C $$$$$$$$$$$$ HYDRO3D.F 3/31/95  --- MODIFY SOURCE/SINK
C       8/17/94     1:30 pm
C
      SUBROUTINE HMCHYD
     > (X,IE,LRN,LRL,NLRL,CMATRX,RLD,RI,RL, H,HP,HW,HT,C,
     . ISTYPT,SOST,IWTYPT,WSST, sk,rk,pk,aa,il,nd,nt,
     1 V,  TH,DTH,AKHC, NPCNV, DCOSB,ISB,NPBB, BFLX,
     2 SOS,ISTYP,LES, WSS,IWTYP,NPW,
     3 QCB,ICTYP,ISC,NPCB, QNB,INTYP,ISN,NPNB,
     4 QVB,IVTYP,ISV,NPVB, RSVAB,INDRS,
c     5 HDB,IDTYP,NPDB, PROP,SPP, DINTS,RHOMU, KPR,KDSK,KDIG,KOUT,
     5 HDB,IDTYP,NPDB, PROP,SPP, DINTS, KPR,KDSK,KDIG,KOUT,
     7 JTM, NNPLR,LMAXDF,GNLR,LNOJCN,CMTRXL,RLDL,
     > IRHO,IBUG,ICHNG,TITLE,NPROB,SQEPS)
C
      IMPLICIT REAL*8(A-H,O-Z)
      CHARACTER*32 SUBHD
      INTEGER*4 GNLR
      CHARACTER TITLE*70
C
      COMMON /SGEOM/ MAXEL,MAXNP,MXADNP,MAXBES,MXTUBS,MAXBNP,MXJBD,
     >               MXKBD,MXNTI,MXDTC
      COMMON /CGEOM/ NNP,NEL,NBNP,NTUBS,NBES,NTI,NDTCHG,ISHAPE
      COMMON /LGEOM/ LTMXNP,LMXNP,LMXBW,MXREGN,NREGN
      COMMON /SCMTL/ MAXMAT,MXSPPM,MXMPPM,NMAT,NMPPM,NSPPM
      COMMON /NOPTN/ ILUMP,IMID,IWET,IOPTIM,KSORP,LGRN,IQUAR
      COMMON /PCG/ GG,IEIGEN
      COMMON /NINTR/ KPR0,KDSK0,NSTRf,NSTRt,KSS,KSSt,IGEOM
      COMMON /CTIM/ DELT,CHNG,DELMAX,TMAX,DELT0,TIME
      COMMON /FINTE/ NCYL,NITER,NPITER,KSP,KGRAV,IPNTS
      COMMON /FREAL/ TOLA,TOLB,W,OME,OMI,GRAV,cnstkr
C
      COMMON /FCS/ MXSEL,MXSPR,MXSDP,NSEL,NSPR,NSDP,KSAI
      COMMON /FCW/ MXWNP,MXWPR,MXWDP,NWNP,NWPR,NWDP,KWAI
C
      COMMON /FCBC/ MXCNP,MXCES,MXCPR,MXCDP,NCNP,NCES,NCPR,NCDP,KCAI
      COMMON /FNBC/ MXNNP,MXNES,MXNPR,MXNDP,NNNP,NNES,NNPR,NNDP,KNAI
      COMMON /FVBC/ MXVES,MXVNP,MXVPR,MXVDP,NVES,NVNP,NVPR,NVDP,KVAI
      COMMON /FDBC/ MXDNP,MXDPR,MXDDP,NDNP,NDPR,NDDP,KDAI
      COMMON /CELS/ MXSELt,MXSPRt,MXSDPt,NSELt,NSPRt,NSDPt,KSAIt
      COMMON /CNPS/ MXWNPt,MXWPRt,MXWDPt,NWNPt,NWPRt,NWDPt,KWAIt
C
      COMMON /FFLOW/ FRATE(10),FLOW(10),TFLOW(10)
C
      COMMON /CHEM/ MXNCC,NCC
C
      DIMENSION X(MAXNP,3),IE(MAXEL,11),LRL(MXKBD,MAXNP),NLRL(MAXNP)
      DIMENSION LRN(MXJBD,MXADNP)
      DIMENSION CMATRX(MXADNP,MXJBD),RLD(MXADNP),RI(MXADNP),RL(MXADNP)
      DIMENSION sk(mxadnp),rk(mxadnp),pk(mxadnp),aa(mxadnp,mxjbd)
      DIMENSION il(mxadnp),nd(mxadnp),nt(maxnp)
      DIMENSION NNPLR(MXREGN),LMAXDF(MXREGN)
      DIMENSION GNLR(LTMXNP,MXREGN),LNOJCN(MXJBD,LMXNP,MXREGN)
      DIMENSION CMTRXL(LMXNP,LMXBW),RLDL(LMXNP)
      DIMENSION H(MAXNP),HP(MAXNP),HW(MAXNP),HT(MAXNP),C(MAXNP,MXNCC)
      DIMENSION V(MAXNP,3)
      DIMENSION TH(MAXEL,8),DTH(MAXEL,8),AKHC(8,MAXEL,7),NPCNV(MAXNP)
C
      DIMENSION DCOSB(3,MAXBES),ISB(6,MAXBES), NPBB(MAXBNP)
      DIMENSION BFLX(MAXBNP,2)
C
C     DIMENSION SOSF(MXSDP,MXSPR),TSOSF(MXSDP,MXSPR)
      DIMENSION ISTYP(MXSEL),LES(MXSEL),SOS(MXSPR)
C     DIMENSION WSSF(MXWDP,MXWPR),TWSSF(MXWDP,MXWPR)
      DIMENSION IWTYP(MXWNP),NPW(MXWNP),WSS(MXWPR)
      DIMENSION ISTYPT(MXSELT,MXNCC),SOST(MXSPRT)
      DIMENSION IWTYPT(MXWNPT,MXNCC),WSST(MXWPRT)
C
C     DIMENSION QCBF(MXCDP,MXCPR),TQCBF(MXCDP,MXCPR)
      DIMENSION ICTYP(MXCES),ISC(5,MXCES), NPCB(MXCNP),QCB(MXCPR)
C
C     DIMENSION QNBF(MXNDP,MXNPR),TQNBF(MXNDP,MXNPR)
      DIMENSION INTYP(MXNES),ISN(5,MXNES), NPNB(MXNNP),QNB(MXNPR)
C
C     DIMENSION QVBF(MXVDP,MXVPR),TQVBF(MXVDP,MXVPR)
      DIMENSION IVTYP(MXVES),ISV(5,MXVES), NPVB(MXVNP),QVB(MXVPR)
      DIMENSION RSVAB(MXVNP,4),INDRS(MXVNP,3)
C
C     DIMENSION HDBF(MXDDP,MXDPR),THDBF(MXDDP,MXDPR)
      DIMENSION IDTYP(MXDNP),NPDB(MXDNP),HDB(MXDPR)
C
      DIMENSION PROP(MAXMAT,MXMPPM),SPP(MXSPPM,MAXMAT,4)
c      DIMENSION RHOMU(MXNCC),DINTS(MXNCC)
      DIMENSION DINTS(MXNCC)
      DIMENSION KPR(MXNTI),KDSK(MXNTI)
C
      DIMENSION SUBHD(3)
C
      DATA SUBHD/'INPUT INITIAL CONDITIONS        ',
     > 'STEADY-STATE INITIAL CONDITIONS ',
     > '                                '/
C
      w1=w
      w2=1.0d0-w
      if(kss.eq.0) then
      w1=1.0d0
      w2=0.0
      end if
c
      KDIAG=0
      IF (KSS.NE.0) GO TO 500
C
C $$$$$$$
C $$$$$$$ PERFORM STEADY-STATE CALCULATION
C $$$$$$$
C
      IF (NVES.EQ.0) GO TO 170
C
      DO NPP=1,NVNP
        NI=NPVB(NPP)
        INDRS(NPP,1)=NPBB(NI)
        INDRS(NPP,2)=0
        INDRS(NPP,3)=0
      ENDDO
C
      NCHG=-1
      CALL BCPREP(IE,X,H,V,DCOSB,ISB,ISV,RSVAB,INDRS,IVTYP,QVB,
     >            NCHG,IQUAR)
C
  170 DO NP=1,NNP
       HP(NP)=H(NP)
      ENDDO
C
      KDIG=KDIG+1
      IF(IBUG.NE.0) WRITE(16,1400) KDIG,TIME,DELT
C
C ------- ITERATION LOOP ON SEEPAGE-RAINFALL BOUNDARY CONDITIONS BEGINS
C
      EPS=0.5D0*TOLA
C
      NNCVN=0
      DO 390 ICY=1,NCYL
C
      DO NP=1,NNP
        IF(NNCVN.NE.0)THEN
          HW(NP)=HP(NP)
          RI(NP)=HW(NP)
        ELSE
          HW(NP)=OME*H(NP)+(1.0D0-OME)*HP(NP)
          RI(NP)=HW(NP)
        ENDIF
      ENDDO
C
      IF(IBUG.NE.0) WRITE(16,1410) ICY
C
C ------- PUT DIRICHLET BOUNDARY VALUES OF THE VARIABLE BOUNDARY
C ------- INTO H, RI, HW, AND RL
C
      IF(NVES.EQ.0) GO TO 250
      DO 230 NPP=1,NVNP
      NI=INDRS(NPP,2)
      IF(NI.EQ.0) GO TO 220
      H(NI)=RSVAB(NPP,2)
      RI(NI)=RSVAB(NPP,2)
      HW(NI)=RSVAB(NPP,2)
      RL(NI)=RSVAB(NPP,2)
      GO TO 230
  220 NI=INDRS(NPP,1)
      IF(NI.EQ.0) GO TO 230
      H(NI)=RSVAB(NPP,1)
      RI(NI)=RSVAB(NPP,1)
      HW(NI)=RSVAB(NPP,1)
      RL(NI)=RSVAB(NPP,1)
  230 CONTINUE
  250 CONTINUE
C
C ******* ITERATION LOOP ON THE NON-LINEAR EQUATION BEGINS
C
      DO 350 IT=1,NITER
C
C ------- EVALUATE SOIL PROPERTIES FOR PREVIOUS ITERATE
C
      CALL SPROP
c     >  (AKHC,TH,DTH,X,HW,C,IE, PROP,DINTS,RHOMU,SPP, IRHO,IQUAR, KSP,
     >  (AKHC,TH,DTH,X,HW,C,IE, PROP,DINTS,SPP, IRHO,IQUAR, KSP,
     >   cnstkr)
C
C ------- ASSEMBLE STEAD-STATE ELEMENT MATRICES QA AND QB INTO THE
C ------- GLOBAL MATRIX C AND CONSTRUCT GLOBAL LOAD VECTOR R FROM
C ------- ELEMENT LOAD VECTOR RQ.
C
      CALL FASEMB(CMATRX,RLD, X,IE,LRN, HP,DTH,AKHC,IRHO,PROP,
c     > ISTYPT,SOST,IWTYPT,WSST,NLRL,LRL,C,DINTS,RHOMU,
     > ISTYPT,SOST,IWTYPT,WSST,NLRL,LRL,C,DINTS,
     > SOS,LES,ISTYP,WSS,NPW,IWTYP, KSS,W,DELT)
C
C ------- APPLY STEADY-STATE BOUNDARY CONDITIONS
C
      CALL FBC(CMATRX,RLD,LRN,NT, IE,X, AKHC, DCOSB,ISB,
     1 QCB,ISC,ICTYP, QNB,ISN,INTYP, RSVAB,INDRS,QVB,ISV,IVTYP,
     2 HDB,IDTYP,NPDB, IQUAR)
C
C ------- SOLVE THE MATRIX EQUATION BY BLOCK OR POINT ITERATION
C
c     WRITE(16,*)'THE FOLLOWING HISTORY IS FOR FLOW PART'
      IF(IPNTS.EQ.0) THEN
        CALL BLKITR(RL,RI, CMTRXL,RLDL, CMATRX,RLD, GNLR,LNOJCN,NNPLR,
     1   LMAXDF, OMI,EPS,NPITER,IBUG,KPR0,1)
      ELSE IF (IPNTS.EQ.1) THEN
        CALL PISS
     I        (MAXNP,MXJBD,MXADNP, NNP,NT,NPITER, OMI,EPS,KPR0,
     I         IBUG, CMATRX,RI,RLD,LRN,1,
     O         RL)
      ELSE IF (IPNTS.EQ.2) THEN
        CALL PPCG
     I  (CMATRX,RLD,LRN,NT, IEIGEN,GG,EPS,SQEPS,IBUG,KPR0,MXADNP,MAXNP,
     M   MXJBD,NNP,1,  SK,RK,RI,PK,
     O   RL)
      ELSE IF (IPNTS.EQ.3) THEN
        CALL ILUCG
     I  (CMATRX,RLD,LRN,ND,NT, EPS,SQEPS,IBUG,KPR0, MXADNP,MAXNP,
     M   MXJBD,NNP,1,  SK,RK,RI,PK,AA,IL,
     O   RL)
      END IF
C
C ------- OBTAIN MAXIMUM RELATIVE DEVIATION FROM PREVIOUS ITERATE
C
      NPP=0
      RD=-1.0D0
      RES=-1.0D0
      DO 320 NP=1,NNP
      RESNP=DABS(RL(NP)-H(NP))
      RES=DMAX1(RES,RESNP)
      IF(H(NP).NE.0.0D0) RD=DMAX1(RD,DABS(RESNP/H(NP)))
      IF(RESNP .LE. TOLA) GO TO 320
      NPP=NPP+1
      NPCNV(NPP)=NP
  320 CONTINUE
C
      NNCVN=NPP
C
C ------- UPDATE PRESSURE WITH CURRENT ITERATE
C
      DO 330 NP=1,NNP
      H(NP)=OME*RL(NP)+(1.0D0-OME)*H(NP)
      RI(NP)=H(NP)
      HW(NP)=H(NP)
  330 CONTINUE
C
C ------- ESCAPE FROM ITERATION LOOP IF THE MAXIMUM RESIDUAL IS
C ------- SUFFICIENTLY SMALL
C
      IF(IBUG.NE.0) WRITE(16,1200) IT,RES,RD,NNCVN
      IF(IT.EQ.1) GO TO 350
      IF(RES.LT.TOLA) GO TO 360
      IF(RES.GT.1.0D38)GOTO 355
C
  350 CONTINUE
  355 CONTINUE
C
C ------- END OF ITERATION LOOP ON THE NON-LINEAR EQUATION
C
      WRITE(16,2000) ICY,IT,NITER,RES,RD,NNCVN
c
      if(ncyl.eq.1) stop
C
C ------- PRINT NONCONVERGENING NODES
C
      IF(IBUG.EQ.0) GO TO 360
      WRITE(16,1450)
      WRITE(16,1460) (NPCNV(NPP),NPP=1,NNCVN)
C
  360 IF(ICHNG.EQ.0) GO TO 380
      IF(NVES.EQ.0) GO TO 380
C
C ------- PRINT RAINFALL-SEEPAGE B. C. CHANGE INFORMATION
C
      WRITE(16,1420) ICY
      DO 370 I=1,NVNP
      NI=NPVB(I)
      NP=NPBB(NI)
      WRITE(16,1430) I,NP,INDRS(I,1),RSVAB(I,1),
     1 INDRS(I,2),RSVAB(I,2),INDRS(I,3),RSVAB(I,3),RSVAB(I,4)
  370 CONTINUE
C
C ------- CALCULATE DARCY'S VELOCITY
C
  380 CONTINUE
      CALL SPROP
c     >  (AKHC,TH,DTH,X,H,C,IE, PROP,DINTS,RHOMU,SPP, IRHO,IQUAR, KSP,
     >  (AKHC,TH,DTH,X,H,C,IE, PROP,DINTS,SPP, IRHO,IQUAR, KSP,
     >   cnstkr)
C
      CALL VELT(V, CMATRX, X,IE,H,HT,AKHC,IQUAR)
C
      IF(NVES .EQ. 0) GO TO 440
C
C ------- PREPARE BOUNDARY CONDITIONS ON THE VARIABLE-TYPE BOUNDARY FOR
C ------- NEXT CYCLE COMPUTATIONS.
C
      CALL BCPREP(IE,X,H,V,DCOSB,ISB,ISV,RSVAB,INDRS,IVTYP,QVB,
     >            NCHG,IQUAR)
C
      IF(NCHG.EQ.0) GO TO 440
  390 CONTINUE
C
C ------- END OF ITERATION LOOP ON SEEPAGE-RAINFALL BOUNDARY CONDITIONS
C
      WRITE(16,3000) ICY,IT,NCYL,NITER,RES,RD,NNCVN
C
  440 IF(NNCVN.EQ.0) GO TO 445
      WRITE(16,3000) ICY,IT,NCYL,NITER,RES,RD,NNCVN
C
C ------- COMPUTE FLUXES THROUGH ALL TYPES OF BOUNDARIES.
C
  445 CONTINUE
C
      RETURN
C
C $$$$$$$
C $$$$$$$ PERFORM TRANSIENT-STATE CALCULATION
C $$$$$$$
C
  500 CONTINUE
C
C ------- PREPARE TRANSIENT BOUNDARY CONDITIONS AND SOURCE FOR THE STEP
C
c     IF(NSEL.NE.0) CALL ESSFCT(SOS,TSOSF,SOSF,TIME,MXSPR,MXSDP,
c    1 NSPR,NSDP,KSAI)
c     IF(NWNP.NE.0) CALL WSSFCT(WSS,TWSSF,WSSF,TIME,MXWPR,MXWDP,
c    1 NWPR,NWDP,KWAI)
C
c     IF(NCES.NE.0) CALL CBVFCT(QCB,TQCBF,QCBF,TIME,
c    1 MXCPR,MXCDP,NCPR,NCDP,KCAI)
c     IF(NNES.NE.0) CALL NBVFCT(QNB,TQNBF,QNBF,TIME,
c    1  MXNPR,MXNDP,NNPR,NNDP,KNAI)
c     IF(NVES.NE.0) CALL VBVFCT(QVB,TQVBF,QVBF,TIME,
c    1 MXVPR,MXVDP,NVPR,NVDP,KVAI)
c     IF(NDNP.NE.0) CALL DBVFCT(HDB,THDBF,HDBF,TIME,
c    1 MXDPR,MXDDP,NDPR,NDDP,KDAI)
C
      IF(NVES.EQ.0) GO TO 560
      NCHG=-1
      CALL BCPREP(IE,X,H,V,DCOSB,ISB,ISV,RSVAB,INDRS,IVTYP,QVB,
     >            NCHG,IQUAR)
C
  560 DO 570 NP=1,NNP
      RL(NP)=H(NP)
      HP(NP)=H(NP)
  570 CONTINUE
C
      KDIG=KDIG+1
      EPS = 0.5D0*TOLB
      KFLOW = 1
      IF(IBUG.NE.0 .AND. KPR(JTM).NE.0) WRITE(16,1400) KDIG,TIME,DELT
C
C ------- BEGIN ITERATION LOOP ON SEEPAGE-RAINFALL BOUNDARY CONDITIONS
C
      NNCVN=0
c
      DO 690 ICY=1,NCYL
      IF(IBUG.NE.0 .AND. KPR(JTM).NE.0) WRITE(16,1410) ICY
C
      DO 580 NP=1,NNP
      IF(NNCVN.NE.0)THEN
        H(NP)=HP(NP)
        RI(NP)=HP(NP)
        HW(NP)=HP(NP)
      ELSE
        H(NP)=OME*RL(NP)+(1.0D0-OME)*H(NP)
        RI(NP)=H(NP)
        HW(NP)=W1*(OME*H(NP)+(1.0D0-OME)*HP(NP))+W2*HP(NP)
      ENDIF
  580 CONTINUE
C
C ------- PUT DIRICHLET BOUNDARY VALUES OF THE VARIABLE BOUNDARY
C ------- INTO H, RI, HW, AND RL
C
      IF(NVES.EQ.0) GO TO 595
      DO 590 NPP=1,NVNP
      NI=INDRS(NPP,2)
      IF(NI.EQ.0) GO TO 585
      H(NI)=RSVAB(NPP,2)
      RI(NI)=RSVAB(NPP,2)
      HW(NI)=RSVAB(NPP,2)
      RL(NI)=RSVAB(NPP,2)
      GO TO 590
  585 NI=INDRS(NPP,1)
      IF(NI.EQ.0) GO TO 590
      H(NI)=RSVAB(NPP,1)
      RI(NI)=RSVAB(NPP,1)
      HW(NI)=RSVAB(NPP,1)
      RL(NI)=RSVAB(NPP,1)
  590 CONTINUE
  595 CONTINUE
C
C ******* BEGIN ITERATION LOOP ON THE NON-LINEAR EQUATION
C
      DO 650 IT=1,NITER
C
C ------- EVALUATE SOIL PROPERTIES FOR PREVIOUS ITERATE
C
      CALL SPROP
c     >  (AKHC,TH,DTH,X,HW,C,IE, PROP,DINTS,RHOMU,SPP, IRHO,IQUAR, KSP,
     >  (AKHC,TH,DTH,X,HW,C,IE, PROP,DINTS,SPP, IRHO,IQUAR, KSP,
     >   cnstkr)
C
C ------- ASSEMBLE ELEMENT MATRICES QA AND QB INTO THE GLOBAL MATRIX C
C ------- AND CONSTRUCT THE GLOBAL LOAD VECTOR R FROM ELEMENT LOAD
C ------- VECTOR RQ.
C
      CALL FASEMB(CMATRX,RLD, X,IE,LRN, HP,DTH,AKHC,IRHO,PROP,
c     > ISTYPT,SOST,IWTYPT,WSST,NLRL,LRL,C,DINTS,RHOMU,
     > ISTYPT,SOST,IWTYPT,WSST,NLRL,LRL,C,DINTS,
     > SOS,LES,ISTYP,WSS,NPW,IWTYP, KSS,W,DELT)
C
C ------- APPLY BOUNDARY CONDITIONS TO MODIFY THE GLOBAL MATRIX C AND
C ------- THE LOAD VECTOR R.
C
      CALL FBC(CMATRX,RLD,LRN,NT, IE,X, AKHC, DCOSB,ISB,
     1 QCB,ISC,ICTYP, QNB,ISN,INTYP, RSVAB,INDRS,QVB,ISV,IVTYP,
     2 HDB,IDTYP,NPDB,IQUAR)
C
C ------- SOLVE THE MATRIX EQUAITON BY BLOCK OR POINT ITERATION
C
c     WRITE(16,*)'THE FOLLOWING HISTORY IS FOR FLOW PART'
      IF(IPNTS.EQ.0) THEN
        CALL BLKITR(RL,RI, CMTRXL,RLDL, CMATRX,RLD, GNLR,LNOJCN,NNPLR,
     1   LMAXDF, OMI,EPS,NPITER,IBUG,KPR(JTM),1)
      ELSE IF (IPNTS.EQ.1) THEN
        CALL PISS
     I        (MAXNP,MXJBD,MXADNP, NNP,NT,NPITER, OMI,EPS,
     I         KPR(JTM),IBUG, CMATRX,RI,RLD,LRN,1,
     O         RL)
      ELSE IF (IPNTS.EQ.2) THEN
        CALL PPCG
     I  (CMATRX,RLD,LRN,NT, IEIGEN,GG,EPS,SQEPS,IBUG,KPR(JTM),MXADNP,
     M   MAXNP,MXJBD,NNP,1,  SK,RK,RI,PK,
     O   RL)
      ELSE IF (IPNTS.EQ.3) THEN
        CALL ILUCG
     I  (CMATRX,RLD,LRN,ND,NT, EPS,SQEPS,IBUG,KPR(JTM), MXADNP,MAXNP,
     M   MXJBD,NNP,1,  SK,RK,RI,PK,AA,IL,
     O   RL)
      END IF
C
C ------- OBTAIN MAXIMUM RELATIVE DEVIATION FROM PREVIOUS ITERATE
C
      NPP=0
      RD=-1.0D0
      RES=-1.0D0
      DO 620 NP=1,NNP
      RESNP=DABS(RL(NP)-H(NP))
      RES=DMAX1(RES,RESNP)
      IF(H(NP) .NE. 0.0D0) RD=DMAX1(RD,DABS(RESNP/H(NP)))
      IF(RESNP .LE. TOLB) GO TO 620
      NPP=NPP+1
      NPCNV(NPP)=NP
  620 CONTINUE
C
      NNCVN=NPP
C
C ------- UPDATE PRESSURE WITH CURRENT ITERATE
C
      DO 630 NP=1,NNP
      H(NP)=OME*RL(NP)+(1.0D0-OME)*H(NP)
      RI(NP)=H(NP)
      HW(NP)=W1*H(NP)+W2*HP(NP)
  630 CONTINUE
C
C ------- ESCAPE FROM ITERATION LOOP IF THE MAXIMUM RESIDUAL IS
C ------- SUFFICIENTLY SMALL.
C
      IF(IBUG.NE.0 .AND. KPR(JTM).NE.0) WRITE(16,1200) IT,RES,RD,NNCVN
      IF(IT.EQ.1 .AND. JTM.EQ.1) GO TO 650
      IF(RES.LT.TOLB) GO TO 660
      IF(RES.GT.1.0D38)GOTO 655
C
  650 CONTINUE
  655 CONTINUE
C
C ------- END THE ITERATION LOOP ON THE NON-LINEAR EQUATION
C
      WRITE(16,4000) JTM,ICY,IT,NITER,RES,RD,NNCVN
c
      if(ncyl.eq.1) stop
C
      IF(IBUG.EQ.0 .OR. KPR(JTM).EQ.0) GO TO 660
C
C ------- PRINT NONCONVERGING NODES
C
      WRITE(16,1450)
      WRITE(16,1460) (NPCNV(NPP),NPP=1,NNCVN)
C
  660 IF(ICHNG.EQ.0 .OR. KPR(JTM).EQ.0) GO TO 680
      IF(NVES.EQ.0) GO TO 680
C
C ------- PRINT RAINFALL-SEEPAGE BOUNDARY CONDITION CHANGE INFORMATION
C
      WRITE(16,1420) ICY
      DO 670 I=1,NVNP
      NI=NPVB(I)
      NP=NPBB(NI)
      WRITE(16,1430) I,NP,INDRS(I,1),RSVAB(I,1),
     1 INDRS(I,2),RSVAB(I,2),INDRS(I,3),RSVAB(I,3),RSVAB(I,4)
  670 CONTINUE
C
C ------- CALCULATE DARCY'S VELOCITY
C
  680 CONTINUE
      CALL SPROP
c     >  (AKHC,TH,DTH,X,H,C,IE, PROP,DINTS,RHOMU,SPP, IRHO,IQUAR, KSP,
     >  (AKHC,TH,DTH,X,H,C,IE, PROP,DINTS,SPP, IRHO,IQUAR, KSP,
     >   cnstkr)
C
      CALL VELT(V, CMATRX, X,IE,H,HT,AKHC,IQUAR)
C
      IF(NVES.EQ.0) GO TO 710
C
      CALL BCPREP(IE,X,H,V,DCOSB,ISB,ISV,RSVAB,INDRS,IVTYP,QVB,
     >            NCHG,IQUAR)
C
      IF(NCHG.EQ.0) GO TO 710
C
  690 CONTINUE
C
C ------- END ITERATION LOOP ON SEEPAGE-RAINFALL BOUNDARY CONDITIONS
C
      WRITE(16,5000) JTM,ICY,IT,NCYL,NITER,RES,RD,NNCVN
  710 IF(NNCVN.EQ.0) GO TO 715
      WRITE(16,5000) JTM,ICY,IT,NCYL,NITER,RES,RD,NNCVN
C
  715 IF(IMID.EQ.0) GO TO 740
C
      DO 720 NP=1,NNP
      H(NP)=2.0D0*H(NP)-HP(NP)
  720 CONTINUE
      DO 730 I=1,NDNP
C     NI=NPDB(I)
      NP=NPDB(I)
      ITYP=IDTYP(I)
      H(NP)=HDB(ITYP)-X(NP,3)*  dble(KGRAV)
  730 CONTINUE
C
C ------- COMPUTE FLUXES THROUGH ALL TYPES OF BOUNDARIES
C
  740 CALL FSFLOW(X,IE,NLRL,LRL,H,HP,V,TH,DTH,AKHC(1,1,7),PROP(1,7),
     > ISTYPT,SOST,IWTYPT,WSST,C,
     1 BFLX,DCOSB,ISB,NPBB, LES,SOS,ISTYP,WSS,IWTYP,NPW,
c     2 NPVB,NPDB,NPCB,NPNB, DINTS,RHOMU, DELT, KFLOW,IQUAR,IRHO)
     2 NPVB,NPDB,NPCB,NPNB, DINTS, DELT, KFLOW,IQUAR,IRHO)
C
C ------- PRINT VARIABLES AT EACH TIME STEP
C
      CALL FPRINT(V,H,HT,TH, BFLX, NPVB,RSVAB,INDRS,SUBHD(3),
     1 TIME,DELT, KPR(JTM),KOUT,KDIAG,JTM)
C
      IF(KDSK(JTM).EQ.1) CALL FSTORE(X,IE, H,HT,TH,V,INDRS,
     1 DCOSB,ISB,NPBB, NNPLR,GNLR, TITLE,JTM, TIME,NPROB,AKHC(1,1,7))    3/15/95
C
      RETURN
C
 1200 FORMAT(5X,I10,3X,E12.4,3X,E12.4,15X,I10)
 1400 FORMAT('1','****************************************************',
     2 '*****'///' DIAGNOSTIC TABLE',I4,'.. AT TIME =',1PD12.4,
     3 ', (DELT =',1PD12.4,')')
 1410 FORMAT(//' TABLE OF ITERATIVE PARAMETERS FOR',I3,'-TH CYCLE'//6X,
     1 'ITERATION',7X,'RESIDUAL',6X,'DEVIATION',6X,
     2 'NO. NON-CONV. NODES')
 1420 FORMAT(//' TABLE OF RAINFALL/EVAPORATION-SEEPAGE B. C. USED FOR',
     1 I3,'-TH CYCLE'//5X,' I NPVB NPCON     HCON    NPMIN     HMIN',
     2 '    NPFLX       FLX       DCYFLX'/5X,
     3 ' - ---- -----     ----    -----     ----',
     4 '    -----       ---       ------')
 1430 FORMAT(' ',I6,I5,I6,1PD12.4,I6,1PD12.4,I6,1PD12.4,1PD12.4)
 1450 FORMAT(//' TABLE OF NON-CONVERGING NODES')
 1460 FORMAT(/(5X,15I5))
 2000 FORMAT('0','WARING: NON-CONVERGENCE OCCUR DURING STEADY STATE SOLU
     1TION AT',I3,' -TH CYCLE'/1H ,'IT = ',I3,'  .GT.  MAXIT = ',I3,
     2 ',  RES =',D12.5,',  RD =',D12.4/'   NNCVN =',I4)
 3000 FORMAT('0','ABSOLUTELY WARNING: STEADY STATE SOLUTION IS NG'/' ',
     > 'ICY = ',I3,'  IT = ',I3,'  MAXCY = ',I3,'  MAXIT = ',I3/
     > '   RES =',D12.4,',  RD =',D12.4,',  NNCVN =',I4)
 4000 FORMAT('0','WARNING: NON-CONVERGENCE OCCUR AT',I5,' -TH TIME STEP'
     >,I3,' -TH CYCLE'/1H ,'IT = ',I3,'  .GT.  MAXIT = ',I3,2D12.4,I5)
 5000 FORMAT('0','ABSOLUTELY WARNING: TRANSIENT SOLUTION IS NG AT ',I5,
     > ' -TH TIME STEP'/1H ,'ICY = ',I3,'  IT = ',I3,'  MAXCY = ',I3,
     > '  MAXIT = ',I3,',  RES =',D12.4,',  RD =',D12.4/'   NNCVN =',I4)
C
      END
C
C
C
      SUBROUTINE BCPREP(IE,X,  H,V, DCOSB,ISB, ISV,
     > RSVAB,INDRS, IVTYP,QVB, NCHG,IQUAR)
C
C********1*********2*********3*********4*********5*********6*********7**
C
C ------- TO DETERMINE WHETHER THE DIRICHLET B. C. WITH PONDING DEPTH,
C ------- OR THE DIRICHELT B. C. WITH MINIMUM PRESSURE HEAD, OR THE FLUX
C ------- B. C. WITH PRESCRIBED FLUX TO BE APPLIED ON THE VARIABLE
C ------- BOUNDARIES, NORMALLY THE AIR-MEDIA INTERFACE.
C
C********1*********2*********3*********4*********5*********6*********7**
C
C ------- INPUT: IE(NEL,9), X(NNP,3), H(NNP), V(NNP,3),
C -------        DCOSB(3,NBES), ISB(6,NBES),
C -------        ISV(5,NVES), IVTYP(NVES), QVB(NVPR),
C -------        RSVAB(NVNP,1), RSVAB(NVNP,2), NCHG.
C
C ------- OUTPUT: INDRS(NVNP,3), RSVAB((NVNP,3),RSVAB(NVNP,4), NCHG.
C
C********1*********2*********3*********4*********5*********6*********7**
C
      IMPLICIT REAL*8 (A-H,O-Z)
C
      COMMON /SGEOM/ MAXEL,MAXNP,MXADNP,MAXBES,MXTUBS,MAXBNP,MXJBD,
     >               MXKBD,MXNTI,MXDTC
      COMMON /CGEOM/ NNP,NEL,NBNP,NTUBS,NBES,NTI,NDTCHG,ISHAPE
      COMMON /FVBC/ MXVES,MXVNP,MXVPR,MXVDP,NVES,NVNP,NVPR,NVDP,KVAI
C
      DIMENSION IE(MAXEL,11),X(MAXNP,3)
      DIMENSION H(MAXNP),V(MAXNP,3)
C
      DIMENSION DCOSB(3,MAXBES),ISB(6,MAXBES),ISV(5,MXVES)
      DIMENSION RSVAB(MXVNP,4),INDRS(MXVNP,3)
      DIMENSION QVB(MXVPR),IVTYP(MXVES)
C
      DIMENSION R1Q(4),R2Q(4),XQ(4),YQ(4),ZQ(4),F1Q(4),F2Q(4),RHOKG(4)
C
      DIMENSION KGB(4,6,3)
C
      DATA KGB/1,4,8,5, 1,2,6,5, 2,3,7,6, 4,3,7,8, 1,2,3,4, 5,6,7,8,
     >         1,3,6,4, 1,4,5,2, 2,5,6,3, 1,2,3,0, 4,5,6,0, 0,0,0,0,
     >         4,3,2,0, 4,1,3,0, 4,2,1,0, 1,2,3,0, 0,0,0,0, 0,0,0,0/
C
C ------- DETERMINE NORMAL RAINFALLS FLX(I) AND DARCY FLUXES DCYFLX(I)
C ------- FOR EACH NODAL POINT ON THE VARIABLE ELEMENT-SIDE.
C
      DO 210 NP=1,NVNP
         RSVAB(NP,3)=0.
         RSVAB(NP,4)=0.
  210 CONTINUE
C
      DO 290 MP=1,NVES
      ITYP=IVTYP(MP)
      RFMP=QVB(ITYP)
C
      MPB=ISV(5,MP)
      LS=ISB(5,MPB)
      M=ISB(6,MPB)
      IF(IE(M,5).EQ.0)THEN
        IK=3
      ELSEIF(IE(M,7).EQ.0)THEN
        IK=2
      ELSE
        IK=1
      ENDIF
C
      PROJ=DCOSB(3,MPB)
      RFMPN=-RFMP*PROJ
C
      NODE=4
      DO 230 IQ=1,4
      I=KGB(IQ,LS,IK)
      IF(I.EQ.0 .AND. IQ.EQ.4)THEN
        NODE=3
        GOTO 230
      ENDIF
      NI=IE(M,I)
      XQ(IQ)=X(NI,1)
      YQ(IQ)=X(NI,2)
      ZQ(IQ)=X(NI,3)
      F1Q(IQ)=RFMPN
      F2Q(IQ)=V(NI,1)*DCOSB(1,MPB)+DCOSB(2,MPB)*V(NI,2)+DCOSB(3,MPB)*
     1        V(NI,3)
      RHOKG(IQ)=1.0D0
  230 CONTINUE
C
C -------- COMPUTE SURFACE INTEGRAL OF N(IQ).F
C
      CALL Q34S(R1Q,R2Q,XQ,YQ,ZQ,F1Q,F2Q,RHOKG,NODE,IQUAR)
C
      DO 270 IQ=1,NODE
      I=ISV(IQ,MP)
      RSVAB(I,3)=RSVAB(I,3)+R1Q(IQ)
      RSVAB(I,4)=RSVAB(I,4)+R2Q(IQ)
  270 CONTINUE
C
  290    CONTINUE
C
C ------- CHANGE TO FLUX OR HEAD CONDITIONS, AS NECESSARY, AND SO
C ------- INDICATE IN THE ARRAYS NPFLX(NPP) AND NPCON(NPP).
C
      IF (NCHG.NE.(-1)) GO TO 300
      NCHG=0
      RETURN
C
  300 NCHG=0
C
      DO 390 NPP=1,NVNP
C
      DCYNNP=RSVAB(NPP,4)
      FLXNNP=RSVAB(NPP,3)
      HCONNP=RSVAB(NPP,1)
      HMINNP=RSVAB(NPP,2)
C
      IF(FLXNNP.GT.0.0) GO TO 350
C
C **** RAINFALL(INFILTRATION)-SEEPAGE CONDITIONS PREVAIL DURING RAINFALL
C
C
C ------- CHECK IF THE CHANGE FROM RAINFALL-FLUX (NEUMANN) CONDITION TO
C ------- PONDING (DIRICHLET) CONDITION IS NECESSARY?
C
         NP=INDRS(NPP,3)
         IF (NP.EQ.0) GO TO 310
      IF(HCONNP.GE.H(NP)) GO TO 390
         INDRS(NPP,1)=INDRS(NPP,3)
         INDRS(NPP,3)=0
         NCHG=NCHG+1
         GO TO 390
C
C ------- CHECK IF THE CHANGE FROM PONDING (DIRICHLET) CONDITION TO
C ------- RAINFALL-FLUX (NEUMANN) CONDITION IS NECESSARY?
C
  310 CONTINUE
      NP=INDRS(NPP,1)
      IF(NP.EQ.0) GO TO 320
      IF(FLXNNP.LE.DCYNNP) GO TO 390
         INDRS(NPP,3)=INDRS(NPP,1)
         INDRS(NPP,1)=0
         NCHG=NCHG+1
      GO TO 390
C
C ------- CHANGE MINIMUM PRESSURE CONDITION TO RAINFALL-FLUX CONDITION
C ------- SINCE A MINIMUM PRESSURE CONDITION IS NOT LIKELY TO BE
C ------- DURING RAINFALL PERIOD
C
  320 CONTINUE
      NP=INDRS(NPP,2)
      IF(NP.EQ.0) GO TO 390
      INDRS(NPP,3)=INDRS(NPP,2)
      INDRS(NPP,2)=0
      NCHG=NCHG+1
      GO TO 390
C
C **** EVAPORATION-SEEPAGE CONDITIONS PREVAIL DURING NON-RAINFALL PERIOD
C
C
C ------- CHECK IF THE CHANGE FROM EVAPORATION-FLUX CONDITION TO
C ------- MINIMUM PRESSURE HEAD CONDITION IS NECESSARY?
C
  350 CONTINUE
      NP=INDRS(NPP,3)
      IF(NP.EQ.0) GO TO 360
      IF(HMINNP.LE.H(NP)) GO TO 390
      INDRS(NPP,2)=INDRS(NPP,3)
      INDRS(NPP,3)=0
      NCHG=NCHG+1
      GO TO 390
C
C ------- CHECK IF THE CHANGE FROM PONDING CONDITION TO EVAPORATION-FLUX
C ------- CONDITION IS NECESSARY?
C
  360 CONTINUE
      NP=INDRS(NPP,1)
      IF(NP.EQ.0) GO TO 370
      IF(DCYNNP.GE.0.0) GO TO 390
      INDRS(NPP,3)=INDRS(NPP,1)
      INDRS(NPP,1)=0
      NCHG=NCHG+1
      GO TO 390
C
C ------- CHECK IF THE CHANGE FROM MINIMUM PRESSURE HEAD CONDITION TO
C ------- EVAPORATION-FLUX CONDITION IS NECESSARY?
C
  370 CONTINUE
      NP=INDRS(NPP,2)
      IF(NP.EQ.0) GO TO 390
C     IF(DCYNNP.LT.0.0) GO TO 380
      IF(DCYNNP.LT.FLXNNP) GO TO 390
      INDRS(NPP,3)=INDRS(NPP,2)
      INDRS(NPP,2)=0
      NCHG=NCHG+1
  390 CONTINUE
C
      RETURN
      END
C
C
C
      SUBROUTINE FASEMB(CMATRX,RLD, X,IE,LRN, HP,DTH,AKHC,IRHO,PROP,
c     > ISTYPT,SOST,IWTYPT,WSST,NLRL,LRL,C,DINTS,RHOMU,
     > ISTYPT,SOST,IWTYPT,WSST,NLRL,LRL,C,DINTS,
     > SOS,LES,ISTYP,WSS,NPW,IWTYP, KSS,W,DELT)
C
C********1*********2*********3*********4*********5*********6*********7**
C
C ------- TO ASSEMBLE THE GLOBAL COEFFICIENT MATRIX AND GLOBAL LOAD
C ------- VECTOR IN COMPRESSED FORM.
C
C********1*********2*********3*********4*********5*********6*********7**
C
C ------- INPUT: X(NNP,3), IE(NEL,9), LRN(MXJBD,NNP),
C --------       HP(NNP), DTH(NEL,8), AKHC(8,NEL,7),
C -------        SOS(NSPR), LES(NSEL), ISTYP(NSEL),
C -------        WSS(NWPR), NPW(NWNP), IWTYP(NWNP), KSS, W, DELT.
C
C ------- OUTPUT: CMATRX(NNP,MXJBD), RLD(NNP).
C
C********1*********2*********3*********4*********5*********6*********7**
C
      IMPLICIT REAL*8(A-H,O-Z)
C
      COMMON /SGEOM/ MAXEL,MAXNP,MXADNP,MAXBES,MXTUBS,MAXBNP,MXJBD,
     >               MXKBD,MXNTI,MXDTC
      COMMON /CGEOM/ NNP,NEL,NBNP,NTUBS,NBES,NTI,NDTCHG,ISHAPE
      COMMON /FINTE/ NCYLf,NITERf,NPITERf,KSP,KGRAV,IPNTS
      COMMON /SCMTL/ MAXMAT,MXSPPM,MXMPPM,NMAT,NMPPM,NSPPM
      COMMON /NOPTN/ ILUMP,IMID,IWET,IOPTIM,KSORP,LGRN,IQUAR
C
      COMMON /FCS/ MXSEL,MXSPR,MXSDP,NSEL,NSPR,NSDP,KSAI
      COMMON /FCW/ MXWNP,MXWPR,MXWDP,NWNP,NWPR,NWDP,KWAI
      COMMON /CELS/ MXSELt,MXSPRt,MXSDPt,NSELt,NSPRt,NSDPt,KSAIt
      COMMON /CNPS/ MXWNPt,MXWPRt,MXWDPt,NWNPt,NWPRt,NWDPt,KWAIt
C
      COMMON /CHEM/ MXNCC,NCC
C
      DIMENSION CMATRX(MXADNP,MXJBD),RLD(MXADNP),PROP(MAXMAT,MXMPPM)
      DIMENSION LRL(MXKBD,MAXNP),NLRL(MAXNP),C(MAXNP,MXNCC)
      DIMENSION X(MAXNP,3),IE(MAXEL,11),LRN(MXJBD,MXADNP)
      DIMENSION HP(MAXNP),DTH(MAXEL,8),AKHC(8,MAXEL,7)
      DIMENSION SOS(MXSPR), LES(MXSEL),ISTYP(MXSEL)
      DIMENSION WSS(MXWPR), NPW(MXWNP),IWTYP(MXWNP)
      DIMENSION ISTYPT(MXSELT,MXNCC),SOST(MXSPRT)
      DIMENSION IWTYPT(MXWNPT,MXNCC),WSST(MXWPRT)
c      DIMENSION DINTS(MXNCC),RHOMU(MXNCC)
      DIMENSION DINTS(MXNCC)
C
      DIMENSION QA(8,8),QB(8,8),RQ(8)
      DIMENSION AKXQ(8),AKYQ(8),AKZQ(8),AKXYQ(8),AKXZQ(8),AKYZQ(8)
      DIMENSION DTHG(8),RHOKG(8)
      DIMENSION XQ(8),YQ(8),ZQ(8),IEM(8)
C
      AGRAV=  dble(KGRAV)
C
      DELTI=1.0D0/DELT
      W1=W
      W2=1.0D0-W
      IF (KSS.EQ.0) THEN
        DELTI=0.
        W1=1.0D0
        W2=0.
      ELSEIF(IMID.EQ.1)THEN
        W1=1.0D0
        W2=0.0D0
      ENDIF
C
C ------- INITIATE MATRICES C(NP,IB) AND R(NP)
C
  100 DO 150 NP=1,NNP
      RLD(NP)=0.0
      DO 150 I=1,MXJBD
      CMATRX(NP,I)=0.0
  150 CONTINUE
C
C ------- START TO ASSEMBLE OVER ALL ELEMENTS
C
      DO 490 M=1,NEL
C
        CALL ELENOD
     I      (IE(M,5),IE(M,7),
     O       NODE,IQ,IQ)
C
C ------- COMPUTE MATRICES QA(IQ,JQ), QB(IQ,JQ), AND RQ(IQ) FOR EACH M
C
        DO 210 IQ=1,NODE
          NP=IE(M,IQ)
          IEM(IQ)=NP
          XQ(IQ)=X(NP,1)
          YQ(IQ)=X(NP,2)
          ZQ(IQ)=X(NP,3)
  210   CONTINUE
C
        DO 220 KG=1,NODE
          AKXQ(KG)=AKHC(KG,M,1)
          AKYQ(KG)=AKHC(KG,M,2)
          AKZQ(KG)=AKHC(KG,M,3)
          AKXYQ(KG)=AKHC(KG,M,4)
          AKXZQ(KG)=AKHC(KG,M,5)
          AKYZQ(KG)=AKHC(KG,M,6)
          RHOKG(KG)=AKHC(KG,M,7)
          DTHG(KG)=DTH(M,KG)
  220   CONTINUE
C
        MTYP=IE(M,9)
        RHOW=PROP(MTYP,7)
        SOSM=0.0
        IF(NSEL.EQ.0) GO TO 260
        DO 240 I=1,NSEL
          MP=LES(I)
          IF(MP.NE.M) GO TO 240
          ITYP=ISTYP(I)
          SOSM=SOS(ITYP)
          IF(IRHO.EQ.1 .AND. SOSM.GT.0.0D0)THEN
            DO K=1,NCC
              ITYP=ISTYPT(I,K)
              RQ(K)=SOST(ITYP)
            ENDDO
c            CALL RHOFUN(RHOSTR,AMU,RHOW,DINTS,RQ,RHOMU)
            CALL RHOFUN(RHOSTR,AMU,RHOW,DINTS,RQ)
            SOSM=SOSM*RHOSTR
          ENDIF
          GO TO 260
  240   CONTINUE
  260   CONTINUE
C
        CALL FQ468(QA,QB,RQ, DTHG,AKXQ,AKYQ,AKZQ,AKXYQ,AKXZQ,AKYZQ,
     >           RHOKG,XQ,YQ,ZQ, SOSM,AGRAV, NODE)
C
C ------- ASSEMBLE QA(IQ,JQ) AND QB(IQ,JQ) INTO THE GLOBAL MATRIX
C ------- C(NP,IB) = B + A/DELT AND FORM THE GLOBAL LOAD VECTOR R(NP).
C
        DO 390 IQ=1,NODE
          NI=IEM(IQ)
          RLD(NI)=RLD(NI)+RQ(IQ)
          DO 340 JQ=1,NODE
            NJ=IEM(JQ)
            IF(IMID.NE.0) GO TO 305
C
C ------- FOR THE CASE OF NON MID-DIFFERNCE
C
            QA(IQ,JQ)=QA(IQ,JQ)*DELTI
            GO TO 310
C
C ------- FOR THE CASE OF MID-DIFFERENCE: BE SURE W IS READ AS 1.0
C
  305       QA(IQ,JQ)=2.0D0*QA(IQ,JQ)*DELTI
C
C ------- MERGE NON MID-DIFFERENCE AND MID-DIFFERENCE CASES
C
  310       CONTINUE
            RLD(NI)=RLD(NI)+(QA(IQ,JQ)-W2*QB(IQ,JQ))*HP(NJ)
            DO 325 I=1,MXJBD
              LNODE=LRN(I,NI)
              IF(NJ.EQ.LNODE) GO TO 330
  325       CONTINUE
C
            WRITE(16,1000) NI,M,JQ
            STOP
C
  330       CMATRX(NI,I)=CMATRX(NI,I)+QA(IQ,JQ)+W1*QB(IQ,JQ)
C
  340     CONTINUE
  390   CONTINUE
  490 CONTINUE
C
C ------- INCORPORATE WELL SOURCE/SINK
C
  700 IF(NWNP.EQ.0) GO TO 910
      DO 790 I=1,NWNP
        NI=NPW(I)
        ITYP=IWTYP(I)
        WSSK=WSS(ITYP)
C
        IF(IRHO.EQ.1)THEN
          RHO=0.0D0
          VOLT=0.0D0
          DO J=1,NLRL(NI)
            MP=LRL(J,NI)
            MTYP=IE(MP,9)
            CALL VOLUME
     I          (MAXNP,MAXEL,X(1,1),X(1,2),X(1,3),IE,MP,
     O           VOL)
            RHO=RHO+PROP(MTYP,7)*VOL
            VOLT=VOLT+VOL
          ENDDO
          RHOW=RHO/VOLT
C
          IF(WSSK.GT.0.0D0)THEN
            DO K=1,NCC
              ITYP=IWTYPT(I,K)
              RHOKG(K)=WSST(ITYP)
            ENDDO
          ELSEIF(WSSK.LT.0.0D0)THEN
            DO K=1,NCC
              RHOKG(K)=C(NI,K)
            ENDDO
          ENDIF
c          CALL RHOFUN(RHO,AMU,RHOW,DINTS,RHOKG,RHOMU)
          CALL RHOFUN(RHO,AMU,RHOW,DINTS,RHOKG)
C
          WSSK=WSSK*RHO
        ENDIF
C
        RLD(NI)=RLD(NI)+WSSK
  790 CONTINUE
C
  910 CONTINUE
C
 1000 FORMAT('1'/5X,'*** WARNING: NONE OF THE LOWER-LEFT NODE IN EQUATIO
     1N',I3,/5X,'***  IS CORRESPONDING TO ',I5,'-TH ELEMENT-S',I2,
     2'-TH NODE; STOP  ****')
C
      RETURN
      END
C
C
C
      SUBROUTINE FQ468(QA,QB,RQ, DTHG,AKXQ,AKYQ,AKZQ,AKXYQ,AKXZQ,AKYZQ,
     > RHOKG,XQ,YQ,ZQ,SOSM,AGRAV,NODE)
C
C********1*********2*********3*********4*********5*********6*********7**
C
C ------- TO COMPUTE ELEMENT MATRICES AND ELEMENT LOAD VECTORS.
C
C********1*********2*********3*********4*********5*********6*********7**
C
C ------- INPUT: XQ(8), YQ(8), ZQ(8), DTHG(8), AKXQ(8), AKYQ(8),
C -------        AKZQ(8), AKXYQ(8), AKXZQ(8), AKYZQ(8), SOSM, AGRAV.
C
C ------- OUTPUT: QA(8,8), QB(8,8), RQ(8).
C
C********1*********2*********3*********4*********5*********6*********7**
C
      IMPLICIT REAL*8 (A-H,O-Z)
      REAL*8 N(8),L1(3),L2(3),L3(3),LL1(4),LL2(4),LL3(4),LL4(4)
C
      COMMON /NOPTN/ ILUMP,IMID,IWET,IOPTIM,KSORP,LGRN,IQUAR
C
      DIMENSION QA(8,8),QB(8,8),RQ(8),DTHG(8),RHOKG(8)
      DIMENSION AKXQ(8),AKYQ(8),AKZQ(8),AKXYQ(8),AKXZQ(8),AKYZQ(8)
      DIMENSION XQ(8),YQ(8),ZQ(8)
C
      DIMENSION DNX(8),DNY(8),DNZ(8),W(8)
      DIMENSION S(8),T(8),U(8)
C
      DATA S/-1.0D0,1.0D0,1.0D0,-1.0D0, -1.0D0,1.0D0,1.0D0,-1.0D0/
      DATA T/-1.0D0,-1.0D0,1.0D0,1.0D0, -1.0D0,-1.0D0,1.0D0,1.0D0/
      DATA U/-1.0D0,-1.0D0,-1.0D0,-1.0D0, 1.0D0,1.0D0,1.0D0,1.0D0/
C
      IF(IQUAR.EQ.1 .OR. IQUAR.EQ.3)THEN
        P=0.577350269189626D0
        L1(1)=0.666666666666667D0
        L1(2)=0.166666666666667D0
        L1(3)=0.166666666666667D0
        L2(1)=0.166666666666667D0
        L2(2)=0.666666666666667D0
        L2(3)=0.166666666666667D0
        L3(1)=0.166666666666667D0
        L3(2)=0.166666666666667D0
        L3(3)=0.666666666666667D0
        LL1(1)=0.58541020D0
        LL1(2)=0.13819660D0
        LL1(3)=0.13819660D0
        LL1(4)=0.13819660D0
        LL2(1)=0.13819660D0
        LL2(2)=0.58541020D0
        LL2(3)=0.13819660D0
        LL2(4)=0.13819660D0
        LL3(1)=0.13819660D0
        LL3(2)=0.13819660D0
        LL3(3)=0.58541020D0
        LL3(4)=0.13819660D0
        LL4(1)=0.13819660D0
        LL4(2)=0.13819660D0
        LL4(3)=0.13819660D0
        LL4(4)=0.58541020D0
      ELSE
        P=1.0D0
        L1(1)=1.0D0
        L1(2)=0.0D0
        L1(3)=0.0D0
        L2(1)=0.0D0
        L2(2)=1.0D0
        L2(3)=0.0D0
        L3(1)=0.0D0
        L3(2)=0.0D0
        L3(3)=1.0D0
        LL1(1)=1.0D0
        LL1(2)=0.0D0
        LL1(3)=0.0D0
        LL1(4)=0.0D0
        LL2(1)=0.0D0
        LL2(2)=1.0D0
        LL2(3)=0.0D0
        LL2(4)=0.0D0
        LL3(1)=0.0D0
        LL3(2)=0.0D0
        LL3(3)=1.0D0
        LL3(4)=0.0D0
        LL4(1)=0.0D0
        LL4(2)=0.0D0
        LL4(3)=0.0D0
        LL4(4)=1.0D0
      ENDIF
C
C ------- INITIATE MATRICES QA, QB, AND RQ
C
      DO 110 IQ=1,8
      RQ(IQ)=0.0
      DO 110 JQ=1,8
      QA(IQ,JQ)=0.0
      QB(IQ,JQ)=0.0
  110 CONTINUE
C
      DO 490 KG=1,NODE
C
C ------- DETERMINE LOACAL COORDINATE  OF GAUSSIAN POINT KG
C
C ------- CALCULATE VALUES OF BASIS FUNCTIONS N(IQ) AND THEIR
C ------- DERIVATIVES DNX(IQ), DNY(IQ), & DNZ(IQ) W.R.T. X, Y, & Z,
C ------- RESPECTIVELY AND THE DETERMINANT OF THE JACOBIAN.
C
        IF(NODE.EQ.8)THEN
          SS=P*S(KG)
          TT=P*T(KG)
          UU=P*U(KG)
          CALL SHAPE
     I      (XQ,YQ,ZQ, SS,TT,UU, XSI,DL1,DL2,DL3, D1,D2,D3,D4, NODE,0,
     O       N,DNX,DNY,DNZ,W,DJAC)
        ELSEIF(NODE.EQ.6)THEN
          IF(KG.LE.3)THEN
            XSI=-P
            KKG=KG
          ELSE
            XSI=P
            KKG=KG-3
          ENDIF
          DL1=L1(KKG)
          DL2=L2(KKG)
          DL3=L3(KKG)
          CALL SHAPE
     I      (XQ,YQ,ZQ, SS,TT,UU, XSI,DL1,DL2,DL3, D1,D2,D3,D4, NODE,0,
     O       N,DNX,DNY,DNZ,W,DJAC)
          DJAC=DJAC/3.0D0
        ELSEIF(NODE.EQ.4)THEN
          D1=LL1(KG)
          D2=LL2(KG)
          D3=LL3(KG)
          D4=LL4(KG)
          CALL SHAPE
     I      (XQ,YQ,ZQ, SS,TT,UU, XSI,DL1,DL2,DL3, D1,D2,D3,D4, NODE,0,
     O       N,DNX,DNY,DNZ,W,DJAC)
          DJAC=0.25D0*DJAC
        ENDIF
C
        AKXK=AKXQ(KG)
        AKYK=AKYQ(KG)
        AKZK=AKZQ(KG)
        AKXYK=AKXYQ(KG)
        AKXZK=AKXZQ(KG)
        AKYZK=AKYZQ(KG)
        RHOK=RHOKG(KG)
C
        AKXQP=AKXK*DJAC
        AKYQP=AKYK*DJAC
        AKZQP=AKZK*DJAC
        AKXYQP=AKXYK*DJAC
        AKXZQP=AKXZK*DJAC
        AKYZQP=AKYZK*DJAC
        RHOQP=RHOK
C
        DTHQP=DTHG(KG)*RHOQP*DJAC
        IF(SOSM.GT.0.0D0)THEN
          SOSMQP=SOSM*DJAC
        ELSE
          SOSMQP=SOSM*DJAC*RHOQP
        ENDIF
C
C ------- ACCUMULATE THE SUMS TO OBTAIN THE MATRIX INTEGRALS QA(IQ,JQ),
C ------- QB(IQ,JQ), AND RQ(IQ).
C
        DO 390 IQ=1,NODE
          RQ(IQ)=RQ(IQ)-AGRAV*(DNX(IQ)*AKXZQP+AKYZQP*DNY(IQ)+
     >           AKZQP*DNZ(IQ))*RHOQP + N(IQ)*SOSMQP
          DO 350 JQ=1,NODE
            QA(IQ,JQ)=QA(IQ,JQ) + DTHQP*N(IQ)*N(JQ)
            QB(IQ,JQ)=QB(IQ,JQ)+DNX(IQ)*(AKXQP*DNX(JQ)+AKXYQP*DNY(JQ)+
     >                AKXZQP*DNZ(JQ)) + DNY(IQ)*(AKXYQP*DNX(JQ)+
     >                AKYQP*DNY(JQ)+AKYZQP*DNZ(JQ)) + DNZ(IQ) *
     >                (AKXZQP*DNX(JQ)+AKYZQP*DNY(JQ)+AKZQP*DNZ(JQ))
  350     CONTINUE
  390   CONTINUE
C
  490 CONTINUE
C
      IF(ILUMP.EQ.0) RETURN
C
      DO 640 I=1,8
      SUM=0.0
      DO 620 J=1,8
      SUM=SUM+QA(I,J)
      QA(I,J)=0.0
  620 CONTINUE
      QA(I,I)=SUM
  640 CONTINUE
C
      RETURN
      END
C
C
C
      SUBROUTINE BASE
c     I               (XX,YY,ZZ,XQ,YQ,ZQ,M,NODE,ID,
     I               (XX,YY,ZZ,XQ,YQ,ZQ,NODE,ID,
     O                DL,DNX,DNY,DNZ)
C
C $$$$$ TO COMPUTE THE BASE FUNCTIONS AND THEIR DERIVATIVES AT POINT Q
C       WHICH IS INSIDE ELEMENT M
C NOTE: IF ID=1, ONLY BASE FUNCTIONS ARE TO BE CALCULATED.
C       IF ID=2, BOTH BASE FUNCTIONS AND THEIR DERIVATIVES ARE TO BE
C                CALCULATED
C
      IMPLICIT REAL*8(A-H,O-Z)
      REAL*8 J1,J2,J3,J4,J5,J6,J7,J8,J9
      REAL*8 J11,J12,J13,J21,J22,J23,J31,J32,J33
C
      DIMENSION XX(8),YY(8),ZZ(8)
      DIMENSION DL(8)
      DIMENSION DNX(8),DNY(8),DNZ(8)
      DIMENSION DNSS(8),DNTT(8),DNUU(8)
      DIMENSION A(4),B(4),C(4),D(4)
C
      DO 10 I=1,8
        DL(I)=0.0D0
        DNSS(I)=0.0D0
        DNTT(I)=0.0D0
        DNUU(I)=0.0D0
        DNX(I)=0.0D0
        DNY(I)=0.0D0
        DNZ(I)=0.0D0
 10   CONTINUE
C
C ***** START CALCULATIONS
C
      IF(NODE.EQ.8)THEN
C
C ----- FOR HEXAHEDRAL ELEMENTS
C
        CALL XSI3D
c     I           (XX,YY,ZZ,XQ,YQ,ZQ,M,
     I           (XX,YY,ZZ,XQ,YQ,ZQ,
     O            SS,TT,UU)
        SM=1.0D0-SS
        SP=1.0D0+SS
        TM=1.0D0-TT
        TP=1.0D0+TT
        UM=1.0D0-UU
        UP=1.0D0+UU
C
        DL(1)=0.125D0*SM*TM*UM
        DL(2)=0.125D0*SP*TM*UM
        DL(3)=0.125D0*SP*TP*UM
        DL(4)=0.125D0*SM*TP*UM
        DL(5)=0.125D0*SM*TM*UP
        DL(6)=0.125D0*SP*TM*UP
        DL(7)=0.125D0*SP*TP*UP
        DL(8)=0.125D0*SM*TP*UP
C
        IF(ID.EQ.2)THEN
          DNSS(1)=-.125D0*TM*UM
          DNSS(2)=.125D0*TM*UM
          DNSS(3)=.125D0*TP*UM
          DNSS(4)=-.125D0*TP*UM
          DNSS(5)=-.125D0*TM*UP
          DNSS(6)=.125D0*TM*UP
          DNSS(7)=.125D0*TP*UP
          DNSS(8)=-.125D0*TP*UP
C
          DNTT(1)=-.125D0*SM*UM
          DNTT(2)=-.125D0*SP*UM
          DNTT(3)=.125D0*SP*UM
          DNTT(4)=.125D0*SM*UM
          DNTT(5)=-.125D0*SM*UP
          DNTT(6)=-.125D0*SP*UP
          DNTT(7)=.125D0*SP*UP
          DNTT(8)=.125D0*SM*UP
C
          DNUU(1)=-.125D0*SM*TM
          DNUU(2)=-.125D0*SP*TM
          DNUU(3)=-.125D0*SP*TP
          DNUU(4)=-.125D0*SM*TP
          DNUU(5)= .125D0*SM*TM
          DNUU(6)= .125D0*SP*TM
          DNUU(7)= .125D0*SP*TP
          DNUU(8)= .125D0*SM*TP
C
          SUM1=0.0
          SUM2=0.0
          SUM3=0.0
          SUM4=0.0
          SUM5=0.0
          SUM6=0.0
          SUM7=0.0
          SUM8=0.0
          SUM9=0.0
C
          DO 290 I=1,8
            SUM1=SUM1+XX(I)*DNSS(I)
            SUM2=SUM2+YY(I)*DNSS(I)
            SUM3=SUM3+ZZ(I)*DNSS(I)
            SUM4=SUM4+XX(I)*DNTT(I)
            SUM5=SUM5+YY(I)*DNTT(I)
            SUM6=SUM6+ZZ(I)*DNTT(I)
            SUM7=SUM7+XX(I)*DNUU(I)
            SUM8=SUM8+YY(I)*DNUU(I)
            SUM9=SUM9+ZZ(I)*DNUU(I)
  290     CONTINUE
C
          DJAC=SUM1*(SUM5*SUM9-SUM6*SUM8)+SUM2*(SUM6*SUM7-SUM4*SUM9)+
     1         SUM3*(SUM4*SUM8-SUM5*SUM7)
C
          DJACI=1.0D0/DJAC
C
          SUMI1=DJACI*(SUM5*SUM9-SUM6*SUM8)
          SUMI2=DJACI*(SUM3*SUM8-SUM2*SUM9)
          SUMI3=DJACI*(SUM2*SUM6-SUM3*SUM5)
          SUMI4=DJACI*(SUM6*SUM7-SUM4*SUM9)
          SUMI5=DJACI*(SUM1*SUM9-SUM3*SUM7)
          SUMI6=DJACI*(SUM3*SUM4-SUM1*SUM6)
          SUMI7=DJACI*(SUM4*SUM8-SUM5*SUM7)
          SUMI8=DJACI*(SUM2*SUM7-SUM1*SUM8)
          SUMI9=DJACI*(SUM1*SUM5-SUM2*SUM4)
C
          DO 390 I=1,8
            DNX(I)=SUMI1*DNSS(I)+SUMI2*DNTT(I)+SUMI3*DNUU(I)
            DNY(I)=SUMI4*DNSS(I)+SUMI5*DNTT(I)+SUMI6*DNUU(I)
            DNZ(I)=SUMI7*DNSS(I)+SUMI8*DNTT(I)+SUMI9*DNUU(I)
  390     CONTINUE
          DJAC=DABS(DJAC)
        ENDIF
C
      ELSEIF(NODE.EQ.6)THEN
C
C ----- FOR PENTAHEDRAL ELEMENTS
C
        CALL XSI3DP
c     I            (XX,YY,ZZ,XQ,YQ,ZQ,M,
     I            (XX,YY,ZZ,XQ,YQ,ZQ,
     O             XSI,DL1,DL2,DL3)
        DL(1)=0.5D0*(1.0D0-XSI)*DL1
        DL(2)=0.5D0*(1.0D0-XSI)*DL2
        DL(3)=0.5D0*(1.0D0-XSI)*DL3
        DL(4)=0.5D0*(1.0D0+XSI)*DL1
        DL(5)=0.5D0*(1.0D0+XSI)*DL2
        DL(6)=0.5D0*(1.0D0+XSI)*DL3
C
        IF(ID.EQ.2)THEN
          SM=1.0D0-XSI
          SP=1.0D0+XSI
          DNSS(1)=-.5D0*DL1
          DNSS(2)=-.5D0*DL2
          DNSS(3)=-.5D0*DL3
          DNSS(4)=.5D0*DL1
          DNSS(5)=.5D0*DL2
          DNSS(6)=.5D0*DL3
C
          DNTT(1)=.5D0*SM
          DNTT(2)=.0D0
          DNTT(3)=-.5D0*SM
          DNTT(4)=.5D0*SP
          DNTT(5)=.0D0
          DNTT(6)=-.5D0*SP
C
          DNUU(1)=.0D0
          DNUU(2)=.5D0*SM
          DNUU(3)=-.5D0*SM
          DNUU(4)=.0D0
          DNUU(5)=.5D0*SP
          DNUU(6)=-.5D0*SP
C
          X3416=XX(3)+XX(4)-XX(1)-XX(6)
          X3526=XX(3)+XX(5)-XX(2)-XX(6)
          X1436=XX(1)+XX(4)-XX(3)-XX(6)
          X2536=XX(2)+XX(5)-XX(3)-XX(6)
          Y3416=YY(3)+YY(4)-YY(1)-YY(6)
          Y3526=YY(3)+YY(5)-YY(2)-YY(6)
          Y1436=YY(1)+YY(4)-YY(3)-YY(6)
          Y2536=YY(2)+YY(5)-YY(3)-YY(6)
          Z3416=ZZ(3)+ZZ(4)-ZZ(1)-ZZ(6)
          Z3526=ZZ(3)+ZZ(5)-ZZ(2)-ZZ(6)
          Z1436=ZZ(1)+ZZ(4)-ZZ(3)-ZZ(6)
          Z2536=ZZ(2)+ZZ(5)-ZZ(3)-ZZ(6)
C
          J11=0.5D0*(XX(6)-XX(3)+DL1*X3416+DL2*X3526)
          J12=0.5D0*(YY(6)-YY(3)+DL1*Y3416+DL2*Y3526)
          J13=0.5D0*(ZZ(6)-ZZ(3)+DL1*Z3416+DL2*Z3526)
          J21=0.5D0*(X1436+XSI*X3416)
          J22=0.5D0*(Y1436+XSI*Y3416)
          J23=0.5D0*(Z1436+XSI*Z3416)
          J31=0.5D0*(X2536+XSI*X3526)
          J32=0.5D0*(Y2536+XSI*Y3526)
          J33=0.5D0*(Z2536+XSI*Z3526)
C
          DJAC=J11*J22*J33+J12*J23*J31+J13*J21*J32-
     >         J11*J32*J23-J12*J21*J33-J13*J31*J22
C
          DJACI=1.0D0/DJAC
C
          J1=DJACI*(J22*J33-J23*J32)
          J2=-DJACI*(J12*J33-J13*J32)
          J3=DJACI*(J12*J23-J13*J22)
          J4=-DJACI*(J21*J33-J23*J31)
          J5=DJACI*(J11*J33-J13*J31)
          J6=-DJACI*(J11*J23-J13*J21)
          J7=DJACI*(J21*J32-J22*J31)
          J8=-DJACI*(J11*J32-J12*J31)
          J9=DJACI*(J11*J22-J12*J21)
C
          DO 490 I=1,6
            DNX(I)=J1*DNSS(I)+J2*DNTT(I)+J3*DNUU(I)
            DNY(I)=J4*DNSS(I)+J5*DNTT(I)+J6*DNUU(I)
            DNZ(I)=J7*DNSS(I)+J8*DNTT(I)+J9*DNUU(I)
  490     CONTINUE
          DJAC=DABS(DJAC)
        ENDIF
C
      ELSE
C
C ----- FOR TETRAHEDRAL ELEMENTS
C
        DETJ=0.0
        DO 550 KK=1,4
          IF(KK.EQ.1)THEN
            K1=2
            K2=3
            K3=4
          ELSEIF(KK.EQ.2)THEN
            K1=1
            K2=3
            K3=4
          ELSEIF(KK.EQ.3)THEN
            K1=1
            K2=2
            K3=4
          ELSE
            K1=1
            K2=2
            K3=3
          ENDIF
          A(KK)=(-1.0D0)**(KK+1)*(XX(K1)*YY(K2)*ZZ(K3)+
     1          YY(K1)*ZZ(K2)*XX(K3)+ZZ(K1)*XX(K2)*YY(K3)-
     2          XX(K3)*YY(K2)*ZZ(K1)-YY(K3)*ZZ(K2)*XX(K1)-
     3          ZZ(K3)*XX(K2)*YY(K1))
          B(KK)=(-1.0D0)**KK*(YY(K1)*ZZ(K2)+
     1          YY(K2)*ZZ(K3)+YY(K3)*ZZ(K1)-
     2          YY(K3)*ZZ(K2)-YY(K2)*ZZ(K1)-
     3          YY(K1)*ZZ(K3))
          C(KK)=(-1.0D0)**(KK+1)*(XX(K1)*ZZ(K2)+
     1          XX(K2)*ZZ(K3)+XX(K3)*ZZ(K1)-
     2          XX(K3)*ZZ(K2)-XX(K2)*ZZ(K1)-
     3          XX(K1)*ZZ(K3))
          D(KK)=(-1.0D0)**KK*(XX(K1)*YY(K2)+
     1          XX(K2)*YY(K3)+XX(K3)*YY(K1)-
     2          XX(K3)*YY(K2)-XX(K2)*YY(K1)-
     3          XX(K1)*YY(K3))
          DETJ=DETJ+A(KK)
  550   CONTINUE
        if(detj.eq.0.0d0)then
          print *,'error occurred at base for DETJ=0 -----> stop'
          stop
        endif
        dlmax=0.0d0
        kkmax=0
        DO 580 KK=1,4
          DL(KK)=(A(KK)+B(KK)*XQ+C(KK)*YQ+D(KK)*ZQ)/DETJ
          if(dl(kk).lt.0.0d0)dl(kk)=0.0d0
          if(dl(kk).gt.dlmax)then   
            dlmax=dl(kk)
            kkmax=kk
          endif
  580   CONTINUE
        dl(kkmax)=dl(kkmax)+(1.0d0-dl(1)-dl(2)-dl(3)-dl(4))
C
        IF(ID.EQ.2)THEN
          DO 590 KK=1,4
            DNX(KK)=B(KK)/DETJ
            DNY(KK)=C(KK)/DETJ
            DNZ(KK)=D(KK)/DETJ
  590     CONTINUE
        ENDIF
        DJAC=DABS(DETJ)
      ENDIF
C
C ***** THIS IS THE END OF CALCULATIONS
C
      RETURN
      END
C
C
C
      SUBROUTINE FBC(CMATRX,RLD,LRN,NLRN, IE,X, AKHC, DCOSB,ISB,
     1 QCB,ISC,ICTYP, QNB,ISN,INTYP, RSVAB,INDRS,QVB,ISV,IVTYP,
     2 HDB,IDTYP,NPDB,IQUAR)
C
C********1*********2*********3*********4*********5*********6*********7**
C
C ------- TO APPLY CAUCHY, NEUMANN, VARIABLE, AND DIRICHLET BOUNDARY
C ------- CONDITIONS.
C
C********1*********2*********3*********4*********5*********6*********7**
C
C ------- INPUT: X(NNP,3), IE(NEL,9), LRN(MXJBD,NNP),
C -------        AKHC(8,NEL,7), DCOSB(3,NBES),ISB(6,NBES), QCB(NCPR),
C -------        ISC(5,NCES),ICTYP(NCES), QNB(NNPR),ISN(5,NNES),
C -------        INTYP(NNES), RSVAB(NVNP,4), INDRS(NVNP,3),
C -------        HDB(NDPR),IDTYP(NDNP), NPDB(NDNP).
C
C ------- OUTPUT: MODIFIED CMATRX(NNP,MXJBD), RLD(NNP).
C
C********1*********2*********3*********4*********5*********6*********7**
C
      IMPLICIT REAL*8(A-H,O-Z)
C
      COMMON /SGEOM/ MAXEL,MAXNP,MXADNP,MAXBES,MXTUBS,MAXBNP,MXJBD,
     >               MXKBD,MXNTI,MXDTC
      COMMON /CGEOM/ NNP,NEL,NBNP,NTUBS,NBES,NTI,NDTCHG,ISHAPE
      COMMON /FINTE/ NCYL,NITER,NPITER,KSP,KGRAV,IPNTS
C
      COMMON /FCBC/ MXCNP,MXCES,MXCPR,MXCDP,NCNP,NCES,NCPR,NCDP,KCAI
      COMMON /FNBC/ MXNNP,MXNES,MXNPR,MXNDP,NNNP,NNES,NNPR,NNDP,KNAI
      COMMON /FVBC/ MXVES,MXVNP,MXVPR,MXVDP,NVES,NVNP,NVPR,NVDP,KVAI
      COMMON /FDBC/ MXDNP,MXDPR,MXDDP,NDNP,NDPR,NDDP,KDAI
C
      DIMENSION CMATRX(MXADNP,MXJBD),RLD(MAXNP),LRN(MXJBD,MXADNP)
      DIMENSION X(MAXNP,3),IE(MAXEL,11), AKHC(8,MAXEL,7),NLRN(MAXNP)
      DIMENSION DCOSB(3,MAXBES),ISB(6,MAXBES)
C
      DIMENSION RSVAB(MXVNP,4),INDRS(MXVNP,3),IVTYP(MXVES),QVB(MXVPR)
      DIMENSION ISV(5,MXVES)
C
      DIMENSION HDB(MXDPR),IDTYP(MXDNP),NPDB(MXDNP)
      DIMENSION QCB(MXCPR),ICTYP(MXCES),ISC(5,MXCES)
      DIMENSION QNB(MXNPR),INTYP(MXNES),ISN(5,MXNES)
C
      DIMENSION R1Q(4),R2Q(4),XQ(4),YQ(4),ZQ(4),F1Q(4),F2Q(4)
      DIMENSION RHOKG(4)
C
      DIMENSION KGB(4,6,3)
C
      DATA KGB/1,4,8,5, 1,2,6,5, 2,3,7,6, 4,3,7,8, 1,2,3,4, 5,6,7,8,
     >         1,3,6,4, 1,4,5,2, 2,5,6,3, 1,2,3,0, 4,5,6,0, 0,0,0,0,
     >         4,3,2,0, 4,1,3,0, 4,2,1,0, 1,2,3,0, 0,0,0,0, 0,0,0,0/
C
      AGRAV=  dble(KGRAV)
C
C ******* APPLY CAUCHY BOUNDARY CONDITIONS
C
      IF(NCES.LE.0) GO TO 300
      DO 260 MP=1,NCES
        ITYP=ICTYP(MP)
        QCBMP=QCB(ITYP)
C
        MPB=ISC(5,MP)
        LS=ISB(5,MPB)
        M=ISB(6,MPB)
        IF(IE(M,5).EQ.0)THEN
          IK=3
        ELSEIF(IE(M,7).EQ.0)THEN
          IK=2
        ELSE
          IK=1
        ENDIF
C
        NODE=4
        DO 210 IQ=1,4
          I=KGB(IQ,LS,IK)
          IF(I.EQ.0 .AND. IQ.EQ.4)THEN
            NODE=3
            GOTO 210
          ENDIF
          NI=IE(M,I)
          XQ(IQ)=X(NI,1)
          YQ(IQ)=X(NI,2)
          ZQ(IQ)=X(NI,3)
          F1Q(IQ)=QCBMP
          F2Q(IQ)=0.0
          RHOKG(IQ)=AKHC(I,M,7)
  210   CONTINUE
C
        CALL Q34S(R1Q,R2Q,XQ,YQ,ZQ,F1Q,F2Q,RHOKG,NODE,IQUAR)
C
        DO 230 IQ=1,NODE
          I=KGB(IQ,LS,IK)
          NI=IE(M,I)
          RLD(NI)=RLD(NI)-R1Q(IQ)
  230   CONTINUE
  260 CONTINUE
C
C ******* APPLY NEUMANN BOUNDARY CONDITIONS
C
  300 IF(NNES.EQ.0) GO TO 500
      DO 390 MP=1,NNES
        ITYP=INTYP(MP)
        QNBMP=QNB(ITYP)
C
        MPB=ISN(5,MP)
        LS=ISB(5,MPB)
        M=ISB(6,MPB)
        IF(IE(M,5).EQ.0)THEN
          IK=3
        ELSEIF(IE(M,7).EQ.0)THEN
          IK=2
        ELSE
          IK=1
        ENDIF
C
        NODE=4
        DO 310 IQ=1,4
        I=KGB(IQ,LS,IK)
        IF(I.EQ.0 .AND. IQ.EQ.4)THEN
          NODE=3
          GOTO 310
        ENDIF
        NI=IE(M,I)
        XQ(IQ)=X(NI,1)
        YQ(IQ)=X(NI,2)
        ZQ(IQ)=X(NI,3)
        F1Q(IQ)=QNBMP
        F2Q(IQ)=AGRAV*(DCOSB(1,MPB)*AKHC(I,M,5)+DCOSB(2,MPB)*AKHC(I,M,6) 
     1          +DCOSB(3,MPB)*AKHC(I,M,3))
        RHOKG(IQ)=AKHC(I,M,7)
  310 CONTINUE
C
      CALL Q34S(R1Q,R2Q,XQ,YQ,ZQ,F1Q,F2Q,RHOKG,NODE,IQUAR)
C
C -------- MODIFY LOAD VECTOR DUE TO NEUMANN FLUX AND GRAVITY TERM.
C
      DO 360 IQ=1,NODE
        I=KGB(IQ,LS,IK)
        NI=IE(M,I)
        RLD(NI)=RLD(NI)-R1Q(IQ)+R2Q(IQ)
  360 CONTINUE
C
  390 CONTINUE
C
C ******* APPLY VARIABLE (RAINFALL-SEEPAGE) BOUNDARY CONDITIONS
C
  500 IF(NVES.EQ.0) GO TO 600
C
C -------- CAUCHY PART OF VARIABLE BOUNDARY CONDITIONS
C
      DO 420 MP=1,NVES
        ITYP=IVTYP(MP)
        QVBMP=QVB(ITYP)
C
        MPB=ISV(5,MP)
        LS=ISB(5,MPB)
        M=ISB(6,MPB)
C
        IF(IE(M,5).EQ.0)THEN
          IK=3
        ELSEIF(IE(M,7).EQ.0)THEN
          IK=2
        ELSE
          IK=1
        ENDIF
C
        PROJ=DCOSB(3,MPB)
        QVBMP=-QVBMP*PROJ
C
        NODE=4
        DO 410 IQ=1,4
          I=KGB(IQ,LS,IK)
          IF(I.EQ.0 .AND. IQ.EQ.4)THEN
            NODE=3
            GOTO 410
          ENDIF
          NI=IE(M,I)
          XQ(IQ)=X(NI,1)
          YQ(IQ)=X(NI,2)
          ZQ(IQ)=X(NI,3)
          F1Q(IQ)=QVBMP
          F2Q(IQ)=0.0
          RHOKG(IQ)=AKHC(I,M,7)
  410   CONTINUE
C
C -------- COMPUTE SURFACE INTEGRAL OF N(IQ).F
C
        CALL Q34S(R1Q,R2Q,XQ,YQ,ZQ,F1Q,F2Q,RHOKG,NODE,IQUAR)
C
        DO IQ=1,NODE
          I=KGB(IQ,LS,IK)
          NI=IE(M,I)
          RLD(NI)=RLD(NI)-R1Q(IQ)
        ENDDO
C
  420 CONTINUE
C
C -------- DIRICHLET PART OF VARIABLE BOUNDARY CONDITIONS
C
      DO 490 NPP=1,NVNP
        NI=INDRS(NPP,1)
        IF(NI.NE.0) GO TO 450
        NI=INDRS(NPP,2)
        IF(NI.NE.0) GO TO 460
        GO TO 490
  450   BB=RSVAB(NPP,1)
        GO TO 470
  460   BB=RSVAB(NPP,2)
C
C ------- put the constant head or minimum head at right-hand side
  470   RLD(NI)=BB
C ------ modify the row corresponding to the head node
        DO 480 I=1,MXJBD
          CMATRX(NI,I)=0.0
          IB=LRN(I,NI)
          IF(IB.EQ.NI) CMATRX(NI,I)=1.0D0
  480   CONTINUE
C ----- modify the column corresponding to the nead node
C ----- the reason for this is to make the coefficient matrix symmetric
        DO 487 INP=1,NLRN(NI)
          NP=LRN(INP,NI)
          IF(NP.EQ.NI .OR. NP.EQ.0) GO TO 487
          DO 485 IP=1,MXJBD
            IB=LRN(IP,NP)
            IF(IB.EQ.0) GO TO 485
            IF(IB.EQ.NI) THEN
              RLD(NP)=RLD(NP)-CMATRX(NP,IP)*RLD(NI)
              CMATRX(NP,IP)=0.0D0
              GO TO 487
            ENDIF
  485     CONTINUE
  487   CONTINUE
C
  490 CONTINUE
C
C ******* APPLY DIRICHLET BOUNDARY CONDITIONS
C
  600 IF(NDNP.EQ.0) GO TO 900
      DO 740 NPP=1,NDNP
      NI=NPDB(NPP)
      ITYP=IDTYP(NPP)
C ------- put the Dirichlet on the right-hand side
      BB=HDB(ITYP)-X(NI,3)*AGRAV
      RLD(NI)=BB
C ------- modify the row corresponding to the Dirichlet node
      DO 710 I=1,MXJBD
      CMATRX(NI,I)=0.0
      IB=LRN(I,NI)
      IF(IB.EQ.NI) CMATRX(NI,I)=1.0D0
  710 CONTINUE
C ------ modify the column corresponding to the Dirichlet node.
C ------ the reason of this is to make the coefficient matrix symmetric
      DO 720 INP=1,NLRN(NI)
        NP=LRN(INP,NI)
        IF(NP.EQ.NI .OR. NP.EQ.0) GO TO 720
        DO 715 IP=1,MXJBD
          IB=LRN(IP,NP)
          IF(IB.EQ.0) GO TO 715
          IF(IB.EQ.NI) THEN
            RLD(NP)=RLD(NP)-CMATRX(NP,IP)*RLD(NI)
            CMATRX(NP,IP)=0.0D0
            GO TO 720
          ENDIF
  715   CONTINUE
  720 CONTINUE
C
  740 CONTINUE
C
  900 CONTINUE
C
      RETURN
      END
C
C
C
      SUBROUTINE Q34S(R1Q,R2Q,XQ,YQ,ZQ,F1Q,F2Q,RHOKG,NODE,IQUAR)
C
C********1*********2*********3*********4*********5*********6*********7**
C
C ------- TO COMPUTE BOUNDARY SURFACE LOAD VECTOR OVER A BOUNDARY
C ------- SURFACE.
C
C********1*********2*********3*********4*********5*********6*********7**
C
C ------- INPUT: XQ(4), YQ(4), ZQ(4),F1Q(4), F2Q(4).
C
C ------- OUTPUT: R1Q(4), R2Q(4).
C
C********1*********2*********3*********4*********5*********6*********7**
C
      IMPLICIT REAL*8 (A-H,O-Z)
      REAL*8 N(4),L1(3),L2(3),L3(3)
C
      DIMENSION R1Q(4),R2Q(4),XQ(4),YQ(4),ZQ(4),F1Q(4),F2Q(4),RHOKG(4)
      DIMENSION S(4),T(4),DNSS(4),DNTT(4),WG(3)
C
      DATA S/-1.0D+00, 1.0D+00, 1.0D+00,-1.0D+00/
      DATA T/-1.0D+00,-1.0D+00, 1.0D+00,  1.0D+00/
      DATA WG/0.333333333333333D0, 0.333333333333333D0,
     1        0.333333333333333D0/
C
      IF(IQUAR.EQ.3 .OR. IQUAR.EQ.4)THEN
        P=0.577350269189626D0
        L1(1)=0.666666666666667D0
        L1(2)=0.166666666666667D0
        L1(3)=0.166666666666667D0
        L2(1)=0.166666666666667D0
        L2(2)=0.666666666666667D0
        L2(3)=0.166666666666667D0
        L3(1)=0.166666666666667D0
        L3(2)=0.166666666666667D0
        L3(3)=0.666666666666667D0
      ELSE
        P=1.0D0
        L1(1)=1.0D0
        L1(2)=0.0D0
        L1(3)=0.0D0
        L2(1)=0.0D0
        L2(2)=1.0D0
        L2(3)=0.0D0
        L3(1)=0.0D0
        L3(2)=0.0D0
        L3(3)=1.0D0
      ENDIF
C
C ------- INITIATE MATRICES RQ(IQ)
C
      DO 100 IQ=1,4
        R1Q(IQ)=0.0
        R2Q(IQ)=0.0
  100 CONTINUE
C
C ----- COMPUTE JACOBIAN AT GAUSSIAN POINTS IF NODE.EQ.3
C
      IF(NODE.EQ.3)THEN
        DXDDL2=XQ(2)-XQ(1)
        DYDDL2=YQ(2)-YQ(1)
        DZDDL2=ZQ(2)-ZQ(1)
        DXDDL3=XQ(3)-XQ(1)
        DYDDL3=YQ(3)-YQ(1)
        DZDDL3=ZQ(3)-ZQ(1)
        DETX=DYDDL2*DZDDL3-DYDDL3*DZDDL2
        DETY=DXDDL2*DZDDL3-DXDDL3*DZDDL2
        DETZ=DXDDL2*DYDDL3-DXDDL3*DYDDL2
        DET1=DSQRT(DETX*DETX+DETY*DETY+DETZ*DETZ)*0.5D0
      ENDIF
C
C ------- SUMMATION OF THE INTEGRAND OVER THE GAUSSIAN POINTS
C
      DO 690 KG=1,NODE
C
C ------- DETERMINE LOACAL COORDINATE OF GAUSSIAN POINT KG
C
        IF(NODE.EQ.4)THEN
C
          SS=P*S(KG)
          TT=P*T(KG)
          SM=1.0D0-SS
          SP=1.0D0+SS
          TM=1.0D0-TT
          TP=1.0D0+TT
          N(1)=0.25D0*SM*TM
          N(2)=0.25D0*SP*TM
          N(3)=0.25D0*SP*TP
          N(4)=0.25D0*SM*TP
C
C ----- COMPUTE JACOBIAN AT GAUSSIAN POINTS
C
          DNSS(1)=-0.25D0*TM
          DNSS(2)= 0.25D0*TM
          DNSS(3)= 0.25D0*TP
          DNSS(4)=-0.25D0*TP
          DNTT(1)=-0.25D0*SM
          DNTT(2)=-0.25D0*SP
          DNTT(3)= 0.25D0*SP
          DNTT(4)= 0.25D0*SM
          DXDSS=0.0D0
          DYDSS=0.0D0
          DZDSS=0.0D0
          DXDTT=0.0D0
          DYDTT=0.0D0
          DZDTT=0.0D0
          DO 290 IQ=1,4
            DXDSS=DXDSS+XQ(IQ)*DNSS(IQ)
            DYDSS=DYDSS+YQ(IQ)*DNSS(IQ)
            DZDSS=DZDSS+ZQ(IQ)*DNSS(IQ)
            DXDTT=DXDTT+XQ(IQ)*DNTT(IQ)
            DYDTT=DYDTT+YQ(IQ)*DNTT(IQ)
            DZDTT=DZDTT+ZQ(IQ)*DNTT(IQ)
  290     CONTINUE
          DETZ=DXDSS*DYDTT-DYDSS*DXDTT
          DETY=-DXDSS*DZDTT+DZDSS*DXDTT
          DETX=DYDSS*DZDTT-DZDSS*DYDTT
          DET=DSQRT(DETX*DETX+DETY*DETY+DETZ*DETZ)
C
        ELSE
C
          N(1)=L1(KG)
          N(2)=L2(KG)
          N(3)=L3(KG)
C
C ----- COMPUTE JACOBIAN AT GAUSSIAN POINTS
C
          DET=DET1*WG(KG)
C
        ENDIF
C
C ------- ACCUMULATE THE SUMS TO OBTAIN THE MATRIX INTEGRALS RQ(IQ)
C
        F1K=0.0D0
        F2K=0.0
        DO 350 IQ=1,NODE
          F1K=F1K+F1Q(IQ)*N(IQ)
          F2K=F2K+F2Q(IQ)*N(IQ)
  350   CONTINUE
        RHOK=RHOKG(KG)
C
        DO 390 IQ=1,NODE
          R1Q(IQ)=R1Q(IQ)+N(IQ)*F1K*DET*RHOK
          R2Q(IQ)=R2Q(IQ)+N(IQ)*F2K*DET*RHOK
  390   CONTINUE
C
  690 CONTINUE
C
      RETURN
      END
C
C
C
      SUBROUTINE FPRINT(V,H,HT,TH, BFLX, NPVB,RSVAB,INDRS,SUBHD,
     1 TIME,DELT, KPR,KOUT,KDIAG,ITIM)
C
C********1*********2*********3*********4*********5*********6*********7**
C
C ------- TO OUTPUT FLOWS, PRESSURE HEAD, TOTAL HEAD, WATER CONTENT,
C ------- AND DARCY'S VELOCITY AS SPECIFIED BY THE PARAMETER KPR.
C
C********1*********2*********3*********4*********5*********6*********7**
C
C ------- INPUT: V(NNP,3), H(NNP), HT(NNP), TH(NEL,8),
C -------        RSVAB(NVNP,4), INDRS(NVNP,3), SUBHD,
C -------        TIME, DELT, KPR, KOUT, KDIAG, ITIM.
C
C ------- OUTPUT: LINE PRINT ALL INPUTS IF NEEDED EXCEPT FOR KPR.
C
C********1*********2*********3*********4*********5*********6*********7**
C
      IMPLICIT REAL*8(A-H,O-Z)
      CHARACTER*32 SUBHD
C
      COMMON /SGEOM/ MAXEL,MAXNP,MXADNP,MAXBES,MXTUBS,MAXBNP,MXJBD,
     >               MXKBD,MXNTI,MXDTC
      COMMON /CGEOM/ NNP,NEL,NBNP,NTUBS,NBES,NTI,NDTCHG,ISHAPE
      COMMON /FVBC/ MXVES,MXVNP,MXVPR,MXVDP,NVES,NVNP,NVPR,NVDP,KVAI
C
      COMMON /FFLOW/ FRATE(10),FLOW(10),TFLOW(10)
C
      DIMENSION V(MAXNP,3),H(MAXNP),HT(MAXNP), TH(MAXEL,8)
      DIMENSION BFLX(MAXBNP,2),NPVB(MXVNP),INDRS(MXVNP,3),RSVAB(MXVNP,4)
C
      IF(KPR.LE.0) RETURN
C ----- print diagnostic flow information
        KDIAG=KDIAG+1
        KDIA=KDIAG-1
        WRITE(16,1000) KDIA,TIME,DELT,ITIM,(FRATE(I),FLOW(I),TFLOW(I),
     >              I=1,9)
        IF(NVNP.GT.0) THEN
          DO 120 NPP=1,NVNP
            NKK=NPVB(NPP)
            RSVAB(NPP,4)=BFLX(NKK,2)
  120     CONTINUE
          WRITE(16,1100)
          WRITE(16,1110) (RSVAB(NPP,4),NPP=1,NVNP)
          WRITE(16,1120) (INDRS(NPP,1),NPP=1,NVNP)
          WRITE(16,1125) (INDRS(NPP,2),NPP=1,NVNP)
          WRITE(16,1130) (INDRS(NPP,3),NPP=1,NVNP)
      END IF
C
      IF(KPR.GT.1) THEN
C ----- print pressure heads
        KOUT=KOUT+1
        LINE=0
        DO 210 NI=1,NNP,4
          NJMN=NI
          NJMX=MIN0(NI+3,NNP)
          LINE=LINE+1
          IF(MOD(LINE-1,50).EQ.0) WRITE(16,2000) KOUT,TIME,
     >     DELT,MXJBD,ITIM,SUBHD
          WRITE(16,2100) (NJ,H(NJ),NJ=NJMN,NJMX)
  210   CONTINUE
      END IF
C
      IF(KPR.GT.2) THEN
C ----- print total heads
        KOUT=KOUT+1
        LINE=0
        DO 310 NI=1,NNP,4
          NJMN=NI
          NJMX=MIN0(NI+3,NNP)
          LINE=LINE+1
          IF(MOD(LINE-1,50).EQ.0) WRITE(16,3000) KOUT,TIME,
     >     DELT,MXJBD,ITIM,SUBHD
          WRITE(16,2100) (NJ,HT(NJ),NJ=NJMN,NJMX)
  310   CONTINUE
      END IF
C
      IF(KPR.GT.3) THEN
C ----- print water contents
        KOUT=KOUT+1
        LINE=0
        WRITE(16,4000) KOUT,TIME,DELT,MXJBD,ITIM,SUBHD
        DO 410 M=1,NEL
          LINE=LINE+1
          IF(MOD(LINE-1,50).EQ.0) WRITE(16,4000) KOUT,TIME,
     >     DELT,MXJBD,ITIM,SUBHD
          WRITE(16,4100) M,(TH(M,IQ),IQ=1,8)
  410   CONTINUE
      END IF
C
      IF(KPR.GT.4) THEN
C ----- print Darcy velocities
        KOUT=KOUT+1
        LINE=0
        DO 510 NP=1,NNP,2
          LINE=LINE+1
          IF(MOD(LINE-1,50).EQ.0) WRITE(16,5000) KOUT,TIME,
     >     DELT,MXJBD,ITIM,SUBHD
          NJMN=NP
          NJMX=MIN0(NP+1,NNP)
          WRITE(16,5100) (NJ,(V(NJ,I),I=1,3),NJ=NJMN,NJMX)
  510   CONTINUE
      END IF
C
      RETURN
C
 1000 FORMAT('1',' TABLE OF SYSTEM-FLOW PARAMETERS',2X,'TABLE: ',I4,
     > '.. AT TIME =',1PD12.4/' (DELT =',1PD12.4,')',' ITIM=',I4//1X,
     > ' TYPE OF FLOW',25X,'RATE',7X,'INC. FLOW',4X,'TOTAL FLOW'/
     1 '1. FLOW THROUGH DIRICHLET NODES .. ',3(1PD12.4,2X)/
     2 '2. FLOW THROUGH CAUCHY NODES . . . ',3(1PD12.4,2X)/
     3 '3. FLOW THROUGH NEUMANN NODES .  . ',3(1PD12.4,2X)/
     4 '4. FLOW THROUGH SEEPAGE NODES .. . ',3(1PD12.4,2X)/
     5 '5. FLOW THROUGH INFILTRATION NODES ',3(1PD12.4,2X)/
     6 '6. FLOW THROUGH UNSPECIFIED NODES  ',3(1PD12.4,2X)/
     7 '7. NET FLOW THROUGH ENTIRE BOUNDARY',3(1PD12.4,2X)/
     8 '8. ARTIFICIAL SOURCES/SINKS . . . .',3(1PD12.4,2X)/
     9 '9. INCREASE IN WATER CONTENT . . . ',3(1PD12.4,2X)/
     A ' *** NOTE: (+) = OUT FROM, (-) = INTO THE REGION. '//)
 1100 FORMAT(/' RAINFALL-SEEPAGE NODAL FLOWS (L**3/T)')
 1110 FORMAT(5D15.4)
 1120 FORMAT('0',' VALUES OF NPCON'/(5I15))
 1125 FORMAT('0',' VALUES OF NPMIN'/(5I15))
 1130 FORMAT('0',' VALUES OF NPFLX'/(5I15))
 2000 FORMAT('1 OUTPUT TABLE',I4,'.. PRESSURE HEADS(L) AT TIME =',
     1 1PD12.4/' (DELT =',1PD12.4,'),(BAND WIDTH =',I4,')','  IT =',
     2 I5//1X,A32/1X,4(' NODE    HEAD(L)   ')/1X,
     3 4(' ----    -------   '))
 2100 FORMAT(1X,4(I5,1PD13.5,1X))
 3000 FORMAT('1 OUTPUT TABLE',I4,'. TOTAL HEADS(L) AT TIME =',1PD12.4/
     1 ' (DELT =',1PD12.4,'),(BAND WIDTH =',I4,')','  IT =',I5//1X,A32,
     2 /1X,4(' NODE  TOT HEAD(L) ')/1X,4(' ----  ----------- '))
 4000 FORMAT('1 OUTPUT TABLE',I4,'. WATER CONTENT(L**3/L**3) AT TIME =',
     1 1PD12.4/' (DELT =',1PD12.4,'),(BAND WIDTH =',I4,')','  IT =',
     3 I5//1X,A32//30X,' GAUSSIAN POINTS'/15X,'1',7X,'2',7X,'3',7X,
     4 '4',7X,'5',7X,'6',7X,'7',7X,'8'/1X,'ELEMENT',2X,'---------',
     5 '-----------------------------------------------------')
 4100 FORMAT(' ',I7,2X,8(F8.5))
 5000 FORMAT('1 OUTPUT TABLE',I4,'.. DARCY VELOCITIES (L/T) AT TIME =',
     1 1PD12.4/' (DELT =',1PD12.4,'),(BAND WIDTH =',I4,')','  IT =',
     2 I5//1X,A32//1X,2(' NODE     VX         VY         VZ     ')/1X,
     3 2(' ------------------------------------- ')/)
 5100 FORMAT(' ',2(I5,1PD11.3,1PD11.3,1PD11.3,1X))
      END
C
C
C
      SUBROUTINE FSTORE(X,IE,H,HT,TH,V,INDRS, DCOSB,ISB,NPBB,
     1 NNPLR,GNLR, TITLE,JTM, TIME, NPROB,AKHC)
C
C********1*********2*********3*********4*********5*********6*********7**
C
C ------- TO STORE PERTINENT QUANTITIES ON AUXILIARY DEVICES FOR FUTURE
C ------- USES, E. G., FOR PLOTTING.  WHAT DEVICE IS TO BE USED MUST BE
C ------- SPECIFIED IN THE JCL.
C
C********1*********2*********3*********4*********5*********6*********7**
C
C ------- INPUT: X(NNP,3), IE(NEL,9), H(NNP), HT(NNP),
C -------        TH(NEL,8), V(NNP,3),  DCOSB(3,NBES),
C -------        ISB(6,NBES),NPBB(NBNP), NNPLR(MXREGN),
C -------        GNLR(LTMXNP,MXREGN), TITLE,TIME,NPROB.
C
C ------- OUTPUT: STORE ALL INPUTS IN LOGICAL UNIT 1.
C
C********1*********2*********3*********4*********5*********6*********7**
C
      IMPLICIT REAL*8(A-H,O-Z)
      INTEGER*4 GNLR
      CHARACTER TITLE*70
C
      COMMON /SGEOM/ MAXEL,MAXNP,MXADNP,MAXBES,MXTUBS,MAXBNP,MXJBD,
     >               MXKBD,MXNTI,MXDTC
      COMMON /CGEOM/ NNP,NEL,NBNP,NTUBS,NBES,NTI,NDTCHG,ISHAPE
      COMMON /LGEOM/ LTMXNP,LMXNP,LMXBW,MXREGN,NREGN
      COMMON /NOPTN/ ILUMP,IMID,IWET,IOPTIM,KSORP,LGRN,IQUAR
      COMMON /FINTE/ NCYL,NITER,NPITER,KSP,KGRAV,IPNTS
      COMMON /FVBC/ MXVES,MXVNP,MXVPR,MXVDP,NVES,NVNP,NVPR,NVDP,KVAI
      COMMON /NINTR/ KPR0,KDSK0,NSTRf,NSTRt,KSS,KSSt,IGEOM
C
      DIMENSION X(MAXNP,3),IE(MAXEL,11)
      DIMENSION H(MAXNP),HT(MAXNP),V(MAXNP,3),INDRS(MXVNP,3)
      DIMENSION TH(MAXEL,8),AKHC(8,MAXEL)
      DIMENSION DCOSB(3,MAXBES),ISB(6,MAXBES),NPBB(MAXBNP)
      DIMENSION NNPLR(MXREGN),GNLR(LTMXNP,MXREGN)
C
      DATA NPPROB/-1/
C
      IF(NPPROB.EQ.(-1) .and. nstrf.eq.0) REWIND 11
      IF(NPPROB.NE.NPROB .and. nstrf.eq.0) THEN
        IF(IPNTS.EQ.0) THEN
          WRITE(11) TITLE,NPROB,NNP,NEL,NBNP,NBES,NTI,NREGN,NVNP
          WRITE(11) ((X(N,I),I=1,3),N=1,NNP),
     >     ((IE(M,I),M=1,NEL),I=1,11),((DCOSB(I,M),I=1,3),M=1,NBES),
     >     ((ISB(I,M),I=1,6),M=1,NBES),(NPBB(N),N=1,NBNP),(NNPLR(N),N=1,
     >     NREGN),((GNLR(N,I),N=1,LTMXNP),I=1,NREGN)
        ELSE
          WRITE(11) TITLE,NPROB,NNP,NEL,NBNP,NBES,NTI,NVNP
          WRITE(11) ((X(N,I),I=1,3),N=1,NNP),
     1     ((IE(M,I),M=1,NEL),I=1,11),((DCOSB(I,M),I=1,3),M=1,NBES),
     2     ((ISB(I,M),I=1,6),M=1,NBES),(NPBB(N),N=1,NBNP)
        END IF
        NPPROB=NPROB
C
      ELSE 
C
        WRITE(11) JTM,TIME,(H(N),N=1,NNP),(HT(N),N=1,NNP),(IE(M,11),
     >    M=1,NEL),((TH(M,I),I=1,8),M=1,NEL),((V(N,I),I=1,3),N=1,NNP),
     >    ((INDRS(N,I),I=1,3),N=1,NVNP),((AKHC(I,M),I=1,8),M=1,NEL)      3/15/95
C
      ENDIF
      RETURN
      END
C
C
C
      SUBROUTINE FSFLOW(X,IE,NLRL,LRL,H,HP,V,TH,DTH,AKHC,PROP,ISTYPt,
     1 SOST,IWTYPT,WSST,C,BFLX, DCOSB,ISB,NPBB, LES,SOS,ISTYP,WSS,IWTYP,
c     2 NPW,NPVB,NPDB,NPCB,NPNB, DINTS,RHOMU,  DELT, KFLOW,IQUAR,IRHO)
     2 NPW,NPVB,NPDB,NPCB,NPNB, DINTS, DELT, KFLOW,IQUAR,IRHO)
C
C********1*********2*********3*********4*********5*********6*********7**
C
C ------- TO COMPUTE WATER FLUXES, INCREMENTAL FLOW, AND ACCUMULATED
C ------- FLOW THROUGH ALL TYPES OF BOUNDARIES AND CHANGE OF WATER
C ------- STORED IN THE REGION OF INTEREST.
C
C********1*********2*********3*********4*********5*********6*********7**
C
C ------- INPUT: X(NNP,3), IE(NEL,9), H(NNP), HP(NNP),
C -------        V(NNP,3), TH(NEL,8), DTH(8,NEL),
C -------        DCOSB(3,NBES), ISB(6,NBES), NPBB(NBNP), LES(NSEL),
C -------        SOS(NSPR), ISTYP(NSEL),  WSS(NWPR),
C -------        IWTYP(NWNP), NPVB(NVNP), NPDB(NDNP), NPCB(NCNP),
C -------        NPNB(NNNP), DELT, KFLOW.
C
C ------- OUTPUT: FRATE(10), FLOW(10), TFLOW(10).
C
C ------- WORKING ARRAYS: BFLX(NBNP,2)
C
C********1*********2*********3*********4*********5*********6*********7**
C
      IMPLICIT REAL*8(A-H,O-Z)
C
      COMMON /SGEOM/ MAXEL,MAXNP,MXADNP,MAXBES,MXTUBS,MAXBNP,MXJBD,
     >               MXKBD,MXNTI,MXDTC
      COMMON /CGEOM/ NNP,NEL,NBNP,NTUBS,NBES,NTI,NDTCHG,ISHAPE
      COMMON /SCMTL/ MAXMAT,MXSPPM,MXMPPM,NMAT,NMPPM,NSPPM
C
      COMMON /FCS/ MXSEL,MXSPR,MXSDP,NSEL,NSPR,NSDP,KSAI
      COMMON /FCW/ MXWNP,MXWPR,MXWDP,NWNP,NWPR,NWDP,KWAI
C
      COMMON /FVBC/ MXVES,MXVNP,MXVPR,MXVDP,NVES,NVNP,NVPR,NVDP,KVAI
      COMMON /FDBC/ MXDNP,MXDPR,MXDDP,NDNP,NDPR,NDDP,KDAI
      COMMON /FCBC/ MXCNP,MXCES,MXCPR,MXCDP,NCNP,NCES,NCPR,NCDP,KCAI
      COMMON /FNBC/ MXNNP,MXNES,MXNPR,MXNDP,NNNP,NNES,NNPR,NNDP,KNAI
      COMMON /CELS/ MXSELt,MXSPRt,MXSDPt,NSELt,NSPRt,NSDPt,KSAIt
      COMMON /CNPS/ MXWNPt,MXWPRt,MXWDPt,NWNPt,NWPRt,NWDPt,KWAIt
C
      COMMON /CHEM/ MXNCC,NCC
C
      COMMON /FFLOW/ FRATE(10),FLOW(10),TFLOW(10)
C
      DIMENSION X(MAXNP,3),IE(MAXEL,11),C(MAXNP,MXNCC)
      DIMENSION NLRL(MAXNP),LRL(MXKBD,MAXNP)
C
      DIMENSION H(MAXNP),HP(MAXNP),V(MAXNP,3),AKHC(8,MAXEL)
      DIMENSION TH(MAXEL,8),DTH(MAXEL,8),PROP(MAXMAT)
c      DIMENSION DINTS(MXNCC),RHOMU(MXNCC)
      DIMENSION DINTS(MXNCC)
C
      DIMENSION BFLX(MAXBNP,2)
      DIMENSION DCOSB(3,MAXBES),ISB(6,MAXBES),NPBB(MAXBNP)
C
      DIMENSION SOS(MXSPR),LES(MXSEL),ISTYP(MXSEL)
      DIMENSION WSS(MXWPR),IWTYP(MXWNP),NPW(MXWNP)
      DIMENSION ISTYPT(MXSELT,MXNCC),SOST(MXSPRT)
      DIMENSION IWTYPT(MXWNPT,MXNCC),WSST(MXWPRT)
C
      DIMENSION NPVB(MXVNP),NPDB(MXDNP),NPCB(MXCNP),NPNB(MXNNP)
C
      DIMENSION XQ(8),YQ(8),ZQ(8),DHQ(8),THG(8)
      DIMENSION R1Q(4),R2Q(4),F1Q(4),F2Q(4),RHOQ(8),XXQ(4),YYQ(4),ZZQ(4)
C
      DIMENSION KGB(4,6,3)
C
      DATA KGB/1,4,8,5, 1,2,6,5, 2,3,7,6, 4,3,7,8, 1,2,3,4, 5,6,7,8,
     >         1,3,6,4, 1,4,5,2, 2,5,6,3, 1,2,3,0, 4,5,6,0, 0,0,0,0,
     >         4,3,2,0, 4,1,3,0, 4,2,1,0, 1,2,3,0, 0,0,0,0, 0,0,0,0/
      DATA QSOS/0.0D0/
C
      DO 110 NP=1,NBNP
      BFLX(NP,1)=BFLX(NP,2)
      BFLX(NP,2)=0.0
  110 CONTINUE
C
C ******* CALCULATE VOLUMETRIC FLOW RATE THROUGH ALL BOUNDARY NODES.
C
      DO 170 MP=1,NBES
C
        LS=ISB(5,MP)
        M=ISB(6,MP)
        IF(IE(M,5).EQ.0)THEN
          IK=3
        ELSEIF(IE(M,7).EQ.0)THEN
          IK=2
        ELSE
          IK=1
        ENDIF
C
        NODE=4
        DO 120 IQ=1,4
          I=KGB(IQ,LS,IK)
          IF(I.EQ.0 .AND. IQ.EQ.4)THEN
            NODE=3
            GOTO 120
          ENDIF
          NI=IE(M,I)
          XXQ(IQ)=X(NI,1)
          YYQ(IQ)=X(NI,2)
          ZZQ(IQ)=X(NI,3)
          F1Q(IQ)=DCOSB(1,MP)*V(NI,1)+DCOSB(2,MP)*V(NI,2)+
     >            DCOSB(3,MP)*V(NI,3)
          F2Q(IQ)=0.0
          RHOQ(IQ)=1.0D0
  120   CONTINUE
C
        CALL Q34S(R1Q,R2Q,XXQ,YYQ,ZZQ,F1Q,F2Q,RHOQ,NODE,IQUAR)
C
        DO 140 IQ=1,NODE
          NII=ISB(IQ,MP)
          BFLX(NII,2)=BFLX(NII,2)+R1Q(IQ)
  140   CONTINUE
  170 CONTINUE
C
      IF (KFLOW.GT.0) GO TO 200
      DO 180 NP=1,NBNP
      BFLX(NP,1)=BFLX(NP,2)
  180 CONTINUE
C
      DO 190 I=1,9
  190 TFLOW(I)=0.0
C
C ******* DETERMINE TOTAL FLOWS AND TOTAL FLOW RATES THROUGH VARIOUS
C ******* TYPES OF BOUNDARIES, STARTING WITH THE NET FLOWS THROUGH THE
C ******* ENTIRE BOUNDARY.
C
  200 SUM=0.
      SUMP=0.
      DO 210 NP=1,NBNP
        SUM=SUM+BFLX(NP,2)
        SUMP=SUMP+BFLX(NP,1)
  210 CONTINUE
C
      FRATE(7)=SUM
      FLOW(7)=0.5D0*(SUM+SUMP)*DELT
C
C ******* THE DIRICHLET BOUNDARY
C
      FRATE(1)=0.
      FLOW(1)=0.
      IF(NDNP.LE.0) GO TO 400
      SUM=0.
      SUMP=0.
      DO 330 NPP=1,NDNP
        NP=NPDB(NPP)
        DO 310 I=1,NBNP
          IJ=NPBB(I)
          IF(IJ.NE.NP) GO TO 310
          NII=I
          GO TO 320
  310   CONTINUE
  320   CONTINUE
        SUM=SUM+BFLX(NII,2)
        SUMP=SUMP+BFLX(NII,1)
  330 CONTINUE
      FRATE(1)=SUM
      FLOW(1)=0.5D0*(SUM+SUMP)*DELT
C
C
C ******* THE CAUCHY BOUNDARY
C
  400 FRATE(2)=0.0
      FLOW(2)=0.0
      IF(NCNP.LE.0) GO TO 500
      SUM=0.0
      SUMP=0.0
      DO 430 NPP=1,NCNP
        NII=NPCB(NPP)
        SUM=SUM+BFLX(NII,2)
        SUMP=SUMP+BFLX(NII,1)
  430 CONTINUE
      FRATE(2)=SUM
      FLOW(2)=0.5D0*(SUM+SUMP)*DELT
C
C
C ******* THE NEUMANN BOUNDARY
C
  500 FRATE(3)=0.
      FLOW(3)=0.
      IF(NNNP.LE.0) GO TO 600
      SUM=0.
      SUMP=0.
      DO 530 NPP=1,NNNP
        NII=NPNB(NPP)
        SUM=SUM+BFLX(NII,2)
        SUMP=SUMP+BFLX(NII,1)
  530 CONTINUE
      FRATE(3)=SUM
      FLOW(3)=0.5D0*(SUM+SUMP)*DELT
C
C ******* THE RAINFALL-SEEPAGE BOUNDARY
C
  600 FRATE(4)=0.
      FLOW(4)=0.
      FRATE(5)=0.
      FLOW(5)=0.
      IF(NVNP.LE.0) GO TO 700
      SUMS=0.
      SUMSP=0.
      SUMR=0.
      SUMRP=0.
      DO 640 NPP=1,NVNP
        NII=NPVB(NPP)
        BFLXA=BFLX(NII,2)
        IF (BFLXA.LT.0.D0) GO TO 630
        SUMS=SUMS+BFLX(NII,2)
        SUMSP=SUMSP+BFLX(NII,1)
        GO TO 640
  630   SUMR=SUMR+BFLX(NII,2)
        SUMRP=SUMRP+BFLX(NII,1)
  640 CONTINUE
      FRATE(4)=SUMS
      FLOW(4)=0.5D0*(SUMS+SUMSP)*DELT
      FRATE(5)=SUMR
      FLOW(5)=0.5D0*(SUMR+SUMRP)*DELT
C
C ******* THE UNSPECIFIED BOUNDARY, I. E. BOUNDARY WITH ZERO TOTAL FLUX
C
  700 SUM=0.
      SUMP=0.
      DO 710 I=1,5
      SUM=SUM+FRATE(I)
  710 SUMP=SUMP+FLOW(I)
      FRATE(6)=FRATE(7)-SUM
      FLOW(6)=FLOW(7)-SUMP
C
C ******* CALCULATE THE INCREASE IN THE WATER CONTENT AND THE SOURCE
C
      QSOSP=QSOS
      QSOS=0.0
      QTH=0.
      DO 850 M=1,NEL
C
        CALL ELENOD
     I      (IE(M,5),IE(M,7),
     O       NODE,MP,MP)
C
        SOURCE=0.0
        IF(NSEL.EQ.0) GO TO 830
        DO 810 MP=1,NSEL
          MS=LES(MP)
          IF(MS.NE.M) GO TO 810
          ITYP=ISTYP(MP)
          SOURCE=SOS(ITYP)
          IF(SOURCE.GT.0.0D0 .AND. IRHO.EQ.1)THEN
            MTYP=IE(MS,9)
            RHOW=PROP(MTYP)
            DO K=1,NCC
              ITYP=ISTYPT(I,K)
              RHOQ(K)=SOST(ITYP)
            ENDDO
c            CALL RHOFUN(RHOSTR,AMU,RHOW,DINTS,RHOQ,RHOMU)
            CALL RHOFUN(RHOSTR,AMU,RHOW,DINTS,RHOQ)
            SOURCE=SOURCE*RHOSTR
          ENDIF
          GO TO 830
  810   CONTINUE
C
  830   DO 840 IQ=1,NODE
          NP=IE(M,IQ)
          XQ(IQ)=X(NP,1)
          YQ(IQ)=X(NP,2)
          ZQ(IQ)=X(NP,3)
          RHOQ(IQ)=AKHC(IQ,M)
          DHQ(IQ)=H(NP)-HP(NP)
          IF(KFLOW.LE.0) DHQ(IQ)=1.0D0
          THG(IQ)=TH(M,IQ)
          IF(KFLOW.GT.0) THG(IQ)=DTH(M,IQ)
  840   CONTINUE
C
        CALL Q468TH(QTHM,QSOSM,DHQ,THG,XQ,YQ,ZQ,SOURCE,NODE,IQUAR,RHOQ)
C
        QSOS=QSOS-QSOSM
        QTH=QTH+QTHM
  850 CONTINUE
C
      IF(NWNP.EQ.0) GO TO 870
      DO 860 I=1,NWNP
        ITYP=IWTYP(I)
        WSSK=WSS(ITYP)
        NI=NPW(I)
        IF(IRHO.EQ.1)THEN
          RHO=0.0D0
          VOLT=0.0D0
          DO J=1,NLRL(NI)
            MP=LRL(J,NI)
            MTYP=IE(MP,9)
            CALL VOLUME
     I          (MAXNP,MAXEL,X(1,1),X(1,2),X(1,3),IE,MP,
     O           VOL)
            RHO=RHO+PROP(MTYP)*VOL
            VOLT=VOLT+VOL
          ENDDO
          RHOW=RHO/VOLT
C
          IF(WSSK.GT.0.0D0)THEN
            DO K=1,NCC
              ITYP=IWTYPT(I,K)
              RHOQ(K)=WSST(ITYP)
            ENDDO
          ELSEIF(WSSK.LT.0.0D0)THEN
            DO K=1,NCC
              RHOQ(K)=C(NI,K)
            ENDDO
          ENDIF
c          CALL RHOFUN(RHO,AMU,RHOW,DINTS,RHOQ,RHOMU)
          CALL RHOFUN(RHO,AMU,RHOW,DINTS,RHOQ)
          WSSK=WSSK*RHO
        ENDIF
      QSOS=QSOS-WSSK
  860 CONTINUE
  870 CONTINUE
C
      IF(KFLOW.GT.0) GO TO 880
      QSOSP=QSOS
C
  880 FRATE(8)=QSOS
      FLOW(8)=0.5D0*(QSOS+QSOSP)*DELT
      FLOW(9)=QTH
      FRATE(9)=FLOW(9)/DELT
      IF(KFLOW.LE.0) FRATE(9)=-(FRATE(7)+FRATE(8))
C
      DO 910 I=1,9
  910 TFLOW(I)=TFLOW(I)+FLOW(I)
C
      RETURN
      END
C
C
C
      SUBROUTINE Q468TH(QTHM,QSOSM,DHQ,THG,XQ,YQ,ZQ,SOURCE,NODE,IQUAR,
     >                  RHOQ)
C
C********1*********2*********3*********4*********5*********6*********7**
C
C ------- TO COMPUTE WATER CONTENT INTEGRATION AND ELEMENT SOURCE
C ------- INTEGRATION OVER AN ELEMENT.
C
C********1*********2*********3*********4*********5*********6*********7**
C
C ------- INPUT: DHQ(8), THG(8), XQ(8), YQ(8), ZQ(8), SOURCE.
C
C ------- OUTPUT: QTHM, QSOSM.
C
C********1*********2*********3*********4*********5*********6*********7**
C
      IMPLICIT REAL*8 (A-H,O-Z)
      REAL*8 N(8),L1(3),L2(3),L3(3),LL1(4),LL2(4),LL3(4),LL4(4)
C
      DIMENSION DHQ(8),THG(8), XQ(8),YQ(8),ZQ(8),DNX(8),DNY(8),DNZ(8)
      DIMENSION S(8),T(8),U(8), W(8),RHOQ(8)
C
      DATA S/-1.0D0,1.0D0,1.0D0,-1.0D0, -1.0D0,1.0D0,1.0D0,-1.0D0/
      DATA T/-1.0D0,-1.0D0,1.0D0,1.0D0, -1.0D0,-1.0D0,1.0D0,1.0D0/
      DATA U/-1.0D0,-1.0D0,-1.0D0,-1.0D0, 1.0D0,1.0D0,1.0D0,1.0D0/
C
      IF(IQUAR.EQ.1 .OR. IQUAR.EQ.3)THEN
        P=0.577350269189626D0
        L1(1)=0.666666666666667D0
        L1(2)=0.166666666666667D0
        L1(3)=0.166666666666667D0
        L2(1)=0.166666666666667D0
        L2(2)=0.666666666666667D0
        L2(3)=0.166666666666667D0
        L3(1)=0.166666666666667D0
        L3(2)=0.166666666666667D0
        L3(3)=0.666666666666667D0
        LL1(1)=0.58541020D0
        LL1(2)=0.13819660D0
        LL1(3)=0.13819660D0
        LL1(4)=0.13819660D0
        LL2(1)=0.13819660D0
        LL2(2)=0.58541020D0
        LL2(3)=0.13819660D0
        LL2(4)=0.13819660D0
        LL3(1)=0.13819660D0
        LL3(2)=0.13819660D0
        LL3(3)=0.58541020D0
        LL3(4)=0.13819660D0
        LL4(1)=0.13819660D0
        LL4(2)=0.13819660D0
        LL4(3)=0.13819660D0
        LL4(4)=0.58541020D0
      ELSE
        P=1.0D0
        L1(1)=1.0D0
        L1(2)=0.0D0
        L1(3)=0.0D0
        L2(1)=0.0D0
        L2(2)=1.0D0
        L2(3)=0.0D0
        L3(1)=0.0D0
        L3(2)=0.0D0
        L3(3)=1.0D0
        LL1(1)=1.0D0
        LL1(2)=0.0D0
        LL1(3)=0.0D0
        LL1(4)=0.0D0
        LL2(1)=0.0D0
        LL2(2)=1.0D0
        LL2(3)=0.0D0
        LL2(4)=0.0D0
        LL3(1)=0.0D0
        LL3(2)=0.0D0
        LL3(3)=1.0D0
        LL3(4)=0.0D0
        LL4(1)=0.0D0
        LL4(2)=0.0D0
        LL4(3)=0.0D0
        LL4(4)=1.0D0
      ENDIF
C
      QSOSM=0.0
      QTHM=0.
      DO 490 KG=1,NODE
C
C ------- DETERMINE LOACAL COORDINATE OF GAUSSIAN POINT KG
C
C ------- CALCULATE VALUES OF BASIS FUNCTIONS N(IQ).
C
C
        IF(NODE.EQ.8)THEN
          SS=P*S(KG)
          TT=P*T(KG)
          UU=P*U(KG)
          CALL SHAPE
     I      (XQ,YQ,ZQ, SS,TT,UU, XSI,DL1,DL2,DL3, D1,D2,D3,D4, NODE,0,
     O       N,DNX,DNY,DNZ,W,DJAC)
        ELSEIF(NODE.EQ.6)THEN
          IF(KG.LE.3)THEN
            XSI=-P
            KKG=KG
          ELSE
            XSI=P
            KKG=KG-3
          ENDIF
          DL1=L1(KKG)
          DL2=L2(KKG)
          DL3=L3(KKG)
          CALL SHAPE
     I      (XQ,YQ,ZQ, SS,TT,UU, XSI,DL1,DL2,DL3, D1,D2,D3,D4, NODE,0,
     O       N,DNX,DNY,DNZ,W,DJAC)
          DJAC=DJAC/3.0D0
        ELSEIF(NODE.EQ.4)THEN
          D1=LL1(KG)
          D2=LL2(KG)
          D3=LL3(KG)
          D4=LL4(KG)
          CALL SHAPE
     I      (XQ,YQ,ZQ, SS,TT,UU, XSI,DL1,DL2,DL3, D1,D2,D3,D4, NODE,0,
     O       N,DNX,DNY,DNZ,W,DJAC)
          DJAC=DJAC*0.25D0
        ENDIF
C
C ------- INTERPOLATE TO OBTAIN WATER CONTENT AT THE GAUSSIAN POINT KG
C
        DHQP=0.0
        DO 390 IQ=1,NODE
          DHQP=DHQP+DHQ(IQ)*N(IQ)
  390   CONTINUE
C
        THQP=DHQP*THG(KG)
C
C ------- ACCUMULATE THE SUM TO EVALUATE THE INTEGRAL
C
        QSOSM=QSOSM+SOURCE*DJAC*RHOQ(KG)
        QTHM=QTHM+THQP*DJAC
  490 CONTINUE
C
      RETURN
      END
C
C
C
c      SUBROUTINE SPROP(AKHC,TH,DTH,X,H,C,IE,PROP,DINTS,RHOMU,SPP,
      SUBROUTINE SPROP(AKHC,TH,DTH,X,H,C,IE,PROP,DINTS,SPP,
     >                 IRHO,IQUAR,KSP,cnstkr)
C
      IMPLICIT REAL*8(A-H,O-Z)
      REAL*8 N(8),L1(3),L2(3),L3(3),LL1(4),LL2(4),LL3(4),LL4(4)
C
C********1*********2*********3*********4*********5*********6********7**
C
C ------- TO COMPUTE HYDRAULIC CONDUCTIVITY OR PERMEABILITY,
C ------- MOISTURE CONTENT, AND WATER CAPACITY GIVEN THE PRESSURE HEAD
C ------- AND CONCENTRATION
C
C********1*********2*********3*********4*********5*********6*********7**
C
C ------- INPUT: H(NNP),X(NNP,3),IE(NEL,9),
C -------        LRL(MXKBD,NNP), H(NNP), SPP(NSPPM,NMAT,4), KSP.
C
C ------- OUTPUT: AKHC(8,NEL,7), TH(NEL,8), DTH(NEL,8).
C
C********1*********2*********3*********4*********5*********6*********7**
C
      COMMON /SGEOM/ MAXEL,MAXNP,MXADNP,MAXBES,MXTUBS,MAXBNP,MXJBD,
     >               MXKBD,MXNTI,MXDTC
      COMMON /CGEOM/ NNP,NEL,NBNP,NTUBS,NBES,NTI,NDTCHG,ISHAPE
      COMMON /SCMTL/ MAXMAT,MXSPPM,MXMPPM,NMAT,NMPPM,NSPPM
      COMMON /CHEM/ MXNCC,NCC
C
      DIMENSION AKHC(8,MAXEL,7),TH(MAXEL,8),DTH(MAXEL,8),H(MAXNP)
      DIMENSION IE(MAXEL,11),X(MAXNP,3),C(MAXNP,MXNCC)
C
      DIMENSION PROP(MAXMAT,MXMPPM),SPP(MXSPPM,MAXMAT,4)
c      DIMENSION RHOMU(MXNCC),DINTS(MXNCC)
      DIMENSION DINTS(MXNCC)
C
      DIMENSION HQ(8), S(8),T(8),U(8), HKG(8),CQ(8,7),CKG(7,8)
      DIMENSION XQ(8),YQ(8),ZQ(8),DNX(8),DNY(8),DNZ(8),W(8)
C
      DATA S/-1.0D0,1.0D0,1.0D0,-1.0D0,-1.0D0,1.0D0,1.0D0,-1.0D0/
      DATA T/-1.0D0,-1.0D0,1.0D0,1.0D0,-1.0D0,-1.0D0,1.0D0,1.0D0/
      DATA U/-1.0D0,-1.0D0,-1.0D0,-1.0D0,1.0D0,1.0D0,1.0D0,1.0D0/
C
      IF(IQUAR.EQ.1 .OR. IQUAR.EQ.3)THEN
        P=0.577350269189626D0
        L1(1)=0.666666666666667D0
        L1(2)=0.166666666666667D0
        L1(3)=0.166666666666667D0
        L2(1)=0.166666666666667D0
        L2(2)=0.666666666666667D0
        L2(3)=0.166666666666667D0
        L3(1)=0.166666666666667D0
        L3(2)=0.166666666666667D0
        L3(3)=0.666666666666667D0
        LL1(1)=0.58541020D0
        LL1(2)=0.13819660D0
        LL1(3)=0.13819660D0
        LL1(4)=0.13819660D0
        LL2(1)=0.13819660D0
        LL2(2)=0.58541020D0
        LL2(3)=0.13819660D0
        LL2(4)=0.13819660D0
        LL3(1)=0.13819660D0
        LL3(2)=0.13819660D0
        LL3(3)=0.58541020D0
        LL3(4)=0.13819660D0
        LL4(1)=0.13819660D0
        LL4(2)=0.13819660D0
        LL4(3)=0.13819660D0
        LL4(4)=0.58541020D0
      ELSE
        P=1.0D0
        L1(1)=1.0D0
        L1(2)=0.0D0
        L1(3)=0.0D0
        L2(1)=0.0D0
        L2(2)=1.0D0
        L2(3)=0.0D0
        L3(1)=0.0D0
        L3(2)=0.0D0
        L3(3)=1.0D0
        LL1(1)=1.0D0
        LL1(2)=0.0D0
        LL1(3)=0.0D0
        LL1(4)=0.0D0
        LL2(1)=0.0D0
        LL2(2)=1.0D0
        LL2(3)=0.0D0
        LL2(4)=0.0D0
        LL3(1)=0.0D0
        LL3(2)=0.0D0
        LL3(3)=1.0D0
        LL3(4)=0.0D0
        LL4(1)=0.0D0
        LL4(2)=0.0D0
        LL4(3)=0.0D0
        LL4(4)=1.0D0
      ENDIF
C
C ------- INITIATE ARRAY AKHC
C
      DO 100 M=1,NEL
      DO 100 KG=1,8
      DO 100 I=1,7
      AKHC(KG,M,I)=0.0D0
  100 CONTINUE
C
C ******* TH AND DTH/DH ARE OBTAINED BY TABLE OR ANALYTICALLY.
C
      DO 490 M=1,NEL
C
        CALL ELENOD
     I      (IE(M,5),IE(M,7),
     O       NODE,IQ,IQ)
        DO 110 IQ=1,NODE
          NP=IE(M,IQ)
          DO K=1,NCC
            CQ(IQ,K)=C(NP,K)
          ENDDO
          HQ(IQ)=H(NP)
          XQ(IQ)=X(NP,1)
          YQ(IQ)=X(NP,2)
          ZQ(IQ)=X(NP,3)
  110   CONTINUE
C
C ------- EVALUATE PRESSURE AT FOUR GAUSSIAN POINTS FOR QUADRILATERAL
C ------- ELEMENT.
C
        DO 150 KG=1,NODE
          IF(NODE.EQ.8)THEN
            SS=P*S(KG)
            TT=P*T(KG)
            UU=P*U(KG)
            CALL SHAPE
     I        (XQ,YQ,ZQ, SS,TT,UU, XSI,DL1,DL2,DL3, D1,D2,D3,D4, NODE,0,
     O         N,DNX,DNY,DNZ,W,DJAC)
          ELSEIF(NODE.EQ.6)THEN
            IF(KG.LE.3)THEN
              XSI=-P
              KKG=KG
            ELSE
              XSI=P
              KKG=KG-3
            ENDIF
            DL1=L1(KKG)
            DL2=L2(KKG)
            DL3=L3(KKG)
            CALL SHAPE
     I        (XQ,YQ,ZQ, SS,TT,UU, XSI,DL1,DL2,DL3, D1,D2,D3,D4, NODE,0,
     O         N,DNX,DNY,DNZ,W,DJAC)
          ELSEIF(NODE.EQ.4)THEN
            D1=LL1(KG)
            D2=LL2(KG)
            D3=LL3(KG)
            D4=LL4(KG)
            CALL SHAPE
     I        (XQ,YQ,ZQ, SS,TT,UU, XSI,DL1,DL2,DL3, D1,D2,D3,D4, NODE,0,
     O         N,DNX,DNY,DNZ,W,DJAC)
          ENDIF
          HKG(KG)=0.0
          DO K=1,NCC
            CKG(K,KG)=0.0
          ENDDO
          DO 120 IQ=1,NODE
            HKG(KG)=HKG(KG)+HQ(IQ)*N(IQ)
            DO K=1,NCC
              CKG(K,KG)=CKG(K,KG)+CQ(IQ,K)*N(IQ)
            ENDDO
  120     CONTINUE
  150   CONTINUE
C
        MTYP=IE(M,9)
        SATKX=PROP(MTYP,1)
        SATKY=PROP(MTYP,2)
        SATKZ=PROP(MTYP,3)
        SATKXY=PROP(MTYP,4)
        SATKXZ=PROP(MTYP,5)
        SATKYZ=PROP(MTYP,6)
        RHOTYP=PROP(MTYP,7)
C
C %%%%%%% TH AND DTH/DH ARE OBTAINED BY TABLE
C
        DO 290 KG=1,NODE
          NP=IE(M,KG)
          HNP=HKG(KG)
          HNP=-HNP
C
          CALL SPFUNC
     I    (HNP,SPP,MTYP,KSP,SATKX,SATKY,SATKZ,SATKXY,SATKXZ,SATKYZ,
c     I     CKG(1,KG),0,IRHO,RHOMU,DINTS,RHOTYP,cnstkr,
     I     CKG(1,KG),0,IRHO,DINTS,RHOTYP,cnstkr,
     O     TH(M,KG),DTH(M,KG),AKHC(KG,M,1),AKHC(KG,M,2),AKHC(KG,M,3),
     O     AKHC(KG,M,4),AKHC(KG,M,5),AKHC(KG,M,6),AKHC(KG,M,7))
C
C
  290   CONTINUE
  490 CONTINUE
C
      RETURN
      END
C
C
c
      SUBROUTINE SPFUNC
     I          (HNP,SPP,MTYP,KSP,SATKX,SATKY,SATKZ,SATKXY,SATKXZ,
c     I           SATKYZ,CKG,ISP,IRHO,RHOMU,DINTS,RHOTYP,cnstkr, 
     I           SATKYZ,CKG,ISP,IRHO,DINTS,RHOTYP,cnstkr,
     O           TH,DTH,AKHCX,AKHCY,AKHCZ,AKHCXY,AKHCXZ,AKHCYZ,RHOM)
C                                                                               
      IMPLICIT REAL*8(A-H,O-Z)
C
      COMMON /SCMTL/ MAXMAT,MXSPPM,MXMPPM,NMAT,NMPPM,NSPPM
      COMMON /CHEM/ MXNCC,NCC
C                                                                               
c      DIMENSION SPP(MXSPPM,MAXMAT,4),RHOMU(MXNCC),DINTS(MXNCC)
      DIMENSION SPP(MXSPPM,MAXMAT,4),DINTS(MXNCC)
      DIMENSION CKG(7)
C
C
C ----- COMPUTE RHO/RHOW
C
      RHOM=1.0D0
      AMU=1.0D0
c      IF(IRHO.EQ.1) CALL RHOFUN(RHOM,AMU,RHOTYP,DINTS,CKG,RHOMU)
      IF(IRHO.EQ.1) CALL RHOFUN(RHOM,AMU,RHOTYP,DINTS,CKG)
C
      IF(KSP.EQ.1) THEN
        HNP=-HNP
C
C ------- TH, DTH/DH, AKX, AKZ, AND AKXZ ARE OBTAINED BY TABLE
C
        IF(HNP.GT.SPP(1,MTYP,4)) GO TO 200
C
C ------- FOR CASE  WHEN PRESSURE IS LESS THAN MINIMUM TABULET VALUE.
C
        JL=1
        JU=2
        A=0.0
        GO TO 400
C
  200   IF(HNP.LT.SPP(NSPPM,MTYP,4)) GO TO 250
C
C ------- FOR CASE  WHEN PRESSURE IS  GT THAN MAXIMUM TABULET VALUE.
C
        JL=NSPPM
        JU=1
        A=0.0
        GO TO 400
C
C ------- FOR CASE  WHEN PRESSURE LIES BETWEEN TABULET VALUES.
C
  250   DO 300 J=2,NSPPM
          JU=J
          IF(SPP(J,MTYP,4).GT.HNP) GO TO 350
  300   CONTINUE
  350   JL=JU-1
        A=(HNP-SPP(JL,MTYP,4))/(SPP(JU,MTYP,4)-SPP(JL,MTYP,4))
C
C ------- THREE CASES MERGE HERE.                                               
C
  400   TH=SPP(JL,MTYP,1)+A*(SPP(JU,MTYP,1)-SPP(JL,MTYP,1))
        IF(ISP.EQ.1)GOTO 900
        DTH=SPP(JL,MTYP,3)+A*(SPP(JU,MTYP,3)-SPP(JL,MTYP,3))
        USKFCT=SPP(JL,MTYP,2)+A*(SPP(JU,MTYP,2)-SPP(JL,MTYP,2))
        if(uskfct.lt.cnstkr)uskfct=cnstkr
C
        AKHCX=SATKX*USKFCT*RHOM/AMU
        AKHCY=SATKY*USKFCT*RHOM/AMU
        AKHCZ=SATKZ*USKFCT*RHOM/AMU
        AKHCXY=SATKXY*USKFCT*RHOM/AMU
        AKHCXZ=SATKXZ*USKFCT*RHOM/AMU
        AKHCYZ=SATKYZ*USKFCT*RHOM/AMU
C
      ELSE
C
C
C ------- TH, DTH/DH, AKX, AKZ, AND AKXZ ARE OBTAINED ANALYTICALLY.
C ------- THE READER MUST SUPPLY THE FUNCTIONAL FORM OF FKX, FKZ, AND
C ------- FTH BELOW
C
C ------- THE FOLLOWING IS JUST AN EXAMPLE.
C ------- WCR= THPROP(MTYP,1)=0.065, 0.050 FOR TWO SAMPLE MATERIALS
C ------- WCS=THPROP(MTYP,2)=0.364, 0.341 FOR TWO SAMPLE MATERIALS
C ------- RN=THPROP(MTYP,3)=1.092217, 1.546937 FOR TWO SAMPLE MATERIALS
C ------- ALPH=THPROP(MTYP,4)=0.109, 0.002166 FOR TWO SAMPLE MATERIALS
C
c ------- soil properties for example 1
c     wcr=spp(1,mtyp,1)
c     wcs=spp(2,mtyp,1)
c     haa=spp(3,mtyp,1)
c     hab=spp(4,mtyp,1)
c ------- soil properties for example 2
c     wcr=spp(1,mtyp,1)
c     wcs=spp(2,mtyp,1)
c     haa=spp(3,mtyp,1)
c     thaa=spp(4,mtyp,1)
c     thbb=spp(5,mtyp,1)
c     power=spp(1,mtyp,2)
c ------- soil properties for example 3
      wcr=spp(1,mtyp,1)
      wcs=spp(2,mtyp,1)
      haa=spp(3,mtyp,1)
      alpha=spp(4,mtyp,1)
      beta=spp(5,mtyp,1)
c ------- soil properties for adaepa case
c     wcs=spp(1,mtyp,1)
c     hcs=spp(2,mtyp,1)
c     b=spp(3,mtyp,1)
c
c ------- soil properties for adaepa hypothetical case
c
c     wcr=spp(1,mtyp,1)
c     wcs=spp(2,mtyp,1)
c     alpha=spp(3,mtyp,1)
c     alamda=spp(4,mtyp,1)
c     alphai=1.0d0/alpha
C
C ------- SATURATED CONDITION
C
        IF(HNP.LE.0.0) THEN
c
C ------ for adaepa case
c       if(hnp.LE.-hcs) THEN
c
c ------ for adaepa hypothetical case
c       if(hnp.le.alphai) THEN
c
          TH=WCS
          IF(ISP.EQ.1)GOTO 900
          DTH=0.0D0
          USKFCT=1.0D0
C
C ------- UNSATURATED CASE
C
        ELSE
C
c ------- moisture content and relative conductivity for example 1
c         th=wcs-(wcs-wcr)*(-hnp-haa)/(hab-haa)
c         IF(ISP.EQ.1)GOTO 900
c         dth=-(wcs-wcr)/(hab-haa)
c         USKFCT=(th-wcr)/(wcs-wcr)
C
c         th=wcs
c         IF(ISP.EQ.1)GOTO 900
c         dth=0.0d0
c         uskfct=1.0d0
C
c ------- moisture content and relative conductivity for example 2
c         th=wcr+(wcs-wcr)*thaa/(thaa+(DABS(-hnp-haa))**thbb)
c         IF(ISP.EQ.1)GOTO 900
c         dnom=thaa+(DABS(-hnp-haa))**thbb
c         dth=(wcs-wcr)*thaa*(DABS(-hnp-haa))**(thbb-1.0D0)/dnom**2
c         USKFCT=((th-wcr)/(wcs-wcr))**power
C
c ------- moisture content and relative conductivity for example 3
          th=wcr+(wcs-wcr)/(1.0D0+(alpha*DABS(-hnp-haa))**beta)
          IF(ISP.EQ.1)GOTO 900
          dnom=1.0D0+(alpha*DABS(-hnp-haa))**beta
          dth=(wcs-wcr)*(alpha*DABS(-hnp-haa))**(beta-1.0D0)/dnom**2
          USKFCT=((th-wcr)/(wcs-wcr))**2
C
c ------ moisture content and relative conductivity for adaepa case
c         th=wcs*(-hnp/hcs)**(-1.0d0/b)
c         IF(ISP.EQ.1)GOTO 900
c         uskfct=(th/wcs)**(2.0d0*b+3.0)
c         dth=-1.0d0/b*wcs/hcs*(-hnp/hcs)**(-1.0d0/b-1.0d0)
C
c ------ moisture content and Kr for adaepa hypothetical case
c         th=wcr+(wcs-wcr)*(alpha*hnp)**(-alamda)
c         IF(ISP.EQ.1)GOTO 900
c         uskfct=1.0d0/(alpha*hnp)**(alamda*3+2)
c         dth=alpha*alamda*(wcs-wcr)*(alpha*hnp)**(-alamda-1.0d0)
C
        ENDIF
C
        if(uskfct.lt.cnstkr)uskfct=cnstkr
        AKHCX=SATKX*USKFCT*RHOM/AMU
        AKHCY=SATKY*USKFCT*RHOM/AMU
        AKHCZ=SATKZ*USKFCT*RHOM/AMU
        AKHCXY=SATKXY*USKFCT*RHOM/AMU
        AKHCXZ=SATKXZ*USKFCT*RHOM/AMU
        AKHCYZ=SATKYZ*USKFCT*RHOM/AMU
      ENDIF
C
  900 RETURN
      END
C
c
c
      SUBROUTINE VELT(V, CMATRX, X,IE,H,HT,AKHC,IQUAR)
C
C********1*********2*********3*********4*********5*********6*********7**
C
C ------- TO COMPUTE DARCY'S VELOCITY.
C
C********1*********2*********3*********4*********5*********6*********7**
C
C ------- INPUT: X(NNP,3), IE(NEL,9), H(NNP), HT(NNP),
C -------        AKHC(8,NEL,7)
C
C ------- OUTPUT: V(NNP,3)
C
C********1*********2*********3*********4*********5*********6*********7**
C
      IMPLICIT REAL*8(A-H,O-Z)
C
      COMMON /SGEOM/ MAXEL,MAXNP,MXADNP,MAXBES,MXTUBS,MAXBNP,MXJBD,
     >               MXKBD,MXNTI,MXDTC
      COMMON /CGEOM/ NNP,NEL,NBNP,NTUBS,NBES,NTI,NDTCHG,ISHAPE
      COMMON /SCMTL/ MAXMAT,MXSPPM,MXMPPM,NMAT,NMPPM,NSPPM
      COMMON /FINTE/ NCYL,NITER,NPITER,KSP,KGRAV,IPNTS
C
      DIMENSION V(MAXNP,3)
      DIMENSION CMATRX(MXADNP,MXJBD)
      DIMENSION X(MAXNP,3),IE(MAXEL,11)
      DIMENSION H(MAXNP),HT(MAXNP),AKHC(8,MAXEL,7)
C
      DIMENSION QB(8,8),QRX(8),QRY(8),QRZ(8),XQ(8),YQ(8),ZQ(8)
      DIMENSION AKXQ(8),AKYQ(8),AKZQ(8),AKXYQ(8),AKXZQ(8),AKYZQ(8)
      DIMENSION RHOKG(8),HQ(8)
C
      AGRAV=  dble(KGRAV)
C
C ------- INITIATE THE DARCY VELOCITY COMPONETNTS
C
      DO 100 NP=1,NNP
      V(NP,1)=0.0
      V(NP,2)=0.0
      V(NP,3)=0.0
  100 CONTINUE
C
C ------- CALCULATE THE TOTAL HEAD HT(NP)
C
      DO 105 NP=1,NNP
  105 HT(NP)=H(NP) +AGRAV*X(NP,3)
C
C ------- COMPUTE DARCY VELOCITIES BY APPLYING FINITE ELEMENT METHOD TO
C ------- DARCY LAW.
C
C
C ------- INITIATE MATRIX CMATRX(NP,IB)
C
      DO 160 NP=1,NNP
  160 CMATRX(NP,1)=0.0
C
C ------- COMPUTE ELEMENT MATRICES QB(IQ,JQ), QRX(IQ),QRY(IQ),& QRZ(IQ)
C
      DO 290 M=1,NEL
        CALL ELENOD
     I      (IE(M,5),IE(M,7),
     O       NODE,IQ,IQ)
C
        DO 210 IQ=1,NODE
          NP=IE(M,IQ)
          XQ(IQ)=X(NP,1)
          YQ(IQ)=X(NP,2)
          ZQ(IQ)=X(NP,3)
          AKXQ(IQ)=AKHC(IQ,M,1)
          AKYQ(IQ)=AKHC(IQ,M,2)
          AKZQ(IQ)=AKHC(IQ,M,3)
          AKXYQ(IQ)=AKHC(IQ,M,4)
          AKXZQ(IQ)=AKHC(IQ,M,5)
          AKYZQ(IQ)=AKHC(IQ,M,6)
          RHOKG(IQ)=AKHC(IQ,M,7)
          HQ(IQ)=H(NP)
  210   CONTINUE
C
        CALL FQ468DV(QB,QRX,QRY,QRZ, XQ,YQ,ZQ,AKXQ,AKYQ,AKZQ,
     1    AKXYQ,AKXZQ,AKYZQ,RHOKG,HQ,AGRAV,NODE,IQUAR)
C
C ------- ASSEMBLE QB(IQ,JQ) INTO THE GLOBAL MATRIX CMATRX(NP,IB) AND
C ------- FORM THE LOAD VECTOR VX(NP), VY(NP), AND VZ(NP).
C
        DO 280 IQ=1,NODE
          NI=IE(M,IQ)
          DO 240 JQ=1,NODE
            CMATRX(NI,1)=CMATRX(NI,1)+QB(IQ,JQ)
  240     CONTINUE
C
          V(NI,1)=V(NI,1)+QRX(IQ)
          V(NI,2)=V(NI,2)+QRY(IQ)
          V(NI,3)=V(NI,3)+QRZ(IQ)
  280   CONTINUE
C
  290 CONTINUE
C
C ------- SOLVE THE MATRIX EQUATION CX=B
C
      DO 370 NP=1,NNP
        V(NP,1)=V(NP,1)/CMATRX(NP,1)
        V(NP,2)=V(NP,2)/CMATRX(NP,1)
        V(NP,3)=V(NP,3)/CMATRX(NP,1)
  370 CONTINUE
C
      RETURN
      END
C
C
C
      SUBROUTINE FQ468DV(QB,QRX,QRY,QRZ, XQ,YQ,ZQ,AKXQ,AKYQ,AKZQ,
     1 AKXYQ,AKXZQ,AKYZQ,RHOKG,HQ,AGRAV,NODE,IQUAR)
C
C********1*********2*********3*********4*********5*********6*********7**
C
C ------- TO COMPUTE THE INTEGRATION OF N(I)*N(J) AND -N(I)*K.GRAD(HT)
C
C********1*********2*********3*********4*********5*********6*********7**
C
C ------- INPUT: XQ(8), YQ(8), ZQ(8), HTQ(8), AKXQ(8), AKYQ(8), AKZQ(8),
C -------        AKXYQ(8), AKXZQ(8), AKYZQ(8).
C
C ------- OUTPUT: QB(8,8), QRX(8), QRY(8), QRZ(8).
C
C********1*********2*********3*********4*********5*********6*********7**
C
      IMPLICIT REAL*8 (A-H,O-Z)
      REAL*8 N(8),L1(3),L2(3),L3(3),LL1(4),LL2(4),LL3(4),LL4(4)
C
      DIMENSION QB(8,8),QRX(8),QRY(8),QRZ(8),XQ(8),YQ(8),ZQ(8)
      DIMENSION AKXQ(8),AKYQ(8),AKZQ(8),AKXYQ(8),AKXZQ(8),AKYZQ(8)
      DIMENSION S(8),T(8),U(8), DNX(8),DNY(8),DNZ(8),W(8)
      DIMENSION RHOKG(8),HQ(8)
C
      DATA S/-1.0D0,1.0D0,1.0D0,-1.0D0, -1.0D0,1.0D0,1.0D0,-1.0D0/
      DATA T/-1.0D0,-1.0D0,1.0D0,1.0D0, -1.0D0,-1.0D0,1.0D0,1.0D0/
      DATA U/-1.0D0,-1.0D0,-1.0D0,-1.0D0, 1.0D0,1.0D0,1.0D0,1.0D0/
C
      IF(IQUAR.EQ.1 .OR. IQUAR.EQ.3)THEN
        P=0.577350269189626D0
        L1(1)=0.666666666666667D0
        L1(2)=0.166666666666667D0
        L1(3)=0.166666666666667D0
        L2(1)=0.166666666666667D0
        L2(2)=0.666666666666667D0
        L2(3)=0.166666666666667D0
        L3(1)=0.166666666666667D0
        L3(2)=0.166666666666667D0
        L3(3)=0.666666666666667D0
        LL1(1)=0.58541020D0
        LL1(2)=0.13819660D0
        LL1(3)=0.13819660D0
        LL1(4)=0.13819660D0
        LL2(1)=0.13819660D0
        LL2(2)=0.58541020D0
        LL2(3)=0.13819660D0
        LL2(4)=0.13819660D0
        LL3(1)=0.13819660D0
        LL3(2)=0.13819660D0
        LL3(3)=0.58541020D0
        LL3(4)=0.13819660D0
        LL4(1)=0.13819660D0
        LL4(2)=0.13819660D0
        LL4(3)=0.13819660D0
        LL4(4)=0.58541020D0
      ELSE
        P=1.0D0
        L1(1)=1.0D0
        L1(2)=0.0D0
        L1(3)=0.0D0
        L2(1)=0.0D0
        L2(2)=1.0D0
        L2(3)=0.0D0
        L3(1)=0.0D0
        L3(2)=0.0D0
        L3(3)=1.0D0
        LL1(1)=1.0D0
        LL1(2)=0.0D0
        LL1(3)=0.0D0
        LL1(4)=0.0D0
        LL2(1)=0.0D0
        LL2(2)=1.0D0
        LL2(3)=0.0D0
        LL2(4)=0.0D0
        LL3(1)=0.0D0
        LL3(2)=0.0D0
        LL3(3)=1.0D0
        LL3(4)=0.0D0
        LL4(1)=0.0D0
        LL4(2)=0.0D0
        LL4(3)=0.0D0
        LL4(4)=1.0D0
      ENDIF
C
C ------- INITIATE MATRICES QB(IQ,JQ), QRX(IQ),QRY(IQ) & QRZ(IQ)
C
      DO 100 IQ=1,8
        QRX(IQ)=0.0
        QRY(IQ)=0.0
        QRZ(IQ)=0.0
        DO JQ=1,8
          QB(IQ,JQ)=0.0
        ENDDO
  100 CONTINUE
C
C ------- SUMMATION OF THE INTEGRAND OVER THE GAUSSIAN POINTS
C
      DO 490 KG=1,NODE
C
C ------- DETERMINE LOACAL COORDINATE OF GAUSSIAN POINT KG
C
C ------- CALCULATE VALUES OF BASIS FUNCTIONS N(IQ) AND THEIR
C ------- DERIVATIVES DNX(IQ), DNY(IQ), AND DNZ(IQ), W.R.T. TO
C ------- X, Y, AND Z, RESPECTIVELY, AT THE GAUSSIAN POINT KG.
C
        IF(NODE.EQ.8)THEN
          SS=P*S(KG)
          TT=P*T(KG)
          UU=P*U(KG)
          CALL SHAPE
     I      (XQ,YQ,ZQ, SS,TT,UU, XSI,DL1,DL2,DL3, D1,D2,D3,D4, NODE,0,
     O       N,DNX,DNY,DNZ,W,DJAC)
        ELSEIF(NODE.EQ.6)THEN
          IF(KG.LE.3)THEN
            XSI=-P
            KKG=KG
          ELSE
            XSI=P
            KKG=KG-3
          ENDIF
          DL1=L1(KKG)
          DL2=L2(KKG)
          DL3=L3(KKG)
          CALL SHAPE
     I      (XQ,YQ,ZQ, SS,TT,UU, XSI,DL1,DL2,DL3, D1,D2,D3,D4, NODE,0,
     O       N,DNX,DNY,DNZ,W,DJAC)
          DJAC=DJAC/3.0D0
        ELSEIF(NODE.EQ.4)THEN
          D1=LL1(KG)
          D2=LL2(KG)
          D3=LL3(KG)
          D4=LL4(KG)
          CALL SHAPE
     I      (XQ,YQ,ZQ, SS,TT,UU, XSI,DL1,DL2,DL3, D1,D2,D3,D4, NODE,0,
     O       N,DNX,DNY,DNZ,W,DJAC)
          DJAC=DJAC*0.25D0
        ENDIF
C
        AKXK=AKXQ(KG)
        AKYK=AKYQ(KG)
        AKZK=AKZQ(KG)
        AKXYK=AKXYQ(KG)
        AKXZK=AKXZQ(KG)
        AKYZK=AKYZQ(KG)
        RHOK=RHOKG(KG)
C
C ------- ACCUMULATE THE SUMS TO OBTAIN THE MATRIX INTEGRALS QB(IQ,JQ)
C ------- AND QRX(IQ), QRY(IQ), AND QRZ(IQ)
C
        DO 390 IQ=1,NODE
          QRX(IQ)=QRX(IQ)-N(IQ)*AKXZK*DJAC*AGRAV
          QRY(IQ)=QRY(IQ)-N(IQ)*AKYZK*DJAC*AGRAV
          QRZ(IQ)=QRZ(IQ)-N(IQ)*AKZK*DJAC*AGRAV
          DO 350 JQ=1,NODE
            QB(IQ,JQ)=QB(IQ,JQ) + N(IQ)*N(JQ)*DJAC
            QRX(IQ)=QRX(IQ)-N(IQ)*(HQ(JQ)*(AKXK*DNX(JQ)+AKXYK*DNY(JQ)+
     1              AKXZK*DNZ(JQ))/RHOK)*DJAC
            QRY(IQ)=QRY(IQ)-N(IQ)*(HQ(JQ)*(AKXYK*DNX(JQ)+AKYK*DNY(JQ)+
     1              AKYZK*DNZ(JQ))/RHOK)*DJAC
            QRZ(IQ)=QRZ(IQ)-N(IQ)*(HQ(JQ)*(AKXZK*DNX(JQ)+AKYZK*DNY(JQ)+
     1              AKZK*DNZ(JQ))/RHOK)*DJAC
  350     CONTINUE
  390   CONTINUE
C
  490 CONTINUE
C
      RETURN
      END
C
c
c
c      SUBROUTINE RHOFUN(RHOM,AMU,RHOTYP,DINTS,CKG,RHOMU)
      SUBROUTINE RHOFUN(RHOM,AMU,RHOTYP,DINTS,CKG)
C
      IMPLICIT REAL*8(A-H,O-Z)
C
      COMMON /CHEM/ MXNCC,NCC
C
c      DIMENSION DINTS(MXNCC),RHOMU(MXNCC),CKG(7)
      DIMENSION DINTS(MXNCC),CKG(7)
C
          RHOM=1.0D0
          AMU=1.0D0
          DO K=1,NCC
              RHOM=RHOM+(1.0D0/RHOTYP-1.0D0/DINTS(K))*CKG(K)
c             RHOM=RHOM+CKG(K)
c             AMU=AMU+RHOMU(K)*CKG(K)
c             RHOM=1.0D0+RHOMU(1)*CKG(K)
          ENDDO
C
          RETURN
          END
