C    8/2/96     Modify CALL FSTORE and CALL TSTORE
C
C ********************************************************************
C *                                                                  *
C *                        3DFATMIC                                  *
C *                                                                  *
C ********************************************************************
C
C  Cheng, J. R., G. T. Yeh, and T. E. Short.  1995.  3DFATMIC: Users'
C    Manual of a Three-Dimensional Subsurface Flow, Fate and Transport
C    of Microbes and Chemicals Model.  EPA/EPA/***/R-95/***,
C    Dept. of Civil and Environmental Engineering, The Pennsylvania
C    State University, University Park, PA 16802.
C
C  For any question, please call Prof. G. T. Yeh at (814) 863-2931
C
C    3/31/95   --- Modify source/sink
C    With local grid refinement and Eularian zooming scheme
C
C ------- MAIN PROGRAM OF 3DFATMIC
C
      IMPLICIT REAL*8(A-H,O-Z)
      INTEGER*4 GNLR
      CHARACTER*80 INPFL,OUTFL,STOFL,STOCN,BARFL,PARFL,CHKFL
      CHARACTER DATNAM*1,TITLE*70
C
c ----- For Example 1 through Example 5
C      INCLUDE 'verify.par'
C
      PARAMETER(MAXNPK=2079,MAXELK=1600,MXBNPK=999,MXBESK=999,
     >          MXTUBK=3008 ,MXADNK=maxnpk+0)
      PARAMETER(MXJBDK=35,MXKBDK=8 ,MXNTIK=100,MXDTCK=4)
      PARAMETER(LTMXNK=693,LMXNPK=231,LMXBWK=49,MXRGNK= 9)
      PARAMETER(MXMATK=8,MXSPMK=5,MXMPMK=9)
C
C -------- 2. For flow source/sink, boundary conditions, and materials
C
      PARAMETER(MXSELh=1,MXSPRh=1,MXSDPh=1,MXWNPh=4,MXWPRh=2,MXWDPh=3)
      PARAMETER(MXCNPh=110,MXCESh=90,MXCPRh=1,MXCDPh=2)
      PARAMETER(MXNNPh=1,MXNESh=1,MXNPRh=1,MXNDPh=1)
      PARAMETER(MXVNPh=198,MXVESh=170,MXVPRh=2,MXVDPh=4)
      PARAMETER(MXDNPh=165,MXDPRh=11,MXDDPh=2)
C
C -------- 3. For transport source/sink, boundary conditions, and
C --------    materials
C
      PARAMETER(MXSELc=1,MXSPRc=1,MXSDPc=1,MXWNPc=4,MXWPRc=2,MXWDPc=5)
      PARAMETER(MXCNPc=55,MXCESc=40,MXCPRc=2,MXCDPc=4)
      PARAMETER(MXNNPc=11,MXNESc=4,MXNPRc=1,MXNDPc=2)
      PARAMETER(MXVNPc=638,MXVESc=560,MXVPRc=1,MXVDPc=2)
      PARAMETER(MXDNPc=70,MXDPRc=6,MXDDPc=2)
C
      PARAMETER(MXNCCK=2)
C
      PARAMETER(MXLSVK=500,MXMSVK=500,MXKGLDK=2000,MXNDBK=2000)
      PARAMETER(MXNEPK=20,MXEPWK=20)
      PARAMETER(MXNPWK=99,MXELWK=27,mxnpws=1331,mxelws=1000)
      PARAMETER(MXNPFGK= 2900,MXKGLK=2800)
C
C
c ----- For Example 6 & Example 8
C
c     PARAMETER(MAXNPK=2288,MAXELK=1800,MXBNPK=1999,MXBESK=1999,
c    >          MXTUBK=2640 ,MXADNK=maxnpk+14000)
c     PARAMETER(MXJBDK=85,MXKBDK=8 ,MXNTIK=100,MXDTCK=4)
c     PARAMETER(LTMXNK=693,LMXNPK=231,LMXBWK=49,MXRGNK=11)
c     PARAMETER(MXMATK=1,MXSPMK=2,MXMPMK=7)
C
C -------- 2. For flow source/sink, boundary conditions, and materials
C
c     PARAMETER(MXSELh=1,MXSPRh=1,MXSDPh=1,MXWNPh=1,MXWPRh=1,MXWDPh=1)
c     PARAMETER(MXCNPh=1,MXCESh=1,MXCPRh=1,MXCDPh=1)
c     PARAMETER(MXNNPh=1,MXNESh=1,MXNPRh=1,MXNDPh=1)
c     PARAMETER(MXVNPh=1,MXVESh=1,MXVPRh=1,MXVDPh=1)
c     PARAMETER(MXDNPh=1,MXDPRh=1,MXDDPh=1)
C
C -------- 3. For transport source/sink, boundary conditions, and
C --------    materials
C
c     PARAMETER(MXSELc=1,MXSPRc=1,MXSDPc=1,MXWNPc=1,MXWPRc=1,MXWDPc=1)
c     PARAMETER(MXCNPc=1,MXCESc=1,MXCPRc=1,MXCDPc=1)
c     PARAMETER(MXNNPc=1,MXNESc=1,MXNPRc=1,MXNDPc=1)
c     PARAMETER(MXVNPc=143,MXVESc=120,MXVPRc=1,MXVDPc=2)
c     PARAMETER(MXDNPc=143,MXDPRc=2,MXDDPc=2)
C
c     PARAMETER(MXNCCK=7)
C
c     PARAMETER(MXLSVK=5000,MXMSVK=5000,MXKGLDK=29999,MXNDBK=9999)
c     PARAMETER(MXNEPK=1,MXEPWK=1)
c     PARAMETER(MXNPWK=48,MXELWK=15,mxnpws=1,mxelws=1)
c     PARAMETER(MXNPFGK=260000,MXKGLK=140000)
C
C
c ----- For Example 7
C
c     PARAMETER(MAXNPK=510,MAXELK=224,MXBNPK=510,MXBESK=508,
c    >          MXTUBK=3552,MXADNK=MAXNPK+20000)
c     PARAMETER(MXJBDK=45,MXKBDK=8,MXNTIK=80,MXDTCK=1)
c     PARAMETER(LTMXNK=1,LMXNPK=1,LMXBWK=1,MXRGNK=1)
c     PARAMETER(MXMATK=8,MXSPMK=2,MXMPMK=8)
C
C -------- 2. For flow source/sink, boundary conditions, and materials
C
c     PARAMETER(MXSELh=1,MXSPRh=1,MXSDPh=1,MXWNPh=4,MXWPRh=2,MXWDPh=3)
c     PARAMETER(MXCNPh=1,MXCESh=1,MXCPRh=1,MXCDPh=1)
c     PARAMETER(MXNNPh=1,MXNESh=1,MXNPRh=1,MXNDPh=1)
c     PARAMETER(MXVNPh=1,MXVESh=1,MXVPRh=1,MXVDPh=1)
c     PARAMETER(MXDNPh=68,MXDPRh=2,MXDDPh=2)
C
C -------- 3. For transport source/sink, boundary conditions, and
C --------    materials
C
c     PARAMETER(MXSELc=1,MXSPRc=1,MXSDPc=1,MXWNPc=4,MXWPRc=2,MXWDPc=3)
c     PARAMETER(MXCNPc=55,MXCESc=40,MXCPRc=2,MXCDPc=4)
c     PARAMETER(MXNNPc=11,MXNESc=4,MXNPRc=1,MXNDPc=2)
c     PARAMETER(MXVNPc=34,MXVESc=16,MXVPRc=1,MXVDPc=2)
c     PARAMETER(MXDNPc=34,MXDPRc=5,MXDDPc=2)
C
c     PARAMETER(MXNCCK=7)
C
c     PARAMETER(MXLSVK=5000,MXMSVK=5000,MXKGLDK=39900,MXNDBK=9600)
c     PARAMETER(MXNEPK=1,MXEPWK=1)
c     PARAMETER(MXNPWK=27,MXELWK=8,mxnpws=27,mxelws=8)
c     PARAMETER(MXNPFGK=190000,MXKGLK=99999)
C
C
C ------- COMMON block for both flow and transport
C
      COMMON /SGEOM/ MAXEL,MAXNP,MXADNP,MAXBES,MXTUBS,MAXBNP,MXJBD,
     >               MXKBD,MXNTI,MXDTC
      COMMON /CGEOM/ NNP,NEL,NBNP,NTUBS,NBES,NTI,NDTCHG,ISHAPE
      COMMON /LGEOM/ LTMXNP,LMXNP,LMXBW,MXREGN,NREGN
      COMMON /SCMTL/ MAXMAT,MXSPPM,MXMPPM,NMAT,NMPPM,NSPPM
      COMMON /NOPTN/ ILUMP,IMID,IWET,IOPTIM,KSORP,LGRN,IQUAR
      COMMON /PCG/ GG,IEIGEN
      COMMON /NINTR/ KPR0,KDSK0,NSTRf,NSTRt,KSSf,KSSt,IGEOM
      COMMON /CTIM/ DELT,CHNG,DELMAX,TMAX,DELT0,TIME
C
C ------- COMMON block for flow iteration and material control
C
      COMMON /FINTE/ NCYLf,NITERf,NPITERf,KSP,KGRAV,IPNTSf
      COMMON /FREAL/ TOLAf,TOLBf,Wf,OMEf,OMIf,GRAV,cnstkr
C
C ------- COMMON block for transport iteration and material control
C
      COMMON /TINTE/ NCMt,KVIt,NITERt,NPITERt,IPNTSt,MICONF,IFLUX
      COMMON /TREAL/ Wt,WVt,OMEt,OMIt,TOLAt,TOLBt
      COMMON /TADP/ ADPEPS,ADPARM,IZOOM,IDZOOM,IEPC,NXG,NYG,NZG,
     >              NXW,NYW,NZW,NXD,NYD,NZD,IDETQ
C
C ------- COMMON block for flow source/sink
C
      COMMON /FCS/ MXSELf,MXSPRf,MXSDPf,NSELf,NSPRf,NSDPf,KSAIf
      COMMON /FCW/ MXWNPf,MXWPRf,MXWDPf,NWNPf,NWPRf,NWDPf,KWAIf
C
C ------- COMMON block for transport source/sink
C
      COMMON /CELS/ MXSELt,MXSPRt,MXSDPt,NSELt,NSPRt,NSDPt,KSAIt
      COMMON /CNPS/ MXWNPt,MXWPRt,MXWDPt,NWNPt,NWPRt,NWDPt,KWAIt
C
C ------- COMMON block for flow boundary conditions
C
      COMMON /FCBC/ MXCNPf,MXCESf,MXCPRf,MXCDPf,
     .              NCNPf,NCESf,NCPRf,NCDPf,KCAIf
      COMMON /FNBC/ MXNNPf,MXNESf,MXNPRf,MXNDPf,
     .              NNNPf,NNESf,NNPRf,NNDPf,KNAIf
      COMMON /FVBC/ MXVESf,MXVNPf,MXVPRf,MXVDPf,
     .              NVESf,NVNPf,NVPRf,NVDPf,KVAIf
      COMMON /FDBC/ MXDNPf,MXDPRf,MXDDPf,NDNPf,NDPRf,NDDPf,KDAIf
C
C ------- COMMON block for transport boundary conditions
C
      COMMON /TCBC/ MXCNPt,MXCESt,MXCPRt,MXCDPt,
     .              NCNPt,NCESt,NCPRt,NCDPt,KCAIt
      COMMON /TNBC/ MXNNPt,MXNESt,MXNPRt,MXNDPt,
     .              NNNPt,NNESt,NNPRt,NNDPt,KNAIt
      COMMON /TVBC/ MXVESt,MXVNPt,MXVPRt,MXVDPt,
     .              NVESt,NVNPt,NVPRt,NVDPt,KVAIt
      COMMON /TDBC/ MXDNPt,MXDPRt,MXDDPt,NDNPt,NDPRt,NDDPt,KDAIt
      COMMON /TFLUX/ MXLSV,MXMSV
C
C ------- COMMON block for flow material balance
C
      COMMON /FFLOW/ FRATEf(10),FLOWf(10),TFLOWf(10)
C
C ------- COMMON block for transport material balance
C
      COMMON /TFLOW/ FRATEt(14),FLOWt(14),TFLOWt(14,7)
C
C ------- Advection weighting factors
C
      COMMON /WETX/ APHA1,APHA2,APHA3,APHA4
      COMMON /WETY/ BETA1,BETA2,BETA3,BETA4
      COMMON /WETZ/ GAMA1,GAMA2,GAMA3,GAMA4
C
C ----- COMPONENT NUMBER
C
      COMMON /SAZFM/ MXNPFG,MXKGL,MXKGLD,MXNEP,MXEPW,MXNPW,MXELW,MXNDB,
     >               mxnpww,mxelww
      COMMON /CHEM/ MXNCC,NCC
      COMMON /MICROB/ GRATE,YCOEFF,RTARDS,RTARDO,RTARDN,SCOEFF,
     >                ECOEFF,DCOEFF,SATURC,PCOEFF,COFK
C
C ------- Arrays for both flow and transport
C
      DIMENSION X(MAXNPK,3),IB(MAXNPK)
      DIMENSION IE(MAXELK,11),LRN(MXJBDK,MXADNK),LRL(MXKBDK,MAXNPK)
      DIMENSION NLRL(MAXNPK),NLRN(MAXNPK)
      DIMENSION CMATRX(MXADNK,MXJBDK),RLD(MXADNK)
      DIMENSION sk(mxadnk),rk(mxadnk),pk(mxadnk),aa(mxadnk,mxjbdk)
      DIMENSION il(mxadnk),nd(mxadnk),RI(MXADNK),RL(MXADNK)
C
      DIMENSION NTNPLR(MXRGNK),NNPLR(MXRGNK),LMAXDF(MXRGNK)
      DIMENSION GNLR(LTMXNK,MXRGNK),LNOJCN(MXJBDK,LMXNPK,MXRGNK)
      DIMENSION CMTRXL(LMXNPK,LMXBWK),RLDL(LMXNPK)
C
      DIMENSION DCOSB(3,MXBESK),ISB(6,MXBESK),NPBB(MXBNPK)
      DIMENSION KPR(MXNTIK),KDSK(MXNTIK),TDTCH(MXDTCK,2)
C
      DIMENSION V(MAXNPK,3),TH(MAXELK,8)
C
C ------- Arrays for flow only
C
      DIMENSION H(MAXNPK),HP(MAXNPK),HW(MAXNPK),HT(MAXNPK)
      DIMENSION DTH(MAXELK,8),AKHC(8,MAXELK,7),NPCNV(MAXNPK)
C
      DIMENSION BFLXf(MXBNPK,2)
C
      DIMENSION SOSf(MXSPRh),SOSFf(MXSDPh,MXSPRh),TSOSFf(MXSDPh,MXSPRh)
      DIMENSION ISTYPf(MXSELh),LESf(MXSELh)
      DIMENSION WSSf(MXWPRh),WSSFf(MXWDPh,MXWPRh),TWSSFf(MXWDPh,MXWPRh)
      DIMENSION IWTYPf(MXWNPh),NPWf(MXWNPh)
C
      DIMENSION QCBf(MXCPRh),QCBFf(MXCDPh,MXCPRh),TQCBFf(MXCDPh,MXCPRh)
      DIMENSION ICTYPf(MXCESh),ISCf(5,MXCESh),NPCBf(MXCNPh)
C
      DIMENSION QNBf(MXNPRh),QNBFf(MXNDPh,MXNPRh),TQNBFf(MXNDPh,MXNPRh)
      DIMENSION INTYPf(MXNESh),ISNf(5,MXNESh),NPNBf(MXNNPh)
C
      DIMENSION QVBf(MXVPRh),QVBFf(MXVDPh,MXVPRh),TQVBFf(MXVDPh,MXVPRh)
      DIMENSION IVTYPf(MXVESh),ISVf(5,MXVESh),NPVBf(MXVNPh)
      DIMENSION RSVAB(MXVNPh,4),INDRS(MXVNPh,3)
C
      DIMENSION HDBf(MXDPRh),HDBFf(MXDDPh,MXDPRh),THDBFf(MXDDPh,MXDPRh)
      DIMENSION IDTYPf(MXDNPh),NPDBf(MXDNPh)
C
      DIMENSION PROPf(MXMATK,MXMPMK),SPP(MXSPMK,MXMATK,4)
      DIMENSION rhomu(mxncck),DINTS(MXNCCK)
C
C ------- Arrays for transport only
C
      DIMENSION C(MAXNPK,MXNCCK),CP(MAXNPK,MXNCCK)
      DIMENSION CS(MAXNPK,MXNCCK),DTI(MAXNPK,MXNCCK)
      DIMENSION F(MAXNPK,3,MXNCCK),CMX(MXNCCK)
C
      DIMENSION BFLXt(MXBNPK,2,MXNCCK),WWRK(MAXNPK)
C
      DIMENSION WETAB(12,MAXELK),VP(MAXNPK,3),VEAVG(MAXNPK,3,MXNCCK)
      DIMENSION THP(MAXELK,8),THN(MAXNPK,2,MXNCCK),AKDC(8,MXKGLDK,8)
C
      DIMENSION SOSt(MXSPRc,2),SOSFt(MXSDPc,MXSPRc,2),
     .          TSOSFt(MXSDPc,MXSPRc)
      DIMENSION ISTYPt(MXSELc,MXNCCK),LESt(MXSELc)
      DIMENSION WSSt(MXWPRc,2),WSSFt(MXWDPc,MXWPRc,2),
     .          TWSSFt(MXWDPc,MXWPRc)
      DIMENSION IWTYPt(MXWNPc,MXNCCK),NPWt(MXWNPc)
C
      DIMENSION QCBt(MXCPRc),QCBFt(MXCDPc,MXCPRc),TQCBFt(MXCDPc,MXCPRc)
      DIMENSION ICTYPt(MXCESc,MXNCCK),ISCt(5,MXCESc),NPCBt(MXCNPc)
C
      DIMENSION QNBt(MXNPRc),QNBFt(MXNDPc,MXNPRc),TQNBFt(MXNDPc,MXNPRc)
      DIMENSION INTYPt(MXNESc,MXNCCK),ISNt(5,MXNESc),NPNBt(MXNNPc)
C
      DIMENSION CVBt(MXVPRc),CVBFt(MXVDPc,MXVPRc),TCVBFt(MXVDPc,MXVPRc)
      DIMENSION IVTYPt(MXVESc,MXNCCK),ISVt(5,MXVESc),NPVBt(MXVNPc)
C
      DIMENSION CDBt(MXDPRc),CDBFt(MXDDPc,MXDPRc),TCDBFt(MXDDPc,MXDPRc)
      DIMENSION IDTYPt(MXDNPc,MXNCCK),NPDBt(MXDNPc)
C
      DIMENSION PROPt(MXMATK,MXMPMK),RKD(MXMATK,MXNCCK)
      DIMENSION TRANC(MXMATK,MXNCCK)
      DIMENSION GRATE(4),YCOEFF(4),RTARDS(4),RTARDO(4),RTARDN(4),
     >          SCOEFF(4),ECOEFF(4),DCOEFF(4),SATURC(4),PCOEFF(4)
      DIMENSION NBDYB(MAXNPK),IBDY(MXTUBK),IWRK(MXBESK),CW(MXNPWK)
      DIMENSION IEW(MXELWK,8,3),IBW(MXNPWK,3),LRLW(24,MXNPWK,3)
      DIMENSION NLRLW(MXNPWK,3),XW(MXNPWK,3),VXW(MXNPWK,3),MWLOC(MXNPWK)
      DIMENSION DL468(8,MXNPWK,3)
c
      DIMENSION IEWw(MXELWs,8,3),IBWw(MXNPWs,3),LRLWw(24,MXNPWs,3)
      DIMENSION NLRLWw(MXNPWs,3),XWw(MXNPWs,3),VXWw(MXNPWs,3)
      DIMENSION DL468w(8,MXNPWs,3)
C
      DIMENSION IBE(MAXELK),IBCHK(MAXELK),ISE(MXKGLK,8)
      DIMENSION XPFG(MXNPFGK,3),MPLOC(MXNPFGK),CPFG(MXNPFGK,MXNCCK)
      DIMENSION XSFG(MXNPFGK,3),MPLOCS(MXNPFGK),CSFG(MXNPFGK,MXNCCK)
      DIMENSION XWFG(MXNPFGK,3),MPLOCW(MXNPFGK),CWFG(MXNPFGK,MXNCCK)
      DIMENSION XEFG(MXNEPK,3),MPLOCE(MXNPFGK),CEFG(MXNEPK,MXNCCK)
      DIMENSION NFGM(MAXELK),NFGMB(MAXELK),MAXFGW(MXELWK,MXNCCK)
      DIMENSION MINFGW(MXELWK,MXNCCK),CMAXFG(MXELWK,MXNCCK)
      DIMENSION CMINFG(MXELWK,MXNCCK),NEPW(MXELWK,MXEPWK),NEPWN(MXELWK)
      DIMENSION ISED(MXKGLDK,9),NDBD(MXNDBK),MPLOCD(MXNDBK)
      DIMENSION NLRND(MXADNK),NCFG(2*MXNCCK),DTIFG(MXNPFGK,MXNCCK)
      DIMENSION ILSV(MXLSVK,5),IMSV(MXMSVK,4),NFGMBB(MAXELK)
C
C -------- Assign user array dimensions to global array dimensions;
C -------- 1. For both flow and transport
C
      MAXNP=MAXNPK
      MXADNP=MXADNK
      MAXEL=MAXELK
      MAXBNP=MXBNPK
      MAXBES=MXBESK
      MXTUBS=MXTUBK
      MXJBD=MXJBDK
      MXKBD=MXKBDK
      MXNTI=MXNTIK
      MXDTC=MXDTCK
      LTMXNP=LTMXNK
      LMXNP=LMXNPK
      LMXBW=LMXBWK
      MXREGN=MXRGNK
      MAXMAT=MXMATK
      MXSPPM=MXSPMK
      MXMPPM=MXMPMK
C
C -------- 2. For flow, source/sink, boundary conditions, and materails
C
      MXSELf=MXSELh
      MXSPRf=MXSPRh
      MXSDPf=MXSDPh
      MXWNPf=MXWNPh
      MXWPRf=MXWPRh
      MXWDPf=MXWDPh
      MXCNPf=MXCNPh
      MXCESf=MXCESh
      MXCPRf=MXCPRh
      MXCDPf=MXCDPh
      MXNNPf=MXNNPh
      MXNESf=MXNESh
      MXNPRf=MXNPRh
      MXNDPf=MXNDPh
      MXVNPf=MXVNPh
      MXVESf=MXVESh
      MXVPRf=MXVPRh
      MXVDPf=MXVDPh
      MXDNPf=MXDNPh
      MXDPRf=MXDPRh
      MXDDPf=MXDDPh
C
C -------- 3. For transport, source/sink, boundary conditions, and
C --------    materails
C
      MXSELt=MXSELc
      MXSPRt=MXSPRc
      MXSDPt=MXSDPc
      MXWNPt=MXWNPc
      MXWPRt=MXWPRc
      MXWDPt=MXWDPc
      MXCNPt=MXCNPc
      MXCESt=MXCESc
      MXCPRt=MXCPRc
      MXCDPt=MXCDPc
      MXNNPt=MXNNPc
      MXNESt=MXNESc
      MXNPRt=MXNPRc
      MXNDPt=MXNDPc
      MXVNPt=MXVNPc
      MXVESt=MXVESc
      MXVPRt=MXVPRc
      MXVDPt=MXVDPc
      MXDNPt=MXDNPc
      MXDPRt=MXDPRc
      MXDDPt=MXDDPc
      MXNCC=MXNCCK
C
C ---- for tracking, local grid refinement, and diffusion zooming
      MXELW=MXELWK
      MXNPW=MXNPWK
      MXNPFG=MXNPFGK
      MXKGL=MXKGLK
      MXKGLD=MXKGLDK
      MXNEP=MXNEPK
      MXEPW=MXEPWK
      MXNDB=MXNDBK
      MXLSV=MXLSVK
      MXMSV=MXMSVK
      mxnpww=mxnpws
      mxelww=mxelws
C
       PRINT *,' PLEASE INPUT YOUR INPUT DATA FILE NAME.'
       READ(*,'(A80)') INPFL
       PRINT *,' THEN, YOUR OUTPUT FILE NAME.'
       READ(*,'(A80)') OUTFL
       PRINT *,' THEN, YOUR FLOW STORAGE FILE NAME.'
       READ(*,'(A80)') STOFL
       PRINT *,' THEN, YOUR CONCENTRATION STORAGE FILE NAME.'
       READ(*,'(A80)') STOCN
       PRINT *,' THEN, YOUR BOUNDARY ARRAY FILE NAME.'
       READ(*,'(A80)') BARFL
       PRINT *,' THEN, YOUR POINTER ARRAY FILE NAME.'
       READ(*,'(A80)') PARFL
       PRINT *,' THEN, YOUR CHECK DEBUG FILE NAME.'
       READ (*,'(A80)') CHKFL
C
       OPEN(UNIT=15,FILE=INPFL,STATUS='UNKNOWN')
       OPEN(UNIT=16,FILE=OUTFL,STATUS='UNKNOWN')
       OPEN(UNIT=11,FILE=STOFL,FORM='UNFORMATTED',STATUS='UNKNOWN')
       OPEN(UNIT=12,FILE=STOCN,FORM='UNFORMATTED',STATUS='UNKNOWN')
       OPEN(UNIT=13,FILE=BARFL,FORM='UNFORMATTED',STATUS='UNKNOWN')
       OPEN(UNIT=14,FILE=PARFL,FORM='UNFORMATTED',STATUS='UNKNOWN')
       OPEN (UNIT=21,FILE=CHKFL,STATUS='UNKNOWN')
C
C ******* DATA SET 1: PROBLEM IDENTIFICATION AND DESCRIPTION
C
  100 READ(15,1000) NPROB,TITLE
C
      IF(NPROB.LE.0) STOP
C
      WRITE(16,2000) NPROB,TITLE
C
C ******* DATA SET 2: OPTION PARAMETERS
C
      READ(15,1010) DATNAM
      PRINT *, 'DATNAM in MAIN =',DATNAM
C
      READ(15,*) IMOD,IGEOM,IBUG,ICHNG
      WRITE(16,2001) IMOD,IGEOM,IBUG,ICHNG
C
      READ(15,*)NITFTS,OMEFTS,ALLOW
      WRITE(16,2005)NITFTS,OMEFTS,ALLOW
C
      READ(15,*) KSSf,KSSt,ILUMP,IMID,IPNTSf,IPNTSt,NSTRf,NSTRt,MICONF,
     >           IQUAR
      WRITE (16,2010) KSSf,KSSt,ILUMP,IMID,IPNTSf,IPNTSt,NSTRf,NSTRt,
     >                MICONF,IQUAR
C
      READ(15,*) KGRAV,Wf,OMEf,OMIf,cnstkr
      WRITE(16,2020) KGRAV,Wf,OMEf,OMIf,cnstkr
C
      READ(15,*) KVIt,IWET,IOPTIM,KSORP,LGRN
      WRITE(16,2030) KVIt,IWET,IOPTIM,KSORP,LGRN
      READ(15,*) Wt,WVt,OMEt,OMIt
      WRITE(16,2040) Wt,WVt,OMEt,OMIt
C
      IF(IPNTSf.GT.1 .OR. IPNTSt.GT.1)READ(15,*) IEIGEN,GG
C
      IF(IMOD.EQ.10)IPNTSt=1
      IF(IMOD.EQ.1)IPNTSf=1
C
C ******* DATA SET 3: ITERATION PARAMETERS
C
      READ(15,1010) DATNAM
      READ(15,*) NITERf,NCYLf,NPITERf,TOLAf,TOLBf
      WRITE(16,2050) NITERf,NCYLf,NPITERf,TOLAf,TOLBf
      READ(15,*) NITERt,NPITERt,TOLAt,TOLBt
      WRITE(16,2060) NITERt,NPITERt,TOLAt,TOLBt
C
C ******* DATA SET 4: TIME CONTROL PARAMETERS
C
      READ(15,1010) DATNAM
      READ(15,*) NTI,NDTCHG
      WRITE(16,2070) NTI,NDTCHG
      READ(15,*) DELT,CHNG,DELMAX,TMAX
      IF(TMAX.LE.0.0) TMAX=1.0D38
      DELT0=DELT
      WRITE(16,2080) DELT,CHNG,DELMAX,TMAX
C
      READ(15,1110) KPR0,(KPR(I),I=1,NTI)
      WRITE(16,2110) KPR0,(KPR(I),I=1,NTI)
      READ(15,1110) KDSK0,(KDSK(I),I=1,NTI)
      WRITE(16,2120) KDSK0,(KDSK(I),I=1,NTI)
      IF(NDTCHG.GT.0) READ(15,*) ((TDTCH(I,J),J=1,2),I=1,NDTCHG)
      NDTCHG=NDTCHG+1
      TDTCH(NDTCHG,1)=1.0D38
      TDTCH(NDTCHG,2)=DELT
      WRITE(16,2130) ((TDTCH(I,J),J=1,2),I=1,NDTCHG)
C
C ******* DATA SETS 5 THROUGH 10: REGION GEOMETRIC AND MATERIAL DATA
C
      CALL RDATIO(PROPf,SPP,DINTS,RHOMU,PROPt,RKD,TRANC,X,NNPLR,GNLR,IE,
     >            DCOSB,ISB,NPBB,IMOD,IRXN)
C
C ******* COMPUTE POINTER ARRAYS LRN,LRL,NLRL,NTNPLR,LMAXDF,LNOJCN,GNLR
C
      IF(IGEOM.LE.3) CALL PAGEN(LRN,NLRN,LRL,NLRL,LNOJCN,LMAXDF,
     >    NTNPLR,GNLR,IE, NNPLR,IGEOM,ND)
C     IF ((IPNTSf.EQ.3).OR.(IPNTSt.EQ.3))
C    .    CALL conect(lrn,nd,nt)
C
      REWIND 14
      IF(IGEOM.LE.3) THEN
        WRITE(14) ((LRN(J,I),J=1,MXJBD),NLRN(I),I=1,NNP),
     >  ((LRL(J,I),J=1,MXKBD),I=1,NNP),(NLRL(I),I=1,NNP)
        IF(IPNTSf.EQ.0 .OR. IPNTST.EQ.0) THEN
          WRITE(14)(NTNPLR(K),K=1,MXREGN),(LMAXDF(K),K=1,MXREGN),
     2      (((LNOJCN(J,I,K),J=1,MXJBD),I=1,LMXNP),K=1,MXREGN),
     3      ((GNLR(I,K),I=1,LTMXNP),K=1,MXREGN),(NNPLR(K),K=1,MXREGN)
        elseif(ipntsf.eq.3 .or. ipntst.eq.3) then
          write(14)(nd(i),i=1,nnp)
        endif
      ELSE
        READ(14) ((LRN(J,I),J=1,MXJBD),NLRN(I),I=1,NNP),
     >  ((LRL(J,I),J=1,MXKBD),I=1,NNP),(NLRL(I),I=1,NNP)
        IF(IPNTSf.EQ.0 .OR. IPNTST.EQ.0) THEN
          READ(14)(NTNPLR(K),K=1,MXREGN),(LMAXDF(K),K=1,MXREGN),
     2      (((LNOJCN(J,I,K),J=1,MXJBD),I=1,LMXNP),K=1,MXREGN),
     3      ((GNLR(I,K),I=1,LTMXNP),K=1,MXREGN),(NNPLR(K),K=1,MXREGN)
        elseif(ipntsf.eq.3 .or. ipntst.eq.3) then
          read(14)(nd(i),i=1,nnp)
        endif
      END IF
      CLOSE(14)
C
C ******* IDENTIFY BOUNDARY ELEMENTS AND COMPUTE DIRECTIONAL COSINES
C
        IF(IGEOM.LE.1 .OR. (NSTRf.GT.0 .AND. NSTRt.GT.0))
     >     CALL SURF(X,IE,LRL,NLRL, DCOSB,ISB,NPBB,IGEOM,LRN,NLRN)
C
        REWIND 13
        IF(IGEOM.LE.1) WRITE(13) NBES,NBNP,((DCOSB(J,I),J=1,3),I=1,
     >    NBES),((ISB(J,I),J=1,6),I=1,NBES),(NPBB(I),I=1,NBNP)
        IF(IGEOM.GT.1) READ(13) NBES,NBNP,((DCOSB(J,I),J=1,3),I=1,NBES),
     >    ((ISB(J,I),J=1,6),I=1,NBES),(NPBB(I),I=1,NBNP)
        CLOSE(13)
C
        IF(IMOD.NE.10)THEN
C
C ----- PREPARE IB ARRAY, THE INDEX OF BOUNDARY OF EVERY NODAL POINT
C
          DO I=1,NNP
            IB(I)=0
          ENDDO
          DO I=1,NBNP
            NP=NPBB(I)
            IB(NP)=5
          ENDDO
C
C ----- PREPARE IBE ARRAY
C
          CALL IBE3D
     I         (MAXEL,MAXNP,MXKBD,IE,NLRL,LRL,IB,NEL,
     O           IBE)
        ENDIF
C
C ******* DATA SET 11: INITIAL CONDITIONS
C
      JTMJTM=0
      IF(NSTRf.EQ.0 .OR. NSTRt.EQ.0)READ(15,1010) DATNAM
      IF(IMOD.NE.1)THEN
        IF(NSTRf.EQ.0)THEN
          READ(15,*) IHTR
          CALL READR(H,MAXNP,NNP)
          IF(IHTR.EQ.1) THEN
            DO NP=1,NNP
              H(NP)=H(NP)-X(NP,3)*DBLE(KGRAV)
            ENDDO
          ENDIF
        ELSE
          DO II=1,NSTRf
            READ(11) JTMJTM,TIME,(H(N),N=1,NNP),(HT(N),N=1,NNP),
     >               (IE(M,10),M=1,NEL),((TH(M,I),I=1,8),M=1,NEL),
     >              ((V(N,I),I=1,3),N=1,NNP),((INDRS(N,I),I=1,3),
     >                N=1,NVNPf),((AKHC(I,M,7),I=1,8),M=1,NEL)           3/15/95
          ENDDO
        ENDIF
      ENDIF
      DO K=1,NCC
        DO NP=1,NNP
          CP(NP,K)=0.0D0
        ENDDO
      ENDDO
      IF(IMOD.NE.10) THEN
        IF(NSTRt.EQ.0)THEN
          DO K=1,NCC
            CALL READR(CP(1,K),MAXNP,NNP)
          ENDDO
        ELSE
          DO II=1,NSTRt
            READ(12) JTM,TIME,((C(N,K),N=1,NNP),K=1,NCC),
     >          (((F(N,I,K),I=1,3),N=1,NNP),K=1,NCC),(IE(M,10),M=1,NEL)
          ENDDO
          PRINT *, 'JTM =',JTM
        ENDIF
      ENDIF
C
C ******* DATA SETS 12 AND 13:  SOURCE/SINK; flow
C
      IF(IMOD.NE.1)
     >  CALL FSSDAT(SOSFf,TSOSFf,ISTYPf,LESf,WSSFf,TWSSFf,IWTYPf,NPWf)
C
C ******* DATA SETS 14 AND 15:  SOURCE/SINK; transport
C
      IF(IMOD.NE.10)
     >  CALL TSSDAT(SOSFt,TSOSFt,ISTYPt,LESt,WSSFt,TWSSFt,IWTYPt,NPWt)
C
C
C ******* DATA SETS 16 TO 19:  BOUNDARY CONDITIONS; flow
C
      IF(IMOD.NE.1)
     >  CALL FBCDAT(ISB,NPBB,
     >  QCBFf,TQCBFf,ICTYPf,ISCf,NPCBf,QNBFf,TQNBFf,INTYPf,ISNf,NPNBf,
     >  QVBFf,TQVBFf,IVTYPf,ISVf,NPVBf,RSVAB,HDBFf,THDBFf,IDTYPf,NPDBf)
C
C ******* DATA SETS 20 THROUGH 23:  BOUNDARY CONDITIONS; transport
C
      IF(IMOD.NE.10)
     >  CALL TBCDAT(ISB,NPBB,IB,
     >  CVBFt,TCVBFt,IVTYPt,ISVt,NPVBt,CDBFt,TCDBFt,IDTYPt,NPDBt,
     >  QCBFt,TQCBFt,ICTYPt,ISCt,NPCBt,QNBFt,TQNBFt,INTYPt,ISNt,NPNBt)
C
C ***** DATA SET 24:  PARAMETERS CONTROLLING TRACKING SCHEME
C
      IF(IMOD.NE.10)THEN
        READ(15,1010) DATNAM
        READ(15,*)IZOOM,IDZOOM,IEPC,NXG,NYG,NZG,NXW,NYW,NZW,NXD,NYD,NZD,
     >            IDETQ
        READ(15,*)ADPEPS,ADPARM
        WRITE(16,2150)IZOOM,IDZOOM,IEPC,NXG,NYG,NZG,NXW,NYW,NZW,NXD,NYD,
     >            NZD,IDETQ
        WRITE(16,2155)ADPEPS,ADPARM
      ENDIF
C
      IF(IMOD.NE.10 .AND. LGRN.NE.0)CALL CKBDY
     I     (NPBB,ISB,ISVt,ISCt,IB,
     O      NBDYB,IBDY,
     M      IWRK)
C
C ------- Pass to GWM3D
C
      CALL HTMICH( sk,rk,pk,aa,il,nd,NLRN,
     > X,IE,IB,LRN,LRL,NLRL, CMATRX,RLD,RI,RL, H,HP,HW,HT,
     1 V,VP,VEAVG ,WETAB, C,CP,CS,DTI,F,CMX,WWRK,TH,THP,THN,DTH,AKHC,
     1 AKDC, DCOSB,ISB,NPBB, BFLXf,BFLXt, NPCNV,
     2 SOSf,SOSFf,TSOSFf,ISTYPf,LESf, WSSf,WSSFf,TWSSFf,IWTYPf,NPWf,
     3 LESt,SOSt,SOSFt,TSOSFt,ISTYPt, NPWt,WSSt,WSSFt,TWSSFt,IWTYPt,
     > ILSV,IMSV,
     3 QCBf,QCBFf,TQCBFf,ICTYPf,ISCf,NPCBf, QCBt,QCBFt,TQCBFt,ICTYPt,
     3 ISCt,NPCBt, QNBf,QNBFf,TQNBFf,INTYPf,ISNf,NPNBf, QNBt,QNBFt,
     4 TQNBFt,INTYPt,ISNt,NPNBt, QVBf,QVBFf,TQVBFf,IVTYPf,ISVf,NPVBf,
     4 RSVAB,INDRS, CVBt,CVBFt,TCVBFt,IVTYPt,ISVt,NPVBt,
     5 HDBf,HDBFf,THDBFf,IDTYPf,NPDBf,CDBt,CDBFt,TCDBFt,IDTYPt,NPDBt,
c     5 PROPf,SPP, PROPt,RKD,TRANC, DINTS,RHOMU, KPR,KDSK,TDTCH,
     5 PROPf,SPP, PROPt,RKD,TRANC, DINTS, KPR,KDSK,TDTCH,
     7 NNPLR,LMAXDF,GNLR,LNOJCN,CMTRXL,RLDL,NBDYB,IBDY,XW,VXW,CW,MWLOC,
     8 LRLW,NLRLW,IEW,IBW,DL468,ieww,ibww,lrlww,nlrlww,xww,vxww,dl468w,
     > IBE,IBCHK,XPFG,CPFG,MPLOC,XSFG,CSFG,MPLOCS,XWFG,CWFG,MPLOCW,
     > XEFG,CEFG,MPLOCE,NFGM,NFGMB,NFGMBB,MAXFGW,MINFGW,CMAXFG,CMINFG,
     > ISE,NEPWN,NEPW,ISED,NDBD,MPLOCD,NLRND,NCFG,DTIFG,
     > JTMJTM,IRXN,IMOD,IBUG,ICHNG,NITFTS,OMEFTS,ALLOW,
     > TITLE,NPROB)
C
      GO TO 100
C
 1000 FORMAT(I5,A70,I2,3I1)
 1010 FORMAT(A1)
 1110 FORMAT(80I1)
C
 2000 FORMAT('  PROBLEM',I5/' ',A70/)
 2001 FORMAT(/5X,
     1 'IS HYDRO-CHEMICAL TO BE SIMULATED?  . . . . . . . . .',I5/5X,
     2 'IS GEOMETRIC INFORMATION TO BE PRINTED? . . . . . . .',I5/5X,
     3 'IS DEBUG INFORMATION TO BE PRINTED? . . . . . . . . .',I5/5X,
     4 'IS CYCLIC CHANGE OF RS NODE TO BE PRINTED? . . . . ..',I5//)
 2005 FORMAT(
     > ' NO. OF ITER. ALLOWED FOR HYDRO-TRANS ITERA.,NITFTS . .',I5/5X,
c    > ' NO. OF ITER. ALLOWED FOR HYDRO-TRANS ITERA.,NITFTT . .',I5/5X,
     > 'RELAXATION FACTOR FOR HYDRO-TRANS ITER, OMEFTS . . .',F5.2/5X,
c    > 'RELAXATION FACTOR FOR HYDRO-TRANS ITER, OMEFTT . . .',F5.2/5X,
     > ' ALLOWED FACTOR OF NEGLIGIBLE CON. IN CONV. TEST  . .',1PD12.6/)
 2010 FORMAT(///' *** OPTIONAL PARAMETERS (flow/transport) ***'/5X,
     > ' FLOW STEADY-STATE I.C. CONTROL, KSSf . . . . . . . .',I5/5X,
     > ' TRANSPORT STEADY-STATE I.C. CONTROL, KSSt. . . . . .',I5/5X,
     > ' LUMPING INDICATOR, ILUMP . . . . . . . . . . . . . .',I5/5X,
     > ' MID-DIFFERENCE INDICATOR, IMID . . . . . . . . . . .',I5/5X,
     > ' POINTWISE ITERATION INDICATOR FOR FLOW, IPNTSf . . .',I5/5X,
     > ' POINTWISE ITERATION INDICATOR FOR TRANSPORT, IPNTSt.',I5/5X,
     > ' NUMBER OF RECORDS OF RESTART, NSTRf  . . . . . . . .',I5/5X,
     > ' NUMBER OF RECORDS OF RESTART, NSTRt  . . . . . . . .',I5/5X,
     > ' INDEX OF MICRO. CONFIGURATION  . . . . . . . . . . .',I5/5X,
     > ' INDEX OF GUADRATURE FOR INTEGRATION  . . . . . . . .',I5/)
 2020 FORMAT(/' *** OPTIONAL PARAMETERS (flow only) ***'/5X,
     > ' GRAVITY CONTROL, KGRAV . . . . . . . . . . . . . ',I5/5X,
     > ' TIME-INTEGRATION PARAMETER, Wf. . . . . . . . . .',1PD15.6/5X,
     > ' ITERATION PARAMETER FOR NONLINEAR EQUATION, OMEf.',1PD15.6/5X,
     > ' RELAXATION PARAMETER FOR MATRIX EQ. SOV., OMIf. .',1PD15.6/5X,
     > ' constraint on hydraulic conductivity, cnstkr  . .',1PD15.6)
 2030 FORMAT(/' *** OPTIONAL PARAMETERS (transport only) ***'/5X,
     > 'VELOCITY INPUT CONTROL, KVI  . . . . . . . . . . .',I5/5X,
     > 'UPSTREAM WEIGHTING INDICATOR, IWET . . . . . . . .',I5/5X,
     > 'WEIGHTING FACTOR OPTIMIZING INDICATOR, IOPTIM  . .',I5/5X,
     > 'SORPTION MODEL CONTROL, KSROP  . . . . . . . . . .',I5/5X,
     > 'LGRANGIAN INDICATOR, LGRN  . . . . . . . . . . . .',I5/)
 2040 FORMAT('0'//5X,
     1 'TIME INTEGRATION PARAMTER, Wt. . . . . . . . . . .',1PD15.6/5X,
     2 'TIME INTEGRATION FACTOR FOR VELOCITY TERM, WVt . .',1PD15.6/5X,
     3 'ITERATION PARAMETER FOR NONLINEAR EQUATION, OMEt .',1PD15.6/5X,
     4 'RELAXATION PARAMETER FOR MATRIX EQUATION, OMIt . .',1PD15.6/)
 2050 FORMAT(/' **** ITERATION PARAMETERS (flow only) ****'/5X,
     > ' NO. OF ITERATIONS PER CYCLE, NITERf. . . . . . . . .',I5/5X,
     > ' NO. OF CYCLES PER TIME STEP, NCYLf . . . . . . . . .',I5/5X,
     > ' NO. OF ITERATIONS ALLOWED FOR SOLVING MATRIX EQ . .',I5/5X,
     > ' STEADY-STATE TOLERANCE, TOLAf . . . . . . . . . .',1PD15.6/5X,
     > ' TRANSIENT-STATE TOLERANCE, TOLBf. . . . . . . . .',1PD15.6/)
 2060 FORMAT(/' *** ITERATION PARAMETERS (transport only) ***'/5X,
     1 'NO. OF ITERATIONS FOR NONLINEAR EQUATION, NITERt .',I5/5X,
     2 'NO. OF ITERATIONS FOR MATRIX EQUATION, NPITERt . .',I5/5X,
     1 'ERROR ALLOWANCE FOR STEADY STATE SOLUTION, TOLAt .',1PD15.6/5X,
     2 'ERROR ALLOWANCE FOR TRANSIENT SOLUTION, TOLBt. . .',1PD15.6/)
 2070 FORMAT('1'/5X,'*** TIME CONTROL PARAMTER ***'/5X,
     > ' NUMBER OF TIME INCREMENTS,NTI. . . . . . . . . . . .',I5/5X,
     > ' NO. OF TIMES TO RESET TIME STEP SIZE, NDTCHG . . . .',I5/)
 2080 FORMAT('0'/5X,
     > ' TIME INCREMENT, DELT. . . . . . . . . . . . . . .',1PD15.6/5X,
     > ' MULTIPLIER FOR INCREASING DELT, CHNG. . . . . . .',1PD15.6/5X,
     > ' MAXIMUM VALUE OF DELT, DELMAX . . . . . . . . . .',1PD15.6/5X,
     > ' MAXIMUM VALUE OF TIME, TMAX . . . . . . . . . . .',1PD15.6/)
 2110 FORMAT('0',' LINNE PRINTER OUTPUT CONTROL'/(6X,30I2))
 2120 FORMAT('0',' DISK OUTPUT CONTROL'/(6X,30I2))
 2130 FORMAT('0','TIME OF CHANGING DELT AND DELT ARE RESET TO'/
     >       (8X,6D12.4))
 2150 FORMAT('0'//5X,
     > 'INCOORPERATING FINE GRIDS? IZOOM . . . . . . . . . ',I3/5X,
     > 'USING FINE GRIDS TO SOLVE MATRIX EQ.? IDZOOM . . . ',I3/5X,
     > 'CAPTURING EPCOF POINTS? IEPC . . . . . . . . . . . ',I3/5X,
     > 'THE NUMBER OF REFINED GRIDS IN X-DIRECTION, NXG. . ',I3/5X,
     > 'THE NUMBER OF REFINED GRIDS IN Y-DIRECTION, NYG  . ',I3/5X,
     > 'THE NUMBER OF REFINED GRIDS IN Z-DIRECTION, NZG  . ',I3/5X,
     > 'THE NUMBER OF REF. WORKING GRIDS IN X-DIRECTION,NXW',I3/5X,
     > 'THE NUMBER OF REF. WORKING GRIDS IN Y-DIRECTION,NYW',I3/5X,
     > 'THE NUMBER OF REF. WORKING GRIDS IN Z-DIRECTION,NZW',I3/5X,
     > 'THE NUMBER OF REF. DIFF. GRIDS IN X-DIRECTION,NXD .',I3/5X,
     > 'THE NUMBER OF REF. DIFF. GRIDS IN Y-DIRECTION,NYD .',I3/5X,
     > 'THE NUMBER OF REF. DIFF. GRIDS IN Z-DIRECTION,NZD .',I3/5X,
     > 'THE INDEX OF CALC. TRACKING VEL., 1:AVG, 2:SINGLE .',I3/)
 2155 FORMAT('0'//5X,
     > 'THE ADAPTION ERROR TOLERANCE 1, ADPEPS  . . . . . .',D12.5/5X,
     > 'THE ADAPTION ERROR TOLERANCE 2, ADPARM  . . . . . .',D12.5/)
      END
C
C
C
C
      SUBROUTINE HTMICH( sk,rk,pk,aa,il,nd,nt,
     > X,IE,IB,LRN,LRL,NLRL, CMATRX,RLD,RI,RL, H,HP,HW,HT,
     1 V,VP,VEAVG,WETAB, C,CP,CS,DTI,F,CMX, WWRK,TH,THP,THN,DTH,AKHC,
     1 AKDC, DCOSB,ISB,NPBB, BFLXf,BFLXt, NPCNV,
     2 SOSf,SOSFf,TSOSFf,ISTYPf,LESf, WSSf,WSSFf,TWSSFf,IWTYPf,NPWf,
     3 LESt,SOSt,SOSFt,TSOSFt,ISTYPt, NPWt,WSSt,WSSFt,TWSSFt,IWTYPt,
     > ILSV,IMSV,
     3 QCBf,QCBFf,TQCBFf,ICTYPf,ISCf,NPCBf, QCBt,QCBFt,TQCBFt,ICTYPt,
     3 ISCt,NPCBt, QNBf,QNBFf,TQNBFf,INTYPf,ISNf,NPNBf, QNBt,QNBFt,
     4 TQNBFt,INTYPt,ISNt,NPNBt, QVBf,QVBFf,TQVBFf,IVTYPf,ISVf,NPVBf,
     4 RSVAB,INDRS, CVBt,CVBFt,TCVBFt,IVTYPt,ISVt,NPVBt,
     5 HDBf,HDBFf,THDBFf,IDTYPf,NPDBf,CDBt,CDBFt,TCDBFt,IDTYPt,NPDBt,
c     5 PROPf,SPP, PROPt,RKD,TRANC, DINTS,RHOMU, KPR,KDSK,TDTCH,
     5 PROPf,SPP, PROPt,RKD,TRANC, DINTS, KPR,KDSK,TDTCH,
     7 NNPLR,LMAXDF,GNLR,LNOJCN,CMTRXL,RLDL,NBDYB,IBDY,XW,VXW,CW,MWLOC,
     8 LRLW,NLRLW,IEW,IBW,DL468,ieww,ibww,lrlww,nlrlww,xww,vxww,dl468w,
     > IBE,IBCHK,XPFG,CPFG,MPLOC,XSFG,CSFG,MPLOCS,XWFG,CWFG,MPLOCW,
     > XEFG,CEFG,MPLOCE,NFGM,NFGMB,NFGMBB,MAXFGW,MINFGW,CMAXFG,CMINFG,
     > ISE,NEPWN,NEPW,ISED,NDBD,MPLOCD,NLRND,NCFG,DTIFG,
     > JTMJTM,IRXN,IMOD,IBUG,ICHNG,NITFTS,OMEFTS,ALLOW,
     > TITLE,NPROB)
C
      IMPLICIT REAL*8(A-H,O-Z)
      CHARACTER*32 SUBHD
      INTEGER*4 GNLR
      CHARACTER TITLE*70
C
C ------- COMMON block for both flow and transport
C
      COMMON /SGEOM/ MAXEL,MAXNP,MXADNP,MAXBES,MXTUBS,MAXBNP,MXJBD,
     >               MXKBD,MXNTI,MXDTC
      COMMON /CGEOM/ NNP,NEL,NBNP,NTUBS,NBES,NTI,NDTCHG,ISHAPE
      COMMON /LGEOM/ LTMXNP,LMXNP,LMXBW,MXREGN,NREGN
      COMMON /SCMTL/ MAXMAT,MXSPPM,MXMPPM,NMAT,NMPPM,NSPPM
      COMMON /NOPTN/ ILUMP,IMID,IWET,IOPTIM,KSORP,LGRN,IQUAR
      COMMON /PCG/ GG,IEIGEN
      COMMON /NINTR/ KPR0,KDSK0,NSTRf,NSTRt,KSSf,KSSt,IGEOM
      COMMON /CTIM/ DELT,CHNG,DELMAX,TMAX,DELT0,TIME
C
C ------- COMMON block for flow iteration and material control
C
      COMMON /FINTE/ NCYLf,NITERf,NPITERf,KSP,KGRAV,IPNTSf
      COMMON /FREAL/ TOLAf,TOLBf,Wf,OMEf,OMIf,GRAV,cnstkr
C
C ------- COMMON block for transport iteration and material control
C
      COMMON /TINTE/ NCMt,KVIt,NITERt,NPITERt,IPNTSt,MICONF,IFLUX
      COMMON /TREAL/ Wt,WVt,OMEt,OMIt,TOLAt,TOLBt
      COMMON /TADP/ ADPEPS,ADPARM,IZOOM,IDZOOM,IEPC,NXG,NYG,NZG,
     >              NXW,NYW,NZW,NXD,NYD,NZD,IDETQ
C
C ------- COMMON block for flow source/sink
C
      COMMON /FCS/ MXSELf,MXSPRf,MXSDPf,NSELf,NSPRf,NSDPf,KSAIf
      COMMON /FCW/ MXWNPf,MXWPRf,MXWDPf,NWNPf,NWPRf,NWDPf,KWAIf
C
C ------- COMMON block for transport source/sink
C
      COMMON /CELS/ MXSELt,MXSPRt,MXSDPt,NSELt,NSPRt,NSDPt,KSAIt
      COMMON /CNPS/ MXWNPt,MXWPRt,MXWDPt,NWNPt,NWPRt,NWDPt,KWAIt
C
C ------- COMMON block for flow boundary conditions
C
      COMMON /FCBC/ MXCNPf,MXCESf,MXCPRf,MXCDPf,
     .              NCNPf,NCESf,NCPRf,NCDPf,KCAIf
      COMMON /FNBC/ MXNNPf,MXNESf,MXNPRf,MXNDPf,
     .              NNNPf,NNESf,NNPRf,NNDPf,KNAIf
      COMMON /FVBC/ MXVESf,MXVNPf,MXVPRf,MXVDPf,
     .              NVESf,NVNPf,NVPRf,NVDPf,KVAIf
      COMMON /FDBC/ MXDNPf,MXDPRf,MXDDPf,NDNPf,NDPRf,NDDPf,KDAIf
C
C ------- COMMON block for transport boundary conditions
C
      COMMON /TCBC/ MXCNPt,MXCESt,MXCPRt,MXCDPt,
     .              NCNPt,NCESt,NCPRt,NCDPt,KCAIt
      COMMON /TNBC/ MXNNPt,MXNESt,MXNPRt,MXNDPt,
     .              NNNPt,NNESt,NNPRt,NNDPt,KNAIt
      COMMON /TVBC/ MXVESt,MXVNPt,MXVPRt,MXVDPt,
     .              NVESt,NVNPt,NVPRt,NVDPt,KVAIt
      COMMON /TDBC/ MXDNPt,MXDPRt,MXDDPt,NDNPt,NDPRt,NDDPt,KDAIt
      COMMON /TFLUX/ MXLSV,MXMSV
C
C ------- COMMON block for flow material balance
C
      COMMON /FFLOW/ FRATEf(10),FLOWf(10),TFLOWf(10)
C
C ------- COMMON block for transport material balance
C
      COMMON /TFLOW/ FRATEt(14),FLOWt(14),TFLOWt(14,7)
C
C ------- Advection weighting factors
C
      COMMON /WETX/ APHA1,APHA2,APHA3,APHA4
      COMMON /WETY/ BETA1,BETA2,BETA3,BETA4
      COMMON /WETZ/ GAMA1,GAMA2,GAMA3,GAMA4
C
      COMMON /SAZFM/ MXNPFG,MXKGL,MXKGLD,MXNEP,MXEPW,MXNPW,MXELW,MXNDB,
     >               mxnpww,mxelww
      COMMON /CHEM/ MXNCC,NCC
      COMMON /MICROB/ GRATE,YCOEFF,RTARDS,RTARDO,RTARDN,SCOEFF,
     >                ECOEFF,DCOEFF,SATURC,PCOEFF,COFK
C
C ------- Arrays for both flow and transport
C
      DIMENSION X(MAXNP,3),IE(MAXEL,11),LRL(MXKBD,MAXNP),NLRL(MAXNP)
      DIMENSION IB(MAXNP),LRN(MXJBD,MXADNP)
      DIMENSION CMATRX(MXADNP,MXJBD),RLD(MXADNP),RI(MXADNP),RL(MXADNP)
      DIMENSION sk(mxadnp),rk(mxadnp),pk(mxadnp),aa(mxadnp,mxjbd)
      DIMENSION il(mxadnp),nd(mxadnp),nt(maxnp)
      DIMENSION NNPLR(MXREGN),LMAXDF(MXREGN)
      DIMENSION GNLR(LTMXNP,MXREGN),LNOJCN(MXJBD,LMXNP,MXREGN)
      DIMENSION CMTRXL(LMXNP,LMXBW),RLDL(LMXNP)
C
      DIMENSION DCOSB(3,MAXBES),ISB(6,MAXBES), NPBB(MAXBNP)
      DIMENSION KPR(MXNTI),KDSK(MXNTI),TDTCH(MXDTC,2)
C
      DIMENSION V(MAXNP,3),TH(MAXEL,8)
C
C ------- Arrays for flow only
C
      DIMENSION H(MAXNP),HP(MAXNP),HW(MAXNP),HT(MAXNP)
      DIMENSION DTH(MAXEL,8),AKHC(8,MAXEL,7),NPCNV(MAXNP)
C
      DIMENSION BFLXf(MAXBNP,2)
C
      DIMENSION SOSf(MXSPRf),SOSFf(MXSDPf,MXSPRf),TSOSFf(MXSDPf,MXSPRf)
      DIMENSION ISTYPf(MXSELf),LESf(MXSELf)
      DIMENSION WSSf(MXWPRf),WSSFf(MXWDPf,MXWPRf),TWSSFf(MXWDPf,MXWPRf)
      DIMENSION IWTYPf(MXWNPf),NPWf(MXWNPf)
C
      DIMENSION QCBf(MXCPRf),QCBFf(MXCDPf,MXCPRf),TQCBFf(MXCDPf,MXCPRf)
      DIMENSION ICTYPf(MXCESf),ISCf(5,MXCESf),NPCBf(MXCNPf)
C
      DIMENSION QNBf(MXNPRf),QNBFf(MXNDPf,MXNPRf),TQNBFf(MXNDPf,MXNPRf)
      DIMENSION INTYPf(MXNESf),ISNf(5,MXNESf),NPNBf(MXNNPf)
C
      DIMENSION QVBf(MXVPRf),QVBFf(MXVDPf,MXVPRf),TQVBFf(MXVDPf,MXVPRf)
      DIMENSION IVTYPf(MXVESf),ISVf(5,MXVESf),NPVBf(MXVNPf)
      DIMENSION RSVAB(MXVNPf,4),INDRS(MXVNPf,3)
C
      DIMENSION HDBf(MXDPRf),HDBFf(MXDDPf,MXDPRf),THDBFf(MXDDPf,MXDPRf)
      DIMENSION IDTYPf(MXDNPf),NPDBf(MXDNPf)
C
      DIMENSION PROPf(MAXMAT,MXMPPM),SPP(MXSPPM,MAXMAT,4)
c      DIMENSION rhomu(mxncc),DINTS(MXNCC)
      DIMENSION DINTS(MXNCC)
      DIMENSION SUBHD(3)
C
C ------- Arrays for transport only
C
      DIMENSION C(MAXNP,MXNCC),CP(MAXNP,MXNCC)
      DIMENSION CS(MAXNP,MXNCC),DTI(MAXNP,MXNCC)
      DIMENSION F(MAXNP,3,MXNCC),CMX(MXNCC)
C
      DIMENSION BFLXt(MAXBNP,2,MXNCC),WWRK(MAXNP)
C
      DIMENSION WETAB(12,MAXEL),VP(MAXNP,3),VEAVG(MAXNP,3,MXNCC)
      DIMENSION THP(MAXEL,8),THN(MAXNP,2,MXNCC),AKDC(8,MXKGLD,8)
C
      DIMENSION SOSt(MXSPRt,2),SOSFt(MXSDPt,MXSPRt,2),
     .          TSOSFt(MXSDPt,MXSPRt)
      DIMENSION ISTYPt(MXSELt,MXNCC),LESt(MXSELt)
      DIMENSION WSSt(MXWPRt,2),WSSFt(MXWDPt,MXWPRt,2),
     .          TWSSFt(MXWDPt,MXWPRt)
      DIMENSION IWTYPt(MXWNPt,MXNCC),NPWt(MXWNPt)
C
      DIMENSION QCBt(MXCPRt),QCBFt(MXCDPt,MXCPRt),TQCBFt(MXCDPt,MXCPRt)
      DIMENSION ICTYPt(MXCESt,MXNCC),ISCt(5,MXCESt),NPCBt(MXCNPt)
C
      DIMENSION CVBt(MXVPRt),CVBFt(MXVDPt,MXVPRt),TCVBFt(MXVDPt,MXVPRt)
      DIMENSION IVTYPt(MXVESt,MXNCC),ISVt(5,MXVESt),NPVBt(MXVNPt)
C
      DIMENSION CDBt(MXDPRt),CDBFt(MXDDPt,MXDPRt),TCDBFt(MXDDPt,MXDPRt)
      DIMENSION IDTYPt(MXDNPt,MXNCC),NPDBt(MXDNPt)
C
      DIMENSION QNBt(MXNPRt),QNBFt(MXNDPt,MXNPRt),TQNBFt(MXNDPt,MXNPRt)
      DIMENSION INTYPt(MXNESt,MXNCC),ISNt(5,MXNESt),NPNBt(MXNNPt)
C
      DIMENSION PROPt(MAXMAT,MXMPPM),RKD(MAXMAT,MXNCC)
      DIMENSION TRANC(MAXMAT,MXNCC)
      DIMENSION GRATE(4),YCOEFF(4),RTARDS(4),RTARDO(4),RTARDN(4),
     >          SCOEFF(4),ECOEFF(4),DCOEFF(4),SATURC(4),PCOEFF(4)
C
      DIMENSION NBDYB(MAXNP),IBDY(MXTUBS),CW(MXNPW)
      DIMENSION IEW(MXELW,8,3),IBW(MXNPW,3),LRLW(24,MXNPW,3)
      DIMENSION NLRLW(MXNPW,3),XW(MXNPW,3),VXW(MXNPW,3),MWLOC(MXNPW)
      DIMENSION IEWw(MXELWw,8,3),IBWw(MXNPWw,3),LRLWw(24,MXNPWw,3)
      DIMENSION NLRLWw(MXNPWw,3),XWw(MXNPWw,3),VXWw(MXNPWw,3)
      DIMENSION DL468w(8,MXNPWw,3)
C
      DIMENSION IBE(MAXEL),IBCHK(MAXEL),DL468(8,MXNPW,3)
      DIMENSION XPFG(MXNPFG,3),CPFG(MXNPFG,MXNCC),MPLOC(MXNPFG)
      DIMENSION XSFG(MXNPFG,3),CSFG(MXNPFG,MXNCC),MPLOCS(MXNPFG)
      DIMENSION XWFG(MXNPFG,3),CWFG(MXNPFG,MXNCC),MPLOCW(MXNPFG)
      DIMENSION XEFG(MXNEP,3),CEFG(MXNEP,MXNCC),MPLOCE(MXNPFG)
      DIMENSION NFGM(MAXEL),NFGMB(MAXEL),MAXFGW(MXELW,MXNCC)
      DIMENSION MINFGW(MXELW,MXNCC),CMAXFG(MXELW,MXNCC),NEPWN(MXELW)
      DIMENSION CMINFG(MXELW,MXNCC),ISE(MXKGL,8),NEPW(MXELW,MXEPW)
      DIMENSION ISED(MXKGLD,9),NDBD(MXNDB),MPLOCD(MXNDB),NLRND(MXADNP)
      DIMENSION NCFG(2*MXNCC),DTIFG(MXNPFG,MXNCC)
      DIMENSION ILSV(MXLSV,5),IMSV(MXMSV,4),NFGMBB(MAXEL)
C
      DATA SUBHD/'INPUT INITIAL CONDITIONS        ',
     > 'STEADY-STATE INITIAL CONDITIONS ',
     > '                                '/
      DATA EPSX/1.0D-8/
C
c ------- Compute machine epsilon and square root of machine epsilon
      epslon=1.0d0
    1 epslon=epslon/2.0d0
      tol1=1.0d0+epslon
      if(tol1.gt.1.0d0) go to 1
      sqeps=dsqrt(epslon)
      print 2, epslon,sqeps
    2 format(1h ,'machine epsilon =',1pd20.10/1x,
     > 'square root of machine epsilon =',1pd20.10)
C
C ------- Print error message for illegal combination of KSSf and KSSt
C
      IF (KSSf.EQ.1 .AND. KSSt.EQ.0) THEN
        PRINT *, '====> Error: illegal combination of KSSf and KSSt.'
        PRINT *, '      Simulation halt.'
        STOP
      ENDIF
C
C ***** DETERMINE THE INDEX INDICATING DENSITY EFFECT
C
      IF(IMOD.EQ.10 .OR. IMOD.EQ.1)THEN
        IRHO=0
      ELSEIF(KVIT.EQ.1 .AND. KSST.EQ.1 .AND. KSSF.EQ.0)THEN
        IRHO=0
      ELSE
        IRHO=1
      ENDIF
      IF(IRHO.EQ.0)THEN
        DO NP=1,NEL
          DO I=1,8
            AKHC(I,NP,7)=1.0D0
          ENDDO
        ENDDO
      ENDIF
C
C ------- PREPARE INITIAL OR PRE-INITIAL VARIABLES
C
      KOUT=0
      TIME=0.0
      KDIG=0
      JTM=0
C
      IF (KVIt.LT.0) THEN
C
C ******* data set 25: fluid velocity and saturation
C ------- READ FLOW VARIABLES VIA LOGICAL UNIT 15
C
        READ(15,9) DATNAM
        PRINT *, 'DATNAM in MTMICH =',DATNAM
        NPI=0
  120   READ(15,*) NI,NSEQ,NAD,VXNI,VYNI,VZNI,VXAD,VYAD,VZAD
        IF(NI.EQ.0) GO TO 140
C
        NJ=NI+NSEQ
        DO NP=NI,NJ
          I=NI+(NP-NI)*NAD
          V(I,1)=VXNI+VXAD*  dble(NP-NI)
          V(I,2)=VYNI+VYAD*  dble(NP-NI)
          V(I,3)=VZNI+VZAD*  dble(NP-NI)
          NPI=NPI+1
        ENDDO
        GO TO 120
  140   IF(NPI.NE.NNP) THEN
          WRITE(16,1400)
          STOP
        ENDIF
C
C -------- PRINT INPUT VELOCITY
C
        LINE=0
        DO NP=1,NNP,2
          LINE=LINE+1
          IF(MOD(LINE-1,50).EQ.0) WRITE(16,1500)
          NJMN=NP
          NJMX=MIN0(NP+1,NNP)
          WRITE(16,1550) (NJ,(V(NJ,I),I=1,3),NJ=NJMN,NJMX)
        ENDDO
C
C ------ READ MOISTURE CONTENT VIA LOBICAL UNIT 15
C
        NPI=0
  160   READ(15,*) NI,NSEQ,NAD,THNI,THNIAD
        IF(NI.EQ.0) GO TO 180
        NJ=NI+NSEQ
        DO NP=NI,NJ
          I=NI+(NP-NI)*NAD
          DO IQ=1,8
            TH(I,IQ)=THNI+THNIAD*  dble(NP-NI)
          ENDDO
          NPI=NPI+1
        ENDDO
        GO TO 160
  180   IF(NPI.NE.NEL) THEN
          WRITE(16,1800)
          STOP
        ENDIF
C
C ------- PRINT CARD INPUT MOISTURE CONTENT
C
        LINE=0
        DO NP=1,NEL
          LINE=LINE+1
          IF(MOD(LINE-1,50).EQ.0) WRITE(16,1900)
          WRITE(16,1950) NP,(TH(NP,IQ),IQ=1,8)
        ENDDO
C
C ------- Flow variables simulation reqired;
C ------- Prepare the initial/pre-initial data for flow
C
      ENDIF
C
      IF(NSTRf.LE.0 .AND. IMOD.NE.1)THEN
        IF(NSELf.NE.0) CALL ESSFCT(SOSf,TSOSFf,SOSFf,TIME,
     1     MXSPRf,MXSDPf,NSPRf,NSDPf,KSAIf)
        IF(NWNPf.NE.0) CALL WSSFCT(WSSf,TWSSFf,WSSFf,TIME,
     1     MXWPRf,MXWDPf,NWPRf,NWDPf,KWAIf)
        IF(NCESf.NE.0) CALL CBVFCT(QCBf,TQCBFf,QCBFf,TIME,
     1     MXCPRf,MXCDPf,NCPRf,NCDPf,KCAIf)
        IF(NNESf.NE.0) CALL NBVFCT(QNBf,TQNBFf,QNBFf,TIME,
     1     MXNPRf,MXNDPf,NNPRf,NNDPf,KNAIf)
        IF(NVESf.NE.0) CALL VBVFCT(QVBf,TQVBFf,QVBFf,TIME,
     1     MXVPRf,MXVDPf,NVPRf,NVDPf,KVAIf)
        IF(NDNPf.NE.0) CALL DBVFCT(HDBf,THDBFf,HDBFf,TIME,
     1     MXDPRf,MXDDPf,NDPRf,NDDPf,KDAIf)
      ENDIF
C
      IF(NSTRt.LE.0 .AND. IMOD.NE.10)THEN
        IF(NSELt.NE.0) CALL ESSFCT(SOSt(1,1),TSOSFt,SOSFt(1,1,1),TIME,
     1     MXSPRt,MXSDPt,NSPRt,NSDPt,KSAIt)
        IF(NSELt.NE.0) CALL ESSFCT(SOSt(1,2),TSOSFt,SOSFt(1,1,2),TIME,
     1     MXSPRt,MXSDPt,NSPRt,NSDPt,KSAIt)
        IF(NWNPt.NE.0) CALL WSSFCT(WSSt(1,1),TWSSFt,WSSFt(1,1,1),TIME,
     1     MXWPRt,MXWDPt,NWPRt,NWDPt,KWAIt)
        IF(NWNPt.NE.0) CALL WSSFCT(WSSt(1,2),TWSSFt,WSSFt(1,1,2),TIME,
     1     MXWPRt,MXWDPt,NWPRt,NWDPt,KWAIt)
c
        do i=1,nwnpt
          np=npwt(i)
          iprof=iwtypt(i,1)
          if(wsst(iprof,1).gt.0.0d0)then
            ib(np)=-1
          else
            ib(np)=-2
          endif
        enddo
c
        IF(NDNPt.NE.0) CALL DBVFCT(CDBt,TCDBFt,CDBFt,TIME,
     1     MXDPRt,MXDDPt,NDPRt,NDDPt,KDAIt)
        IF(NVESt.NE.0) CALL VBVFCT(CVBt,TCVBFt,CVBFt,TIME,
     1     MXVPRt,MXVDPt,NVPRt,NVDPt,KVAIt)
        IF(NCNPt.NE.0) CALL CBVFCT(QCBt,TQCBFt,QCBFt,TIME,
     1     MXCPRt,MXCDPt,NCPRt,NCDPt,KCAIt)
        IF(NNNPt.NE.0) CALL NBVFCT(QNBt,TQNBFt,QNBFt,TIME,
     1     MXNPRt,MXNDPt,NNPRt,NNDPt,KNAIt)
      ENDIF
C
      IF(NSTRf.LE.0 .AND. IMOD.NE.1)THEN
C
C ------- PUT DIRICHLET BOUNDARY VALUES TO INITIAL CONDITIONS
C
        DO I=1,NDNPf
          NP=NPDBf(I)
          ITYP=IDTYPf(I)
          H(NP)=HDBf(ITYP)-X(NP,3)*  dble(KGRAV)
        ENDDO
c
        do np=1,nbnp
          bflxf(np,2)=0.0
        end do
        do np=1,nnp
          hp(np)=h(np)
        enddo
        DO M=1,NEL
          DO IQ=1,8
            TH(M,IQ)=0.0D0
          ENDDO
        ENDDO
C
        CALL SPROP
c     >   (AKHC,TH,DTH,X,H,CP,IE, PROPf,DINTS,RHOMU,SPP, IRHO,IQUAR,KSP,
     >   (AKHC,TH,DTH,X,H,CP,IE, PROPf,DINTS,SPP, IRHO,IQUAR,KSP,
     >    cnstkr)
C
        CALL VELT(V, CMATRX, X,IE,H,HT,AKHC,IQUAR)
        KFLOW=-1
C
        CALL FSFLOW(X,IE,NLRL,LRL, H,HP,V,TH,DTH,AKHC(1,1,7),PROPf(1,7),
     >     ISTYPT,SOST(1,2),IWTYPT,WSST(1,2),CP,
     1     BFLXf,DCOSB,ISB,NPBB, LESf,SOSf,ISTYPf, WSSf,IWTYPf,NPWf,
c     2     NPVBf,NPDBf,NPCBf,NPNBf, DINTS,RHOMU, DELT, KFLOW,IQUAR,IRHO)
     2     NPVBf,NPDBf,NPCBf,NPNBf, DINTS, DELT, KFLOW,IQUAR,IRHO)
C
        DO 240 I=1,9
          IF(I.EQ.9) GO TO 240
          FLOWf(I)=0.0
          TFLOWf(I)=0.0
  240   CONTINUE
        FLOWf(9)=0.0
C
C ------- PRINT INITIAL OR PRE-INITIAL VARIABLES
C
        KDIAG=0
C
        CALL FPRINT(V,H,HT,TH, BFLXf, NPVBf,RSVAB,INDRS, SUBHD(1),
     >              TIME,DELT,KPR0,KOUT,KDIAG,-1)
        CALL FSTORE(X,IE, H,HT,TH,
     1     V,INDRS, DCOSB,ISB,NPBB, NNPLR,GNLR, TITLE,JTM,TIME,NPROB,
     >     AKHC(1,1,7))                                                  3/15/95
C
        IF(KSSf.EQ.1 .AND. KDSK0.EQ.1) CALL FSTORE(X,IE, H,HT,TH,
     1     V,INDRS, DCOSB,ISB,NPBB, NNPLR,GNLR, TITLE,JTM,TIME,NPROB,
     >     AKHC(1,1,7))                                                  3/15/95
C
        IF (KSSf.EQ.1 .AND. IMOD.EQ.10) GO TO 500
C
      ENDIF
C
C ------- PREPARE INITIAL OR PRE-INITIAL VARIABLES for transport
C
      IF(IMOD.NE.10 .AND. NSTRt.LE.0)THEN
C
C ------- APPLY DIRICHLET BOUNDARY SPECIFICATIONS TO INITIAL CONDITIONS
C
        DO NPP=1,NDNPt
          NP=NPDBt(NPP)
          DO K=1,NCC
            ITYP=IDTYPt(NPP,K)
            CP(NP,K)=CDBt(ITYP)
          ENDDO
        ENDDO
C
C ------ INITIATE C
C
        DO K=1,NCC
          DO NP=1,NNP
            C(NP,K)=CP(NP,K)
          ENDDO
        ENDDO
C
        DO NP=1,NNP
          VP(NP,1)=V(NP,1)
          VP(NP,2)=V(NP,2)
          VP(NP,3)=V(NP,3)
        ENDDO
        DO M=1,NEL
          DO IQ=1,8
            DTH(M,IQ)=0.0D0
            THP(M,IQ)=TH(M,IQ)
          ENDDO
        ENDDO
C
        CALL THNODE(THN(1,1,1),TH,THP,PROPt,RKD(1,1),WWRK,IE,X)
        CALL DISPC
     I    (X,IE,V,VP,TH,THP,H,PROPt,Wt,KSSt,IQUAR,XWFG,CWFG,NEL,cnstkr,
c     I     ISED,1,MAXEL,7,KSP,KVIT,SPP,RHOMU,DINTS,IRHO,PROPf(1,7),
     I     ISED,1,MAXEL,7,KSP,KVIT,SPP,DINTS,IRHO,PROPf(1,7),
     O     AKHC)
        CALL AFABTA
     I      (X,IE,  V,VP,  Wt,KSSt,IOPTIM,  THN(1,2,1),PROPt,
     O       WETAB)
C
        LINE=0
        DO MP=1,NEL
          LINE=LINE+1
          IF(MOD(LINE-1,50).EQ.0) WRITE(16,3400)
          WRITE(16,3450) MP, (WETAB(IQ,MP),IQ=1,12)
        ENDDO
C
        KFLOW=-1
C
        DO K=1,NCC
          do np=1,nbnp
            bflxt(np,2,k)=0.0
          enddo
        ENDDO
c
        DO 415 K=1,NCC
C
          CMX(K)=-1.0D38
          DO NP=1,NNP
            CMX(K)=DMAX1(CMX(K),CP(NP,K))
          ENDDO
C
          CALL FLUX(F(1,1,K),CMATRX,CP(1,K),X,IE,V,AKHC,IQUAR)
C
          CALL TSFLOW(BFLXt(1,1,K),X,IE,CP(1,K),F(1,1,K),TH,RKD(1,K),
     >      TRANC(1,K), DCOSB,ISB,NPBB,SOSt,ISTYPt(1,K),LESt,WSSt,
     >      IWTYPt(1,K),NPWt,NPVBt,NPDBt,NPCBt,NPNBt, PROPt,
     >      DELT,KFLOW,K)
C
          DO 410 I=1,14
            IF(I.EQ.8 .OR. I.EQ.9) GO TO 410
            FLOWt(I)=0.0
            TFLOWt(I,K)=0.0
  410     CONTINUE
          FLOWt(8)=0.0
          FLOWt(9)=0.0
C
C ------- PRINT INITIAL OR PRE-INITIAL VARIABLES
C
          KDIAG=-2
C
          CALL TPRINT(CP(1,K),F(1,1,K),TIME,DELT, KPR0,KOUT,KDIAG, -1,K)
  415   CONTINUE
C
        CALL TSTORE(X,IE, CP,F,TITLE,NPROB,JTM,TIME)
        IF(IMOD.EQ.0) RETURN
C
        IF(KDSK0.EQ.1 .AND. KSSt.EQ.1)
     1     CALL TSTORE(X,IE, CP,F,TITLE,NPROB,JTM,TIME)
C
c       IF (KSSt.EQ.1) GO TO 500
C
C ------- If KVIt .GE. 0 and imod = 01, no velocity and moisture fields
C ------- were read.  Print warning message, and use the velocity and
C ------- moisture fields calculated using initial pressure heads.
C
c       IF (KVIt.GE.0 .AND. imod.EQ.1) THEN
c         PRINT *, '====> Warning: no card input velocity and moisture'
c         PRINT *, '      fields. The velocity and moisture field '
c         PRINT *, '      calculated using initial pressure heads '
c         PRINT *, '      will be used for transport simulations. '
c       ENDIF
C
      ENDIF
c
      IF(KSSf.EQ.1 .AND. KSSt.EQ.1)GOTO 500
C
C ***** START STEADY-STATE ITERATION LOOP
C
      IF(IMOD.NE.1)EPSS=0.5D0*TOLAf
      IF(IMOD.NE.10)EPST=0.5D0*TOLAt
C
      DO K=1,NCC
        DO NP=1,NNP
          C(NP,K)=CP(NP,K)
        ENDDO
      ENDDO
C
      DO 440 ITER=1,NITFTS
C
C -------- Pass to HYDRO for steady state hydrological
C -------- calculations
C
        IF(IMOD.NE.1 .AND. KSSf.EQ.0 .AND. NSTRf.EQ.0) THEN
          DO NP=1,NNP
            HP(NP)=H(NP)
          ENDDO
          CALL HMCHYD(X,IE,LRN,LRL,NLRL, CMATRX,RLD,RI,RL, H,HP,HW,HT,C,
     .     ISTYPT,SOST(1,2),IWTYPT,WSST(1,2), sk,rk,pk,aa,il,nd,nt,
     1     V,  TH,DTH,AKHC, NPCNV, DCOSB,ISB,NPBB,BFLXf,
     2     SOSf,ISTYPf,LESf, WSSf,IWTYPf,NPWf,
     3     QCBf,ICTYPf,ISCf,NPCBf,QNBf,INTYPf,ISNf,NPNBf,
     4     QVBf,IVTYPf,ISVf,NPVBf, RSVAB,INDRS,
c     5     HDBf,IDTYPf,NPDBf, PROPf,SPP,DINTS,RHOMU, KPR,KDSK,KDIG,
     5     HDBf,IDTYPf,NPDBf, PROPf,SPP,DINTS, KPR,KDSK,KDIG,
     7     KOUT,JTM, NNPLR,LMAXDF,GNLR,LNOJCN,CMTRXL,RLDL,
     >     IRHO,IBUG,ICHNG,TITLE,NPROB,SQEPS)
C
C ----- CHECK CONVERGENCE OF FLOW PART
C
          NPP=0
          RD=-1.0D0
          RES=-1.0D0
          DO 420 NP=1,NNP
            RESNP=DABS(H(NP)-HP(NP))
            RES=DMAX1(RES,RESNP)
            IF(HP(NP).NE.0.0D0) RD=DMAX1(RD,DABS(RESNP/HP(NP)))
            IF(RESNP.GT.EPSS)NPP=NPP+1
  420     CONTINUE
          IF(IBUG.NE.0)WRITE(16,6300)ITER,RES,RD,NPP
C
        ENDIF
C
c        IF (imod.EQ.10) GO TO 445
         IF(IMOD.EQ.11 .AND. KSSt.NE.0)GOTO 445
C
         DO NP=1,NNP
           VP(NP,1)=V(NP,1)
           VP(NP,2)=V(NP,2)
           VP(NP,3)=V(NP,3)
         ENDDO
C
C ------- Pass to CHEMI  for steady state chemical transport
C ------- calculations
C
        IF(IMOD.NE.10 .AND. KSSt.EQ.0 .AND. NSTRt.EQ.0) THEN
          DO K=1,NCC
            DO NP=1,NNP
              CS(NP,K)=C(NP,K)
            ENDDO
          ENDDO
C
          CALL HMCTRN(C,CP,CS,DTI,F,RI,RL,X,IE,IB,LRL,NLRL,CMX,
c     .      sk,rk,pk,aa,il,nd,nt, IRHO,AKHC,RHOMU,cnstkr,DINTS,
     .      sk,rk,pk,aa,il,nd,nt, IRHO,AKHC,cnstkr,DINTS,
     1      LRN, CMATRX,RLD, NNPLR,LMAXDF,GNLR,LNOJCN,CMTRXL,RLDL,DCOSB,
     2      ISB,NPBB,BFLXt,WETAB,V,VP,VEAVG,H,TH,THP,WWRK,THN,
     3      AKDC, LESt,SOSt,ISTYPt, NPWt,WSSt,IWTYPt, ILSV,
     >      IMSV, QCBt,ICTYPt,ISCt,NPCBt,QNBt,INTYPt,ISNt,NPNBt,
     >      CVBt,IVTYPt,ISVt,NPVBt, CDBt,IDTYPt,NPDBt, PROPf(1,7),PROPt,
     >      SPP,RKD,TRANC,NBDYB,IBDY,XW,VXW,CW,MWLOC,LRLW,NLRLW,IEW,IBW,
     >      DL468,ieww,ibww,lrlww,nlrlww,xww,vxww,dl468w,IBE,IBCHK,XPFG,
     >      CPFG,MPLOC,XSFG,CSFG,MPLOCS,XWFG,CWFG,MPLOCW,XEFG,CEFG,
     >      MPLOCE,NFGM,NFGMB,NFGMBB,MAXFGW,MINFGW,CMAXFG,CMINFG,
     >      ISE,NEPWN,NEPW,ISED,NDBD,MPLOCD,NLRND,NCFG,DTIFG,NPFG,NEFG,
     7      KPR,KDSK,KDIG,KOUT,JTM,IRXN, IBUG,TITLE,NPROB,EPSX,SQEPS)
C
c       IF(IMOD.EQ.1)GOTO 448
c       IF(NSTRf.GT.0 .OR. NSTRt.GT.0)GOTO 445
C
C ----- CHECK CONVERGENCE OF TRANSPORT PART
C
          DIFMAX=-1.0D38
          NPMAX=1
          KMAX=1
          DO 428 K=1,NCC
            DO 425 NP=1,NNP
              ERROR=DABS(CS(NP,K)-C(NP,K))
              IF(ERROR.LE.CMX(K)*ALLOW)GOTO 425
              IF(CS(NP,K).EQ.0.0D0)GOTO 425
              DIF=ERROR/CS(NP,K)
              IF(DIF.GT.DIFMAX)THEN
                DIFMAX=DIF
                NPMAX=NP
                KMAX=K
              ENDIF
  425       CONTINUE
  428     CONTINUE
        ENDIF
C
c       print 432, iter,npp,npmax,res,difmax,epss,epst
c 432   format(3i3,4e12.5)
c       print 431,(i,hp(i),h(i),v(i,1),v(i,3),cs(i,1),
c    >             c(i,1),i=1,nnp)
c 431   format(i4,1x,6e12.5)
C
        IF(NITFTS.EQ.1)GOTO 445
C
        IF(IBUG.NE.0)WRITE(16,8010)ITER,KMAX,NPMAX,DIFMAX,EPST
C
        IF(DIFMAX.LE.EPST .AND. ITER.GT.1 .AND. RES.LE.EPSS)GOTO 445
C
C ----- UPDATE THE NONLINEAR ITERATED VALUE
C
        DO 430 NP=1,NNP
          H(NP)=OMEFTS*H(NP)+(1.0D0-OMEFTS)*HP(NP)
          DO K=1,NCC
            C(NP,K)=OMEFTS*C(NP,K)+(1.0D0-OMEFTS)*CS(NP,K)
          ENDDO
  430   CONTINUE
C
  440 CONTINUE
      WRITE(16,7500)ITM,ITER,NITFTS,DIFMAX,EPST
C
  445 CONTINUE
C
      IF(IMOD.NE.1 .AND. KSSf.EQ.0 .AND. NSTRf.EQ.0)THEN
C
C ------- PRINT STEADY-STATE VARIABLES
C
        KFLOW=0
        CALL FSFLOW(X,IE,NLRL,LRL, H,HP,V,TH,DTH,AKHC(1,1,7),PROPf(1,7),
     >     ISTYPT,SOST,IWTYPT,WSST,C,
     1     BFLXf,DCOSB,ISB,NPBB, LESf,SOSf,ISTYPf,WSSf,IWTYPf,NPWf,
c     2     NPVBf,NPDBf,NPCBf,NPNBf, DINTS,RHOMU, DELT, KFLOW,IQUAR,IRHO)
     2     NPVBf,NPDBf,NPCBf,NPNBf, DINTS, DELT, KFLOW,IQUAR,IRHO)
C
        DO I=1,9
          IF(I.NE.9) THEN
            FLOWf(I)=0.0
            TFLOWf(I)=0.0
          ENDIF
        ENDDO
        FLOWf(9)=0.0
C
        CALL FPRINT(V,H,HT,TH, BFLXf, NPVBf,RSVAB,INDRS,SUBHD(2),
     1              TIME,DELT, KPR0,KOUT,KDIAG,0)
C
        IF(KDSK0.EQ.1) CALL FSTORE(X,IE, H,HT,TH, V,INDRS,
     1     DCOSB,ISB,NPBB, NNPLR,GNLR, TITLE,JTM,TIME,NPROB,AKHC(1,1,7)) 3/15/95
      ENDIF
C
c     IF(IMOD.EQ.10)GOTO 450
C
C 448 CONTINUE
C
      IF(IMOD.NE.10 .AND. KSSt.EQ.0 .AND. NSTRt.EQ.0)THEN
C
C  ------- PRINT STEADY STATE  VARIABLES
C
        KDIAG=-1
C
        DO 455 K=1,NCC
          CALL FLUX(F(1,1,K),CMATRX,C(1,K),X,IE,V,AKHC,IQUAR)
C
          KFLOW=0
C
          CALL TSFLOW
     >      (BFLXt(1,1,K),X,IE,C(1,K),F(1,1,K),TH,RKD(1,K),TRANC(1,K),
     >       DCOSB,ISB,NPBB, SOSt,ISTYPt(1,K),LESt, WSSt,IWTYPt(1,K),
     >       NPWt,NPVBt,NPDBt,NPCBt,NPNBt,PROPt,DELT,KFLOW,K)
C
          DO 449 I=1,14
            IF(I.EQ.8 .OR. I.EQ.9) GO TO 449
            FLOWt(I)=0.0
            TFLOWt(I,K)=0.0
  449     CONTINUE
          FLOWt(8)=0.0
          FLOWt(9)=0.0
C
          CALL TPRINT(C(1,K),F(1,1,K),TIME,DELT, KPR0,KOUT,KDIAG, 0,K)
  455   CONTINUE
C
        IF(KDSK0.EQ.1)
     >    CALL TSTORE(X,IE,C,F,TITLE,NPROB,JTM,TIME)
      ENDIF
C
c 450 CONTINUE
      IF(NTI.EQ.0) GO TO 990
C
      JTM=JTMJTM
      KSSf=1
      KSSt=1
C
C ******* Transient state simulations
C
  500 CONTINUE
C
      IF (KVIt.EQ.1 .AND. IMOD.NE.10) imod = 1
C
      IF (IMOD.EQ.1) GO TO 550
      IF (NVESf.EQ.0 .OR. JTMJTM.GT.0) GO TO 550
C
      DO NPP=1,NVNPf
        NI=NPVBf(NPP)
        INDRS(NPP,1)=NPBB(NI)
        INDRS(NPP,2)=0
        INDRS(NPP,3)=0
      ENDDO
C
  550 TIME=TIME+DELT
      KSSf = 1
      TFLOWf(9)=0.0
      DO K=1,NCC
        TFLOWt(8,K)=0.0
        TFLOWt(9,K)=0.0
      ENDDO
C
C  ------- BEGIN THE TIME-MARCHING LOOP
C
      IDELT=0
      DO K=1,NCC
        do np=1,nnp
          c(np,K)=cp(np,K)
        enddo
      ENDDO
c
C ----- PREPARE INFORMATION FOR IN-ELEMENT TRACKING
C
      IF(LGRN.NE.0 .AND. IMOD.NE.10)THEN
C
C ----- PREPARE WORKING ARRAYS FOR LAGRANGIAN APPROACH
C
        IF(NSTRt.EQ.0)THEN
          NPFG=0
          DO M=1,NEL
            NFGMB(M)=0
          ENDDO
          DO K=1,2*NCC
            NCFG(K)=0
          ENDDO
        ENDIF
C
        IF(ISHAPE.EQ.4 .OR. ISHAPE.EQ.0) CALL ADVW3D
     I      (MXNPW,MXELW,NXW,NYW,NZW,4,EPSX,
     O       IBW(1,1),IEW(1,1,1),NLRLW(1,1),LRLW(1,1,1),DL468(1,1,1))
        IF(ISHAPE.EQ.6 .OR. ISHAPE.EQ.0) CALL ADVW3D
     I      (MXNPW,MXELW,NXW,NYW,NZW,6,EPSX,
     O       IBW(1,2),IEW(1,1,2),NLRLW(1,2),LRLW(1,1,2),DL468(1,1,2))
        IF(ISHAPE.EQ.8 .OR. ISHAPE.EQ.0) CALL ADVW3D
     I      (MXNPW,MXELW,NXW,NYW,NZW,8,EPSX,
     O       IBW(1,3),IEW(1,1,3),NLRLW(1,3),LRLW(1,1,3),DL468(1,1,3))
c
        if(nwnpt.ne.0)then
          IF(ISHAPE.EQ.4 .OR. ISHAPE.EQ.0) CALL ADVW3D
     I      (MXNPWw,MXELWw,NXg,NYg,NZg,4,EPSX,
     O       IBWw(1,1),IEWw(1,1,1),NLRLWw(1,1),LRLWw(1,1,1),
     o       DL468w(1,1,1))
          IF(ISHAPE.EQ.6 .OR. ISHAPE.EQ.0) CALL ADVW3D
     I      (MXNPWw,MXELWw,NXg,NYg,NZg,6,EPSX,
     O       IBWw(1,2),IEWw(1,1,2),NLRLWw(1,2),LRLWw(1,1,2),
     o       DL468w(1,1,2))
          IF(ISHAPE.EQ.8 .OR. ISHAPE.EQ.0) CALL ADVW3D
     I      (MXNPWw,MXELWw,NXg,NYg,NZg,8,EPSX,
     O       IBWw(1,3),IEWw(1,1,3),NLRLWw(1,3),LRLWw(1,1,3),
     o       DL468w(1,1,3))
        endif
      ENDIF
C
      DO 890 ITM=JTMJTM+1,NTI
      JTM=ITM
      print *,'jtm=',jtm
c     do k=1,ncc
c       do np=1,nnp
c         if(cp(np,k).lt.0.0d0)then
c           print *,'k,np=',k,np
c           stop
c         endif
c       enddo
c     enddo
C
      DO NP=1,NNP
        VP(NP,1)=V(NP,1)
        VP(NP,2)=V(NP,2)
        VP(NP,3)=V(NP,3)
      ENDDO
C
      DO M=1,NEL
        DO IQ=1,8
          THP(M,IQ)=TH(M,IQ)
        ENDDO
      ENDDO
C
C ------- PREPARE TRANSIENT BOUNDARY CONDITIONS AND SOURCE FOR THE STEP
C
      IF(IMOD.NE.1)THEN
        IF(NSELf.NE.0) CALL ESSFCT(SOSf,TSOSFf,SOSFf,TIME,
     1     MXSPRf,MXSDPf,NSPRf,NSDPf,KSAIf)
        IF(NWNPf.NE.0) CALL WSSFCT(WSSf,TWSSFf,WSSFf,TIME,
     1     MXWPRf,MXWDPf,NWPRf,NWDPf,KWAIf)
        IF(NCESf.NE.0) CALL CBVFCT(QCBf,TQCBFf,QCBFf,TIME,
     1     MXCPRf,MXCDPf,NCPRf,NCDPf,KCAIf)
        IF(NNESf.NE.0) CALL NBVFCT(QNBf,TQNBFf,QNBFf,TIME,
     1     MXNPRf,MXNDPf,NNPRf,NNDPf,KNAIf)
        IF(NVESf.NE.0) CALL VBVFCT(QVBf,TQVBFf,QVBFf,TIME,
     1     MXVPRf,MXVDPf,NVPRf,NVDPf,KVAIf)
        IF(NDNPf.NE.0) CALL DBVFCT(HDBf,THDBFf,HDBFf,TIME,
     1     MXDPRf,MXDDPf,NDPRf,NDDPf,KDAIf)
      ENDIF
C
      IF(IMOD.NE.10)THEN
        IF(NSELt.NE.0) CALL ESSFCT(SOSt(1,1),TSOSFt,SOSFt(1,1,1),TIME,
     1     MXSPRt,MXSDPt,NSPRt,NSDPt,KSAIt)
        IF(NSELt.NE.0) CALL ESSFCT(SOSt(1,2),TSOSFt,SOSFt(1,1,2),TIME,
     1     MXSPRt,MXSDPt,NSPRt,NSDPt,KSAIt)
        IF(NWNPt.NE.0) CALL WSSFCT(WSSt(1,1),TWSSFt,WSSFt(1,1,1),TIME,
     1     MXWPRt,MXWDPt,NWPRt,NWDPt,KWAIt)
        IF(NWNPt.NE.0) CALL WSSFCT(WSSt(1,2),TWSSFt,WSSFt(1,1,2),TIME,
     1     MXWPRt,MXWDPt,NWPRt,NWDPt,KWAIt)
c
        do i=1,nwnpt
          np=npwt(i)
          iprof=iwtypt(i,1)
          if(wsst(iprof,1).gt.0.0d0)then
            ib(np)=-1
          else
            ib(np)=-2
          endif
        enddo
c
        IF(NDNPt.NE.0) CALL DBVFCT(CDBt,TCDBFt,CDBFt,TIME,
     1     MXDPRt,MXDDPt,NDPRt,NDDPt,KDAIt)
        IF(NVESt.NE.0) CALL VBVFCT(CVBt,TCVBFt,CVBFt,TIME,
     1     MXVPRt,MXVDPt,NVPRt,NVDPt,KVAIt)
        IF(NCNPt.NE.0) CALL CBVFCT(QCBt,TQCBFt,QCBFt,TIME,
     1     MXCPRt,MXCDPt,NCPRt,NCDPt,KCAIt)
        IF(NNNPt.NE.0) CALL NBVFCT(QNBt,TQNBFt,QNBFt,TIME,
     1     MXNPRt,MXNDPt,NNPRt,NNDPt,KNAIt)
c       DO 624 NPP=1,NDNPt
c         NP=NPDBt(NPP)
c         DO 624 K=1,NCC
c           IF(MICONF.EQ.0 .OR. K.GT.3)THEN
c             ITYP=IDTYPt(NPP,K)
c             C(NP,K)=CDBt(ITYP)
c           ENDIF
c 624   CONTINUE
      ENDIF
C
      IF (KVIt.LT.0 .OR. imod.EQ.1) GO TO 750
C
C
C -------- Pass to HYDRO for transient state hydrological
C -------- calculations
C
      CALL HMCHYD(X,IE,LRN,LRL,NLRL, CMATRX,RLD,RI,RL, H,HP,HW,HT,C,
     .   ISTYPT,SOST(1,2),IWTYPT,WSST(1,2), sk,rk,pk,aa,il,nd,nt,
     1   V,  TH,DTH,AKHC, NPCNV, DCOSB,ISB,NPBB, BFLXf,
     2   SOSf,ISTYPf,LESf, WSSf,IWTYPf,NPWf,
     3   QCBf,ICTYPf,ISCf,NPCBf,QNBf,INTYPf,ISNf,NPNBf,
     4   QVBf,IVTYPf,ISVf,NPVBf, RSVAB,INDRS,
c     5   HDBf,IDTYPf,NPDBf, PROPf,SPP,DINTS,RHOMU, KPR,KDSK,KDIG,
     5   HDBf,IDTYPf,NPDBf, PROPf,SPP,DINTS, KPR,KDSK,KDIG,
     7   KOUT,JTM, NNPLR,LMAXDF,GNLR,LNOJCN,CMTRXL,RLDL,
     >   IRHO,IBUG,ICHNG,TITLE,NPROB,SQEPS)
C
      IF (imod.EQ.10) GO TO 860
C
C ------- If KVIt .GE.0 and imod.EQ.1, no card input velocity and
C ------- moisture fields.  Print warning message and use the
C ------- velocity and moisture content fields calculated using
C ------- initial pressure heads for transport simulations.
C
      IF (KVIt.GE.0 .AND. imod.EQ.1) THEN
        PRINT *, '====> Warning: no card input velocity and moisture'
        PRINT *, '      fields.  Those calculated from initial '
        PRINT *, '      pressure heads are used for transport '
        PRINT *, '      simulations.'
      ENDIF
C
        CALL DISPC
     I    (X,IE,V,VP,TH,THP,H,PROPt,Wt,KSSt,IQUAR,XWFG,CWFG,NEL,cnstkr,
c     I     ISED,1,MAXEL,7,KSP,KVIT,SPP,RHOMU,DINTS,IRHO,PROPf(1,7),
     I     ISED,1,MAXEL,7,KSP,KVIT,SPP,DINTS,IRHO,PROPf(1,7),
     O     AKHC)
C
  750 CONTINUE
C
      DO M=1,NEL
        DO IQ=1,8
          DTH(M,IQ)=(TH(M,IQ)-THP(M,IQ))/DELT
        ENDDO
      ENDDO
C
C ------- Pass to CHEMI for transient state chemical transport
C ------- calculations
C
      CALL HMCTRN(C,CP,CS,DTI,F, RI,RL, X,IE,IB,LRL,NLRL,CMX,
c     .    sk,rk,pk,aa,il,nd,nt, IRHO,AKHC,RHOMU,cnstkr,DINTS,
     .    sk,rk,pk,aa,il,nd,nt, IRHO,AKHC,cnstkr,DINTS,
     1    LRN, CMATRX,RLD, NNPLR,LMAXDF,GNLR,LNOJCN,CMTRXL,RLDL,DCOSB,
     2    ISB,NPBB,BFLXt,WETAB,V,VP,VEAVG,H,TH,THP,WWRK,THN,AKDC,
     3    LESt,SOSt,ISTYPt, NPWt,WSSt,IWTYPt, ILSV,IMSV,
     >    QCBt,ICTYPt,ISCt,NPCBt, QNBt,INTYPt,ISNt,NPNBt,
     >    CVBt,IVTYPt,ISVt,NPVBt, CDBt,IDTYPt,NPDBt, PROPf(1,7),PROPt,
     >    SPP,RKD,TRANC, NBDYB,IBDY,XW,VXW,CW,MWLOC,LRLW,NLRLW,IEW,IBW,
     >    DL468, ieww,ibww,lrlww,nlrlww,xww,vxww,dl468w,IBE,IBCHK,XPFG,
     >    CPFG,MPLOC,XSFG,CSFG,MPLOCS,XWFG,CWFG,MPLOCW,XEFG,CEFG,
     >    MPLOCE,NFGM,NFGMB,NFGMBB,MAXFGW,MINFGW,CMAXFG,CMINFG,ISE,
     >    NEPWN,NEPW,ISED,NDBD,MPLOCD,NLRND,NCFG,DTIFG,NPFG,NEFG,
     7    KPR,KDSK,KDIG,KOUT,JTM,IRXN, IBUG,TITLE,NPROB,EPSX,SQEPS)
C
C ------- PREPARE FOR NEXT TIME STEP
C
  860 CONTINUE
      IF(TIME.GE.TMAX) GO TO 990
      DELT=DELT*(1.0D0+CHNG)
      DELT=DMIN1(DELT,DELMAX)
      IF(IDELT.EQ.0) GO TO 880
      IF(TIME.EQ.TDTCH(IDELT,1)) DELT=TDTCH(IDELT,2)
  880 TIME=TIME+DELT
      IF(TIME.GE.TDTCH(IDELT+1,1)) THEN
        IDELT=IDELT+1
        TIME=TIME-DELT
        DELT=TDTCH(IDELT,1)-TIME
        IF(DELT.LE.0.0) DELT=TDTCH(IDELT,2)
        TIME=TIME+DELT
      ENDIF
C
C ====== UPDATE XPFG,IE(M,10),IE(M,11)
C
c       NPFG=NPFGS
        IF(IMOD.EQ.10)GOTO 890
        DO M=1,NEL
          IF(IE(M,11).EQ.-1)THEN
C ------    this number was set in DFPREP for connecting to
C ------    a SF element
            IE(M,10)=0
          ELSE
            IE(M,10)=IE(M,11)
          ENDIF
          IE(M,11)=0
        ENDDO
C       NEFG=NEFGS
        DO I=1,NPFG
          DO J=1,3
            XPFG(I,J)=XSFG(I,J)
          ENDDO
          DO K=1,NCC
            CPFG(I,K)=CSFG(I,K)
          ENDDO
          MPLOC(I)=MPLOCS(I)
        ENDDO
C
  890 CONTINUE
C
  990 RETURN
C
    9 FORMAT(A1)
 1400 FORMAT('0',' *** ERROR IN READING VELOCITY: STOP ')
 1500 FORMAT('1'/5X,' **** CARD INPUTTED VELOCITY ****'///1X,
     1 2('    N     VX         VY         VZ    ')/1X,
     2 2('  --- ---------- ---------- ----------')/)
 1550 FORMAT(' ',2(I5,3D11.4))
 1800 FORMAT('0',' *** ERROR IN READING MOISTURE: STOP')
 1900 FORMAT('1'/5X,' **** CARD INPUTTED MOISTURE CONTENT ***'///1X,
     1 '    M    1       2       3       4      5       6       7   ',
     3 '    8   '/1X,'  ---',8(' -------'))
 1950 FORMAT(' ',I5,8F8.5)
 3400 FORMAT('1','TABLE OF WEIGHTING FACTORS OF EVERY ELEMENTS'//)
 3450 FORMAT(' ',I5,12F6.2)
 6300 FORMAT(5X,'ITERATION',9X,'RES',12X,'RD',20X,'NNCVN'/
     >       5X,I10,3X,E12.4,3X,E12.4,15X,I10)
 7500 FORMAT('0'/5X,'** WARNING: NO CONVERGENCE AT',I4,'-TH TIME STEP AF
     1TER',I4,' ITERATIONS'/8X,'NITER =',I4,' DIFMAX =',D12.4,' TOLB =',
     2 D12.4)
 8010 FORMAT(1X,3I6,1PD12.4,1PD12.4)
C
      END
