/*
 * Decompiled with CFR 0.152.
 */
public class BoundaryCondition {
    private double hAt0;
    private double hInitialAt0;
    private double hAtL;
    private double qAt0;
    private double qAtL;
    private double cAt0;
    private double cAtL;
    private double h0;
    private int bcWaterAt0;
    private int bcWaterAtL;
    private int bcChemAt0 = -1;
    private int bcChemAtL = -1;
    private double timeStart;
    private double timeEnd;
    public static final int POTENTIAL = 0;
    public static final int FLUX = 1;
    public static final int MIXED = 2;
    public static final int FREE_DRAINAGE = 3;
    public static final int SOLUTION_CONCENTRATION = 4;
    public static final int CONCENTRATION = 5;
    public static final int MASS_FLOW = 6;
    public static final int SEMI_INFINITE = -1;
    public static final int FALLING_HEAD = 7;

    public BoundaryCondition(double d, double d2) {
        this.timeStart = d;
        this.timeEnd = d2;
        this.bcWaterAtL = -1;
    }

    public BoundaryCondition(double d) {
        this(0.0, d);
    }

    public BoundaryCondition() {
        this.bcWaterAtL = -1;
    }

    public void setSemiInfinite() {
        this.bcWaterAtL = -1;
    }

    public void setTimeStart(double d) {
        this.timeStart = d;
    }

    public void setTimeEnd(double d) {
        this.timeEnd = d;
    }

    public void setPotentialAt0(double d) {
        this.hAt0 = d;
        this.bcWaterAt0 = 0;
    }

    public void setFallingHeadPotentialAt0(double d) {
        this.h0 = d;
    }

    public void setPotentialAtL(double d) {
        this.hAtL = d;
        this.bcWaterAtL = 0;
    }

    public void setFluxAt0(double d) {
        this.qAt0 = d;
        this.bcWaterAt0 = 1;
    }

    public void setFluxAtL(double d) {
        this.qAtL = d;
        this.bcWaterAtL = 1;
    }

    public void setMixedAt0(double d, double d2, double d3) {
        this.qAt0 = d;
        this.hAt0 = d2;
        this.hInitialAt0 = d3;
        this.bcWaterAt0 = 2;
    }

    public void setFallingHeadAt0(double d) {
        this.qAt0 = 0.0;
        this.hAt0 = d;
        this.h0 = d;
        this.bcWaterAt0 = 7;
    }

    public void resetFallingHeadAt0() {
        this.h0 = this.hAt0;
    }

    public void setRainfall(double d, double d2) {
        this.setMixedAt0(d, 0.0, d2);
    }

    public void setFreeDrainageAtL() {
        this.bcWaterAtL = 3;
    }

    public boolean setConcAt0(double d, int n) {
        if (n == 4 || n == 5) {
            this.bcChemAt0 = n;
            this.cAt0 = d;
            return true;
        }
        return false;
    }

    public void setConcAtL(double d) {
        this.bcChemAtL = 5;
        this.cAtL = d;
    }

    public void setMassFlowAtL() {
        this.bcChemAtL = 6;
    }

    public double getPotentialAt0() {
        if (this.bcWaterAt0 == 7) {
            return this.h0;
        }
        return this.hAt0;
    }

    public double getPotentialAtL() {
        return this.hAtL;
    }

    public double getFluxAt0() {
        return this.qAt0;
    }

    public double getInitialPondingDepth() {
        return this.hAt0;
    }

    public double getFluxAtL() {
        return this.qAtL;
    }

    public double getConcAt0() {
        return this.cAt0;
    }

    public double getConcAtL() {
        if (this.bcChemAtL == 5) {
            return this.cAtL;
        }
        return -1.0;
    }

    public int getWaterBCTypeAt0() {
        return this.bcWaterAt0;
    }

    public int getWaterBCTypeAtL() {
        return this.bcWaterAtL;
    }

    public int getChemBCTypeAt0() {
        return this.bcChemAt0;
    }

    public int getChemBCTypeAtL() {
        return this.bcChemAtL;
    }

    public boolean getIsFinite() {
        return this.bcWaterAtL != -1;
    }

    public double getTimeStart() {
        return this.timeStart;
    }

    public double getTimeEnd() {
        return this.timeEnd;
    }

    public boolean changeToPotAt0(double d) {
        return (this.hInitialAt0 - this.hAt0) * (d - this.hAt0) <= 0.0;
    }

    public boolean changeToFluxAt0(double d) {
        return d <= 0.001;
    }

    public void displayBC() {
        System.out.println("Boundary Condition");
        switch (this.bcWaterAt0) {
            case 0: {
                System.out.println("Potential BC for water at x=0 with h = " + this.hAt0);
                break;
            }
            case 1: {
                System.out.println("Flux BC for water at x=0 with q = " + this.qAt0);
                break;
            }
            case 2: {
                System.out.println("Mixed BC for water at x=0 with initial h = " + this.hInitialAt0);
                System.out.println("             and flux = " + this.qAt0);
                break;
            }
            case 7: {
                System.out.println("Falling head for water at x=0 with initial head =" + this.hAt0);
                System.out.println("              and h0 = " + this.h0);
                break;
            }
            default: {
                System.out.print("ERROR: bcWaterAt0 = " + this.bcWaterAt0);
            }
        }
        switch (this.bcChemAt0) {
            case 4: {
                System.out.println("Inflowing Solution Concentration at x=0 is " + this.cAt0);
                break;
            }
            case 5: {
                System.out.println("Soil Solution Concentration at x=0 is " + this.cAt0);
                break;
            }
            default: {
                System.out.println("ERROR: bcChemAt0 = " + this.bcChemAt0);
            }
        }
        switch (this.bcWaterAtL) {
            case 0: {
                System.out.println("Potential BC for water at x=L with h = " + this.hAtL);
                break;
            }
            case 1: {
                System.out.println("Flux BC for water at x=L with q = " + this.qAtL);
                break;
            }
            case 3: {
                System.out.println("Free Drainage for water at x=L");
                break;
            }
            case -1: {
                System.out.println("Semi-infinite soil");
            }
            default: {
                System.out.println("ERROR: bcWaterAtL = " + this.bcWaterAtL);
            }
        }
        switch (this.bcChemAtL) {
            case 5: {
                System.out.println("Soil Solution Concentration at x=L is " + this.cAtL);
                break;
            }
            case 6: {
                System.out.println("Mass flow only at x=L");
                break;
            }
            default: {
                System.out.println("ERROR: bcChemAtL = " + this.bcChemAtL);
            }
        }
        System.out.println("for time = " + this.timeStart + "   to time = " + this.timeEnd);
    }
}

