/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Image;

public class BrooksWaterContent
extends WaterContent {
    double satWC;
    double residualWC;
    double n;
    double bubblingPressure;
    private static final Parameter hBubble = new Parameter("Bubbling Pressure, hb (cm)", -22.6, -60.0, -1.0, 1);
    private static final Parameter nConstant = new Parameter("Empirical Constant, n", 0.53, 0.05, 1.7, 2);
    private Image equationImage;

    public BrooksWaterContent(double d, double d2, double d3, double d4, Image image) {
        this.satWC = d;
        this.residualWC = d2;
        this.n = d4;
        this.bubblingPressure = d3;
        this.equationImage = image;
    }

    public double getWC(double d) {
        double d2 = d < this.bubblingPressure ? this.residualWC + (this.satWC - this.residualWC) / Math.pow(d / this.bubblingPressure, this.n) : this.satWC;
        return d2;
    }

    public double getSatWC() {
        return this.satWC;
    }

    public double getResidualWC() {
        return this.residualWC;
    }

    public double getWaterCapacity(double d) {
        if (d < this.bubblingPressure) {
            return -this.n * (this.satWC - this.residualWC) / (this.bubblingPressure * Math.pow(d / this.bubblingPressure, this.n + 1.0));
        }
        return 0.0;
    }

    public double getMatricPotential(double d) {
        double d2;
        if (d > this.satWC) {
            d = this.satWC;
            d2 = 0.0;
        } else {
            double d3;
            if (d <= this.residualWC + 0.001) {
                d = this.residualWC + 0.001;
            }
            if ((d2 = this.bubblingPressure * Math.pow(d3 = (this.satWC - this.residualWC) / (d - this.residualWC), 1.0 / this.n)) < -20000.0) {
                d2 = -20000.0;
                d = this.getWC(d2);
            }
        }
        return d2;
    }

    public String getName(int n) {
        String string;
        switch (n) {
            case 1: {
                string = hBubble.getName();
                break;
            }
            case 2: {
                string = nConstant.getName();
                break;
            }
            case 3: {
                string = WaterContent.thetaSat.getName();
                break;
            }
            case 4: {
                string = WaterContent.thetaRes.getName();
                break;
            }
            default: {
                string = "IllegalIndex";
            }
        }
        return string;
    }

    public double getParamValue(int n) {
        double d;
        switch (n) {
            case 1: {
                d = this.bubblingPressure;
                break;
            }
            case 2: {
                d = this.n;
                break;
            }
            case 3: {
                d = this.satWC;
                break;
            }
            case 4: {
                d = this.residualWC;
                break;
            }
            default: {
                d = -999.0;
            }
        }
        return d;
    }

    public double getDefault(int n) {
        double d;
        switch (n) {
            case 1: {
                d = hBubble.getDefaultValue();
                break;
            }
            case 2: {
                d = nConstant.getDefaultValue();
                break;
            }
            case 3: {
                d = WaterContent.thetaSat.getDefaultValue();
                break;
            }
            case 4: {
                d = WaterContent.thetaRes.getDefaultValue();
                break;
            }
            default: {
                d = -999.0;
            }
        }
        return d;
    }

    public double getLowerLimit(int n) {
        double d;
        switch (n) {
            case 1: {
                d = hBubble.getLowerLimit();
                break;
            }
            case 2: {
                d = nConstant.getLowerLimit();
                break;
            }
            case 3: {
                d = WaterContent.thetaSat.getLowerLimit();
                break;
            }
            case 4: {
                d = WaterContent.thetaRes.getLowerLimit();
                break;
            }
            default: {
                d = -999999.0;
            }
        }
        return d;
    }

    public double getUpperLimit(int n) {
        double d;
        switch (n) {
            case 1: {
                d = hBubble.getUpperLimit();
                break;
            }
            case 2: {
                d = nConstant.getUpperLimit();
                break;
            }
            case 3: {
                d = WaterContent.thetaSat.getUpperLimit();
                break;
            }
            case 4: {
                d = WaterContent.thetaRes.getUpperLimit();
                break;
            }
            default: {
                d = 999999.0;
            }
        }
        return d;
    }

    public int getDecimalDigits(int n) {
        int n2;
        switch (n) {
            case 1: {
                n2 = hBubble.getDecimalDigits();
                break;
            }
            case 2: {
                n2 = nConstant.getDecimalDigits();
                break;
            }
            case 3: {
                n2 = WaterContent.thetaSat.getDecimalDigits();
                break;
            }
            case 4: {
                n2 = WaterContent.thetaRes.getDecimalDigits();
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return n2;
    }

    public String getErrorMessage(int n) {
        String string;
        switch (n) {
            case 1: {
                string = new String("Bubbling Pressure");
                break;
            }
            case 2: {
                string = new String("Empirical constant, n");
                break;
            }
            case 3: {
                string = new String("Saturated Water Content");
                break;
            }
            case 4: {
                string = new String("Residual Water Content");
                break;
            }
            default: {
                string = new String("Program Error: This should never be shown.");
            }
        }
        string = new String(string + " is usually between " + Tools.formatDouble(this.getLowerLimit(n), this.getDecimalDigits(n), 0) + " and " + Tools.formatDouble(this.getUpperLimit(n), this.getDecimalDigits(n), 0));
        return string;
    }

    public Image getEquationImage() {
        return this.equationImage;
    }

    public void setParamValue(int n, double d) {
        switch (n) {
            case 1: {
                this.bubblingPressure = d;
                break;
            }
            case 2: {
                this.n = d;
                break;
            }
            case 3: {
                this.satWC = d;
                break;
            }
            case 4: {
                this.residualWC = d;
            }
        }
    }
}

