/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ListIterator;
import java.util.Vector;
import javax.jnlp.BasicService;
import javax.jnlp.FileContents;
import javax.jnlp.FileOpenService;
import javax.jnlp.FileSaveService;
import javax.jnlp.PrintService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.plaf.ColorUIResource;

public class CHEMFLO
extends JApplet {
    private BevelBorder raisedEdge = new BevelBorder(0);
    private CardLayout card;
    private BorderLayout border = new BorderLayout();
    private ListIterator iter;
    private JButton GraphsBnt;
    private JButton SoilSysBnt;
    private JButton InitialCondBnt;
    private JButton BoundaryCondBnt;
    private JButton MeshSizeBnt;
    private JButton ReportTableBnt;
    private JButton PreferencesBnt;
    private JButton TransBnt;
    private Container mainP;
    private JLabel title;
    static JPanel buttonP;
    private JPanel windowP;
    static MainScreenPanel mainScreen;
    static SoilInterestPanel soilPane;
    static InitialConditionPanel initialPane;
    static DefineBoundaryPanel boundaryPane;
    static TransportPropertyPanel transProperty;
    static MeshSizePanel meshsizePane;
    static ReportTablePanel reportPane;
    static PreferencePanel preferencePane;
    private ChemfloPanel coverPanel;
    private eventListener target;
    static JFrame appWin;
    private int flag = 0;
    private Color oldBk;
    private Color newBk;
    private CHEMFLO appl;
    static ChemfloPanel currentCP;
    static int old_width;
    static int old_height;
    static boolean wMax;
    private FileQuitAction fQuit;
    private ScreenPrintAction sPrint;
    private PageFormat mPageFormat;
    JPanel soilP = new JPanel();
    private boolean initialCondChanged = false;
    private boolean transPropChanged = false;
    static SoilFileIO soilIO;
    static JMenuItem transpDataPreview;
    static JMenuItem transpDataPrint;
    static boolean localSoilData;
    private MouseEventHandler meh = new MouseEventHandler();
    static Dimension screenDimension;
    private LoadSoilAction lSoil;
    static PrintService printService;
    static PrinterJob printerJob;
    static FileSaveService FSS;
    static String fileNameSaved;
    FileOpenService fos;
    File latestSoilDataFile;
    private BrowserControl Bctrl;
    private static JProgressBar progressBar;
    private static int value;
    private final String menualAddress = "http://soilphysics.okstate.edu/software/chemflo/ChemfloManual.html";
    private final String tipAddress = "http://soilphysics.okstate.edu/software/chemflo/tips.html";
    private final String aboutStr = "CHEMFLO\u2122 2000   Version 2003.04.23\n   Copyright \u00a9 1989, 2001, 2002, 2003\n   Oklahoma Agricultural Experiment Station\n   Oklahoma State University\n   Stillwater, Oklahoma\n\nAuthors:\n   Dr. D.L. Nofziger and Dr. Jinquan Wu \n\nProgrammer:\n   D.L. Nofziger, Jianbin Yu, Jinquan Wu \n\nContact:\n   D. L. Nofziger, Professor\n   Department of Plant and Soil Sciences\n   Oklahoma State University\n   Stillwater, OK 74078\n   E-mail: dln@okstate.edu\n   ";
    static /* synthetic */ Class class$CHEMFLO;

    public static void main(String[] stringArray) {
        RichardsEqn.osName = System.getProperty("os.name");
        JWindow jWindow = new JWindow();
        value = 0;
        progressBar = new JProgressBar(0, value, 18);
        progressBar.setPreferredSize(new Dimension(360, 30));
        progressBar.setString("Loading CHEMFLO...");
        progressBar.setStringPainted(true);
        ImageIcon imageIcon = new ImageIcon((class$CHEMFLO == null ? (class$CHEMFLO = CHEMFLO.class$("CHEMFLO")) : class$CHEMFLO).getResource("images/oaesw.png"));
        JLabel jLabel = new JLabel(imageIcon);
        jLabel.setOpaque(true);
        jWindow.getContentPane().setLayout(new BorderLayout());
        jWindow.getContentPane().add((Component)jLabel, "Center");
        jWindow.getContentPane().add((Component)progressBar, "South");
        jWindow.pack();
        screenDimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = jWindow.getSize().width;
        int n2 = jWindow.getSize().height;
        int n3 = (CHEMFLO.screenDimension.width - n) / 2;
        int n4 = (CHEMFLO.screenDimension.height - n2) / 2;
        jWindow.setBounds(n3, n4, n, n2);
        try {
            Thread.sleep(500L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        jWindow.setVisible(true);
        progressBar.setValue(++value);
        CHEMFLO cHEMFLO = new CHEMFLO();
        appWin.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (CHEMFLO.soilIO.fout != null) {
                    try {
                        CHEMFLO.soilIO.fout.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                System.exit(0);
            }
        });
        cHEMFLO.mainP = appWin.getContentPane();
        cHEMFLO.flag = 1;
        cHEMFLO.init();
        cHEMFLO.start();
        jWindow.setVisible(false);
        jWindow.dispose();
        appWin.setVisible(true);
    }

    public CHEMFLO() {
        soilIO = new SoilFileIO();
        soilIO.makeSoilList("Soils.dat");
        progressBar.setValue(++value);
        new RichardsEqn();
        appWin = new JFrame("Transient Water and Chemical Movement in Soils");
        appWin.setBounds(0, 0, 800, 600);
        old_width = CHEMFLO.appWin.getSize().width;
        old_height = CHEMFLO.appWin.getSize().height;
        progressBar.setValue(++value);
        if (CHEMFLO.screenDimension.width > 800 || CHEMFLO.screenDimension.height > 600) {
            appWin.addComponentListener(new frameChangeListener());
        }
        UIManager.put("ToolTip.foreground", new ColorUIResource(Color.black.darker()));
        UIManager.put("ToolTip.background", new ColorUIResource(Color.white));
        ToolTipManager.sharedInstance().setDismissDelay(100000);
    }

    public void init() {
        this.target = new eventListener();
        this.GraphsBnt = new JButton(" Graphs ");
        this.GraphsBnt.setBorder(this.raisedEdge);
        this.SoilSysBnt = new JButton(" Soil System ");
        this.SoilSysBnt.setBorder(this.raisedEdge);
        this.InitialCondBnt = new JButton(" Initial Conditions ");
        this.InitialCondBnt.setBorder(this.raisedEdge);
        this.BoundaryCondBnt = new JButton(" Boundary Conditions ");
        this.BoundaryCondBnt.setBorder(this.raisedEdge);
        this.MeshSizeBnt = new JButton(" Mesh Size/Convergence ");
        this.MeshSizeBnt.setBorder(this.raisedEdge);
        this.ReportTableBnt = new JButton(" Reports/Tables ");
        this.ReportTableBnt.setBorder(this.raisedEdge);
        this.PreferencesBnt = new JButton(" Preferences ");
        this.PreferencesBnt.setBorder(this.raisedEdge);
        this.PreferencesBnt.setVisible(false);
        this.TransBnt = new JButton("Transport Properties");
        this.TransBnt.setBorder(this.raisedEdge);
        this.GraphsBnt.addActionListener(this.target);
        this.SoilSysBnt.addActionListener(this.target);
        this.InitialCondBnt.addActionListener(this.target);
        this.BoundaryCondBnt.addActionListener(this.target);
        this.MeshSizeBnt.addActionListener(this.target);
        this.ReportTableBnt.addActionListener(this.target);
        this.PreferencesBnt.addActionListener(this.target);
        this.TransBnt.addActionListener(this.target);
        progressBar.setValue(++value);
        buttonP = new JPanel();
        buttonP.setPreferredSize(new Dimension(180, 575));
        buttonP.setLayout(new BorderLayout());
        SoilGraphPanel2 soilGraphPanel2 = new SoilGraphPanel2();
        this.soilP.setLayout(new BoxLayout(this.soilP, 1));
        JLabel jLabel = new JLabel("     Orientation of Soil");
        jLabel.setFont(RichardsEqn.labelFont);
        jLabel.setForeground(Color.black);
        this.soilP.add(jLabel);
        this.soilP.add(soilGraphPanel2);
        buttonP.add((Component)this.soilP, "North");
        progressBar.setValue(++value);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(7, 1, 0, 0));
        jPanel.add(this.GraphsBnt);
        jPanel.add(this.ReportTableBnt);
        jPanel.add(this.SoilSysBnt);
        jPanel.add(this.InitialCondBnt);
        jPanel.add(this.BoundaryCondBnt);
        jPanel.add(this.TransBnt);
        jPanel.add(this.MeshSizeBnt);
        bntMouseListener bntMouseListener2 = new bntMouseListener();
        this.GraphsBnt.addMouseListener(bntMouseListener2);
        this.SoilSysBnt.addMouseListener(bntMouseListener2);
        this.InitialCondBnt.addMouseListener(bntMouseListener2);
        this.BoundaryCondBnt.addMouseListener(bntMouseListener2);
        this.MeshSizeBnt.addMouseListener(bntMouseListener2);
        this.ReportTableBnt.addMouseListener(bntMouseListener2);
        this.PreferencesBnt.addMouseListener(bntMouseListener2);
        this.TransBnt.addMouseListener(bntMouseListener2);
        buttonP.add((Component)jPanel, "Center");
        progressBar.setValue(++value);
        JPanel jPanel2 = new JPanel();
        jPanel2.setPreferredSize(new Dimension(180, 100));
        jPanel2.setLayout(new BorderLayout());
        JPanel jPanel3 = new JPanel();
        jPanel3.setPreferredSize(new Dimension(2, 110));
        JPanel jPanel4 = new JPanel();
        jPanel4.setPreferredSize(new Dimension(180, 10));
        ClassLoader classLoader = this.getClass().getClassLoader();
        ImageIcon imageIcon = new ImageIcon(classLoader.getResource("images/oaesw.gif"));
        JLabel jLabel2 = new JLabel(imageIcon);
        jLabel2.setForeground(Color.red);
        jPanel2.add((Component)jPanel3, "West");
        jPanel2.add((Component)jLabel2, "Center");
        jPanel2.add((Component)jPanel4, "South");
        buttonP.add((Component)jPanel2, "South");
        progressBar.setValue(++value);
        this.windowP = new JPanel();
        this.card = new CardLayout(15, 10);
        this.windowP.setLayout(this.card);
        progressBar.setValue(++value);
        this.makeMultiplePanels();
        if (this.flag == 0) {
            new RichardsEqn();
            this.appl = new CHEMFLO();
            this.mainP = this.getContentPane();
        }
        progressBar.setValue(++value);
        JPanel jPanel5 = new JPanel();
        jPanel5.setPreferredSize(new Dimension(800, 575));
        jPanel5.setLayout(new BorderLayout());
        jPanel5.add((Component)this.createMenuBar(), "North");
        progressBar.setValue(++value);
        this.title = new JLabel("CHEMFLO-2000");
        this.title.setFont(new Font("Serif", 3, 24));
        this.title.setHorizontalAlignment(0);
        this.title.setForeground(Color.black);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout());
        jPanel6.add((Component)this.title, "North");
        jPanel6.add((Component)this.windowP, "Center");
        jPanel5.add((Component)buttonP, "West");
        jPanel5.add((Component)jPanel6, "Center");
        this.card.show(this.windowP, "Cover");
        currentCP = this.coverPanel;
        progressBar.setValue(++value);
        if (CHEMFLO.screenDimension.width < 800 || CHEMFLO.screenDimension.height < 600) {
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.getViewport().add(jPanel5);
            this.mainP.add((Component)jScrollPane, "Center");
        } else {
            this.mainP.add((Component)jPanel5, "Center");
        }
        this.oldBk = this.mainP.getBackground();
        this.newBk = new Color(204, 204, 255);
        if (this.flag == 0) {
            this.appl.start();
        }
    }

    public void makeMultiplePanels() {
        this.coverPanel = new CoverPanel();
        this.windowP.add((Component)this.coverPanel, "Cover");
        progressBar.setValue(++value);
        mainScreen = new MainScreenPanel();
        this.windowP.add((Component)mainScreen, "Main Screen");
        progressBar.setValue(++value);
        initialPane = new InitialConditionPanel();
        this.windowP.add((Component)initialPane, "Define initial condition of soil system");
        progressBar.setValue(++value);
        boundaryPane = new DefineBoundaryPanel();
        this.windowP.add((Component)boundaryPane, "Define boundary conditions");
        progressBar.setValue(++value);
        transProperty = new TransportPropertyPanel();
        this.windowP.add((Component)transProperty, "Trans Properties");
        progressBar.setValue(++value);
        soilPane = new SoilInterestPanel();
        this.windowP.add((Component)soilPane, "Select soil of interest");
        progressBar.setValue(++value);
        meshsizePane = new MeshSizePanel();
        this.windowP.add((Component)meshsizePane, "Define mesh size");
        progressBar.setValue(++value);
        reportPane = new ReportTablePanel();
        this.windowP.add((Component)reportPane, "Reports Tables");
        progressBar.setValue(++value);
        preferencePane = new PreferencePanel();
        this.windowP.add((Component)preferencePane, "Preferences");
        progressBar.setValue(++value);
        CHEMFLO.mainScreen.graphData[0].collectData();
    }

    private JMenuBar createMenuBar() {
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File", true);
        jMenu.setMnemonic('f');
        this.fQuit = new FileQuitAction();
        this.fQuit.setMnemonic('x');
        this.fQuit.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.lSoil = new LoadSoilAction();
        this.lSoil.setMnemonic('L');
        jMenu.add(this.lSoil);
        jMenu.addSeparator();
        jMenu.add(this.fQuit);
        jMenuBar.add(jMenu);
        JMenu jMenu2 = new JMenu("Print");
        jMenu2.setMnemonic('p');
        JMenu jMenu3 = new JMenu("Screen Page Setup");
        JMenuItem jMenuItem = new JMenuItem("Portrait");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Thread thread = new Thread(this){
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        CHEMFLO.setPrinter();
                        if (printService == null && printerJob == null) {
                            JOptionPane.showMessageDialog(appWin, "Failed to obtain printer service.", "Error", 2);
                            return;
                        }
                        CHEMFLO.access$1500(2.access$1400(this.this$1), 1);
                    }
                };
                thread.start();
            }

            static /* synthetic */ CHEMFLO access$1400(2 var0) {
                return var0.CHEMFLO.this;
            }
        });
        jMenu3.add(jMenuItem);
        jMenuItem = new JMenuItem("Landscape");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Thread thread = new Thread(this){
                    private final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        CHEMFLO.setPrinter();
                        if (printService == null && printerJob == null) {
                            JOptionPane.showMessageDialog(appWin, "Failed to obtain printer service.", "Error", 2);
                            return;
                        }
                        CHEMFLO.access$1500(4.access$1600(this.this$1), 0);
                    }
                };
                thread.start();
            }

            static /* synthetic */ CHEMFLO access$1600(4 var0) {
                return var0.CHEMFLO.this;
            }
        });
        jMenu3.add(jMenuItem);
        this.sPrint = new ScreenPrintAction();
        this.sPrint.setMnemonic('s');
        this.sPrint.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        jMenu2.add(jMenu3);
        jMenu2.add(this.sPrint);
        jMenu2.addSeparator();
        JMenu jMenu4 = new JMenu("Graph Line Data");
        jMenu4.addMouseMotionListener(this.meh);
        jMenu4.addMouseListener(this.meh);
        jMenu4.addFocusListener(this.meh);
        JMenuItem jMenuItem2 = new JMenuItem("Print Preview");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Thread thread = new Thread(this){
                    private final /* synthetic */ 6 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        new ShowGraphLineDataOnScreen(new GraphLineDataTablePanel(), "Graph Line Data Print Preview", 1);
                    }
                };
                thread.start();
                currentCP.repaint();
            }
        });
        jMenu4.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("Print");
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Thread thread = new Thread(this){
                    private final /* synthetic */ 8 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        GraphLineDataTablePanel graphLineDataTablePanel = new GraphLineDataTablePanel();
                        graphLineDataTablePanel.printData();
                    }
                };
                thread.start();
                currentCP.repaint();
            }
        });
        jMenu4.add(jMenuItem3);
        jMenu2.add(jMenu4);
        jMenuBar.add(jMenu2);
        JMenu jMenu5 = new JMenu("Reset");
        jMenu5.setMnemonic('r');
        JMenuItem jMenuItem4 = new JMenuItem("Reset all graphs to automatic");
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = CustomizeDialog.gpLimits.length;
                int n2 = 0;
                while (n2 < n) {
                    CustomizeDialog.gpLimits[n2].setAuto(true);
                    ++n2;
                }
                appWin.repaint();
            }
        });
        jMenu5.add(jMenuItem4);
        jMenuBar.add(jMenu5);
        JMenu jMenu6 = new JMenu("Help");
        jMenu6.setMnemonic('h');
        JMenuItem jMenuItem5 = new JMenuItem("Documentation");
        jMenuItem5.setMnemonic('d');
        jMenuItem5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Thread thread = new Thread(this){
                    private final /* synthetic */ 11 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        CHEMFLO.access$1800(11.access$1700(this.this$1), "Manual");
                    }
                };
                thread.start();
            }

            static /* synthetic */ CHEMFLO access$1700(11 var0) {
                return var0.CHEMFLO.this;
            }
        });
        jMenuItem5.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        jMenu6.add(jMenuItem5);
        JMenuItem jMenuItem6 = new JMenuItem("Tips");
        jMenuItem6.setMnemonic('t');
        jMenuItem6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Thread thread = new Thread(this){
                    private final /* synthetic */ 13 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        CHEMFLO.access$1800(13.access$1900(this.this$1), "Tips");
                    }
                };
                thread.start();
            }

            static /* synthetic */ CHEMFLO access$1900(13 var0) {
                return var0.CHEMFLO.this;
            }
        });
        jMenu6.add(jMenuItem6);
        jMenu6.addSeparator();
        JMenuItem jMenuItem7 = new JMenuItem("About CHEMFLO");
        jMenuItem7.setMnemonic('a');
        jMenuItem7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JOptionPane.showMessageDialog(appWin, "CHEMFLO\u2122 2000   Version 2003.04.23\n   Copyright \u00a9 1989, 2001, 2002, 2003\n   Oklahoma Agricultural Experiment Station\n   Oklahoma State University\n   Stillwater, Oklahoma\n\nAuthors:\n   Dr. D.L. Nofziger and Dr. Jinquan Wu \n\nProgrammer:\n   D.L. Nofziger, Jianbin Yu, Jinquan Wu \n\nContact:\n   D. L. Nofziger, Professor\n   Department of Plant and Soil Sciences\n   Oklahoma State University\n   Stillwater, OK 74078\n   E-mail: dln@okstate.edu\n   ");
                appWin.repaint();
            }
        });
        jMenuItem7.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        jMenu6.add(jMenuItem7);
        JMenuItem jMenuItem8 = new JMenuItem("Acknowledgements");
        jMenuItem8.setMnemonic('k');
        jMenuItem8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Thread thread = new Thread(this){
                    private final /* synthetic */ 16 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        new AcknowledgementsDialog();
                    }
                };
                thread.start();
            }
        });
        jMenuItem8.setAccelerator(KeyStroke.getKeyStroke(75, 2));
        jMenu6.add(jMenuItem8);
        jMenuBar.add(jMenu6);
        return jMenuBar;
    }

    void checkErrorFree() {
        RichardsEqn.errorFree = CHEMFLO.mainScreen.errorFree && CHEMFLO.soilPane.errorFree && CHEMFLO.initialPane.errorFree && CHEMFLO.boundaryPane.errorFree && CHEMFLO.transProperty.errorFree && CHEMFLO.meshsizePane.mshsP.errorFree;
    }

    private boolean errorInitialConditions() {
        return !initialPane.tableErrorFree();
    }

    private boolean errorTransProperity() {
        return !transProperty.tableErrorFree();
    }

    public void updatePanelSize() {
        mainScreen.updateSize();
        soilPane.updateSize();
        initialPane.updateSize();
        boundaryPane.updateSize();
        transProperty.updateSize();
        meshsizePane.updateSize();
        reportPane.updateSize();
        preferencePane.updateSize();
        this.coverPanel.updateSize();
    }

    private String setInputStream() {
        String string = null;
        JFileChooser jFileChooser = null;
        if (this.fos == null) {
            try {
                this.fos = (FileOpenService)ServiceManager.lookup("javax.jnlp.FileOpenService");
            }
            catch (UnavailableServiceException unavailableServiceException) {
                this.fos = null;
            }
        }
        if (this.fos != null) {
            try {
                InputStream inputStream;
                FileContents fileContents = this.fos.openFileDialog(null, null);
                if (fileContents != null) {
                    string = fileContents.getName();
                    inputStream = null;
                    try {
                        inputStream = fileContents.getInputStream();
                    }
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(appWin, "File, " + string + ", Not Found.", "Error", 2);
                        return null;
                    }
                } else {
                    return null;
                }
                CHEMFLO.soilIO.reader = new InputStreamReader(inputStream, "latin1");
                CHEMFLO.soilIO.fin = new BufferedReader(CHEMFLO.soilIO.reader);
            }
            catch (Exception exception) {
                return null;
            }
        }
        jFileChooser = this.latestSoilDataFile != null ? new JFileChooser(this.latestSoilDataFile) : new JFileChooser();
        int n = jFileChooser.showOpenDialog(appWin);
        if (n == 0) {
            File file;
            this.latestSoilDataFile = file = jFileChooser.getSelectedFile();
            string = file.getName();
            try {
                CHEMFLO.soilIO.reader = new FileReader(file);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(appWin, "File, " + string + ", Not Found.", "Error", 2);
                return null;
            }
            CHEMFLO.soilIO.fin = new BufferedReader(CHEMFLO.soilIO.reader);
        } else {
            return null;
        }
        return string;
    }

    static BufferedWriter getBufferedWriter() {
        JFileChooser jFileChooser = null;
        BufferedWriter bufferedWriter = null;
        if (FSS == null) {
            try {
                FSS = (FileSaveService)ServiceManager.lookup("javax.jnlp.FileSaveService");
            }
            catch (UnavailableServiceException unavailableServiceException) {
                FSS = null;
            }
        }
        if (FSS != null) {
            try {
                FileContents fileContents = FSS.saveFileDialog(null, null, new ByteArrayInputStream(new byte[256]), "Soils.dat");
                if (fileContents == null) {
                    return null;
                }
                fileNameSaved = fileContents.getName();
                fileContents.setMaxLength(0x180000L);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileContents.getOutputStream(true), "latin1");
                bufferedWriter = new BufferedWriter(outputStreamWriter);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(appWin, "Can not write to the specified location.\nCheck r-w-x privileges of the specified file and directories.", "Error", 2);
                return null;
            }
        } else {
            jFileChooser = new JFileChooser();
            int n = jFileChooser.showOpenDialog(appWin);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                fileNameSaved = file.getName();
                try {
                    bufferedWriter = new BufferedWriter(new FileWriter(file));
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(appWin, "Can not write to the specified location.\nCheck r-w-x privileges of the specified file and directories.", "Error", 2);
                    return null;
                }
            } else {
                return null;
            }
        }
        return bufferedWriter;
    }

    static void setPrinter() {
        if (printService == null && printerJob == null) {
            if (Tools.getPrinter() instanceof PrinterJob) {
                printerJob = (PrinterJob)Tools.getPrinter();
            } else {
                printService = (PrintService)Tools.getPrinter();
            }
        }
    }

    private void setPageFormat(int n) {
        int[] nArray = new int[2];
        int n2 = 0;
        int n3 = 1;
        nArray[0] = 1;
        nArray[1] = 0;
        if (n != 1) {
            n2 = 1;
            n3 = 0;
        }
        if (printService == null) {
            if (this.mPageFormat == null) {
                this.mPageFormat = printerJob.defaultPage();
                this.mPageFormat.setOrientation(nArray[n2]);
            }
            this.mPageFormat = printerJob.pageDialog(this.mPageFormat);
        } else {
            if (this.mPageFormat == null) {
                this.mPageFormat = printService.getDefaultPage();
                this.mPageFormat.setOrientation(nArray[n2]);
            }
            this.mPageFormat = printService.showPageFormatDialog(this.mPageFormat);
        }
        if (this.mPageFormat.getOrientation() != nArray[n2]) {
            this.mPageFormat.setOrientation(nArray[n3]);
        }
        Paper paper = this.mPageFormat.getPaper();
        double d = paper.getImageableX();
        double d2 = paper.getImageableY();
        paper.setImageableArea(d, d2, paper.getImageableWidth(), paper.getImageableHeight());
        this.mPageFormat.setPaper(paper);
    }

    private String displayHTMLDocument(String string) {
        BasicService basicService;
        String string2;
        String string3;
        String string4 = "";
        if (string.trim().equals("Manual")) {
            string3 = "ChemfloManual.pdf";
            string2 = "http://soilphysics.okstate.edu/software/chemflo/ChemfloManual.html";
        } else {
            string3 = "";
            string2 = "http://soilphysics.okstate.edu/software/chemflo/tips.html";
        }
        try {
            basicService = (BasicService)ServiceManager.lookup("javax.jnlp.BasicService");
        }
        catch (UnavailableServiceException unavailableServiceException) {
            basicService = null;
        }
        if (basicService == null) {
            this.Bctrl = new BrowserControl();
            File file = new File(string3);
            if (file != null && file.exists()) {
                try {
                    string3 = file.getCanonicalPath();
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(appWin, "Could not get path name.", "Error", 2);
                    return "Could not get path name";
                }
                string4 = this.Bctrl.displayURL("file://" + string3);
            } else {
                string4 = this.Bctrl.displayURL(string2);
            }
            if (string4.length() > 0) {
                JOptionPane.showMessageDialog(appWin, "Default browser not found.  You may start a browser yourself and view the document at the following URL: \n" + string2, "Error", 2);
            }
        } else if (basicService.isWebBrowserSupported()) {
            URL uRL = null;
            try {
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                JOptionPane.showMessageDialog(appWin, "Failed to set up document URL.", "Error", 2);
                return "Failed to set up document URL. ";
            }
            if (uRL != null && !basicService.showDocument(uRL)) {
                JOptionPane.showMessageDialog(appWin, "Web browser not supported in by the System.", "Error", 2);
            }
        } else {
            JOptionPane.showMessageDialog(appWin, "Web browser not supported in by the Basic Service in jnlp.", "Error", 2);
            return "Web browser not supported.";
        }
        return string4;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ String access$1800(CHEMFLO cHEMFLO, String string) {
        return cHEMFLO.displayHTMLDocument(string);
    }

    static {
        wMax = false;
        localSoilData = false;
    }

    class frameChangeListener
    extends ComponentAdapter {
        frameChangeListener() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            wMax = CHEMFLO.appWin.getSize().width > 800 || CHEMFLO.appWin.getSize().height > 600;
            old_width = CHEMFLO.appWin.getSize().width;
            old_height = CHEMFLO.appWin.getSize().height;
            CHEMFLO.this.updatePanelSize();
            currentCP.revalidate();
        }
    }

    class MouseEventHandler
    extends MouseAdapter
    implements MouseMotionListener,
    FocusListener {
        MouseEventHandler() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            currentCP.repaint();
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
            currentCP.repaint();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            currentCP.repaint();
        }

        public void focusGained(FocusEvent focusEvent) {
            currentCP.repaint();
        }

        public void focusLost(FocusEvent focusEvent) {
            currentCP.repaint();
        }
    }

    class FileQuitAction
    extends JMenuItem
    implements ActionListener {
        public FileQuitAction() {
            super("Exit");
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (CHEMFLO.soilIO.fout != null) {
                try {
                    CHEMFLO.soilIO.fout.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            System.exit(0);
        }
    }

    class LoadSoilAction
    extends JMenuItem
    implements ActionListener {
        public LoadSoilAction() {
            super("Load local soil database");
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            localSoilData = true;
            boolean bl = false;
            Vector vector = new Vector();
            int n = 0;
            while (n < CHEMFLO.soilIO.soilList.size()) {
                vector.add(CHEMFLO.soilIO.soilList.get(n));
                ++n;
            }
            if (CHEMFLO.soilIO.fout != null) {
                try {
                    CHEMFLO.soilIO.fout.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            CHEMFLO.soilIO.fin = null;
            String string = CHEMFLO.this.setInputStream();
            if (string == null) {
                return;
            }
            CHEMFLO.soilIO.soilList.removeAllElements();
            CHEMFLO.soilIO.soilList.removeAllElements();
            bl = soilIO.makeSoilList(string);
            if (!bl) {
                CHEMFLO.soilIO.soilList.removeAllElements();
                int n2 = 0;
                while (n2 < vector.size()) {
                    CHEMFLO.soilIO.soilList.add(vector.get(n2));
                    ++n2;
                }
            }
            RichardsEqn.getSoilNames(CHEMFLO.soilIO.soilList);
            RichardsEqn.currentSoilIndex = 0;
            DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel(RichardsEqn.allSoilNames);
            CHEMFLO.soilPane.soilBox.setModel(defaultComboBoxModel);
            soilPane.updateSelectedSoil();
            CHEMFLO.soilPane.soilBox.setSelectedIndex(RichardsEqn.currentSoilIndex);
            RichardsEqn.currentSoilName = (String)CHEMFLO.soilPane.soilBox.getSelectedItem();
            RichardsEqn.setCurrentSoil(RichardsEqn.currentSoilName);
            SoilInterestPanel.tfLength.setText("" + RichardsEqn.length);
            RichardsEqn.xmax = RichardsEqn.length;
            CHEMFLO.soilPane.sbrLength.setVisible(true);
            CHEMFLO.soilPane.lLength.setVisible(true);
            SoilInterestPanel.tfLength.setVisible(true);
            SoilInterestPanel.tfLength.setEditable(true);
            initialPane.refresh();
            transProperty.refresh();
            SoilInterestPanel.centerP.repaint();
            RichardsEqn.restart = true;
            mainScreen.revalidate();
            mainScreen.repaint();
            boundaryPane.updateMarks();
            buttonP.repaint();
            mainScreen.revalidate();
            mainScreen.repaint();
        }
    }

    class ScreenPrintAction
    extends JMenuItem
    implements ActionListener {
        public ScreenPrintAction() {
            super("Print Screen");
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CHEMFLO.setPrinter();
            if (printService == null && printerJob == null) {
                JOptionPane.showMessageDialog(appWin, "Failed to obtain printer service.", "Error", 2);
                return;
            }
            CHEMFLO.this.setPageFormat(1);
            if (CHEMFLO.this.mPageFormat == null) {
                JOptionPane.showMessageDialog(appWin, "Failed to set up page format.", "Error", 2);
                return;
            }
            ComponentPrintable componentPrintable = new ComponentPrintable(CHEMFLO.this.windowP);
            Book book = new Book();
            book.append(componentPrintable, CHEMFLO.this.mPageFormat);
            if (printService == null) {
                printerJob.setPageable(book);
                if (printerJob.printDialog()) {
                    try {
                        printerJob.print();
                    }
                    catch (PrinterException printerException) {
                        JOptionPane.showMessageDialog(appWin, "Could not print.", "Error", 2);
                        return;
                    }
                }
            } else {
                try {
                    printService.print(book);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(appWin, "Could not print.", "Error", 2);
                    return;
                }
            }
        }
    }

    class bntMouseListener
    extends MouseAdapter {
        bntMouseListener() {
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (CHEMFLO.this.GraphsBnt == (JButton)mouseEvent.getSource()) {
                CHEMFLO.this.GraphsBnt.setBackground(CHEMFLO.this.oldBk);
                CHEMFLO.this.GraphsBnt.setForeground(Color.black);
            } else if (CHEMFLO.this.SoilSysBnt == (JButton)mouseEvent.getSource()) {
                CHEMFLO.this.SoilSysBnt.setBackground(CHEMFLO.this.oldBk);
                CHEMFLO.this.SoilSysBnt.setForeground(Color.black);
            } else if (CHEMFLO.this.InitialCondBnt == (JButton)mouseEvent.getSource()) {
                CHEMFLO.this.InitialCondBnt.setBackground(CHEMFLO.this.oldBk);
                CHEMFLO.this.InitialCondBnt.setForeground(Color.black);
            } else if (CHEMFLO.this.BoundaryCondBnt == (JButton)mouseEvent.getSource()) {
                CHEMFLO.this.BoundaryCondBnt.setBackground(CHEMFLO.this.oldBk);
                CHEMFLO.this.BoundaryCondBnt.setForeground(Color.black);
            } else if (CHEMFLO.this.MeshSizeBnt == (JButton)mouseEvent.getSource()) {
                CHEMFLO.this.MeshSizeBnt.setBackground(CHEMFLO.this.oldBk);
                CHEMFLO.this.MeshSizeBnt.setForeground(Color.black);
            } else if (CHEMFLO.this.ReportTableBnt == (JButton)mouseEvent.getSource()) {
                CHEMFLO.this.ReportTableBnt.setBackground(CHEMFLO.this.oldBk);
                CHEMFLO.this.ReportTableBnt.setForeground(Color.black);
            } else if (CHEMFLO.this.PreferencesBnt == (JButton)mouseEvent.getSource()) {
                CHEMFLO.this.PreferencesBnt.setBackground(CHEMFLO.this.oldBk);
                CHEMFLO.this.PreferencesBnt.setForeground(Color.black);
            } else if (CHEMFLO.this.TransBnt == (JButton)mouseEvent.getSource()) {
                CHEMFLO.this.TransBnt.setBackground(CHEMFLO.this.oldBk);
                CHEMFLO.this.TransBnt.setForeground(Color.black);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (CHEMFLO.this.GraphsBnt == (JButton)mouseEvent.getSource()) {
                CHEMFLO.this.GraphsBnt.setBackground(CHEMFLO.this.newBk);
            } else if (CHEMFLO.this.SoilSysBnt == (JButton)mouseEvent.getSource()) {
                CHEMFLO.this.SoilSysBnt.setBackground(CHEMFLO.this.newBk);
            } else if (CHEMFLO.this.InitialCondBnt == (JButton)mouseEvent.getSource()) {
                CHEMFLO.this.InitialCondBnt.setBackground(CHEMFLO.this.newBk);
            } else if (CHEMFLO.this.BoundaryCondBnt == (JButton)mouseEvent.getSource()) {
                CHEMFLO.this.BoundaryCondBnt.setBackground(CHEMFLO.this.newBk);
            } else if (CHEMFLO.this.MeshSizeBnt == (JButton)mouseEvent.getSource()) {
                CHEMFLO.this.MeshSizeBnt.setBackground(CHEMFLO.this.newBk);
            } else if (CHEMFLO.this.ReportTableBnt == (JButton)mouseEvent.getSource()) {
                CHEMFLO.this.ReportTableBnt.setBackground(CHEMFLO.this.newBk);
            } else if (CHEMFLO.this.PreferencesBnt == (JButton)mouseEvent.getSource()) {
                CHEMFLO.this.PreferencesBnt.setBackground(CHEMFLO.this.newBk);
            } else if (CHEMFLO.this.TransBnt == (JButton)mouseEvent.getSource()) {
                CHEMFLO.this.TransBnt.setBackground(CHEMFLO.this.newBk);
            }
        }
    }

    class eventListener
    implements ActionListener {
        eventListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MainScreenPanel.lMessage1.setVisible(false);
            CHEMFLO.this.checkErrorFree();
            if (!RichardsEqn.errorFree) {
                JOptionPane.showMessageDialog(appWin, RichardsEqn.errorMessage, "Error", 0);
                appWin.repaint();
                return;
            }
            MainScreenPanel.lMessage1.setVisible(false);
            Object object = actionEvent.getSource();
            if (object == CHEMFLO.this.GraphsBnt) {
                if (CHEMFLO.this.errorInitialConditions() || CHEMFLO.this.errorTransProperity()) {
                    return;
                }
                if (initialPane.getHasTable()) {
                    initialPane.sortingTable();
                    if (CHEMFLO.initialPane.initTable.isPositionDuplication()) {
                        return;
                    }
                }
                if (transProperty.getHasTable()) {
                    transProperty.sortingTable();
                    if (CHEMFLO.transProperty.transPropPane.isPositionDuplication()) {
                        return;
                    }
                }
                if (CHEMFLO.this.initialCondChanged) {
                    initialPane.getInitialConditions();
                    CHEMFLO.this.initialCondChanged = false;
                }
                if (CHEMFLO.this.transPropChanged) {
                    transProperty.getTransProperties();
                    CHEMFLO.this.transPropChanged = false;
                }
                if (CHEMFLO.meshsizePane.mshsP.changed) {
                    CHEMFLO.meshsizePane.mshsP.getMeshData();
                }
                CHEMFLO.this.card.show(CHEMFLO.this.windowP, "Main Screen");
                currentCP = mainScreen;
            } else if (object == CHEMFLO.this.SoilSysBnt) {
                if (CHEMFLO.this.errorInitialConditions() || CHEMFLO.this.errorTransProperity()) {
                    return;
                }
                if (initialPane.getHasTable()) {
                    initialPane.sortingTable();
                    if (CHEMFLO.initialPane.initTable.isPositionDuplication()) {
                        return;
                    }
                }
                if (transProperty.getHasTable()) {
                    transProperty.sortingTable();
                    if (CHEMFLO.transProperty.transPropPane.isPositionDuplication()) {
                        return;
                    }
                }
                if (CHEMFLO.this.initialCondChanged) {
                    initialPane.getInitialConditions();
                    CHEMFLO.this.initialCondChanged = false;
                }
                if (CHEMFLO.this.transPropChanged) {
                    transProperty.getTransProperties();
                    CHEMFLO.this.transPropChanged = false;
                }
                CHEMFLO.this.card.show(CHEMFLO.this.windowP, "Select soil of interest");
                currentCP = soilPane;
            } else if (object == CHEMFLO.this.InitialCondBnt) {
                if (SoilInterestPanel.cboxSemiInfinite.isSelected()) {
                    CHEMFLO.initialPane.tfInitialCond.setVisible(true);
                    CHEMFLO.initialPane.sbrInitialCond.setVisible(true);
                    CHEMFLO.initialPane.tfInitialCond2.setVisible(false);
                    CHEMFLO.initialPane.sbrInitialCond2.setVisible(false);
                    CHEMFLO.initialPane.lInitialCond2.setVisible(false);
                    CHEMFLO.initialPane.choiceInitialCond2.setVisible(false);
                } else {
                    initialPane.hiddenComponents(false);
                }
                CHEMFLO.this.initialCondChanged = true;
                CHEMFLO.this.card.show(CHEMFLO.this.windowP, "Define initial condition of soil system");
                currentCP = initialPane;
            } else if (object == CHEMFLO.this.BoundaryCondBnt) {
                if (CHEMFLO.this.errorInitialConditions() || CHEMFLO.this.errorTransProperity()) {
                    return;
                }
                if (initialPane.getHasTable()) {
                    initialPane.sortingTable();
                    if (CHEMFLO.initialPane.initTable.isPositionDuplication()) {
                        return;
                    }
                }
                if (transProperty.getHasTable()) {
                    transProperty.sortingTable();
                    if (CHEMFLO.transProperty.transPropPane.isPositionDuplication()) {
                        return;
                    }
                }
                if (CHEMFLO.this.initialCondChanged) {
                    initialPane.getInitialConditions();
                    CHEMFLO.this.initialCondChanged = false;
                }
                if (CHEMFLO.this.transPropChanged) {
                    transProperty.getTransProperties();
                    CHEMFLO.this.transPropChanged = false;
                }
                CHEMFLO.this.card.show(CHEMFLO.this.windowP, "Define boundary conditions");
                currentCP = boundaryPane;
                if (RichardsEqn.semiInfiniteSelected) {
                    boundaryPane.showComponents1();
                }
                if (!RichardsEqn.semiInfiniteSelected && RichardsEqn.selectedInitialCond2 != 0) {
                    boundaryPane.showComponents2();
                }
                if (!RichardsEqn.semiInfiniteSelected && RichardsEqn.selectedInitialCond2 == 0) {
                    boundaryPane.showComponents3();
                }
            } else if (object == CHEMFLO.this.TransBnt) {
                CHEMFLO.this.card.show(CHEMFLO.this.windowP, "Trans Properties");
                currentCP = transProperty;
                CHEMFLO.this.transPropChanged = true;
            } else if (object == CHEMFLO.this.MeshSizeBnt) {
                if (CHEMFLO.this.errorInitialConditions() || CHEMFLO.this.errorTransProperity()) {
                    return;
                }
                if (initialPane.getHasTable()) {
                    initialPane.sortingTable();
                    if (CHEMFLO.initialPane.initTable.isPositionDuplication()) {
                        return;
                    }
                }
                if (CHEMFLO.this.initialCondChanged) {
                    initialPane.getInitialConditions();
                    CHEMFLO.this.initialCondChanged = false;
                }
                if (CHEMFLO.this.transPropChanged) {
                    transProperty.getTransProperties();
                    CHEMFLO.this.transPropChanged = false;
                }
                CHEMFLO.this.card.show(CHEMFLO.this.windowP, "Define mesh size");
                currentCP = meshsizePane;
                CHEMFLO.meshsizePane.mshsP.changed = false;
            } else if (object == CHEMFLO.this.ReportTableBnt) {
                if (CHEMFLO.this.errorInitialConditions() || CHEMFLO.this.errorTransProperity()) {
                    return;
                }
                if (initialPane.getHasTable()) {
                    initialPane.sortingTable();
                    if (CHEMFLO.initialPane.initTable.isPositionDuplication()) {
                        return;
                    }
                }
                if (transProperty.getHasTable()) {
                    transProperty.sortingTable();
                    if (CHEMFLO.transProperty.transPropPane.isPositionDuplication()) {
                        return;
                    }
                }
                if (CHEMFLO.this.initialCondChanged) {
                    initialPane.getInitialConditions();
                    CHEMFLO.this.initialCondChanged = false;
                }
                if (CHEMFLO.this.transPropChanged) {
                    transProperty.getTransProperties();
                    CHEMFLO.this.transPropChanged = false;
                }
                if (RichardsEqn.selectedInitialCond2 != 0 && !RichardsEqn.semiInfiniteSelected) {
                    CHEMFLO.reportPane.sub_title2.setVisible(true);
                    CHEMFLO.reportPane.chemConSolution.setVisible(true);
                    CHEMFLO.reportPane.chemConAdsorbed.setVisible(true);
                    CHEMFLO.reportPane.chemConTotal.setVisible(true);
                    CHEMFLO.reportPane.chemFluxDensity.setVisible(true);
                    CHEMFLO.reportPane.chemCumuFlux.setVisible(true);
                } else {
                    CHEMFLO.reportPane.sub_title2.setVisible(false);
                    CHEMFLO.reportPane.chemConSolution.setVisible(false);
                    CHEMFLO.reportPane.chemConAdsorbed.setVisible(false);
                    CHEMFLO.reportPane.chemConTotal.setVisible(false);
                    CHEMFLO.reportPane.chemFluxDensity.setVisible(false);
                    CHEMFLO.reportPane.chemCumuFlux.setVisible(false);
                    reportPane.reSetChemChoice();
                }
                if (RichardsEqn.criticalPosition != 0.0) {
                    RichardsEqn.experiment.criticalPosition = RichardsEqn.criticalPosition = 0.0;
                    CHEMFLO.mainScreen.sbrPosition.setValue((int)(RichardsEqn.criticalPosition + 0.5));
                    CHEMFLO.mainScreen.tfPosition.setText(RichardsEqn.formatLength(RichardsEqn.criticalPosition));
                }
                if (CHEMFLO.meshsizePane.mshsP.changed) {
                    CHEMFLO.meshsizePane.mshsP.getMeshData();
                }
                CHEMFLO.this.card.show(CHEMFLO.this.windowP, "Reports Tables");
                currentCP = reportPane;
            } else if (object == CHEMFLO.this.PreferencesBnt) {
                if (CHEMFLO.this.errorInitialConditions() || CHEMFLO.this.errorTransProperity()) {
                    return;
                }
                if (initialPane.getHasTable()) {
                    initialPane.sortingTable();
                    if (CHEMFLO.initialPane.initTable.isPositionDuplication()) {
                        return;
                    }
                }
                if (transProperty.getHasTable()) {
                    transProperty.sortingTable();
                    if (CHEMFLO.transProperty.transPropPane.isPositionDuplication()) {
                        return;
                    }
                }
                if (CHEMFLO.this.initialCondChanged) {
                    initialPane.getInitialConditions();
                    CHEMFLO.this.initialCondChanged = false;
                }
                if (CHEMFLO.this.transPropChanged) {
                    transProperty.getTransProperties();
                    CHEMFLO.this.transPropChanged = false;
                }
                CHEMFLO.this.card.show(CHEMFLO.this.windowP, "Preferences");
                currentCP = preferencePane;
            }
        }
    }
}

