/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class DefineBoundaryPanel
extends ChemfloPanel {
    JLabel lBoundaryCond;
    JTextField tfBoundaryCondAt0;
    JScrollBar sbrBoundaryCondAt0;
    public JComboBox choiceBoundaryCond;
    JLabel lCriticalPot;
    JTextField tfCriticalPot;
    JScrollBar sbrCriticalPot;
    Vector choiceBoundaryCondNames = new Vector(5, 5);
    JLabel lBoundaryCondAtL;
    JTextField tfBoundaryCondAtL;
    JScrollBar sbrBoundaryCondAtL;
    public JComboBox choiceBoundaryCondAtL;
    Vector choiceBoundaryCondNames2 = new Vector(5, 5);
    JLabel lBndChemAt0;
    JTextField tfBndChemAt0;
    JScrollBar sbrBndChemAt0;
    public JComboBox choiceBndChemAt0;
    Vector BndChemAt0Names = new Vector(5, 5);
    JLabel lBndChemAtL;
    JTextField tfBndChemAtL;
    JScrollBar sbrBndChemAtL;
    public JComboBox choiceBndChemAtL;
    Vector BndChemAtLNames = new Vector(5, 5);
    static JRadioButton cboxFirstBC = new JRadioButton("<html>Restart Simulation at t=0</html>", true);
    static JRadioButton cboxMultpleBC = new JRadioButton("<html>Continue Simulation with New Boundary Condition</html> ", false);
    ButtonGroup group = new ButtonGroup();
    private SimulateOptionPanel optionPane;
    boolean errorFree = true;
    private JPanel rootPane;
    private JPanel topPane;
    private int wid = 0;
    private int hgh = 0;
    private JPanel northP;
    private JPanel southP;
    private JPanel westP;
    private JPanel eastP;

    public DefineBoundaryPanel() {
        super("Define Boundary Conditions");
        this.setLayout(this.border);
        this.setBorder(this.edge);
        this.add((Component)this.titleP, "North");
        cboxFirstBC.setFont(RichardsEqn.comboBoxFont);
        cboxMultpleBC.setFont(RichardsEqn.comboBoxFont);
        if (CHEMFLO.wMax) {
            this.wid = CHEMFLO.old_width - 250;
            this.hgh = CHEMFLO.old_height - 140;
        } else {
            this.wid = 550;
            this.hgh = 470;
        }
        this.rootPane = new JPanel();
        this.rootPane.setLayout(new BorderLayout());
        this.rootPane.setPreferredSize(new Dimension(this.wid, this.hgh));
        this.northP = new JPanel();
        this.northP.setPreferredSize(new Dimension(this.wid, 1));
        this.southP = new JPanel();
        this.southP.setPreferredSize(new Dimension(this.wid, 1));
        this.westP = new JPanel();
        this.westP.setPreferredSize(new Dimension(1, 450));
        this.eastP = new JPanel();
        this.eastP.setPreferredSize(new Dimension(1, 450));
        this.topPane = new JPanel();
        this.topPane.setLayout(new BorderLayout());
        this.topPane.setPreferredSize(new Dimension(this.wid - 2, this.hgh - 2));
        NorthPanelL northPanelL = new NorthPanelL();
        this.topPane.add((Component)northPanelL, "North");
        BndChemPanel bndChemPanel = new BndChemPanel();
        this.topPane.add((Component)bndChemPanel, "Center");
        this.rootPane.add((Component)this.northP, "North");
        this.rootPane.add((Component)this.westP, "West");
        this.rootPane.add((Component)this.topPane, "Center");
        this.rootPane.add((Component)this.eastP, "East");
        this.rootPane.add((Component)this.southP, "South");
        this.add((Component)this.rootPane, "Center");
        this.addMouseListener(new forEvent(" "));
    }

    private void performed() {
        String string = "";
        JTextField jTextField = null;
        try {
            double d;
            double d2;
            String string2;
            switch (RichardsEqn.selectedBoundaryCond) {
                case 0: 
                case 1: {
                    jTextField = this.tfBoundaryCondAt0;
                    string = "Boundary Condition for Water at X = 0: Invalid matric potential value";
                    string2 = new String(this.tfBoundaryCondAt0.getText());
                    d2 = Double.parseDouble(string2);
                    d = RichardsEqn.storeLength(d2);
                    if (d < -15000.0 || d > 5000.0) {
                        throw new IllegalValueException("Boundary Condition for Water at X = 0: Matric potential must be between " + RichardsEqn.formatLength(-15000.0) + " and " + RichardsEqn.formatLength(5000.0) + " " + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + ".");
                    }
                    if (d == RichardsEqn.matricPotAt0) break;
                    RichardsEqn.matricPotAt0 = d;
                    this.sbrBoundaryCondAt0.setValue((int)((RichardsEqn.matricPotAt0 + 10000.0) / 10.0 + 0.5));
                    RichardsEqn.matricPotAt0 = d;
                    this.tfBoundaryCondAt0.setText(String.valueOf(d));
                    RichardsEqn.newBC0 = true;
                    break;
                }
                case 2: {
                    jTextField = this.tfBoundaryCondAt0;
                    string = "Boundary Condition for Water at X = 0: Invalid flux value";
                    string2 = new String(this.tfBoundaryCondAt0.getText());
                    d2 = Double.parseDouble(string2);
                    d = RichardsEqn.storeVelocity(d2);
                    if (d < -25.0 || d > 25.0) {
                        throw new IllegalValueException("Boundary Condition for Water at X = 0: Flux must be between " + RichardsEqn.formatVelocity(-25.0) + " and " + RichardsEqn.formatVelocity(25.0) + " " + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ".");
                    }
                    if (d == RichardsEqn.fluxAt0) break;
                    RichardsEqn.fluxAt0 = d;
                    this.sbrBoundaryCondAt0.setValue((int)(250.0 + 10.0 * RichardsEqn.fluxAt0 + 0.5));
                    RichardsEqn.rainfall = d;
                    this.tfBoundaryCondAt0.setText(String.valueOf(d));
                    RichardsEqn.newBC0 = true;
                    break;
                }
                case 3: {
                    jTextField = this.tfBoundaryCondAt0;
                    string = "Boundary Condition for Water at X = 0: Invalid rainfall value";
                    string2 = new String(this.tfBoundaryCondAt0.getText());
                    d2 = Double.parseDouble(string2);
                    d = RichardsEqn.storeVelocity(d2);
                    if (d < 0.0 || d > 25.0) {
                        throw new IllegalValueException("Boundary Condition for Water at X = 0: Rainfall must be between 0 and " + RichardsEqn.formatVelocity(25.0) + " " + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ".");
                    }
                    if (d == RichardsEqn.rainfall) break;
                    RichardsEqn.rainfall = d;
                    this.sbrBoundaryCondAt0.setValue((int)(10.0 * RichardsEqn.rainfall + 0.5));
                    RichardsEqn.rainfall = d;
                    this.tfBoundaryCondAt0.setText(String.valueOf(d));
                    RichardsEqn.newBC0 = true;
                    break;
                }
                case 4: {
                    jTextField = this.tfBoundaryCondAt0;
                    string = "Boundary Condition for Water at X = 0: Invalid flux value";
                    string2 = new String(this.tfBoundaryCondAt0.getText());
                    d2 = Double.parseDouble(string2);
                    d = RichardsEqn.storeVelocity(d2);
                    if (d < -25.0 || d > 25.0) {
                        throw new IllegalValueException("Boundary Condition for Water at X = 0: Flux must be between " + RichardsEqn.formatVelocity(-25.0) + " and " + RichardsEqn.formatVelocity(25.0) + " " + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ".");
                    }
                    if (d != RichardsEqn.mixedFlux) {
                        RichardsEqn.mixedFlux = d;
                        this.sbrBoundaryCondAt0.setValue((int)(250.0 + 10.0 * RichardsEqn.mixedFlux + 0.5));
                        RichardsEqn.mixedFlux = d;
                        this.tfBoundaryCondAt0.setText(String.valueOf(d));
                        RichardsEqn.newBC0 = true;
                    }
                    jTextField = this.tfCriticalPot;
                    string = "Boundary Condition for Water at X = 0: Invalid matric potential value";
                    string2 = new String(this.tfCriticalPot.getText());
                    d2 = Double.parseDouble(string2);
                    d = RichardsEqn.storeLength(d2);
                    if (d < -15000.0 || d > 5000.0) {
                        throw new IllegalValueException("Boundary Condition for Water at X = 0: Matric potential must be between " + RichardsEqn.formatLength(-15000.0) + " and " + RichardsEqn.formatLength(5000.0) + " " + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + ".");
                    }
                    if (d == RichardsEqn.criticalPot) break;
                    RichardsEqn.criticalPot = d;
                    this.sbrCriticalPot.setValue((int)((RichardsEqn.criticalPot + 10000.0) / 10.0 + 0.5));
                    RichardsEqn.criticalPot = d;
                    this.tfCriticalPot.setText(String.valueOf(d));
                    RichardsEqn.newBC0 = true;
                    break;
                }
                case 5: {
                    jTextField = this.tfBoundaryCondAt0;
                    string = "Boundary Condition for Water at X = 0: Invalid initial depth of ponding value";
                    string2 = new String(this.tfBoundaryCondAt0.getText());
                    d2 = Double.parseDouble(string2);
                    d = RichardsEqn.storeLength(d2);
                    if (d < 0.0 || d > 100.0) {
                        throw new IllegalValueException("Boundary Condition for Water at X = 0: Intial Depth of Ponding must be between " + RichardsEqn.formatLength(0.0) + " and " + RichardsEqn.formatLength(100.0) + " " + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + ".");
                    }
                    if (d == RichardsEqn.initPondingDepth) break;
                    RichardsEqn.initPondingDepth = d;
                    this.sbrBoundaryCondAt0.setValue((int)(RichardsEqn.initPondingDepth * 10.0 + 0.5));
                    RichardsEqn.matricPotAt0 = d;
                    this.tfBoundaryCondAt0.setText(String.valueOf(d));
                    RichardsEqn.newBC0 = true;
                }
            }
            switch (RichardsEqn.selectedBoundaryCondAtL) {
                case 0: {
                    jTextField = this.tfBoundaryCondAtL;
                    string = "Boundary Condition for Water at X = " + Tools.formatDouble(RichardsEqn.length, 1, 1) + ": Invalid matric potential value";
                    string2 = new String(this.tfBoundaryCondAtL.getText());
                    d2 = Double.parseDouble(string2);
                    d = RichardsEqn.storeLength(d2);
                    if (d < -15000.0 || d > 5000.0) {
                        throw new IllegalValueException("Boundary Condition for Water at X = " + Tools.formatDouble(RichardsEqn.length, 1, 1) + ": Matric potential must be between " + RichardsEqn.formatLength(-15000.0) + " and " + RichardsEqn.formatLength(5000.0) + " " + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + ".");
                    }
                    if (d == RichardsEqn.matricPotAtL) break;
                    RichardsEqn.matricPotAtL = d;
                    this.sbrBoundaryCondAtL.setValue((int)((RichardsEqn.matricPotAtL + 10000.0) / 10.0 + 0.5));
                    RichardsEqn.matricPotAtL = d;
                    this.tfBoundaryCondAtL.setText(String.valueOf(d));
                    RichardsEqn.newBCL = true;
                    break;
                }
                case 1: {
                    jTextField = this.tfBoundaryCondAtL;
                    string = "Boundary Condition for Water at X = " + Tools.formatDouble(RichardsEqn.length, 1, 1) + ": Invalid flux value";
                    string2 = new String(this.tfBoundaryCondAtL.getText());
                    d2 = Double.parseDouble(string2);
                    d = RichardsEqn.storeVelocity(d2);
                    if (d < -25.0 || d > 25.0) {
                        throw new IllegalValueException("Boundary Condition for Water at X = " + Tools.formatDouble(RichardsEqn.length, 1, 1) + ": Flux must be between " + RichardsEqn.formatVelocity(-25.0) + " and " + RichardsEqn.formatVelocity(25.0) + " " + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ".");
                    }
                    if (d == RichardsEqn.fluxAtL) break;
                    RichardsEqn.fluxAtL = d;
                    this.sbrBoundaryCondAtL.setValue((int)(250.0 + 10.0 * RichardsEqn.fluxAtL + 0.5));
                    RichardsEqn.fluxAtL = d;
                    this.tfBoundaryCondAtL.setText(String.valueOf(d));
                    RichardsEqn.newBCL = true;
                }
            }
            if (RichardsEqn.selectedInitialCond2 > 0) {
                switch (RichardsEqn.selectedChemBoundaryCond) {
                    case 0: {
                        jTextField = this.tfBndChemAt0;
                        string = "Boundary Condition for Chemical at X = 0: Invalid chemical concentration";
                        string2 = new String(this.tfBndChemAt0.getText());
                        d = Double.parseDouble(string2);
                        if (d < 0.0 || d > 1000.0) {
                            throw new IllegalValueException("Boundary Condition for Chemical at X = 0: Chemical concentration must be between 0.0 and  1000.0 g/m3");
                        }
                        if (d == RichardsEqn.matricChemPotAt0) break;
                        RichardsEqn.matricChemPotAt0 = d;
                        this.sbrBndChemAt0.setValue((int)(RichardsEqn.matricChemPotAt0 * 1000.0 + 0.5));
                        RichardsEqn.matricChemPotAt0 = d;
                        this.tfBndChemAt0.setText(Tools.formatDouble(d, 3, 3));
                        RichardsEqn.newBC0 = true;
                        break;
                    }
                    case 1: {
                        jTextField = this.tfBndChemAt0;
                        string = "Boundary Condition for Chemical at X = 0: Invalid chemical concentration";
                        string2 = new String(this.tfBndChemAt0.getText());
                        d = Double.parseDouble(string2);
                        if (d < 0.0 || d > 1000.0) {
                            throw new IllegalValueException("Boundary Condition for Chemical at X = 0: Chemical concentration must be between 0.0 and 1000.0 g/m3");
                        }
                        if (d == RichardsEqn.matricChemSoilPotAt0) break;
                        RichardsEqn.matricChemSoilPotAt0 = d;
                        this.sbrBndChemAt0.setValue((int)(RichardsEqn.matricChemSoilPotAt0 * 1000.0 + 0.5));
                        RichardsEqn.matricChemSoilPotAt0 = d;
                        this.tfBndChemAt0.setText(Tools.formatDouble(d, 3, 3));
                        RichardsEqn.newBC0 = true;
                    }
                }
                switch (RichardsEqn.selectedChemBoundaryCondAtL) {
                    case 1: {
                        jTextField = this.tfBndChemAtL;
                        string = "Boundary Condition for Chemical at X = " + Tools.formatDouble(RichardsEqn.length, 1, 1) + ": Invalid chemical concentration";
                        string2 = new String(this.tfBndChemAtL.getText());
                        d = Double.parseDouble(string2);
                        if (d < 0.0 || d > 1000.0) {
                            throw new IllegalValueException("Boundary Condition for Chemical at X = " + Tools.formatDouble(RichardsEqn.length, 1, 1) + ": Chemical concentration must be between 0.0 and " + "1000.0 g/m3");
                        }
                        if (d == RichardsEqn.matricChemPotAtL) break;
                        RichardsEqn.matricChemPotAtL = d;
                        this.sbrBndChemAtL.setValue((int)(RichardsEqn.matricChemPotAtL * 1000.0 + 0.5));
                        RichardsEqn.matricChemPotAtL = d;
                        this.tfBndChemAtL.setText(Tools.formatDouble(d, 3, 3));
                        RichardsEqn.newBCL = true;
                    }
                }
            }
            this.errorFree = true;
        }
        catch (Exception exception) {
            RichardsEqn.errorMessage = exception instanceof IllegalValueException ? exception.getMessage() : string;
            jTextField.grabFocus();
            this.errorFree = false;
        }
    }

    public void showComponents1() {
        this.lBoundaryCondAtL.setVisible(false);
        this.choiceBoundaryCondAtL.setVisible(false);
        this.tfBoundaryCondAtL.setVisible(false);
        this.sbrBoundaryCondAtL.setVisible(false);
        this.lBndChemAtL.setVisible(false);
        this.choiceBndChemAtL.setVisible(false);
        this.tfBndChemAtL.setVisible(false);
        this.sbrBndChemAtL.setVisible(false);
        this.lBndChemAt0.setVisible(false);
        this.tfBndChemAt0.setVisible(false);
        this.sbrBndChemAt0.setVisible(false);
        this.choiceBndChemAt0.setVisible(false);
    }

    public void showComponents2() {
        this.lBoundaryCondAtL.setVisible(true);
        this.choiceBoundaryCondAtL.setVisible(true);
        this.tfBoundaryCondAtL.setVisible(true);
        this.sbrBoundaryCondAtL.setVisible(true);
        this.lBndChemAtL.setVisible(true);
        this.choiceBndChemAtL.setVisible(true);
        if (RichardsEqn.selectedChemBoundaryCondAtL == 0) {
            this.tfBndChemAtL.setVisible(false);
            this.sbrBndChemAtL.setVisible(false);
        } else {
            this.tfBndChemAtL.setVisible(true);
            this.sbrBndChemAtL.setVisible(true);
        }
        this.lBndChemAt0.setVisible(true);
        this.tfBndChemAt0.setVisible(true);
        this.sbrBndChemAt0.setVisible(true);
        this.choiceBndChemAt0.setVisible(true);
        this.tfBoundaryCondAtL.setVisible(RichardsEqn.selectedBoundaryCondAtL != 2);
        this.sbrBoundaryCondAtL.setVisible(RichardsEqn.selectedBoundaryCondAtL != 2);
    }

    public void showComponents3() {
        this.lBoundaryCondAtL.setVisible(true);
        this.choiceBoundaryCondAtL.setVisible(true);
        this.tfBoundaryCondAtL.setVisible(true);
        this.sbrBoundaryCondAtL.setVisible(true);
        this.lBndChemAtL.setVisible(false);
        this.choiceBndChemAtL.setVisible(false);
        this.tfBndChemAtL.setVisible(false);
        this.sbrBndChemAtL.setVisible(false);
        this.lBndChemAt0.setVisible(false);
        this.tfBndChemAt0.setVisible(false);
        this.sbrBndChemAt0.setVisible(false);
        this.choiceBndChemAt0.setVisible(false);
        this.tfBoundaryCondAtL.setVisible(RichardsEqn.selectedBoundaryCondAtL != 2);
        this.sbrBoundaryCondAtL.setVisible(RichardsEqn.selectedBoundaryCondAtL != 2);
    }

    public void ResetUnits() {
        this.lBoundaryCondAtL.setText("Boundary Condition at x = " + RichardsEqn.formatLength(RichardsEqn.length) + " " + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit]);
        this.lBndChemAtL.setText("Boundary Condition for Chemical at x = " + RichardsEqn.formatLength(RichardsEqn.length) + " " + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit]);
        if (this.choiceBoundaryCond.getSelectedIndex() == 0) {
            this.tfBoundaryCondAt0.setText(RichardsEqn.formatLength(RichardsEqn.matricPotAt0));
        } else {
            this.tfBoundaryCondAt0.setText(RichardsEqn.formatVelocity(RichardsEqn.fluxAt0));
        }
        if (this.choiceBoundaryCondAtL.getSelectedIndex() == 0) {
            this.tfBoundaryCondAtL.setText(RichardsEqn.formatLength(RichardsEqn.matricPotAtL));
        } else if (this.choiceBoundaryCondAtL.getSelectedIndex() == 1) {
            this.tfBoundaryCondAtL.setText(RichardsEqn.formatVelocity(RichardsEqn.fluxAtL));
        }
        this.choiceBoundaryCondNames.removeAllElements();
        this.choiceBoundaryCondNames.addElement("Matric Potential (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + ")");
        this.choiceBoundaryCondNames.addElement("Total Potential (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + ")");
        this.choiceBoundaryCondNames.addElement("Flux Density (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ")");
        this.choiceBoundaryCondNames.addElement("Rainfall Rate (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ")");
        this.choiceBoundaryCondNames.addElement("Mixed Type: Flux (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ")");
        this.choiceBoundaryCond.setSelectedIndex(RichardsEqn.selectedBoundaryCond);
        this.choiceBoundaryCondNames2.removeAllElements();
        this.choiceBoundaryCondNames2.addElement("Matric Potential (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + ")");
        this.choiceBoundaryCondNames2.addElement("Flux Density (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ")");
        this.choiceBoundaryCondNames2.addElement("Free Drainage");
        this.choiceBoundaryCondAtL.setSelectedIndex(RichardsEqn.selectedBoundaryCondAtL);
        if (RichardsEqn.selectedBoundaryCond == 4) {
            this.lCriticalPot.setText("Critical Matric Potential (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + ")");
        }
        this.repaint();
    }

    public void updateMarks() {
        this.lBoundaryCondAtL.setText("Boundary Condition at x = " + RichardsEqn.formatLength(RichardsEqn.length) + " " + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit]);
        this.lBndChemAtL.setText("Boundary Condition for Chemical at x = " + RichardsEqn.formatLength(RichardsEqn.length) + " " + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit]);
    }

    public void updateSize() {
        if (CHEMFLO.wMax) {
            this.wid = CHEMFLO.old_width - 250;
            this.hgh = CHEMFLO.old_height - 140;
        } else {
            this.wid = 550;
            this.hgh = 470;
        }
        if (this.rootPane.getComponentCount() != 0) {
            this.rootPane.removeAll();
        }
        this.rootPane.setPreferredSize(new Dimension(this.wid, this.hgh));
        int n = (int)((double)(this.hgh - 470) / 2.0);
        this.northP.setPreferredSize(new Dimension(this.wid, n));
        if (CHEMFLO.wMax) {
            this.southP.setPreferredSize(new Dimension(this.wid, n - 10));
        } else {
            this.southP.setPreferredSize(new Dimension(this.wid, n));
        }
        int n2 = (int)((double)(this.wid - 540) / 2.0);
        this.westP.setPreferredSize(new Dimension(n2, 460));
        this.eastP.setPreferredSize(new Dimension(n2 - 5, 460));
        this.rootPane.add((Component)this.northP, "North");
        this.rootPane.add((Component)this.westP, "West");
        this.rootPane.add((Component)this.topPane, "Center");
        this.rootPane.add((Component)this.eastP, "East");
        this.rootPane.add((Component)this.southP, "South");
        this.rootPane.repaint();
    }

    public Vector getBoundaryConditionData() {
        int n;
        int n2;
        int n3;
        int n4;
        String string;
        this.performed();
        if (!this.errorFree) {
            new ErrorMessageDialog("Error", RichardsEqn.errorMessage);
        }
        Vector<String> vector = new Vector<String>();
        vector.addElement("Boundary Conditions:");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Location       ");
        int n5 = stringBuffer.toString().length();
        stringBuffer.append("Time(" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ")                 ");
        int n6 = stringBuffer.toString().length();
        stringBuffer.append("Component   ");
        int n7 = stringBuffer.toString().length();
        stringBuffer.append("Boundary Condition");
        vector.addElement(stringBuffer.toString());
        int n8 = 0;
        while (n8 <= RichardsEqn.mBC) {
            stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            StringBuffer stringBuffer3 = new StringBuffer();
            string = new String(String.valueOf(Tools.formatDouble(RichardsEqn.bc[n8].getTimeStart(), 4, 12)).trim() + " to " + String.valueOf(Tools.formatDouble(RichardsEqn.bc[n8].getTimeEnd(), 4, 12)).trim());
            stringBuffer.append("X = 0 " + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit]);
            n4 = n5 - stringBuffer.toString().length();
            n3 = 0;
            while (n3 < n4) {
                stringBuffer.append(" ");
                ++n3;
            }
            stringBuffer.append(string);
            n4 = n6 - stringBuffer.toString().length();
            n2 = 0;
            while (n2 < n4) {
                stringBuffer.append(" ");
                ++n2;
            }
            stringBuffer.append("Water");
            n4 = n7 - stringBuffer.toString().length();
            n = 0;
            while (n < n4) {
                stringBuffer.append(" ");
                ++n;
            }
            switch (RichardsEqn.bc[n8].getWaterBCTypeAt0()) {
                case 0: {
                    stringBuffer.append("Matric Potential = " + RichardsEqn.formatLength(RichardsEqn.bc[n8].getPotentialAt0()) + " " + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit]);
                    break;
                }
                case 1: {
                    stringBuffer.append("Flux Density = " + RichardsEqn.formatVelocity(RichardsEqn.bc[n8].getFluxAt0()) + " " + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit]);
                    break;
                }
                case 2: {
                    stringBuffer.append("Mixed Type:");
                    int n9 = 0;
                    while (n9 < n7) {
                        stringBuffer2.append(" ");
                        stringBuffer3.append(" ");
                        ++n9;
                    }
                    stringBuffer2.append("Flux Density = " + RichardsEqn.formatVelocity(RichardsEqn.bc[n8].getFluxAt0()) + " " + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit]);
                    stringBuffer3.append("Critical Matric Potential = " + RichardsEqn.formatLength(RichardsEqn.bc[n8].getPotentialAt0()) + " " + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit]);
                    break;
                }
                case 7: {
                    stringBuffer.append("Falling Head:");
                    int n10 = 0;
                    while (n10 < n7) {
                        stringBuffer2.append(" ");
                        ++n10;
                    }
                    stringBuffer2.append("Initial Ponding Depth = " + RichardsEqn.formatLength(RichardsEqn.bc[n8].getInitialPondingDepth()) + " " + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit]);
                }
            }
            vector.addElement(stringBuffer.toString());
            if (RichardsEqn.bc[n8].getWaterBCTypeAt0() == 7) {
                vector.addElement(stringBuffer2.toString());
            }
            if (RichardsEqn.bc[n8].getWaterBCTypeAt0() == 2) {
                vector.addElement(stringBuffer2.toString());
                vector.addElement(stringBuffer3.toString());
            }
            ++n8;
        }
        if (!RichardsEqn.semiInfiniteSelected) {
            if (RichardsEqn.selectedInitialCond2 > 0) {
                n8 = 0;
                while (n8 <= RichardsEqn.mBC) {
                    stringBuffer = new StringBuffer();
                    string = new String(String.valueOf(Tools.formatDouble(RichardsEqn.bc[n8].getTimeStart(), 4, 12)).trim() + " to " + String.valueOf(Tools.formatDouble(RichardsEqn.bc[n8].getTimeEnd(), 4, 12)).trim());
                    stringBuffer.append("X = 0 " + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit]);
                    n4 = n5 - stringBuffer.toString().length();
                    n3 = 0;
                    while (n3 < n4) {
                        stringBuffer.append(" ");
                        ++n3;
                    }
                    stringBuffer.append(string);
                    n4 = n6 - stringBuffer.toString().length();
                    n2 = 0;
                    while (n2 < n4) {
                        stringBuffer.append(" ");
                        ++n2;
                    }
                    stringBuffer.append("Chemical");
                    n4 = n7 - stringBuffer.toString().length();
                    n = 0;
                    while (n < n4) {
                        stringBuffer.append(" ");
                        ++n;
                    }
                    switch (RichardsEqn.bc[n8].getChemBCTypeAt0()) {
                        case 4: {
                            stringBuffer.append("Inflow Solution Conc. = " + String.valueOf(Tools.formatDouble(RichardsEqn.bc[n8].getConcAt0(), 4, 12)).trim() + " g/m3");
                            break;
                        }
                        case 5: {
                            stringBuffer.append("Soil Solution Conc. = " + String.valueOf(Tools.formatDouble(RichardsEqn.bc[n8].getConcAt0(), 4, 12)).trim() + " g/m3");
                        }
                    }
                    vector.addElement(stringBuffer.toString());
                    ++n8;
                }
            }
            n8 = 0;
            while (n8 <= RichardsEqn.mBC) {
                stringBuffer = new StringBuffer();
                string = new String(String.valueOf(Tools.formatDouble(RichardsEqn.bc[n8].getTimeStart(), 4, 12)).trim() + " to " + String.valueOf(Tools.formatDouble(RichardsEqn.bc[n8].getTimeEnd(), 4, 12)).trim());
                stringBuffer.append("X = " + RichardsEqn.formatLength(RichardsEqn.length) + " " + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit]);
                n4 = n5 - stringBuffer.toString().length();
                n3 = 0;
                while (n3 < n4) {
                    stringBuffer.append(" ");
                    ++n3;
                }
                stringBuffer.append(string);
                n4 = n6 - stringBuffer.toString().length();
                n2 = 0;
                while (n2 < n4) {
                    stringBuffer.append(" ");
                    ++n2;
                }
                stringBuffer.append("Water");
                n4 = n7 - stringBuffer.toString().length();
                n = 0;
                while (n < n4) {
                    stringBuffer.append(" ");
                    ++n;
                }
                switch (RichardsEqn.bc[n8].getWaterBCTypeAtL()) {
                    case 0: {
                        stringBuffer.append("Matric Potential = " + RichardsEqn.formatLength(RichardsEqn.bc[n8].getPotentialAtL()) + " " + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit]);
                        break;
                    }
                    case 1: {
                        stringBuffer.append("Flux Density = " + RichardsEqn.formatVelocity(RichardsEqn.bc[n8].getFluxAtL()) + " " + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit]);
                        break;
                    }
                    case 3: {
                        stringBuffer.append("Free Drainage                          ");
                    }
                }
                vector.addElement(stringBuffer.toString());
                ++n8;
            }
            if (RichardsEqn.selectedInitialCond2 > 0) {
                n8 = 0;
                while (n8 <= RichardsEqn.mBC) {
                    stringBuffer = new StringBuffer();
                    string = new String(String.valueOf(Tools.formatDouble(RichardsEqn.bc[n8].getTimeStart(), 4, 12)).trim() + " to " + String.valueOf(Tools.formatDouble(RichardsEqn.bc[n8].getTimeEnd(), 4, 12)).trim());
                    stringBuffer.append("X = " + String.valueOf(Tools.formatDouble(RichardsEqn.length, 1, 8)).trim() + " " + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit]);
                    n4 = n5 - stringBuffer.toString().length();
                    n3 = 0;
                    while (n3 < n4) {
                        stringBuffer.append(" ");
                        ++n3;
                    }
                    stringBuffer.append(string);
                    n4 = n6 - stringBuffer.toString().length();
                    n2 = 0;
                    while (n2 < n4) {
                        stringBuffer.append(" ");
                        ++n2;
                    }
                    stringBuffer.append("Chemical");
                    n4 = n7 - stringBuffer.toString().length();
                    n = 0;
                    while (n < n4) {
                        stringBuffer.append(" ");
                        ++n;
                    }
                    switch (RichardsEqn.bc[n8].getChemBCTypeAtL()) {
                        case 6: {
                            stringBuffer.append("Convective Flow Only");
                            break;
                        }
                        case 5: {
                            stringBuffer.append("Soil Solution Conc. = " + String.valueOf(Tools.formatDouble(RichardsEqn.bc[n8].getConcAtL(), 4, 12)).trim() + " g/m3");
                        }
                    }
                    vector.addElement(stringBuffer.toString());
                    ++n8;
                }
            }
        }
        return vector;
    }

    class forEvent
    extends MouseAdapter
    implements AdjustmentListener,
    ActionListener,
    ItemListener {
        int iTemp;
        String sTemp;
        String name;

        public forEvent(String string) {
            this.name = string;
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            if (this.name.equals("BoundaryCondAt0")) {
                int n = DefineBoundaryPanel.this.sbrBoundaryCondAt0.getValue();
                switch (RichardsEqn.selectedBoundaryCond) {
                    case 0: 
                    case 1: {
                        n = n * 10 - 10000;
                        RichardsEqn.matricPotAt0 = n;
                        DefineBoundaryPanel.this.tfBoundaryCondAt0.setText(RichardsEqn.formatLength(RichardsEqn.matricPotAt0));
                        break;
                    }
                    case 2: {
                        RichardsEqn.fluxAt0 = (double)(n - 250) / 10.0;
                        DefineBoundaryPanel.this.tfBoundaryCondAt0.setText(RichardsEqn.formatVelocity(RichardsEqn.fluxAt0));
                        break;
                    }
                    case 3: {
                        RichardsEqn.rainfall = (double)n / 10.0;
                        DefineBoundaryPanel.this.tfBoundaryCondAt0.setText(RichardsEqn.formatVelocity(RichardsEqn.rainfall));
                        break;
                    }
                    case 4: {
                        RichardsEqn.mixedFlux = (double)(n - 250) / 10.0;
                        DefineBoundaryPanel.this.tfBoundaryCondAt0.setText(RichardsEqn.formatVelocity(RichardsEqn.mixedFlux));
                        break;
                    }
                    case 5: {
                        RichardsEqn.initPondingDepth = (double)n / 10.0;
                        DefineBoundaryPanel.this.tfBoundaryCondAt0.setText(RichardsEqn.formatLength(RichardsEqn.initPondingDepth));
                    }
                }
                RichardsEqn.newBC0 = true;
            } else if (this.name.equals("BoundaryCondAtL")) {
                switch (RichardsEqn.selectedBoundaryCondAtL) {
                    case 0: {
                        int n = DefineBoundaryPanel.this.sbrBoundaryCondAtL.getValue();
                        n = n * 10 - 10000;
                        RichardsEqn.matricPotAtL = n;
                        DefineBoundaryPanel.this.tfBoundaryCondAtL.setText(RichardsEqn.formatLength(RichardsEqn.matricPotAtL));
                        break;
                    }
                    case 1: {
                        int n = DefineBoundaryPanel.this.sbrBoundaryCondAtL.getValue();
                        RichardsEqn.fluxAtL = (double)(n - 250) / 10.0;
                        DefineBoundaryPanel.this.tfBoundaryCondAtL.setText(RichardsEqn.formatVelocity(RichardsEqn.fluxAtL));
                    }
                }
                RichardsEqn.newBCL = true;
            } else if (this.name.equals("BoundaryChemCondAt0")) {
                switch (RichardsEqn.selectedChemBoundaryCond) {
                    case 0: {
                        int n = DefineBoundaryPanel.this.sbrBndChemAt0.getValue();
                        RichardsEqn.matricChemPotAt0 = (double)n / 1000.0;
                        DefineBoundaryPanel.this.tfBndChemAt0.setText(Tools.formatDouble(RichardsEqn.matricChemPotAt0, 3, 3));
                        break;
                    }
                    case 1: {
                        int n = DefineBoundaryPanel.this.sbrBndChemAt0.getValue();
                        RichardsEqn.matricChemSoilPotAt0 = (double)n / 1000.0;
                        DefineBoundaryPanel.this.tfBndChemAt0.setText(Tools.formatDouble(RichardsEqn.matricChemSoilPotAt0, 3, 3));
                    }
                }
                RichardsEqn.newBC0 = true;
            } else if (this.name.equals("BoundaryChemCondAtL")) {
                int n = DefineBoundaryPanel.this.sbrBndChemAtL.getValue();
                RichardsEqn.matricChemPotAtL = (double)n / 1000.0;
                DefineBoundaryPanel.this.tfBndChemAtL.setText(Tools.formatDouble(RichardsEqn.matricChemPotAtL, 3, 3));
                RichardsEqn.newBCL = true;
            } else if (this.name.equals("CriticalPot")) {
                int n = DefineBoundaryPanel.this.sbrCriticalPot.getValue() * 10 - 10000;
                RichardsEqn.criticalPot = n;
                DefineBoundaryPanel.this.tfCriticalPot.setText(RichardsEqn.formatLength(RichardsEqn.criticalPot));
                RichardsEqn.newBC0 = true;
            }
            DefineBoundaryPanel.this.performed();
            if (!DefineBoundaryPanel.this.errorFree) {
                new ErrorMessageDialog("Error", RichardsEqn.errorMessage);
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (this.name.equals("FirstBC")) {
                if (cboxFirstBC.isSelected()) {
                    RichardsEqn.restart = true;
                } else {
                    RichardsEqn.newBC0 = true;
                }
            }
            if (this.name.equals("BoundaryCondAt0")) {
                if (RichardsEqn.selectedBoundaryCond != DefineBoundaryPanel.this.choiceBoundaryCond.getSelectedIndex()) {
                    RichardsEqn.newBC0 = true;
                    RichardsEqn.selectedBoundaryCond = DefineBoundaryPanel.this.choiceBoundaryCond.getSelectedIndex();
                    DefaultBoundedRangeModel defaultBoundedRangeModel = null;
                    int n = 0;
                    switch (RichardsEqn.selectedBoundaryCond) {
                        case 0: 
                        case 1: {
                            DefineBoundaryPanel.this.tfBoundaryCondAt0.setText(RichardsEqn.formatLength(RichardsEqn.matricPotAt0));
                            n = (int)((RichardsEqn.matricPotAt0 + 10000.0) / 10.0 + 0.5);
                            defaultBoundedRangeModel = new DefaultBoundedRangeModel(n, 0, 0, 1010);
                            DefineBoundaryPanel.this.sbrBoundaryCondAt0.setModel(defaultBoundedRangeModel);
                            break;
                        }
                        case 2: {
                            DefineBoundaryPanel.this.tfBoundaryCondAt0.setText(RichardsEqn.formatVelocity(RichardsEqn.fluxAt0));
                            n = (int)(250.0 + 10.0 * RichardsEqn.fluxAt0 + 0.5);
                            defaultBoundedRangeModel = new DefaultBoundedRangeModel(n, 0, 0, 500);
                            DefineBoundaryPanel.this.sbrBoundaryCondAt0.setModel(defaultBoundedRangeModel);
                            break;
                        }
                        case 3: {
                            DefineBoundaryPanel.this.tfBoundaryCondAt0.setText(RichardsEqn.formatVelocity(RichardsEqn.rainfall));
                            n = (int)(10.0 * RichardsEqn.rainfall + 0.5);
                            defaultBoundedRangeModel = new DefaultBoundedRangeModel(n, 0, 0, 250);
                            DefineBoundaryPanel.this.sbrBoundaryCondAt0.setModel(defaultBoundedRangeModel);
                            break;
                        }
                        case 4: {
                            DefineBoundaryPanel.this.tfBoundaryCondAt0.setText(RichardsEqn.formatVelocity(RichardsEqn.mixedFlux));
                            n = (int)(250.0 + 10.0 * RichardsEqn.mixedFlux + 0.5);
                            defaultBoundedRangeModel = new DefaultBoundedRangeModel(n, 0, 0, 500);
                            DefineBoundaryPanel.this.sbrBoundaryCondAt0.setModel(defaultBoundedRangeModel);
                            break;
                        }
                        case 5: {
                            DefineBoundaryPanel.this.tfBoundaryCondAt0.setText(RichardsEqn.formatLength(RichardsEqn.initPondingDepth));
                            n = (int)(RichardsEqn.initPondingDepth * 10.0 + 0.5);
                            defaultBoundedRangeModel = new DefaultBoundedRangeModel(n, 0, 0, 1000);
                            DefineBoundaryPanel.this.sbrBoundaryCondAt0.setModel(defaultBoundedRangeModel);
                        }
                    }
                    if (RichardsEqn.selectedBoundaryCond == 4) {
                        DefineBoundaryPanel.this.lCriticalPot.setText("Critical Matric Potential (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + ")");
                        DefineBoundaryPanel.this.tfCriticalPot.setText(RichardsEqn.formatLength(RichardsEqn.criticalPot));
                        n = (int)((RichardsEqn.criticalPot + 10000.0) / 10.0 + 0.5);
                        defaultBoundedRangeModel = new DefaultBoundedRangeModel(n, 0, 0, 1010);
                        DefineBoundaryPanel.this.sbrCriticalPot.setModel(defaultBoundedRangeModel);
                        DefineBoundaryPanel.this.lCriticalPot.setVisible(true);
                        DefineBoundaryPanel.this.tfCriticalPot.setVisible(true);
                        DefineBoundaryPanel.this.sbrCriticalPot.setVisible(true);
                    } else {
                        DefineBoundaryPanel.this.lCriticalPot.setVisible(false);
                        DefineBoundaryPanel.this.tfCriticalPot.setVisible(false);
                        DefineBoundaryPanel.this.sbrCriticalPot.setVisible(false);
                    }
                }
            } else if (this.name.equals("BoundaryCondAtL")) {
                if (RichardsEqn.selectedBoundaryCondAtL != DefineBoundaryPanel.this.choiceBoundaryCondAtL.getSelectedIndex()) {
                    RichardsEqn.newBCL = true;
                    RichardsEqn.selectedBoundaryCondAtL = DefineBoundaryPanel.this.choiceBoundaryCondAtL.getSelectedIndex();
                    DefaultBoundedRangeModel defaultBoundedRangeModel = null;
                    int n = 0;
                    switch (RichardsEqn.selectedBoundaryCondAtL) {
                        case 0: {
                            DefineBoundaryPanel.this.tfBoundaryCondAtL.setText(RichardsEqn.formatLength(RichardsEqn.matricPotAtL));
                            n = (int)((RichardsEqn.matricPotAtL + 10000.0) / 10.0 + 0.5);
                            defaultBoundedRangeModel = new DefaultBoundedRangeModel(n, 0, 0, 1010);
                            DefineBoundaryPanel.this.sbrBoundaryCondAtL.setModel(defaultBoundedRangeModel);
                            break;
                        }
                        case 1: {
                            DefineBoundaryPanel.this.tfBoundaryCondAtL.setText(RichardsEqn.formatVelocity(RichardsEqn.fluxAtL));
                            n = (int)(250.0 + 10.0 * RichardsEqn.fluxAtL + 0.5);
                            defaultBoundedRangeModel = new DefaultBoundedRangeModel(n, 0, 0, 500);
                            DefineBoundaryPanel.this.sbrBoundaryCondAtL.setModel(defaultBoundedRangeModel);
                        }
                    }
                    DefineBoundaryPanel.this.tfBoundaryCondAtL.setVisible(RichardsEqn.selectedBoundaryCondAtL != 2);
                    DefineBoundaryPanel.this.sbrBoundaryCondAtL.setVisible(RichardsEqn.selectedBoundaryCondAtL != 2);
                }
            } else if (this.name.equals("BoundaryChemCondAt0")) {
                if (RichardsEqn.selectedChemBoundaryCond != DefineBoundaryPanel.this.choiceBndChemAt0.getSelectedIndex()) {
                    RichardsEqn.newBC0 = true;
                    RichardsEqn.selectedChemBoundaryCond = DefineBoundaryPanel.this.choiceBndChemAt0.getSelectedIndex();
                    DefaultBoundedRangeModel defaultBoundedRangeModel = null;
                    int n = 0;
                    switch (RichardsEqn.selectedChemBoundaryCond) {
                        case 0: {
                            DefineBoundaryPanel.this.tfBndChemAt0.setText(Tools.formatDouble(RichardsEqn.matricChemPotAt0, 3, 3));
                            n = (int)(RichardsEqn.matricChemPotAt0 * 1000.0 + 0.5);
                            defaultBoundedRangeModel = new DefaultBoundedRangeModel(n, 0, 0, 1000000);
                            DefineBoundaryPanel.this.sbrBndChemAt0.setModel(defaultBoundedRangeModel);
                            break;
                        }
                        case 1: {
                            DefineBoundaryPanel.this.tfBndChemAt0.setText(Tools.formatDouble(RichardsEqn.matricChemSoilPotAt0, 3, 3));
                            n = (int)(RichardsEqn.matricChemSoilPotAt0 * 1000.0 + 0.5);
                            defaultBoundedRangeModel = new DefaultBoundedRangeModel(n, 0, 0, 1000000);
                            DefineBoundaryPanel.this.sbrBndChemAt0.setModel(defaultBoundedRangeModel);
                        }
                    }
                }
            } else if (this.name.equals("BoundaryChemCondAtL") && RichardsEqn.selectedChemBoundaryCondAtL != DefineBoundaryPanel.this.choiceBndChemAtL.getSelectedIndex()) {
                RichardsEqn.selectedChemBoundaryCondAtL = DefineBoundaryPanel.this.choiceBndChemAtL.getSelectedIndex();
                RichardsEqn.newBCL = true;
                DefaultBoundedRangeModel defaultBoundedRangeModel = null;
                int n = 0;
                if (RichardsEqn.selectedChemBoundaryCondAtL == 0) {
                    DefineBoundaryPanel.this.tfBndChemAtL.setVisible(false);
                    DefineBoundaryPanel.this.sbrBndChemAtL.setVisible(false);
                } else {
                    DefineBoundaryPanel.this.tfBndChemAtL.setVisible(true);
                    DefineBoundaryPanel.this.sbrBndChemAtL.setVisible(true);
                    DefineBoundaryPanel.this.tfBndChemAtL.setText(Tools.formatDouble(RichardsEqn.matricChemPotAtL, 3, 3));
                    n = (int)(RichardsEqn.matricChemPotAtL * 1000.0 + 0.5);
                    defaultBoundedRangeModel = new DefaultBoundedRangeModel(n, 0, 0, 1000000);
                    DefineBoundaryPanel.this.sbrBndChemAtL.setModel(defaultBoundedRangeModel);
                }
            }
            DefineBoundaryPanel.this.performed();
            if (!DefineBoundaryPanel.this.errorFree) {
                new ErrorMessageDialog("Error", RichardsEqn.errorMessage);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.name.equals("BoundaryCondAt0") || this.name.equals("BoundaryCondAtL") || this.name.equals("CriticalPot")) {
                DefineBoundaryPanel.this.performed();
                if (!DefineBoundaryPanel.this.errorFree) {
                    JOptionPane.showMessageDialog(new JPanel(), RichardsEqn.errorMessage, "Error", 0);
                    CHEMFLO.appWin.repaint();
                }
            } else if (this.name.equals("BoundaryChemCondAt0") || this.name.equals("BoundaryChemCondAtL")) {
                DefineBoundaryPanel.this.performed();
                if (!DefineBoundaryPanel.this.errorFree) {
                    JOptionPane.showMessageDialog(new JPanel(), RichardsEqn.errorMessage, "Error", 0);
                    CHEMFLO.appWin.repaint();
                }
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            block3: {
                JTextField jTextField;
                if (!(mouseEvent.getSource() instanceof JTextField) || (jTextField = (JTextField)mouseEvent.getSource()).getText() == null || jTextField.getText().trim().length() == 0) break block3;
                try {
                    Double.parseDouble(jTextField.getText());
                    DefineBoundaryPanel.this.performed();
                    if (!DefineBoundaryPanel.this.errorFree) {
                        JOptionPane.showMessageDialog(new JPanel(), RichardsEqn.errorMessage, "Error", 0);
                        CHEMFLO.appWin.repaint();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    jTextField.grabFocus();
                }
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            DefineBoundaryPanel.this.performed();
        }
    }

    class NorthPanelL
    extends JPanel {
        NorthPanelL() {
            this.setPreferredSize(new Dimension(570, 200));
            this.setLayout(null);
            int n = 0;
            DefineBoundaryPanel.this.lBoundaryCond = new JLabel("Boundary Condition for Water at x = 0 ", 2);
            DefineBoundaryPanel.this.lBoundaryCond.setForeground(Color.black);
            DefineBoundaryPanel.this.lBoundaryCond.setFont(RichardsEqn.labelFont);
            DefineBoundaryPanel.this.lBoundaryCond.setBounds(40, 5, 250, 25);
            DefineBoundaryPanel.this.lBoundaryCond.setPreferredSize(new Dimension(250, 20));
            DefineBoundaryPanel.this.choiceBoundaryCondNames.addElement("Matric Potential (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + ")");
            DefineBoundaryPanel.this.choiceBoundaryCondNames.addElement("Total Potential (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + ")");
            DefineBoundaryPanel.this.choiceBoundaryCondNames.addElement("Flux Density (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ")");
            DefineBoundaryPanel.this.choiceBoundaryCondNames.addElement("Rainfall Rate (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ")");
            DefineBoundaryPanel.this.choiceBoundaryCondNames.addElement("Mixed Type: Flux (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ")");
            DefineBoundaryPanel.this.choiceBoundaryCondNames.addElement("Initial Depth of Ponding (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + ")");
            DefineBoundaryPanel.this.choiceBoundaryCond = new JComboBox(DefineBoundaryPanel.this.choiceBoundaryCondNames);
            DefineBoundaryPanel.this.choiceBoundaryCond.setSelectedIndex(RichardsEqn.selectedBoundaryCond);
            DefineBoundaryPanel.this.choiceBoundaryCond.setForeground(Color.black);
            DefineBoundaryPanel.this.choiceBoundaryCond.setFont(RichardsEqn.comboBoxFont);
            DefineBoundaryPanel.this.choiceBoundaryCond.setBounds(20, 35, 200, 22);
            DefineBoundaryPanel.this.choiceBoundaryCond.setPreferredSize(new Dimension(200, 22));
            DefineBoundaryPanel.this.choiceBoundaryCond.addItemListener(new forEvent("BoundaryCondAt0"));
            DefineBoundaryPanel.this.tfBoundaryCondAt0 = new JTextField(String.valueOf(RichardsEqn.matricPotAt0));
            DefineBoundaryPanel.this.tfBoundaryCondAt0.setBounds(225, 35, 75, 22);
            DefineBoundaryPanel.this.tfBoundaryCondAt0.setPreferredSize(new Dimension(50, 22));
            n = (int)((RichardsEqn.matricPotAt0 + 10000.0) / 10.0 + 0.5);
            DefineBoundaryPanel.this.sbrBoundaryCondAt0 = new JScrollBar(0, n, 0, 0, 1010);
            DefineBoundaryPanel.this.sbrBoundaryCondAt0.setBounds(305, 35, 65, 22);
            DefineBoundaryPanel.this.sbrBoundaryCondAt0.setPreferredSize(new Dimension(60, 22));
            DefineBoundaryPanel.this.sbrBoundaryCondAt0.addAdjustmentListener(new forEvent("BoundaryCondAt0"));
            this.add(DefineBoundaryPanel.this.lBoundaryCond);
            this.add(DefineBoundaryPanel.this.choiceBoundaryCond);
            this.add(DefineBoundaryPanel.this.tfBoundaryCondAt0);
            this.add(DefineBoundaryPanel.this.sbrBoundaryCondAt0);
            DefineBoundaryPanel.this.lBoundaryCondAtL = new JLabel("Boundary Condition for Water at x = " + Tools.formatDouble(RichardsEqn.length, 1, 1) + " " + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit], 2);
            DefineBoundaryPanel.this.lBoundaryCondAtL.setForeground(Color.black);
            DefineBoundaryPanel.this.lBoundaryCondAtL.setFont(RichardsEqn.labelFont);
            DefineBoundaryPanel.this.lBoundaryCondAtL.setBounds(40, 120, 280, 25);
            DefineBoundaryPanel.this.lBoundaryCondAtL.setPreferredSize(new Dimension(270, 20));
            DefineBoundaryPanel.this.choiceBoundaryCondNames2.addElement("Matric Potential (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + ")");
            DefineBoundaryPanel.this.choiceBoundaryCondNames2.addElement("Flux Density (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ")");
            DefineBoundaryPanel.this.choiceBoundaryCondNames2.addElement("Free Drainage");
            DefineBoundaryPanel.this.choiceBoundaryCondAtL = new JComboBox(DefineBoundaryPanel.this.choiceBoundaryCondNames2);
            DefineBoundaryPanel.this.choiceBoundaryCondAtL.setSelectedIndex(RichardsEqn.selectedBoundaryCondAtL);
            DefineBoundaryPanel.this.choiceBoundaryCondAtL.setForeground(Color.black);
            DefineBoundaryPanel.this.choiceBoundaryCondAtL.setFont(RichardsEqn.comboBoxFont);
            DefineBoundaryPanel.this.choiceBoundaryCondAtL.setBounds(20, 150, 200, 22);
            DefineBoundaryPanel.this.choiceBoundaryCondAtL.setPreferredSize(new Dimension(200, 22));
            DefineBoundaryPanel.this.choiceBoundaryCondAtL.addItemListener(new forEvent("BoundaryCondAtL"));
            DefineBoundaryPanel.this.tfBoundaryCondAtL = new JTextField(String.valueOf(RichardsEqn.matricPotAtL));
            DefineBoundaryPanel.this.tfBoundaryCondAtL.setBounds(225, 150, 75, 22);
            DefineBoundaryPanel.this.tfBoundaryCondAtL.setPreferredSize(new Dimension(50, 22));
            n = (int)((RichardsEqn.matricPotAtL + 10000.0) / 10.0 + 0.5);
            DefineBoundaryPanel.this.sbrBoundaryCondAtL = new JScrollBar(0, n, 0, 0, 1010);
            DefineBoundaryPanel.this.sbrBoundaryCondAtL.setBounds(305, 150, 65, 22);
            DefineBoundaryPanel.this.sbrBoundaryCondAtL.setPreferredSize(new Dimension(60, 22));
            DefineBoundaryPanel.this.sbrBoundaryCondAtL.addAdjustmentListener(new forEvent("BoundaryCondAtL"));
            this.add(DefineBoundaryPanel.this.lBoundaryCondAtL);
            this.add(DefineBoundaryPanel.this.choiceBoundaryCondAtL);
            this.add(DefineBoundaryPanel.this.tfBoundaryCondAtL);
            this.add(DefineBoundaryPanel.this.sbrBoundaryCondAtL);
            DefineBoundaryPanel.this.lCriticalPot = new JLabel("Critical Matric Potential (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + ")");
            DefineBoundaryPanel.this.lCriticalPot.setBounds(25, 60, 195, 22);
            DefineBoundaryPanel.this.lCriticalPot.setPreferredSize(new Dimension(200, 22));
            DefineBoundaryPanel.this.lCriticalPot.setForeground(Color.black);
            DefineBoundaryPanel.this.lCriticalPot.setFont(RichardsEqn.labelFont);
            this.add(DefineBoundaryPanel.this.lCriticalPot);
            DefineBoundaryPanel.this.lCriticalPot.setVisible(false);
            DefineBoundaryPanel.this.tfCriticalPot = new JTextField(String.valueOf(RichardsEqn.criticalPot));
            DefineBoundaryPanel.this.tfCriticalPot.setBounds(225, 60, 75, 22);
            DefineBoundaryPanel.this.tfCriticalPot.setPreferredSize(new Dimension(50, 22));
            this.add(DefineBoundaryPanel.this.tfCriticalPot);
            DefineBoundaryPanel.this.tfCriticalPot.setVisible(false);
            n = (int)((RichardsEqn.criticalPot + 10000.0) / 10.0 + 0.5);
            DefineBoundaryPanel.this.sbrCriticalPot = new JScrollBar(0, n, 0, 0, 1010);
            DefineBoundaryPanel.this.sbrCriticalPot.setBounds(305, 60, 65, 22);
            DefineBoundaryPanel.this.sbrCriticalPot.setPreferredSize(new Dimension(60, 22));
            this.add(DefineBoundaryPanel.this.sbrCriticalPot);
            DefineBoundaryPanel.this.sbrCriticalPot.setVisible(false);
            DefineBoundaryPanel.this.sbrCriticalPot.addAdjustmentListener(new forEvent("CriticalPot"));
            DefineBoundaryPanel.this.tfCriticalPot.addActionListener(new forEvent("CriticalPot"));
            DefineBoundaryPanel.this.tfBoundaryCondAt0.addActionListener(new forEvent("BoundaryCondAt0"));
            DefineBoundaryPanel.this.tfBoundaryCondAtL.addActionListener(new forEvent("BoundaryCondAtL"));
            DefineBoundaryPanel.this.tfBoundaryCondAt0.addMouseListener(new forEvent("BoundaryCondAt0"));
            DefineBoundaryPanel.this.tfBoundaryCondAtL.addMouseListener(new forEvent("BoundaryCondAtL"));
            DefineBoundaryPanel.this.tfCriticalPot.addMouseListener(new forEvent("CriticalPot"));
            DefineBoundaryPanel.this.optionPane = new SimulateOptionPanel();
            DefineBoundaryPanel.this.optionPane.setBounds(385, 10, 170, 165);
            DefineBoundaryPanel.this.optionPane.setBorder(new TitledBorder(new EtchedBorder(), "Simulation Options", 2, 0, RichardsEqn.labelFont, Color.black));
            this.add(DefineBoundaryPanel.this.optionPane);
        }
    }

    class BndChemPanel
    extends JPanel {
        BndChemPanel() {
            this.setPreferredSize(new Dimension(500, 250));
            this.setLayout(null);
            DefineBoundaryPanel.this.lBndChemAt0 = new JLabel("Boundary Condition for Chemical at x = 0", 2);
            DefineBoundaryPanel.this.lBndChemAt0.setForeground(Color.black);
            DefineBoundaryPanel.this.lBndChemAt0.setFont(RichardsEqn.labelFont);
            DefineBoundaryPanel.this.lBndChemAt0.setBounds(40, 30, 450, 25);
            DefineBoundaryPanel.this.lBndChemAt0.setPreferredSize(new Dimension(400, 20));
            DefineBoundaryPanel.this.BndChemAt0Names.addElement("Specified Concentration (g/m3 Inflowing Solution)");
            DefineBoundaryPanel.this.BndChemAt0Names.addElement("Specified Concentration (g/m3 Soil Solution)");
            DefineBoundaryPanel.this.choiceBndChemAt0 = new JComboBox(DefineBoundaryPanel.this.BndChemAt0Names);
            DefineBoundaryPanel.this.choiceBndChemAt0.setBounds(20, 60, 350, 22);
            DefineBoundaryPanel.this.choiceBndChemAt0.setForeground(Color.black);
            DefineBoundaryPanel.this.choiceBndChemAt0.setFont(RichardsEqn.comboBoxFont);
            DefineBoundaryPanel.this.choiceBndChemAt0.setPreferredSize(new Dimension(350, 22));
            DefineBoundaryPanel.this.choiceBndChemAt0.setSelectedIndex(RichardsEqn.selectedChemBoundaryCond);
            DefineBoundaryPanel.this.tfBndChemAt0 = new JTextField(Tools.formatDouble(RichardsEqn.matricChemPotAt0, 3, 3));
            DefineBoundaryPanel.this.tfBndChemAt0.setBounds(375, 60, 60, 22);
            DefineBoundaryPanel.this.tfBndChemAt0.setPreferredSize(new Dimension(50, 22));
            int n = (int)(RichardsEqn.matricChemPotAt0 * 1000.0);
            DefineBoundaryPanel.this.sbrBndChemAt0 = new JScrollBar(0, n, 0, 0, 1000000);
            DefineBoundaryPanel.this.sbrBndChemAt0.setBounds(440, 60, 70, 22);
            DefineBoundaryPanel.this.sbrBndChemAt0.setPreferredSize(new Dimension(60, 22));
            this.add(DefineBoundaryPanel.this.lBndChemAt0);
            this.add(DefineBoundaryPanel.this.choiceBndChemAt0);
            this.add(DefineBoundaryPanel.this.tfBndChemAt0);
            this.add(DefineBoundaryPanel.this.sbrBndChemAt0);
            DefineBoundaryPanel.this.lBndChemAtL = new JLabel("Boundary Condition for Chemical at x = " + Tools.formatDouble(RichardsEqn.length, 1, 1) + " " + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit], 2);
            DefineBoundaryPanel.this.lBndChemAtL.setForeground(Color.black);
            DefineBoundaryPanel.this.lBndChemAtL.setFont(RichardsEqn.labelFont);
            DefineBoundaryPanel.this.lBndChemAtL.setBounds(40, 150, 450, 25);
            DefineBoundaryPanel.this.lBndChemAtL.setPreferredSize(new Dimension(400, 20));
            DefineBoundaryPanel.this.BndChemAtLNames.addElement("Convective Flow Only");
            DefineBoundaryPanel.this.BndChemAtLNames.addElement("Specified Concentration (g/m3 Soil Solution)");
            DefineBoundaryPanel.this.choiceBndChemAtL = new JComboBox(DefineBoundaryPanel.this.BndChemAtLNames);
            DefineBoundaryPanel.this.choiceBndChemAtL.setBounds(20, 180, 350, 22);
            DefineBoundaryPanel.this.choiceBndChemAtL.setForeground(Color.black);
            DefineBoundaryPanel.this.choiceBndChemAtL.setFont(RichardsEqn.comboBoxFont);
            DefineBoundaryPanel.this.choiceBndChemAtL.setPreferredSize(new Dimension(350, 22));
            DefineBoundaryPanel.this.choiceBndChemAtL.setSelectedIndex(RichardsEqn.selectedChemBoundaryCondAtL);
            DefineBoundaryPanel.this.tfBndChemAtL = new JTextField(Tools.formatDouble(RichardsEqn.matricChemPotAtL, 3, 3));
            DefineBoundaryPanel.this.tfBndChemAtL.setBounds(375, 180, 60, 22);
            DefineBoundaryPanel.this.tfBndChemAtL.setPreferredSize(new Dimension(50, 22));
            n = (int)(RichardsEqn.matricChemPotAtL * 1000.0);
            DefineBoundaryPanel.this.sbrBndChemAtL = new JScrollBar(0, n, 0, 0, 1000000);
            DefineBoundaryPanel.this.sbrBndChemAtL.setBounds(440, 180, 70, 22);
            DefineBoundaryPanel.this.sbrBndChemAtL.setPreferredSize(new Dimension(60, 22));
            DefineBoundaryPanel.this.tfBndChemAtL.setVisible(false);
            DefineBoundaryPanel.this.sbrBndChemAtL.setVisible(false);
            this.add(DefineBoundaryPanel.this.lBndChemAtL);
            this.add(DefineBoundaryPanel.this.choiceBndChemAtL);
            this.add(DefineBoundaryPanel.this.tfBndChemAtL);
            this.add(DefineBoundaryPanel.this.sbrBndChemAtL);
            DefineBoundaryPanel.this.choiceBndChemAt0.addItemListener(new forEvent("BoundaryChemCondAt0"));
            DefineBoundaryPanel.this.choiceBndChemAtL.addItemListener(new forEvent("BoundaryChemCondAtL"));
            cboxFirstBC.addItemListener(new forEvent("FirstBC"));
            DefineBoundaryPanel.this.sbrBndChemAt0.addAdjustmentListener(new forEvent("BoundaryChemCondAt0"));
            DefineBoundaryPanel.this.sbrBndChemAtL.addAdjustmentListener(new forEvent("BoundaryChemCondAtL"));
            DefineBoundaryPanel.this.tfBndChemAt0.addActionListener(new forEvent("BoundaryChemCondAt0"));
            DefineBoundaryPanel.this.tfBndChemAtL.addActionListener(new forEvent("BoundaryChemCondAtL"));
            DefineBoundaryPanel.this.tfBndChemAt0.addMouseListener(new forEvent("BoundaryChemCondAt0"));
            DefineBoundaryPanel.this.tfBndChemAtL.addMouseListener(new forEvent("BoundaryChemCondAtL"));
        }
    }

    class SimulateOptionPanel
    extends JPanel {
        SimulateOptionPanel() {
            this.setForeground(Color.black);
            this.setPreferredSize(new Dimension(160, 160));
            this.setLayout(null);
            cboxFirstBC.setBounds(10, 30, 150, 35);
            this.add(cboxFirstBC);
            cboxMultpleBC.setBounds(10, 80, 150, 55);
            this.add(cboxMultpleBC);
            DefineBoundaryPanel.this.group.add(cboxFirstBC);
            DefineBoundaryPanel.this.group.add(cboxMultpleBC);
        }
    }
}

