/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;

public class EditSoilFunctionFormPanel
extends JPanel {
    private int xWidth = 595;
    private int yHeight = 810;
    private int maxNumLayers = 5;
    private final String[][] conductivityPara = new String[3][3];
    private final String[][] rententionPara = new String[3][4];
    private JPanel[] line = new JPanel[this.maxNumLayers];
    public Soil newSoil;
    private Soil oldSoil;
    private Horizon[] oldHorizons;
    private Horizon[] horizons;
    private JLabel[] clAlpha = new JLabel[this.maxNumLayers];
    private JLabel[] clK = new JLabel[this.maxNumLayers];
    private JLabel[] clN = new JLabel[this.maxNumLayers];
    private JLabel[] wlAlpha = new JLabel[this.maxNumLayers];
    private JLabel[] wlK = new JLabel[this.maxNumLayers];
    private JLabel[] wlN = new JLabel[this.maxNumLayers];
    private JLabel[] wlTheta = new JLabel[this.maxNumLayers];
    private JComboBox[] conductProperty = new JComboBox[this.maxNumLayers];
    private JComboBox[] waterProperty = new JComboBox[this.maxNumLayers];
    private Rectangle[] rectC = new Rectangle[this.maxNumLayers];
    private Rectangle[] rectW = new Rectangle[this.maxNumLayers];
    private final Vector conductName;
    private final Vector waterName;
    private int[] oldConductIndex = new int[5];
    private int[] oldWaterIndex = new int[5];
    private int[] orignCindex;
    private int[] orignWCindex;
    private int currentHorizon = 0;
    private JTextField[] ctfParam1 = new JTextField[this.maxNumLayers];
    private JTextField[] ctfParam2 = new JTextField[this.maxNumLayers];
    private JTextField[] ctfParam3 = new JTextField[this.maxNumLayers];
    private JTextField[] wtfParam1 = new JTextField[this.maxNumLayers];
    private JTextField[] wtfParam2 = new JTextField[this.maxNumLayers];
    private JTextField[] wtfParam3 = new JTextField[this.maxNumLayers];
    private JTextField[] wtfParam4 = new JTextField[this.maxNumLayers];
    private JTextField[] tfLayer = new JTextField[this.maxNumLayers];
    private JLabel[] layerLabel = new JLabel[this.maxNumLayers];
    private JTextField[] orgCarbon = new JTextField[this.maxNumLayers];
    private JTextField[] bulkDen = new JTextField[this.maxNumLayers];
    private Border oldBorder;
    private BevelBorder raisedEdge = new BevelBorder(0);
    private boolean first = true;
    int[] xParam = new int[]{50, 340, 50, 340};
    int[] yParam = new int[]{335, 335, 347, 347};
    int[] nParameters = new int[]{3, 4, 3, 4};
    public boolean errorFree = true;
    public boolean restart;
    private Color dblue = Color.blue.darker();
    private int maxHeight;
    private int Layer_No;
    public int IconIndex;
    private Conductivity newK;
    private WaterContent newWC;
    private JPanel left;
    private JPanel right;
    private int selectedConductModelIndex = 2;
    private int selectedRententModelIndex = 2;
    private double orgCarb = 0.014;
    private double bulkD = 1.55;
    private double thick = 0.0;
    private final Conductivity[][] defaultConductivity = new Conductivity[5][3];
    private final WaterContent[][] defaultWaterContent = new WaterContent[5][3];
    private boolean[] bulkDensityErrorFree = new boolean[this.maxNumLayers];
    private boolean[] orgCarbonErrorFree = new boolean[this.maxNumLayers];
    private boolean[] thicknessErrorFree = new boolean[this.maxNumLayers];
    private boolean[] satKErrorFree = new boolean[this.maxNumLayers];
    private boolean[] bubblinCoeffCondErrorFree = new boolean[this.maxNumLayers];
    private boolean[] exponentCondErrorFree = new boolean[this.maxNumLayers];
    private boolean[] satWCErrorFree = new boolean[this.maxNumLayers];
    private boolean[] resWCErrorFree = new boolean[this.maxNumLayers];
    private boolean[] bubblinCoeffWCErrorFree = new boolean[this.maxNumLayers];
    private boolean[] exponentWCErrorFree = new boolean[this.maxNumLayers];
    private final String[] layerSuffix = new String[this.maxNumLayers];
    String previousTextField = null;
    String errorTextField = null;

    EditSoilFunctionFormPanel(Soil soil) {
        this.conductName = new Vector(5, 5);
        this.conductName.addElement(new String("Gardner"));
        this.conductName.addElement(new String("Brooks & Corey"));
        this.conductName.addElement(new String("van Genuchten"));
        this.waterName = new Vector(5, 5);
        this.waterName.addElement(new String("Simmons"));
        this.waterName.addElement(new String("Brooks & Corey"));
        this.waterName.addElement(new String("van Genuchten"));
        this.setPreferredSize(new Dimension(this.xWidth, this.yHeight));
        this.setLayout(null);
        this.Layer_No = soil.nHorizons;
        this.restart = false;
        this.oldHorizons = new Horizon[soil.nHorizons];
        this.horizons = new Horizon[soil.nHorizons];
        this.orignCindex = new int[this.Layer_No];
        this.orignWCindex = new int[this.Layer_No];
        int n = 0;
        while (n < soil.nHorizons) {
            this.oldHorizons[n] = soil.horizon[n].duplicate();
            this.horizons[n] = soil.horizon[n].duplicate();
            this.orignCindex[n] = RichardsEqn.selectedConductModelIndex[n];
            this.orignWCindex[n] = RichardsEqn.selectedRententModelIndex[n];
            ++n;
        }
        if (soil.nHorizons > 1) {
            this.oldSoil = new Soil(soil.name, this.oldHorizons);
            this.newSoil = new Soil(soil.name, this.horizons);
        } else {
            this.oldSoil = new Soil(soil.name, this.oldHorizons[0].getLength(), this.oldHorizons[0].getBulkDensity(), this.oldHorizons[0].getOC(), this.oldHorizons[0].wc, this.oldHorizons[0].k);
            this.newSoil = new Soil(soil.name, this.horizons[0].getLength(), this.horizons[0].getBulkDensity(), this.horizons[0].getOC(), this.horizons[0].wc, this.horizons[0].k);
        }
        this.setDefaultParameters();
        char[] cArray = new char[2];
        this.conductivityPara[0][0] = "Ks (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ") = ";
        this.conductivityPara[0][1] = "hc (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + ") = ";
        this.conductivityPara[0][2] = "n = ";
        this.conductivityPara[1][0] = "Ks (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ") = ";
        this.conductivityPara[1][1] = "hb (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + ") = ";
        this.conductivityPara[1][2] = "n = ";
        this.conductivityPara[2][0] = "Ks (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ") = ";
        this.conductivityPara[2][1] = "\u03b1 (1/" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + ") = ";
        this.conductivityPara[2][2] = "n = ";
        cArray[0] = 952;
        cArray[1] = 115;
        String string = new String(cArray);
        this.rententionPara[0][0] = string + " (v/v) = ";
        this.rententionPara[0][1] = "\u03b8r (v/v)= ";
        this.rententionPara[0][2] = "\u03b1 (1/" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + ") = ";
        this.rententionPara[0][3] = "n = ";
        this.rententionPara[1][0] = "\u03b8s (v/v) = ";
        this.rententionPara[1][1] = "\u03b8r (v/v) = ";
        this.rententionPara[1][2] = "hb (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + ") = ";
        this.rententionPara[1][3] = "\u03bb = ";
        this.rententionPara[2][0] = "\u03b8s (v/v) = ";
        this.rententionPara[2][1] = "\u03b8r (v/v) = ";
        this.rententionPara[2][2] = "\u03b1 (1/" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + ") = ";
        this.rententionPara[2][3] = "n = ";
        int n2 = 0;
        while (n2 < this.maxNumLayers) {
            this.conductProperty[n2] = new JComboBox(this.conductName);
            this.waterProperty[n2] = new JComboBox(this.waterName);
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.newSoil.nHorizons) {
            this.ctfParam1[n3] = new JTextField(Double.toString(this.newSoil.horizon[n3].k.getParamValue(3)));
            this.ctfParam2[n3] = new JTextField(Double.toString(this.newSoil.horizon[n3].k.getParamValue(1)));
            this.ctfParam3[n3] = new JTextField(Double.toString(this.newSoil.horizon[n3].k.getParamValue(2)));
            this.wtfParam1[n3] = new JTextField(Double.toString(this.newSoil.horizon[n3].wc.getParamValue(3)));
            this.wtfParam2[n3] = new JTextField(Double.toString(this.newSoil.horizon[n3].wc.getParamValue(4)));
            this.wtfParam3[n3] = new JTextField(Double.toString(this.newSoil.horizon[n3].wc.getParamValue(1)));
            this.wtfParam4[n3] = new JTextField(Double.toString(this.newSoil.horizon[n3].wc.getParamValue(2)));
            this.orgCarbon[n3] = new JTextField(String.valueOf(this.newSoil.horizon[n3].getOC()));
            this.bulkDen[n3] = new JTextField(String.valueOf(this.newSoil.horizon[n3].getBulkDensity()));
            this.tfLayer[n3] = new JTextField("" + RichardsEqn.formatLength(this.newSoil.horizon[n3].getLength()));
            this.conductProperty[n3].setSelectedIndex(RichardsEqn.selectedConductModelIndex[n3]);
            this.waterProperty[n3].setSelectedIndex(RichardsEqn.selectedRententModelIndex[n3]);
            ++n3;
        }
        int n4 = this.newSoil.nHorizons;
        while (n4 < this.maxNumLayers) {
            this.ctfParam1[n4] = new JTextField(Double.toString(this.defaultConductivity[n4][2].getParamValue(3)));
            this.ctfParam2[n4] = new JTextField(Double.toString(this.defaultConductivity[n4][2].getParamValue(1)));
            this.ctfParam3[n4] = new JTextField(Double.toString(this.defaultConductivity[n4][2].getParamValue(2)));
            this.wtfParam1[n4] = new JTextField(Double.toString(this.defaultWaterContent[n4][2].getParamValue(3)));
            this.wtfParam2[n4] = new JTextField(Double.toString(this.defaultWaterContent[n4][2].getParamValue(4)));
            this.wtfParam3[n4] = new JTextField(Double.toString(this.defaultWaterContent[n4][2].getParamValue(1)));
            this.wtfParam4[n4] = new JTextField(Double.toString(this.defaultWaterContent[n4][2].getParamValue(2)));
            this.orgCarbon[n4] = new JTextField("0.014");
            this.bulkDen[n4] = new JTextField("1.55");
            this.tfLayer[n4] = new JTextField("0.0");
            RichardsEqn.selectedConductModelIndex[n4] = 2;
            this.conductProperty[n4].setSelectedIndex(RichardsEqn.selectedConductModelIndex[n4]);
            RichardsEqn.selectedRententModelIndex[n4] = 2;
            this.waterProperty[n4].setSelectedIndex(RichardsEqn.selectedRententModelIndex[n4]);
            ++n4;
        }
        int n5 = 0;
        while (n5 < this.maxNumLayers) {
            this.bulkDensityErrorFree[n5] = true;
            this.orgCarbonErrorFree[n5] = true;
            this.thicknessErrorFree[n5] = true;
            this.satKErrorFree[n5] = true;
            this.bubblinCoeffCondErrorFree[n5] = true;
            this.exponentCondErrorFree[n5] = true;
            this.satWCErrorFree[n5] = true;
            this.resWCErrorFree[n5] = true;
            this.bubblinCoeffWCErrorFree[n5] = true;
            this.exponentWCErrorFree[n5] = true;
            ++n5;
        }
        this.maxHeight = 0;
        int n6 = 0;
        while (n6 < this.maxNumLayers) {
            this.addSoilEditingGUIForALayer(n6 + 1);
            ++n6;
        }
        this.left = new JPanel();
        this.left.setPreferredSize(new Dimension(5, this.maxHeight + 5));
        this.left.setLayout(new BorderLayout());
        this.left.setBounds(20, 0, 5, this.maxHeight + 5);
        this.right = new JPanel();
        this.right.setPreferredSize(new Dimension(5, this.maxHeight + 5));
        this.right.setLayout(new BorderLayout());
        this.right.setBounds(this.xWidth + 5, 0, 5, this.maxHeight + 5);
        int n7 = 0;
        while (n7 < this.maxNumLayers) {
            this.addComponentForALayer(n7 + 1);
            ++n7;
        }
        this.add(this.left);
        this.add(this.right);
        this.layerSuffix[0] = "I";
        this.layerSuffix[1] = "II";
        this.layerSuffix[2] = "III";
        this.layerSuffix[3] = "IV";
        this.layerSuffix[4] = "V";
        int n8 = 0;
        while (n8 < this.maxNumLayers) {
            this.conductProperty[n8].addItemListener(new forEvent("Conduct" + this.layerSuffix[n8]));
            this.waterProperty[n8].addItemListener(new forEvent("Water" + this.layerSuffix[n8]));
            this.ctfParam1[n8].addActionListener(new forEvent("ConductK" + this.layerSuffix[n8]));
            this.ctfParam2[n8].addActionListener(new forEvent("ConductAlpha" + this.layerSuffix[n8]));
            this.ctfParam3[n8].addActionListener(new forEvent("ConductN" + this.layerSuffix[n8]));
            this.wtfParam1[n8].addActionListener(new forEvent("SatWater" + this.layerSuffix[n8]));
            this.wtfParam2[n8].addActionListener(new forEvent("ResWater" + this.layerSuffix[n8]));
            this.wtfParam3[n8].addActionListener(new forEvent("WaterAlpha" + this.layerSuffix[n8]));
            this.wtfParam4[n8].addActionListener(new forEvent("WaterN" + this.layerSuffix[n8]));
            this.orgCarbon[n8].addActionListener(new forEvent("OrgCarbon" + this.layerSuffix[n8]));
            this.bulkDen[n8].addActionListener(new forEvent("Bulk" + this.layerSuffix[n8]));
            this.tfLayer[n8].addActionListener(new forEvent("Layer" + this.layerSuffix[n8]));
            this.ctfParam1[n8].addMouseListener(new forEvent("ConductK" + this.layerSuffix[n8]));
            this.ctfParam2[n8].addMouseListener(new forEvent("ConductAlpha" + this.layerSuffix[n8]));
            this.ctfParam3[n8].addMouseListener(new forEvent("ConductN" + this.layerSuffix[n8]));
            this.wtfParam1[n8].addMouseListener(new forEvent("SatWater" + this.layerSuffix[n8]));
            this.wtfParam2[n8].addMouseListener(new forEvent("ResWater" + this.layerSuffix[n8]));
            this.wtfParam3[n8].addMouseListener(new forEvent("WaterAlpha" + this.layerSuffix[n8]));
            this.wtfParam4[n8].addMouseListener(new forEvent("WaterN" + this.layerSuffix[n8]));
            this.orgCarbon[n8].addMouseListener(new forEvent("OrgCarbon" + this.layerSuffix[n8]));
            this.bulkDen[n8].addMouseListener(new forEvent("Bulk" + this.layerSuffix[n8]));
            this.tfLayer[n8].addMouseListener(new forEvent("Layer" + this.layerSuffix[n8]));
            ++n8;
        }
        this.addMouseListener(new MouseClickListener());
        this.displayEditedSoilLayer(this.Layer_No, false);
    }

    private void setDefaultParameters() {
        int n;
        int n2;
        int n3 = 0;
        while (n3 < RichardsEqn.editingSoil.nHorizons) {
            n2 = RichardsEqn.getConductivityModelIndex(RichardsEqn.getConductivityModel(RichardsEqn.editingSoil.horizon[n3].k));
            n = RichardsEqn.getWaterContentModelIndex(RichardsEqn.getWaterContentModel(RichardsEqn.editingSoil.horizon[n3].wc));
            this.defaultConductivity[n3][0] = new GardnerConductivity(2.0, -29.6, 3.0, null);
            this.defaultConductivity[n3][1] = new BrooksConductivity(2.0, -22.6, 3.25, null);
            this.defaultConductivity[n3][2] = new VanGenuchtenConductivity(2.0, 0.015, 1.875, null);
            this.defaultConductivity[n3][n2] = this.newSoil.horizon[n3].k;
            this.defaultWaterContent[n3][0] = new SimmonsWaterContent(0.43, 0.08, 1.2, 0.06, null);
            this.defaultWaterContent[n3][1] = new BrooksWaterContent(0.43, 0.08, -22.6, 0.53, null);
            this.defaultWaterContent[n3][2] = new VanGenuchtenWaterContent(0.43, 0.08, 0.015, 1.875, null);
            this.defaultWaterContent[n3][n] = this.newSoil.horizon[n3].wc;
            ++n3;
        }
        if (RichardsEqn.editingSoil.nHorizons < 5) {
            n2 = 5 - RichardsEqn.editingSoil.nHorizons;
            n = RichardsEqn.editingSoil.nHorizons;
            int n4 = 0;
            while (n4 < n2) {
                this.defaultConductivity[n + n4][0] = new GardnerConductivity(2.0, -29.6, 3.0, null);
                this.defaultConductivity[n + n4][1] = new BrooksConductivity(2.0, -22.6, 3.25, null);
                this.defaultConductivity[n + n4][2] = new VanGenuchtenConductivity(2.0, 0.015, 1.875, null);
                this.defaultWaterContent[n + n4][0] = new SimmonsWaterContent(0.43, 0.08, 1.2, 0.06, null);
                this.defaultWaterContent[n + n4][1] = new BrooksWaterContent(0.43, 0.08, -22.6, 0.53, null);
                this.defaultWaterContent[n + n4][2] = new VanGenuchtenWaterContent(0.43, 0.08, 0.015, 1.875, null);
                ++n4;
            }
        }
    }

    private void addSoilEditingGUIForALayer(int n) {
        int n2 = n - 1;
        this.maxHeight += 10;
        this.layerLabel[n2] = new JLabel(Integer.toString(n));
        this.layerLabel[n2].setForeground(Color.black);
        this.layerLabel[n2].setFont(RichardsEqn.equationFont);
        this.layerLabel[n2].setBounds(30, this.maxHeight, 60, 22);
        this.tfLayer[n2].setBounds(80, this.maxHeight, 50, 22);
        this.conductProperty[n2].setFont(RichardsEqn.equationFont);
        this.conductProperty[n2].setBounds(160, this.maxHeight, 135, 22);
        this.rectC[n2] = new Rectangle(155, this.maxHeight - 3, 140, 26);
        this.waterProperty[n2].setForeground(Color.black);
        this.waterProperty[n2].setBounds(315, this.maxHeight, 135, 22);
        this.rectW[n2] = new Rectangle(310, this.maxHeight - 3, 140, 26);
        this.orgCarbon[n2].setForeground(Color.black);
        this.orgCarbon[n2].setFont(RichardsEqn.equationFont);
        this.orgCarbon[n2].setBounds(480, this.maxHeight, 45, 22);
        this.bulkDen[n2].setForeground(Color.black);
        this.bulkDen[n2].setFont(RichardsEqn.equationFont);
        this.bulkDen[n2].setBounds(550, this.maxHeight, 45, 22);
        this.maxHeight += 30;
        this.clK[n2] = new JLabel(this.conductivityPara[RichardsEqn.selectedConductModelIndex[n2]][0]);
        this.clK[n2].setForeground(Color.black);
        this.clK[n2].setFont(RichardsEqn.equationFont);
        this.clK[n2].setBounds(160, this.maxHeight, 75, 22);
        this.ctfParam1[n2].setFont(RichardsEqn.equationFont);
        this.ctfParam1[n2].setBounds(240, this.maxHeight, 55, 22);
        this.wlK[n2] = new JLabel(this.rententionPara[RichardsEqn.selectedRententModelIndex[n2]][0]);
        this.wlK[n2].setForeground(Color.black);
        this.wlK[n2].setFont(RichardsEqn.equationFont);
        this.wlK[n2].setBounds(315, this.maxHeight, 100, 22);
        this.wtfParam1[n2].setFont(RichardsEqn.equationFont);
        this.wtfParam1[n2].setBounds(400, this.maxHeight, 50, 22);
        this.maxHeight += 30;
        this.clAlpha[n2] = new JLabel(this.conductivityPara[RichardsEqn.selectedConductModelIndex[n2]][1]);
        this.clAlpha[n2].setForeground(Color.black);
        this.clAlpha[n2].setFont(RichardsEqn.equationFont);
        this.clAlpha[n2].setBounds(160, this.maxHeight, 75, 22);
        this.ctfParam2[n2].setFont(RichardsEqn.equationFont);
        this.ctfParam2[n2].setBounds(240, this.maxHeight, 55, 22);
        this.wlTheta[n2] = new JLabel(this.rententionPara[RichardsEqn.selectedRententModelIndex[n2]][1]);
        this.wlTheta[n2].setForeground(Color.black);
        this.wlTheta[n2].setFont(RichardsEqn.equationFont);
        this.wlTheta[n2].setBounds(315, this.maxHeight, 100, 22);
        this.wtfParam2[n2].setFont(RichardsEqn.equationFont);
        this.wtfParam2[n2].setBounds(400, this.maxHeight, 50, 22);
        this.maxHeight += 30;
        this.clN[n2] = new JLabel(this.conductivityPara[RichardsEqn.selectedConductModelIndex[n2]][2]);
        this.clN[n2].setForeground(Color.black);
        this.clN[n2].setFont(RichardsEqn.equationFont);
        this.clN[n2].setBounds(160, this.maxHeight, 75, 22);
        this.ctfParam3[n2].setFont(RichardsEqn.equationFont);
        this.ctfParam3[n2].setBounds(240, this.maxHeight, 55, 22);
        this.wlAlpha[n2] = new JLabel(this.rententionPara[RichardsEqn.selectedRententModelIndex[n2]][2]);
        this.wlAlpha[n2].setForeground(Color.black);
        this.wlAlpha[n2].setFont(RichardsEqn.equationFont);
        this.wlAlpha[n2].setBounds(315, this.maxHeight, 100, 22);
        this.wtfParam3[n2].setFont(RichardsEqn.equationFont);
        this.wtfParam3[n2].setBounds(400, this.maxHeight, 50, 22);
        this.maxHeight += 30;
        this.wlN[n2] = new JLabel(this.rententionPara[RichardsEqn.selectedRententModelIndex[n2]][3]);
        this.wlN[n2].setForeground(Color.black);
        this.wlN[n2].setFont(RichardsEqn.equationFont);
        this.wlN[n2].setBounds(315, this.maxHeight, 100, 22);
        this.wtfParam4[n2].setFont(RichardsEqn.equationFont);
        this.wtfParam4[n2].setBounds(400, this.maxHeight, 50, 22);
        this.maxHeight += 30;
        this.line[n2] = new JPanel();
        this.line[n2].setPreferredSize(new Dimension(this.xWidth, 6));
        this.line[n2].setLayout(new BorderLayout());
        this.line[n2].add((Component)new JPanel(){

            protected void paintComponent(Graphics graphics) {
                graphics.setColor(EditSoilFunctionFormPanel.this.dblue);
                graphics.drawLine(0, 4, EditSoilFunctionFormPanel.this.xWidth, 4);
                graphics.drawLine(0, 5, EditSoilFunctionFormPanel.this.xWidth, 5);
            }
        }, "Center");
        this.line[n2].setBounds(25, this.maxHeight - 5, this.xWidth - 20, 6);
    }

    private void addComponentForALayer(int n) {
        int n2 = n - 1;
        this.add(this.layerLabel[n2]);
        this.add(this.tfLayer[n2]);
        this.add(this.conductProperty[n2]);
        this.add(this.waterProperty[n2]);
        this.add(this.orgCarbon[n2]);
        this.add(this.bulkDen[n2]);
        this.add(this.clK[n2]);
        this.add(this.ctfParam1[n2]);
        this.add(this.wlK[n2]);
        this.add(this.wtfParam1[n2]);
        this.add(this.clAlpha[n2]);
        this.add(this.ctfParam2[n2]);
        this.add(this.wlTheta[n2]);
        this.add(this.wtfParam2[n2]);
        this.add(this.clN[n2]);
        this.add(this.ctfParam3[n2]);
        this.add(this.wlAlpha[n2]);
        this.add(this.wtfParam3[n2]);
        this.add(this.wlN[n2]);
        this.add(this.wtfParam4[n2]);
        this.add(this.line[n2]);
    }

    void displayEditedSoilLayer(int n, boolean bl) {
        int n2;
        if (!bl) {
            n2 = 0;
            while (n2 < n) {
                this.tfLayer[n2].setText("" + RichardsEqn.formatLength(this.newSoil.horizon[n2].getLength()));
                ++n2;
            }
        }
        n2 = n - 1;
        while (n2 < n) {
            this.conductProperty[n2].setVisible(true);
            this.waterProperty[n2].setVisible(true);
            this.layerLabel[n2].setVisible(true);
            this.tfLayer[n2].setVisible(true);
            this.orgCarbon[n2].setVisible(true);
            this.bulkDen[n2].setVisible(true);
            this.conductProperty[n2].setEnabled(true);
            this.waterProperty[n2].setEnabled(true);
            this.orgCarbon[n2].setEnabled(true);
            this.bulkDen[n2].setEnabled(true);
            this.clK[n2].setVisible(true);
            this.ctfParam1[n2].setVisible(true);
            this.wlK[n2].setVisible(true);
            this.wtfParam1[n2].setVisible(true);
            this.clAlpha[n2].setVisible(true);
            this.ctfParam2[n2].setVisible(true);
            this.wlTheta[n2].setVisible(true);
            this.wtfParam2[n2].setVisible(true);
            this.clN[n2].setVisible(true);
            this.ctfParam3[n2].setVisible(true);
            this.wlAlpha[n2].setVisible(true);
            this.wtfParam3[n2].setVisible(true);
            this.wlN[n2].setVisible(true);
            this.wtfParam4[n2].setVisible(true);
            this.line[n2].setVisible(true);
            ++n2;
        }
        if (n < this.maxNumLayers) {
            int n3 = n;
            while (n3 < this.maxNumLayers) {
                this.conductProperty[n3].setVisible(false);
                this.waterProperty[n3].setVisible(false);
                this.layerLabel[n3].setVisible(false);
                this.tfLayer[n3].setVisible(false);
                this.orgCarbon[n3].setVisible(false);
                this.bulkDen[n3].setVisible(false);
                this.clK[n3].setVisible(false);
                this.ctfParam1[n3].setVisible(false);
                this.wlK[n3].setVisible(false);
                this.wtfParam1[n3].setVisible(false);
                this.clAlpha[n3].setVisible(false);
                this.ctfParam2[n3].setVisible(false);
                this.wlTheta[n3].setVisible(false);
                this.wtfParam2[n3].setVisible(false);
                this.clN[n3].setVisible(false);
                this.ctfParam3[n3].setVisible(false);
                this.wlAlpha[n3].setVisible(false);
                this.wtfParam3[n3].setVisible(false);
                this.wlN[n3].setVisible(false);
                this.wtfParam4[n3].setVisible(false);
                this.line[n3].setVisible(false);
                ++n3;
            }
            this.conductProperty[n].setVisible(true);
            this.waterProperty[n].setVisible(true);
            this.layerLabel[n].setVisible(true);
            this.tfLayer[n].setVisible(true);
            this.orgCarbon[n].setVisible(true);
            this.bulkDen[n].setVisible(true);
            this.line[n].setVisible(true);
            this.conductProperty[n].setEnabled(false);
            this.waterProperty[n].setEnabled(false);
            this.orgCarbon[n].setEnabled(false);
            this.bulkDen[n].setEnabled(false);
        }
        if (this.left.getComponentCount() != 0) {
            this.left.removeAll();
        }
        if (this.right.getComponentCount() != 0) {
            this.right.removeAll();
        }
        if (RichardsEqn.semiInfiniteSelected) {
            this.layerLabel[0].setVisible(false);
            this.conductProperty[1].setVisible(false);
            this.waterProperty[1].setVisible(false);
            this.layerLabel[1].setVisible(false);
            this.tfLayer[1].setVisible(false);
            this.orgCarbon[1].setVisible(false);
            this.bulkDen[1].setVisible(false);
            this.line[1].setVisible(false);
        }
        final int n4 = Math.min(321 + (n - 1) * 160, 801);
        if (RichardsEqn.semiInfiniteSelected) {
            this.left.add((Component)new JPanel(){

                protected void paintComponent(Graphics graphics) {
                    graphics.setColor(EditSoilFunctionFormPanel.this.dblue);
                    graphics.drawLine(4, 0, 4, 160);
                    graphics.drawLine(3, 0, 3, 160);
                }
            }, "Center");
            this.right.add((Component)new JPanel(){

                protected void paintComponent(Graphics graphics) {
                    graphics.setColor(EditSoilFunctionFormPanel.this.dblue);
                    graphics.drawLine(0, 0, 0, 160);
                    graphics.drawLine(1, 0, 1, 160);
                }
            }, "Center");
        } else {
            this.left.add((Component)new JPanel(){

                protected void paintComponent(Graphics graphics) {
                    graphics.setColor(EditSoilFunctionFormPanel.this.dblue);
                    graphics.drawLine(4, 0, 4, n4);
                    graphics.drawLine(3, 0, 3, n4);
                }
            }, "Center");
            this.right.add((Component)new JPanel(){

                protected void paintComponent(Graphics graphics) {
                    graphics.setColor(EditSoilFunctionFormPanel.this.dblue);
                    graphics.drawLine(0, 0, 0, n4);
                    graphics.drawLine(1, 0, 1, n4);
                }
            }, "Center");
        }
    }

    void setNewSoilLayer(int n) {
        this.horizons = new Horizon[n];
        int n2 = 0;
        while (n2 < n - 1) {
            this.horizons[n2] = this.newSoil.horizon[n2].duplicate();
            ++n2;
        }
        double d = this.horizons[n - 2].depthBottom;
        double d2 = d + 0.0;
        this.horizons[n - 1] = new Horizon(d, d2, 1.55, 0.014, this.defaultWaterContent[n - 1][2], this.defaultConductivity[n - 1][2]);
        this.newSoil = new Soil(this.newSoil.name, this.horizons);
    }

    void removeSoilLayer(int n) {
        double d = 0.0;
        double d2 = 0.0;
        this.horizons = new Horizon[this.newSoil.nHorizons - 1];
        int n2 = 0;
        while (n2 < n) {
            this.horizons[n2] = this.newSoil.horizon[n2].duplicate();
            ++n2;
        }
        int n3 = n;
        while (n3 < this.newSoil.nHorizons - 1) {
            this.horizons[n3] = this.newSoil.horizon[n3 + 1].duplicate();
            d = n > 0 ? this.horizons[n3 - 1].depthBottom : 0.0;
            d2 = d + this.horizons[n3].getLength();
            this.horizons[n3].setLength(d, d2);
            ++n3;
        }
        this.newSoil = new Soil(this.newSoil.name, this.horizons);
    }

    void processingTextFieldEvents(String string) {
        if (string.equals("LayerI")) {
            this.checkValidSoilThickness(1);
        } else {
            int n = 1;
            while (n < this.maxNumLayers) {
                if (string.equals("Layer" + this.layerSuffix[n])) {
                    if (this.Layer_No == n) {
                        this.Layer_No = n + 1;
                        this.setNewSoilLayer(this.Layer_No);
                        this.displayEditedSoilLayer(this.Layer_No, true);
                        this.checkValidSoilThickness(this.Layer_No);
                        break;
                    }
                    this.checkValidSoilThickness(n + 1);
                    break;
                }
                ++n;
            }
            int n2 = 0;
            while (n2 < this.maxNumLayers) {
                if (string.equals("Bulk" + this.layerSuffix[n2])) {
                    this.checkValidBulkDen(n2 + 1);
                    break;
                }
                if (string.equals("OrgCarbon" + this.layerSuffix[n2])) {
                    this.checkValidOrgCarbon(n2 + 1);
                    break;
                }
                if (string.equals("ConductK" + this.layerSuffix[n2])) {
                    this.checkValidSatK(n2 + 1);
                    break;
                }
                if (string.equals("ConductAlpha" + this.layerSuffix[n2])) {
                    this.checkValidBubblingCoeffInConductivity(n2 + 1);
                    break;
                }
                if (string.equals("ConductN" + this.layerSuffix[n2])) {
                    this.checkValidExponentInConductivity(n2 + 1);
                    break;
                }
                if (string.equals("SatWater" + this.layerSuffix[n2])) {
                    this.checkValidSatWC(n2 + 1);
                    break;
                }
                if (string.equals("ResWater" + this.layerSuffix[n2])) {
                    this.checkValidResWC(n2 + 1);
                    break;
                }
                if (string.equals("WaterAlpha" + this.layerSuffix[n2])) {
                    this.checkValidBubblingCoeffInWC(n2 + 1);
                    break;
                }
                if (string.equals("WaterN" + this.layerSuffix[n2])) {
                    this.checkValidExponentInWC(n2 + 1);
                    break;
                }
                ++n2;
            }
        }
    }

    public void performed() {
        this.errorFree = true;
        int n = 1;
        while (n <= this.Layer_No) {
            if (!this.satKErrorFree[n - 1]) {
                this.checkValidSatK(n);
            }
            if (!this.exponentCondErrorFree[n - 1]) {
                this.checkValidExponentInConductivity(n);
            }
            if (!this.bubblinCoeffCondErrorFree[n - 1]) {
                this.checkValidBubblingCoeffInConductivity(n);
            }
            if (!this.satWCErrorFree[n - 1]) {
                this.checkValidSatWC(n);
            }
            if (!this.resWCErrorFree[n - 1]) {
                this.checkValidResWC(n);
            }
            if (!this.exponentWCErrorFree[n - 1]) {
                this.checkValidExponentInWC(n);
            }
            if (!this.bubblinCoeffWCErrorFree[n - 1]) {
                this.checkValidBubblingCoeffInWC(n);
            }
            if (!this.bulkDensityErrorFree[n - 1]) {
                this.checkValidBulkDen(n);
            }
            if (!this.orgCarbonErrorFree[n - 1]) {
                this.checkValidOrgCarbon(n);
            }
            if (!this.thicknessErrorFree[n - 1]) {
                this.checkValidSoilThickness(n);
            }
            if (!this.errorFree) break;
            ++n;
        }
    }

    private void checkValidResWC(int n) {
        int n2 = n - 1;
        double d = 0.0;
        double d2 = this.newSoil.horizon[n2].wc.getSatWC() - Double.MIN_VALUE;
        double d3 = this.newSoil.horizon[n2].wc.getLowerLimit(4);
        double d4 = this.newSoil.horizon[n2].wc.getUpperLimit(4);
        String string = "Layer " + Integer.toString(n) + ": " + this.newSoil.horizon[n2].wc.getName(4) + " should be greater than or equal to 0 and less than saturated water content.";
        String string2 = "Layer " + Integer.toString(n) + ": " + this.newSoil.horizon[n2].wc.getErrorMessage(4);
        this.resWCErrorFree[n2] = Tools.getErrorAndWarning(this.wtfParam2[n2], d, d2, d3, d4, string, string2);
        if (this.resWCErrorFree[n2]) {
            this.errorTextField = null;
            this.newSoil.horizon[n2].wc.setParamValue(4, Double.parseDouble(this.wtfParam2[n2].getText()));
        } else {
            this.errorFree = false;
            this.errorTextField = "ResWater" + this.layerSuffix[n2];
        }
    }

    private void checkValidSatWC(int n) {
        int n2 = n - 1;
        double d = this.newSoil.horizon[n2].wc.getResidualWC() + Double.MIN_VALUE;
        double d2 = 1.0;
        double d3 = this.newSoil.horizon[n2].wc.getLowerLimit(3);
        double d4 = this.newSoil.horizon[n2].wc.getUpperLimit(3);
        String string = "Layer " + Integer.toString(n) + ": " + this.newSoil.horizon[n2].wc.getName(3) + " should be greater than the residual water content and less than 1.";
        String string2 = "Layer " + Integer.toString(n) + ": " + this.newSoil.horizon[n2].wc.getErrorMessage(3);
        this.satWCErrorFree[n2] = Tools.getErrorAndWarning(this.wtfParam1[n2], d, d2, d3, d4, string, string2);
        if (this.satWCErrorFree[n2]) {
            this.errorTextField = null;
            this.newSoil.horizon[n2].wc.setParamValue(3, Double.parseDouble(this.wtfParam1[n2].getText()));
        } else {
            this.errorFree = false;
            this.errorTextField = "SatWater" + this.layerSuffix[n2];
        }
    }

    private void checkValidExponentInWC(int n) {
        int n2 = n - 1;
        double d = Double.MIN_VALUE;
        double d2 = Double.MAX_VALUE;
        double d3 = this.newSoil.horizon[n2].wc.getLowerLimit(2);
        double d4 = this.newSoil.horizon[n2].wc.getUpperLimit(2);
        String string = "greater than 0.";
        if (this.newSoil.horizon[n2].wc instanceof BrooksWaterContent) {
            d = Double.MIN_VALUE;
            d2 = Double.MAX_VALUE;
            string = "greater than 0.";
        } else if (this.newSoil.horizon[n2].wc instanceof SimmonsWaterContent) {
            d = Double.MIN_VALUE;
            d2 = Double.MAX_VALUE;
            string = "greater than 0.";
        } else if (this.newSoil.horizon[n2].wc instanceof VanGenuchtenWaterContent) {
            d = 1.0;
            d2 = Double.MAX_VALUE;
            string = "greater than 1.";
        }
        String string2 = "Layer " + Integer.toString(n) + ": " + this.newSoil.horizon[n2].wc.getName(2) + " should be " + string;
        String string3 = "Layer " + Integer.toString(n) + ": " + this.newSoil.horizon[n2].wc.getErrorMessage(2);
        this.exponentWCErrorFree[n2] = Tools.getErrorAndWarning(this.wtfParam4[n2], d, d2, d3, d4, string2, string3);
        if (this.exponentWCErrorFree[n2]) {
            this.errorTextField = null;
            this.newSoil.horizon[n2].wc.setParamValue(2, Double.parseDouble(this.wtfParam4[n2].getText()));
        } else {
            this.errorFree = false;
            this.errorTextField = "WaterN" + this.layerSuffix[n2];
        }
    }

    private void checkValidBubblingCoeffInWC(int n) {
        int n2 = n - 1;
        double d = Double.MIN_VALUE;
        double d2 = Double.MAX_VALUE;
        double d3 = this.newSoil.horizon[n2].wc.getLowerLimit(1);
        double d4 = this.newSoil.horizon[n2].wc.getUpperLimit(1);
        String string = "greater than 0.";
        if (this.newSoil.horizon[n2].wc instanceof BrooksWaterContent) {
            d = -1.7976931348623157E308;
            d2 = -4.9E-324;
            string = "less than 0.";
        } else if (this.newSoil.horizon[n2].wc instanceof SimmonsWaterContent) {
            d = Double.MIN_VALUE;
            d2 = Double.MAX_VALUE;
            string = "greater than 0.";
        } else if (this.newSoil.horizon[n2].wc instanceof VanGenuchtenWaterContent) {
            d = Double.MIN_VALUE;
            d2 = Double.MAX_VALUE;
            string = "greater than 0.";
        }
        String string2 = "Layer " + Integer.toString(n) + ": " + this.newSoil.horizon[n2].wc.getName(1) + " should be " + string;
        String string3 = "Layer " + Integer.toString(n) + ": " + this.newSoil.horizon[n2].wc.getErrorMessage(1);
        this.bubblinCoeffWCErrorFree[n2] = Tools.getErrorAndWarning(this.wtfParam3[n2], d, d2, d3, d4, string2, string3);
        if (this.bubblinCoeffWCErrorFree[n2]) {
            this.errorTextField = null;
            this.newSoil.horizon[n2].wc.setParamValue(1, Double.parseDouble(this.wtfParam3[n2].getText()));
        } else {
            this.errorFree = false;
            this.errorTextField = "WaterAlpha" + this.layerSuffix[n2];
        }
    }

    private void checkValidExponentInConductivity(int n) {
        int n2 = n - 1;
        double d = Double.MIN_VALUE;
        double d2 = Double.MAX_VALUE;
        double d3 = this.newSoil.horizon[n2].k.getLowerLimit(2);
        double d4 = this.newSoil.horizon[n2].k.getUpperLimit(2);
        String string = "greater than 0.";
        if (this.newSoil.horizon[n2].k instanceof BrooksConductivity) {
            d = 2.0;
            d2 = Double.MAX_VALUE;
            string = "greater than or equal to 2.";
        } else if (this.newSoil.horizon[n2].k instanceof GardnerConductivity) {
            d = Double.MIN_VALUE;
            d2 = Double.MAX_VALUE;
            string = "greater than 0.";
        } else if (this.newSoil.horizon[n2].k instanceof VanGenuchtenConductivity) {
            d = 1.0;
            d2 = Double.MAX_VALUE;
            string = "greater than 1.";
        }
        String string2 = "Layer " + Integer.toString(n) + ": " + this.newSoil.horizon[n2].k.getName(2) + " should be " + string;
        String string3 = "Layer " + Integer.toString(n) + ": " + this.newSoil.horizon[n2].k.getErrorMessage(2);
        this.exponentCondErrorFree[n2] = Tools.getErrorAndWarning(this.ctfParam3[n2], d, d2, d3, d4, string2, string3);
        if (this.exponentCondErrorFree[n2]) {
            this.errorTextField = null;
            this.newSoil.horizon[n2].k.setParamValue(2, Double.parseDouble(this.ctfParam3[n2].getText()));
        } else {
            this.errorFree = false;
            this.errorTextField = "ConductN" + this.layerSuffix[n2];
        }
    }

    private void checkValidBubblingCoeffInConductivity(int n) {
        int n2 = n - 1;
        double d = Double.MIN_VALUE;
        double d2 = Double.MAX_VALUE;
        double d3 = this.newSoil.horizon[n2].k.getLowerLimit(1);
        double d4 = this.newSoil.horizon[n2].k.getUpperLimit(1);
        String string = "greater than 0.";
        if (this.newSoil.horizon[n2].k instanceof BrooksConductivity) {
            d = -1.7976931348623157E308;
            d2 = -4.9E-324;
            string = "less than 0.";
        } else if (this.newSoil.horizon[n2].k instanceof GardnerConductivity) {
            d = -1.7976931348623157E308;
            d2 = -4.9E-324;
            string = "less than 0.";
        } else if (this.newSoil.horizon[n2].k instanceof VanGenuchtenConductivity) {
            d = Double.MIN_VALUE;
            d2 = Double.MAX_VALUE;
            string = "greater than 0.";
        }
        String string2 = "Layer " + Integer.toString(n) + ": " + this.newSoil.horizon[n2].k.getName(1) + " should be " + string;
        String string3 = "Layer " + Integer.toString(n) + ": " + this.newSoil.horizon[n2].k.getErrorMessage(1);
        this.bubblinCoeffCondErrorFree[n2] = Tools.getErrorAndWarning(this.ctfParam2[n2], d, d2, d3, d4, string2, string3);
        if (this.bubblinCoeffCondErrorFree[n2]) {
            this.errorTextField = null;
            this.newSoil.horizon[n2].k.setParamValue(1, Double.parseDouble(this.ctfParam2[n2].getText()));
        } else {
            this.errorFree = false;
            this.errorTextField = "ConductAlpha" + this.layerSuffix[n2];
        }
    }

    private void checkValidSatK(int n) {
        int n2 = n - 1;
        double d = Double.MIN_VALUE;
        double d2 = Double.MAX_VALUE;
        double d3 = this.newSoil.horizon[n2].k.getLowerLimit(3);
        double d4 = this.newSoil.horizon[n2].k.getUpperLimit(3);
        String string = "Layer " + Integer.toString(n) + ": " + this.newSoil.horizon[n2].k.getName(3) + " should be greater than 0.";
        String string2 = "Layer " + Integer.toString(n) + ": " + this.newSoil.horizon[n2].k.getErrorMessage(3);
        this.satKErrorFree[n2] = Tools.getErrorAndWarning(this.ctfParam1[n2], d, d2, d3, d4, string, string2);
        if (this.satKErrorFree[n2]) {
            this.errorTextField = null;
            this.newSoil.horizon[n2].k.setParamValue(3, Double.parseDouble(this.ctfParam1[n2].getText()));
        } else {
            this.errorFree = false;
            this.errorTextField = "ConductK" + this.layerSuffix[n2];
        }
    }

    void checkValidSoilThickness(int n) {
        int n2 = n - 1;
        double d = Double.MIN_VALUE;
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MIN_VALUE;
        double d4 = Double.MAX_VALUE;
        String string = "Layer " + Integer.toString(n) + ": " + "Soil layer thickness should be greater than 0.";
        String string2 = "Layer " + Integer.toString(n) + ": " + "Soil layer thickness should be greater than 0.";
        this.thicknessErrorFree[n2] = Tools.getErrorAndWarning(this.tfLayer[n2], d, d2, d3, d4, string, string2);
        if (this.thicknessErrorFree[n2]) {
            double d5;
            double d6;
            this.errorTextField = null;
            if (n2 == 0) {
                this.newSoil.horizon[n2].setLength(Double.parseDouble(this.tfLayer[n2].getText()));
            } else {
                d6 = this.newSoil.horizon[n2 - 1].depthBottom;
                d5 = d6 + Double.parseDouble(this.tfLayer[n2].getText());
                this.newSoil.horizon[n2].setLength(d6, d5);
            }
            int n3 = n2 + 1;
            while (n3 < this.newSoil.nHorizons) {
                d6 = this.newSoil.horizon[n3 - 1].depthBottom;
                d5 = d6 + this.newSoil.horizon[n3].getLength();
                this.newSoil.horizon[n3].setLength(d6, d5);
                ++n3;
            }
        } else {
            this.errorFree = false;
            this.errorTextField = "Layer" + this.layerSuffix[n2];
        }
    }

    void checkValidOrgCarbon(int n) {
        int n2 = n - 1;
        double d = 0.0;
        double d2 = Double.MAX_VALUE;
        double d3 = 0.0;
        double d4 = 0.5;
        String string = "Layer " + Integer.toString(n) + ": " + "Organic carbon content should be greater than or equal to 0.";
        String string2 = "Layer " + Integer.toString(n) + ": " + "Organic carbon content usually ranges from 0.0 to 0.5.";
        this.orgCarbonErrorFree[n2] = Tools.getErrorAndWarning(this.orgCarbon[n2], d, d2, d3, d4, string, string2);
        if (this.orgCarbonErrorFree[n2]) {
            this.errorTextField = null;
            this.newSoil.horizon[n2].setOC(Double.parseDouble(this.orgCarbon[n2].getText()));
        } else {
            this.errorFree = false;
            this.errorTextField = "OrgCarbon" + this.layerSuffix[n2];
        }
    }

    void checkValidBulkDen(int n) {
        int n2 = n - 1;
        double d = Double.MIN_VALUE;
        double d2 = Double.MAX_VALUE;
        double d3 = 0.5;
        double d4 = 2.0;
        String string = "Layer " + Integer.toString(n) + ": " + "Bulk density should be greater than 0.";
        String string2 = "Layer " + Integer.toString(n) + ": " + "Bulk density usually ranges from 0.5 to 2.0.";
        this.bulkDensityErrorFree[n2] = Tools.getErrorAndWarning(this.bulkDen[n2], d, d2, d3, d4, string, string2);
        if (this.bulkDensityErrorFree[n2]) {
            this.errorTextField = null;
            this.newSoil.horizon[n2].setBulkDensity(Double.parseDouble(this.bulkDen[n2].getText()));
        } else {
            this.errorFree = false;
            this.errorTextField = "Bulk" + this.layerSuffix[n2];
        }
    }

    private void setTextFields(Conductivity conductivity, int n) {
        int n2 = n - 1;
        this.ctfParam1[n2].setText(Tools.formatDouble(conductivity.getParamValue(3), conductivity.getDecimalDigits(3), 0));
        this.ctfParam2[n2].setText(Tools.formatDouble(conductivity.getParamValue(1), conductivity.getDecimalDigits(1), 0));
        this.ctfParam3[n2].setText(Tools.formatDouble(conductivity.getParamValue(2), conductivity.getDecimalDigits(2), 0));
    }

    private void setTextFields(WaterContent waterContent, int n) {
        int n2 = n - 1;
        this.wtfParam1[n2].setText(Tools.formatDouble(waterContent.getParamValue(3), waterContent.getDecimalDigits(3), 0));
        this.wtfParam2[n2].setText(Tools.formatDouble(waterContent.getParamValue(4), waterContent.getDecimalDigits(4), 0));
        this.wtfParam3[n2].setText(Tools.formatDouble(waterContent.getParamValue(1), waterContent.getDecimalDigits(1), 0));
        this.wtfParam4[n2].setText(Tools.formatDouble(waterContent.getParamValue(2), waterContent.getDecimalDigits(2), 0));
    }

    void setNewConductivity(int n) {
        this.newK = this.defaultConductivity[this.currentHorizon][n];
    }

    void setNewWaterContent(int n) {
        this.newWC = this.defaultWaterContent[this.currentHorizon][n];
    }

    void setConductivityChoices(int n) {
        this.newSoil.horizon[this.currentHorizon].setConductivity(this.newK);
        this.setTextFields(this.newSoil.horizon[this.currentHorizon].k, this.currentHorizon + 1);
        this.clK[this.currentHorizon].setText(this.conductivityPara[n][0]);
        this.clAlpha[this.currentHorizon].setText(this.conductivityPara[n][1]);
        this.clN[this.currentHorizon].setText(this.conductivityPara[n][2]);
    }

    void setWaterContentChoices(int n) {
        this.newSoil.horizon[this.currentHorizon].setWaterContent(this.newWC);
        this.setTextFields(this.newSoil.horizon[this.currentHorizon].wc, this.currentHorizon + 1);
        this.wlK[this.currentHorizon].setText(this.rententionPara[n][0]);
        this.wlTheta[this.currentHorizon].setText(this.rententionPara[n][1]);
        this.wlAlpha[this.currentHorizon].setText(this.rententionPara[n][2]);
        this.wlN[this.currentHorizon].setText(this.rententionPara[n][3]);
    }

    public boolean saveNewSoilData() {
        this.performed();
        if (this.errorFree) {
            RichardsEqn.length = this.newSoil.horizon[this.newSoil.nHorizons - 1].depthBottom;
            if (this.newSoil.nHorizons != this.oldSoil.nHorizons) {
                this.restart = true;
            } else if (Math.abs(RichardsEqn.length - this.oldSoil.horizon[this.oldSoil.nHorizons - 1].depthBottom) > 1.0E-8) {
                this.restart = true;
            } else {
                int n = 0;
                while (n < this.newSoil.nHorizons) {
                    if (this.orignCindex[n] != RichardsEqn.selectedConductModelIndex[n]) {
                        this.restart = true;
                        break;
                    }
                    if (this.orignWCindex[n] != RichardsEqn.selectedRententModelIndex[n]) {
                        this.restart = true;
                        break;
                    }
                    int n2 = 1;
                    while (n2 <= 3) {
                        if (Math.abs(this.newSoil.horizon[n].k.getParamValue(n2) - this.oldSoil.horizon[n].k.getParamValue(n2)) > 1.0E-8) {
                            this.restart = true;
                            break;
                        }
                        ++n2;
                    }
                    if (this.restart) break;
                    int n3 = 1;
                    while (n3 <= 4) {
                        if (Math.abs(this.newSoil.horizon[n].wc.getParamValue(n3) - this.oldSoil.horizon[n].wc.getParamValue(n3)) > 1.0E-8) {
                            this.restart = true;
                            break;
                        }
                        ++n3;
                    }
                    if (this.restart) break;
                    if (Math.abs(this.newSoil.horizon[n].getOC() - this.oldSoil.horizon[n].getOC()) > 1.0E-8) {
                        this.restart = true;
                        break;
                    }
                    if (Math.abs(this.newSoil.horizon[n].getBulkDensity() - this.oldSoil.horizon[n].getBulkDensity()) > 1.0E-8) {
                        this.restart = true;
                        break;
                    }
                    if (Math.abs(this.newSoil.horizon[n].getLength() - this.oldSoil.horizon[n].getLength()) > 1.0E-8) {
                        this.restart = true;
                        break;
                    }
                    ++n;
                }
            }
            RichardsEqn.editingSoil = this.newSoil;
        }
        return this.errorFree;
    }

    public void reStoreOriginalSoil() {
        int n = 0;
        while (n < this.oldSoil.nHorizons) {
            RichardsEqn.selectedConductModelIndex[n] = this.orignCindex[n];
            RichardsEqn.selectedRententModelIndex[n] = this.orignWCindex[n];
            RichardsEqn.editingSoil = this.oldSoil;
            this.restart = false;
            ++n;
        }
    }

    class MouseClickListener
    extends MouseAdapter {
        MouseClickListener() {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = 0;
            while (n3 < EditSoilFunctionFormPanel.this.Layer_No) {
                if (EditSoilFunctionFormPanel.this.rectC[n3].contains(n, n2)) {
                    ModelParameters.lIcon.setIcon(ModelParameters.Images[RichardsEqn.selectedConductModelIndex[n3]]);
                    break;
                }
                if (EditSoilFunctionFormPanel.this.rectW[n3].contains(n, n2)) {
                    ModelParameters.lIcon.setIcon(ModelParameters.Images[RichardsEqn.selectedRententModelIndex[n3] + 3]);
                    break;
                }
                ++n3;
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = 0;
            while (n3 < EditSoilFunctionFormPanel.this.Layer_No) {
                if (EditSoilFunctionFormPanel.this.rectC[n3].contains(n, n2)) {
                    ModelParameters.lIcon.setIcon(ModelParameters.Images[RichardsEqn.selectedConductModelIndex[0]]);
                    break;
                }
                if (EditSoilFunctionFormPanel.this.rectW[n3].contains(n, n2)) {
                    ModelParameters.lIcon.setIcon(ModelParameters.Images[RichardsEqn.selectedRententModelIndex[0] + 3]);
                    break;
                }
                ++n3;
            }
        }
    }

    class forEvent
    extends MouseAdapter
    implements ActionListener,
    ItemListener {
        String name;

        public forEvent() {
        }

        public forEvent(String string) {
            this.name = string;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (this.name.equals("ConductI")) {
                ((EditSoilFunctionFormPanel)EditSoilFunctionFormPanel.this).oldConductIndex[0] = RichardsEqn.selectedConductModelIndex[0];
                RichardsEqn.selectedConductModelIndex[0] = EditSoilFunctionFormPanel.this.conductProperty[0].getSelectedIndex();
                if (RichardsEqn.selectedConductModelIndex[0] != EditSoilFunctionFormPanel.this.oldConductIndex[0]) {
                    EditSoilFunctionFormPanel.this.IconIndex = RichardsEqn.selectedConductModelIndex[0];
                    EditSoilFunctionFormPanel.this.restart = true;
                    EditSoilFunctionFormPanel.this.currentHorizon = 0;
                    EditSoilFunctionFormPanel.this.setNewConductivity(RichardsEqn.selectedConductModelIndex[0]);
                    EditSoilFunctionFormPanel.this.setConductivityChoices(EditSoilFunctionFormPanel.this.IconIndex);
                    ModelParameters.lIcon.setIcon(ModelParameters.Images[EditSoilFunctionFormPanel.this.IconIndex]);
                }
            } else if (this.name.equals("WaterI")) {
                ((EditSoilFunctionFormPanel)EditSoilFunctionFormPanel.this).oldWaterIndex[0] = RichardsEqn.selectedRententModelIndex[0];
                RichardsEqn.selectedRententModelIndex[0] = EditSoilFunctionFormPanel.this.waterProperty[0].getSelectedIndex();
                if (EditSoilFunctionFormPanel.this.oldWaterIndex[0] != RichardsEqn.selectedRententModelIndex[0]) {
                    EditSoilFunctionFormPanel.this.IconIndex = RichardsEqn.selectedRententModelIndex[0] + 3;
                    EditSoilFunctionFormPanel.this.restart = true;
                    EditSoilFunctionFormPanel.this.currentHorizon = 0;
                    EditSoilFunctionFormPanel.this.setNewWaterContent(RichardsEqn.selectedRententModelIndex[0]);
                    EditSoilFunctionFormPanel.this.setWaterContentChoices(EditSoilFunctionFormPanel.this.IconIndex - 3);
                    ModelParameters.lIcon.setIcon(ModelParameters.Images[EditSoilFunctionFormPanel.this.IconIndex]);
                }
            } else if (this.name.equals("ConductII")) {
                ((EditSoilFunctionFormPanel)EditSoilFunctionFormPanel.this).oldConductIndex[1] = RichardsEqn.selectedConductModelIndex[1];
                RichardsEqn.selectedConductModelIndex[1] = EditSoilFunctionFormPanel.this.conductProperty[1].getSelectedIndex();
                if (RichardsEqn.selectedConductModelIndex[1] != EditSoilFunctionFormPanel.this.oldConductIndex[1]) {
                    EditSoilFunctionFormPanel.this.IconIndex = RichardsEqn.selectedConductModelIndex[1];
                    EditSoilFunctionFormPanel.this.restart = true;
                    EditSoilFunctionFormPanel.this.currentHorizon = 1;
                    EditSoilFunctionFormPanel.this.setNewConductivity(RichardsEqn.selectedConductModelIndex[1]);
                    EditSoilFunctionFormPanel.this.setConductivityChoices(EditSoilFunctionFormPanel.this.IconIndex);
                    ModelParameters.lIcon.setIcon(ModelParameters.Images[EditSoilFunctionFormPanel.this.IconIndex]);
                } else {
                    ModelParameters.lIcon.setIcon(ModelParameters.Images[EditSoilFunctionFormPanel.this.oldConductIndex[1]]);
                }
            } else if (this.name.equals("WaterII")) {
                ((EditSoilFunctionFormPanel)EditSoilFunctionFormPanel.this).oldWaterIndex[1] = RichardsEqn.selectedRententModelIndex[1];
                RichardsEqn.selectedRententModelIndex[1] = EditSoilFunctionFormPanel.this.waterProperty[1].getSelectedIndex();
                if (EditSoilFunctionFormPanel.this.oldWaterIndex[1] != RichardsEqn.selectedRententModelIndex[1]) {
                    EditSoilFunctionFormPanel.this.IconIndex = RichardsEqn.selectedRententModelIndex[1] + 3;
                    EditSoilFunctionFormPanel.this.restart = true;
                    EditSoilFunctionFormPanel.this.currentHorizon = 1;
                    EditSoilFunctionFormPanel.this.setNewWaterContent(RichardsEqn.selectedRententModelIndex[1]);
                    EditSoilFunctionFormPanel.this.setWaterContentChoices(EditSoilFunctionFormPanel.this.IconIndex - 3);
                    ModelParameters.lIcon.setIcon(ModelParameters.Images[EditSoilFunctionFormPanel.this.IconIndex]);
                } else {
                    ModelParameters.lIcon.setIcon(ModelParameters.Images[EditSoilFunctionFormPanel.this.oldWaterIndex[1] + 3]);
                }
            } else if (this.name.equals("ConductIII")) {
                ((EditSoilFunctionFormPanel)EditSoilFunctionFormPanel.this).oldConductIndex[2] = RichardsEqn.selectedConductModelIndex[2];
                RichardsEqn.selectedConductModelIndex[2] = EditSoilFunctionFormPanel.this.conductProperty[2].getSelectedIndex();
                if (RichardsEqn.selectedConductModelIndex[2] != EditSoilFunctionFormPanel.this.oldConductIndex[2]) {
                    EditSoilFunctionFormPanel.this.IconIndex = RichardsEqn.selectedConductModelIndex[2];
                    EditSoilFunctionFormPanel.this.restart = true;
                    EditSoilFunctionFormPanel.this.currentHorizon = 2;
                    EditSoilFunctionFormPanel.this.setNewConductivity(RichardsEqn.selectedConductModelIndex[2]);
                    EditSoilFunctionFormPanel.this.setConductivityChoices(EditSoilFunctionFormPanel.this.IconIndex);
                    ModelParameters.lIcon.setIcon(ModelParameters.Images[EditSoilFunctionFormPanel.this.IconIndex]);
                } else {
                    ModelParameters.lIcon.setIcon(ModelParameters.Images[EditSoilFunctionFormPanel.this.oldConductIndex[2]]);
                }
            } else if (this.name.equals("WaterIII")) {
                ((EditSoilFunctionFormPanel)EditSoilFunctionFormPanel.this).oldWaterIndex[2] = RichardsEqn.selectedRententModelIndex[2];
                RichardsEqn.selectedRententModelIndex[2] = EditSoilFunctionFormPanel.this.waterProperty[2].getSelectedIndex();
                if (EditSoilFunctionFormPanel.this.oldWaterIndex[2] != RichardsEqn.selectedRententModelIndex[2]) {
                    EditSoilFunctionFormPanel.this.IconIndex = RichardsEqn.selectedRententModelIndex[2] + 3;
                    EditSoilFunctionFormPanel.this.restart = true;
                    EditSoilFunctionFormPanel.this.currentHorizon = 2;
                    EditSoilFunctionFormPanel.this.setNewWaterContent(RichardsEqn.selectedRententModelIndex[2]);
                    EditSoilFunctionFormPanel.this.setWaterContentChoices(EditSoilFunctionFormPanel.this.IconIndex - 3);
                    ModelParameters.lIcon.setIcon(ModelParameters.Images[EditSoilFunctionFormPanel.this.IconIndex]);
                } else {
                    ModelParameters.lIcon.setIcon(ModelParameters.Images[EditSoilFunctionFormPanel.this.oldWaterIndex[2] + 3]);
                }
            } else if (this.name.equals("ConductIV")) {
                ((EditSoilFunctionFormPanel)EditSoilFunctionFormPanel.this).oldConductIndex[3] = RichardsEqn.selectedConductModelIndex[3];
                RichardsEqn.selectedConductModelIndex[3] = EditSoilFunctionFormPanel.this.conductProperty[3].getSelectedIndex();
                if (RichardsEqn.selectedConductModelIndex[3] != EditSoilFunctionFormPanel.this.oldConductIndex[3]) {
                    EditSoilFunctionFormPanel.this.IconIndex = RichardsEqn.selectedConductModelIndex[3];
                    EditSoilFunctionFormPanel.this.restart = true;
                    EditSoilFunctionFormPanel.this.currentHorizon = 3;
                    EditSoilFunctionFormPanel.this.setNewConductivity(RichardsEqn.selectedConductModelIndex[3]);
                    EditSoilFunctionFormPanel.this.setConductivityChoices(EditSoilFunctionFormPanel.this.IconIndex);
                    ModelParameters.lIcon.setIcon(ModelParameters.Images[EditSoilFunctionFormPanel.this.IconIndex]);
                } else {
                    ModelParameters.lIcon.setIcon(ModelParameters.Images[EditSoilFunctionFormPanel.this.oldConductIndex[3]]);
                }
            } else if (this.name.equals("WaterIV")) {
                ((EditSoilFunctionFormPanel)EditSoilFunctionFormPanel.this).oldWaterIndex[3] = RichardsEqn.selectedRententModelIndex[3];
                RichardsEqn.selectedRententModelIndex[3] = EditSoilFunctionFormPanel.this.waterProperty[3].getSelectedIndex();
                if (EditSoilFunctionFormPanel.this.oldWaterIndex[3] != RichardsEqn.selectedRententModelIndex[3]) {
                    EditSoilFunctionFormPanel.this.IconIndex = RichardsEqn.selectedRententModelIndex[3] + 3;
                    EditSoilFunctionFormPanel.this.restart = true;
                    EditSoilFunctionFormPanel.this.currentHorizon = 3;
                    EditSoilFunctionFormPanel.this.setNewWaterContent(RichardsEqn.selectedRententModelIndex[3]);
                    EditSoilFunctionFormPanel.this.setWaterContentChoices(EditSoilFunctionFormPanel.this.IconIndex - 3);
                    ModelParameters.lIcon.setIcon(ModelParameters.Images[EditSoilFunctionFormPanel.this.IconIndex]);
                } else {
                    ModelParameters.lIcon.setIcon(ModelParameters.Images[EditSoilFunctionFormPanel.this.oldWaterIndex[3] + 3]);
                }
            } else if (this.name.equals("ConductV")) {
                ((EditSoilFunctionFormPanel)EditSoilFunctionFormPanel.this).oldConductIndex[4] = RichardsEqn.selectedConductModelIndex[4];
                RichardsEqn.selectedConductModelIndex[4] = EditSoilFunctionFormPanel.this.conductProperty[4].getSelectedIndex();
                if (RichardsEqn.selectedConductModelIndex[4] != EditSoilFunctionFormPanel.this.oldConductIndex[4]) {
                    EditSoilFunctionFormPanel.this.IconIndex = RichardsEqn.selectedConductModelIndex[4];
                    EditSoilFunctionFormPanel.this.restart = true;
                    EditSoilFunctionFormPanel.this.currentHorizon = 4;
                    EditSoilFunctionFormPanel.this.setNewConductivity(RichardsEqn.selectedConductModelIndex[4]);
                    EditSoilFunctionFormPanel.this.setConductivityChoices(EditSoilFunctionFormPanel.this.IconIndex);
                    ModelParameters.lIcon.setIcon(ModelParameters.Images[EditSoilFunctionFormPanel.this.IconIndex]);
                } else {
                    ModelParameters.lIcon.setIcon(ModelParameters.Images[EditSoilFunctionFormPanel.this.oldConductIndex[4]]);
                }
            } else if (this.name.equals("WaterV")) {
                ((EditSoilFunctionFormPanel)EditSoilFunctionFormPanel.this).oldWaterIndex[4] = RichardsEqn.selectedRententModelIndex[4];
                RichardsEqn.selectedRententModelIndex[4] = EditSoilFunctionFormPanel.this.waterProperty[4].getSelectedIndex();
                if (EditSoilFunctionFormPanel.this.oldWaterIndex[4] != RichardsEqn.selectedRententModelIndex[4]) {
                    EditSoilFunctionFormPanel.this.IconIndex = RichardsEqn.selectedRententModelIndex[4] + 3;
                    EditSoilFunctionFormPanel.this.restart = true;
                    EditSoilFunctionFormPanel.this.currentHorizon = 4;
                    EditSoilFunctionFormPanel.this.setNewWaterContent(RichardsEqn.selectedRententModelIndex[4]);
                    EditSoilFunctionFormPanel.this.setWaterContentChoices(EditSoilFunctionFormPanel.this.IconIndex - 3);
                    ModelParameters.lIcon.setIcon(ModelParameters.Images[EditSoilFunctionFormPanel.this.IconIndex]);
                } else {
                    ModelParameters.lIcon.setIcon(ModelParameters.Images[EditSoilFunctionFormPanel.this.oldWaterIndex[4] + 3]);
                }
            }
            EditSoilFunctionFormPanel.this.performed();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() instanceof JTextField) {
                EditSoilFunctionFormPanel.this.processingTextFieldEvents(this.name);
                EditSoilFunctionFormPanel.this.previousTextField = null;
            } else {
                EditSoilFunctionFormPanel.this.performed();
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            String string = null;
            if (EditSoilFunctionFormPanel.this.previousTextField != null) {
                EditSoilFunctionFormPanel.this.processingTextFieldEvents(EditSoilFunctionFormPanel.this.previousTextField);
                string = EditSoilFunctionFormPanel.this.previousTextField;
                EditSoilFunctionFormPanel.this.previousTextField = null;
            }
            if (mouseEvent.getSource() instanceof JTextField) {
                this.updateEquationImage();
                if (!(string != null && EditSoilFunctionFormPanel.this.errorTextField != null && string.equals(EditSoilFunctionFormPanel.this.errorTextField) || mouseEvent.getSource() == null || ((JTextField)mouseEvent.getSource()).getText().trim().length() == 0)) {
                    EditSoilFunctionFormPanel.this.performed();
                }
                EditSoilFunctionFormPanel.this.previousTextField = this.name;
            }
        }

        private void updateEquationImage() {
            if (this.name.equals("ConductKI") || this.name.equals("ConductAlphaI") || this.name.equals("ConductNI")) {
                ModelParameters.lIcon.setIcon(ModelParameters.Images[RichardsEqn.selectedConductModelIndex[0]]);
            } else if (this.name.equals("SatWaterI") || this.name.equals("ResWaterI") || this.name.equals("WaterAlphaI") || this.name.equals("WaterNI")) {
                ModelParameters.lIcon.setIcon(ModelParameters.Images[RichardsEqn.selectedRententModelIndex[0] + 3]);
            } else if (this.name.equals("ConductKII") || this.name.equals("ConductAlphaII") || this.name.equals("ConductNII")) {
                ModelParameters.lIcon.setIcon(ModelParameters.Images[RichardsEqn.selectedConductModelIndex[1]]);
            } else if (this.name.equals("SatWaterII") || this.name.equals("ResWaterII") || this.name.equals("WaterAlphaII") || this.name.equals("WaterNII")) {
                ModelParameters.lIcon.setIcon(ModelParameters.Images[RichardsEqn.selectedRententModelIndex[1] + 3]);
            } else if (this.name.equals("ConductKIII") || this.name.equals("ConductAlphaIII") || this.name.equals("ConductNIII")) {
                ModelParameters.lIcon.setIcon(ModelParameters.Images[RichardsEqn.selectedConductModelIndex[2]]);
            } else if (this.name.equals("SatWaterIII") || this.name.equals("ResWaterIII") || this.name.equals("WaterAlphaIII") || this.name.equals("WaterNIII")) {
                ModelParameters.lIcon.setIcon(ModelParameters.Images[RichardsEqn.selectedRententModelIndex[2] + 3]);
            } else if (this.name.equals("ConductKIV") || this.name.equals("ConductAlphaIV") || this.name.equals("ConductNIV")) {
                ModelParameters.lIcon.setIcon(ModelParameters.Images[RichardsEqn.selectedConductModelIndex[3]]);
            } else if (this.name.equals("SatWaterIV") || this.name.equals("ResWaterIV") || this.name.equals("WaterAlphaIV") || this.name.equals("WaterNIV")) {
                ModelParameters.lIcon.setIcon(ModelParameters.Images[RichardsEqn.selectedRententModelIndex[3] + 3]);
            } else if (this.name.equals("ConductKV") || this.name.equals("ConductAlphaV") || this.name.equals("ConductNV")) {
                ModelParameters.lIcon.setIcon(ModelParameters.Images[RichardsEqn.selectedConductModelIndex[4]]);
            } else if (this.name.equals("SatWaterV") || this.name.equals("ResWaterV") || this.name.equals("WaterAlphaV") || this.name.equals("WaterNV")) {
                ModelParameters.lIcon.setIcon(ModelParameters.Images[RichardsEqn.selectedRententModelIndex[4] + 3]);
            }
        }
    }
}

