/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Image;

public class GardnerConductivity
extends Conductivity {
    double matricPotConstant;
    double satK;
    double n;
    private static final Parameter hConstant = new Parameter("Matric Potential Constant, hc (cm)", -29.6, -50.0, -5.0, 1);
    private static final Parameter nConstant = new Parameter("Empirical Constant, n", 3.0, 1.8, 3.5, 2);
    private static final Parameter kSat = new Parameter("Sat. Conductivity, Ks, (cm/hr)", 2.0, 0.0, 50.0, 2);
    private Image equationImage;

    public GardnerConductivity(double d, double d2, double d3, Image image) {
        this.matricPotConstant = d2;
        this.satK = d;
        this.n = d3;
        this.equationImage = image;
    }

    public double getK(double d) {
        double d2 = d < 0.0 ? this.satK / (1.0 + Math.pow(d / this.matricPotConstant, this.n)) : this.satK;
        return d2;
    }

    public double getSatK() {
        return this.satK;
    }

    public String getName(int n) {
        String string;
        switch (n) {
            case 1: {
                string = hConstant.getName();
                break;
            }
            case 2: {
                string = nConstant.getName();
                break;
            }
            case 3: {
                string = kSat.getName();
                break;
            }
            default: {
                string = "IllegalIndex";
            }
        }
        return string;
    }

    public double getParamValue(int n) {
        double d;
        switch (n) {
            case 1: {
                d = this.matricPotConstant;
                break;
            }
            case 2: {
                d = this.n;
                break;
            }
            case 3: {
                d = this.satK;
                break;
            }
            default: {
                d = -999.0;
            }
        }
        return d;
    }

    public double getDefault(int n) {
        double d;
        switch (n) {
            case 1: {
                d = hConstant.getDefaultValue();
                break;
            }
            case 2: {
                d = nConstant.getDefaultValue();
                break;
            }
            case 3: {
                d = kSat.getDefaultValue();
                break;
            }
            default: {
                d = -999.0;
            }
        }
        return d;
    }

    public double getLowerLimit(int n) {
        double d;
        switch (n) {
            case 1: {
                d = hConstant.getLowerLimit();
                break;
            }
            case 2: {
                d = nConstant.getLowerLimit();
                break;
            }
            case 3: {
                d = kSat.getLowerLimit();
                break;
            }
            default: {
                d = -999999.0;
            }
        }
        return d;
    }

    public double getUpperLimit(int n) {
        double d;
        switch (n) {
            case 1: {
                d = hConstant.getUpperLimit();
                break;
            }
            case 2: {
                d = nConstant.getUpperLimit();
                break;
            }
            case 3: {
                d = kSat.getUpperLimit();
                break;
            }
            default: {
                d = 999999.0;
            }
        }
        return d;
    }

    public int getDecimalDigits(int n) {
        int n2;
        switch (n) {
            case 1: {
                n2 = hConstant.getDecimalDigits();
                break;
            }
            case 2: {
                n2 = nConstant.getDecimalDigits();
                break;
            }
            case 3: {
                n2 = kSat.getDecimalDigits();
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return n2;
    }

    public String getErrorMessage(int n) {
        String string;
        switch (n) {
            case 1: {
                string = new String("Matric Potential Constant");
                break;
            }
            case 2: {
                string = new String("Empirical constant, n");
                break;
            }
            case 3: {
                string = new String("Sat. Conductivity");
                break;
            }
            default: {
                string = new String("Program Error: This should never be shown.");
            }
        }
        string = n == 3 ? new String(string + " is usually between " + Tools.formatDouble(this.getLowerLimit(n), this.getDecimalDigits(n), 0) + " and " + Tools.formatDouble(this.getUpperLimit(n), this.getDecimalDigits(n), 0)) : new String(string + " is usually between " + Tools.formatDouble(this.getLowerLimit(n), this.getDecimalDigits(n), 0) + " and " + Tools.formatDouble(this.getUpperLimit(n), this.getDecimalDigits(n), 0));
        return string;
    }

    public Image getEquationImage() {
        return this.equationImage;
    }

    public void setParamValue(int n, double d) {
        switch (n) {
            case 1: {
                this.matricPotConstant = d;
                break;
            }
            case 2: {
                this.n = d;
                break;
            }
            case 3: {
                this.satK = d;
            }
        }
    }
}

