/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

class GraphLineDataTableModel
extends AbstractTableModel
implements Serializable {
    protected Vector m_vector;
    String[] columnNames;
    protected int m_columnsCount;

    GraphLineDataTableModel(Vector vector, Vector vector2, String[] stringArray) {
        this.columnNames = stringArray;
        this.m_columnsCount = stringArray.length;
        this.m_vector = new Vector();
        this.getData(vector, vector2);
    }

    public int getRowCount() {
        return this.m_vector == null ? 0 : this.m_vector.size();
    }

    public int getColumnCount() {
        return this.m_columnsCount;
    }

    public Object getValueAt(int n, int n2) {
        if (n < 0 || n >= this.getRowCount()) {
            return "";
        }
        ColorData colorData = (ColorData)this.m_vector.elementAt(n);
        if (colorData != null) {
            return colorData;
        }
        return "";
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    void getData(Vector vector, Vector vector2) {
        this.m_vector.removeAllElements();
        int n = 0;
        while (n < vector.size()) {
            String string = new String((String)vector.elementAt(n));
            Color color = (Color)vector2.elementAt(n);
            ColorData colorData = new ColorData(color, string);
            this.m_vector.addElement(colorData);
            ++n;
        }
    }
}

