/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

class GraphLineDataTablePanel
extends JPanel
implements Printable {
    protected int m_maxNumPage = 1;
    private JTable table;
    private GraphLineDataTableModel model;
    private String[] colNames = new String[]{""};
    private final int deftWidth = 450;
    private final int deftHeight = 800;

    public GraphLineDataTablePanel() {
        int n;
        int n2;
        this.setSize(450, 800);
        this.setLayout(new BorderLayout());
        Vector vector = new Vector();
        Vector<Color> vector2 = new Vector<Color>();
        if (CHEMFLO.mainScreen.hasNewLine()) {
            n2 = 0;
            while (n2 < CHEMFLO.mainScreen.graphData.length) {
                if (CHEMFLO.mainScreen.graphData[n2] != null) {
                    vector2.addElement(CHEMFLO.mainScreen.graphData[n2].color.darker());
                    n = 0;
                    while (n < CHEMFLO.mainScreen.graphData[n2].gData.size()) {
                        vector.addElement(CHEMFLO.mainScreen.graphData[n2].gData.elementAt(n));
                        if (n != 0) {
                            vector2.addElement(Color.black);
                        }
                        ++n;
                    }
                }
                ++n2;
            }
        } else {
            int n3;
            n2 = 0;
            n = 1;
            while (n < CHEMFLO.mainScreen.graphData.length) {
                if (CHEMFLO.mainScreen.graphData[n] != null) {
                    vector2.addElement(CHEMFLO.mainScreen.graphData[n].color.darker());
                    n3 = 0;
                    while (n3 < CHEMFLO.mainScreen.graphData[n].gData.size()) {
                        vector.addElement(CHEMFLO.mainScreen.graphData[n].gData.elementAt(n3));
                        if (n3 != 0) {
                            vector2.addElement(Color.black);
                        }
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            if (n2 == 0) {
                vector2.addElement(CHEMFLO.mainScreen.graphData[0].color.darker());
                n3 = 0;
                while (n3 < CHEMFLO.mainScreen.graphData[0].gData.size()) {
                    vector.addElement(CHEMFLO.mainScreen.graphData[0].gData.elementAt(n3));
                    if (n3 != 0) {
                        vector2.addElement(Color.black);
                    }
                    ++n3;
                }
            }
        }
        this.model = new GraphLineDataTableModel(vector, vector2, this.colNames);
        this.table = new JTable();
        this.table.setFont(new Font("Monospaced", 0, 12));
        if (RichardsEqn.osName.equals("Mac OS X")) {
            this.table.setFont(new Font("Osaka-Mono", 0, 12));
        }
        this.table.setAutoCreateColumnsFromModel(false);
        this.table.setModel(this.model);
        this.table.setGridColor(Color.white);
        this.table.setRowSelectionAllowed(false);
        this.table.setColumnSelectionAllowed(false);
        n2 = 0;
        while (n2 < this.colNames.length) {
            ColoredTableCellRenderer coloredTableCellRenderer = new ColoredTableCellRenderer();
            coloredTableCellRenderer.setHorizontalAlignment(2);
            TableColumn tableColumn = new TableColumn(n2, 450, coloredTableCellRenderer, null);
            this.table.addColumn(tableColumn);
            ++n2;
        }
        this.add((Component)this.table, "Center");
    }

    public void printData() {
        PageFormat pageFormat = null;
        CHEMFLO.setPrinter();
        if (CHEMFLO.printService == null && CHEMFLO.printerJob == null) {
            JOptionPane.showMessageDialog(CHEMFLO.appWin, "Failed to obtain printer service.", "Error", 2);
            return;
        }
        if (CHEMFLO.printService == null) {
            pageFormat = CHEMFLO.printerJob.defaultPage();
            pageFormat = CHEMFLO.printerJob.pageDialog(pageFormat);
        } else {
            pageFormat = CHEMFLO.printService.getDefaultPage();
            pageFormat = CHEMFLO.printService.showPageFormatDialog(pageFormat);
        }
        Paper paper = pageFormat.getPaper();
        paper.setImageableArea(paper.getImageableX(), (paper.getHeight() - paper.getImageableHeight()) / 4.0, paper.getImageableWidth(), paper.getImageableHeight() + (paper.getHeight() - paper.getImageableHeight()) / 2.0);
        pageFormat.setPaper(paper);
        this.m_maxNumPage = 1;
        if (CHEMFLO.printService == null) {
            CHEMFLO.printerJob.setPrintable(this, pageFormat);
            if (CHEMFLO.printerJob.printDialog()) {
                try {
                    CHEMFLO.printerJob.print();
                }
                catch (PrinterException printerException) {
                    JOptionPane.showMessageDialog(CHEMFLO.appWin, "Could not print.", "Error", 2);
                    return;
                }
            }
        } else {
            try {
                CHEMFLO.printService.print(this);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(CHEMFLO.appWin, "Could not print.", "Error", 2);
                return;
            }
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        int n2;
        if (n >= this.m_maxNumPage) {
            return 1;
        }
        graphics.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
        int n3 = 0;
        int n4 = 0;
        if (pageFormat.getOrientation() == 1) {
            n3 = (int)pageFormat.getImageableWidth();
            n4 = (int)(pageFormat.getImageableHeight() + pageFormat.getImageableHeight() / 2.0);
            graphics.setClip(0, 0, n3, n4);
        } else {
            n3 = (int)pageFormat.getImageableWidth();
            n3 += n3 / 2;
            n4 = (int)(pageFormat.getImageableHeight() + pageFormat.getImageableHeight() / 2.0);
            graphics.setClip(0, 0, n3, n4);
        }
        int n5 = 0;
        graphics.setColor(Color.black);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Font font = this.table.getFont().deriveFont(1);
        graphics.setFont(font);
        fontMetrics = graphics.getFontMetrics();
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        int n6 = tableColumnModel.getColumnCount();
        int[] nArray = new int[n6];
        nArray[0] = 0;
        int n7 = fontMetrics.getHeight();
        int n8 = 0;
        while (n8 < n6) {
            TableColumn tableColumn = tableColumnModel.getColumn(n8);
            n2 = tableColumn.getWidth();
            if (nArray[n8] + n2 > n3) {
                n6 = n8;
                break;
            }
            if (n8 + 1 < n6) {
                nArray[n8 + 1] = nArray[n8] + n2;
            }
            String string = (String)tableColumn.getIdentifier();
            ++n8;
        }
        graphics.setFont(new Font("Monospaced", 0, 8));
        if (RichardsEqn.osName.equals("Mac OS X")) {
            this.table.setFont(new Font("Osaka-Mono", 0, 8));
        }
        fontMetrics = graphics.getFontMetrics();
        int n9 = (int)(1.5 * (double)n7);
        n7 = fontMetrics.getHeight();
        n2 = Math.max((int)((double)n7 * 1.5), 10);
        int n10 = (n4 - n9) / n2;
        this.m_maxNumPage = Math.max((int)Math.ceil((double)this.table.getRowCount() / (double)n10), 1);
        TableModel tableModel = this.table.getModel();
        int n11 = n * n10;
        int n12 = Math.min(this.table.getRowCount(), n11 + n10);
        n6 = this.model.getColumnCount();
        int n13 = n11;
        while (n13 < n12) {
            n5 += n7;
            n8 = 0;
            while (n8 < n6) {
                Object object = this.model.getValueAt(n13, n8);
                String string = ((ColorData)object).m_data.toString();
                if (object instanceof ColorData) {
                    graphics.setColor(((ColorData)object).m_color);
                } else {
                    graphics.setColor(Color.black);
                }
                graphics.drawString("  " + string, nArray[n8], n5);
                ++n8;
            }
            ++n13;
        }
        System.gc();
        return 0;
    }

    class ColoredTableCellRenderer
    extends DefaultTableCellRenderer {
        ColoredTableCellRenderer() {
        }

        public void setValue(Object object) {
            if (object instanceof ColorData) {
                ColorData colorData = (ColorData)object;
                this.setForeground(colorData.m_color);
                this.setText("  " + colorData.m_data.toString());
            } else {
                super.setValue(object);
            }
        }
    }
}

