/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;

public class Graphs
extends JDialog {
    Soil s;
    int MAXPOINTS = 50;
    int temp;
    int winwidth = 500;
    int winheight = 455;
    public int matricMin = -1000;
    double thetaMax = 0.01;
    int selectedGraphIndex = 0;
    private Rectangle adjR;
    JLabel lLegend = new JLabel("LEGEND");
    JLabel lLayer1 = new JLabel("------ Layer 1");
    JLabel lLayer2 = new JLabel("------ Layer 2");
    JLabel lLayer3 = new JLabel("------ Layer 3");
    JLabel lLayer4 = new JLabel("------ Layer 4");
    JLabel lLayer5 = new JLabel("------ Layer 5");
    JComboBox chType;
    JButton bClose;
    JButton bPrint;
    Font fDialog = new Font("Serif", 0, 12);
    FontMetrics fm;
    double[] x = new double[this.MAXPOINTS + 1];
    double[] k1 = new double[this.MAXPOINTS + 1];
    double[] k2 = new double[this.MAXPOINTS + 1];
    double[] k3 = new double[this.MAXPOINTS + 1];
    double[] k4 = new double[this.MAXPOINTS + 1];
    double[] k5 = new double[this.MAXPOINTS + 1];
    double[] wc1 = new double[this.MAXPOINTS + 1];
    double[] wc2 = new double[this.MAXPOINTS + 1];
    double[] wc3 = new double[this.MAXPOINTS + 1];
    double[] wc4 = new double[this.MAXPOINTS + 1];
    double[] wc5 = new double[this.MAXPOINTS + 1];
    private Border oldBorder;
    private BevelBorder raisedEdge = new BevelBorder(0);
    private GraphPanel gp;
    InnerFrame frame;

    public Graphs(Soil soil, int n) {
        super(CHEMFLO.appWin, "Additional Graphs", true);
        this.setSize(this.winwidth, this.winheight);
        this.setFont(this.fDialog);
        this.getContentPane().setLayout(new BorderLayout());
        this.s = soil;
        this.selectedGraphIndex = n;
        this.thetaMax = this.s.horizon[0].wc.getSatWC();
        int n2 = 0;
        while (n2 < this.s.nHorizons) {
            if (this.s.horizon[n2].wc.getSatWC() > this.thetaMax) {
                this.thetaMax = this.s.horizon[n2].wc.getSatWC();
            }
            ++n2;
        }
        this.thetaMax = Math.ceil(this.thetaMax * 10.0) / 10.0;
        typePanel typePanel2 = new typePanel();
        this.getContentPane().add((Component)typePanel2, "North");
        buttonPanel buttonPanel2 = new buttonPanel();
        this.getContentPane().add((Component)buttonPanel2, "South");
        this.gp = new GraphPanel();
        this.getContentPane().add((Component)this.gp, "Center");
        this.addWindowListener(new forEvent());
        Toolkit toolkit = this.getToolkit();
        Dimension dimension = toolkit.getScreenSize();
        this.setLocation(dimension.width - this.getSize().width >> 1, dimension.height - this.getSize().height >> 1);
        this.getLayeredPane().setLayout(null);
        this.frame = new InnerFrame("Adjust Matric Potential", this);
        this.frame.setSize(165, 70);
        this.frame.setBounds(5, 290, 170, 80);
        this.frame.setBorder(this.raisedEdge);
        this.getLayeredPane().add(this.frame);
        this.frame.setVisible(false);
        this.show();
    }

    public void Draw() {
        this.gp.repaint();
    }

    private void Calculation() {
        double d = Math.log(10.0);
        this.x[this.MAXPOINTS] = 0.0;
        this.k1[this.MAXPOINTS] = Math.log(this.s.horizon[0].getSatK()) / d;
        this.wc1[this.MAXPOINTS] = this.s.horizon[0].wc.getSatWC();
        if (this.s.nHorizons >= 2) {
            this.k2[this.MAXPOINTS] = Math.log(this.s.horizon[1].getSatK()) / d;
            this.wc2[this.MAXPOINTS] = this.s.horizon[1].wc.getSatWC();
            if (this.s.nHorizons >= 3) {
                this.k3[this.MAXPOINTS] = Math.log(this.s.horizon[2].getSatK()) / d;
                this.wc3[this.MAXPOINTS] = this.s.horizon[2].wc.getSatWC();
                if (this.s.nHorizons >= 4) {
                    this.k4[this.MAXPOINTS] = Math.log(this.s.horizon[3].getSatK()) / d;
                    this.wc4[this.MAXPOINTS] = this.s.horizon[3].wc.getSatWC();
                    if (this.s.nHorizons >= 5) {
                        this.k5[this.MAXPOINTS] = Math.log(this.s.horizon[4].getSatK()) / d;
                        this.wc5[this.MAXPOINTS] = this.s.horizon[4].wc.getSatWC();
                    }
                }
            }
        }
        double d2 = -this.matricMin / this.MAXPOINTS;
        int n = this.MAXPOINTS - 1;
        while (n >= 0) {
            this.x[n] = (double)this.matricMin + d2 * (double)n;
            this.k1[n] = Math.log(this.s.horizon[0].k.getK(this.x[n])) / d;
            this.wc1[n] = this.s.horizon[0].wc.getWC(this.x[n]);
            if (this.s.nHorizons >= 2) {
                this.k2[n] = Math.log(this.s.horizon[1].k.getK(this.x[n])) / d;
                this.wc2[n] = this.s.horizon[1].wc.getWC(this.x[n]);
                if (this.s.nHorizons >= 3) {
                    this.k3[n] = Math.log(this.s.horizon[2].k.getK(this.x[n])) / d;
                    this.wc3[n] = this.s.horizon[2].wc.getWC(this.x[n]);
                    if (this.s.nHorizons >= 4) {
                        this.k4[n] = Math.log(this.s.horizon[3].k.getK(this.x[n])) / d;
                        this.wc4[n] = this.s.horizon[3].wc.getWC(this.x[n]);
                        if (this.s.nHorizons >= 5) {
                            this.k5[n] = Math.log(this.s.horizon[4].k.getK(this.x[n])) / d;
                            this.wc5[n] = this.s.horizon[4].wc.getWC(this.x[n]);
                        }
                    }
                }
            }
            --n;
        }
    }

    public static void drawTicMarksOnY(double d, double d2, int n, int n2, int n3, int n4, int n5, int n6, FontMetrics fontMetrics, Rectangle rectangle, Graphics graphics) {
        double[] dArray = new double[2];
        int[] nArray = new int[2];
        double d3 = (d2 - d) / (double)n3;
        int n7 = 0;
        while (n7 <= n3) {
            dArray[0] = d + (double)n7 * d3;
            Tools.scaleY(dArray, d, d2, 1, nArray, rectangle.height, rectangle.y, n, n2);
            graphics.drawLine(rectangle.x, nArray[0], rectangle.x + n6, nArray[0]);
            graphics.drawLine(rectangle.x + rectangle.width, nArray[0], rectangle.x + rectangle.width - n6, nArray[0]);
            String string = new String(Tools.formatDouble(dArray[0], n4, n5));
            graphics.drawString(string, rectangle.x + rectangle.width + 5, nArray[0] + 4);
            ++n7;
        }
    }

    public static void drawTicMarksOnLogY(double d, double d2, int n, double d3, int n2, int n3, int n4, FontMetrics fontMetrics, Rectangle rectangle, Graphics graphics) {
        double[] dArray = new double[2];
        int[] nArray = new int[2];
        int n5 = 0;
        while (n5 <= n) {
            dArray[0] = d + (double)n5 * d3;
            Tools.scaleY(dArray, d, d2, 1, nArray, rectangle.height, rectangle.y, n2, n3);
            graphics.drawLine(rectangle.x, nArray[0], rectangle.x + n4, nArray[0]);
            graphics.drawLine(rectangle.x + rectangle.width, nArray[0], rectangle.x + rectangle.width - n4, nArray[0]);
            String string = new String(Tools.formatDouble(dArray[0], 0, 1));
            graphics.drawString("10", rectangle.x + rectangle.width + 5, nArray[0] + 4);
            graphics.drawString(string, rectangle.x + rectangle.width + 6 + fontMetrics.stringWidth("10"), nArray[0]);
            ++n5;
        }
        double d4 = 1.0;
        double d5 = Math.log(10.0);
        if (n <= 3 && d3 == 1.0) {
            n5 = 0;
            while (n5 < n) {
                if (n5 > 0) {
                    d4 *= 10.0;
                }
                int n6 = 2;
                while (n6 < 10) {
                    dArray[0] = d + Math.log((double)n6 * d4) / d5;
                    Tools.scaleY(dArray, d, d2, 1, nArray, rectangle.height, rectangle.y, n2, n3);
                    graphics.drawLine(rectangle.x, nArray[0], rectangle.x + n4, nArray[0]);
                    graphics.drawLine(rectangle.x + rectangle.width, nArray[0], rectangle.x + rectangle.width - n4, nArray[0]);
                    ++n6;
                }
                ++n5;
            }
        }
    }

    class MouseClickListener
    extends MouseAdapter {
        MouseClickListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() >= 1) {
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                if (Graphs.this.adjR.contains(n, n2)) {
                    Graphs.this.frame.setVisible(true);
                }
            }
        }
    }

    class bntMouseListener
    extends MouseAdapter {
        bntMouseListener() {
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (Graphs.this.bClose == (JButton)mouseEvent.getSource()) {
                Graphs.this.bClose.setBorder(Graphs.this.oldBorder);
            }
            if (Graphs.this.bPrint == (JButton)mouseEvent.getSource()) {
                Graphs.this.bPrint.setBorder(Graphs.this.oldBorder);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (Graphs.this.bClose == (JButton)mouseEvent.getSource()) {
                Graphs.this.bClose.setBorder(Graphs.this.raisedEdge);
            }
            if (Graphs.this.bPrint == (JButton)mouseEvent.getSource()) {
                Graphs.this.bPrint.setBorder(Graphs.this.raisedEdge);
            }
        }
    }

    class forEvent
    extends WindowAdapter
    implements ActionListener,
    ItemListener {
        String name;

        public forEvent() {
        }

        public forEvent(String string) {
            this.name = string;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (this.name.equals("chType") && Graphs.this.selectedGraphIndex != Graphs.this.chType.getSelectedIndex()) {
                Graphs.this.selectedGraphIndex = Graphs.this.chType.getSelectedIndex();
            }
            Graphs.this.gp.repaint();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.name.equals("Close")) {
                Graphs.this.setVisible(false);
                Graphs.this.dispose();
            }
            if (this.name.equals("Print")) {
                PageFormat pageFormat = null;
                CHEMFLO.setPrinter();
                if (CHEMFLO.printService == null && CHEMFLO.printerJob == null) {
                    JOptionPane.showMessageDialog(CHEMFLO.appWin, "Failed to obtain printer service.", "Error", 2);
                    return;
                }
                if (CHEMFLO.printService == null) {
                    pageFormat = CHEMFLO.printerJob.defaultPage();
                    pageFormat.setOrientation(1);
                    pageFormat = CHEMFLO.printerJob.pageDialog(pageFormat);
                } else {
                    pageFormat = CHEMFLO.printService.getDefaultPage();
                    pageFormat.setOrientation(1);
                    pageFormat = CHEMFLO.printService.showPageFormatDialog(pageFormat);
                }
                Paper paper = pageFormat.getPaper();
                paper.setImageableArea(63.0, paper.getImageableY(), paper.getImageableWidth() + 45.0, paper.getImageableHeight());
                pageFormat.setPaper(paper);
                ComponentPrintable componentPrintable = new ComponentPrintable(Graphs.this);
                Book book = new Book();
                book.append(componentPrintable, pageFormat);
                if (CHEMFLO.printService == null) {
                    CHEMFLO.printerJob.setPageable(book);
                    if (CHEMFLO.printerJob.printDialog()) {
                        try {
                            CHEMFLO.printerJob.print();
                        }
                        catch (PrinterException printerException) {
                            JOptionPane.showMessageDialog(CHEMFLO.appWin, "Could not print.", "Error", 2);
                            return;
                        }
                    }
                } else {
                    try {
                        CHEMFLO.printService.print(book);
                    }
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog(CHEMFLO.appWin, "Could not print.", "Error", 2);
                        return;
                    }
                }
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            Graphs.this.setVisible(false);
            Graphs.this.dispose();
        }
    }

    class GraphPanel
    extends JPanel {
        public GraphPanel() {
            Graphs.this.adjR = new Rectangle(10, 213, 60, 15);
            this.addMouseListener(new MouseClickListener());
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            double[] dArray = new double[]{0.0, 1.0, 1.0, 1.0};
            double[] dArray2 = null;
            Graphs.this.Calculation();
            graphics.setColor(Color.red);
            Rectangle rectangle = this.getBounds();
            rectangle.x = 35;
            rectangle.y = 30;
            rectangle.width = Graphs.this.winwidth - (rectangle.x * 2 + 30);
            rectangle.height = 180;
            Graphs.this.fm = this.getFontMetrics(this.getFont());
            graphics.setColor(Color.cyan);
            graphics.drawRect(10, 213, 60, 15);
            graphics.setColor(Color.red);
            Tools.drawBorder(rectangle, 2, graphics);
            Tools.drawTicMarksOnX(Graphs.this.matricMin, 0.0, 0, 0, 5, 0, 2, 8, Graphs.this.fm, rectangle, graphics);
            if (Graphs.this.selectedGraphIndex == 0) {
                if (Graphs.this.s.nHorizons >= 2) {
                    switch (Graphs.this.s.nHorizons) {
                        case 2: {
                            dArray[0] = Graphs.this.k1[0] > Graphs.this.k2[0] ? Graphs.this.k2[0] : Graphs.this.k1[0];
                            dArray[1] = Graphs.this.k1[Graphs.this.MAXPOINTS] > Graphs.this.k2[Graphs.this.MAXPOINTS] ? Graphs.this.k1[Graphs.this.MAXPOINTS] : Graphs.this.k2[Graphs.this.MAXPOINTS];
                            break;
                        }
                        case 3: {
                            dArray2 = new double[]{Graphs.this.k1[0], Graphs.this.k2[0], Graphs.this.k3[0]};
                            dArray[0] = Tools.getMinimum(dArray2, 3);
                            dArray2[0] = Graphs.this.k1[Graphs.this.MAXPOINTS];
                            dArray2[1] = Graphs.this.k2[Graphs.this.MAXPOINTS];
                            dArray2[2] = Graphs.this.k3[Graphs.this.MAXPOINTS];
                            dArray[1] = Tools.getMaximum(dArray2, 3);
                            break;
                        }
                        case 4: {
                            dArray2 = new double[]{Graphs.this.k1[0], Graphs.this.k2[0], Graphs.this.k3[0], Graphs.this.k4[0]};
                            dArray[0] = Tools.getMinimum(dArray2, 4);
                            dArray2[0] = Graphs.this.k1[Graphs.this.MAXPOINTS];
                            dArray2[1] = Graphs.this.k2[Graphs.this.MAXPOINTS];
                            dArray2[2] = Graphs.this.k3[Graphs.this.MAXPOINTS];
                            dArray2[3] = Graphs.this.k4[Graphs.this.MAXPOINTS];
                            dArray[1] = Tools.getMaximum(dArray2, 4);
                            break;
                        }
                        case 5: {
                            dArray2 = new double[]{Graphs.this.k1[0], Graphs.this.k2[0], Graphs.this.k3[0], Graphs.this.k4[0], Graphs.this.k5[0]};
                            dArray[0] = Tools.getMinimum(dArray2, 5);
                            dArray2[0] = Graphs.this.k1[Graphs.this.MAXPOINTS];
                            dArray2[1] = Graphs.this.k2[Graphs.this.MAXPOINTS];
                            dArray2[2] = Graphs.this.k3[Graphs.this.MAXPOINTS];
                            dArray2[3] = Graphs.this.k4[Graphs.this.MAXPOINTS];
                            dArray2[4] = Graphs.this.k5[Graphs.this.MAXPOINTS];
                            dArray[1] = Tools.getMaximum(dArray2, 5);
                        }
                    }
                } else {
                    dArray[0] = Graphs.this.k1[0];
                    dArray[1] = Graphs.this.k1[Graphs.this.MAXPOINTS];
                }
                Tools.getLogLimits(dArray[0], dArray[1], dArray);
                Graphs.drawTicMarksOnLogY(dArray[0], dArray[1], (int)dArray[2], (int)dArray[3], 0, 0, 8, Graphs.this.fm, rectangle, graphics);
            } else {
                Graphs.drawTicMarksOnY(0.0, Graphs.this.thetaMax, 0, 0, 5, 2, 2, 8, Graphs.this.fm, rectangle, graphics);
            }
            graphics.drawString("Matric Potential (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + ")", rectangle.x + rectangle.width / 2 - 60, rectangle.y + rectangle.height + 35);
            if (Graphs.this.selectedGraphIndex == 0) {
                graphics.drawString("Conductivity (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ")", rectangle.x + rectangle.width - 80, rectangle.y - 15);
                graphics.setColor(Color.blue);
                switch (Graphs.this.s.nHorizons) {
                    case 1: {
                        Tools.plotXY(Graphs.this.MAXPOINTS, Graphs.this.x, Graphs.this.k1, Graphs.this.matricMin, 0.0, dArray[0], dArray[1], 0, 0, 0, 0, rectangle, graphics);
                        break;
                    }
                    case 2: {
                        Tools.plotXY(Graphs.this.MAXPOINTS, Graphs.this.x, Graphs.this.k1, Graphs.this.matricMin, 0.0, dArray[0], dArray[1], 0, 0, 0, 0, rectangle, graphics);
                        graphics.setColor(Color.magenta.darker());
                        Tools.plotXY(Graphs.this.MAXPOINTS, Graphs.this.x, Graphs.this.k2, Graphs.this.matricMin, 0.0, dArray[0], dArray[1], 0, 0, 0, 0, rectangle, graphics);
                        break;
                    }
                    case 3: {
                        Tools.plotXY(Graphs.this.MAXPOINTS, Graphs.this.x, Graphs.this.k1, Graphs.this.matricMin, 0.0, dArray[0], dArray[1], 0, 0, 0, 0, rectangle, graphics);
                        graphics.setColor(Color.magenta.darker());
                        Tools.plotXY(Graphs.this.MAXPOINTS, Graphs.this.x, Graphs.this.k2, Graphs.this.matricMin, 0.0, dArray[0], dArray[1], 0, 0, 0, 0, rectangle, graphics);
                        graphics.setColor(Color.darkGray);
                        Tools.plotXY(Graphs.this.MAXPOINTS, Graphs.this.x, Graphs.this.k3, Graphs.this.matricMin, 0.0, dArray[0], dArray[1], 0, 0, 0, 0, rectangle, graphics);
                        break;
                    }
                    case 4: {
                        Tools.plotXY(Graphs.this.MAXPOINTS, Graphs.this.x, Graphs.this.k1, Graphs.this.matricMin, 0.0, dArray[0], dArray[1], 0, 0, 0, 0, rectangle, graphics);
                        graphics.setColor(Color.magenta.darker());
                        Tools.plotXY(Graphs.this.MAXPOINTS, Graphs.this.x, Graphs.this.k2, Graphs.this.matricMin, 0.0, dArray[0], dArray[1], 0, 0, 0, 0, rectangle, graphics);
                        graphics.setColor(Color.darkGray);
                        Tools.plotXY(Graphs.this.MAXPOINTS, Graphs.this.x, Graphs.this.k3, Graphs.this.matricMin, 0.0, dArray[0], dArray[1], 0, 0, 0, 0, rectangle, graphics);
                        graphics.setColor(Color.green);
                        Tools.plotXY(Graphs.this.MAXPOINTS, Graphs.this.x, Graphs.this.k4, Graphs.this.matricMin, 0.0, dArray[0], dArray[1], 0, 0, 0, 0, rectangle, graphics);
                        break;
                    }
                    case 5: {
                        Tools.plotXY(Graphs.this.MAXPOINTS, Graphs.this.x, Graphs.this.k1, Graphs.this.matricMin, 0.0, dArray[0], dArray[1], 0, 0, 0, 0, rectangle, graphics);
                        graphics.setColor(Color.magenta.darker());
                        Tools.plotXY(Graphs.this.MAXPOINTS, Graphs.this.x, Graphs.this.k2, Graphs.this.matricMin, 0.0, dArray[0], dArray[1], 0, 0, 0, 0, rectangle, graphics);
                        graphics.setColor(Color.darkGray);
                        Tools.plotXY(Graphs.this.MAXPOINTS, Graphs.this.x, Graphs.this.k3, Graphs.this.matricMin, 0.0, dArray[0], dArray[1], 0, 0, 0, 0, rectangle, graphics);
                        graphics.setColor(Color.green);
                        Tools.plotXY(Graphs.this.MAXPOINTS, Graphs.this.x, Graphs.this.k4, Graphs.this.matricMin, 0.0, dArray[0], dArray[1], 0, 0, 0, 0, rectangle, graphics);
                        graphics.setColor(Color.red);
                        Tools.plotXY(Graphs.this.MAXPOINTS, Graphs.this.x, Graphs.this.k5, Graphs.this.matricMin, 0.0, dArray[0], dArray[1], 0, 0, 0, 0, rectangle, graphics);
                    }
                }
            } else {
                graphics.drawString("Water Content (v/v)", rectangle.x + rectangle.width - 70, rectangle.y - 15);
                graphics.setColor(Color.blue);
                switch (Graphs.this.s.nHorizons) {
                    case 1: {
                        Tools.plotXY(Graphs.this.MAXPOINTS, Graphs.this.x, Graphs.this.wc1, Graphs.this.matricMin, 0.0, 0.0, Graphs.this.thetaMax, 0, 0, 0, 0, rectangle, graphics);
                        break;
                    }
                    case 2: {
                        Tools.plotXY(Graphs.this.MAXPOINTS, Graphs.this.x, Graphs.this.wc1, Graphs.this.matricMin, 0.0, 0.0, Graphs.this.thetaMax, 0, 0, 0, 0, rectangle, graphics);
                        graphics.setColor(Color.magenta.darker());
                        Tools.plotXY(Graphs.this.MAXPOINTS, Graphs.this.x, Graphs.this.wc2, Graphs.this.matricMin, 0.0, 0.0, Graphs.this.thetaMax, 0, 0, 0, 0, rectangle, graphics);
                        break;
                    }
                    case 3: {
                        Tools.plotXY(Graphs.this.MAXPOINTS, Graphs.this.x, Graphs.this.wc1, Graphs.this.matricMin, 0.0, 0.0, Graphs.this.thetaMax, 0, 0, 0, 0, rectangle, graphics);
                        graphics.setColor(Color.magenta.darker());
                        Tools.plotXY(Graphs.this.MAXPOINTS, Graphs.this.x, Graphs.this.wc2, Graphs.this.matricMin, 0.0, 0.0, Graphs.this.thetaMax, 0, 0, 0, 0, rectangle, graphics);
                        graphics.setColor(Color.darkGray);
                        Tools.plotXY(Graphs.this.MAXPOINTS, Graphs.this.x, Graphs.this.wc3, Graphs.this.matricMin, 0.0, 0.0, Graphs.this.thetaMax, 0, 0, 0, 0, rectangle, graphics);
                        break;
                    }
                    case 4: {
                        Tools.plotXY(Graphs.this.MAXPOINTS, Graphs.this.x, Graphs.this.wc1, Graphs.this.matricMin, 0.0, 0.0, Graphs.this.thetaMax, 0, 0, 0, 0, rectangle, graphics);
                        graphics.setColor(Color.magenta.darker());
                        Tools.plotXY(Graphs.this.MAXPOINTS, Graphs.this.x, Graphs.this.wc2, Graphs.this.matricMin, 0.0, 0.0, Graphs.this.thetaMax, 0, 0, 0, 0, rectangle, graphics);
                        graphics.setColor(Color.darkGray);
                        Tools.plotXY(Graphs.this.MAXPOINTS, Graphs.this.x, Graphs.this.wc3, Graphs.this.matricMin, 0.0, 0.0, Graphs.this.thetaMax, 0, 0, 0, 0, rectangle, graphics);
                        graphics.setColor(Color.green);
                        Tools.plotXY(Graphs.this.MAXPOINTS, Graphs.this.x, Graphs.this.wc4, Graphs.this.matricMin, 0.0, 0.0, Graphs.this.thetaMax, 0, 0, 0, 0, rectangle, graphics);
                        break;
                    }
                    case 5: {
                        Tools.plotXY(Graphs.this.MAXPOINTS, Graphs.this.x, Graphs.this.wc1, Graphs.this.matricMin, 0.0, 0.0, Graphs.this.thetaMax, 0, 0, 0, 0, rectangle, graphics);
                        graphics.setColor(Color.magenta.darker());
                        Tools.plotXY(Graphs.this.MAXPOINTS, Graphs.this.x, Graphs.this.wc2, Graphs.this.matricMin, 0.0, 0.0, Graphs.this.thetaMax, 0, 0, 0, 0, rectangle, graphics);
                        graphics.setColor(Color.darkGray);
                        Tools.plotXY(Graphs.this.MAXPOINTS, Graphs.this.x, Graphs.this.wc3, Graphs.this.matricMin, 0.0, 0.0, Graphs.this.thetaMax, 0, 0, 0, 0, rectangle, graphics);
                        graphics.setColor(Color.green);
                        Tools.plotXY(Graphs.this.MAXPOINTS, Graphs.this.x, Graphs.this.wc4, Graphs.this.matricMin, 0.0, 0.0, Graphs.this.thetaMax, 0, 0, 0, 0, rectangle, graphics);
                        graphics.setColor(Color.red);
                        Tools.plotXY(Graphs.this.MAXPOINTS, Graphs.this.x, Graphs.this.wc5, Graphs.this.matricMin, 0.0, 0.0, Graphs.this.thetaMax, 0, 0, 0, 0, rectangle, graphics);
                    }
                }
            }
        }
    }

    class buttonPanel
    extends JPanel {
        public buttonPanel() {
            this.setLayout(null);
            this.setPreferredSize(new Dimension(500, 115));
            Graphs.this.bClose = new JButton("Close");
            Graphs.this.bClose.setForeground(Color.darkGray);
            Graphs.this.bClose.setBounds(185, 70, 80, 30);
            Graphs.this.bClose.addActionListener(new forEvent("Close"));
            this.add(Graphs.this.bClose);
            Graphs.this.bClose.addMouseListener(new bntMouseListener());
            Graphs.this.oldBorder = Graphs.this.bClose.getBorder();
            Graphs.this.bPrint = new JButton("Print");
            Graphs.this.bPrint.setForeground(Color.darkGray);
            Graphs.this.bPrint.setBounds(270, 70, 80, 30);
            Graphs.this.bPrint.addActionListener(new forEvent("Print"));
            this.add(Graphs.this.bPrint);
            Graphs.this.bPrint.addMouseListener(new bntMouseListener());
            this.setToolTipText("Click the cyan rectangle to adjust matric potential");
            if (Graphs.this.s.nHorizons > 1) {
                Graphs.this.lLegend.setBounds(360, 5, 55, 25);
                Graphs.this.lLegend.setForeground(Color.darkGray);
                this.add(Graphs.this.lLegend);
                switch (Graphs.this.s.nHorizons) {
                    case 2: {
                        Graphs.this.lLayer1.setForeground(Color.blue);
                        Graphs.this.lLayer1.setFont(RichardsEqn.comboBoxFont);
                        Graphs.this.lLayer1.setBounds(360, 30, 80, 12);
                        this.add(Graphs.this.lLayer1);
                        Graphs.this.lLayer2.setForeground(Color.magenta.darker());
                        Graphs.this.lLayer2.setFont(RichardsEqn.comboBoxFont);
                        Graphs.this.lLayer2.setBounds(360, 42, 80, 12);
                        this.add(Graphs.this.lLayer2);
                        break;
                    }
                    case 3: {
                        Graphs.this.lLayer1.setForeground(Color.blue);
                        Graphs.this.lLayer1.setFont(RichardsEqn.comboBoxFont);
                        Graphs.this.lLayer1.setBounds(360, 30, 80, 12);
                        this.add(Graphs.this.lLayer1);
                        Graphs.this.lLayer2.setForeground(Color.magenta.darker());
                        Graphs.this.lLayer2.setFont(RichardsEqn.comboBoxFont);
                        Graphs.this.lLayer2.setBounds(360, 42, 80, 12);
                        this.add(Graphs.this.lLayer2);
                        Graphs.this.lLayer3.setForeground(Color.darkGray);
                        Graphs.this.lLayer3.setFont(RichardsEqn.comboBoxFont);
                        Graphs.this.lLayer3.setBounds(360, 54, 80, 12);
                        this.add(Graphs.this.lLayer3);
                        break;
                    }
                    case 4: {
                        Graphs.this.lLayer1.setForeground(Color.blue);
                        Graphs.this.lLayer1.setFont(RichardsEqn.comboBoxFont);
                        Graphs.this.lLayer1.setBounds(360, 30, 80, 12);
                        this.add(Graphs.this.lLayer1);
                        Graphs.this.lLayer2.setForeground(Color.magenta.darker());
                        Graphs.this.lLayer2.setFont(RichardsEqn.comboBoxFont);
                        Graphs.this.lLayer2.setBounds(360, 42, 80, 12);
                        this.add(Graphs.this.lLayer2);
                        Graphs.this.lLayer3.setForeground(Color.darkGray);
                        Graphs.this.lLayer3.setFont(RichardsEqn.comboBoxFont);
                        Graphs.this.lLayer3.setBounds(360, 54, 80, 12);
                        this.add(Graphs.this.lLayer3);
                        Graphs.this.lLayer4.setForeground(Color.green);
                        Graphs.this.lLayer4.setFont(RichardsEqn.comboBoxFont);
                        Graphs.this.lLayer4.setBounds(360, 66, 80, 12);
                        this.add(Graphs.this.lLayer4);
                        break;
                    }
                    case 5: {
                        Graphs.this.lLayer1.setForeground(Color.blue);
                        Graphs.this.lLayer1.setFont(RichardsEqn.comboBoxFont);
                        Graphs.this.lLayer1.setBounds(360, 30, 80, 12);
                        this.add(Graphs.this.lLayer1);
                        Graphs.this.lLayer2.setForeground(Color.magenta.darker());
                        Graphs.this.lLayer2.setFont(RichardsEqn.comboBoxFont);
                        Graphs.this.lLayer2.setBounds(360, 42, 80, 12);
                        this.add(Graphs.this.lLayer2);
                        Graphs.this.lLayer3.setForeground(Color.darkGray);
                        Graphs.this.lLayer3.setFont(RichardsEqn.comboBoxFont);
                        Graphs.this.lLayer3.setBounds(360, 54, 80, 12);
                        this.add(Graphs.this.lLayer3);
                        Graphs.this.lLayer4.setForeground(Color.green);
                        Graphs.this.lLayer4.setFont(RichardsEqn.comboBoxFont);
                        Graphs.this.lLayer4.setBounds(360, 66, 80, 12);
                        this.add(Graphs.this.lLayer4);
                        Graphs.this.lLayer5.setForeground(Color.red);
                        Graphs.this.lLayer5.setFont(RichardsEqn.comboBoxFont);
                        Graphs.this.lLayer5.setBounds(360, 78, 80, 12);
                        this.add(Graphs.this.lLayer5);
                    }
                }
            }
        }
    }

    class typePanel
    extends JPanel {
        public typePanel() {
            Vector<String> vector = new Vector<String>(5);
            vector.addElement("Conductivity vs Matric Potential");
            vector.addElement("Water Content vs Matric Potential");
            Graphs.this.chType = new JComboBox(vector);
            Graphs.this.chType.setForeground(Color.darkGray);
            Graphs.this.chType.setSelectedIndex(Graphs.this.selectedGraphIndex);
            this.setLayout(null);
            this.setPreferredSize(new Dimension(500, 30));
            Graphs.this.chType.setBounds(120, 8, 250, 22);
            this.add(Graphs.this.chType);
            Graphs.this.chType.addItemListener(new forEvent("chType"));
        }
    }
}

