/*
 * Decompiled with CFR 0.152.
 */
public class Horizon {
    double depthTop;
    double depthBottom;
    double bulkDensity;
    double oc;
    Conductivity k;
    WaterContent wc;

    public Horizon(double d, double d2, double d3, double d4, WaterContent waterContent, Conductivity conductivity) {
        this.depthTop = d;
        this.depthBottom = d2;
        this.bulkDensity = d3;
        this.oc = d4;
        this.k = conductivity;
        this.wc = waterContent;
    }

    public Horizon(double d, double d2, WaterContent waterContent, Conductivity conductivity) {
        this(d, d2, (1.0 - waterContent.getSatWC()) * 2.65, 0.0, waterContent, conductivity);
    }

    public Horizon(double d, WaterContent waterContent, Conductivity conductivity) {
        this(0.0, d, waterContent, conductivity);
    }

    public double getLength() {
        return this.depthBottom - this.depthTop;
    }

    public double getK(double d) {
        if (Double.isNaN(d)) {
            return d;
        }
        return d < 0.0 ? this.k.getK(d) : this.k.getSatK();
    }

    public double getSatK() {
        return this.k.getSatK();
    }

    public double getBulkDensity() {
        return this.bulkDensity;
    }

    public double getOC() {
        return this.oc;
    }

    public double getWaterContent(double d) {
        if (Double.isNaN(d)) {
            return d;
        }
        return d < 0.0 ? this.wc.getWC(d) : this.wc.getSatWC();
    }

    public void setConductivity(Conductivity conductivity) {
        this.k = conductivity;
    }

    public void setWaterContent(WaterContent waterContent) {
        this.wc = waterContent;
    }

    public void setLength(double d) {
        this.depthTop = 0.0;
        this.depthBottom = d;
    }

    public void setLength(double d, double d2) {
        this.depthTop = d;
        this.depthBottom = d2;
    }

    public void setBulkDensity(double d) {
        this.bulkDensity = d;
    }

    public void setOC(double d) {
        this.oc = d;
    }

    public Horizon duplicate() {
        Conductivity conductivity = this.k instanceof GardnerConductivity ? new GardnerConductivity(this.k.getParamValue(3), this.k.getParamValue(1), this.k.getParamValue(2), this.k.getEquationImage()) : (this.k instanceof BrooksConductivity ? new BrooksConductivity(this.k.getParamValue(3), this.k.getParamValue(1), this.k.getParamValue(2), this.k.getEquationImage()) : new VanGenuchtenConductivity(this.k.getParamValue(3), this.k.getParamValue(1), this.k.getParamValue(2), this.k.getEquationImage()));
        WaterContent waterContent = this.wc instanceof SimmonsWaterContent ? new SimmonsWaterContent(this.wc.getParamValue(3), this.wc.getParamValue(4), this.wc.getParamValue(1), this.wc.getParamValue(2), this.wc.getEquationImage()) : (this.wc instanceof BrooksWaterContent ? new BrooksWaterContent(this.wc.getParamValue(3), this.wc.getParamValue(4), this.wc.getParamValue(1), this.wc.getParamValue(2), this.wc.getEquationImage()) : new VanGenuchtenWaterContent(this.wc.getParamValue(3), this.wc.getParamValue(4), this.wc.getParamValue(1), this.wc.getParamValue(2), this.wc.getEquationImage()));
        return new Horizon(this.depthTop, this.depthBottom, this.bulkDensity, this.oc, waterContent, conductivity);
    }

    public String displayHorizon() {
        String string = this.k instanceof GardnerConductivity ? new String("GardnerConductivity(" + this.k.getParamValue(3) + ", " + this.k.getParamValue(1) + ", " + this.k.getParamValue(2) + ")") : (this.k instanceof BrooksConductivity ? new String("BrooksConductivity(" + this.k.getParamValue(3) + ", " + this.k.getParamValue(1) + ", " + this.k.getParamValue(2) + ")") : new String("VanGenuchtenConductivity(" + this.k.getParamValue(3) + ", " + this.k.getParamValue(1) + ", " + this.k.getParamValue(2) + ")"));
        String string2 = this.wc instanceof SimmonsWaterContent ? new String("SimmonsWaterContent(" + this.wc.getParamValue(3) + ", " + this.wc.getParamValue(4) + ", " + this.wc.getParamValue(1) + ", " + this.wc.getParamValue(2) + ")") : (this.wc instanceof BrooksWaterContent ? new String("BrooksWaterContent(" + this.wc.getParamValue(3) + ", " + this.wc.getParamValue(4) + ", " + this.wc.getParamValue(1) + ", " + this.wc.getParamValue(2) + ")") : new String("VanGenuchtenWaterContent(" + this.wc.getParamValue(3) + ", " + this.wc.getParamValue(4) + ", " + this.wc.getParamValue(1) + ", " + this.wc.getParamValue(2) + ")"));
        return "Horizon(" + this.depthTop + ", " + this.depthBottom + ", " + this.bulkDensity + ", " + this.oc + ", " + string2 + ", " + string + ")";
    }
}

