/*
 * Decompiled with CFR 0.152.
 */
public class InitialCondition {
    public double[] x;
    public double[] h;
    public double[] c;
    public boolean isFinite;
    public boolean simChemical;
    public boolean isTotalConcentration;

    public InitialCondition(double[] dArray, double[] dArray2, double[] dArray3) {
        this.x = dArray;
        this.h = dArray2;
        this.c = dArray3;
        this.isFinite = true;
        this.simChemical = true;
    }

    public InitialCondition(double[] dArray, double[] dArray2) {
        this.x = dArray;
        this.h = dArray2;
        this.isFinite = true;
        this.simChemical = false;
        this.isTotalConcentration = false;
    }

    public InitialCondition(double d, double d2, boolean bl) {
        this.x = new double[1];
        this.h = new double[1];
        this.c = new double[1];
        this.x[0] = 0.0;
        this.h[0] = d;
        this.c[0] = d2;
        this.isFinite = bl;
        this.simChemical = true;
    }

    public InitialCondition(double[] dArray, double[] dArray2, double d, boolean bl) {
        this.x = dArray;
        this.h = dArray2;
        this.c = new double[this.x.length];
        int n = 0;
        while (n < this.x.length) {
            this.c[n] = d;
            ++n;
        }
        this.isFinite = bl;
        this.simChemical = true;
    }

    public InitialCondition(double d, boolean bl) {
        this.x = new double[1];
        this.h = new double[1];
        this.x[0] = 0.0;
        this.h[0] = d;
        this.isFinite = bl;
        this.simChemical = false;
        this.isTotalConcentration = false;
    }

    public InitialCondition(double[] dArray, double[] dArray2, boolean bl) {
        this.x = dArray;
        this.h = dArray2;
        this.isFinite = bl;
        this.simChemical = false;
        this.isTotalConcentration = false;
    }

    public void setIsTotalConcentration(boolean bl) {
        this.isTotalConcentration = bl;
    }

    public double[] getInitialPotentialArray(double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray2[n2] = Tools.linearInterpolateY(dArray[n2], this.x, this.h);
            ++n2;
        }
        return dArray2;
    }

    public double[] getInitialConcentrationArray(double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray2[n2] = Tools.linearInterpolateY(dArray[n2], this.x, this.c);
            ++n2;
        }
        return dArray2;
    }

    public double[] getInitConcenArrayFromTotalConcentration(double[] dArray, Soil soil, TransportProperties transportProperties) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        double[] dArray3 = transportProperties.getKdArray(dArray, soil);
        int n2 = 0;
        while (n2 < n) {
            double d = Tools.linearInterpolateY(dArray[n2], this.x, this.h);
            double d2 = Tools.linearInterpolateY(dArray[n2], this.x, this.c);
            double d3 = Double.parseDouble(Tools.formatDouble(soil.horizon[soil.getHorizonIndex((double)dArray[n2])].wc.getWC(d) + 5.0E-6, 5, 5));
            double d4 = soil.horizon[soil.getHorizonIndex(dArray[n2])].getBulkDensity();
            dArray2[n2] = d2 / (d3 + d4 * dArray3[n2]);
            ++n2;
        }
        return dArray2;
    }
}

