/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;

public class InitialConditionPanel
extends ChemfloPanel {
    public JScrollBar sbrInitialCond;
    public JTextField tfInitialCond;
    private JLabel lInitialCond;
    public JComboBox choiceInitialCond;
    private Vector choiceInitialCondNames;
    public JScrollBar sbrInitialCond2;
    public JTextField tfInitialCond2;
    public JLabel lInitialCond2;
    public JComboBox choiceInitialCond2;
    private Vector choiceInitialCondNames2;
    private JButton clearBnt;
    private JButton sortBnt;
    private Border oldBorder;
    private BevelBorder raisedEdge = new BevelBorder(0);
    public InitialConditionTable initTable;
    boolean errorFree = true;
    boolean noChemical = true;
    private boolean hasTable = false;
    TablePanel tablePane;
    JPanel topPane;
    UpPanel upPane;
    private Object[][] data;
    private Object[][] old_data;
    private double savedWc;
    private JPanel prePane;
    private JPanel rootPane;
    private int wid = 0;
    private int hgh = 0;
    private JPanel northP;
    private JPanel southP;
    private JPanel westP;
    private JPanel eastP;

    public InitialConditionPanel() {
        super("Define Initial Conditions of Soil System");
        this.setLayout(this.border);
        this.setBorder(this.edge);
        this.add((Component)this.titleP, "North");
        if (CHEMFLO.wMax) {
            this.wid = CHEMFLO.old_width - 220;
            this.hgh = CHEMFLO.old_height - 140;
        } else {
            this.wid = 580;
            this.hgh = 470;
        }
        this.rootPane = new JPanel();
        this.rootPane.setLayout(new BorderLayout());
        this.rootPane.setPreferredSize(new Dimension(this.wid, this.hgh));
        this.northP = new JPanel();
        this.northP.setPreferredSize(new Dimension(this.wid, 1));
        this.southP = new JPanel();
        this.southP.setPreferredSize(new Dimension(this.wid, 1));
        this.westP = new JPanel();
        this.westP.setPreferredSize(new Dimension(1, 450));
        this.eastP = new JPanel();
        this.eastP.setPreferredSize(new Dimension(1, 450));
        this.prePane = new JPanel();
        this.prePane.setLayout(new BorderLayout());
        this.prePane.setPreferredSize(new Dimension(this.wid - 2, this.hgh - 2));
        this.topPane = new JPanel();
        this.topPane.setLayout(new BoxLayout(this.topPane, 1));
        this.upPane = new UpPanel();
        this.tablePane = new TablePanel();
        this.topPane.add(this.upPane);
        this.topPane.add(this.tablePane);
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(80, 540));
        jPanel.setLayout(null);
        this.clearBnt = new JButton("Clear");
        this.clearBnt.setBounds(2, 270, 65, 30);
        this.clearBnt.setFont(RichardsEqn.comboBoxFont);
        jPanel.add(this.clearBnt);
        this.sortBnt = new JButton("Sort");
        this.sortBnt.setBounds(2, 320, 65, 30);
        this.sortBnt.setFont(RichardsEqn.comboBoxFont);
        jPanel.add(this.sortBnt);
        this.clearBnt.addActionListener(new forEvent("Clear"));
        this.sortBnt.addActionListener(new forEvent("Sort"));
        bntMouseListener bntMouseListener2 = new bntMouseListener();
        this.clearBnt.addMouseListener(bntMouseListener2);
        this.sortBnt.addMouseListener(bntMouseListener2);
        this.oldBorder = this.clearBnt.getBorder();
        this.prePane.add((Component)jPanel, "East");
        this.prePane.add((Component)this.topPane, "Center");
        this.rootPane.add((Component)this.northP, "North");
        this.rootPane.add((Component)this.westP, "West");
        this.rootPane.add((Component)this.prePane, "Center");
        this.rootPane.add((Component)this.eastP, "East");
        this.rootPane.add((Component)this.southP, "South");
        this.add((Component)this.rootPane, "Center");
        this.addMouseListener(new forEvent(" "));
        this.hiddenComponents(true);
    }

    public void updateTableChemCond() {
        this.tableErrorFree();
        if (RichardsEqn.selectedInitialCond2 == 1 || RichardsEqn.selectedInitialCond2 == 2) {
            this.initTable.setCursor(Cursor.getPredefinedCursor(3));
            this.initTable.prepareTableBeforeSorting();
            SortingTable sortingTable = new SortingTable(this.initTable.data, 0);
            this.initTable.data = sortingTable.SortTable2();
            int n = 0;
            while (n < this.initTable.data.length) {
                this.initTable.data[n][3] = this.tfInitialCond2.getText().toString();
                ++n;
            }
            this.initTable.restoreTableAfterSorting(this.initTable.data);
            this.initTable.setCursor(Cursor.getPredefinedCursor(0));
            this.initTable.table.repaint();
            RichardsEqn.restart = true;
        }
    }

    public void updateTableInitialCond() {
        this.tableErrorFree();
        this.initTable.setCursor(Cursor.getPredefinedCursor(3));
        this.initTable.prepareTableBeforeSorting();
        SortingTable sortingTable = new SortingTable(this.initTable.data, 0);
        this.initTable.data = sortingTable.SortTable2();
        switch (RichardsEqn.selectedInitialCond) {
            case 0: {
                int n = 0;
                while (n < this.initTable.data.length) {
                    double d = Double.parseDouble(this.tfInitialCond.getText());
                    double d2 = Double.parseDouble((String)this.initTable.data[n][0]);
                    this.initTable.data[n][1] = this.tfInitialCond.getText().toString();
                    this.initTable.data[n][2] = String.valueOf(Tools.formatDouble(RichardsEqn.editingSoil.horizon[RichardsEqn.editingSoil.getHorizonIndex((double)d2)].wc.getWC(d) + 5.0E-6, 5, 5));
                    ++n;
                }
                break;
            }
            case 1: {
                int n = 0;
                while (n < this.initTable.data.length) {
                    double d = Double.parseDouble(this.tfInitialCond.getText());
                    double d3 = Double.parseDouble((String)this.initTable.data[n][0]);
                    this.initTable.data[n][2] = this.tfInitialCond.getText().toString();
                    double d4 = RichardsEqn.editingSoil.horizon[RichardsEqn.editingSoil.getHorizonIndex((double)d3)].wc.getMatricPotential(d);
                    this.initTable.data[n][1] = String.valueOf(Tools.formatDouble(d4, 1, 5));
                    ++n;
                }
                break;
            }
        }
        this.initTable.restoreTableAfterSorting(this.initTable.data);
        this.initTable.setCursor(Cursor.getPredefinedCursor(0));
        this.initTable.table.repaint();
        RichardsEqn.restart = true;
    }

    public void performed() {
        String string = "";
        JTextField jTextField = null;
        try {
            double d;
            String string2;
            switch (RichardsEqn.selectedInitialCond) {
                case 0: {
                    string2 = this.tfInitialCond.getText();
                    jTextField = this.tfInitialCond;
                    string = "Initial Condition: Invalid matric potential value";
                    double d2 = Double.parseDouble(string2);
                    d = RichardsEqn.storeLength(d2);
                    if (d < -15000.0 || d > 5000.0) {
                        throw new IllegalValueException("Initial Condition: Initial potential must be between " + RichardsEqn.formatLength(-15000.0) + " " + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + " and " + RichardsEqn.formatLength(5000.0) + " " + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + ".");
                    }
                    if (d == RichardsEqn.matricPotInitial) break;
                    RichardsEqn.matricPotInitial = d;
                    this.sbrInitialCond.setValue((int)((RichardsEqn.matricPotInitial + 10000.0) / 10.0 + 0.5));
                    RichardsEqn.matricPotInitial = d;
                    this.tfInitialCond.setText(string2);
                    if (this.hasTable && !this.initTable.isEmptyTable()) {
                        this.updateTableInitialCond();
                    }
                    RichardsEqn.restart = true;
                    break;
                }
                case 1: {
                    string2 = this.tfInitialCond.getText();
                    jTextField = this.tfInitialCond;
                    string = "Initial Condition: Invalid water content value";
                    d = Double.parseDouble(string2);
                    boolean bl = true;
                    int n = 0;
                    while (n < RichardsEqn.editingSoil.nHorizons) {
                        if (d < RichardsEqn.editingSoil.horizon[n].wc.getResidualWC() || d > RichardsEqn.editingSoil.horizon[n].wc.getSatWC()) {
                            bl = false;
                        }
                        ++n;
                    }
                    if (!bl) {
                        throw new IllegalValueException("Initial Condition: Water content is out of range for 1 or more soil layers.");
                    }
                    if (d == RichardsEqn.wcInitial) break;
                    RichardsEqn.wcInitial = d;
                    this.sbrInitialCond.setValue((int)(RichardsEqn.wcInitial * 1000.0 + 0.5));
                    RichardsEqn.wcInitial = d;
                    this.tfInitialCond.setText(string2);
                    if (this.hasTable && !this.initTable.isEmptyTable()) {
                        this.updateTableInitialCond();
                    }
                    RichardsEqn.restart = true;
                }
            }
            switch (RichardsEqn.selectedInitialCond2) {
                case 1: 
                case 2: {
                    string2 = this.tfInitialCond2.getText();
                    jTextField = this.tfInitialCond2;
                    string = "Initial Condition: Invalid chemical concentration value";
                    d = Double.parseDouble(string2);
                    if (d < 0.0 || d > 1000.0) {
                        throw new IllegalValueException("Initial Condition: Initial chemical concentration must be between 0 and 1000 g/m3.");
                    }
                    if (d == RichardsEqn.matricChemPotInitial) break;
                    RichardsEqn.matricChemPotInitial = d;
                    this.sbrInitialCond2.setValue((int)(RichardsEqn.matricChemPotInitial * 1000.0 + 0.5));
                    RichardsEqn.matricChemPotInitial = d;
                    this.tfInitialCond2.setText(Tools.formatDouble(d, 3, 3));
                    RichardsEqn.restart = true;
                }
            }
            this.errorFree = true;
        }
        catch (Exception exception) {
            RichardsEqn.errorMessage = exception instanceof IllegalValueException ? exception.getMessage() : string;
            jTextField.grabFocus();
            this.errorFree = false;
        }
    }

    public void ResetUnits() {
        double d = 0.0;
        this.choiceInitialCondNames.removeAllElements();
        if (RichardsEqn.semiInfiniteSelected) {
            this.choiceInitialCondNames.addElement("Uniform Matric Potential, (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + ")");
            this.choiceInitialCondNames.addElement("Uniform Volumetric Water Content (v/v)");
            this.choiceInitialCond.setSelectedIndex(RichardsEqn.selectedInitialCond);
        } else {
            this.choiceInitialCondNames.addElement("Uniform Matric Potential, (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + ")");
            this.choiceInitialCondNames.addElement("Uniform Volumetric Water Content (v/v)");
            this.choiceInitialCondNames.addElement("Non-uniform Conditions");
            this.choiceInitialCond.setSelectedIndex(RichardsEqn.selectedInitialCond);
        }
        int n = this.sbrInitialCond.getValue();
        switch (RichardsEqn.selectedInitialCond) {
            case 0: {
                d = RichardsEqn.matricPotInitial;
                n = 10 * n - 5000;
                RichardsEqn.matricPotInitial = n;
                this.tfInitialCond.setText(RichardsEqn.formatLength(RichardsEqn.matricPotInitial));
                break;
            }
            case 1: {
                d = RichardsEqn.wcInitial;
                RichardsEqn.wcInitial = (double)n / 1000.0;
                this.tfInitialCond.setText(Tools.formatDouble(RichardsEqn.wcInitial, 3, 3));
            }
        }
        if (this.hasTable) {
            this.initTable.setCursor(Cursor.getPredefinedCursor(3));
            this.initTable.prepareTableBeforeSorting();
            SortingTable sortingTable = new SortingTable(this.initTable.data, 0);
            this.initTable.data = sortingTable.SortTable2();
            switch (RichardsEqn.selectedInitialCond) {
                case 0: {
                    int n2 = 0;
                    while (n2 < this.initTable.data.length) {
                        double d2 = Double.parseDouble(this.tfInitialCond.getText());
                        double d3 = Double.parseDouble((String)this.initTable.data[n2][0]);
                        this.initTable.data[n2][1] = String.valueOf(d2);
                        this.initTable.data[n2][2] = String.valueOf(Tools.formatDouble(RichardsEqn.editingSoil.horizon[RichardsEqn.editingSoil.getHorizonIndex((double)d3)].wc.getWC(d2) + 5.0E-6, 5, 5));
                        ++n2;
                    }
                    break;
                }
                case 1: {
                    int n3 = 0;
                    while (n3 < this.initTable.data.length) {
                        double d4 = Double.parseDouble(this.tfInitialCond.getText());
                        this.initTable.data[n3][2] = String.valueOf(d4);
                        double d5 = Double.parseDouble((String)this.initTable.data[n3][0]);
                        double d6 = RichardsEqn.editingSoil.horizon[RichardsEqn.editingSoil.getHorizonIndex((double)d5)].wc.getMatricPotential(d4);
                        this.initTable.data[n3][1] = String.valueOf(Tools.formatDouble(d6, 1, 5));
                        ++n3;
                    }
                    break;
                }
            }
            this.initTable.restoreTableAfterSorting(this.initTable.data);
            this.initTable.setCursor(Cursor.getPredefinedCursor(0));
            this.initTable.table.repaint();
        }
        this.performed();
    }

    public void hiddenComponents(boolean bl) {
        if (bl) {
            if (this.choiceInitialCond.getSelectedIndex() == 2) {
                if (this.tablePane.getComponentCount() != 0) {
                    this.tablePane.removeAll();
                }
                this.tablePane.setPreferredSize(new Dimension(500, 300));
                this.tablePane.setLayout(null);
                if (this.choiceInitialCond2.getSelectedIndex() > 2) {
                    this.noChemical = false;
                    this.initTable = new InitialConditionTable(this.noChemical);
                    this.initTable.setBounds(15, 10, 473, 280);
                    this.tablePane.add(this.initTable);
                    this.tablePane.setVisible(true);
                    this.clearBnt.setVisible(true);
                    this.sortBnt.setVisible(true);
                    this.hasTable = true;
                } else if (this.choiceInitialCond2.getSelectedIndex() == 0) {
                    this.noChemical = true;
                    this.initTable = new InitialConditionTable(this.noChemical);
                    this.initTable.setBounds(15, 10, 473, 280);
                    this.tablePane.add(this.initTable);
                    this.tablePane.setVisible(true);
                    this.clearBnt.setVisible(true);
                    this.sortBnt.setVisible(true);
                    this.hasTable = true;
                } else {
                    this.noChemical = false;
                    this.initTable = new InitialConditionTable(this.noChemical);
                    this.initTable.setBounds(15, 10, 473, 280);
                    this.tablePane.add(this.initTable);
                    this.tablePane.setVisible(true);
                    this.clearBnt.setVisible(true);
                    this.sortBnt.setVisible(true);
                    this.hasTable = true;
                }
            } else if (this.choiceInitialCond2.getSelectedIndex() > 2) {
                if (this.tablePane.getComponentCount() != 0) {
                    this.tablePane.removeAll();
                }
                this.tablePane.setPreferredSize(new Dimension(500, 300));
                this.tablePane.setLayout(null);
                this.noChemical = false;
                this.initTable = new InitialConditionTable(this.noChemical);
                this.initTable.setBounds(15, 10, 473, 280);
                this.tablePane.add(this.initTable);
                this.tablePane.setVisible(true);
                this.clearBnt.setVisible(true);
                this.sortBnt.setVisible(true);
                this.hasTable = true;
            } else {
                this.tablePane.setVisible(false);
                this.clearBnt.setVisible(false);
                this.sortBnt.setVisible(false);
                this.hasTable = false;
            }
            if (this.hasTable) {
                this.updateSize();
            }
            this.initTable.clearTable();
        } else {
            if (this.choiceInitialCond.getSelectedIndex() == 2) {
                if (this.choiceInitialCond2.getSelectedIndex() > 2) {
                    this.tablePane.setVisible(true);
                    this.clearBnt.setVisible(true);
                    this.sortBnt.setVisible(true);
                    this.hasTable = true;
                } else if (this.choiceInitialCond2.getSelectedIndex() == 0) {
                    this.tablePane.setVisible(true);
                    this.clearBnt.setVisible(true);
                    this.sortBnt.setVisible(true);
                    this.hasTable = true;
                } else {
                    this.tablePane.setVisible(true);
                    this.clearBnt.setVisible(true);
                    this.sortBnt.setVisible(true);
                    this.hasTable = true;
                }
            } else if (this.choiceInitialCond2.getSelectedIndex() > 2) {
                this.tablePane.setVisible(true);
                this.clearBnt.setVisible(true);
                this.sortBnt.setVisible(true);
                this.hasTable = true;
            } else {
                this.tablePane.setVisible(false);
                this.clearBnt.setVisible(false);
                this.sortBnt.setVisible(false);
                this.hasTable = false;
            }
            if (this.hasTable) {
                this.updateSize();
            }
        }
    }

    public boolean tableErrorFree() {
        if (this.tablePane.isVisible()) {
            if (this.initTable.isEmptyTable()) {
                JDialog jDialog = new JDialog(new Frame(), "Warning");
                WarningMessagePanel warningMessagePanel = new WarningMessagePanel(jDialog, "Initial conditions for the flow system must  be defined before leaving this option.");
                jDialog.getContentPane().setLayout(new BorderLayout());
                jDialog.getContentPane().add((Component)warningMessagePanel, "Center");
                Toolkit toolkit = this.getToolkit();
                Dimension dimension = toolkit.getScreenSize();
                jDialog.setLocation(dimension.width - jDialog.getWidth() >> 1, dimension.height - jDialog.getHeight() >> 1);
                jDialog.show();
                return false;
            }
            if (this.checlValidTable()) {
                if (!RichardsEqn.semiInfiniteSelected) {
                    if (this.initTable.model.minPos == 0.0 && this.initTable.model.maxPos == RichardsEqn.length) {
                        return true;
                    }
                    JDialog jDialog = new JDialog(new Frame(), "Warning");
                    WarningMessagePanel warningMessagePanel = new WarningMessagePanel(jDialog, "There are errors in the initial condition table: The minimum position must be defined at 0 and the maximum position must be " + RichardsEqn.length + ".");
                    jDialog.getContentPane().setLayout(new BorderLayout());
                    jDialog.getContentPane().add((Component)warningMessagePanel, "Center");
                    Toolkit toolkit = this.getToolkit();
                    Dimension dimension = toolkit.getScreenSize();
                    jDialog.setLocation(dimension.width - jDialog.getWidth() >> 1, dimension.height - jDialog.getHeight() >> 1);
                    jDialog.show();
                    return false;
                }
                return true;
            }
            JDialog jDialog = new JDialog(new Frame(), "Warning");
            WarningMessagePanel warningMessagePanel = new WarningMessagePanel(jDialog, "Initial conditions for the flow system must be defined before leaving this option.");
            jDialog.getContentPane().setLayout(new BorderLayout());
            jDialog.getContentPane().add((Component)warningMessagePanel, "Center");
            Toolkit toolkit = this.getToolkit();
            Dimension dimension = toolkit.getScreenSize();
            jDialog.setLocation(dimension.width - jDialog.getWidth() >> 1, dimension.height - jDialog.getHeight() >> 1);
            jDialog.show();
            return false;
        }
        return true;
    }

    private boolean checlValidTable() {
        boolean bl = true;
        int n = 0;
        int n2 = this.initTable.table.getRowCount();
        int n3 = this.initTable.table.getColumnCount();
        boolean[] blArray = new boolean[n2];
        int n4 = 0;
        while (n4 < n2) {
            if (((String)this.initTable.table.getValueAt(n4, 0)).equals("")) {
                blArray[n4] = false;
            } else {
                blArray[n4] = true;
                ++n;
            }
            ++n4;
        }
        int n5 = 0;
        while (n5 < n2) {
            int n6 = 0;
            while (n6 < n3) {
                if (blArray[n5] && ((String)this.initTable.table.getValueAt(n5, n6)).equals("")) {
                    bl = false;
                    break;
                }
                ++n6;
            }
            ++n5;
        }
        if (n == 0) {
            bl = false;
        }
        return bl;
    }

    public void refresh() {
        if (RichardsEqn.semiInfiniteSelected) {
            if (RichardsEqn.selectedInitialCond == 2) {
                RichardsEqn.selectedInitialCond = 0;
                RichardsEqn.wcInitial = this.savedWc;
            }
            RichardsEqn.selectedInitialCond2 = 0;
            RichardsEqn.matricChemPotInitial = 10.0;
        }
        this.errorFree = true;
        this.noChemical = true;
        this.hasTable = false;
        if (this.topPane.getComponentCount() != 0) {
            this.topPane.removeAll();
        }
        this.upPane = new UpPanel();
        this.tablePane = new TablePanel();
        this.topPane.add(this.upPane);
        this.topPane.add(this.tablePane);
        this.hiddenComponents(true);
    }

    public void getInitialConditions() {
        if (RichardsEqn.semiInfiniteSelected) {
            return;
        }
        if (!this.tableErrorFree()) {
            return;
        }
        switch (this.choiceInitialCond2.getSelectedIndex()) {
            case 0: {
                this.getInitialCondationsI();
                break;
            }
            case 1: 
            case 2: {
                this.getInitialCondationsII();
                break;
            }
            case 3: 
            case 4: {
                this.getInitialCondationsIII();
            }
        }
    }

    void getInitialCondationsI() {
        if (this.choiceInitialCond.getSelectedIndex() == 0 || this.choiceInitialCond.getSelectedIndex() == 1) {
            if (RichardsEqn.editingSoil.horizon.length > 1) {
                this.extractUniInitCondations();
            }
            return;
        }
        this.sortingTable();
        this.data = this.initTable.data;
        this.extractInitCondations();
    }

    void getInitialCondationsII() {
        if (this.choiceInitialCond.getSelectedIndex() == 0 || this.choiceInitialCond.getSelectedIndex() == 1) {
            if (RichardsEqn.editingSoil.horizon.length > 1) {
                this.extractUniInitCondations();
            }
            return;
        }
        this.sortingTable();
        this.data = this.initTable.data;
        this.extractInitCondations2();
    }

    void getInitialCondationsIII() {
        this.sortingTable();
        this.data = this.initTable.data;
        this.extractInitCondations2();
    }

    void extractUniInitCondations() {
        int n = (int)(RichardsEqn.length / RichardsEqn.experiment.dz) + 1;
        RichardsEqn.meshPosition = new double[n];
        RichardsEqn.matricPotential = new double[n];
        RichardsEqn.meshPosition[0] = 0.0;
        int n2 = 1;
        while (n2 < n) {
            int n3 = n2;
            RichardsEqn.meshPosition[n3] = RichardsEqn.meshPosition[n3] + (double)n2 * RichardsEqn.experiment.dz;
            ++n2;
        }
        int n4 = 0;
        while (n4 < n) {
            int n5 = RichardsEqn.editingSoil.getHorizonIndex(RichardsEqn.meshPosition[n4]);
            RichardsEqn.matricPotential[n4] = RichardsEqn.editingSoil.horizon[n5].wc.getMatricPotential(RichardsEqn.wcInitial);
            ++n4;
        }
    }

    void extractInitCondations() {
        int n = this.data.length;
        int n2 = this.data[0].length;
        RichardsEqn.meshPosition = new double[n];
        RichardsEqn.matricPotential = new double[n];
        int n3 = 0;
        while (n3 < n) {
            RichardsEqn.meshPosition[n3] = Double.parseDouble((String)this.data[n3][0]);
            ++n3;
        }
        int n4 = 0;
        while (n4 < n) {
            RichardsEqn.matricPotential[n4] = Double.parseDouble((String)this.data[n4][1]);
            ++n4;
        }
        if (this.old_data != null) {
            int n5;
            if (this.old_data.length != n || this.old_data[0].length != this.data[0].length) {
                RichardsEqn.restart = true;
            } else {
                n5 = 0;
                while (n5 < n) {
                    if (!((String)this.old_data[n5][0]).trim().equals(((String)this.data[n5][0]).trim())) {
                        RichardsEqn.restart = true;
                    }
                    if (!((String)this.old_data[n5][1]).trim().equals(((String)this.data[n5][1]).trim())) {
                        RichardsEqn.restart = true;
                    }
                    ++n5;
                }
            }
            this.old_data = new Object[this.data.length][this.data[0].length];
            n5 = 0;
            while (n5 < this.data.length) {
                int n6 = 0;
                while (n6 < this.data[0].length) {
                    this.old_data[n5][n6] = new String((String)this.data[n5][n6]);
                    ++n6;
                }
                ++n5;
            }
        } else {
            this.old_data = new Object[this.data.length][this.data[0].length];
            int n7 = 0;
            while (n7 < this.data.length) {
                int n8 = 0;
                while (n8 < this.data[0].length) {
                    this.old_data[n7][n8] = new String((String)this.data[n7][n8]);
                    ++n8;
                }
                ++n7;
            }
        }
    }

    void extractInitCondations2() {
        int n = this.data.length;
        int n2 = this.data[0].length;
        RichardsEqn.meshPosition = new double[n];
        RichardsEqn.matricPotential = new double[n];
        RichardsEqn.chemConcentration = new double[n];
        int n3 = 0;
        while (n3 < n) {
            RichardsEqn.meshPosition[n3] = Double.parseDouble((String)this.data[n3][0]);
            ++n3;
        }
        int n4 = 0;
        while (n4 < n) {
            RichardsEqn.matricPotential[n4] = Double.parseDouble((String)this.data[n4][1]);
            ++n4;
        }
        int n5 = 0;
        while (n5 < n) {
            RichardsEqn.chemConcentration[n5] = Double.parseDouble((String)this.data[n5][3]);
            ++n5;
        }
        if (this.old_data != null) {
            int n6;
            if (this.old_data.length != n || this.old_data[0].length != this.data[0].length) {
                RichardsEqn.restart = true;
            } else {
                n6 = 0;
                while (n6 < n) {
                    if (!((String)this.old_data[n6][0]).trim().equals(((String)this.data[n6][0]).trim())) {
                        RichardsEqn.restart = true;
                    }
                    if (!((String)this.old_data[n6][1]).trim().equals(((String)this.data[n6][1]).trim())) {
                        RichardsEqn.restart = true;
                    }
                    if (!((String)this.old_data[n6][3]).trim().equals(((String)this.data[n6][3]).trim())) {
                        RichardsEqn.restart = true;
                    }
                    ++n6;
                }
            }
            this.old_data = new Object[this.data.length][this.data[0].length];
            n6 = 0;
            while (n6 < this.data.length) {
                int n7 = 0;
                while (n7 < this.data[0].length) {
                    this.old_data[n6][n7] = new String((String)this.data[n6][n7]);
                    ++n7;
                }
                ++n6;
            }
        } else {
            this.old_data = new Object[this.data.length][this.data[0].length];
            int n8 = 0;
            while (n8 < this.data.length) {
                int n9 = 0;
                while (n9 < this.data[0].length) {
                    this.old_data[n8][n9] = new String((String)this.data[n8][n9]);
                    ++n9;
                }
                ++n8;
            }
        }
    }

    public void prepareTableBeforeSorting() {
        int n = 0;
        int n2 = this.initTable.table.getRowCount();
        int n3 = this.initTable.table.getColumnCount();
        boolean[] blArray = new boolean[n2];
        int n4 = 0;
        while (n4 < n2) {
            if (((String)this.initTable.table.getValueAt(n4, 0)).equals("")) {
                blArray[n4] = false;
            } else {
                blArray[n4] = true;
                ++n;
            }
            ++n4;
        }
        this.data = new Object[n][n3];
        int n5 = 0;
        int n6 = 0;
        while (n6 < n2) {
            int n7 = 0;
            while (n7 < n3) {
                if (blArray[n6]) {
                    this.data[n5][n7] = this.initTable.table.getValueAt(n6, n7);
                    if (n7 == n3 - 1) {
                        ++n5;
                    }
                }
                ++n7;
            }
            ++n6;
        }
    }

    public boolean getHasTable() {
        return this.hasTable;
    }

    public void sortingTable() {
        this.initTable.setCursor(Cursor.getPredefinedCursor(3));
        this.initTable.prepareTableBeforeSorting();
        SortingTable sortingTable = new SortingTable(this.initTable.data, 0);
        this.initTable.data = sortingTable.SortTable2();
        this.initTable.restoreTableAfterSorting(this.initTable.data);
        this.initTable.setCursor(Cursor.getPredefinedCursor(0));
        this.initTable.table.repaint();
    }

    public void refreshInitTableWithSoilChanged() {
        if (!this.hasTable) {
            return;
        }
        if (this.initTable.isEmptyTable()) {
            return;
        }
        this.initTable.prepareTableBeforeSorting();
        SortingTable sortingTable = new SortingTable(this.initTable.data, 0);
        this.initTable.data = sortingTable.SortTable2();
        int n = this.initTable.data.length;
        double[] dArray = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = Double.parseDouble((String)this.initTable.data[n2][0]);
            ++n2;
        }
        switch (RichardsEqn.selectedInitialCond) {
            case 0: 
            case 3: {
                int n3 = 0;
                while (n3 < n) {
                    double d = Double.parseDouble((String)this.initTable.data[n3][1]);
                    this.initTable.data[n3][2] = String.valueOf(Tools.formatDouble(RichardsEqn.editingSoil.horizon[RichardsEqn.editingSoil.getHorizonIndex((double)dArray[n3])].wc.getWC(d) + 5.0E-6, 5, 5));
                    ++n3;
                }
                break;
            }
            case 1: {
                int n4 = 0;
                while (n4 < n) {
                    double d = Double.parseDouble((String)this.initTable.data[n4][2]);
                    double d2 = RichardsEqn.editingSoil.horizon[RichardsEqn.editingSoil.getHorizonIndex((double)dArray[n4])].wc.getMatricPotential(d);
                    this.initTable.data[n4][1] = String.valueOf(Tools.formatDouble(d2, 1, 5));
                    ++n4;
                }
                break;
            }
        }
        this.initTable.restoreTableAfterSorting(this.initTable.data);
        this.initTable.table.repaint();
    }

    public void updateSize() {
        if (CHEMFLO.wMax) {
            this.wid = CHEMFLO.old_width - 220;
            this.hgh = CHEMFLO.old_height - 140;
        } else {
            this.wid = 580;
            this.hgh = 470;
        }
        if (this.rootPane.getComponentCount() != 0) {
            this.rootPane.removeAll();
        }
        this.rootPane.setPreferredSize(new Dimension(this.wid, this.hgh));
        int n = (int)((double)(this.hgh - 470) / 3.0);
        this.northP.setPreferredSize(new Dimension(this.wid, n));
        this.southP.setPreferredSize(new Dimension(this.wid, n - 5));
        int n2 = (int)((double)(this.wid - 580) / 2.0);
        this.westP.setPreferredSize(new Dimension(n2, 470));
        this.eastP.setPreferredSize(new Dimension(n2, 470));
        this.tablePane.setPreferredSize(new Dimension(500, 300 + n));
        this.initTable.setBounds(15, 10, 473, 280 + n);
        this.clearBnt.setBounds(5, 270 + n / 2, 65, 30);
        this.sortBnt.setBounds(5, 320 + n / 2, 65, 30);
        this.rootPane.add((Component)this.northP, "North");
        this.rootPane.add((Component)this.westP, "West");
        this.rootPane.add((Component)this.prePane, "Center");
        this.rootPane.add((Component)this.eastP, "East");
        this.rootPane.add((Component)this.southP, "South");
        this.rootPane.repaint();
    }

    public Vector getInitialConditionData() {
        Vector<String> vector;
        block23: {
            int n;
            block25: {
                block26: {
                    block24: {
                        block22: {
                            vector = new Vector<String>();
                            if (!CHEMFLO.initialPane.getHasTable()) break block22;
                            StringBuffer stringBuffer = new StringBuffer();
                            StringBuffer stringBuffer2 = new StringBuffer();
                            stringBuffer.append("   Position       ");
                            stringBuffer2.append("     (cm)         ");
                            stringBuffer.append("Matric Potential  ");
                            stringBuffer2.append("     (cm)         ");
                            stringBuffer.append("Water Content     ");
                            stringBuffer2.append("  (cm3/cm3)       ");
                            if (this.initTable.colNames.length > 3) {
                                String string = this.initTable.colNames[this.initTable.colNames.length - 1];
                                string = string.substring(8 + string.indexOf("<center>"), string.indexOf("</center>"));
                                String string2 = string.substring(0, string.indexOf("<br>"));
                                String string3 = string.substring(4 + string.indexOf("<br>"));
                                stringBuffer.append("  " + string2);
                                stringBuffer2.append(string3);
                            }
                            vector.addElement(stringBuffer.toString());
                            vector.addElement(stringBuffer2.toString());
                            int n2 = this.initTable.model.getRowCount();
                            int n3 = this.initTable.model.getColumnCount();
                            int n4 = 0;
                            while (n4 < n2) {
                                stringBuffer = new StringBuffer();
                                int n5 = 0;
                                while (n5 < n3) {
                                    Object object = this.initTable.model.getValueAt(n4, n5);
                                    if (((String)object).equals("")) break;
                                    stringBuffer.append(object.toString() + "           ");
                                    ++n5;
                                }
                                if (stringBuffer.length() != 0) {
                                    vector.addElement(stringBuffer.toString());
                                }
                                ++n4;
                            }
                            break block23;
                        }
                        vector.addElement(this.lInitialCond.getText() + ": ");
                        if (!RichardsEqn.semiInfiniteSelected) break block24;
                        switch (RichardsEqn.selectedInitialCond) {
                            case 0: {
                                vector.addElement(new String("Uniform Matric Potential                  " + RichardsEqn.matricPotInitial + " " + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit]));
                                vector.addElement(new String("Corresponding Water Content               " + Tools.formatDouble(RichardsEqn.editingSoil.horizon[0].wc.getWC(RichardsEqn.matricPotInitial) + 5.0E-6, 5, 5) + " (m3/m3)"));
                                break;
                            }
                            case 1: {
                                vector.addElement(new String("Uniform Water Content                     " + RichardsEqn.wcInitial + " (m3/m3)"));
                                double d = RichardsEqn.editingSoil.horizon[0].wc.getMatricPotential(RichardsEqn.wcInitial);
                                vector.addElement(new String("Corresponding Matric Potential            " + String.valueOf(Tools.formatDouble(d, 1, 5)) + " " + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit]));
                            }
                        }
                        break block25;
                    }
                    if (RichardsEqn.editingSoil.nHorizons <= 1) break block26;
                    vector.addElement(new String("Layer        Matric Potential (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + ")        " + "Water Content " + "(cm3/cm3)"));
                    switch (RichardsEqn.selectedInitialCond) {
                        case 0: {
                            int n6 = 0;
                            while (n6 < RichardsEqn.editingSoil.nHorizons) {
                                vector.addElement(new String(Integer.toString(n6 + 1) + "              " + Tools.formatDouble(RichardsEqn.matricPotInitial, 1, 8) + "                        " + Tools.formatDouble(RichardsEqn.editingSoil.horizon[n6].wc.getWC(RichardsEqn.matricPotInitial) + 5.0E-6, 5, 5)));
                                ++n6;
                            }
                            break block25;
                        }
                        case 1: {
                            n = 0;
                            while (n < RichardsEqn.editingSoil.nHorizons) {
                                double d = RichardsEqn.editingSoil.horizon[n].wc.getMatricPotential(RichardsEqn.wcInitial);
                                vector.addElement(new String(Integer.toString(n + 1) + "              " + String.valueOf(Tools.formatDouble(d, 1, 8))) + "                        " + RichardsEqn.wcInitial);
                                ++n;
                            }
                            break block25;
                        }
                    }
                    break block25;
                }
                switch (RichardsEqn.selectedInitialCond) {
                    case 0: {
                        vector.addElement(new String("Uniform Matric Potential                  " + RichardsEqn.matricPotInitial + " " + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit]));
                        vector.addElement(new String("Corresponding Water Content               " + Tools.formatDouble(RichardsEqn.editingSoil.horizon[0].wc.getWC(RichardsEqn.matricPotInitial) + 5.0E-6, 5, 5) + " (m3/m3)"));
                        break;
                    }
                    case 1: {
                        vector.addElement(new String("Uniform Water Content                     " + RichardsEqn.wcInitial + " (m3/m3)"));
                        double d = RichardsEqn.editingSoil.horizon[0].wc.getMatricPotential(RichardsEqn.wcInitial);
                        vector.addElement(new String("Corresponding Matric Potential            " + String.valueOf(Tools.formatDouble(d, 1, 5)) + " " + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit]));
                    }
                }
            }
            if (!RichardsEqn.semiInfiniteSelected) {
                vector.addElement(this.lInitialCond2.getText() + ":");
                if (RichardsEqn.selectedInitialCond2 == 1 || RichardsEqn.selectedInitialCond2 == 2) {
                    String string = this.choiceInitialCond2.getSelectedItem().toString();
                    n = 42 - string.substring(0, string.indexOf(40)).length();
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(string.substring(0, string.indexOf(40)));
                    int n7 = 0;
                    while (n7 < n) {
                        stringBuffer.append(" ");
                        ++n7;
                    }
                    vector.addElement(stringBuffer.toString() + RichardsEqn.matricChemPotInitial + " " + string.substring(string.indexOf(40), string.length()));
                } else {
                    vector.addElement(this.choiceInitialCond2.getSelectedItem().toString());
                }
            }
        }
        return vector;
    }

    class bntMouseListener
    extends MouseAdapter {
        bntMouseListener() {
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (InitialConditionPanel.this.clearBnt == (JButton)mouseEvent.getSource()) {
                InitialConditionPanel.this.clearBnt.setBorder(InitialConditionPanel.this.oldBorder);
            }
            if (InitialConditionPanel.this.sortBnt == (JButton)mouseEvent.getSource()) {
                InitialConditionPanel.this.sortBnt.setBorder(InitialConditionPanel.this.oldBorder);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (InitialConditionPanel.this.clearBnt == (JButton)mouseEvent.getSource()) {
                InitialConditionPanel.this.clearBnt.setBorder(InitialConditionPanel.this.raisedEdge);
            }
            if (InitialConditionPanel.this.sortBnt == (JButton)mouseEvent.getSource()) {
                InitialConditionPanel.this.sortBnt.setBorder(InitialConditionPanel.this.raisedEdge);
                if (InitialConditionPanel.this.hasTable) {
                    InitialConditionPanel.this.initTable.checkTableData();
                }
                InitialConditionPanel.this.performed();
                if (!InitialConditionPanel.this.errorFree) {
                    JOptionPane.showMessageDialog(CHEMFLO.appWin, RichardsEqn.errorMessage, "Error", 0);
                    CHEMFLO.appWin.repaint();
                }
            }
        }
    }

    class forEvent
    extends MouseAdapter
    implements AdjustmentListener,
    ActionListener,
    ItemListener {
        int iTemp;
        double dTemp;
        String name;

        public forEvent(String string) {
            this.name = string;
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            if (this.name.equals("InitialCond")) {
                switch (RichardsEqn.selectedInitialCond) {
                    case 0: {
                        this.iTemp = InitialConditionPanel.this.sbrInitialCond.getValue();
                        this.dTemp = RichardsEqn.matricPotInitial;
                        this.iTemp = 10 * this.iTemp - 10000;
                        RichardsEqn.matricPotInitial = this.iTemp;
                        InitialConditionPanel.this.tfInitialCond.setText(RichardsEqn.formatLength(RichardsEqn.matricPotInitial));
                        if (this.dTemp == RichardsEqn.matricPotInitial) break;
                        RichardsEqn.restart = true;
                        break;
                    }
                    case 1: {
                        this.iTemp = InitialConditionPanel.this.sbrInitialCond.getValue();
                        this.dTemp = RichardsEqn.wcInitial;
                        RichardsEqn.wcInitial = (double)this.iTemp / 1000.0;
                        InitialConditionPanel.this.tfInitialCond.setText(Tools.formatDouble(RichardsEqn.wcInitial, 3, 3));
                        if (this.dTemp == RichardsEqn.wcInitial) break;
                        RichardsEqn.restart = true;
                    }
                }
                InitialConditionPanel.this.performed();
                if (!InitialConditionPanel.this.errorFree) {
                    new ErrorMessageDialog("Error", RichardsEqn.errorMessage);
                    return;
                }
                if (InitialConditionPanel.this.hasTable && !InitialConditionPanel.this.initTable.isEmptyTable()) {
                    InitialConditionPanel.this.updateTableInitialCond();
                }
            } else if (this.name.equals("InitialCond2")) {
                if (RichardsEqn.selectedInitialCond2 == 1 || RichardsEqn.selectedInitialCond2 == 2) {
                    this.iTemp = InitialConditionPanel.this.sbrInitialCond2.getValue();
                    RichardsEqn.matricChemPotInitial = (double)this.iTemp / 1000.0;
                    InitialConditionPanel.this.tfInitialCond2.setText(Tools.formatDouble(RichardsEqn.matricChemPotInitial, 3, 3));
                    RichardsEqn.restart = true;
                    RichardsEqn.newBC0 = true;
                }
                InitialConditionPanel.this.performed();
                if (!InitialConditionPanel.this.errorFree) {
                    new ErrorMessageDialog("Error", RichardsEqn.errorMessage);
                    return;
                }
                if (InitialConditionPanel.this.hasTable && !InitialConditionPanel.this.initTable.isEmptyTable()) {
                    InitialConditionPanel.this.updateTableChemCond();
                }
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            int n;
            if (this.name.equals("InitialCond") && RichardsEqn.selectedInitialCond != InitialConditionPanel.this.choiceInitialCond.getSelectedIndex()) {
                RichardsEqn.restart = true;
                RichardsEqn.selectedInitialCond = InitialConditionPanel.this.choiceInitialCond.getSelectedIndex();
                InitialConditionPanel.this.tfInitialCond.setVisible(true);
                InitialConditionPanel.this.sbrInitialCond.setVisible(true);
                switch (RichardsEqn.selectedInitialCond) {
                    case 0: {
                        n = (int)((RichardsEqn.matricPotInitial + 10000.0) / 10.0);
                        DefaultBoundedRangeModel defaultBoundedRangeModel = new DefaultBoundedRangeModel(n, 0, 0, 1010);
                        InitialConditionPanel.this.sbrInitialCond.setModel(defaultBoundedRangeModel);
                        InitialConditionPanel.this.tfInitialCond.setText(RichardsEqn.formatLength(RichardsEqn.matricPotInitial));
                        break;
                    }
                    case 1: {
                        int n2 = 1000;
                        int n3 = 0;
                        int n4 = 0;
                        while (n4 < RichardsEqn.editingSoil.nHorizons) {
                            if ((int)(1000.0 * RichardsEqn.editingSoil.horizon[n4].wc.getSatWC()) < n2) {
                                n2 = (int)(1000.0 * RichardsEqn.editingSoil.horizon[n4].wc.getSatWC());
                            }
                            if ((int)(1000.0 * RichardsEqn.editingSoil.horizon[n4].wc.getResidualWC() + 0.5) > n3) {
                                n3 = (int)(1000.0 * RichardsEqn.editingSoil.horizon[n4].wc.getResidualWC() + 0.5);
                            }
                            ++n4;
                        }
                        if (RichardsEqn.wcInitial > (double)n2 / 1000.0) {
                            RichardsEqn.wcInitial = (double)n2 / 1000.0;
                        }
                        if (RichardsEqn.wcInitial < (double)n3 / 1000.0) {
                            RichardsEqn.wcInitial = (double)n3 / 1000.0;
                        }
                        InitialConditionPanel.this.tfInitialCond.setText(Tools.formatDouble(RichardsEqn.wcInitial, 3, 3));
                        int n5 = (int)(1000.0 * RichardsEqn.wcInitial + 0.5);
                        DefaultBoundedRangeModel defaultBoundedRangeModel = new DefaultBoundedRangeModel(n5, 0, n3, n2);
                        InitialConditionPanel.this.sbrInitialCond.setModel(defaultBoundedRangeModel);
                        break;
                    }
                    case 2: {
                        InitialConditionPanel.this.tfInitialCond.setVisible(false);
                        InitialConditionPanel.this.sbrInitialCond.setVisible(false);
                    }
                }
            }
            if (this.name.equals("InitialCond2")) {
                n = RichardsEqn.selectedInitialCond2;
                if (RichardsEqn.selectedInitialCond2 != InitialConditionPanel.this.choiceInitialCond2.getSelectedIndex()) {
                    RichardsEqn.restart = true;
                    RichardsEqn.selectedInitialCond2 = InitialConditionPanel.this.choiceInitialCond2.getSelectedIndex();
                    InitialConditionPanel.this.tfInitialCond2.setVisible(true);
                    InitialConditionPanel.this.sbrInitialCond2.setVisible(true);
                    switch (RichardsEqn.selectedInitialCond2) {
                        case 0: {
                            InitialConditionPanel.this.tfInitialCond2.setVisible(false);
                            InitialConditionPanel.this.sbrInitialCond2.setVisible(false);
                            InitialConditionPanel.this.performed();
                            break;
                        }
                        case 1: 
                        case 2: {
                            int n6 = (int)(RichardsEqn.matricChemPotInitial * 1000.0 + 0.5);
                            DefaultBoundedRangeModel defaultBoundedRangeModel = new DefaultBoundedRangeModel(n6, 0, 0, 1000000);
                            InitialConditionPanel.this.sbrInitialCond2.setModel(defaultBoundedRangeModel);
                            InitialConditionPanel.this.tfInitialCond2.setText(Tools.formatDouble(RichardsEqn.matricChemPotInitial, 3, 3));
                            InitialConditionPanel.this.performed();
                            break;
                        }
                        case 3: 
                        case 4: {
                            InitialConditionPanel.this.tfInitialCond2.setVisible(false);
                            InitialConditionPanel.this.sbrInitialCond2.setVisible(false);
                            InitialConditionPanel.this.performed();
                        }
                    }
                }
                if (n <= 0 || RichardsEqn.selectedInitialCond2 <= 0) {
                    CHEMFLO.transProperty.refresh();
                }
            }
            InitialConditionPanel.this.hiddenComponents(true);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.name.equals("Clear")) {
                InitialConditionPanel.this.initTable.clearTable();
                return;
            }
            if (this.name.equals("Sort")) {
                if (!InitialConditionPanel.this.tableErrorFree()) {
                    return;
                }
                InitialConditionPanel.this.sortingTable();
                return;
            }
            if (this.name.equals("InitialCond")) {
                if (!InitialConditionPanel.this.hasTable) {
                    InitialConditionPanel.this.performed();
                    if (InitialConditionPanel.this.errorFree) return;
                    JOptionPane.showMessageDialog(CHEMFLO.appWin, RichardsEqn.errorMessage, "Error", 0);
                    CHEMFLO.appWin.repaint();
                    return;
                }
                if (InitialConditionPanel.this.initTable.isEmptyTable()) {
                    InitialConditionPanel.this.performed();
                    if (InitialConditionPanel.this.errorFree) return;
                    JOptionPane.showMessageDialog(CHEMFLO.appWin, RichardsEqn.errorMessage, "Error", 0);
                    CHEMFLO.appWin.repaint();
                    return;
                }
                if (!InitialConditionPanel.this.tableErrorFree()) {
                    JOptionPane.showMessageDialog(CHEMFLO.appWin, "Error in initial condition table", "Error", 0);
                    CHEMFLO.appWin.repaint();
                    return;
                }
                InitialConditionPanel.this.performed();
                if (InitialConditionPanel.this.errorFree) {
                    InitialConditionPanel.this.updateTableInitialCond();
                    return;
                }
                JOptionPane.showMessageDialog(CHEMFLO.appWin, RichardsEqn.errorMessage, "Error", 0);
                CHEMFLO.appWin.repaint();
                return;
            }
            if (!this.name.equals("InitialCond2")) return;
            if (!InitialConditionPanel.this.hasTable) {
                InitialConditionPanel.this.performed();
                if (InitialConditionPanel.this.errorFree) return;
                JOptionPane.showMessageDialog(CHEMFLO.appWin, RichardsEqn.errorMessage, "Error", 0);
                CHEMFLO.appWin.repaint();
                return;
            }
            if (InitialConditionPanel.this.initTable.isEmptyTable()) {
                InitialConditionPanel.this.performed();
                if (InitialConditionPanel.this.errorFree) return;
                JOptionPane.showMessageDialog(CHEMFLO.appWin, RichardsEqn.errorMessage, "Error", 0);
                CHEMFLO.appWin.repaint();
                return;
            }
            if (!InitialConditionPanel.this.tableErrorFree()) {
                JOptionPane.showMessageDialog(CHEMFLO.appWin, "Error in initial condition table", "Error", 0);
                CHEMFLO.appWin.repaint();
                return;
            }
            InitialConditionPanel.this.performed();
            if (InitialConditionPanel.this.errorFree) {
                InitialConditionPanel.this.updateTableChemCond();
                return;
            }
            JOptionPane.showMessageDialog(CHEMFLO.appWin, RichardsEqn.errorMessage, "Error", 0);
            CHEMFLO.appWin.repaint();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            block3: {
                JTextField jTextField;
                if (!(mouseEvent.getSource() instanceof JTextField) || (jTextField = (JTextField)mouseEvent.getSource()).getText() == null || jTextField.getText().trim().length() == 0) break block3;
                try {
                    Double.parseDouble(jTextField.getText());
                    InitialConditionPanel.this.performed();
                    if (!InitialConditionPanel.this.errorFree) {
                        JOptionPane.showMessageDialog(CHEMFLO.appWin, RichardsEqn.errorMessage, "Error", 0);
                        CHEMFLO.appWin.repaint();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    jTextField.grabFocus();
                }
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (InitialConditionPanel.this.hasTable) {
                InitialConditionPanel.this.initTable.checkTableData();
            }
            InitialConditionPanel.this.performed();
        }
    }

    class TablePanel
    extends JPanel {
        TablePanel() {
            this.setPreferredSize(new Dimension(500, 300));
            this.setLayout(null);
            InitialConditionPanel.this.initTable = new InitialConditionTable(InitialConditionPanel.this.noChemical);
            InitialConditionPanel.this.initTable.setBounds(15, 10, 473, 280);
            this.add(InitialConditionPanel.this.initTable);
        }
    }

    class UpPanel
    extends JPanel {
        UpPanel() {
            this.setPreferredSize(new Dimension(500, 125));
            this.setLayout(null);
            InitialConditionPanel.this.choiceInitialCondNames = new Vector(5, 5);
            InitialConditionPanel.this.choiceInitialCondNames2 = new Vector(5, 5);
            int n = 0;
            InitialConditionPanel.this.lInitialCond = new JLabel("Initial Condition for Water Movement", 2);
            InitialConditionPanel.this.lInitialCond.setFont(new Font("Serif", 1, 16));
            InitialConditionPanel.this.lInitialCond.setForeground(Color.black);
            InitialConditionPanel.this.lInitialCond.setFont(RichardsEqn.labelFont);
            InitialConditionPanel.this.lInitialCond.setBounds(15, 10, 410, 22);
            InitialConditionPanel.this.lInitialCond.setPreferredSize(new Dimension(410, 22));
            if (RichardsEqn.semiInfiniteSelected) {
                InitialConditionPanel.this.choiceInitialCondNames.addElement("Uniform Matric Potential (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + ")");
                InitialConditionPanel.this.choiceInitialCondNames.addElement("Uniform Volumetric Water Content (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "3/" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "3)");
            } else {
                InitialConditionPanel.this.choiceInitialCondNames.addElement("Uniform Matric Potential (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + ")");
                InitialConditionPanel.this.choiceInitialCondNames.addElement("Uniform Volumetric Water Content (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "3/" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "3)");
                InitialConditionPanel.this.choiceInitialCondNames.addElement("Non-uniform Conditions");
            }
            InitialConditionPanel.this.choiceInitialCond = new JComboBox(InitialConditionPanel.this.choiceInitialCondNames);
            InitialConditionPanel.this.choiceInitialCond.setSelectedIndex(RichardsEqn.selectedInitialCond);
            InitialConditionPanel.this.choiceInitialCond.setForeground(Color.black);
            InitialConditionPanel.this.choiceInitialCond.setFont(RichardsEqn.comboBoxFont);
            InitialConditionPanel.this.choiceInitialCond.setBounds(15, 40, 340, 22);
            InitialConditionPanel.this.choiceInitialCond.setPreferredSize(new Dimension(340, 22));
            InitialConditionPanel.this.tfInitialCond = new JTextField(String.valueOf((int)RichardsEqn.matricPotInitial));
            InitialConditionPanel.this.tfInitialCond.setBounds(359, 40, 60, 22);
            InitialConditionPanel.this.tfInitialCond.setPreferredSize(new Dimension(60, 22));
            n = (int)((RichardsEqn.matricPotInitial + 10000.0) / 10.0);
            InitialConditionPanel.this.sbrInitialCond = new JScrollBar(0, n, 0, 0, 1010);
            InitialConditionPanel.this.sbrInitialCond.setBounds(423, 40, 65, 22);
            InitialConditionPanel.this.sbrInitialCond.setPreferredSize(new Dimension(65, 22));
            switch (RichardsEqn.selectedInitialCond) {
                case 0: {
                    n = (int)((RichardsEqn.matricPotInitial + 10000.0) / 10.0);
                    DefaultBoundedRangeModel defaultBoundedRangeModel = new DefaultBoundedRangeModel(n, 0, 0, 1010);
                    InitialConditionPanel.this.sbrInitialCond.setModel(defaultBoundedRangeModel);
                    InitialConditionPanel.this.tfInitialCond.setText(RichardsEqn.formatLength(RichardsEqn.matricPotInitial));
                    break;
                }
                case 1: {
                    int n2 = 1000;
                    int n3 = 0;
                    int n4 = 0;
                    while (n4 < RichardsEqn.editingSoil.nHorizons) {
                        if ((int)(1000.0 * RichardsEqn.editingSoil.horizon[n4].wc.getSatWC()) < n2) {
                            n2 = (int)(1000.0 * RichardsEqn.editingSoil.horizon[n4].wc.getSatWC());
                        }
                        if ((int)(1000.0 * RichardsEqn.editingSoil.horizon[n4].wc.getResidualWC() + 0.5) > n3) {
                            n3 = (int)(1000.0 * RichardsEqn.editingSoil.horizon[n4].wc.getResidualWC() + 0.5);
                        }
                        ++n4;
                    }
                    if (RichardsEqn.wcInitial > (double)n2 / 1000.0) {
                        RichardsEqn.wcInitial = (double)n2 / 1000.0;
                    }
                    if (RichardsEqn.wcInitial < (double)n3 / 1000.0) {
                        RichardsEqn.wcInitial = (double)n3 / 1000.0;
                    }
                    InitialConditionPanel.this.tfInitialCond.setText(Tools.formatDouble(RichardsEqn.wcInitial, 3, 3));
                    InitialConditionPanel.this.savedWc = RichardsEqn.wcInitial;
                    n = (int)(1000.0 * RichardsEqn.wcInitial + 0.5);
                    DefaultBoundedRangeModel defaultBoundedRangeModel = new DefaultBoundedRangeModel(n, 0, n3, n2);
                    InitialConditionPanel.this.sbrInitialCond.setModel(defaultBoundedRangeModel);
                    break;
                }
                case 2: {
                    InitialConditionPanel.this.tfInitialCond.setVisible(false);
                    InitialConditionPanel.this.sbrInitialCond.setVisible(false);
                }
            }
            this.add(InitialConditionPanel.this.lInitialCond);
            this.add(InitialConditionPanel.this.choiceInitialCond);
            this.add(InitialConditionPanel.this.tfInitialCond);
            this.add(InitialConditionPanel.this.sbrInitialCond);
            InitialConditionPanel.this.sbrInitialCond.addAdjustmentListener(new forEvent("InitialCond"));
            InitialConditionPanel.this.choiceInitialCond.addItemListener(new forEvent("InitialCond"));
            InitialConditionPanel.this.lInitialCond2 = new JLabel("Initial Condition for Chemical Movement");
            InitialConditionPanel.this.lInitialCond2.setFont(new Font("Serif", 1, 16));
            InitialConditionPanel.this.lInitialCond2.setForeground(Color.black);
            InitialConditionPanel.this.lInitialCond2.setFont(RichardsEqn.labelFont);
            InitialConditionPanel.this.lInitialCond2.setBounds(15, 77, 410, 22);
            InitialConditionPanel.this.lInitialCond2.setPreferredSize(new Dimension(410, 22));
            if (RichardsEqn.semiInfiniteSelected) {
                InitialConditionPanel.this.choiceInitialCondNames2.addElement("Simulate Water Only");
                InitialConditionPanel.this.choiceInitialCondNames2.addElement("Uniform Solution Concentration");
            } else {
                InitialConditionPanel.this.choiceInitialCondNames2.addElement("Simulate Water Only");
                InitialConditionPanel.this.choiceInitialCondNames2.addElement("Uniform Solution Concentration (g/m3 Soil Water)");
                InitialConditionPanel.this.choiceInitialCondNames2.addElement("Uniform Total Concentration (g/m3 Bulk Soil)");
                InitialConditionPanel.this.choiceInitialCondNames2.addElement("Non-uniform Solution Concentration (g/m3 Soil Water)");
                InitialConditionPanel.this.choiceInitialCondNames2.addElement("Non-uniform Total Concentration (g/m3 Bulk Soil)");
            }
            InitialConditionPanel.this.choiceInitialCond2 = new JComboBox(InitialConditionPanel.this.choiceInitialCondNames2);
            InitialConditionPanel.this.choiceInitialCond2.setSelectedIndex(RichardsEqn.selectedInitialCond2);
            InitialConditionPanel.this.choiceInitialCond2.setForeground(Color.black);
            InitialConditionPanel.this.choiceInitialCond2.setFont(RichardsEqn.comboBoxFont);
            InitialConditionPanel.this.choiceInitialCond2.setBounds(15, 107, 340, 22);
            InitialConditionPanel.this.choiceInitialCond2.setPreferredSize(new Dimension(340, 22));
            InitialConditionPanel.this.tfInitialCond2 = new JTextField(Tools.formatDouble(RichardsEqn.matricChemPotInitial, 3, 3));
            InitialConditionPanel.this.tfInitialCond2.setBounds(359, 107, 60, 22);
            InitialConditionPanel.this.tfInitialCond2.setPreferredSize(new Dimension(60, 22));
            InitialConditionPanel.this.tfInitialCond2.setVisible(false);
            n = (int)RichardsEqn.matricChemPotInitial * 1000;
            InitialConditionPanel.this.sbrInitialCond2 = new JScrollBar(0, n, 0, 0, 1000000);
            InitialConditionPanel.this.sbrInitialCond2.setBounds(423, 107, 65, 22);
            InitialConditionPanel.this.sbrInitialCond2.setPreferredSize(new Dimension(65, 22));
            InitialConditionPanel.this.sbrInitialCond2.setVisible(false);
            switch (RichardsEqn.selectedInitialCond2) {
                case 0: {
                    InitialConditionPanel.this.tfInitialCond2.setVisible(false);
                    InitialConditionPanel.this.sbrInitialCond2.setVisible(false);
                    break;
                }
                case 1: 
                case 2: {
                    InitialConditionPanel.this.tfInitialCond2.setText(Tools.formatDouble(RichardsEqn.matricChemPotInitial, 3, 3));
                    n = (int)(RichardsEqn.matricChemPotInitial * 1000.0 + 0.5);
                    DefaultBoundedRangeModel defaultBoundedRangeModel = new DefaultBoundedRangeModel(n, 0, 0, 1000000);
                    InitialConditionPanel.this.sbrInitialCond2.setModel(defaultBoundedRangeModel);
                    break;
                }
                case 3: 
                case 4: {
                    InitialConditionPanel.this.tfInitialCond2.setVisible(false);
                    InitialConditionPanel.this.sbrInitialCond2.setVisible(false);
                }
            }
            this.add(InitialConditionPanel.this.lInitialCond2);
            this.add(InitialConditionPanel.this.choiceInitialCond2);
            this.add(InitialConditionPanel.this.tfInitialCond2);
            this.add(InitialConditionPanel.this.sbrInitialCond2);
            InitialConditionPanel.this.sbrInitialCond2.addAdjustmentListener(new forEvent("InitialCond2"));
            InitialConditionPanel.this.choiceInitialCond2.addItemListener(new forEvent("InitialCond2"));
            InitialConditionPanel.this.tfInitialCond.addActionListener(new forEvent("InitialCond"));
            InitialConditionPanel.this.tfInitialCond2.addActionListener(new forEvent("InitialCond2"));
            InitialConditionPanel.this.tfInitialCond.addMouseListener(new forEvent("InitialCond"));
            InitialConditionPanel.this.tfInitialCond2.addMouseListener(new forEvent("InitialCond2"));
        }
    }
}

