/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.MouseInputAdapter;

public class InnerFrame
extends JPanel
implements RootPaneContainer {
    private static ImageIcon CLOSE_BUTTON_ICON;
    private static ImageIcon DEFAULT_FRAME_ICON;
    private static ImageIcon PRESS_CLOSE_BUTTON_ICON;
    private static int BORDER_THICKNESS;
    private static int WIDTH;
    private static int HEIGHT;
    private static int TITLE_BAR_HEIGHT;
    private static int FRAME_ICON_PADDING;
    private static int ICONIZED_WIDTH;
    private static Color TITLE_BAR_BG_COLOR;
    private static Color BORDER_COLOR;
    private int m_titleBarHeight = TITLE_BAR_HEIGHT;
    private int m_width = WIDTH;
    private int m_height = HEIGHT;
    private int m_iconizedWidth = ICONIZED_WIDTH;
    private int m_x;
    private int m_y;
    private String m_title;
    private JLabel m_titleLabel;
    private JLabel m_iconLabel;
    private boolean m_iconified;
    private boolean m_maximized;
    private boolean m_iconizeable;
    private boolean m_resizeable;
    private boolean m_closeable;
    private boolean m_maximizeable;
    private boolean m_draggable = true;
    private JRootPane m_rootPane;
    private JPanel m_frameContentPanel;
    private JPanel m_titlePanel;
    private JPanel m_contentPanel;
    private JPanel m_buttonPanel;
    private JPanel m_buttonWrapperPanel;
    private InnerFrameButton m_iconize;
    private InnerFrameButton m_close;
    private InnerFrameButton m_maximize;
    private NorthResizeEdge m_northResizer;
    private SouthResizeEdge m_southResizer;
    private EastResizeEdge m_eastResizer;
    private WestResizeEdge m_westResizer;
    private Graphs gp;

    public InnerFrame(String string, Graphs graphs) {
        super.setLayout(new BorderLayout());
        ClassLoader classLoader = this.getClass().getClassLoader();
        CLOSE_BUTTON_ICON = new ImageIcon(classLoader.getResource("images/close.gif"));
        DEFAULT_FRAME_ICON = new ImageIcon(classLoader.getResource("images/default.gif"));
        PRESS_CLOSE_BUTTON_ICON = new ImageIcon(classLoader.getResource("images/pressclose.gif"));
        this.gp = graphs;
        this.attachNorthResizeEdge();
        this.attachSouthResizeEdge();
        this.attachEastResizeEdge();
        this.attachWestResizeEdge();
        this.populateInnerFrame();
        this.setTitle(string);
        this.setResizeable(false);
        this.setIconizeable(false);
        this.setCloseable(true);
        this.setMaximizeable(false);
    }

    protected void populateInnerFrame() {
        this.m_rootPane = new JRootPane();
        this.m_frameContentPanel = new JPanel();
        this.m_frameContentPanel.setLayout(new BorderLayout());
        this.createTitleBar();
        this.m_contentPanel = new JPanel(new BorderLayout());
        GraphsParameter graphsParameter = new GraphsParameter(this.gp);
        this.m_contentPanel.add((Component)graphsParameter, "Center");
        this.m_rootPane.setContentPane(this.m_contentPanel);
        this.m_frameContentPanel.add((Component)this.m_titlePanel, "North");
        this.m_frameContentPanel.add((Component)this.m_rootPane, "Center");
        this.setupCapturePanel();
        super.add((Component)this.m_frameContentPanel, "Center");
    }

    protected void setupCapturePanel() {
        CapturePanel capturePanel = new CapturePanel();
        this.m_rootPane.getLayeredPane().add((Component)capturePanel, new Integer(Integer.MIN_VALUE));
        capturePanel.setBounds(0, 0, 10000, 10000);
    }

    public Component add(Component component) {
        return null;
    }

    public void setLayout(LayoutManager layoutManager) {
    }

    public JMenuBar getJMenuBar() {
        return this.m_rootPane.getJMenuBar();
    }

    public JRootPane getRootPane() {
        return this.m_rootPane;
    }

    public Container getContentPane() {
        return this.m_rootPane.getContentPane();
    }

    public Component getGlassPane() {
        return this.m_rootPane.getGlassPane();
    }

    public JLayeredPane getLayeredPane() {
        return this.m_rootPane.getLayeredPane();
    }

    public void setJMenuBar(JMenuBar jMenuBar) {
        this.m_rootPane.setJMenuBar(jMenuBar);
    }

    public void setContentPane(Container container) {
        this.m_rootPane.setContentPane(container);
    }

    public void setGlassPane(Component component) {
        this.m_rootPane.setGlassPane(component);
    }

    public void setLayeredPane(JLayeredPane jLayeredPane) {
        this.m_rootPane.setLayeredPane(jLayeredPane);
    }

    public void toFront() {
        if (this.getParent() instanceof JLayeredPane) {
            ((JLayeredPane)this.getParent()).moveToFront(this);
        }
    }

    public void close() {
        if (this.getParent() instanceof JLayeredPane) {
            JLayeredPane jLayeredPane = (JLayeredPane)this.getParent();
            jLayeredPane.remove(this);
            jLayeredPane.repaint();
        }
    }

    public boolean isIconizeable() {
        return this.m_iconizeable;
    }

    public void setIconizeable(boolean bl) {
        this.m_iconizeable = bl;
        this.m_titlePanel.revalidate();
    }

    public boolean isCloseable() {
        return this.m_closeable;
    }

    public void setCloseable(boolean bl) {
        this.m_closeable = bl;
        this.m_close.setVisible(bl);
        this.m_titlePanel.revalidate();
    }

    public boolean isMaximizeable() {
        return this.m_maximizeable;
    }

    public void setMaximizeable(boolean bl) {
        this.m_maximizeable = bl;
        this.m_titlePanel.revalidate();
    }

    public boolean isIconified() {
        return this.m_iconified;
    }

    public void setIconified(boolean bl) {
        this.m_iconified = bl;
        if (bl) {
            if (this.isMaximized()) {
                this.setMaximized(false);
            }
            this.toFront();
            this.m_width = this.getWidth();
            this.m_height = this.getHeight();
            this.setBounds(this.getX(), this.getY(), ICONIZED_WIDTH, this.m_titleBarHeight + 2 * BORDER_THICKNESS);
            this.setResizeable(false);
        } else {
            this.toFront();
            this.setBounds(this.getX(), this.getY(), this.m_width, this.m_height);
            this.setResizeable(false);
        }
        this.revalidate();
    }

    public boolean isMaximized() {
        return this.m_maximized;
    }

    public void setMaximized(boolean bl) {
        this.m_maximized = bl;
        if (bl) {
            if (this.isIconified()) {
                this.setIconified(false);
            }
            this.toFront();
            this.m_width = this.getWidth();
            this.m_height = this.getHeight();
            this.m_x = this.getX();
            this.m_y = this.getY();
            this.setBounds(0, 0, this.getParent().getWidth(), this.getParent().getHeight());
            this.setResizeable(false);
            this.setDraggable(false);
        } else {
            this.toFront();
            this.setBounds(this.m_x, this.m_y, this.m_width, this.m_height);
            this.setResizeable(true);
            this.setDraggable(true);
        }
        this.revalidate();
    }

    public void setTitle(String string) {
        this.m_title = string;
        this.m_titleLabel.setForeground(Color.cyan);
        this.m_titleLabel.setText(string);
        this.m_titlePanel.repaint();
    }

    public String getTitle() {
        return this.m_title;
    }

    public void setTitleBarHeight(int n) {
        this.m_titleBarHeight = n;
    }

    public int getTitleBarHeight() {
        return this.m_titleBarHeight;
    }

    public boolean isDraggable() {
        return this.m_draggable;
    }

    private void setDraggable(boolean bl) {
        this.m_draggable = bl;
    }

    protected void createTitleBar() {
        this.m_titlePanel = new JPanel(){

            public Dimension getPreferredSize() {
                return new Dimension(InnerFrame.this.getWidth(), InnerFrame.this.m_titleBarHeight);
            }
        };
        this.m_titlePanel.setLayout(new BorderLayout());
        this.m_titlePanel.setOpaque(true);
        this.m_titlePanel.setBackground(TITLE_BAR_BG_COLOR);
        this.m_titleLabel = new JLabel();
        this.m_titleLabel.setForeground(Color.black);
        this.m_close = new InnerFrameButton(CLOSE_BUTTON_ICON);
        this.m_close.setPressedIcon(PRESS_CLOSE_BUTTON_ICON);
        this.m_close.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InnerFrame.this.setVisible(false);
                InnerFrame.this.gp.repaint();
            }
        });
        this.m_buttonWrapperPanel = new JPanel();
        this.m_buttonWrapperPanel.setOpaque(false);
        this.m_buttonPanel = new JPanel(new GridLayout(1, 3));
        this.m_buttonPanel.setOpaque(false);
        this.m_buttonPanel.add(this.m_close);
        this.m_buttonPanel.setAlignmentX(0.5f);
        this.m_buttonPanel.setAlignmentY(0.5f);
        this.m_buttonWrapperPanel.add(this.m_buttonPanel);
        this.m_iconLabel = new JLabel();
        this.m_iconLabel.setBorder(new EmptyBorder(FRAME_ICON_PADDING, FRAME_ICON_PADDING, FRAME_ICON_PADDING, FRAME_ICON_PADDING));
        this.m_titlePanel.add((Component)this.m_titleLabel, "Center");
        this.m_titlePanel.add((Component)this.m_buttonWrapperPanel, "East");
        this.m_titlePanel.add((Component)this.m_iconLabel, "West");
        InnerFrameTitleBarMouseAdapter innerFrameTitleBarMouseAdapter = new InnerFrameTitleBarMouseAdapter(this);
        this.m_titlePanel.addMouseListener(innerFrameTitleBarMouseAdapter);
        this.m_titlePanel.addMouseMotionListener(innerFrameTitleBarMouseAdapter);
    }

    public boolean isResizeable() {
        return this.m_resizeable;
    }

    public void setResizeable(boolean bl) {
        if (!bl && this.m_resizeable) {
            this.m_northResizer.removeMouseListener(this.m_northResizer);
            this.m_northResizer.removeMouseMotionListener(this.m_northResizer);
            this.m_southResizer.removeMouseListener(this.m_southResizer);
            this.m_southResizer.removeMouseMotionListener(this.m_southResizer);
            this.m_eastResizer.removeMouseListener(this.m_eastResizer);
            this.m_eastResizer.removeMouseMotionListener(this.m_eastResizer);
            this.m_westResizer.removeMouseListener(this.m_westResizer);
            this.m_westResizer.removeMouseMotionListener(this.m_westResizer);
        } else if (bl && !this.m_resizeable) {
            this.m_northResizer.addMouseListener(this.m_northResizer);
            this.m_northResizer.addMouseMotionListener(this.m_northResizer);
            this.m_southResizer.addMouseListener(this.m_southResizer);
            this.m_southResizer.addMouseMotionListener(this.m_southResizer);
            this.m_eastResizer.addMouseListener(this.m_eastResizer);
            this.m_eastResizer.addMouseMotionListener(this.m_eastResizer);
            this.m_westResizer.addMouseListener(this.m_westResizer);
            this.m_westResizer.addMouseMotionListener(this.m_westResizer);
        }
        this.m_resizeable = bl;
    }

    protected void attachNorthResizeEdge() {
        this.m_northResizer = new NorthResizeEdge(this);
        super.add((Component)this.m_northResizer, "North");
    }

    protected void attachSouthResizeEdge() {
        this.m_southResizer = new SouthResizeEdge(this);
        super.add((Component)this.m_southResizer, "South");
    }

    protected void attachEastResizeEdge() {
        this.m_eastResizer = new EastResizeEdge(this);
        super.add((Component)this.m_eastResizer, "East");
    }

    protected void attachWestResizeEdge() {
        this.m_westResizer = new WestResizeEdge(this);
        super.add((Component)this.m_westResizer, "West");
    }

    static /* synthetic */ int access$200() {
        return BORDER_THICKNESS;
    }

    static /* synthetic */ int access$300() {
        return ICONIZED_WIDTH;
    }

    static /* synthetic */ int access$500() {
        return TITLE_BAR_HEIGHT;
    }

    static {
        BORDER_THICKNESS = 4;
        WIDTH = 200;
        HEIGHT = 200;
        TITLE_BAR_HEIGHT = 25;
        FRAME_ICON_PADDING = 2;
        ICONIZED_WIDTH = 150;
        TITLE_BAR_BG_COLOR = new Color(153, 153, 255);
        BORDER_COLOR = new Color(204, 204, 204);
    }

    class SouthResizeEdge
    extends JPanel
    implements MouseListener,
    MouseMotionListener {
        private static final int SOUTH = 0;
        private static final int SOUTHEAST = 1;
        private static final int SOUTHWEST = 2;
        private int CORNER = 10;
        private int HEIGHT = InnerFrame.access$200();
        private int MIN_WIDTH = InnerFrame.access$300();
        private int MIN_HEIGHT = InnerFrame.access$500() + 2 * this.HEIGHT;
        private int m_width;
        private int m_dragX;
        private int m_dragY;
        private int m_rightX;
        private boolean m_dragging;
        private JComponent m_resizeComponent;
        private int m_mode;

        protected SouthResizeEdge(JComponent jComponent) {
            this.m_resizeComponent = jComponent;
            this.setOpaque(true);
            this.setBackground(BORDER_COLOR);
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.m_resizeComponent.getWidth(), this.HEIGHT);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (!this.m_dragging) {
                if (mouseEvent.getX() < this.CORNER) {
                    this.setCursor(Cursor.getPredefinedCursor(4));
                } else if (mouseEvent.getX() > this.getWidth() - this.CORNER) {
                    this.setCursor(Cursor.getPredefinedCursor(5));
                } else {
                    this.setCursor(Cursor.getPredefinedCursor(9));
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.m_dragging = false;
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n = this.m_resizeComponent.getHeight();
            int n2 = this.m_resizeComponent.getWidth();
            int n3 = this.m_resizeComponent.getX();
            int n4 = this.m_resizeComponent.getY();
            int n5 = mouseEvent.getX();
            int n6 = mouseEvent.getY();
            switch (this.m_mode) {
                case 0: {
                    if (n + (n6 - this.m_dragY) >= this.MIN_HEIGHT) {
                        this.m_resizeComponent.setBounds(n3, n4, n2, n + (n6 - this.m_dragY));
                        break;
                    }
                    this.m_resizeComponent.setBounds(n3, n4, n2, this.MIN_HEIGHT);
                    break;
                }
                case 1: {
                    if (n + (n6 - this.m_dragY) >= this.MIN_HEIGHT && n2 + (n5 - (this.getWidth() - this.CORNER)) >= this.MIN_WIDTH) {
                        this.m_resizeComponent.setBounds(n3, n4, n2 + (n5 - (this.getWidth() - this.CORNER)), n + (n6 - this.m_dragY));
                        break;
                    }
                    if (n + (n6 - this.m_dragY) >= this.MIN_HEIGHT && n2 + (n5 - (this.getWidth() - this.CORNER)) < this.MIN_WIDTH) {
                        this.m_resizeComponent.setBounds(n3, n4, this.MIN_WIDTH, n + (n6 - this.m_dragY));
                        break;
                    }
                    if (n + (n6 - this.m_dragY) < this.MIN_HEIGHT && n2 + (n5 - (this.getWidth() - this.CORNER)) >= this.MIN_WIDTH) {
                        this.m_resizeComponent.setBounds(n3, n4, n2 + (n5 - (this.getWidth() - this.CORNER)), this.MIN_HEIGHT);
                        break;
                    }
                    this.m_resizeComponent.setBounds(n3, n4, this.MIN_WIDTH, this.MIN_HEIGHT);
                    break;
                }
                case 2: {
                    if (n + (n6 - this.m_dragY) >= this.MIN_HEIGHT && n2 - (n5 - this.m_dragX) >= this.MIN_WIDTH) {
                        this.m_resizeComponent.setBounds(n3 + (n5 - this.m_dragX), n4, n2 - (n5 - this.m_dragX), n + (n6 - this.m_dragY));
                        break;
                    }
                    if (n + (n6 - this.m_dragY) >= this.MIN_HEIGHT && n2 - (n5 - this.m_dragX) < this.MIN_WIDTH) {
                        if (n3 + this.MIN_WIDTH < this.m_rightX) {
                            this.m_resizeComponent.setBounds(this.m_rightX - this.MIN_WIDTH, n4, this.MIN_WIDTH, n + (n6 - this.m_dragY));
                            break;
                        }
                        this.m_resizeComponent.setBounds(n3, n4, n2, n + (n6 - this.m_dragY));
                        break;
                    }
                    if (n + (n6 - this.m_dragY) < this.MIN_HEIGHT && n2 - (n5 - this.m_dragX) >= this.MIN_WIDTH) {
                        this.m_resizeComponent.setBounds(n3 + (n5 - this.m_dragX), n4, n2 - (n5 - this.m_dragX), this.MIN_HEIGHT);
                        break;
                    }
                    this.m_resizeComponent.setBounds(this.m_rightX - this.MIN_WIDTH, n4, this.MIN_WIDTH, this.MIN_HEIGHT);
                }
            }
            this.m_rightX = n3 + n2;
            this.m_resizeComponent.validate();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.mouseMoved(mouseEvent);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (!this.m_dragging) {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            InnerFrame.this.toFront();
            this.m_dragging = true;
            this.m_dragX = mouseEvent.getX();
            this.m_dragY = mouseEvent.getY();
            this.m_mode = mouseEvent.getX() < this.CORNER ? 2 : (mouseEvent.getX() > this.getWidth() - this.CORNER ? 1 : 0);
        }
    }

    class NorthResizeEdge
    extends JPanel
    implements MouseListener,
    MouseMotionListener {
        private static final int NORTH = 0;
        private static final int NORTHEAST = 1;
        private static final int NORTHWEST = 2;
        private int CORNER = 10;
        private int HEIGHT = InnerFrame.access$200();
        private int MIN_WIDTH = InnerFrame.access$300();
        private int MIN_HEIGHT = InnerFrame.access$500() + 2 * this.HEIGHT;
        private int m_width;
        private int m_dragX;
        private int m_dragY;
        private int m_rightX;
        private int m_lowerY;
        private boolean m_dragging;
        private JComponent m_resizeComponent;
        private int m_mode;

        protected NorthResizeEdge(JComponent jComponent) {
            this.m_resizeComponent = jComponent;
            this.setOpaque(true);
            this.setBackground(BORDER_COLOR);
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.m_resizeComponent.getWidth(), this.HEIGHT);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (!this.m_dragging) {
                if (mouseEvent.getX() < this.CORNER) {
                    this.setCursor(Cursor.getPredefinedCursor(6));
                } else if (mouseEvent.getX() > this.getWidth() - this.CORNER) {
                    this.setCursor(Cursor.getPredefinedCursor(7));
                } else {
                    this.setCursor(Cursor.getPredefinedCursor(8));
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.m_dragging = false;
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n = this.m_resizeComponent.getHeight();
            int n2 = this.m_resizeComponent.getWidth();
            int n3 = this.m_resizeComponent.getX();
            int n4 = this.m_resizeComponent.getY();
            int n5 = mouseEvent.getX();
            int n6 = mouseEvent.getY();
            switch (this.m_mode) {
                case 0: {
                    if (n - (n6 - this.m_dragY) >= this.MIN_HEIGHT) {
                        this.m_resizeComponent.setBounds(n3, n4 + (n6 - this.m_dragY), n2, n - (n6 - this.m_dragY));
                        break;
                    }
                    this.m_resizeComponent.setBounds(n3, this.m_lowerY - this.MIN_HEIGHT, n2, this.MIN_HEIGHT);
                    break;
                }
                case 1: {
                    if (n - (n6 - this.m_dragY) >= this.MIN_HEIGHT && n2 + (n5 - (this.getWidth() - this.CORNER)) >= this.MIN_WIDTH) {
                        this.m_resizeComponent.setBounds(n3, n4 + (n6 - this.m_dragY), n2 + (n5 - (this.getWidth() - this.CORNER)), n - (n6 - this.m_dragY));
                        break;
                    }
                    if (n - (n6 - this.m_dragY) >= this.MIN_HEIGHT && n2 + (n5 - (this.getWidth() - this.CORNER)) < this.MIN_WIDTH) {
                        this.m_resizeComponent.setBounds(n3, n4 + (n6 - this.m_dragY), this.MIN_WIDTH, n - (n6 - this.m_dragY));
                        break;
                    }
                    if (n - (n6 - this.m_dragY) < this.MIN_HEIGHT && n2 + (n5 - (this.getWidth() - this.CORNER)) >= this.MIN_WIDTH) {
                        this.m_resizeComponent.setBounds(n3, this.m_lowerY - this.MIN_HEIGHT, n2 + (n5 - (this.getWidth() - this.CORNER)), this.MIN_HEIGHT);
                        break;
                    }
                    this.m_resizeComponent.setBounds(n3, this.m_lowerY - this.MIN_HEIGHT, this.MIN_WIDTH, this.MIN_HEIGHT);
                    break;
                }
                case 2: {
                    if (n - (n6 - this.m_dragY) >= this.MIN_HEIGHT && n2 - (n5 - this.m_dragX) >= this.MIN_WIDTH) {
                        this.m_resizeComponent.setBounds(n3 + (n5 - this.m_dragX), n4 + (n6 - this.m_dragY), n2 - (n5 - this.m_dragX), n - (n6 - this.m_dragY));
                        break;
                    }
                    if (n - (n6 - this.m_dragY) >= this.MIN_HEIGHT && n2 - (n5 - this.m_dragX) < this.MIN_WIDTH) {
                        if (n3 + this.MIN_WIDTH < this.m_rightX) {
                            this.m_resizeComponent.setBounds(this.m_rightX - this.MIN_WIDTH, n4 + (n6 - this.m_dragY), this.MIN_WIDTH, n - (n6 - this.m_dragY));
                            break;
                        }
                        this.m_resizeComponent.setBounds(n3, n4 + (n6 - this.m_dragY), n2, n - (n6 - this.m_dragY));
                        break;
                    }
                    if (n - (n6 - this.m_dragY) < this.MIN_HEIGHT && n2 - (n5 - this.m_dragX) >= this.MIN_WIDTH) {
                        this.m_resizeComponent.setBounds(n3 + (n5 - this.m_dragX), this.m_lowerY - this.MIN_HEIGHT, n2 - (n5 - this.m_dragX), this.MIN_HEIGHT);
                        break;
                    }
                    this.m_resizeComponent.setBounds(this.m_rightX - this.MIN_WIDTH, this.m_lowerY - this.MIN_HEIGHT, this.MIN_WIDTH, this.MIN_HEIGHT);
                }
            }
            this.m_rightX = n3 + n2;
            this.m_resizeComponent.validate();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.mouseMoved(mouseEvent);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (!this.m_dragging) {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            InnerFrame.this.toFront();
            this.m_dragging = true;
            this.m_dragX = mouseEvent.getX();
            this.m_dragY = mouseEvent.getY();
            this.m_lowerY = this.m_resizeComponent.getY() + this.m_resizeComponent.getHeight();
            this.m_mode = mouseEvent.getX() < this.CORNER ? 2 : (mouseEvent.getX() > this.getWidth() - this.CORNER ? 1 : 0);
        }
    }

    class WestResizeEdge
    extends JPanel
    implements MouseListener,
    MouseMotionListener {
        private int WIDTH = InnerFrame.access$200();
        private int MIN_WIDTH = InnerFrame.access$300();
        private int m_dragX;
        private int m_rightX;
        private boolean m_dragging;
        private JComponent m_resizeComponent;

        protected WestResizeEdge(JComponent jComponent) {
            this.m_resizeComponent = jComponent;
            this.setOpaque(true);
            this.setBackground(BORDER_COLOR);
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.WIDTH, this.m_resizeComponent.getHeight());
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.m_dragging = false;
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.m_resizeComponent.getWidth() - (mouseEvent.getX() - this.m_dragX) >= this.MIN_WIDTH) {
                this.m_resizeComponent.setBounds(this.m_resizeComponent.getX() + (mouseEvent.getX() - this.m_dragX), this.m_resizeComponent.getY(), this.m_resizeComponent.getWidth() - (mouseEvent.getX() - this.m_dragX), this.m_resizeComponent.getHeight());
            } else if (this.m_resizeComponent.getX() + this.MIN_WIDTH < this.m_rightX) {
                this.m_resizeComponent.setBounds(this.m_rightX - this.MIN_WIDTH, this.m_resizeComponent.getY(), this.MIN_WIDTH, this.m_resizeComponent.getHeight());
            } else {
                this.m_resizeComponent.setBounds(this.m_resizeComponent.getX(), this.m_resizeComponent.getY(), this.MIN_WIDTH, this.m_resizeComponent.getHeight());
            }
            this.m_resizeComponent.validate();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (!this.m_dragging) {
                this.setCursor(Cursor.getPredefinedCursor(10));
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (!this.m_dragging) {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            InnerFrame.this.toFront();
            this.m_rightX = this.m_resizeComponent.getX() + this.m_resizeComponent.getWidth();
            this.m_dragging = true;
            this.m_dragX = mouseEvent.getX();
        }
    }

    class EastResizeEdge
    extends JPanel
    implements MouseListener,
    MouseMotionListener {
        private int WIDTH = InnerFrame.access$200();
        private int MIN_WIDTH = InnerFrame.access$300();
        private boolean m_dragging;
        private JComponent m_resizeComponent;

        protected EastResizeEdge(JComponent jComponent) {
            this.m_resizeComponent = jComponent;
            this.setOpaque(true);
            this.setBackground(BORDER_COLOR);
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.WIDTH, this.m_resizeComponent.getHeight());
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.m_dragging = false;
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.m_resizeComponent.getWidth() + mouseEvent.getX() >= this.MIN_WIDTH) {
                this.m_resizeComponent.setBounds(this.m_resizeComponent.getX(), this.m_resizeComponent.getY(), this.m_resizeComponent.getWidth() + mouseEvent.getX(), this.m_resizeComponent.getHeight());
            } else {
                this.m_resizeComponent.setBounds(this.m_resizeComponent.getX(), this.m_resizeComponent.getY(), this.MIN_WIDTH, this.m_resizeComponent.getHeight());
            }
            this.m_resizeComponent.validate();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (!this.m_dragging) {
                this.setCursor(Cursor.getPredefinedCursor(11));
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (!this.m_dragging) {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            InnerFrame.this.toFront();
            this.m_dragging = true;
        }
    }

    class CapturePanel
    extends JPanel {
        public CapturePanel() {
            MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(this){
                private final /* synthetic */ CapturePanel this$1;
                {
                    this.this$1 = capturePanel;
                }
            };
            this.addMouseListener(mouseInputAdapter);
            this.addMouseMotionListener(mouseInputAdapter);
        }
    }

    class InnerFrameButton
    extends JButton {
        Dimension m_dim;

        public InnerFrameButton(ImageIcon imageIcon) {
            super(imageIcon);
            this.m_dim = new Dimension(imageIcon.getIconWidth(), imageIcon.getIconHeight());
            this.setOpaque(false);
            this.setContentAreaFilled(false);
            this.setBorder(null);
        }

        public Dimension getPreferredSize() {
            return this.m_dim;
        }

        public Dimension getMinimumSize() {
            return this.m_dim;
        }

        public Dimension getMaximumSize() {
            return this.m_dim;
        }
    }

    class InnerFrameTitleBarMouseAdapter
    extends MouseInputAdapter {
        InnerFrame m_if;
        int m_XDifference;
        int m_YDifference;
        boolean m_dragging;

        public InnerFrameTitleBarMouseAdapter(InnerFrame innerFrame2) {
            this.m_if = innerFrame2;
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = this.m_if.getX();
            int n4 = this.m_if.getY();
            int n5 = this.m_if.getParent().getWidth();
            int n6 = this.m_if.getParent().getHeight();
            if (this.m_dragging & this.m_if.isDraggable()) {
                if (n2 + n4 > 0 && n2 + n4 < n6 && n + n3 > 0 && n + n3 < n5) {
                    this.m_if.setLocation(n - this.m_XDifference + n3, n2 - this.m_YDifference + n4);
                } else if ((n2 + n4 <= 0 || n2 + n4 >= n6) && n + n3 > 0 && n + n3 < n5) {
                    if (n2 + n4 <= 0 && n2 + n4 < n6) {
                        this.m_if.setLocation(n - this.m_XDifference + n3, 0 - this.m_YDifference);
                    } else if (n2 + n4 > 0 && n2 + n4 >= n6) {
                        this.m_if.setLocation(n - this.m_XDifference + n3, n6 - this.m_YDifference);
                    }
                } else if (n2 + n4 > 0 && n2 + n4 < n6 && (n + n3 <= 0 || n + n3 >= n5)) {
                    if (n + n3 <= 0 && n + n3 < n5) {
                        this.m_if.setLocation(0 - this.m_XDifference, n2 - this.m_YDifference + n4);
                    } else if (n + n3 > 0 && n + n3 >= n5) {
                        this.m_if.setLocation(n5 - this.m_XDifference, n2 - this.m_YDifference + n4);
                    }
                } else if (n2 + n4 <= 0 && n2 + n4 < n6 && n + n3 <= 0 && n + n3 < n5) {
                    this.m_if.setLocation(0 - this.m_XDifference, 0 - this.m_YDifference);
                } else if (n2 + n4 <= 0 && n2 + n4 < n6 && n + n3 > 0 && n + n3 >= n5) {
                    this.m_if.setLocation(n5 - this.m_XDifference, 0 - this.m_YDifference);
                } else if (n2 + n4 > 0 && n2 + n4 >= n6 && n + n3 <= 0 && n + n3 < n5) {
                    this.m_if.setLocation(0 - this.m_XDifference, n6 - this.m_YDifference);
                } else if (n2 + n4 > 0 && n2 + n4 >= n6 && n + n3 > 0 && n + n3 >= n5) {
                    this.m_if.setLocation(n5 - this.m_XDifference, n6 - this.m_YDifference);
                }
                InnerFrame.this.gp.repaint();
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.m_if.toFront();
            this.m_XDifference = mouseEvent.getX();
            this.m_YDifference = mouseEvent.getY();
            this.m_dragging = true;
            InnerFrame.this.gp.repaint();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.m_dragging = false;
            InnerFrame.this.gp.repaint();
        }
    }
}

