/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;

public class MainScreenPanel
extends ChemfloPanel {
    private BevelBorder raisedEdge = new BevelBorder(0);
    private Border oldBorder;
    public boolean errorFree = true;
    private JButton bSave;
    private JButton bClear;
    private JButton bCalculate;
    private JButton bCustomizer;
    private boolean simChem;
    private boolean showMsg;
    private boolean newLine;
    JLabel lTime;
    JLabel lPosition;
    JLabel caption;
    JLabel caption2;
    public JTextField tfTime;
    public JTextField tfPosition;
    JScrollBar sbrTime;
    JScrollBar sbrPosition;
    public JComboBox choiceGraph;
    public JComboBox combox2;
    Vector choiceG = new Vector(20, 5);
    Vector chNames = new Vector(20, 5);
    static UpTitlePanel upPanel;
    LowTitlePanel lowPanel;
    UpGraphPanel upGraph;
    LowGraphPanel lowGraph;
    CaptionPanel captionP;
    JPanel centerPane;
    public static Label lMessage1;
    String message1;
    JLabel lGraph;
    JLabel lGraph2;
    FontMetrics fm;
    private boolean DEBUG = false;
    private int posLimit;
    private JButton bAbort;
    private volatile Thread lookupThread;
    private int gWidth;
    private int gHeight;
    public GraphData[] graphData;
    private String[] colorName = new String[]{"RED", "BLUE", "BLACK", "GREEN", "MAGENTA"};
    private double old_t;
    private double upXmax;
    private double upXmin;
    private double upYmax;
    private double upYmin;
    private double lowXmax;
    private double lowXmin;
    private double lowYmax;
    private double lowYmin;
    private double[] upLim = new double[4];
    private double[] lowLim = new double[4];
    private double[] autoUpLim = new double[4];
    private double[] autoLowLim = new double[4];
    private int nDecimals = 2;
    private boolean drawCurve;
    private double cumuInflux;
    private double storageIncrease;
    private double absError;
    private double relaError;
    private boolean massBalanceWarning;

    public MainScreenPanel() {
        super("Graph Output");
        this.graphData = new GraphData[5];
        this.graphData[RichardsEqn.currentLine] = new GraphData();
        this.graphData[RichardsEqn.currentLine].setColor(this.colorName[RichardsEqn.currentLine], RichardsEqn.colorLine[RichardsEqn.currentLine]);
        this.newLine = true;
        this.old_t = RichardsEqn.criticalTime;
        Font font = new Font("Serif", 0, 12);
        this.fm = this.getFontMetrics(font);
        this.setLayout(this.border);
        this.setBorder(this.edge);
        this.add((Component)this.titleP, "North");
        this.simChem = false;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setPreferredSize(new Dimension(120, 20));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(3, 1, 0, 0));
        JPanel jPanel4 = new JPanel();
        jPanel4.setPreferredSize(new Dimension(120, (this.getHeight() - 70) / 3));
        JPanel jPanel5 = new JPanel();
        jPanel5.setPreferredSize(new Dimension(120, 25));
        jPanel4.add(jPanel5);
        JLabel jLabel = new JLabel("Time of Interest  ");
        jLabel.setForeground(Color.black);
        jLabel.setFont(RichardsEqn.labelFont);
        jPanel4.add(jLabel);
        this.lTime = new JLabel(" (" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ") ");
        this.lTime.setForeground(Color.black);
        this.lTime.setFont(RichardsEqn.labelFont);
        jPanel4.add(this.lTime);
        JPanel jPanel6 = new JPanel();
        this.tfTime = new JTextField(RichardsEqn.formatTime(RichardsEqn.criticalTime));
        this.tfTime.setPreferredSize(new Dimension(50, 20));
        this.tfTime.setFont(RichardsEqn.textFieldFont);
        jPanel6.add(this.tfTime);
        int n = (int)(10.0 * RichardsEqn.criticalTime);
        this.sbrTime = new JScrollBar(0, n, 0, 0, 10000);
        this.sbrTime.setPreferredSize(new Dimension(60, 20));
        jPanel6.add(this.sbrTime);
        jPanel4.add(jPanel6);
        jPanel3.add(jPanel4);
        JPanel jPanel7 = new JPanel();
        jPanel7.setPreferredSize(new Dimension(120, (this.getHeight() - 70) / 3));
        JPanel jPanel8 = new JPanel();
        jPanel8.setPreferredSize(new Dimension(120, 10));
        jPanel7.add(jPanel8);
        JLabel jLabel2 = new JLabel("Position of interest");
        jLabel2.setForeground(Color.black);
        jLabel2.setFont(RichardsEqn.labelFont);
        jPanel7.add(jLabel2);
        this.lPosition = new JLabel("(" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + ")");
        this.lPosition.setForeground(Color.black);
        this.lPosition.setFont(RichardsEqn.labelFont);
        jPanel7.add(this.lPosition);
        JPanel jPanel9 = new JPanel();
        this.tfPosition = new JTextField(RichardsEqn.formatLength(RichardsEqn.criticalPosition));
        this.tfPosition.setPreferredSize(new Dimension(50, 20));
        this.tfPosition.setFont(RichardsEqn.textFieldFont);
        jPanel9.add(this.tfPosition);
        n = (int)RichardsEqn.criticalPosition;
        this.posLimit = (int)(RichardsEqn.length + 0.5);
        this.sbrPosition = new JScrollBar(0, n, 0, 0, this.posLimit);
        this.sbrPosition.setPreferredSize(new Dimension(60, 20));
        jPanel9.add(this.sbrPosition);
        jPanel7.add(jPanel9);
        jPanel3.add(jPanel7);
        JPanel jPanel10 = new JPanel();
        jPanel10.setPreferredSize(new Dimension(120, (this.getHeight() - 70) / 3));
        jPanel10.setLayout(new GridLayout(5, 1, 0, 0));
        this.bCalculate = new JButton("Calculate");
        this.bSave = new JButton("Retain Line");
        this.bClear = new JButton("Clear Lines");
        this.bAbort = new JButton("Abort");
        this.bAbort.setEnabled(false);
        this.bCustomizer = new JButton("Customize");
        this.bCustomizer.setToolTipText("Customize Graph Axes Limits");
        this.oldBorder = this.bClear.getBorder();
        bntMouseListener bntMouseListener2 = new bntMouseListener();
        this.bClear.addMouseListener(bntMouseListener2);
        this.bSave.addMouseListener(bntMouseListener2);
        this.bCalculate.addMouseListener(bntMouseListener2);
        this.bAbort.addMouseListener(bntMouseListener2);
        this.bCustomizer.addMouseListener(bntMouseListener2);
        this.bSave.addActionListener(new forEvent("SaveImage"));
        this.bClear.addActionListener(new forEvent("ClearImage"));
        this.bCustomizer.addActionListener(new forEvent("CustomizeGraph"));
        jPanel10.add(this.bCalculate);
        jPanel10.add(this.bSave);
        jPanel10.add(this.bClear);
        jPanel10.add(this.bAbort);
        jPanel10.add(this.bCustomizer);
        jPanel3.add(jPanel10);
        jPanel.add((Component)jPanel3, "Center");
        jPanel.add((Component)jPanel2, "South");
        this.add((Component)jPanel, "East");
        this.tfPosition.addActionListener(new forEvent("Position"));
        this.tfTime.addActionListener(new forEvent("Time"));
        this.tfPosition.addMouseListener(new forEvent("Position"));
        this.tfTime.addMouseListener(new forEvent("Time"));
        this.sbrPosition.addAdjustmentListener(new forEvent("Position"));
        this.sbrTime.addAdjustmentListener(new forEvent("Time"));
        this.centerPane = new JPanel();
        this.centerPane.setLayout(new BoxLayout(this.centerPane, 1));
        upPanel = new UpTitlePanel();
        this.upGraph = new UpGraphPanel();
        this.lowPanel = new LowTitlePanel();
        this.lowGraph = new LowGraphPanel();
        this.captionP = new CaptionPanel();
        this.centerPane.add(upPanel);
        this.centerPane.add(this.upGraph);
        this.centerPane.add(this.lowPanel);
        this.centerPane.add(this.lowGraph);
        this.centerPane.add(this.captionP);
        this.add((Component)this.centerPane, "Center");
        this.addMouseListener(new forEvent(" "));
        this.hookupEvents();
    }

    void drawGraph(Graphics graphics, int n, boolean bl) {
        int n2;
        int n3;
        int n4;
        int n5;
        double d;
        double d2;
        double d3 = 1.0;
        double d4 = 0.0;
        double[] dArray = new double[5002];
        double[] dArray2 = new double[5002];
        double[] dArray3 = new double[5002];
        double[] dArray4 = new double[5002];
        double[] dArray5 = new double[4];
        int n6 = 6;
        int n7 = 6;
        int n8 = 8;
        int n9 = 12;
        int n10 = 12;
        String string = null;
        graphics.setColor(Color.red);
        Rectangle rectangle = new Rectangle(85, 4, this.gWidth, this.gHeight - 5);
        Tools.drawBorder(rectangle, 2, graphics);
        this.drawCurve = true;
        if (n == 15) {
            d2 = RichardsEqn.criticalTime > 0.0 ? RichardsEqn.xmax / Math.sqrt(RichardsEqn.criticalTime) : RichardsEqn.xmax / 0.1;
            d = 0.0;
        } else if (n <= 6) {
            d2 = RichardsEqn.xmax;
            d = 0.0;
        } else if (n > 6 && n < 15) {
            d2 = RichardsEqn.criticalTime;
            d = 0.0;
        } else if (n > 15 && n <= 18) {
            d2 = RichardsEqn.xmax;
            d = 0.0;
        } else {
            d2 = RichardsEqn.criticalTime;
            d = 0.0;
        }
        this.nDecimals = this.getDecimalNumber(d2, d);
        if (bl) {
            this.upXmin = this.autoUpLim[0] = Double.parseDouble(Tools.formatDouble(d, 5, this.nDecimals));
            this.upXmax = this.autoUpLim[1] = Double.parseDouble(Tools.formatDouble(d2, 5, this.nDecimals));
        } else {
            this.lowXmin = this.autoLowLim[0] = Double.parseDouble(Tools.formatDouble(d, 5, this.nDecimals));
            this.lowXmax = this.autoLowLim[1] = Double.parseDouble(Tools.formatDouble(d2, 5, this.nDecimals));
        }
        if (!CustomizeDialog.gpLimits[n].getAuto()) {
            if (d > CustomizeDialog.gpLimits[n].getXmax() || d2 < CustomizeDialog.gpLimits[n].getXmin()) {
                this.drawCurve = false;
            }
            d = CustomizeDialog.gpLimits[n].getXmin();
            d2 = CustomizeDialog.gpLimits[n].getXmax();
        }
        this.nDecimals = this.getDecimalNumber(d2, d);
        Tools.drawTicMarksOnX(d, d2, 0, 0, 5, this.nDecimals, 0, n8, this.fm, rectangle, graphics);
        switch (n) {
            case 0: {
                double d5;
                d4 = 0.0;
                d3 = 0.0;
                n5 = 0;
                while (n5 < 5) {
                    if (RichardsEqn.output[n5].nPoints > 0) {
                        n4 = 0;
                        while (n4 < RichardsEqn.output[n5].nPoints) {
                            d5 = RichardsEqn.output[n5].getWaterContent(n4);
                            if (d3 < d5) {
                                d3 = d5;
                            }
                            ++n4;
                        }
                    }
                    ++n5;
                }
                d3 = Math.ceil(d3 * 10.0) / 10.0;
                this.nDecimals = this.getDecimalNumber(d3, d4);
                if (bl) {
                    this.upYmin = this.autoUpLim[2] = Double.parseDouble(Tools.formatDouble(d4, 5, this.nDecimals));
                    this.upYmax = this.autoUpLim[3] = Double.parseDouble(Tools.formatDouble(d3, 5, this.nDecimals));
                } else {
                    this.lowYmin = this.autoLowLim[2] = Double.parseDouble(Tools.formatDouble(d4, 5, this.nDecimals));
                    this.lowYmax = this.autoLowLim[3] = Double.parseDouble(Tools.formatDouble(d3, 5, this.nDecimals));
                }
                if (!CustomizeDialog.gpLimits[n].getAuto()) {
                    if (d4 > CustomizeDialog.gpLimits[n].getYmax() || d3 < CustomizeDialog.gpLimits[n].getYmin()) {
                        this.drawCurve = false;
                    }
                    d4 = CustomizeDialog.gpLimits[n].getYmin();
                    d3 = CustomizeDialog.gpLimits[n].getYmax();
                }
                this.nDecimals = this.getDecimalNumber(d3, d4);
                Tools.drawTicMarksOnY(d4, d3, n9, n10, 5, this.nDecimals, 7, n8, this.fm, rectangle, graphics);
                n5 = 0;
                while (n5 < 5) {
                    if (RichardsEqn.output[n5].nPoints > 0) {
                        dArray = RichardsEqn.output[n5].z;
                        n4 = 0;
                        while (n4 < RichardsEqn.output[n5].nPoints) {
                            dArray2[n4] = RichardsEqn.output[n5].getWaterContent(n4);
                            ++n4;
                        }
                        graphics.setColor(RichardsEqn.colorLine[n5]);
                        if (this.drawCurve) {
                            Tools.plotXY(RichardsEqn.output[n5].nPoints - 1, dArray, dArray2, d, d2, d4, d3, 0, 0, n9, n10, rectangle, graphics);
                        }
                        if (!RichardsEqn.output[n5].isFinite && dArray[RichardsEqn.output[n5].nPoints - 1] < d2) {
                            dArray3[0] = dArray[RichardsEqn.output[n5].nPoints - 1];
                            dArray3[1] = d2;
                            dArray4[0] = dArray2[RichardsEqn.output[n5].nPoints - 1];
                            dArray4[1] = dArray4[0];
                            if (this.drawCurve) {
                                Tools.plotXY(1, dArray3, dArray4, d, d2, d4, d3, 0, 0, n9, n10, rectangle, graphics);
                            }
                        }
                    }
                    ++n5;
                }
                break;
            }
            case 1: {
                d4 = d3 = RichardsEqn.displayLength(RichardsEqn.output[RichardsEqn.currentLine].h[0]);
                n5 = 0;
                while (n5 < 5) {
                    if (RichardsEqn.output[n5].nPoints > 0) {
                        n4 = 0;
                        while (n4 < RichardsEqn.output[n5].nPoints) {
                            dArray2[n4] = RichardsEqn.displayLength(RichardsEqn.output[n5].h[n4]);
                            if (dArray2[n4] > d3) {
                                d3 = dArray2[n4];
                            }
                            if (dArray2[n4] < d4) {
                                d4 = dArray2[n4];
                            }
                            ++n4;
                        }
                    }
                    ++n5;
                }
                if (d3 - d4 < 10.0) {
                    d3 = d4 + 10.0;
                }
                d3 = 10.0 * Math.ceil(d3 / 10.0);
                d4 = 10.0 * Math.floor(d4 / 10.0);
                this.nDecimals = this.getDecimalNumber(d3, d4);
                if (bl) {
                    this.upYmin = this.autoUpLim[2] = Double.parseDouble(Tools.formatDouble(d4, 5, this.nDecimals));
                    this.upYmax = this.autoUpLim[3] = Double.parseDouble(Tools.formatDouble(d3, 5, this.nDecimals));
                } else {
                    this.lowYmin = this.autoLowLim[2] = Double.parseDouble(Tools.formatDouble(d4, 5, this.nDecimals));
                    this.lowYmax = this.autoLowLim[3] = Double.parseDouble(Tools.formatDouble(d3, 5, this.nDecimals));
                }
                if (!CustomizeDialog.gpLimits[n].getAuto()) {
                    if (d4 > CustomizeDialog.gpLimits[n].getYmax() || d3 < CustomizeDialog.gpLimits[n].getYmin()) {
                        this.drawCurve = false;
                    }
                    d4 = CustomizeDialog.gpLimits[n].getYmin();
                    d3 = CustomizeDialog.gpLimits[n].getYmax();
                }
                if (d3 * d4 < 0.0) {
                    Tools.drawHorizontalDashedLine(0.0, d4, d3, n9, n10, rectangle, graphics);
                }
                this.nDecimals = this.getDecimalNumber(d3, d4);
                Tools.drawTicMarksOnY(d4, d3, n9, n10, 5, this.nDecimals, 8, n8, this.fm, rectangle, graphics);
                n5 = 0;
                while (n5 < 5) {
                    if (RichardsEqn.output[n5].nPoints > 0) {
                        dArray = RichardsEqn.output[n5].z;
                        n4 = 0;
                        while (n4 < RichardsEqn.output[n5].nPoints) {
                            dArray2[n4] = RichardsEqn.displayLength(RichardsEqn.output[n5].h[n4]);
                            ++n4;
                        }
                        graphics.setColor(RichardsEqn.colorLine[n5]);
                        if (this.drawCurve) {
                            Tools.plotXY(RichardsEqn.output[n5].nPoints - 1, dArray, dArray2, d, d2, d4, d3, 0, 0, n9, n10, rectangle, graphics);
                        }
                        if (!RichardsEqn.output[n5].isFinite && dArray[RichardsEqn.output[n5].nPoints - 1] < d2) {
                            dArray3[0] = dArray[RichardsEqn.output[n5].nPoints - 1];
                            dArray3[1] = d2;
                            dArray4[0] = dArray2[RichardsEqn.output[n5].nPoints - 1];
                            dArray4[1] = dArray4[0];
                            if (this.drawCurve) {
                                Tools.plotXY(1, dArray3, dArray4, d, d2, d4, d3, 0, 0, n9, n10, rectangle, graphics);
                            }
                        }
                    }
                    ++n5;
                }
                break;
            }
            case 2: {
                double d5;
                d4 = 0.0;
                d3 = 0.0;
                n5 = 0;
                while (n5 < 5) {
                    if (RichardsEqn.output[n5].nPoints > 0) {
                        n4 = 0;
                        while (n4 < RichardsEqn.output[n5].nPoints) {
                            d5 = RichardsEqn.displayVelocity(RichardsEqn.output[n5].getK(n4));
                            if (d3 < d5) {
                                d3 = d5;
                            }
                            ++n4;
                        }
                        if (d3 < 1.0E-4) {
                            d3 = 1.0;
                        }
                    }
                    ++n5;
                }
                this.nDecimals = this.getDecimalNumber(d3, d4);
                if (bl) {
                    this.upYmin = this.autoUpLim[2] = Double.parseDouble(Tools.formatDouble(d4, 5, this.nDecimals));
                    this.upYmax = this.autoUpLim[3] = Double.parseDouble(Tools.formatDouble(d3, 5, this.nDecimals));
                } else {
                    this.lowYmin = this.autoLowLim[2] = Double.parseDouble(Tools.formatDouble(d4, 5, this.nDecimals));
                    this.lowYmax = this.autoLowLim[3] = Double.parseDouble(Tools.formatDouble(d3, 5, this.nDecimals));
                }
                if (!CustomizeDialog.gpLimits[n].getAuto()) {
                    if (d4 > CustomizeDialog.gpLimits[n].getYmax() || d3 < CustomizeDialog.gpLimits[n].getYmin()) {
                        this.drawCurve = false;
                    }
                    d4 = CustomizeDialog.gpLimits[n].getYmin();
                    d3 = CustomizeDialog.gpLimits[n].getYmax();
                }
                this.nDecimals = this.getDecimalNumber(d3, d4);
                Tools.drawTicMarksOnY(d4, d3, n9, n10, 5, this.nDecimals, 10, n8, this.fm, rectangle, graphics);
                n5 = 0;
                while (n5 < 5) {
                    if (RichardsEqn.output[n5].nPoints > 0) {
                        dArray = RichardsEqn.output[n5].z;
                        n4 = 0;
                        while (n4 < RichardsEqn.output[n5].nPoints) {
                            dArray2[n4] = RichardsEqn.displayVelocity(RichardsEqn.output[n5].getK(n4));
                            ++n4;
                        }
                        graphics.setColor(RichardsEqn.colorLine[n5]);
                        if (this.drawCurve) {
                            Tools.plotXY(RichardsEqn.output[n5].nPoints - 1, dArray, dArray2, d, d2, d4, d3, 0, 0, n9, n10, rectangle, graphics);
                        }
                        if (!RichardsEqn.output[n5].isFinite && dArray[RichardsEqn.output[n5].nPoints - 1] < d2) {
                            dArray3[0] = dArray[RichardsEqn.output[n5].nPoints - 1];
                            dArray3[1] = d2;
                            dArray4[0] = dArray2[RichardsEqn.output[n5].nPoints - 1];
                            dArray4[1] = dArray4[0];
                            if (this.drawCurve) {
                                Tools.plotXY(1, dArray3, dArray4, d, d2, d4, d3, 0, 0, n9, n10, rectangle, graphics);
                            }
                        }
                    }
                    ++n5;
                }
                break;
            }
            case 3: {
                double d5;
                d4 = RichardsEqn.output[0].s.getConductivity(0.0, 0.0);
                d3 = 0.0;
                n5 = 0;
                while (n5 < 5) {
                    if (RichardsEqn.output[n5].nPoints > 0) {
                        n4 = 0;
                        while (n4 < RichardsEqn.output[n5].nPoints) {
                            d5 = RichardsEqn.displayVelocity(RichardsEqn.output[n5].getK(n4));
                            if (d3 < d5) {
                                d3 = d5;
                            } else if (d4 > d5) {
                                d4 = d5;
                            }
                            ++n4;
                        }
                    }
                    ++n5;
                }
                if (d3 == 0.0) {
                    d3 = 1.0;
                }
                if (d4 == 0.0) {
                    d4 = 1.0E-20;
                }
                d3 = Math.log(d3) / RichardsEqn.ln10;
                d4 = Math.log(d4) / RichardsEqn.ln10;
                Tools.getLogLimits(d4, d3, dArray5);
                if (bl) {
                    string = "1.0E" + (int)dArray5[0];
                    this.upYmin = this.autoUpLim[2] = Double.parseDouble(string);
                    string = "1.0E" + (int)dArray5[1];
                    this.upYmax = this.autoUpLim[3] = Double.parseDouble(string);
                } else {
                    string = "1.0E" + (int)dArray5[0];
                    this.lowYmin = this.autoUpLim[2] = Double.parseDouble(string);
                    string = "1.0E" + (int)dArray5[1];
                    this.lowYmax = this.autoUpLim[3] = Double.parseDouble(string);
                }
                if (!CustomizeDialog.gpLimits[n].getAuto()) {
                    if (d4 > CustomizeDialog.gpLimits[n].getYmax() || d3 < CustomizeDialog.gpLimits[n].getYmin()) {
                        this.drawCurve = false;
                    }
                    d4 = CustomizeDialog.gpLimits[n].getYmin();
                    d3 = CustomizeDialog.gpLimits[n].getYmax();
                    if (d3 == 0.0) {
                        d3 = 1.0;
                    }
                    if (d4 == 0.0) {
                        d4 = 1.0E-20;
                    }
                    d3 = Math.log(d3) / RichardsEqn.ln10;
                    d4 = Math.log(d4) / RichardsEqn.ln10;
                    Tools.getLogLimits(d4, d3, dArray5);
                }
                Tools.drawTicMarksOnLogY(dArray5[0], dArray5[1], (int)dArray5[2], (int)dArray5[3], n9, n10, n8, this.fm, rectangle, graphics);
                n5 = 0;
                while (n5 < 5) {
                    if (RichardsEqn.output[n5].nPoints > 0) {
                        graphics.setColor(RichardsEqn.colorLine[n5]);
                        dArray = RichardsEqn.output[n5].z;
                        n4 = 0;
                        while (n4 < RichardsEqn.output[n5].nPoints) {
                            dArray2[n4] = Math.log(RichardsEqn.displayVelocity(RichardsEqn.output[n5].getK(n4))) / RichardsEqn.ln10;
                            ++n4;
                        }
                        if (this.drawCurve) {
                            Tools.plotXY(RichardsEqn.output[n5].nPoints - 1, dArray, dArray2, d, d2, dArray5[0], dArray5[1], 0, 0, n9, n10, rectangle, graphics);
                        }
                        if (!RichardsEqn.output[n5].isFinite && dArray[RichardsEqn.output[n5].nPoints - 1] < d2) {
                            dArray3[0] = dArray[RichardsEqn.output[n5].nPoints - 1];
                            dArray3[1] = d2;
                            dArray4[0] = dArray2[RichardsEqn.output[n5].nPoints - 1];
                            dArray4[1] = dArray4[0];
                            if (this.drawCurve) {
                                Tools.plotXY(1, dArray3, dArray4, d, d2, dArray5[0], dArray5[1], 0, 0, n9, n10, rectangle, graphics);
                            }
                        }
                    }
                    ++n5;
                }
                break;
            }
            case 4: {
                n5 = 0;
                while (n5 < 5) {
                    if (RichardsEqn.output[n5].nPoints > 0) {
                        n4 = 0;
                        while (n4 < RichardsEqn.output[n5].nPoints) {
                            dArray2[n4] = RichardsEqn.output[n5].getDrivingForce(n4);
                            ++n4;
                        }
                        if (n5 == 0) {
                            d4 = dArray2[1];
                            d3 = dArray2[1];
                        }
                        n4 = 0;
                        while (n4 < RichardsEqn.output[n5].nPoints) {
                            if (dArray2[n4] > d3) {
                                d3 = dArray2[n4];
                            }
                            if (dArray2[n4] < d4) {
                                d4 = dArray2[n4];
                            }
                            ++n4;
                        }
                        if (d3 == d4) {
                            d3 += 3.0;
                            d4 -= 2.0;
                        }
                    }
                    ++n5;
                }
                d3 = 5.0 * Math.ceil(d3 / 5.0);
                d4 = 5.0 * Math.floor(d4 / 5.0);
                this.nDecimals = this.getDecimalNumber(d3, d4);
                if (bl) {
                    this.upYmin = this.autoUpLim[2] = Double.parseDouble(Tools.formatDouble(d4, 5, this.nDecimals));
                    this.upYmax = this.autoUpLim[3] = Double.parseDouble(Tools.formatDouble(d3, 5, this.nDecimals));
                } else {
                    this.lowYmin = this.autoLowLim[2] = Double.parseDouble(Tools.formatDouble(d4, 5, this.nDecimals));
                    this.lowYmax = this.autoLowLim[3] = Double.parseDouble(Tools.formatDouble(d3, 5, this.nDecimals));
                }
                if (!CustomizeDialog.gpLimits[n].getAuto()) {
                    if (d4 > CustomizeDialog.gpLimits[n].getYmax() || d3 < CustomizeDialog.gpLimits[n].getYmin()) {
                        this.drawCurve = false;
                    }
                    d4 = CustomizeDialog.gpLimits[n].getYmin();
                    d3 = CustomizeDialog.gpLimits[n].getYmax();
                }
                this.nDecimals = this.getDecimalNumber(d3, d4);
                Tools.drawTicMarksOnY(d4, d3, n9, n10, 5, this.nDecimals, 8, n8, this.fm, rectangle, graphics);
                if (d3 * d4 < 0.0) {
                    Tools.drawHorizontalDashedLine(0.0, d4, d3, n9, n10, rectangle, graphics);
                }
                n5 = 0;
                while (n5 < 5) {
                    if (RichardsEqn.output[n5].nPoints > 0) {
                        dArray = RichardsEqn.output[n5].z;
                        n4 = 0;
                        while (n4 < RichardsEqn.output[n5].nPoints) {
                            dArray2[n4] = RichardsEqn.output[n5].getDrivingForce(n4);
                            ++n4;
                        }
                        graphics.setColor(RichardsEqn.colorLine[n5]);
                        if (this.drawCurve) {
                            Tools.plotXY(RichardsEqn.output[n5].nPoints - 1, dArray, dArray2, d, d2, d4, d3, 0, 0, n9, n10, rectangle, graphics);
                        }
                        if (!RichardsEqn.output[n5].isFinite && dArray[RichardsEqn.output[n5].nPoints - 1] < d2) {
                            dArray3[0] = dArray[RichardsEqn.output[n5].nPoints - 1];
                            dArray3[1] = d2;
                            dArray4[0] = dArray2[RichardsEqn.output[n5].nPoints - 1];
                            dArray4[1] = dArray4[0];
                            if (this.drawCurve) {
                                Tools.plotXY(1, dArray3, dArray4, d, d2, d4, d3, 0, 0, n9, n10, rectangle, graphics);
                            }
                        }
                    }
                    ++n5;
                }
                break;
            }
            case 5: {
                n5 = 0;
                while (n5 < 5) {
                    if (RichardsEqn.output[n5].nPoints > 0) {
                        n4 = 0;
                        while (n4 < RichardsEqn.output[n5].nPoints) {
                            dArray2[n4] = RichardsEqn.displayVelocity(RichardsEqn.output[n5].getFluxDensity(n4));
                            ++n4;
                        }
                        if (n5 == 0) {
                            d4 = dArray2[1];
                            d3 = dArray2[1];
                        }
                        n4 = 0;
                        while (n4 < RichardsEqn.output[n5].nPoints) {
                            if (dArray2[n4] > d3) {
                                d3 = dArray2[n4];
                            }
                            if (dArray2[n4] < d4) {
                                d4 = dArray2[n4];
                            }
                            ++n4;
                        }
                    }
                    ++n5;
                }
                if (d3 == d4) {
                    d3 += 0.1;
                }
                this.nDecimals = this.getDecimalNumber(d3, d4);
                if (bl) {
                    this.upYmin = this.autoUpLim[2] = Double.parseDouble(Tools.formatDouble(d4, 5, this.nDecimals));
                    this.upYmax = this.autoUpLim[3] = Double.parseDouble(Tools.formatDouble(d3, 5, this.nDecimals));
                } else {
                    this.lowYmin = this.autoLowLim[2] = Double.parseDouble(Tools.formatDouble(d4, 5, this.nDecimals));
                    this.lowYmax = this.autoLowLim[3] = Double.parseDouble(Tools.formatDouble(d3, 5, this.nDecimals));
                }
                if (!CustomizeDialog.gpLimits[n].getAuto()) {
                    if (d4 > CustomizeDialog.gpLimits[n].getYmax() || d3 < CustomizeDialog.gpLimits[n].getYmin()) {
                        this.drawCurve = false;
                    }
                    d4 = CustomizeDialog.gpLimits[n].getYmin();
                    d3 = CustomizeDialog.gpLimits[n].getYmax();
                }
                this.nDecimals = this.getDecimalNumber(d3, d4);
                Tools.drawTicMarksOnY(d4, d3, n9, n10, 5, this.nDecimals, 8, n8, this.fm, rectangle, graphics);
                if (d3 * d4 < 0.0) {
                    Tools.drawHorizontalDashedLine(0.0, d4, d3, n9, n10, rectangle, graphics);
                }
                n5 = 0;
                while (n5 < 5) {
                    if (RichardsEqn.output[n5].nPoints > 0) {
                        dArray = RichardsEqn.output[n5].z;
                        n4 = 0;
                        while (n4 < RichardsEqn.output[n5].nPoints) {
                            dArray2[n4] = RichardsEqn.displayVelocity(RichardsEqn.output[n5].getFluxDensity(n4));
                            ++n4;
                        }
                        graphics.setColor(RichardsEqn.colorLine[n5]);
                        if (this.drawCurve) {
                            Tools.plotXY(RichardsEqn.output[n5].nPoints - 1, dArray, dArray2, d, d2, d4, d3, 0, 0, n9, n10, rectangle, graphics);
                        }
                        if (!RichardsEqn.output[n5].isFinite && dArray[RichardsEqn.output[n5].nPoints - 1] < d2) {
                            dArray3[0] = dArray[RichardsEqn.output[n5].nPoints - 1];
                            dArray3[1] = d2;
                            dArray4[0] = dArray2[RichardsEqn.output[n5].nPoints - 1];
                            dArray4[1] = dArray4[0];
                            if (this.drawCurve) {
                                Tools.plotXY(1, dArray3, dArray4, d, d2, d4, d3, 0, 0, n9, n10, rectangle, graphics);
                            }
                        }
                    }
                    ++n5;
                }
                break;
            }
            case 6: {
                n5 = 0;
                while (n5 < 5) {
                    if (RichardsEqn.output[n5].nPoints > 0) {
                        n4 = 0;
                        while (n4 < RichardsEqn.output[n5].nPoints) {
                            dArray2[n4] = RichardsEqn.displayLength(RichardsEqn.output[n5].getTotalPotential(n4));
                            ++n4;
                        }
                        if (n5 == 0) {
                            d4 = dArray2[1];
                            d3 = dArray2[1];
                        }
                        n4 = 0;
                        while (n4 < RichardsEqn.output[n5].nPoints) {
                            if (dArray2[n4] > d3) {
                                d3 = dArray2[n4];
                            }
                            if (dArray2[n4] < d4) {
                                d4 = dArray2[n4];
                            }
                            ++n4;
                        }
                        dArray4[1] = RichardsEqn.output[n5].h[RichardsEqn.output[n5].nPoints - 1] - d2 * RichardsEqn.output[n5].sinAngle;
                        if (dArray4[1] > d3) {
                            d3 = dArray4[1];
                        }
                        if (dArray4[1] < d4) {
                            d4 = dArray4[1];
                        }
                    }
                    ++n5;
                }
                if (d3 == d4) {
                    d3 += 1.0;
                }
                d3 = 10.0 * Math.ceil(d3 / 10.0);
                d4 = 10.0 * Math.floor(d4 / 10.0);
                this.nDecimals = this.getDecimalNumber(d3, d4);
                if (bl) {
                    this.upYmin = this.autoUpLim[2] = Double.parseDouble(Tools.formatDouble(d4, 5, this.nDecimals));
                    this.upYmax = this.autoUpLim[3] = Double.parseDouble(Tools.formatDouble(d3, 5, this.nDecimals));
                } else {
                    this.lowYmin = this.autoLowLim[2] = Double.parseDouble(Tools.formatDouble(d4, 5, this.nDecimals));
                    this.lowYmax = this.autoLowLim[3] = Double.parseDouble(Tools.formatDouble(d3, 5, this.nDecimals));
                }
                if (!CustomizeDialog.gpLimits[n].getAuto()) {
                    if (d4 > CustomizeDialog.gpLimits[n].getYmax() || d3 < CustomizeDialog.gpLimits[n].getYmin()) {
                        this.drawCurve = false;
                    }
                    d4 = CustomizeDialog.gpLimits[n].getYmin();
                    d3 = CustomizeDialog.gpLimits[n].getYmax();
                }
                this.nDecimals = this.getDecimalNumber(d3, d4);
                Tools.drawTicMarksOnY(d4, d3, n9, n10, 5, this.nDecimals, 8, n8, this.fm, rectangle, graphics);
                if (d3 * d4 < 0.0) {
                    Tools.drawHorizontalDashedLine(0.0, d4, d3, n9, n10, rectangle, graphics);
                }
                n5 = 0;
                while (n5 < 5) {
                    if (RichardsEqn.output[n5].nPoints > 0) {
                        dArray = RichardsEqn.output[n5].z;
                        n4 = 0;
                        while (n4 < RichardsEqn.output[n5].nPoints) {
                            dArray2[n4] = RichardsEqn.displayLength(RichardsEqn.output[n5].getTotalPotential(n4));
                            ++n4;
                        }
                        graphics.setColor(RichardsEqn.colorLine[n5]);
                        if (this.drawCurve) {
                            Tools.plotXY(RichardsEqn.output[n5].nPoints - 1, dArray, dArray2, d, d2, d4, d3, 0, 0, n9, n10, rectangle, graphics);
                        }
                        if (!RichardsEqn.output[n5].isFinite && dArray[RichardsEqn.output[n5].nPoints - 1] < d2) {
                            dArray3[0] = dArray[RichardsEqn.output[n5].nPoints - 1];
                            dArray3[1] = d2;
                            dArray4[0] = dArray2[RichardsEqn.output[n5].nPoints - 1];
                            dArray4[1] = RichardsEqn.output[n5].h[RichardsEqn.output[n5].nPoints - 1] - RichardsEqn.output[n5].sinAngle * d2;
                            if (this.drawCurve) {
                                Tools.plotXY(1, dArray3, dArray4, d, d2, d4, d3, 0, 0, n9, n10, rectangle, graphics);
                            }
                        }
                    }
                    ++n5;
                }
                break;
            }
            case 7: {
                double d5;
                d4 = 0.0;
                d3 = 0.0;
                n5 = 0;
                while (n5 < 5) {
                    if (RichardsEqn.output[n5].nPointsSaved > 0) {
                        n4 = 0;
                        while (n4 < RichardsEqn.output[n5].nPointsSaved) {
                            d5 = RichardsEqn.output[n5].getWaterContentAtDepth(RichardsEqn.output[n5].mp[n4]);
                            if (d3 < d5) {
                                d3 = d5;
                            }
                            ++n4;
                        }
                    }
                    ++n5;
                }
                d3 = Math.ceil(d3 * 10.0) / 10.0;
                this.nDecimals = this.getDecimalNumber(d3, d4);
                if (bl) {
                    this.upYmin = this.autoUpLim[2] = Double.parseDouble(Tools.formatDouble(d4, 5, this.nDecimals));
                    this.upYmax = this.autoUpLim[3] = Double.parseDouble(Tools.formatDouble(d3, 5, this.nDecimals));
                } else {
                    this.lowYmin = this.autoLowLim[2] = Double.parseDouble(Tools.formatDouble(d4, 5, this.nDecimals));
                    this.lowYmax = this.autoLowLim[3] = Double.parseDouble(Tools.formatDouble(d3, 5, this.nDecimals));
                }
                if (!CustomizeDialog.gpLimits[n].getAuto()) {
                    if (d4 > CustomizeDialog.gpLimits[n].getYmax() || d3 < CustomizeDialog.gpLimits[n].getYmin()) {
                        this.drawCurve = false;
                    }
                    d4 = CustomizeDialog.gpLimits[n].getYmin();
                    d3 = CustomizeDialog.gpLimits[n].getYmax();
                }
                this.nDecimals = this.getDecimalNumber(d3, d4);
                Tools.drawTicMarksOnY(d4, d3, n9, n10, 5, this.nDecimals, 7, n8, this.fm, rectangle, graphics);
                n5 = 0;
                while (n5 < 5) {
                    if (RichardsEqn.output[n5].nPointsSaved > 0) {
                        dArray = RichardsEqn.output[n5].time;
                        n4 = 0;
                        while (n4 < RichardsEqn.output[n5].nPointsSaved) {
                            dArray2[n4] = RichardsEqn.output[n5].getWaterContentAtDepth(RichardsEqn.output[n5].mp[n4]);
                            ++n4;
                        }
                        graphics.setColor(RichardsEqn.colorLine[n5]);
                        if (this.drawCurve) {
                            if (RichardsEqn.output[n5].depth == 0.0) {
                                Tools.plotXY(1, RichardsEqn.output[n5].nPointsSaved - 1, dArray, dArray2, d, d2, d4, d3, 0, 0, n9, n10, rectangle, graphics);
                            } else {
                                Tools.plotXY(0, RichardsEqn.output[n5].nPointsSaved - 1, dArray, dArray2, d, d2, d4, d3, 0, 0, n9, n10, rectangle, graphics);
                            }
                        }
                    }
                    ++n5;
                }
                break;
            }
            case 8: {
                d4 = d3 = RichardsEqn.displayLength(RichardsEqn.output[RichardsEqn.currentLine].mp[0]);
                n5 = 0;
                while (n5 < 5) {
                    if (RichardsEqn.output[n5].nPointsSaved > 0) {
                        n4 = 0;
                        while (n4 < RichardsEqn.output[n5].nPointsSaved) {
                            dArray2[n4] = RichardsEqn.displayLength(RichardsEqn.output[n5].mp[n4]);
                            if (dArray2[n4] > d3) {
                                d3 = dArray2[n4];
                            }
                            if (dArray2[n4] < d4) {
                                d4 = dArray2[n4];
                            }
                            ++n4;
                        }
                    }
                    ++n5;
                }
                if (d3 - d4 < 10.0) {
                    d3 = d4 + 10.0;
                }
                d3 = 10.0 * Math.ceil(d3 / 10.0);
                d4 = 10.0 * Math.floor(d4 / 10.0);
                this.nDecimals = this.getDecimalNumber(d3, d4);
                if (bl) {
                    this.upYmin = this.autoUpLim[2] = Double.parseDouble(Tools.formatDouble(d4, 5, this.nDecimals));
                    this.upYmax = this.autoUpLim[3] = Double.parseDouble(Tools.formatDouble(d3, 5, this.nDecimals));
                } else {
                    this.lowYmin = this.autoLowLim[2] = Double.parseDouble(Tools.formatDouble(d4, 5, this.nDecimals));
                    this.lowYmax = this.autoLowLim[3] = Double.parseDouble(Tools.formatDouble(d3, 5, this.nDecimals));
                }
                if (!CustomizeDialog.gpLimits[n].getAuto()) {
                    if (d4 > CustomizeDialog.gpLimits[n].getYmax() || d3 < CustomizeDialog.gpLimits[n].getYmin()) {
                        this.drawCurve = false;
                    }
                    d4 = CustomizeDialog.gpLimits[n].getYmin();
                    d3 = CustomizeDialog.gpLimits[n].getYmax();
                }
                if (d3 * d4 < 0.0) {
                    Tools.drawHorizontalDashedLine(0.0, d4, d3, n9, n10, rectangle, graphics);
                }
                this.nDecimals = this.getDecimalNumber(d3, d4);
                Tools.drawTicMarksOnY(d4, d3, n9, n10, 5, this.nDecimals, 8, n8, this.fm, rectangle, graphics);
                n5 = 0;
                while (n5 < 5) {
                    if (RichardsEqn.output[n5].nPointsSaved > 0) {
                        dArray = RichardsEqn.output[n5].time;
                        n4 = 0;
                        while (n4 < RichardsEqn.output[n5].nPointsSaved) {
                            dArray2[n4] = RichardsEqn.displayLength(RichardsEqn.output[n5].mp[n4]);
                            ++n4;
                        }
                        graphics.setColor(RichardsEqn.colorLine[n5]);
                        if (this.drawCurve) {
                            if (RichardsEqn.output[n5].depth == 0.0) {
                                Tools.plotXY(1, RichardsEqn.output[n5].nPointsSaved - 1, dArray, dArray2, d, d2, d4, d3, 0, 0, n9, n10, rectangle, graphics);
                            } else {
                                Tools.plotXY(0, RichardsEqn.output[n5].nPointsSaved - 1, dArray, dArray2, d, d2, d4, d3, 0, 0, n9, n10, rectangle, graphics);
                            }
                        }
                    }
                    ++n5;
                }
                break;
            }
            case 9: {
                double d5;
                d4 = 0.0;
                d3 = 0.0;
                n5 = 0;
                while (n5 < 5) {
                    if (RichardsEqn.output[n5].nPointsSaved > 0) {
                        n4 = 0;
                        while (n4 < RichardsEqn.output[n5].nPointsSaved) {
                            d5 = RichardsEqn.displayVelocity(RichardsEqn.output[n5].getKatDepth(RichardsEqn.output[n5].mp[n4]));
                            if (d3 < d5) {
                                d3 = d5;
                            }
                            ++n4;
                        }
                        if (d3 < 1.0E-4) {
                            d3 = 1.0;
                        }
                    }
                    ++n5;
                }
                this.nDecimals = this.getDecimalNumber(d3, d4);
                if (bl) {
                    this.upYmin = this.autoUpLim[2] = Double.parseDouble(Tools.formatDouble(d4, 5, this.nDecimals));
                    this.upYmax = this.autoUpLim[3] = Double.parseDouble(Tools.formatDouble(d3, 5, this.nDecimals));
                } else {
                    this.lowYmin = this.autoLowLim[2] = Double.parseDouble(Tools.formatDouble(d4, 5, this.nDecimals));
                    this.lowYmax = this.autoLowLim[3] = Double.parseDouble(Tools.formatDouble(d3, 5, this.nDecimals));
                }
                if (!CustomizeDialog.gpLimits[n].getAuto()) {
                    if (d4 > CustomizeDialog.gpLimits[n].getYmax() || d3 < CustomizeDialog.gpLimits[n].getYmin()) {
                        this.drawCurve = false;
                    }
                    d4 = CustomizeDialog.gpLimits[n].getYmin();
                    d3 = CustomizeDialog.gpLimits[n].getYmax();
                }
                this.nDecimals = this.getDecimalNumber(d3, d4);
                Tools.drawTicMarksOnY(d4, d3, n9, n10, 5, this.nDecimals, 10, n8, this.fm, rectangle, graphics);
                n5 = 0;
                while (n5 < 5) {
                    if (RichardsEqn.output[n5].nPointsSaved > 0) {
                        dArray = RichardsEqn.output[n5].time;
                        n4 = 0;
                        while (n4 < RichardsEqn.output[n5].nPointsSaved) {
                            dArray2[n4] = RichardsEqn.displayVelocity(RichardsEqn.output[n5].getKatDepth(RichardsEqn.output[n5].mp[n4]));
                            ++n4;
                        }
                        graphics.setColor(RichardsEqn.colorLine[n5]);
                        if (this.drawCurve) {
                            if (RichardsEqn.output[n5].depth == 0.0) {
                                Tools.plotXY(1, RichardsEqn.output[n5].nPointsSaved - 1, dArray, dArray2, d, d2, d4, d3, 0, 0, n9, n10, rectangle, graphics);
                            } else {
                                Tools.plotXY(0, RichardsEqn.output[n5].nPointsSaved - 1, dArray, dArray2, d, d2, d4, d3, 0, 0, n9, n10, rectangle, graphics);
                            }
                        }
                    }
                    ++n5;
                }
                break;
            }
            case 10: {
                double d5;
                d4 = RichardsEqn.output[0].getKatDepth(RichardsEqn.output[0].mp[0]);
                d3 = 0.0;
                n5 = 0;
                while (n5 < 5) {
                    if (RichardsEqn.output[n5].nPointsSaved > 0) {
                        n4 = 0;
                        while (n4 < RichardsEqn.output[n5].nPointsSaved) {
                            d5 = RichardsEqn.displayVelocity(RichardsEqn.output[n5].getKatDepth(RichardsEqn.output[n5].mp[n4]));
                            if (d3 < d5) {
                                d3 = d5;
                            } else if (d4 > d5) {
                                d4 = d5;
                            }
                            ++n4;
                        }
                    }
                    ++n5;
                }
                if (d3 == 0.0) {
                    d3 = 1.0;
                }
                if (d4 == 0.0) {
                    d4 = 1.0E-20;
                }
                d3 = Math.log(d3) / RichardsEqn.ln10;
                d4 = Math.log(d4) / RichardsEqn.ln10;
                Tools.getLogLimits(d4, d3, dArray5);
                if (bl) {
                    string = "1.0E" + (int)dArray5[0];
                    this.upYmin = this.autoUpLim[2] = Double.parseDouble(string);
                    string = "1.0E" + (int)dArray5[1];
                    this.upYmax = this.autoUpLim[3] = Double.parseDouble(string);
                } else {
                    string = "1.0E" + (int)dArray5[0];
                    this.lowYmin = this.autoUpLim[2] = Double.parseDouble(string);
                    string = "1.0E" + (int)dArray5[1];
                    this.lowYmax = this.autoUpLim[3] = Double.parseDouble(string);
                }
                if (!CustomizeDialog.gpLimits[n].getAuto()) {
                    if (d4 > CustomizeDialog.gpLimits[n].getYmax() || d3 < CustomizeDialog.gpLimits[n].getYmin()) {
                        this.drawCurve = false;
                    }
                    d4 = CustomizeDialog.gpLimits[n].getYmin();
                    d3 = CustomizeDialog.gpLimits[n].getYmax();
                    if (d3 == 0.0) {
                        d3 = 1.0;
                    }
                    if (d4 == 0.0) {
                        d4 = 1.0E-20;
                    }
                    d3 = Math.log(d3) / RichardsEqn.ln10;
                    d4 = Math.log(d4) / RichardsEqn.ln10;
                    Tools.getLogLimits(d4, d3, dArray5);
                }
                Tools.drawTicMarksOnLogY(dArray5[0], dArray5[1], (int)dArray5[2], (int)dArray5[3], n9, n10, n8, this.fm, rectangle, graphics);
                n5 = 0;
                while (n5 < 5) {
                    if (RichardsEqn.output[n5].nPointsSaved > 0) {
                        graphics.setColor(RichardsEqn.colorLine[n5]);
                        dArray = RichardsEqn.output[n5].time;
                        n4 = 0;
                        while (n4 < RichardsEqn.output[n5].nPointsSaved) {
                            dArray2[n4] = Math.log(RichardsEqn.displayVelocity(RichardsEqn.output[n5].getKatDepth(RichardsEqn.output[n5].mp[n4]))) / RichardsEqn.ln10;
                            ++n4;
                        }
                        if (this.drawCurve) {
                            if (RichardsEqn.output[n5].depth == 0.0) {
                                Tools.plotXY(1, RichardsEqn.output[n5].nPointsSaved - 1, dArray, dArray2, d, d2, dArray5[0], dArray5[1], 0, 0, n9, n10, rectangle, graphics);
                            } else {
                                Tools.plotXY(0, RichardsEqn.output[n5].nPointsSaved - 1, dArray, dArray2, d, d2, dArray5[0], dArray5[1], 0, 0, n9, n10, rectangle, graphics);
                            }
                        }
                    }
                    ++n5;
                }
                break;
            }
            case 11: {
                d4 = 0.0;
                d3 = 0.0;
                n5 = 0;
                while (n5 < 5) {
                    if (RichardsEqn.output[n5].nPointsSaved > 0) {
                        n4 = 0;
                        while (n4 < RichardsEqn.output[n5].nPointsSaved) {
                            dArray2[n4] = RichardsEqn.output[n5].getDrivingForceAtDepth(n4);
                            if (dArray2[n4] > d3) {
                                d3 = dArray2[n4];
                            }
                            if (dArray2[n4] < d4) {
                                d4 = dArray2[n4];
                            }
                            ++n4;
                        }
                        if (d3 == d4) {
                            d3 += 3.0;
                            d4 -= 2.0;
                        }
                    }
                    ++n5;
                }
                d3 = 5.0 * Math.ceil(d3 / 5.0);
                d4 = 5.0 * Math.floor(d4 / 5.0);
                this.nDecimals = this.getDecimalNumber(d3, d4);
                if (bl) {
                    this.upYmin = this.autoUpLim[2] = Double.parseDouble(Tools.formatDouble(d4, 5, this.nDecimals));
                    this.upYmax = this.autoUpLim[3] = Double.parseDouble(Tools.formatDouble(d3, 5, this.nDecimals));
                } else {
                    this.lowYmin = this.autoLowLim[2] = Double.parseDouble(Tools.formatDouble(d4, 5, this.nDecimals));
                    this.lowYmax = this.autoLowLim[3] = Double.parseDouble(Tools.formatDouble(d3, 5, this.nDecimals));
                }
                if (!CustomizeDialog.gpLimits[n].getAuto()) {
                    if (d4 > CustomizeDialog.gpLimits[n].getYmax() || d3 < CustomizeDialog.gpLimits[n].getYmin()) {
                        this.drawCurve = false;
                    }
                    d4 = CustomizeDialog.gpLimits[n].getYmin();
                    d3 = CustomizeDialog.gpLimits[n].getYmax();
                }
                this.nDecimals = this.getDecimalNumber(d3, d4);
                Tools.drawTicMarksOnY(d4, d3, n9, n10, 5, this.nDecimals, 8, n8, this.fm, rectangle, graphics);
                if (d3 * d4 < 0.0) {
                    Tools.drawHorizontalDashedLine(0.0, d4, d3, n9, n10, rectangle, graphics);
                }
                n5 = 0;
                while (n5 < 5) {
                    if (RichardsEqn.output[n5].nPointsSaved > 0) {
                        dArray = RichardsEqn.output[n5].time;
                        n4 = 0;
                        while (n4 < RichardsEqn.output[n5].nPointsSaved) {
                            dArray2[n4] = RichardsEqn.output[n5].getDrivingForceAtDepth(n4);
                            ++n4;
                        }
                        graphics.setColor(RichardsEqn.colorLine[n5]);
                        if (this.drawCurve) {
                            if (RichardsEqn.output[n5].depth == 0.0) {
                                Tools.plotXY(1, RichardsEqn.output[n5].nPointsSaved - 1, dArray, dArray2, d, d2, d4, d3, 0, 0, n9, n10, rectangle, graphics);
                            } else {
                                Tools.plotXY(0, RichardsEqn.output[n5].nPointsSaved - 1, dArray, dArray2, d, d2, d4, d3, 0, 0, n9, n10, rectangle, graphics);
                            }
                        }
                    }
                    ++n5;
                }
                break;
            }
            case 12: {
                n5 = 0;
                while (n5 < 5) {
                    if (RichardsEqn.output[n5].nPointsSaved > 0) {
                        n4 = 0;
                        while (n4 < RichardsEqn.output[n5].nPointsSaved) {
                            dArray2[n4] = RichardsEqn.displayVelocity(RichardsEqn.output[n5].q[n4]);
                            ++n4;
                        }
                        if (n5 == 0) {
                            d4 = dArray2[1];
                            d3 = dArray2[1];
                        }
                        n4 = 0;
                        while (n4 < RichardsEqn.output[n5].nPointsSaved) {
                            if (dArray2[n4] > d3) {
                                d3 = dArray2[n4];
                            }
                            if (dArray2[n4] < d4) {
                                d4 = dArray2[n4];
                            }
                            ++n4;
                        }
                    }
                    ++n5;
                }
                if (d3 == d4) {
                    d3 += 0.1;
                }
                this.nDecimals = this.getDecimalNumber(d3, d4);
                if (bl) {
                    this.upYmin = this.autoUpLim[2] = Double.parseDouble(Tools.formatDouble(d4, 5, this.nDecimals));
                    this.upYmax = this.autoUpLim[3] = Double.parseDouble(Tools.formatDouble(d3, 5, this.nDecimals));
                } else {
                    this.lowYmin = this.autoLowLim[2] = Double.parseDouble(Tools.formatDouble(d4, 5, this.nDecimals));
                    this.lowYmax = this.autoLowLim[3] = Double.parseDouble(Tools.formatDouble(d3, 5, this.nDecimals));
                }
                if (!CustomizeDialog.gpLimits[n].getAuto()) {
                    if (d4 > CustomizeDialog.gpLimits[n].getYmax() || d3 < CustomizeDialog.gpLimits[n].getYmin()) {
                        this.drawCurve = false;
                    }
                    d4 = CustomizeDialog.gpLimits[n].getYmin();
                    d3 = CustomizeDialog.gpLimits[n].getYmax();
                    this.nDecimals = this.getDecimalNumber(d3, d4);
                }
                Tools.drawTicMarksOnY(d4, d3, n9, n10, 5, this.nDecimals, 8, n8, this.fm, rectangle, graphics);
                if (d3 * d4 < 0.0) {
                    Tools.drawHorizontalDashedLine(0.0, d4, d3, n9, n10, rectangle, graphics);
                }
                n5 = 0;
                while (n5 < 5) {
                    if (RichardsEqn.output[n5].nPointsSaved > 0) {
                        dArray = RichardsEqn.output[n5].time;
                        n4 = 0;
                        while (n4 < RichardsEqn.output[n5].nPointsSaved) {
                            dArray2[n4] = RichardsEqn.displayVelocity(RichardsEqn.output[n5].q[n4]);
                            ++n4;
                        }
                        graphics.setColor(RichardsEqn.colorLine[n5]);
                        if (this.drawCurve) {
                            if (RichardsEqn.output[n5].depth == 0.0) {
                                Tools.plotXY(1, RichardsEqn.output[n5].nPointsSaved - 1, dArray, dArray2, d, d2, d4, d3, 0, 0, n9, n10, rectangle, graphics);
                            } else {
                                Tools.plotXY(0, RichardsEqn.output[n5].nPointsSaved - 1, dArray, dArray2, d, d2, d4, d3, 0, 0, n9, n10, rectangle, graphics);
                            }
                        }
                    }
                    ++n5;
                }
                break;
            }
            case 13: {
                n5 = 0;
                while (n5 < 5) {
                    if (RichardsEqn.output[n5].nPointsSaved > 0) {
                        n4 = 0;
                        while (n4 < RichardsEqn.output[n5].nPointsSaved) {
                            dArray2[n4] = RichardsEqn.displayLength(RichardsEqn.output[n5].getTotalPotential(RichardsEqn.output[n5].mp[n4], RichardsEqn.output[n5].depth));
                            ++n4;
                        }
                        if (n5 == 0) {
                            d4 = dArray2[1];
                            d3 = dArray2[1];
                        }
                        n4 = 0;
                        while (n4 < RichardsEqn.output[n5].nPointsSaved) {
                            if (dArray2[n4] > d3) {
                                d3 = dArray2[n4];
                            }
                            if (dArray2[n4] < d4) {
                                d4 = dArray2[n4];
                            }
                            ++n4;
                        }
                    }
                    ++n5;
                }
                if (d3 == d4) {
                    d3 += 1.0;
                }
                d3 = 10.0 * Math.ceil(d3 / 10.0);
                d4 = 10.0 * Math.floor(d4 / 10.0);
                this.nDecimals = this.getDecimalNumber(d3, d4);
                if (bl) {
                    this.upYmin = this.autoUpLim[2] = Double.parseDouble(Tools.formatDouble(d4, 5, this.nDecimals));
                    this.upYmax = this.autoUpLim[3] = Double.parseDouble(Tools.formatDouble(d3, 5, this.nDecimals));
                } else {
                    this.lowYmin = this.autoLowLim[2] = Double.parseDouble(Tools.formatDouble(d4, 5, this.nDecimals));
                    this.lowYmax = this.autoLowLim[3] = Double.parseDouble(Tools.formatDouble(d3, 5, this.nDecimals));
                }
                if (!CustomizeDialog.gpLimits[n].getAuto()) {
                    if (d4 > CustomizeDialog.gpLimits[n].getYmax() || d3 < CustomizeDialog.gpLimits[n].getYmin()) {
                        this.drawCurve = false;
                    }
                    d4 = CustomizeDialog.gpLimits[n].getYmin();
                    d3 = CustomizeDialog.gpLimits[n].getYmax();
                }
                this.nDecimals = this.getDecimalNumber(d3, d4);
                Tools.drawTicMarksOnY(d4, d3, n9, n10, 5, this.nDecimals, 8, n8, this.fm, rectangle, graphics);
                if (d3 * d4 < 0.0) {
                    Tools.drawHorizontalDashedLine(0.0, d4, d3, n9, n10, rectangle, graphics);
                }
                n5 = 0;
                while (n5 < 5) {
                    if (RichardsEqn.output[n5].nPointsSaved > 0) {
                        dArray = RichardsEqn.output[n5].time;
                        n4 = 0;
                        while (n4 < RichardsEqn.output[n5].nPointsSaved) {
                            dArray2[n4] = RichardsEqn.displayLength(RichardsEqn.output[n5].getTotalPotential(RichardsEqn.output[n5].mp[n4], RichardsEqn.output[n5].depth));
                            ++n4;
                        }
                        graphics.setColor(RichardsEqn.colorLine[n5]);
                        if (this.drawCurve) {
                            if (RichardsEqn.output[n5].depth == 0.0) {
                                Tools.plotXY(1, RichardsEqn.output[n5].nPointsSaved - 1, dArray, dArray2, d, d2, d4, d3, 0, 0, n9, n10, rectangle, graphics);
                            } else {
                                Tools.plotXY(0, RichardsEqn.output[n5].nPointsSaved - 1, dArray, dArray2, d, d2, d4, d3, 0, 0, n9, n10, rectangle, graphics);
                            }
                        }
                    }
                    ++n5;
                }
                break;
            }
            case 14: {
                d4 = 0.0;
                d3 = 0.0;
                n5 = 0;
                while (n5 < 5) {
                    dArray = RichardsEqn.output[n5].time;
                    if (RichardsEqn.output[n5].nPointsSaved > 0) {
                        n4 = 0;
                        while (n4 < RichardsEqn.output[n5].nPointsSaved) {
                            dArray2[n4] = RichardsEqn.displayLength(RichardsEqn.output[n5].q[n4]);
                            ++n4;
                        }
                        n3 = 1;
                        while (n3 < RichardsEqn.output[n5].nPointsSaved) {
                            dArray4[n3] = Tools.integrateTrapezoidal(n3 + 1, dArray, dArray2);
                            if (dArray4[n3] > d3) {
                                d3 = dArray4[n3];
                            }
                            if (dArray4[n3] < d4) {
                                d4 = dArray4[n3];
                            }
                            ++n3;
                        }
                    }
                    ++n5;
                }
                if (d3 == d4) {
                    d3 += 0.1;
                }
                if (d3 - d4 > 0.5) {
                    d3 = Math.ceil(d3);
                    d4 = Math.floor(d4);
                } else {
                    d3 = Math.ceil(d3 * 10.0) / 10.0;
                    d4 = Math.floor(d4 * 10.0) / 10.0;
                }
                this.nDecimals = this.getDecimalNumber(d3, d4);
                if (bl) {
                    this.upYmin = this.autoUpLim[2] = Double.parseDouble(Tools.formatDouble(d4, 5, this.nDecimals));
                    this.upYmax = this.autoUpLim[3] = Double.parseDouble(Tools.formatDouble(d3, 5, this.nDecimals));
                } else {
                    this.lowYmin = this.autoLowLim[2] = Double.parseDouble(Tools.formatDouble(d4, 5, this.nDecimals));
                    this.lowYmax = this.autoLowLim[3] = Double.parseDouble(Tools.formatDouble(d3, 5, this.nDecimals));
                }
                if (!CustomizeDialog.gpLimits[n].getAuto()) {
                    if (d4 > CustomizeDialog.gpLimits[n].getYmax() || d3 < CustomizeDialog.gpLimits[n].getYmin()) {
                        this.drawCurve = false;
                    }
                    d4 = CustomizeDialog.gpLimits[n].getYmin();
                    d3 = CustomizeDialog.gpLimits[n].getYmax();
                }
                this.nDecimals = this.getDecimalNumber(d3, d4);
                Tools.drawTicMarksOnY(d4, d3, n9, n10, 5, this.nDecimals, 8, n8, this.fm, rectangle, graphics);
                if (d3 * d4 < 0.0) {
                    Tools.drawHorizontalDashedLine(0.0, d4, d3, n9, n10, rectangle, graphics);
                }
                n5 = 0;
                while (n5 < 5) {
                    if (RichardsEqn.output[n5].nPointsSaved > 0) {
                        dArray = RichardsEqn.output[n5].time;
                        n4 = 0;
                        while (n4 < RichardsEqn.output[n5].nPointsSaved) {
                            dArray2[n4] = RichardsEqn.displayLength(RichardsEqn.output[n5].q[n4]);
                            ++n4;
                        }
                        dArray4[0] = 0.0;
                        dArray3[0] = 0.0;
                        n2 = 0;
                        n4 = 1;
                        while (n4 < RichardsEqn.output[n5].nPointsSaved) {
                            n2 = n4;
                            dArray3[n4] = dArray[n4];
                            dArray4[n4] = Tools.integrateTrapezoidal(n4 + 1, dArray, dArray2);
                            if (dArray[n4] > d2) {
                                dArray4[n4] = dArray4[n4 - 1] + (dArray4[n4] - dArray4[n4 - 1]) * (d2 - dArray[n4 - 1]) / (dArray[n4] - dArray[n4 - 1]);
                                dArray3[n4] = d2;
                                break;
                            }
                            ++n4;
                        }
                        graphics.setColor(RichardsEqn.colorLine[n5]);
                        if (this.drawCurve) {
                            Tools.plotXY(n2, dArray3, dArray4, d, d2, d4, d3, 0, 0, n9, n10, rectangle, graphics);
                        }
                    }
                    ++n5;
                }
                break;
            }
            case 15: {
                double d5;
                d4 = 0.0;
                d3 = 0.0;
                n5 = 0;
                while (n5 < 5) {
                    if (RichardsEqn.output[n5].nPoints > 0) {
                        n4 = 0;
                        while (n4 < RichardsEqn.output[n5].nPoints) {
                            d5 = RichardsEqn.output[n5].getWaterContent(n4);
                            if (d3 < d5) {
                                d3 = d5;
                            }
                            ++n4;
                        }
                    }
                    ++n5;
                }
                d3 = Math.ceil(d3 * 10.0) / 10.0;
                this.nDecimals = this.getDecimalNumber(d3, d4);
                if (bl) {
                    this.upYmin = this.autoUpLim[2] = Double.parseDouble(Tools.formatDouble(d4, 5, this.nDecimals));
                    this.upYmax = this.autoUpLim[3] = Double.parseDouble(Tools.formatDouble(d3, 5, this.nDecimals));
                } else {
                    this.lowYmin = this.autoLowLim[2] = Double.parseDouble(Tools.formatDouble(d4, 5, this.nDecimals));
                    this.lowYmax = this.autoLowLim[3] = Double.parseDouble(Tools.formatDouble(d3, 5, this.nDecimals));
                }
                if (!CustomizeDialog.gpLimits[n].getAuto()) {
                    if (d4 > CustomizeDialog.gpLimits[n].getYmax() || d3 < CustomizeDialog.gpLimits[n].getYmin()) {
                        this.drawCurve = false;
                    }
                    d4 = CustomizeDialog.gpLimits[n].getYmin();
                    d3 = CustomizeDialog.gpLimits[n].getYmax();
                }
                this.nDecimals = this.getDecimalNumber(d3, d4);
                Tools.drawTicMarksOnY(d4, d3, n9, n10, 5, this.nDecimals, 7, n8, this.fm, rectangle, graphics);
                n5 = 0;
                while (n5 < 5) {
                    double d6;
                    if (RichardsEqn.output[n5].nPoints > 0 && (d6 = Math.sqrt(RichardsEqn.output[n5].time[RichardsEqn.output[n5].nPointsSaved - 1])) > 0.0) {
                        dArray = RichardsEqn.output[n5].z;
                        n4 = 0;
                        while (n4 < RichardsEqn.output[n5].nPoints) {
                            dArray2[n4] = RichardsEqn.output[n5].getWaterContent(n4);
                            dArray4[n4] = dArray[n4] / d6;
                            ++n4;
                        }
                        graphics.setColor(RichardsEqn.colorLine[n5]);
                        if (this.drawCurve) {
                            Tools.plotXY(RichardsEqn.output[n5].nPoints - 1, dArray4, dArray2, d, d2, d4, d3, 0, 0, n9, n10, rectangle, graphics);
                        }
                        if (!RichardsEqn.output[n5].isFinite && dArray[RichardsEqn.output[n5].nPoints - 1] < d2) {
                            dArray3[0] = dArray4[RichardsEqn.output[n5].nPoints - 1];
                            dArray3[1] = d2 / d6;
                            dArray4[0] = dArray2[RichardsEqn.output[n5].nPoints - 1];
                            dArray4[1] = dArray4[0];
                            if (this.drawCurve) {
                                Tools.plotXY(1, dArray3, dArray4, d, d2, d4, d3, 0, 0, n9, n10, rectangle, graphics);
                            }
                        }
                    }
                    ++n5;
                }
                break;
            }
        }
        if (this.simChem) {
            switch (n) {
                case 16: {
                    dArray2 = RichardsEqn.output[RichardsEqn.currentLine].c;
                    d3 = dArray2[0];
                    d4 = dArray2[0];
                    n5 = 0;
                    while (n5 < 5) {
                        if (RichardsEqn.output[n5].nPoints > 0) {
                            dArray2 = RichardsEqn.output[n5].c;
                            n4 = 0;
                            while (n4 < RichardsEqn.output[n5].nPoints) {
                                if (dArray2[n4] > d3) {
                                    d3 = dArray2[n4];
                                }
                                if (dArray2[n4] < d4) {
                                    d4 = dArray2[n4];
                                }
                                ++n4;
                            }
                        }
                        ++n5;
                    }
                    d4 = 0.0;
                    this.nDecimals = this.getDecimalNumber(d3, d4);
                    if (bl) {
                        this.upYmin = this.autoUpLim[2] = Double.parseDouble(Tools.formatDouble(d4, 5, this.nDecimals));
                        this.upYmax = this.autoUpLim[3] = Double.parseDouble(Tools.formatDouble(d3, 5, this.nDecimals));
                    } else {
                        this.lowYmin = this.autoLowLim[2] = Double.parseDouble(Tools.formatDouble(d4, 5, this.nDecimals));
                        this.lowYmax = this.autoLowLim[3] = Double.parseDouble(Tools.formatDouble(d3, 5, this.nDecimals));
                    }
                    if (!CustomizeDialog.gpLimits[n].getAuto()) {
                        if (d4 > CustomizeDialog.gpLimits[n].getYmax() || d3 < CustomizeDialog.gpLimits[n].getYmin()) {
                            this.drawCurve = false;
                        }
                        d4 = CustomizeDialog.gpLimits[n].getYmin();
                        d3 = CustomizeDialog.gpLimits[n].getYmax();
                    }
                    this.nDecimals = this.getDecimalNumber(d3, d4);
                    Tools.drawTicMarksOnY(d4, d3, n9, n10, 5, this.nDecimals, 8, n8, this.fm, rectangle, graphics);
                    n5 = 0;
                    while (n5 < 5) {
                        if (RichardsEqn.output[n5].nPoints > 0) {
                            dArray = RichardsEqn.output[n5].z;
                            dArray2 = RichardsEqn.output[n5].c;
                            graphics.setColor(RichardsEqn.colorLine[n5]);
                            if (this.drawCurve) {
                                Tools.plotXY(RichardsEqn.output[n5].nPoints - 1, dArray, dArray2, d, d2, d4, d3, 0, 0, n9, n10, rectangle, graphics);
                            }
                        }
                        ++n5;
                    }
                    break;
                }
                case 17: {
                    n5 = 0;
                    while (n5 < 5) {
                        if (RichardsEqn.output[n5].nPoints > 0) {
                            dArray = RichardsEqn.output[n5].z;
                            n4 = 0;
                            while (n4 < RichardsEqn.output[n5].nPoints) {
                                dArray2[n4] = RichardsEqn.output[n5].getTotalConcentration(n4);
                                ++n4;
                            }
                            if (n5 == 0) {
                                d4 = dArray2[0];
                                d3 = dArray2[0];
                            }
                            n4 = 0;
                            while (n4 < RichardsEqn.output[n5].nPoints) {
                                if (dArray2[n4] > d3) {
                                    d3 = dArray2[n4];
                                }
                                if (dArray2[n4] < d4) {
                                    d4 = dArray2[n4];
                                }
                                ++n4;
                            }
                        }
                        ++n5;
                    }
                    d4 = 0.0;
                    this.nDecimals = this.getDecimalNumber(d3, d4);
                    if (bl) {
                        this.upYmin = this.autoUpLim[2] = Double.parseDouble(Tools.formatDouble(d4, 5, this.nDecimals));
                        this.upYmax = this.autoUpLim[3] = Double.parseDouble(Tools.formatDouble(d3, 5, this.nDecimals));
                    } else {
                        this.lowYmin = this.autoLowLim[2] = Double.parseDouble(Tools.formatDouble(d4, 5, this.nDecimals));
                        this.lowYmax = this.autoLowLim[3] = Double.parseDouble(Tools.formatDouble(d3, 5, this.nDecimals));
                    }
                    if (!CustomizeDialog.gpLimits[n].getAuto()) {
                        if (d4 > CustomizeDialog.gpLimits[n].getYmax() || d3 < CustomizeDialog.gpLimits[n].getYmin()) {
                            this.drawCurve = false;
                        }
                        d4 = CustomizeDialog.gpLimits[n].getYmin();
                        d3 = CustomizeDialog.gpLimits[n].getYmax();
                    }
                    this.nDecimals = this.getDecimalNumber(d3, d4);
                    Tools.drawTicMarksOnY(d4, d3, n9, n10, 5, this.nDecimals, 8, n8, this.fm, rectangle, graphics);
                    n5 = 0;
                    while (n5 < 5) {
                        if (RichardsEqn.output[n5].nPoints > 0) {
                            dArray = RichardsEqn.output[n5].z;
                            n4 = 0;
                            while (n4 < RichardsEqn.output[n5].nPoints) {
                                dArray2[n4] = RichardsEqn.output[n5].getTotalConcentration(n4);
                                ++n4;
                            }
                            graphics.setColor(RichardsEqn.colorLine[n5]);
                            if (this.drawCurve) {
                                Tools.plotXY(RichardsEqn.output[n5].nPoints - 1, dArray, dArray2, d, d2, d4, d3, 0, 0, n9, n10, rectangle, graphics);
                            }
                        }
                        ++n5;
                    }
                    break;
                }
                case 18: {
                    n5 = 0;
                    while (n5 < 5) {
                        if (RichardsEqn.output[n5].nPoints > 0) {
                            dArray = RichardsEqn.output[n5].z;
                            n4 = 0;
                            while (n4 < RichardsEqn.output[n5].nPoints) {
                                dArray2[n4] = RichardsEqn.output[n5].getChemicalFluxDensity(dArray[n4]);
                                ++n4;
                            }
                            if (n5 == 0) {
                                d4 = dArray2[1];
                                d3 = dArray2[1];
                            }
                            n4 = 0;
                            while (n4 < RichardsEqn.output[n5].nPoints) {
                                if (dArray2[n4] > d3) {
                                    d3 = dArray2[n4];
                                }
                                if (dArray2[n4] < d4) {
                                    d4 = dArray2[n4];
                                }
                                ++n4;
                            }
                        }
                        ++n5;
                    }
                    if (d3 == d4) {
                        d3 += 0.1;
                    }
                    this.nDecimals = this.getDecimalNumber(d3, d4);
                    if (bl) {
                        this.upYmin = this.autoUpLim[2] = Double.parseDouble(Tools.formatDouble(d4, 5, this.nDecimals));
                        this.upYmax = this.autoUpLim[3] = Double.parseDouble(Tools.formatDouble(d3, 5, this.nDecimals));
                    } else {
                        this.lowYmin = this.autoLowLim[2] = Double.parseDouble(Tools.formatDouble(d4, 5, this.nDecimals));
                        this.lowYmax = this.autoLowLim[3] = Double.parseDouble(Tools.formatDouble(d3, 5, this.nDecimals));
                    }
                    if (!CustomizeDialog.gpLimits[n].getAuto()) {
                        if (d4 > CustomizeDialog.gpLimits[n].getYmax() || d3 < CustomizeDialog.gpLimits[n].getYmin()) {
                            this.drawCurve = false;
                        }
                        d4 = CustomizeDialog.gpLimits[n].getYmin();
                        d3 = CustomizeDialog.gpLimits[n].getYmax();
                    }
                    this.nDecimals = this.getDecimalNumber(d3, d4);
                    Tools.drawTicMarksOnY(d4, d3, n9, n10, 5, this.nDecimals, 8, n8, this.fm, rectangle, graphics);
                    if (d3 * d4 < 0.0) {
                        Tools.drawHorizontalDashedLine(0.0, d4, d3, n9, n10, rectangle, graphics);
                    }
                    n5 = 0;
                    while (n5 < 5) {
                        if (RichardsEqn.output[n5].nPoints > 0) {
                            dArray = RichardsEqn.output[n5].z;
                            n4 = 0;
                            while (n4 < RichardsEqn.output[n5].nPoints) {
                                dArray2[n4] = RichardsEqn.output[n5].getChemicalFluxDensity(dArray[n4]);
                                ++n4;
                            }
                            graphics.setColor(RichardsEqn.colorLine[n5]);
                            if (this.drawCurve) {
                                Tools.plotXY(RichardsEqn.output[n5].nPoints - 1, dArray, dArray2, d, d2, d4, d3, 0, 0, n9, n10, rectangle, graphics);
                            }
                        }
                        ++n5;
                    }
                    break;
                }
                case 19: {
                    dArray2 = RichardsEqn.output[RichardsEqn.currentLine].con;
                    d3 = dArray2[0];
                    d4 = dArray2[0];
                    n5 = 0;
                    while (n5 < 5) {
                        if (RichardsEqn.output[n5].nPointsSaved > 0) {
                            dArray2 = RichardsEqn.output[n5].con;
                            n4 = 0;
                            while (n4 < RichardsEqn.output[n5].nPointsSaved) {
                                if (dArray2[n4] > d3) {
                                    d3 = dArray2[n4];
                                }
                                if (dArray2[n4] < d4) {
                                    d4 = dArray2[n4];
                                }
                                ++n4;
                            }
                        }
                        ++n5;
                    }
                    d4 = 0.0;
                    this.nDecimals = this.getDecimalNumber(d3, d4);
                    if (bl) {
                        this.upYmin = this.autoUpLim[2] = Double.parseDouble(Tools.formatDouble(d4, 5, this.nDecimals));
                        this.upYmax = this.autoUpLim[3] = Double.parseDouble(Tools.formatDouble(d3, 5, this.nDecimals));
                    } else {
                        this.lowYmin = this.autoLowLim[2] = Double.parseDouble(Tools.formatDouble(d4, 5, this.nDecimals));
                        this.lowYmax = this.autoLowLim[3] = Double.parseDouble(Tools.formatDouble(d3, 5, this.nDecimals));
                    }
                    if (!CustomizeDialog.gpLimits[n].getAuto()) {
                        if (d4 > CustomizeDialog.gpLimits[n].getYmax() || d3 < CustomizeDialog.gpLimits[n].getYmin()) {
                            this.drawCurve = false;
                        }
                        d4 = CustomizeDialog.gpLimits[n].getYmin();
                        d3 = CustomizeDialog.gpLimits[n].getYmax();
                    }
                    this.nDecimals = this.getDecimalNumber(d3, d4);
                    Tools.drawTicMarksOnY(d4, d3, n9, n10, 5, this.nDecimals, 8, n8, this.fm, rectangle, graphics);
                    n5 = 0;
                    while (n5 < 5) {
                        if (RichardsEqn.output[n5].nPointsSaved > 0) {
                            dArray = RichardsEqn.output[n5].time;
                            dArray2 = RichardsEqn.output[n5].con;
                            graphics.setColor(RichardsEqn.colorLine[n5]);
                            if (this.drawCurve) {
                                if (RichardsEqn.output[n5].depth == 0.0) {
                                    Tools.plotXY(1, RichardsEqn.output[n5].nPointsSaved - 1, dArray, dArray2, d, d2, d4, d3, 0, 0, n9, n10, rectangle, graphics);
                                } else {
                                    Tools.plotXY(0, RichardsEqn.output[n5].nPointsSaved - 1, dArray, dArray2, d, d2, d4, d3, 0, 0, n9, n10, rectangle, graphics);
                                }
                            }
                        }
                        ++n5;
                    }
                    break;
                }
                case 20: {
                    n5 = 0;
                    while (n5 < 5) {
                        if (RichardsEqn.output[n5].nPointsSaved > 0) {
                            n4 = 0;
                            while (n4 < RichardsEqn.output[n5].nPointsSaved) {
                                dArray2[n4] = RichardsEqn.output[n5].getTotalConcentrationAtTime(n4);
                                ++n4;
                            }
                            if (n5 == 0) {
                                d4 = dArray2[1];
                                d3 = dArray2[1];
                            }
                            n4 = 0;
                            while (n4 < RichardsEqn.output[n5].nPointsSaved) {
                                if (dArray2[n4] > d3) {
                                    d3 = dArray2[n4];
                                }
                                if (dArray2[n4] < d4) {
                                    d4 = dArray2[n4];
                                }
                                ++n4;
                            }
                        }
                        ++n5;
                    }
                    d4 = 0.0;
                    this.nDecimals = this.getDecimalNumber(d3, d4);
                    if (bl) {
                        this.upYmin = this.autoUpLim[2] = Double.parseDouble(Tools.formatDouble(d4, 5, this.nDecimals));
                        this.upYmax = this.autoUpLim[3] = Double.parseDouble(Tools.formatDouble(d3, 5, this.nDecimals));
                    } else {
                        this.lowYmin = this.autoLowLim[2] = Double.parseDouble(Tools.formatDouble(d4, 5, this.nDecimals));
                        this.lowYmax = this.autoLowLim[3] = Double.parseDouble(Tools.formatDouble(d3, 5, this.nDecimals));
                    }
                    if (!CustomizeDialog.gpLimits[n].getAuto()) {
                        if (d4 > CustomizeDialog.gpLimits[n].getYmax() || d3 < CustomizeDialog.gpLimits[n].getYmin()) {
                            this.drawCurve = false;
                        }
                        d4 = CustomizeDialog.gpLimits[n].getYmin();
                        d3 = CustomizeDialog.gpLimits[n].getYmax();
                    }
                    this.nDecimals = this.getDecimalNumber(d3, d4);
                    Tools.drawTicMarksOnY(d4, d3, n9, n10, 5, this.nDecimals, 8, n8, this.fm, rectangle, graphics);
                    n5 = 0;
                    while (n5 < 5) {
                        if (RichardsEqn.output[n5].nPointsSaved > 0) {
                            dArray = RichardsEqn.output[n5].time;
                            n4 = 0;
                            while (n4 < RichardsEqn.output[n5].nPointsSaved) {
                                dArray2[n4] = RichardsEqn.output[n5].getTotalConcentrationAtTime(n4);
                                ++n4;
                            }
                            graphics.setColor(RichardsEqn.colorLine[n5]);
                            if (this.drawCurve) {
                                Tools.plotXY(0, RichardsEqn.output[n5].nPointsSaved - 1, dArray, dArray2, d, d2, d4, d3, 0, 0, n9, n10, rectangle, graphics);
                            }
                        }
                        ++n5;
                    }
                    break;
                }
                case 21: {
                    n5 = 0;
                    while (n5 < 5) {
                        if (RichardsEqn.output[n5].nPointsSaved > 0) {
                            n4 = 0;
                            while (n4 < RichardsEqn.output[n5].nPointsSaved) {
                                dArray2[n4] = RichardsEqn.output[n5].fluxChem[n4];
                                ++n4;
                            }
                            if (n5 == 0) {
                                d4 = dArray2[1];
                                d3 = dArray2[1];
                            }
                            n4 = 0;
                            while (n4 < RichardsEqn.output[n5].nPointsSaved) {
                                if (dArray2[n4] > d3) {
                                    d3 = dArray2[n4];
                                }
                                if (dArray2[n4] < d4) {
                                    d4 = dArray2[n4];
                                }
                                ++n4;
                            }
                        }
                        ++n5;
                    }
                    if (d3 == d4) {
                        d3 += 0.1;
                    }
                    this.nDecimals = this.getDecimalNumber(d3, d4);
                    if (bl) {
                        this.upYmin = this.autoUpLim[2] = Double.parseDouble(Tools.formatDouble(d4, 5, this.nDecimals));
                        this.upYmax = this.autoUpLim[3] = Double.parseDouble(Tools.formatDouble(d3, 5, this.nDecimals));
                    } else {
                        this.lowYmin = this.autoLowLim[2] = Double.parseDouble(Tools.formatDouble(d4, 5, this.nDecimals));
                        this.lowYmax = this.autoLowLim[3] = Double.parseDouble(Tools.formatDouble(d3, 5, this.nDecimals));
                    }
                    if (!CustomizeDialog.gpLimits[n].getAuto()) {
                        if (d4 > CustomizeDialog.gpLimits[n].getYmax() || d3 < CustomizeDialog.gpLimits[n].getYmin()) {
                            this.drawCurve = false;
                        }
                        d4 = CustomizeDialog.gpLimits[n].getYmin();
                        d3 = CustomizeDialog.gpLimits[n].getYmax();
                    }
                    this.nDecimals = this.getDecimalNumber(d3, d4);
                    Tools.drawTicMarksOnY(d4, d3, n9, n10, 5, this.nDecimals, 8, n8, this.fm, rectangle, graphics);
                    if (d3 * d4 < 0.0) {
                        Tools.drawHorizontalDashedLine(0.0, d4, d3, n9, n10, rectangle, graphics);
                    }
                    n5 = 0;
                    while (n5 < 5) {
                        if (RichardsEqn.output[n5].nPointsSaved > 0) {
                            dArray = RichardsEqn.output[n5].time;
                            n4 = 0;
                            while (n4 < RichardsEqn.output[n5].nPointsSaved) {
                                dArray2[n4] = RichardsEqn.output[n5].fluxChem[n4];
                                ++n4;
                            }
                            graphics.setColor(RichardsEqn.colorLine[n5]);
                            if (this.drawCurve) {
                                if (RichardsEqn.output[n5].depth == 0.0) {
                                    Tools.plotXY(1, RichardsEqn.output[n5].nPointsSaved - 1, dArray, dArray2, d, d2, d4, d3, 0, 0, n9, n10, rectangle, graphics);
                                } else {
                                    Tools.plotXY(0, RichardsEqn.output[n5].nPointsSaved - 1, dArray, dArray2, d, d2, d4, d3, 0, 0, n9, n10, rectangle, graphics);
                                }
                            }
                        }
                        ++n5;
                    }
                    break;
                }
                case 22: {
                    d4 = 0.0;
                    d3 = 0.0;
                    n5 = 0;
                    while (n5 < 5) {
                        dArray = RichardsEqn.output[n5].time;
                        if (RichardsEqn.output[n5].nPointsSaved > 0) {
                            n4 = 0;
                            while (n4 < RichardsEqn.output[n5].nPointsSaved) {
                                dArray2[n4] = RichardsEqn.output[n5].fluxChem[n4];
                                ++n4;
                            }
                            n3 = 1;
                            while (n3 < RichardsEqn.output[n5].nPointsSaved) {
                                dArray4[n3] = Tools.integrateTrapezoidal(n3 + 1, dArray, dArray2);
                                if (dArray4[n3] > d3) {
                                    d3 = dArray4[n3];
                                }
                                if (dArray4[n3] < d4) {
                                    d4 = dArray4[n3];
                                }
                                ++n3;
                            }
                        }
                        ++n5;
                    }
                    if (d3 == d4) {
                        d3 += 0.1;
                    }
                    this.nDecimals = this.getDecimalNumber(d3, d4);
                    if (bl) {
                        this.upYmin = this.autoUpLim[2] = Double.parseDouble(Tools.formatDouble(d4, 5, this.nDecimals));
                        this.upYmax = this.autoUpLim[3] = Double.parseDouble(Tools.formatDouble(d3, 5, this.nDecimals));
                    } else {
                        this.lowYmin = this.autoLowLim[2] = Double.parseDouble(Tools.formatDouble(d4, 5, this.nDecimals));
                        this.lowYmax = this.autoLowLim[3] = Double.parseDouble(Tools.formatDouble(d3, 5, this.nDecimals));
                    }
                    if (!CustomizeDialog.gpLimits[n].getAuto()) {
                        if (d4 > CustomizeDialog.gpLimits[n].getYmax() || d3 < CustomizeDialog.gpLimits[n].getYmin()) {
                            this.drawCurve = false;
                        }
                        d4 = CustomizeDialog.gpLimits[n].getYmin();
                        d3 = CustomizeDialog.gpLimits[n].getYmax();
                    }
                    this.nDecimals = this.getDecimalNumber(d3, d4);
                    Tools.drawTicMarksOnY(d4, d3, n9, n10, 5, this.nDecimals, 8, n8, this.fm, rectangle, graphics);
                    if (d3 * d4 < 0.0) {
                        Tools.drawHorizontalDashedLine(0.0, d4, d3, n9, n10, rectangle, graphics);
                    }
                    n5 = 0;
                    while (n5 < 5) {
                        if (RichardsEqn.output[n5].nPointsSaved > 0) {
                            dArray = RichardsEqn.output[n5].time;
                            n4 = 0;
                            while (n4 < RichardsEqn.output[n5].nPointsSaved) {
                                dArray2[n4] = RichardsEqn.output[n5].fluxChem[n4];
                                ++n4;
                            }
                            dArray4[0] = 0.0;
                            dArray3[0] = 0.0;
                            n2 = 0;
                            n4 = 1;
                            while (n4 < RichardsEqn.output[n5].nPointsSaved) {
                                n2 = n4;
                                dArray3[n4] = dArray[n4];
                                dArray4[n4] = Tools.integrateTrapezoidal(n4 + 1, dArray, dArray2);
                                if (dArray[n4] > d2) {
                                    dArray4[n4] = dArray4[n4 - 1] + (dArray4[n4] - dArray4[n4 - 1]) * (d2 - dArray[n4 - 1]) / (dArray[n4] - dArray[n4 - 1]);
                                    dArray3[n4] = d2;
                                    break;
                                }
                                ++n4;
                            }
                            graphics.setColor(RichardsEqn.colorLine[n5]);
                            if (this.drawCurve) {
                                Tools.plotXY(n2, dArray3, dArray4, d, d2, d4, d3, 0, 0, n9, n10, rectangle, graphics);
                            }
                        }
                        ++n5;
                    }
                    break;
                }
                case 23: {
                    dArray2 = RichardsEqn.output[RichardsEqn.currentLine].massChem;
                    d3 = dArray2[0];
                    d4 = dArray2[0];
                    n5 = 0;
                    while (n5 < 5) {
                        if (RichardsEqn.output[n5].nPointsSaved > 0) {
                            dArray2 = RichardsEqn.output[n5].massChem;
                            n4 = 0;
                            while (n4 < RichardsEqn.output[n5].nPointsSaved) {
                                if (dArray2[n4] > d3) {
                                    d3 = dArray2[n4];
                                }
                                if (dArray2[n4] < d4) {
                                    d4 = dArray2[n4];
                                }
                                ++n4;
                            }
                        }
                        ++n5;
                    }
                    d4 = 0.0;
                    this.nDecimals = this.getDecimalNumber(d3, d4);
                    if (bl) {
                        this.upYmin = this.autoUpLim[2] = Double.parseDouble(Tools.formatDouble(d4, 5, this.nDecimals));
                        this.upYmax = this.autoUpLim[3] = Double.parseDouble(Tools.formatDouble(d3, 5, this.nDecimals));
                    } else {
                        this.lowYmin = this.autoLowLim[2] = Double.parseDouble(Tools.formatDouble(d4, 5, this.nDecimals));
                        this.lowYmax = this.autoLowLim[3] = Double.parseDouble(Tools.formatDouble(d3, 5, this.nDecimals));
                    }
                    if (!CustomizeDialog.gpLimits[n].getAuto()) {
                        if (d4 > CustomizeDialog.gpLimits[n].getYmax() || d3 < CustomizeDialog.gpLimits[n].getYmin()) {
                            this.drawCurve = false;
                        }
                        d4 = CustomizeDialog.gpLimits[n].getYmin();
                        d3 = CustomizeDialog.gpLimits[n].getYmax();
                    }
                    this.nDecimals = this.getDecimalNumber(d3, d4);
                    Tools.drawTicMarksOnY(d4, d3, n9, n10, 5, this.nDecimals, 8, n8, this.fm, rectangle, graphics);
                    n5 = 0;
                    while (n5 < 5) {
                        if (RichardsEqn.output[n5].nPointsSaved > 0) {
                            dArray = RichardsEqn.output[n5].time;
                            dArray2 = RichardsEqn.output[n5].massChem;
                            graphics.setColor(RichardsEqn.colorLine[n5]);
                            if (this.drawCurve) {
                                Tools.plotXY(0, RichardsEqn.output[n5].nPointsSaved - 1, dArray, dArray2, d, d2, d4, d3, 0, 0, n9, n10, rectangle, graphics);
                            }
                        }
                        ++n5;
                    }
                    break;
                }
            }
        }
    }

    public void performed() {
        JTextField jTextField = null;
        String string = "";
        try {
            String string2 = new String(this.tfTime.getText());
            jTextField = this.tfTime;
            double d = Double.parseDouble(string2);
            double d2 = RichardsEqn.storeTime(d);
            if (d < 0.0) {
                string = "Time of interest must be zero or greater.";
                throw new IllegalValueException("Time of interest must be zero or greater.");
            }
            RichardsEqn.criticalTime = d2;
            this.sbrTime.setValue((int)(10.0 * RichardsEqn.criticalTime + 0.5));
            RichardsEqn.criticalTime = d2;
            this.tfTime.setText(string2);
            if (RichardsEqn.criticalTime < RichardsEqn.bc[RichardsEqn.mBC].getTimeEnd() && RichardsEqn.newBC0 && !DefineBoundaryPanel.cboxFirstBC.isSelected()) {
                string = "The 'Time of Interest' must be greater than " + Tools.formatDouble(RichardsEqn.bc[RichardsEqn.mBC].getTimeEnd(), 2, 2) + " to define this boundary condition.";
                throw new IllegalValueException("The 'Time of Interest' must be greater than " + Tools.formatDouble(RichardsEqn.bc[RichardsEqn.mBC].getTimeEnd(), 2, 2) + " to define this boundary condition.");
            }
            if (d2 > RichardsEqn.criticalTime) {
                RichardsEqn.restart = true;
            }
            d2 = RichardsEqn.criticalPosition;
            jTextField = this.tfPosition;
            string2 = new String(this.tfPosition.getText());
            d = Double.parseDouble(string2);
            if (d < 0.0) {
                string = "Position of interest cannot be less than zero.";
                throw new IllegalValueException("Position of interest cannot be less than zero.");
            }
            if (!RichardsEqn.semiInfiniteSelected && d > (double)this.posLimit) {
                string = "Position of interest cannot be more than " + new Double(this.posLimit).toString();
                throw new IllegalValueException("Position of interest cannot be more than " + this.posLimit);
            }
            RichardsEqn.criticalPosition = RichardsEqn.storeLength(d);
            this.sbrPosition.setValue((int)(RichardsEqn.criticalPosition + 0.5));
            if (d2 != RichardsEqn.criticalPosition) {
                RichardsEqn.restart = true;
            }
            this.errorFree = true;
            this.updateMessage();
        }
        catch (Exception exception) {
            if (exception instanceof IllegalValueException) {
                if (this.showMsg) {
                    lMessage1.setText("Illegal Value:" + exception.getMessage());
                    RichardsEqn.errorMessage = string;
                    lMessage1.setVisible(true);
                } else {
                    RichardsEqn.errorMessage = string;
                }
            } else if (this.showMsg) {
                lMessage1.setText("Error in number format");
                RichardsEqn.errorMessage = string;
                lMessage1.setVisible(true);
            } else {
                RichardsEqn.errorMessage = string;
            }
            jTextField.grabFocus();
            this.errorFree = false;
        }
    }

    void updateMessage() {
        if (RichardsEqn.errorFree && this.errorFree) {
            lMessage1.setText(" ");
            lMessage1.setVisible(false);
        }
    }

    void updateBoundaryConditionAt0(double d) {
        switch (RichardsEqn.selectedBoundaryCond) {
            case 0: 
            case 1: {
                RichardsEqn.bc[RichardsEqn.mBC].setPotentialAt0(RichardsEqn.matricPotAt0);
                break;
            }
            case 2: {
                RichardsEqn.bc[RichardsEqn.mBC].setFluxAt0(RichardsEqn.fluxAt0);
                break;
            }
            case 3: {
                RichardsEqn.bc[RichardsEqn.mBC].setRainfall(RichardsEqn.rainfall, d);
                break;
            }
            case 4: {
                RichardsEqn.bc[RichardsEqn.mBC].setMixedAt0(RichardsEqn.mixedFlux, RichardsEqn.criticalPot, d);
                break;
            }
            case 5: {
                RichardsEqn.bc[RichardsEqn.mBC].setFallingHeadAt0(RichardsEqn.initPondingDepth);
            }
        }
        if (this.simChem) {
            switch (RichardsEqn.selectedChemBoundaryCond) {
                case 0: {
                    RichardsEqn.bc[RichardsEqn.mBC].setConcAt0(RichardsEqn.matricChemPotAt0, 4);
                    break;
                }
                case 1: {
                    RichardsEqn.bc[RichardsEqn.mBC].setConcAt0(RichardsEqn.matricChemSoilPotAt0, 5);
                }
            }
        }
        RichardsEqn.bc[RichardsEqn.mBC].setTimeEnd(RichardsEqn.criticalTime);
    }

    void updateBoundaryConditionAtL(double d) {
        switch (RichardsEqn.selectedBoundaryCondAtL) {
            case 0: {
                RichardsEqn.bc[RichardsEqn.mBC].setPotentialAtL(RichardsEqn.matricPotAtL);
                break;
            }
            case 1: {
                RichardsEqn.bc[RichardsEqn.mBC].setFluxAtL(RichardsEqn.fluxAtL);
                break;
            }
            case 2: {
                RichardsEqn.bc[RichardsEqn.mBC].setFreeDrainageAtL();
            }
        }
        if (this.simChem) {
            switch (RichardsEqn.selectedChemBoundaryCondAtL) {
                case 0: {
                    RichardsEqn.bc[RichardsEqn.mBC].setMassFlowAtL();
                    break;
                }
                case 1: {
                    RichardsEqn.bc[RichardsEqn.mBC].setConcAtL(RichardsEqn.matricChemPotAtL);
                }
            }
        }
        RichardsEqn.bc[RichardsEqn.mBC].setTimeEnd(RichardsEqn.criticalTime);
    }

    public void ResetUnits() {
        this.lPosition.setText(" (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + ") ");
        this.lTime.setText(" (" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ") ");
        this.tfPosition.setText(RichardsEqn.formatLength(RichardsEqn.criticalPosition));
        this.tfTime.setText(RichardsEqn.formatTime(RichardsEqn.criticalTime));
        if (this.choiceGraph.getSelectedIndex() <= 6) {
            this.lGraph.setText("Time = " + RichardsEqn.formatTime(this.old_t) + " " + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit]);
        } else {
            this.lGraph.setText("Position = " + RichardsEqn.formatLength(RichardsEqn.criticalPosition) + " " + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit]);
            this.tfPosition.setText(RichardsEqn.formatLength(RichardsEqn.criticalPosition));
        }
        this.choiceG.removeAllElements();
        this.choiceG.addElement("Water Content (v/v) vs. Distance");
        this.choiceG.addElement("Matric Potential (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + " of water) vs. Distance");
        this.choiceG.addElement("Conductivity (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ") vs. Distance(Linear)");
        this.choiceG.addElement("Conductivity (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ") vs. Distance(Semi-log)");
        this.choiceG.addElement("Driving Force vs. Distance");
        this.choiceG.addElement("Flux Density (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ") vs. Distance");
        this.choiceG.addElement("Total Potential (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + " of water) vs. Distance");
        this.choiceG.addElement("Water Content (v/v) vs. Time");
        this.choiceG.addElement("Matric Potential (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + " of water) vs. Time");
        this.choiceG.addElement("Conductivity (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ") vs. Time (Linear)");
        this.choiceG.addElement("Conductivity (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ") vs. Time (Semi-log)");
        this.choiceG.addElement("Driving Force vs. Time");
        this.choiceG.addElement("Flux Density (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ") vs. Time");
        this.choiceG.addElement("Total Potential (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + " of water) vs. Time");
        this.choiceG.addElement("Cumulative Flux (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + ") vs Time");
        this.choiceG.addElement("Water Content (v/v) vs Boltzman Variable");
        if (RichardsEqn.selectedInitialCond2 != 0) {
            this.choiceG.addElement("Solution Concentration (g/m3) vs Distance");
            this.choiceG.addElement("Total Concentration (g/m3) vs Distance");
            this.choiceG.addElement("Flux Density of Chemical (g/m2/hr) vs Distance");
            this.choiceG.addElement("Solution Concentration (g/m3) vs Time");
            this.choiceG.addElement("Total Concentration vs (g/m3) Time");
            this.choiceG.addElement("Flux Density of Chemical (g/m2/hr) vs Time");
            this.choiceG.addElement("Cumulative Flux of Chemical (g/m2) vs Time");
            this.choiceG.addElement("Mass Chemical/Unit Area (g/m2) vs Time");
        }
        this.choiceGraph.setSelectedIndex(RichardsEqn.selectedGraphIndex);
        if (RichardsEqn.selectedGraphIndex == 15) {
            this.caption.setText("Boltzman Variable (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "/sqrt[" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + "])");
            this.caption.setAlignmentX(0.0f);
            this.lGraph.setText("");
        } else if (RichardsEqn.selectedGraphIndex <= 6 || RichardsEqn.selectedGraphIndex > 15 && RichardsEqn.selectedGraphIndex <= 18) {
            this.caption.setText("Distance from Soil Surface (X = 0), " + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit]);
        } else {
            this.caption.setText("Time (hr) ");
        }
        if (this.combox2.getSelectedIndex() <= 6 || this.combox2.getSelectedIndex() > 15 && this.combox2.getSelectedIndex() <= 18) {
            this.lGraph2.setText("Time = " + RichardsEqn.formatTime(this.old_t) + " " + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit]);
        } else {
            this.lGraph2.setText("Position = " + RichardsEqn.formatLength(RichardsEqn.criticalPosition) + " " + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit]);
            this.tfPosition.setText(RichardsEqn.formatLength(RichardsEqn.criticalPosition));
            if (RichardsEqn.selectedGraphIndex2 == 23) {
                this.lGraph2.setText("");
            }
        }
        this.chNames.removeAllElements();
        this.chNames.addElement("Water Content (v/v) vs. Distance");
        this.chNames.addElement("Matric Potential (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + " of water) vs. Distance");
        this.chNames.addElement("Conductivity (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ") vs. Distance(Linear)");
        this.chNames.addElement("Conductivity (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ") vs. Distance(Semi-log)");
        this.chNames.addElement("Driving Force vs. Distance");
        this.chNames.addElement("Flux Density (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ") vs. Distance");
        this.chNames.addElement("Total Potential (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + " of water) vs. Distance");
        this.chNames.addElement("Water Content (v/v) vs. Time");
        this.chNames.addElement("Matric Potential (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + " of water) vs. Time");
        this.chNames.addElement("Conductivity (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ") vs. Time (Linear)");
        this.chNames.addElement("Conductivity (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ") vs. Time (Semi-log)");
        this.chNames.addElement("Driving Force vs. Time");
        this.chNames.addElement("Flux Density (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ") vs. Time");
        this.chNames.addElement("Total Potential (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + " of water) vs. Time");
        this.chNames.addElement("Cumulative Flux (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + ") vs Time");
        this.chNames.addElement("Water Content (v/v) vs Boltzman Variable");
        if (RichardsEqn.selectedInitialCond2 != 0) {
            this.chNames.addElement("Solution Concentration (g/m3) vs Distance");
            this.chNames.addElement("Total Concentration (g/m3) vs Distance");
            this.chNames.addElement("Flux Density of Chemical (g/m2/hr) vs Distance");
            this.chNames.addElement("Solution Concentration (g/m3) vs Time");
            this.chNames.addElement("Total Concentration (g/m3) vs Time");
            this.chNames.addElement("Flux Density of Chemical (g/m2/hr) vs Time");
            this.chNames.addElement("Cumulative Flux of Chemical (g/m2) vs Time");
            this.chNames.addElement("Mass Chemical/Unit Area (g/m2) vs Time");
        }
        this.combox2.setSelectedIndex(RichardsEqn.selectedGraphIndex2);
        if (RichardsEqn.selectedGraphIndex2 == 15) {
            this.caption2.setText("Boltzman Variable (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "/sqrt[" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + "])");
            this.caption2.setAlignmentX(0.0f);
            this.lGraph2.setText("");
        } else if (RichardsEqn.selectedGraphIndex2 <= 6 || RichardsEqn.selectedGraphIndex2 > 15 && RichardsEqn.selectedGraphIndex2 <= 18) {
            this.caption2.setText("Distance from Soil Surface (X = 0), " + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit]);
            this.lGraph2.setText("Time = " + RichardsEqn.formatTime(this.old_t) + " " + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit]);
        } else {
            this.caption2.setText("Time (hr) ");
            this.lGraph2.setText("Position = " + RichardsEqn.formatLength(RichardsEqn.criticalPosition) + " " + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit]);
            this.tfPosition.setText(RichardsEqn.formatLength(RichardsEqn.criticalPosition));
            if (RichardsEqn.selectedGraphIndex2 == 23) {
                this.lGraph2.setText("");
            }
        }
    }

    public void updateSimulationGraphChoice(boolean bl) {
        if (this.centerPane.getComponentCount() != 0) {
            this.centerPane.removeAll();
        }
        if (!bl) {
            upPanel = new UpTitlePanel();
        }
        this.upGraph = new UpGraphPanel();
        if (!bl) {
            this.lowPanel = new LowTitlePanel();
        }
        this.lowGraph = new LowGraphPanel();
        this.captionP = new CaptionPanel();
        this.centerPane.add(upPanel);
        this.centerPane.add(this.upGraph);
        this.centerPane.add(this.lowPanel);
        this.centerPane.add(this.lowGraph);
        this.centerPane.add(this.captionP);
        CHEMFLO.mainScreen.add((Component)this.centerPane, "Center");
    }

    public void simulationForOutput(double d, boolean bl) {
        RichardsEqn.criticalTime = d;
        this.showMsg = false;
        this.simCalculate();
        RichardsEqn.stop = false;
        if (bl) {
            this.performed();
            this.repaint();
        }
    }

    public void simCalculate() {
        if (RichardsEqn.semiInfiniteSelected != SoilInterestPanel.cboxSemiInfinite.isSelected()) {
            RichardsEqn.restart = true;
            boolean bl = RichardsEqn.semiInfiniteSelected = !RichardsEqn.semiInfiniteSelected;
        }
        if (RichardsEqn.errorFree && this.errorFree) {
            double d;
            double d2;
            if (RichardsEqn.restart) {
                RichardsEqn.soil = RichardsEqn.editingSoil.horizon.length == 1 ? (RichardsEqn.semiInfiniteSelected ? new Soil(RichardsEqn.currentSoilName, 100000.0, RichardsEqn.editingSoil.horizon[0].getBulkDensity(), RichardsEqn.editingSoil.horizon[0].getOC(), RichardsEqn.editingSoil.horizon[0].wc, RichardsEqn.editingSoil.horizon[0].k) : new Soil(RichardsEqn.currentSoilName, RichardsEqn.length, RichardsEqn.editingSoil.horizon[0].getBulkDensity(), RichardsEqn.editingSoil.horizon[0].getOC(), RichardsEqn.editingSoil.horizon[0].wc, RichardsEqn.editingSoil.horizon[0].k)) : new Soil(RichardsEqn.currentSoilName, RichardsEqn.editingSoil.horizon);
                if (SoilInterestPanel.cboxSemiInfinite.isSelected()) {
                    switch (RichardsEqn.selectedInitialCond) {
                        case 0: {
                            RichardsEqn.ic = new InitialCondition(RichardsEqn.matricPotInitial, false);
                            break;
                        }
                        case 1: {
                            RichardsEqn.ic = new InitialCondition(RichardsEqn.soil.horizon[0].wc.getMatricPotential(RichardsEqn.wcInitial), false);
                        }
                    }
                    this.simChem = false;
                } else {
                    switch (RichardsEqn.selectedInitialCond) {
                        case 0: {
                            if (RichardsEqn.selectedInitialCond2 == 0) {
                                RichardsEqn.ic = new InitialCondition(RichardsEqn.matricPotInitial, true);
                                this.simChem = false;
                                break;
                            }
                            switch (RichardsEqn.selectedInitialCond2) {
                                case 1: {
                                    RichardsEqn.ic = new InitialCondition(RichardsEqn.matricPotInitial, RichardsEqn.matricChemPotInitial, true);
                                    RichardsEqn.ic.setIsTotalConcentration(false);
                                    break;
                                }
                                case 2: {
                                    RichardsEqn.ic = new InitialCondition(RichardsEqn.matricPotInitial, RichardsEqn.matricChemPotInitial, true);
                                    RichardsEqn.ic.setIsTotalConcentration(true);
                                    break;
                                }
                                case 3: {
                                    RichardsEqn.ic = new InitialCondition(RichardsEqn.meshPosition, RichardsEqn.matricPotential, RichardsEqn.chemConcentration);
                                    RichardsEqn.ic.setIsTotalConcentration(false);
                                    break;
                                }
                                case 4: {
                                    RichardsEqn.ic = new InitialCondition(RichardsEqn.meshPosition, RichardsEqn.matricPotential, RichardsEqn.chemConcentration);
                                    RichardsEqn.ic.setIsTotalConcentration(true);
                                }
                            }
                            this.simChem = true;
                            break;
                        }
                        case 1: {
                            if (RichardsEqn.selectedInitialCond2 == 0) {
                                RichardsEqn.ic = RichardsEqn.soil.horizon.length > 1 ? new InitialCondition(RichardsEqn.meshPosition, RichardsEqn.matricPotential, true) : new InitialCondition(RichardsEqn.soil.horizon[0].wc.getMatricPotential(RichardsEqn.wcInitial), true);
                                this.simChem = false;
                                break;
                            }
                            switch (RichardsEqn.selectedInitialCond2) {
                                case 1: {
                                    RichardsEqn.ic = RichardsEqn.soil.horizon.length > 1 ? new InitialCondition(RichardsEqn.meshPosition, RichardsEqn.matricPotential, RichardsEqn.matricChemPotInitial, true) : new InitialCondition(RichardsEqn.soil.horizon[0].wc.getMatricPotential(RichardsEqn.wcInitial), RichardsEqn.matricChemPotInitial, true);
                                    RichardsEqn.ic.setIsTotalConcentration(false);
                                    break;
                                }
                                case 2: {
                                    RichardsEqn.ic = RichardsEqn.soil.horizon.length > 1 ? new InitialCondition(RichardsEqn.meshPosition, RichardsEqn.matricPotential, RichardsEqn.matricChemPotInitial, true) : new InitialCondition(RichardsEqn.soil.horizon[0].wc.getMatricPotential(RichardsEqn.wcInitial), RichardsEqn.matricChemPotInitial, true);
                                    RichardsEqn.ic.setIsTotalConcentration(true);
                                    break;
                                }
                                case 3: {
                                    RichardsEqn.ic = new InitialCondition(RichardsEqn.meshPosition, RichardsEqn.matricPotential, RichardsEqn.chemConcentration);
                                    RichardsEqn.ic.setIsTotalConcentration(false);
                                    break;
                                }
                                case 4: {
                                    RichardsEqn.ic = new InitialCondition(RichardsEqn.meshPosition, RichardsEqn.matricPotential, RichardsEqn.chemConcentration);
                                    RichardsEqn.ic.setIsTotalConcentration(true);
                                }
                            }
                            this.simChem = true;
                            break;
                        }
                        case 2: {
                            if (RichardsEqn.selectedInitialCond2 == 0) {
                                RichardsEqn.ic = new InitialCondition(RichardsEqn.meshPosition, RichardsEqn.matricPotential);
                                this.simChem = false;
                                break;
                            }
                            RichardsEqn.ic = new InitialCondition(RichardsEqn.meshPosition, RichardsEqn.matricPotential, RichardsEqn.chemConcentration);
                            if (RichardsEqn.selectedInitialCond2 == 1 || RichardsEqn.selectedInitialCond2 == 3) {
                                RichardsEqn.ic.setIsTotalConcentration(false);
                            } else {
                                RichardsEqn.ic.setIsTotalConcentration(true);
                            }
                            this.simChem = true;
                        }
                    }
                }
            }
            if (RichardsEqn.newBCL && DefineBoundaryPanel.cboxFirstBC.isSelected() || RichardsEqn.newBC0 && DefineBoundaryPanel.cboxFirstBC.isSelected()) {
                RichardsEqn.mBC = 0;
                RichardsEqn.restart = true;
                d2 = RichardsEqn.ic.h[0];
                d = RichardsEqn.ic.h[RichardsEqn.ic.h.length - 1];
                this.updateBoundaryConditionAt0(d2);
                this.updateBoundaryConditionAtL(d);
            } else if ((RichardsEqn.newBC0 || RichardsEqn.newBCL) && RichardsEqn.criticalTime > RichardsEqn.bc[RichardsEqn.mBC].getTimeEnd()) {
                RichardsEqn.bc[++RichardsEqn.mBC] = new BoundaryCondition(RichardsEqn.bc[RichardsEqn.mBC - 1].getTimeEnd(), RichardsEqn.bc[RichardsEqn.mBC - 1].getTimeEnd());
                d2 = RichardsEqn.output[RichardsEqn.currentLine].h[0];
                d = RichardsEqn.output[RichardsEqn.currentLine].h[RichardsEqn.output[RichardsEqn.currentLine].h.length - 1];
                this.updateBoundaryConditionAt0(d2);
                this.updateBoundaryConditionAtL(d);
            }
            if (RichardsEqn.selectedInitialCond2 > 0) {
                RichardsEqn.tp = TransportPropertyPanel.hasNonUniform ? (!RichardsEqn.usingKoc ? new TransportProperties(RichardsEqn.Position, RichardsEqn.Alpha, RichardsEqn.Beta, RichardsEqn.Gamma, RichardsEqn.Kd, RichardsEqn.disp, RichardsEqn.diff) : new TransportProperties(RichardsEqn.Position, RichardsEqn.Alpha, RichardsEqn.Beta, RichardsEqn.Gamma, RichardsEqn.Koc, RichardsEqn.disp, RichardsEqn.diff)) : (!RichardsEqn.usingKoc ? new TransportProperties(RichardsEqn.alph, RichardsEqn.beta, RichardsEqn.gamma, RichardsEqn.kd, RichardsEqn.disp, RichardsEqn.diff) : new TransportProperties(RichardsEqn.alph, RichardsEqn.beta, RichardsEqn.gamma, 0.0, RichardsEqn.disp, RichardsEqn.diff, RichardsEqn.Koc));
            }
            if (RichardsEqn.restart || RichardsEqn.criticalTime < RichardsEqn.bc[RichardsEqn.mBC].getTimeEnd()) {
                this.newLine = true;
                if (SoilInterestPanel.cboxSemiInfinite.isSelected()) {
                    double d3;
                    double d4;
                    double d5;
                    RichardsEqn.ic.isFinite = false;
                    RichardsEqn.bc[0].setSemiInfinite();
                    double d6 = 0.0;
                    double d7 = 0.0;
                    double d8 = 0.0;
                    if (RichardsEqn.restart) {
                        d6 = RichardsEqn.dt;
                        d7 = RichardsEqn.dz;
                        d8 = RichardsEqn.converg;
                        d5 = RichardsEqn.maxAbsError;
                        d4 = RichardsEqn.maxRelaError;
                        d3 = RichardsEqn.criticalCumuFlux;
                    } else {
                        d6 = RichardsEqn.experiment.getMeshSizeInTime();
                        d7 = RichardsEqn.experiment.getMeshSizeInDistance();
                        d8 = RichardsEqn.experiment.getConvergenceCriteria();
                        d5 = RichardsEqn.experiment.getMaxAbsError();
                        d4 = RichardsEqn.experiment.getMaxRelaError();
                        d3 = RichardsEqn.experiment.getCriticalCumuFlux();
                    }
                    RichardsEqn.experiment = new RichardsEqnSolver(RichardsEqn.soil, RichardsEqn.ic, RichardsEqn.bc[0], RichardsEqn.alpha, d7, d6, d8, d5, d4, d3, RichardsEqn.criticalPosition);
                    int n = 1;
                    while (n <= RichardsEqn.mBC) {
                        RichardsEqn.bc[n].setSemiInfinite();
                        RichardsEqn.experiment.addBoundaryCondition(RichardsEqn.bc[n]);
                        ++n;
                    }
                    RichardsEqn.experiment.setInitialCondition();
                } else {
                    RichardsEqn.ic.isFinite = true;
                    int n = 0;
                    while (n <= RichardsEqn.mBC) {
                        if (!RichardsEqn.bc[n].getIsFinite()) {
                            RichardsEqn.bc[n].setPotentialAtL(RichardsEqn.ic.h[0]);
                        }
                        ++n;
                    }
                    RichardsEqn.experiment = this.simChem ? new RichardsEqnSolver(RichardsEqn.soil, RichardsEqn.tp, RichardsEqn.ic, RichardsEqn.bc[0], RichardsEqn.alpha, RichardsEqn.experiment.getMeshSizeInDistance(), RichardsEqn.experiment.getMeshSizeInTime(), RichardsEqn.experiment.getConvergenceCriteria(), RichardsEqn.experiment.getMaxAbsError(), RichardsEqn.experiment.getMaxRelaError(), RichardsEqn.experiment.getCriticalCumuFlux(), RichardsEqn.criticalPosition) : new RichardsEqnSolver(RichardsEqn.soil, RichardsEqn.ic, RichardsEqn.bc[0], RichardsEqn.alpha, RichardsEqn.experiment.getMeshSizeInDistance(), RichardsEqn.experiment.getMeshSizeInTime(), RichardsEqn.experiment.getConvergenceCriteria(), RichardsEqn.experiment.getMaxAbsError(), RichardsEqn.experiment.getMaxRelaError(), RichardsEqn.experiment.getCriticalCumuFlux(), RichardsEqn.criticalPosition);
                    int n2 = 1;
                    while (n2 <= RichardsEqn.mBC) {
                        RichardsEqn.experiment.addBoundaryCondition(RichardsEqn.bc[n2]);
                        ++n2;
                    }
                    RichardsEqn.experiment.setInitialCondition();
                }
            } else if (RichardsEqn.newBC0 || RichardsEqn.newBCL) {
                if (SoilInterestPanel.cboxSemiInfinite.isSelected()) {
                    RichardsEqn.bc[RichardsEqn.mBC].setSemiInfinite();
                }
                RichardsEqn.experiment.addBoundaryCondition(RichardsEqn.bc[RichardsEqn.mBC]);
            }
            RichardsEqn.bc[RichardsEqn.mBC].setTimeEnd(RichardsEqn.criticalTime);
            if (this.DEBUG) {
                try {
                    this.outputAllData();
                }
                catch (IOException iOException) {
                    System.out.println(iOException);
                }
            }
            RichardsEqn.restart = false;
            RichardsEqn.newBC0 = false;
            RichardsEqn.newBCL = false;
            lMessage1.setVisible(this.showMsg);
            lMessage1.setText("Calculating, Please Wait ...");
            if (this.old_t < RichardsEqn.criticalTime) {
                this.newLine = true;
            }
            if ((RichardsEqn.simString = RichardsEqn.experiment.simulate(RichardsEqn.criticalTime)).equals("true")) {
                this.cumuInflux = RichardsEqn.experiment.cumuInflux;
                this.storageIncrease = RichardsEqn.experiment.storageIncrease;
                this.absError = Math.abs(this.cumuInflux - this.storageIncrease);
                this.relaError = 100.0 * this.absError / Math.abs(this.cumuInflux);
                this.massBalanceWarning = false;
                if (Math.abs(this.cumuInflux) >= RichardsEqn.criticalCumuFlux) {
                    if (this.relaError >= RichardsEqn.maxRelaError) {
                        this.massBalanceWarning = true;
                    }
                } else if (this.absError >= RichardsEqn.maxAbsError) {
                    this.massBalanceWarning = true;
                }
                if (this.massBalanceWarning && RichardsEqn.criticalTime > 0.0) {
                    String string = "Mass Balance Criterion Not Met\n";
                    string = Double.isNaN(this.cumuInflux) ? string + "\nNet Cumulative Flux (cm):                             " + this.cumuInflux : string + "\nNet Cumulative Flux (cm):                             " + Tools.formatDouble(this.cumuInflux, 4, 4);
                    string = Double.isNaN(this.storageIncrease) ? string + "\nStorage Increase (cm):                                 " + this.storageIncrease : string + "\nStorage Increase (cm):                                 " + Tools.formatDouble(this.storageIncrease, 4, 4);
                    string = Double.isNaN(this.absError) ? string + "\nAbsolute Mass Balance Error (cm):           " + this.absError : string + "\nAbsolute Mass Balance Error (cm):           " + Tools.formatDouble(this.absError, 4, 4);
                    string = Double.isNaN(this.relaError) ? string + "\nRelative Mass Balance Error (%):                " + this.relaError : string + "\nRelative Mass Balance Error (%):                " + Tools.formatDouble(this.relaError, 4, 4);
                    JOptionPane.showMessageDialog(CHEMFLO.appWin, string + "\n\nMass balance can usually be improved by using a smaller value for the convergence " + "\ncriterion or smaller mesh sizes.", "Mass Balance Information", 2);
                }
                RichardsEqn.output[RichardsEqn.currentLine] = this.simChem ? new Solution(RichardsEqn.experiment.getNumberPoints(), RichardsEqn.experiment.getPositionArray(), RichardsEqn.experiment.getMatricPotentialArray(), RichardsEqn.experiment.getFluxWaterArray(), RichardsEqn.experiment.cumFluxWater, RichardsEqn.experiment.getConcentrationArray(), RichardsEqn.experiment.cumFluxChem, RichardsEqn.soil, RichardsEqn.experiment.tp, RichardsEqn.experiment.angle, RichardsEqn.experiment.positionSaved, RichardsEqn.experiment.time, RichardsEqn.experiment.mp, RichardsEqn.experiment.q, RichardsEqn.experiment.conc, RichardsEqn.experiment.fluxChem, RichardsEqn.experiment.massChem, RichardsEqn.experiment.nPointsSaved, RichardsEqn.experiment.ic.isFinite) : new Solution(RichardsEqn.experiment.getNumberPoints(), RichardsEqn.experiment.getPositionArray(), RichardsEqn.experiment.getMatricPotentialArray(), RichardsEqn.experiment.getFluxWaterArray(), RichardsEqn.experiment.cumFluxWater, RichardsEqn.soil, RichardsEqn.experiment.angle, RichardsEqn.experiment.positionSaved, RichardsEqn.experiment.time, RichardsEqn.experiment.mp, RichardsEqn.experiment.q, RichardsEqn.experiment.nPointsSaved, RichardsEqn.experiment.ic.isFinite);
                if (RichardsEqn.oldInitialCond2 != RichardsEqn.selectedInitialCond2) {
                    if (RichardsEqn.oldInitialCond2 <= 0 || RichardsEqn.selectedInitialCond2 <= 0) {
                        int n = 1;
                        while (n < 5) {
                            RichardsEqn.output[n] = new Solution();
                            this.graphData[n] = null;
                            ++n;
                        }
                        this.updateSimulationGraphChoice(false);
                        RichardsEqn.diffsoilModel = false;
                    }
                    RichardsEqn.oldInitialCond2 = RichardsEqn.selectedInitialCond2;
                } else if (RichardsEqn.diffsoilModel) {
                    this.updateSimulationGraphChoice(false);
                    RichardsEqn.diffsoilModel = false;
                }
                RichardsEqn.criticalPosition = RichardsEqn.output[RichardsEqn.currentLine].depth;
                this.old_t = RichardsEqn.criticalTime;
                if (RichardsEqn.selectedGraphIndex <= 6 || RichardsEqn.selectedGraphIndex > 15 && RichardsEqn.selectedGraphIndex <= 18) {
                    this.lGraph.setText("Time = " + RichardsEqn.formatTime(this.old_t) + " " + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit]);
                } else {
                    String string = RichardsEqn.formatLength(RichardsEqn.criticalPosition);
                    this.lGraph.setText("Position = " + string + " " + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit]);
                    this.tfPosition.setText(string);
                }
                if (RichardsEqn.selectedGraphIndex2 <= 6 || RichardsEqn.selectedGraphIndex2 > 15 && RichardsEqn.selectedGraphIndex2 <= 18) {
                    this.lGraph2.setText("Time = " + RichardsEqn.formatTime(this.old_t) + " " + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit]);
                } else {
                    String string = RichardsEqn.formatLength(RichardsEqn.criticalPosition);
                    this.lGraph2.setText("Position = " + string + " " + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit]);
                    this.tfPosition.setText(string);
                    if (RichardsEqn.selectedGraphIndex2 == 23) {
                        this.lGraph2.setText("");
                    }
                }
            } else if (RichardsEqn.simString.equals("false")) {
                String string = "";
                switch (RichardsEqn.experiment.convergenceFailureIndex) {
                    case 0: {
                        string = "SMALL or the time step was too BIG.";
                        break;
                    }
                    case 1: {
                        string = "BIG.";
                    }
                }
                JOptionPane.showMessageDialog(CHEMFLO.appWin, "Convergence failed probably because the convergence \ncriterion was too " + string + "\n\nNo solution was obtained.", "Convergence Error", 0);
                CHEMFLO.appWin.repaint();
            } else {
                if (RichardsEqn.simString.equals("Abort")) {
                    return;
                }
                JOptionPane.showMessageDialog(CHEMFLO.appWin, RichardsEqn.simString, "Error", 0);
                CHEMFLO.appWin.repaint();
            }
            if (RichardsEqn.simString.equals("true")) {
                lMessage1.setVisible(false);
            }
            if (this.newLine) {
                this.graphData[RichardsEqn.currentLine].gData = new Vector();
                this.graphData[RichardsEqn.currentLine].collectData();
            }
            RichardsEqn.stop = true;
        }
    }

    void outputAllData() throws IOException {
        try {
            int n;
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter("alldata.txt"));
            bufferedWriter.write("restart =" + RichardsEqn.restart + "\r\n");
            bufferedWriter.write(RichardsEqn.experiment.s.displaySoil() + "\r\n");
            if (RichardsEqn.semiInfiniteSelected) {
                bufferedWriter.write("Semi-infinite soil: ");
                bufferedWriter.write("Max distance to plot: " + RichardsEqn.xmax + "\r\n");
            }
            bufferedWriter.write("soil length = " + RichardsEqn.experiment.s.getLength() + "\r\n");
            bufferedWriter.write("angle = " + RichardsEqn.experiment.angle + "\r\n");
            bufferedWriter.write("dz = " + RichardsEqn.experiment.getMeshSizeInDistance() + "\r\n");
            bufferedWriter.write("dt = " + RichardsEqn.experiment.getMeshSizeInTime() + "\r\n");
            bufferedWriter.write("convergenceCriteria = " + RichardsEqn.experiment.getConvergenceCriteria() + "\r\n");
            bufferedWriter.write("Initial Conditions:\r\n");
            bufferedWriter.write("\r\nisFinite =" + RichardsEqn.experiment.ic.isFinite + "\r\n");
            bufferedWriter.write("simChemical =" + RichardsEqn.experiment.ic.simChemical + "\r\n");
            if (RichardsEqn.experiment.ic.simChemical) {
                bufferedWriter.write("\r\nposition\tPotential\tConcentration\r\n");
                n = 0;
                while (n < RichardsEqn.experiment.ic.x.length) {
                    bufferedWriter.write(RichardsEqn.experiment.ic.x[n] + "\t\t" + RichardsEqn.experiment.ic.h[n] + "\t\t" + RichardsEqn.experiment.ic.c[n] + "\r\n");
                    ++n;
                }
            } else {
                bufferedWriter.write("\r\nposition\tPotential\r\n");
                n = 0;
                while (n < RichardsEqn.experiment.ic.x.length) {
                    bufferedWriter.write(RichardsEqn.experiment.ic.x[n] + "\t\t" + RichardsEqn.experiment.ic.h[n] + "\r\n");
                    ++n;
                }
            }
            bufferedWriter.write("Boundary Conditions:\r\n");
            bufferedWriter.write("\r\ntimeStart = " + RichardsEqn.experiment.bc[RichardsEqn.experiment.currentBC].getTimeStart() + "\r\n");
            bufferedWriter.write("timeEnd = " + RichardsEqn.experiment.bc[RichardsEqn.experiment.currentBC].getTimeEnd() + "\r\n");
            bufferedWriter.write("isInfinite =" + RichardsEqn.experiment.bc[RichardsEqn.experiment.currentBC].getIsFinite() + "\r\n");
            bufferedWriter.write("PotentialAt0 = " + RichardsEqn.experiment.bc[RichardsEqn.experiment.currentBC].getPotentialAt0() + "\r\n");
            bufferedWriter.write("PotentialAtL = " + RichardsEqn.experiment.bc[RichardsEqn.experiment.currentBC].getPotentialAtL() + "\r\n");
            bufferedWriter.write("FluxAt0 = " + RichardsEqn.experiment.bc[RichardsEqn.experiment.currentBC].getFluxAt0() + "\r\n");
            bufferedWriter.write("FluxAtL = " + RichardsEqn.experiment.bc[RichardsEqn.experiment.currentBC].getFluxAtL() + "\r\n");
            bufferedWriter.write("WaterBCTypeAt0 = " + RichardsEqn.experiment.bc[RichardsEqn.experiment.currentBC].getWaterBCTypeAt0() + "\r\n");
            bufferedWriter.write("WaterBCTypeAtL = " + RichardsEqn.experiment.bc[RichardsEqn.experiment.currentBC].getWaterBCTypeAtL() + "\r\n");
            if (RichardsEqn.experiment.ic.simChemical) {
                bufferedWriter.write("ConcAt0 = " + RichardsEqn.experiment.bc[RichardsEqn.experiment.currentBC].getConcAt0() + "\r\n");
                bufferedWriter.write("ConcAtL = " + RichardsEqn.experiment.bc[RichardsEqn.experiment.currentBC].getConcAtL() + "\r\n");
                bufferedWriter.write("ChemBCTypeAt0 = " + RichardsEqn.experiment.bc[RichardsEqn.experiment.currentBC].getChemBCTypeAt0() + "\r\n");
                bufferedWriter.write("ChemBCTypeAtL = " + RichardsEqn.experiment.bc[RichardsEqn.experiment.currentBC].getChemBCTypeAtL() + "\r\n");
            }
            if (RichardsEqn.experiment.tp != null) {
                bufferedWriter.write("\r\nTransport properties:\r\n");
                bufferedWriter.write("\r\ndiffusion=" + RichardsEqn.experiment.tp.getDiffusionCoef() + "\r\n");
                bufferedWriter.write("Dispersivity=" + RichardsEqn.experiment.tp.getDispersivity() + "\r\n");
                double[] dArray = RichardsEqn.experiment.tp.getPsVal();
                double[] dArray2 = RichardsEqn.experiment.tp.getKdVal();
                double[] dArray3 = RichardsEqn.experiment.tp.getAlpVal();
                double[] dArray4 = RichardsEqn.experiment.tp.getBtVal();
                double[] dArray5 = RichardsEqn.experiment.tp.getGaVal();
                if (RichardsEqn.waterPartCoeIndex == 0 || RichardsEqn.waterPartCoeIndex == 2) {
                    bufferedWriter.write("\r\nposition\tKd\t\talpha\t\tBeta\t\tGamma\r\n");
                    int n2 = 0;
                    while (n2 < dArray.length) {
                        bufferedWriter.write(dArray[n2] + "\t\t" + dArray2[n2] + "\t\t" + dArray3[n2] + "\t\t" + dArray4[n2] + "\t\t" + dArray5[n2] + "\r\n");
                        ++n2;
                    }
                } else {
                    bufferedWriter.write("\r\nposition\tKoc\t\talpha\t\tBeta\t\tGamma\r\n");
                    int n3 = 0;
                    while (n3 < dArray.length) {
                        bufferedWriter.write(dArray[n3] + "\t\t" + RichardsEqn.experiment.tp.getKoc() + "\t\t" + dArray3[n3] + "\t\t" + dArray4[n3] + "\t\t" + dArray5[n3] + "\r\n");
                        ++n3;
                    }
                }
            }
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    public void resetPosition() {
        if (RichardsEqn.semiInfiniteSelected) {
            String string = this.tfPosition.getText();
            int n = (int)Double.parseDouble(string);
            DefaultBoundedRangeModel defaultBoundedRangeModel = new DefaultBoundedRangeModel(n, 0, 0, 5000);
            this.sbrPosition.setModel(defaultBoundedRangeModel);
        } else {
            String string = this.tfPosition.getText();
            int n = (int)Double.parseDouble(string);
            this.posLimit = (int)(RichardsEqn.length + 0.5);
            if (n > this.posLimit) {
                n = 0;
                this.tfPosition.setText(RichardsEqn.formatLength(n));
            }
            DefaultBoundedRangeModel defaultBoundedRangeModel = new DefaultBoundedRangeModel(n, 0, 0, this.posLimit);
            this.sbrPosition.setModel(defaultBoundedRangeModel);
        }
    }

    private void hookupEvents() {
        this.bCalculate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainScreenPanel.this.startCalcu();
            }
        });
        this.bAbort.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainScreenPanel.this.abortCalcu();
            }
        });
    }

    private void startCalcu() {
        this.ensureEventThread();
        RichardsEqn.stop = false;
        this.performed();
        this.showMsg = true;
        this.bCalculate.setEnabled(false);
        this.bAbort.setEnabled(true);
        this.lookupAsync();
    }

    private void abortCalcu() {
        this.ensureEventThread();
        RichardsEqn.stop = true;
        if (this.lookupThread != null) {
            this.lookupThread.interrupt();
        }
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.bAbort.setEnabled(false);
        lMessage1.setText("");
        this.updateAbortGraphs();
    }

    private void ensureEventThread() {
        if (SwingUtilities.isEventDispatchThread()) {
            return;
        }
        throw new RuntimeException("only the event thread should invoke this method");
    }

    private void lookupAsync() {
        Runnable runnable = new Runnable(){

            public void run() {
                MainScreenPanel.this.simCalculate();
                MainScreenPanel.this.setButtonSafely();
            }
        };
        this.lookupThread = new Thread(runnable, "lookupThread");
        this.lookupThread.start();
    }

    private void setButtonSafely() {
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    MainScreenPanel.this.setButtonSatae();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
        CHEMFLO.appWin.repaint();
    }

    private void setButtonSatae() {
        this.ensureEventThread();
        this.bCalculate.setEnabled(true);
        RichardsEqn.stop = true;
        this.bAbort.setEnabled(false);
    }

    private void updateAbortGraphs() {
        RichardsEqn.selectedGraphIndex = this.choiceGraph.getSelectedIndex();
        if (RichardsEqn.selectedGraphIndex == 15) {
            this.caption.setText("Boltzman Variable (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "/sqrt[" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + "])");
            this.lGraph.setText("");
        } else if (RichardsEqn.selectedGraphIndex <= 6 || RichardsEqn.selectedGraphIndex > 15 && RichardsEqn.selectedGraphIndex <= 18) {
            this.caption.setText("Distance from Soil Surface (X = 0), " + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit]);
            this.lGraph.setText("Time = " + RichardsEqn.formatTime(RichardsEqn.criticalTime) + " " + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit]);
        } else {
            this.caption.setText("Time (" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ")");
            this.lGraph.setText("Position = " + RichardsEqn.formatLength(RichardsEqn.criticalPosition) + " " + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit]);
            this.tfPosition.setText(RichardsEqn.formatLength(RichardsEqn.criticalPosition));
        }
        RichardsEqn.selectedGraphIndex2 = this.combox2.getSelectedIndex();
        if (RichardsEqn.selectedGraphIndex2 == 15) {
            this.caption2.setText("Boltzman Variable (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "/sqrt[" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + "])");
            this.caption2.setAlignmentX(0.0f);
            this.lGraph2.setText("");
        } else if (RichardsEqn.selectedGraphIndex2 <= 6 || RichardsEqn.selectedGraphIndex2 > 15 && RichardsEqn.selectedGraphIndex2 <= 18) {
            this.caption2.setText("Distance from Soil Surface (X = 0), " + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit]);
            this.caption2.setAlignmentX(2.0f);
            this.lGraph2.setText("Time = " + RichardsEqn.formatTime(RichardsEqn.criticalTime) + " " + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit]);
        } else {
            this.caption2.setText("Time (" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ")");
            this.caption2.setAlignmentX(0.0f);
            this.lGraph2.setText("Position = " + RichardsEqn.formatLength(RichardsEqn.criticalPosition) + " " + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit]);
            this.tfPosition.setText(RichardsEqn.formatLength(RichardsEqn.criticalPosition));
            if (RichardsEqn.selectedGraphIndex2 == 23) {
                this.lGraph2.setText("");
            }
        }
        RichardsEqn.output[RichardsEqn.currentLine] = this.simChem ? new Solution(RichardsEqn.experiment.getNumberPoints(), RichardsEqn.experiment.getPositionArray(), RichardsEqn.experiment.getMatricPotentialArray(), RichardsEqn.experiment.getFluxWaterArray(), RichardsEqn.experiment.cumFluxWater, RichardsEqn.experiment.getConcentrationArray(), RichardsEqn.experiment.cumFluxChem, RichardsEqn.soil, RichardsEqn.experiment.tp, RichardsEqn.experiment.angle, RichardsEqn.experiment.positionSaved, RichardsEqn.experiment.time, RichardsEqn.experiment.mp, RichardsEqn.experiment.q, RichardsEqn.experiment.conc, RichardsEqn.experiment.fluxChem, RichardsEqn.experiment.massChem, RichardsEqn.experiment.nPointsSaved, RichardsEqn.experiment.ic.isFinite) : new Solution(RichardsEqn.experiment.getNumberPoints(), RichardsEqn.experiment.getPositionArray(), RichardsEqn.experiment.getMatricPotentialArray(), RichardsEqn.experiment.getFluxWaterArray(), RichardsEqn.experiment.cumFluxWater, RichardsEqn.soil, RichardsEqn.experiment.angle, RichardsEqn.experiment.positionSaved, RichardsEqn.experiment.time, RichardsEqn.experiment.mp, RichardsEqn.experiment.q, RichardsEqn.experiment.nPointsSaved, RichardsEqn.experiment.ic.isFinite);
        this.graphData[RichardsEqn.currentLine].gData = new Vector();
        this.graphData[RichardsEqn.currentLine].collectData();
        this.old_t = RichardsEqn.criticalTime;
        this.performed();
        this.repaint();
    }

    public void updateSize() {
        this.updateSimulationGraphChoice(true);
    }

    public boolean hasNewLine() {
        return this.newLine;
    }

    public int getDecimalNumber(double d, double d2) {
        int n = 2;
        double d3 = d - d2;
        if (d3 < 0.01) {
            n = 4;
            String string = String.valueOf(d3);
            if (string.indexOf(69) > 0 || string.indexOf(101) > 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
                stringTokenizer.nextToken();
                n = Integer.parseInt(stringTokenizer.nextToken()) + 1;
            }
        } else if (d3 > 1000.0) {
            n = 1;
        }
        return n;
    }

    static {
        lMessage1 = new Label(" ", 0);
    }

    class forEvent
    extends MouseAdapter
    implements AdjustmentListener,
    ActionListener,
    ItemListener {
        int iTemp;
        double dTemp;
        String sTemp;
        String name;

        public forEvent(String string) {
            this.name = string;
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            if (this.name.equals("Time")) {
                MainScreenPanel.this.showMsg = true;
                this.iTemp = MainScreenPanel.this.sbrTime.getValue();
                RichardsEqn.criticalTime = (double)this.iTemp / 10.0;
                MainScreenPanel.this.tfTime.setText(RichardsEqn.formatTime(RichardsEqn.criticalTime));
                if (MainScreenPanel.this.old_t > RichardsEqn.criticalTime) {
                    RichardsEqn.restart = true;
                }
            } else if (this.name.equals("Position")) {
                MainScreenPanel.this.showMsg = true;
                this.iTemp = MainScreenPanel.this.sbrPosition.getValue();
                RichardsEqn.criticalPosition = this.iTemp;
                MainScreenPanel.this.tfPosition.setText(RichardsEqn.formatLength(RichardsEqn.criticalPosition));
                RichardsEqn.restart = true;
            }
            MainScreenPanel.this.performed();
            MainScreenPanel.this.repaint();
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (this.name.equals("Graph") && RichardsEqn.selectedGraphIndex != MainScreenPanel.this.choiceGraph.getSelectedIndex()) {
                RichardsEqn.selectedGraphIndex = MainScreenPanel.this.choiceGraph.getSelectedIndex();
                if (RichardsEqn.selectedGraphIndex == 15) {
                    MainScreenPanel.this.caption.setText("Boltzman Variable (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "/sqrt[" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + "])");
                    MainScreenPanel.this.lGraph.setText("");
                } else if (RichardsEqn.selectedGraphIndex <= 6 || RichardsEqn.selectedGraphIndex > 15 && RichardsEqn.selectedGraphIndex <= 18) {
                    MainScreenPanel.this.caption.setText("Distance from Soil Surface (X = 0), " + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit]);
                    MainScreenPanel.this.lGraph.setText("Time = " + RichardsEqn.formatTime(MainScreenPanel.this.old_t) + " " + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit]);
                } else {
                    MainScreenPanel.this.caption.setText("Time (" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ")");
                    MainScreenPanel.this.lGraph.setText("Position = " + RichardsEqn.formatLength(RichardsEqn.criticalPosition) + " " + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit]);
                    MainScreenPanel.this.tfPosition.setText(RichardsEqn.formatLength(RichardsEqn.criticalPosition));
                }
            }
            if (this.name.equals("Graph2") && RichardsEqn.selectedGraphIndex2 != MainScreenPanel.this.combox2.getSelectedIndex()) {
                RichardsEqn.selectedGraphIndex2 = MainScreenPanel.this.combox2.getSelectedIndex();
                if (RichardsEqn.selectedGraphIndex2 == 15) {
                    MainScreenPanel.this.caption2.setText("Boltzman Variable (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "/sqrt[" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + "])");
                    MainScreenPanel.this.caption2.setAlignmentX(0.0f);
                    MainScreenPanel.this.lGraph2.setText("");
                } else if (RichardsEqn.selectedGraphIndex2 <= 6 || RichardsEqn.selectedGraphIndex2 > 15 && RichardsEqn.selectedGraphIndex2 <= 18) {
                    MainScreenPanel.this.caption2.setText("Distance from Soil Surface (X = 0), " + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit]);
                    MainScreenPanel.this.caption2.setAlignmentX(2.0f);
                    MainScreenPanel.this.lGraph2.setText("Time = " + RichardsEqn.formatTime(MainScreenPanel.this.old_t) + " " + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit]);
                } else {
                    MainScreenPanel.this.caption2.setText("Time (" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ")");
                    MainScreenPanel.this.caption2.setAlignmentX(0.0f);
                    MainScreenPanel.this.lGraph2.setText("Position = " + RichardsEqn.formatLength(RichardsEqn.criticalPosition) + " " + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit]);
                    MainScreenPanel.this.tfPosition.setText(RichardsEqn.formatLength(RichardsEqn.criticalPosition));
                    if (RichardsEqn.selectedGraphIndex2 == 23) {
                        MainScreenPanel.this.lGraph2.setText("");
                    }
                }
            }
            MainScreenPanel.this.repaint();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.name.equals("SaveImage") && MainScreenPanel.this.newLine && RichardsEqn.simString.equals("true")) {
                if (++RichardsEqn.jLines > 4) {
                    RichardsEqn.jLines = 1;
                }
                RichardsEqn.output[RichardsEqn.jLines] = MainScreenPanel.this.simChem ? new Solution(RichardsEqn.experiment.getNumberPoints(), RichardsEqn.experiment.getPositionArray(), RichardsEqn.experiment.getMatricPotentialArray(), RichardsEqn.experiment.getFluxWaterArray(), RichardsEqn.experiment.cumFluxWater, RichardsEqn.experiment.getConcentrationArray(), RichardsEqn.experiment.cumFluxChem, RichardsEqn.soil, RichardsEqn.experiment.tp, RichardsEqn.experiment.angle, RichardsEqn.experiment.positionSaved, RichardsEqn.experiment.time, RichardsEqn.experiment.mp, RichardsEqn.experiment.q, RichardsEqn.experiment.conc, RichardsEqn.experiment.fluxChem, RichardsEqn.experiment.massChem, RichardsEqn.experiment.nPointsSaved, RichardsEqn.experiment.ic.isFinite) : new Solution(RichardsEqn.experiment.getNumberPoints(), RichardsEqn.experiment.getPositionArray(), RichardsEqn.experiment.getMatricPotentialArray(), RichardsEqn.experiment.getFluxWaterArray(), RichardsEqn.experiment.cumFluxWater, RichardsEqn.soil, RichardsEqn.experiment.angle, RichardsEqn.experiment.positionSaved, RichardsEqn.experiment.time, RichardsEqn.experiment.mp, RichardsEqn.experiment.q, RichardsEqn.experiment.nPointsSaved, RichardsEqn.experiment.ic.isFinite);
                MainScreenPanel.this.graphData[RichardsEqn.jLines] = new GraphData();
                MainScreenPanel.this.graphData[RichardsEqn.jLines].setColor(MainScreenPanel.this.colorName[RichardsEqn.jLines], RichardsEqn.colorLine[RichardsEqn.jLines]);
                MainScreenPanel.this.graphData[RichardsEqn.jLines].gData = MainScreenPanel.this.graphData[RichardsEqn.currentLine].gData;
                MainScreenPanel.this.graphData[RichardsEqn.jLines].updateColor();
                MainScreenPanel.this.performed();
                MainScreenPanel.this.repaint();
                MainScreenPanel.this.newLine = false;
            }
            if (this.name.equals("ClearImage")) {
                int n = 1;
                while (n < 5) {
                    RichardsEqn.output[n] = new Solution();
                    MainScreenPanel.this.graphData[n] = null;
                    ++n;
                }
                MainScreenPanel.this.graphData[RichardsEqn.currentLine].updateColor();
                MainScreenPanel.this.performed();
                MainScreenPanel.this.repaint();
            }
            if (this.name.equals("Time") || this.name.equals("Position")) {
                MainScreenPanel.this.showMsg = true;
                MainScreenPanel.this.performed();
                MainScreenPanel.this.repaint();
            }
            if (this.name.trim().equals("CustomizeGraph")) {
                MainScreenPanel.this.performed();
                if (!MainScreenPanel.this.errorFree) {
                    JOptionPane.showMessageDialog(CHEMFLO.appWin, RichardsEqn.errorMessage, "Error", 0);
                    CHEMFLO.appWin.repaint();
                } else {
                    ((MainScreenPanel)MainScreenPanel.this).upLim[0] = MainScreenPanel.this.upXmin;
                    ((MainScreenPanel)MainScreenPanel.this).upLim[1] = MainScreenPanel.this.upXmax;
                    ((MainScreenPanel)MainScreenPanel.this).upLim[2] = MainScreenPanel.this.upYmin;
                    ((MainScreenPanel)MainScreenPanel.this).upLim[3] = MainScreenPanel.this.upYmax;
                    ((MainScreenPanel)MainScreenPanel.this).lowLim[0] = MainScreenPanel.this.lowXmin;
                    ((MainScreenPanel)MainScreenPanel.this).lowLim[1] = MainScreenPanel.this.lowXmax;
                    ((MainScreenPanel)MainScreenPanel.this).lowLim[2] = MainScreenPanel.this.lowYmin;
                    ((MainScreenPanel)MainScreenPanel.this).lowLim[3] = MainScreenPanel.this.lowYmax;
                    new CustomizeDialog(MainScreenPanel.this.upLim, MainScreenPanel.this.lowLim, (String)MainScreenPanel.this.choiceGraph.getSelectedItem(), (String)MainScreenPanel.this.combox2.getSelectedItem(), RichardsEqn.selectedGraphIndex, RichardsEqn.selectedGraphIndex2);
                }
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            block3: {
                if (!(mouseEvent.getSource() instanceof JTextField)) break block3;
                MainScreenPanel.this.showMsg = true;
                JTextField jTextField = (JTextField)mouseEvent.getSource();
                if (jTextField.getText() != null && jTextField.getText().trim().length() != 0) {
                    try {
                        Double.parseDouble(jTextField.getText());
                        MainScreenPanel.this.performed();
                        MainScreenPanel.this.repaint();
                    }
                    catch (NumberFormatException numberFormatException) {
                        jTextField.grabFocus();
                    }
                }
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            MainScreenPanel.this.showMsg = true;
            MainScreenPanel.this.performed();
        }
    }

    class bntMouseListener
    extends MouseAdapter {
        bntMouseListener() {
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (MainScreenPanel.this.bSave == (JButton)mouseEvent.getSource()) {
                MainScreenPanel.this.bSave.setBorder(MainScreenPanel.this.oldBorder);
            } else if (MainScreenPanel.this.bClear == (JButton)mouseEvent.getSource()) {
                MainScreenPanel.this.bClear.setBorder(MainScreenPanel.this.oldBorder);
            } else if (MainScreenPanel.this.bCalculate == (JButton)mouseEvent.getSource()) {
                MainScreenPanel.this.bCalculate.setBorder(MainScreenPanel.this.oldBorder);
            } else if (MainScreenPanel.this.bAbort == (JButton)mouseEvent.getSource()) {
                MainScreenPanel.this.bAbort.setBorder(MainScreenPanel.this.oldBorder);
            } else if (MainScreenPanel.this.bCustomizer == (JButton)mouseEvent.getSource()) {
                MainScreenPanel.this.bCustomizer.setBorder(MainScreenPanel.this.oldBorder);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (MainScreenPanel.this.bSave == (JButton)mouseEvent.getSource()) {
                MainScreenPanel.this.bSave.setBorder(MainScreenPanel.this.raisedEdge);
            } else if (MainScreenPanel.this.bClear == (JButton)mouseEvent.getSource()) {
                MainScreenPanel.this.bClear.setBorder(MainScreenPanel.this.raisedEdge);
            } else if (MainScreenPanel.this.bCalculate == (JButton)mouseEvent.getSource()) {
                MainScreenPanel.this.bCalculate.setBorder(MainScreenPanel.this.raisedEdge);
            } else if (MainScreenPanel.this.bAbort == (JButton)mouseEvent.getSource()) {
                MainScreenPanel.this.bAbort.setBorder(MainScreenPanel.this.raisedEdge);
            } else if (MainScreenPanel.this.bCustomizer == (JButton)mouseEvent.getSource()) {
                MainScreenPanel.this.bCustomizer.setBorder(MainScreenPanel.this.raisedEdge);
            }
        }
    }

    class LowGraphPanel
    extends JPanel {
        LowGraphPanel() {
            if (CHEMFLO.wMax) {
                MainScreenPanel.this.gWidth = CHEMFLO.screenDimension.width - 430;
                MainScreenPanel.this.gHeight = (CHEMFLO.screenDimension.height - 365) / 2;
            } else {
                MainScreenPanel.this.gWidth = 350;
                MainScreenPanel.this.gHeight = 132;
            }
            this.setPreferredSize(new Dimension(MainScreenPanel.this.gWidth, MainScreenPanel.this.gHeight));
            this.setLayout(null);
        }

        public void paint(Graphics graphics) {
            MainScreenPanel.this.drawGraph(graphics, RichardsEqn.selectedGraphIndex2, false);
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }
    }

    class UpGraphPanel
    extends JPanel {
        UpGraphPanel() {
            if (CHEMFLO.wMax) {
                MainScreenPanel.this.gWidth = CHEMFLO.screenDimension.width - 430;
                MainScreenPanel.this.gHeight = (CHEMFLO.screenDimension.height - 365) / 2;
            } else {
                MainScreenPanel.this.gWidth = 350;
                MainScreenPanel.this.gHeight = 132;
            }
            this.setPreferredSize(new Dimension(MainScreenPanel.this.gWidth, MainScreenPanel.this.gHeight));
            this.setLayout(null);
        }

        public void paint(Graphics graphics) {
            MainScreenPanel.this.drawGraph(graphics, RichardsEqn.selectedGraphIndex, true);
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }
    }

    class CaptionPanel
    extends JPanel {
        CaptionPanel() {
            int n = 0;
            n = CHEMFLO.wMax ? MainScreenPanel.this.gWidth : 420;
            this.setPreferredSize(new Dimension(n, 15));
            this.setLayout(null);
            MainScreenPanel.this.caption2 = new JLabel("Time (" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ") ", 0);
            MainScreenPanel.this.caption2.setForeground(Color.red);
            MainScreenPanel.this.caption2.setFont(RichardsEqn.labelFont);
            MainScreenPanel.this.caption2.setBounds(10, 8, n, 12);
            this.add(MainScreenPanel.this.caption2);
        }
    }

    class LowTitlePanel
    extends JPanel {
        LowTitlePanel() {
            int n = 0;
            n = CHEMFLO.wMax ? MainScreenPanel.this.gWidth : 420;
            this.setPreferredSize(new Dimension(n, 40));
            this.setLayout(null);
            MainScreenPanel.this.caption = new JLabel("Distance from Soil Surface (X = 0), " + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit], 0);
            MainScreenPanel.this.caption.setForeground(Color.red);
            MainScreenPanel.this.caption.setFont(RichardsEqn.labelFont);
            MainScreenPanel.this.caption.setBounds(10, 0, n, 22);
            MainScreenPanel.this.chNames.removeAllElements();
            MainScreenPanel.this.chNames.addElement("Water Content (v/v) vs. Distance");
            MainScreenPanel.this.chNames.addElement("Matric Potential (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + " of water) vs. Distance");
            MainScreenPanel.this.chNames.addElement("Conductivity (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ") vs. Distance(Linear)");
            MainScreenPanel.this.chNames.addElement("Conductivity (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ") vs. Distance(Semi-log)");
            MainScreenPanel.this.chNames.addElement("Driving Force vs. Distance");
            MainScreenPanel.this.chNames.addElement("Flux Density (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ") vs. Distance");
            MainScreenPanel.this.chNames.addElement("Total Potential (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + " of water) vs. Distance");
            MainScreenPanel.this.chNames.addElement("Water Content (v/v) vs. Time");
            MainScreenPanel.this.chNames.addElement("Matric Potential (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + " of water) vs. Time");
            MainScreenPanel.this.chNames.addElement("Conductivity (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ") vs. Time (Linear)");
            MainScreenPanel.this.chNames.addElement("Conductivity (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ") vs. Time (Semi-log)");
            MainScreenPanel.this.chNames.addElement("Driving Force vs. Time");
            MainScreenPanel.this.chNames.addElement("Flux Density (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ") vs. Time");
            MainScreenPanel.this.chNames.addElement("Total Potential (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + " of water) vs. Time");
            MainScreenPanel.this.chNames.addElement("Cumulative Flux (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + ") vs Time");
            MainScreenPanel.this.chNames.addElement("Water Content (v/v) vs Boltzman Variable");
            if (RichardsEqn.selectedInitialCond2 != 0) {
                MainScreenPanel.this.chNames.addElement("Solution Concentration (g/m3) vs Distance");
                MainScreenPanel.this.chNames.addElement("Total Concentration (g/m3) vs Distance");
                MainScreenPanel.this.chNames.addElement("Flux Density of Chemical (g/m2/hr) vs Distance");
                MainScreenPanel.this.chNames.addElement("Solution Concentration (g/m3) vs Time");
                MainScreenPanel.this.chNames.addElement("Total Concentration (g/m3) vs Time");
                MainScreenPanel.this.chNames.addElement("Flux Density of Chemical (g/m2/hr) vs Time");
                MainScreenPanel.this.chNames.addElement("Cumulative Flux of Chemical (g/m2)vs Time");
                MainScreenPanel.this.chNames.addElement("Mass Chemical/Unit Area (g/m2) vs Time");
            }
            MainScreenPanel.this.combox2 = new JComboBox(MainScreenPanel.this.chNames);
            MainScreenPanel.this.combox2.setForeground(Color.black);
            MainScreenPanel.this.combox2.setFont(RichardsEqn.comboBoxFont);
            if (RichardsEqn.selectedGraphIndex2 > 15 && RichardsEqn.selectedInitialCond2 == 0) {
                RichardsEqn.selectedGraphIndex2 = 14;
            }
            MainScreenPanel.this.combox2.setSelectedIndex(RichardsEqn.selectedGraphIndex2);
            MainScreenPanel.this.combox2.setBounds(10, 30, 280, 22);
            MainScreenPanel.this.lGraph2 = new JLabel("Position = " + Tools.formatDouble(RichardsEqn.criticalPosition, 2, 2) + " " + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit]);
            MainScreenPanel.this.lGraph2.setForeground(Color.red);
            MainScreenPanel.this.lGraph2.setFont(RichardsEqn.labelFont);
            MainScreenPanel.this.lGraph2.setBounds(295, 30, 140, 22);
            MainScreenPanel.this.combox2.addItemListener(new forEvent("Graph2"));
            this.add(MainScreenPanel.this.caption);
            this.add(MainScreenPanel.this.combox2);
            this.add(MainScreenPanel.this.lGraph2);
        }
    }

    class UpTitlePanel
    extends JPanel {
        UpTitlePanel() {
            this.setPreferredSize(new Dimension(430, 40));
            this.setLayout(null);
            lMessage1.setFont(new Font("Serif", 0, 12));
            lMessage1.setForeground(Color.blue);
            lMessage1.setBounds(10, 5, 520, 22);
            lMessage1.setVisible(false);
            MainScreenPanel.this.choiceG.removeAllElements();
            MainScreenPanel.this.choiceG.addElement("Water Content (v/v) vs. Distance");
            MainScreenPanel.this.choiceG.addElement("Matric Potential (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + " of water) vs. Distance");
            MainScreenPanel.this.choiceG.addElement("Conductivity (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ") vs. Distance(Linear)");
            MainScreenPanel.this.choiceG.addElement("Conductivity (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ") vs. Distance(Semi-log)");
            MainScreenPanel.this.choiceG.addElement("Driving Force vs. Distance");
            MainScreenPanel.this.choiceG.addElement("Flux Density (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ") vs. Distance");
            MainScreenPanel.this.choiceG.addElement("Total Potential (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + " of water) vs. Distance");
            MainScreenPanel.this.choiceG.addElement("Water Content (v/v) vs. Time");
            MainScreenPanel.this.choiceG.addElement("Matric Potential (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + " of water) vs. Time");
            MainScreenPanel.this.choiceG.addElement("Conductivity (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ") vs. Time (Linear)");
            MainScreenPanel.this.choiceG.addElement("Conductivity (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ") vs. Time (Semi-log)");
            MainScreenPanel.this.choiceG.addElement("Driving Force vs. Time");
            MainScreenPanel.this.choiceG.addElement("Flux Density (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ") vs. Time");
            MainScreenPanel.this.choiceG.addElement("Total Potential (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + " of water) vs. Time");
            MainScreenPanel.this.choiceG.addElement("Cumulative Flux (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + ") vs Time");
            MainScreenPanel.this.choiceG.addElement("Water Content (v/v) vs Boltzman Variable");
            if (RichardsEqn.selectedInitialCond2 != 0) {
                MainScreenPanel.this.choiceG.addElement("Solution Concentration (g/m3) vs Distance");
                MainScreenPanel.this.choiceG.addElement("Total Concentration (g/m3) vs Distance");
                MainScreenPanel.this.choiceG.addElement("Flux Density of Chemical (g/m2/hr) vs Distance");
                MainScreenPanel.this.choiceG.addElement("Solution Concentration (g/m3) vs Time");
                MainScreenPanel.this.choiceG.addElement("Total Concentration (g/m3) vs Time");
                MainScreenPanel.this.choiceG.addElement("Flux Density of Chemical (g/m2/hr) vs Time");
                MainScreenPanel.this.choiceG.addElement("Cumulative Flux of Chemical (g/m2) vs Time");
                MainScreenPanel.this.choiceG.addElement("Mass Chemical/Unit Area (g/m2) vs Time");
            }
            CustomizeDialog.gpLimits = new GraphAxesLimits[MainScreenPanel.this.choiceG.size()];
            int n = 0;
            while (n < MainScreenPanel.this.choiceG.size()) {
                CustomizeDialog.gpLimits[n] = new GraphAxesLimits();
                ++n;
            }
            MainScreenPanel.this.choiceGraph = new JComboBox(MainScreenPanel.this.choiceG);
            if (RichardsEqn.selectedGraphIndex > 15 && RichardsEqn.selectedInitialCond2 == 0) {
                RichardsEqn.selectedGraphIndex = 0;
            }
            MainScreenPanel.this.choiceGraph.setSelectedIndex(RichardsEqn.selectedGraphIndex);
            MainScreenPanel.this.choiceGraph.setForeground(Color.black);
            MainScreenPanel.this.choiceGraph.setFont(RichardsEqn.comboBoxFont);
            MainScreenPanel.this.choiceGraph.setBounds(10, 30, 280, 22);
            MainScreenPanel.this.choiceGraph.addItemListener(new forEvent("Graph"));
            MainScreenPanel.this.lGraph = new JLabel("Time = " + RichardsEqn.formatTime(MainScreenPanel.this.old_t) + " " + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit]);
            MainScreenPanel.this.lGraph.setForeground(Color.red);
            MainScreenPanel.this.lGraph.setBounds(295, 30, 140, 22);
            this.add(lMessage1);
            this.add(MainScreenPanel.this.choiceGraph);
            this.add(MainScreenPanel.this.lGraph);
        }
    }
}

