/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class MeshSize
extends JPanel {
    private RichardsEqnSolver experiment;
    public double dz;
    public double dt;
    public double convergenceCriteria;
    public double maxAbsError;
    public double maxRelaError;
    public double criticalCumuFlux;
    public boolean changed;
    private JLabel lDeltaZ;
    private JLabel lDeltaT;
    private JLabel lConvergenceCriteria;
    private JLabel lMassBalanceErrors;
    private JLabel lMaxAbsError;
    private JLabel lMaxRelaError;
    private JLabel lCriticalCumuFlux;
    private JTextField tfDeltaZ;
    private JTextField tfDeltaT;
    private JTextField tfConvergenceCriteria;
    private JTextField tfMaxAbsError;
    private JTextField tfMaxRelaError;
    private JTextField tfCriticalCumuFlux;
    private JScrollBar sbrDeltaZ;
    private JScrollBar sbrDeltaT;
    private JScrollBar sbrConvergenceCriteria;
    private JScrollBar sbrMaxAbsError;
    private JScrollBar sbrMaxRelaError;
    private JScrollBar sbrCriticalCumuFlux;
    public boolean errorFree = true;
    Font fDialog = new Font("Serif", 1, 14);
    int labelWidth = 245;
    int textfieldWidth = 75;
    int scrollbarWidth = 75;
    int xOffset = 0;
    int yOffset = 0;
    int yCellSize = 20;
    int yInterv = 3;
    int yExtraInterv = 5;
    int nDigits;

    public MeshSize(RichardsEqnSolver richardsEqnSolver) {
        this.experiment = richardsEqnSolver;
        this.dz = this.experiment.dz;
        this.dt = this.experiment.dt;
        this.changed = false;
        this.convergenceCriteria = this.experiment.convergenceCriteria;
        this.maxAbsError = this.experiment.maxAbsError;
        this.maxRelaError = this.experiment.maxRelaError;
        this.criticalCumuFlux = this.experiment.criticalCumuFlux;
        this.nDigits = (int)(-Math.log(this.convergenceCriteria) / Math.log(10.0) + 0.5);
        this.setFont(this.fDialog);
        this.setLayout(null);
        this.lDeltaZ = new JLabel("Mesh Size in Distance (cm)");
        this.lDeltaZ.setBounds(this.xOffset, this.yOffset, this.labelWidth, this.yCellSize);
        this.lDeltaZ.setForeground(Color.black);
        this.lDeltaZ.setFont(this.fDialog);
        this.add(this.lDeltaZ);
        this.lDeltaT = new JLabel("Mesh Size in Time (hr)");
        this.lDeltaT.setBounds(this.xOffset, this.yOffset + this.yCellSize + this.yInterv, this.labelWidth, this.yCellSize);
        this.lDeltaT.setForeground(Color.black);
        this.lDeltaT.setFont(this.fDialog);
        this.add(this.lDeltaT);
        this.lConvergenceCriteria = new JLabel("Convergence Criteria");
        this.lConvergenceCriteria.setBounds(this.xOffset, this.yOffset + 2 * (this.yCellSize + this.yInterv), this.labelWidth, this.yCellSize);
        this.lConvergenceCriteria.setForeground(Color.black);
        this.lConvergenceCriteria.setFont(this.fDialog);
        this.add(this.lConvergenceCriteria);
        this.lMassBalanceErrors = new JLabel("Mass Balance Errors:");
        this.lMassBalanceErrors.setBounds(this.xOffset, this.yExtraInterv + this.yOffset + 3 * (this.yCellSize + this.yInterv), this.labelWidth, this.yCellSize);
        this.lMassBalanceErrors.setForeground(Color.black);
        this.lMassBalanceErrors.setFont(this.fDialog);
        this.add(this.lMassBalanceErrors);
        this.lMaxAbsError = new JLabel("Maximum Absolute Error (cm)");
        this.lMaxAbsError.setBounds(this.xOffset + 20, this.yExtraInterv + this.yOffset + 4 * (this.yCellSize + this.yInterv), this.labelWidth, this.yCellSize);
        this.lMaxAbsError.setForeground(Color.black);
        this.lMaxAbsError.setFont(this.fDialog);
        this.add(this.lMaxAbsError);
        this.lMaxRelaError = new JLabel("Maximum Relative Error (%)");
        this.lMaxRelaError.setBounds(this.xOffset + 20, this.yExtraInterv + this.yOffset + 5 * (this.yCellSize + this.yInterv), this.labelWidth, this.yCellSize);
        this.lMaxRelaError.setForeground(Color.black);
        this.lMaxRelaError.setFont(this.fDialog);
        this.add(this.lMaxRelaError);
        this.lCriticalCumuFlux = new JLabel("Critical Cumulative Flux (cm)");
        this.lCriticalCumuFlux.setBounds(this.xOffset + 20, this.yExtraInterv + this.yOffset + 6 * (this.yCellSize + this.yInterv), this.labelWidth, this.yCellSize);
        this.lCriticalCumuFlux.setForeground(Color.black);
        this.lCriticalCumuFlux.setFont(this.fDialog);
        this.add(this.lCriticalCumuFlux);
        this.xOffset += 50 + this.labelWidth;
        this.tfDeltaZ = new JTextField(Tools.formatDouble(this.dz, 3, 3));
        this.tfDeltaZ.setBounds(this.xOffset, this.yOffset, this.textfieldWidth, this.yCellSize);
        this.add(this.tfDeltaZ);
        this.tfDeltaT = new JTextField(Tools.formatDouble(this.dt, 5, 5));
        this.tfDeltaT.setBounds(this.xOffset, this.yOffset + this.yCellSize + this.yInterv, this.textfieldWidth, this.yCellSize);
        this.add(this.tfDeltaT);
        this.tfConvergenceCriteria = new JTextField(Tools.formatDouble(this.convergenceCriteria, 8, 8));
        this.tfConvergenceCriteria.setBounds(this.xOffset, this.yOffset + 2 * (this.yCellSize + this.yInterv), this.textfieldWidth, this.yCellSize);
        this.add(this.tfConvergenceCriteria);
        this.tfMaxAbsError = new JTextField(Tools.formatDouble(this.maxAbsError, 3, 3));
        this.tfMaxAbsError.setBounds(this.xOffset, this.yExtraInterv + this.yOffset + 4 * (this.yCellSize + this.yInterv), this.textfieldWidth, this.yCellSize);
        this.add(this.tfMaxAbsError);
        this.tfMaxRelaError = new JTextField(Tools.formatDouble(this.maxRelaError, 3, 3));
        this.tfMaxRelaError.setBounds(this.xOffset, this.yExtraInterv + this.yOffset + 5 * (this.yCellSize + this.yInterv), this.textfieldWidth, this.yCellSize);
        this.add(this.tfMaxRelaError);
        this.tfCriticalCumuFlux = new JTextField(Tools.formatDouble(this.criticalCumuFlux, 3, 3));
        this.tfCriticalCumuFlux.setBounds(this.xOffset, this.yExtraInterv + this.yOffset + 6 * (this.yCellSize + this.yInterv), this.textfieldWidth, this.yCellSize);
        this.add(this.tfCriticalCumuFlux);
        this.xOffset += this.textfieldWidth;
        this.sbrDeltaZ = new JScrollBar(0, (int)(this.dz * 100.0), 0, 1, 500);
        this.sbrDeltaZ.setBounds(this.xOffset, this.yOffset, this.scrollbarWidth, this.yCellSize);
        this.add(this.sbrDeltaZ);
        this.sbrDeltaT = new JScrollBar(0, (int)(this.dt * 10000.0), 0, 1, 10000);
        this.sbrDeltaT.setBounds(this.xOffset, this.yOffset + this.yCellSize + this.yInterv, this.scrollbarWidth, this.yCellSize);
        this.add(this.sbrDeltaT);
        this.sbrConvergenceCriteria = new JScrollBar(0, this.nDigits, 1, 1, 9);
        this.sbrConvergenceCriteria.setBounds(this.xOffset, this.yOffset + 2 * (this.yCellSize + this.yInterv), this.scrollbarWidth, this.yCellSize);
        this.add(this.sbrConvergenceCriteria);
        this.sbrMaxAbsError = new JScrollBar(0, (int)(this.maxAbsError * 100.0), 0, 1, 100);
        this.sbrMaxAbsError.setBounds(this.xOffset, this.yExtraInterv + this.yOffset + 4 * (this.yCellSize + this.yInterv), this.scrollbarWidth, this.yCellSize);
        this.add(this.sbrMaxAbsError);
        this.sbrMaxRelaError = new JScrollBar(0, (int)(this.maxRelaError * 10.0), 0, 1, 100);
        this.sbrMaxRelaError.setBounds(this.xOffset, this.yExtraInterv + this.yOffset + 5 * (this.yCellSize + this.yInterv), this.scrollbarWidth, this.yCellSize);
        this.add(this.sbrMaxRelaError);
        this.sbrCriticalCumuFlux = new JScrollBar(0, (int)(this.criticalCumuFlux * 5.0 + 1.0), 0, 1, 501);
        this.sbrCriticalCumuFlux.setBounds(this.xOffset, this.yExtraInterv + this.yOffset + 6 * (this.yCellSize + this.yInterv), this.scrollbarWidth, this.yCellSize);
        this.add(this.sbrCriticalCumuFlux);
        this.tfDeltaZ.addActionListener(new forEvent("dz"));
        this.tfDeltaT.addActionListener(new forEvent("dt"));
        this.tfConvergenceCriteria.addActionListener(new forEvent("convergence"));
        this.tfMaxAbsError.addActionListener(new forEvent("MaxAbsError"));
        this.tfMaxRelaError.addActionListener(new forEvent("MaxRelaError"));
        this.tfCriticalCumuFlux.addActionListener(new forEvent("CriticalCumuFlux"));
        this.sbrDeltaZ.addAdjustmentListener(new forEvent("dz"));
        this.sbrDeltaT.addAdjustmentListener(new forEvent("dt"));
        this.sbrConvergenceCriteria.addAdjustmentListener(new forEvent("convergence"));
        this.sbrMaxAbsError.addAdjustmentListener(new forEvent("MaxAbsError"));
        this.sbrMaxRelaError.addAdjustmentListener(new forEvent("MaxRelaError"));
        this.sbrCriticalCumuFlux.addAdjustmentListener(new forEvent("CriticalCumuFlux"));
        this.tfDeltaZ.addMouseListener(new forEvent("dz"));
        this.tfDeltaT.addMouseListener(new forEvent("dt"));
        this.tfConvergenceCriteria.addMouseListener(new forEvent("convergence"));
        this.tfMaxAbsError.addMouseListener(new forEvent("MaxAbsError"));
        this.tfMaxRelaError.addMouseListener(new forEvent("MaxRelaError"));
        this.tfCriticalCumuFlux.addMouseListener(new forEvent("CriticalCumuFlux"));
        JPanel jPanel = new JPanel(){

            public void paintComponent(Graphics graphics) {
                graphics.setFont(RichardsEqn.noteFont);
                graphics.drawString("1. The mesh size in distance may be modified by the software to assure that", 15, 40);
                graphics.drawString("    at least 10 meshpoints exist in each soil layer and that no", 15, 55);
                graphics.drawString("    more than 501 mesh points are used in the entire soil system.", 15, 70);
                graphics.drawString("2. The mesh size in time may be reduced by the software to meet the specified", 15, 100);
                graphics.drawString("    convergence criterion or to provide output at the time of interest.", 15, 115);
                graphics.drawString("3. The difference between the net amount of water entering the soil and the", 15, 145);
                graphics.drawString("    increase in amount of water stored in the soil represents the absolute ", 15, 160);
                graphics.drawString("    mass balance error.  This difference divided by the amount of water ", 15, 175);
                graphics.drawString("    entering the soil represents the relative mass balance error.  If the ", 15, 190);
                graphics.drawString("    absolute value of this error exceeds the maximum value specified above, ", 15, 205);
                graphics.drawString("    a warning message appears to inform the user.  Absolute errors are used ", 15, 220);
                graphics.drawString("    when the absolute value of the net cumulative flux is less than the critical ", 15, 235);
                graphics.drawString("    cumulative flux specified above.  Relative errors are used in other cases.", 15, 250);
            }
        };
        jPanel.setPreferredSize(new Dimension(450, 265));
        jPanel.setBackground(new Color(204, 204, 204));
        jPanel.setBorder(new TitledBorder(new EtchedBorder(), "Notes:", 1, 0, new Font("Serif", 1, 14), Color.black));
        jPanel.setBounds(0, 2 * this.yExtraInterv + this.yOffset + 7 * (this.yCellSize + this.yInterv), 450, 265);
        this.add(jPanel);
        this.addMouseListener(new forEvent(" "));
    }

    public void performed() {
        JTextField jTextField = null;
        String string = " ";
        try {
            String string2 = this.tfDeltaZ.getText();
            jTextField = this.tfDeltaZ;
            string = "Invalid mesh size value";
            this.dz = new Double(string2);
            if (this.dz <= 0.0) {
                throw new IllegalValueException("The mesh size in distance must be greater than zero.");
            }
            if (RichardsEqn.experiment.dz != this.dz) {
                this.sbrDeltaZ.setValue((int)(100.0 * this.dz + 0.5));
                this.dz = new Double(string2);
                this.tfDeltaZ.setText(string2);
                this.changed = true;
            }
            string2 = this.tfDeltaT.getText();
            jTextField = this.tfDeltaT;
            string = "Invalid mesh size in time value";
            this.dt = new Double(string2);
            if (this.dt <= 0.0) {
                throw new IllegalValueException("The mesh size in time must be greater than zero.");
            }
            if (RichardsEqn.experiment.dt != this.dt) {
                this.sbrDeltaT.setValue((int)(10000.0 * this.dt + 0.5));
                this.dt = new Double(string2);
                this.tfDeltaT.setText(string2);
                this.changed = true;
            }
            string2 = this.tfConvergenceCriteria.getText();
            jTextField = this.tfConvergenceCriteria;
            string = "Invalid convergence criteria value";
            this.convergenceCriteria = new Double(string2);
            if (this.convergenceCriteria <= 0.0) {
                throw new IllegalValueException("The convergence criteria must be greater than zero.");
            }
            this.nDigits = (int)(-Math.log(this.convergenceCriteria) / Math.log(10.0) + 0.5);
            if (RichardsEqn.experiment.convergenceCriteria != this.convergenceCriteria) {
                this.sbrConvergenceCriteria.setValue(this.nDigits);
                this.convergenceCriteria = new Double(string2);
                this.tfConvergenceCriteria.setText(string2);
                this.changed = true;
            }
            string2 = this.tfMaxAbsError.getText();
            jTextField = this.tfMaxAbsError;
            string = "Invalid maximum absolute error";
            this.maxAbsError = new Double(string2);
            if (this.maxAbsError <= 0.0) {
                throw new IllegalValueException("The maximum absolute error must be greater than zero.");
            }
            if (RichardsEqn.experiment.maxAbsError != this.maxAbsError) {
                this.sbrMaxAbsError.setValue((int)(100.0 * this.maxAbsError));
                this.maxAbsError = new Double(string2);
                this.tfMaxAbsError.setText(string2);
                this.changed = true;
            }
            string2 = this.tfMaxRelaError.getText();
            jTextField = this.tfMaxRelaError;
            string = "Invalid maximum relative error";
            this.maxRelaError = new Double(string2);
            if (this.maxRelaError <= 0.0) {
                throw new IllegalValueException("The maximum relative error must be greater than zero.");
            }
            if (RichardsEqn.experiment.maxRelaError != this.maxRelaError) {
                this.sbrMaxRelaError.setValue((int)(10.0 * this.maxRelaError));
                this.maxRelaError = new Double(string2);
                this.tfMaxRelaError.setText(string2);
                this.changed = true;
            }
            string2 = this.tfCriticalCumuFlux.getText();
            jTextField = this.tfCriticalCumuFlux;
            string = "Invalid critical cumulative flux";
            this.criticalCumuFlux = new Double(string2);
            if (this.criticalCumuFlux < 0.0) {
                throw new IllegalValueException("The critical cumulative flux must be greater than zero.");
            }
            if (RichardsEqn.experiment.criticalCumuFlux != this.criticalCumuFlux) {
                this.sbrCriticalCumuFlux.setValue((int)(5.0 * this.criticalCumuFlux + 1.0));
                this.criticalCumuFlux = new Double(string2);
                this.tfCriticalCumuFlux.setText(string2);
                this.changed = true;
            }
            this.errorFree = true;
        }
        catch (Exception exception) {
            RichardsEqn.errorMessage = exception instanceof IllegalValueException ? exception.getMessage() : string;
            this.errorFree = false;
            jTextField.grabFocus();
        }
    }

    public void getMeshData() {
        this.performed();
        if (this.errorFree) {
            if (RichardsEqn.dz != this.dz || RichardsEqn.dt != this.dt || RichardsEqn.converg != this.convergenceCriteria || RichardsEqn.maxAbsError != this.maxAbsError || RichardsEqn.maxRelaError != this.maxRelaError || RichardsEqn.criticalCumuFlux != this.criticalCumuFlux) {
                RichardsEqn.restart = true;
            }
            RichardsEqn.experiment.dz = this.dz;
            RichardsEqn.experiment.dt = this.dt;
            RichardsEqn.experiment.convergenceCriteria = this.convergenceCriteria;
            RichardsEqn.experiment.maxAbsError = this.maxAbsError;
            RichardsEqn.experiment.maxRelaError = this.maxRelaError;
            RichardsEqn.experiment.criticalCumuFlux = this.criticalCumuFlux;
            RichardsEqn.dz = this.dz;
            RichardsEqn.dt = this.dt;
            RichardsEqn.converg = this.convergenceCriteria;
            RichardsEqn.maxAbsError = this.maxAbsError;
            RichardsEqn.maxRelaError = this.maxRelaError;
            RichardsEqn.criticalCumuFlux = this.criticalCumuFlux;
        }
    }

    class forEvent
    extends MouseAdapter
    implements AdjustmentListener,
    ActionListener,
    ItemListener {
        String name;
        int iTemp;

        public forEvent() {
        }

        public forEvent(String string) {
            this.name = string;
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            if (this.name.equals("dz")) {
                this.iTemp = MeshSize.this.sbrDeltaZ.getValue();
                MeshSize.this.dz = (double)this.iTemp / 100.0;
                MeshSize.this.tfDeltaZ.setText(Tools.formatDouble(MeshSize.this.dz, 3, 3));
                MeshSize.this.changed = true;
            }
            if (this.name.equals("dt")) {
                this.iTemp = MeshSize.this.sbrDeltaT.getValue();
                MeshSize.this.dt = (double)this.iTemp / 10000.0;
                MeshSize.this.tfDeltaT.setText(Tools.formatDouble(MeshSize.this.dt, 5, 5));
                MeshSize.this.changed = true;
            }
            if (this.name.equals("convergence")) {
                MeshSize.this.nDigits = MeshSize.this.sbrConvergenceCriteria.getValue();
                MeshSize.this.convergenceCriteria = Math.pow(10.0, -1.0 * (double)MeshSize.this.nDigits);
                MeshSize.this.tfConvergenceCriteria.setText(Tools.formatDouble(MeshSize.this.convergenceCriteria, 8, 8));
                MeshSize.this.changed = true;
            }
            if (this.name.equals("MaxAbsError")) {
                this.iTemp = MeshSize.this.sbrMaxAbsError.getValue();
                MeshSize.this.maxAbsError = (double)this.iTemp / 100.0;
                MeshSize.this.tfMaxAbsError.setText(Tools.formatDouble(MeshSize.this.maxAbsError, 3, 3));
                MeshSize.this.changed = true;
            }
            if (this.name.equals("MaxRelaError")) {
                this.iTemp = MeshSize.this.sbrMaxRelaError.getValue();
                MeshSize.this.maxRelaError = (double)this.iTemp / 10.0;
                MeshSize.this.tfMaxRelaError.setText(Tools.formatDouble(MeshSize.this.maxRelaError, 3, 3));
                MeshSize.this.changed = true;
            }
            if (this.name.equals("CriticalCumuFlux")) {
                this.iTemp = MeshSize.this.sbrCriticalCumuFlux.getValue();
                MeshSize.this.criticalCumuFlux = (double)(this.iTemp - 1) / 5.0;
                MeshSize.this.tfCriticalCumuFlux.setText(Tools.formatDouble(MeshSize.this.criticalCumuFlux, 3, 3));
                MeshSize.this.changed = true;
            }
            MeshSize.this.performed();
            if (!MeshSize.this.errorFree) {
                new ErrorMessageDialog("Error", RichardsEqn.errorMessage);
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MeshSize.this.performed();
            if (!MeshSize.this.errorFree) {
                JOptionPane.showMessageDialog(new JPanel(), RichardsEqn.errorMessage, "Error", 0);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            block3: {
                JTextField jTextField;
                if (!(mouseEvent.getSource() instanceof JTextField) || (jTextField = (JTextField)mouseEvent.getSource()).getText() == null || jTextField.getText().trim().length() == 0) break block3;
                try {
                    Double.parseDouble(jTextField.getText());
                    MeshSize.this.performed();
                    if (!MeshSize.this.errorFree) {
                        JOptionPane.showMessageDialog(new JPanel(), RichardsEqn.errorMessage, "Error", 0);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    jTextField.grabFocus();
                }
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            MeshSize.this.performed();
        }
    }
}

