/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Vector;
import javax.swing.JPanel;

public class MeshSizePanel
extends ChemfloPanel {
    public MeshSize mshsP;
    private JPanel topPane;
    private int wid = 0;
    private int hgh = 0;
    private JPanel northP;
    private JPanel southP;
    private JPanel westP;
    private JPanel eastP;

    public MeshSizePanel() {
        super("Define Mesh Sizes");
        this.setLayout(this.border);
        this.setBorder(this.edge);
        this.add((Component)this.titleP, "North");
        if (CHEMFLO.wMax) {
            this.wid = CHEMFLO.old_width - 250;
            this.hgh = CHEMFLO.old_height - 140;
        } else {
            this.wid = 550;
            this.hgh = 480;
        }
        this.topPane = new JPanel();
        this.topPane.setLayout(new BorderLayout());
        this.topPane.setPreferredSize(new Dimension(this.wid, this.hgh));
        this.northP = new JPanel();
        this.northP.setPreferredSize(new Dimension(this.wid, 3));
        this.southP = new JPanel();
        this.southP.setPreferredSize(new Dimension(this.wid, 1));
        this.westP = new JPanel();
        this.westP.setPreferredSize(new Dimension(50, 460));
        this.eastP = new JPanel();
        this.eastP.setPreferredSize(new Dimension(50, 460));
        this.mshsP = new MeshSize(RichardsEqn.experiment);
        this.mshsP.setPreferredSize(new Dimension(550, 470));
        this.topPane.add((Component)this.northP, "North");
        this.topPane.add((Component)this.westP, "West");
        this.topPane.add((Component)this.mshsP, "Center");
        this.topPane.add((Component)this.eastP, "East");
        this.topPane.add((Component)this.southP, "South");
        this.add((Component)this.topPane, "Center");
    }

    public void updateSize() {
        int n = 0;
        if (CHEMFLO.wMax) {
            this.wid = CHEMFLO.old_width - 250;
            this.hgh = CHEMFLO.old_height - 140;
        } else {
            this.wid = 550;
            this.hgh = 490;
        }
        if (this.topPane.getComponentCount() != 0) {
            this.topPane.removeAll();
        }
        this.topPane.setPreferredSize(new Dimension(this.wid, this.hgh));
        n = (int)((double)(this.hgh - 485) / 2.0);
        this.northP.setPreferredSize(new Dimension(this.wid, n));
        this.southP.setPreferredSize(new Dimension(this.wid, n));
        int n2 = (int)((double)(this.wid - 450) / 2.0);
        this.westP.setPreferredSize(new Dimension(n2, 460));
        this.eastP.setPreferredSize(new Dimension(n2, 460));
        this.topPane.add((Component)this.northP, "North");
        this.topPane.add((Component)this.westP, "West");
        this.topPane.add((Component)this.mshsP, "Center");
        this.topPane.add((Component)this.eastP, "East");
        this.topPane.add((Component)this.southP, "South");
        this.topPane.repaint();
    }

    public Vector getMeshSizeData() {
        Vector<String> vector = new Vector<String>();
        vector.addElement("Mesh Size/Convergence:");
        vector.addElement(new String("Mesh size in time:            " + RichardsEqn.dt + " hr"));
        vector.addElement(new String("Mesh size in length:          " + RichardsEqn.dz + " cm"));
        vector.addElement(new String("Convergence criteria:         " + RichardsEqn.converg));
        vector.addElement(new String("Maximum Absolute Error:       " + RichardsEqn.maxAbsError + " cm"));
        vector.addElement(new String("Maximum Relative Error:       " + RichardsEqn.maxRelaError + "%"));
        vector.addElement(new String("Critical Cumulative Flux:     " + RichardsEqn.criticalCumuFlux + " cm"));
        return vector;
    }
}

