/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class OutputTablePanel
extends JPanel
implements Printable {
    private int row;
    private int col;
    private Object[][] Data;
    protected int m_maxNumPage = 1;
    private JTable table;
    private OutputTableTestModel model;
    private TableColumn tbc;
    private TableColumnModel tbcm;
    private final Font ftBorder = new Font("Serif", 1, 14);
    private MouseListener popupListener;
    private String[] colNames;
    private final int deftWidth = 500;
    private final int deftHeight = 800;

    public OutputTablePanel(Object[][] objectArray, String[] stringArray, int n) {
        int n2;
        this.setSize(500, 800);
        this.setLayout(new BorderLayout());
        if (n == 1) {
            if (stringArray.length > 6) {
                this.colNames = new String[6];
                n2 = 0;
                while (n2 < 6) {
                    this.colNames[n2] = "";
                    ++n2;
                }
            } else {
                this.colNames = new String[stringArray.length];
                n2 = 0;
                while (n2 < stringArray.length) {
                    this.colNames[n2] = "";
                    ++n2;
                }
            }
        } else if (stringArray.length > 8) {
            this.colNames = new String[8];
            n2 = 0;
            while (n2 < 8) {
                this.colNames[n2] = "";
                ++n2;
            }
        } else {
            this.colNames = new String[stringArray.length];
            n2 = 0;
            while (n2 < stringArray.length) {
                this.colNames[n2] = "";
                ++n2;
            }
        }
        this.model = new OutputTableTestModel(objectArray, this.colNames);
        this.table = new JTable();
        this.table.setFont(new Font("Serif", 0, 12));
        this.table.setAutoCreateColumnsFromModel(false);
        this.table.setModel(this.model);
        n2 = 0;
        n2 = n == 1 ? 75 : 80;
        int n3 = 0;
        while (n3 < this.colNames.length) {
            DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
            defaultTableCellRenderer.setHorizontalAlignment(2);
            TableColumn tableColumn = new TableColumn(n3, n2, defaultTableCellRenderer, null);
            this.table.addColumn(tableColumn);
            ++n3;
        }
        this.add((Component)this.table, "Center");
    }

    public void printData(int n) {
        PageFormat pageFormat = null;
        CHEMFLO.setPrinter();
        if (CHEMFLO.printService == null && CHEMFLO.printerJob == null) {
            JOptionPane.showMessageDialog(CHEMFLO.appWin, "Failed to obtain printer service.", "Error", 2);
            return;
        }
        if (CHEMFLO.printService == null) {
            pageFormat = CHEMFLO.printerJob.defaultPage();
            pageFormat.setOrientation(n);
            pageFormat = CHEMFLO.printerJob.pageDialog(pageFormat);
        } else {
            pageFormat = CHEMFLO.printService.getDefaultPage();
            pageFormat.setOrientation(n);
            pageFormat = CHEMFLO.printService.showPageFormatDialog(pageFormat);
        }
        this.m_maxNumPage = 1;
        if (CHEMFLO.printService == null) {
            CHEMFLO.printerJob.setPrintable(this, pageFormat);
            if (CHEMFLO.printerJob.printDialog()) {
                try {
                    CHEMFLO.printerJob.print();
                }
                catch (PrinterException printerException) {
                    JOptionPane.showMessageDialog(CHEMFLO.appWin, "Could not print.", "Error", 2);
                    return;
                }
            }
        } else {
            try {
                CHEMFLO.printService.print(this);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(CHEMFLO.appWin, "Could not print.", "Error", 2);
                return;
            }
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        int n2;
        if (n >= this.m_maxNumPage) {
            return 1;
        }
        graphics.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
        int n3 = 0;
        int n4 = 0;
        if (pageFormat.getOrientation() == 1) {
            n3 = (int)pageFormat.getImageableWidth();
            n4 = (int)(pageFormat.getImageableHeight() + pageFormat.getImageableHeight() / 2.0);
            graphics.setClip(0, 0, n3, n4);
        } else {
            n3 = (int)pageFormat.getImageableWidth();
            n3 += n3 / 2;
            n4 = (int)(pageFormat.getImageableHeight() + pageFormat.getImageableHeight() / 2.0);
            graphics.setClip(0, 0, n3, n4);
        }
        int n5 = 0;
        graphics.setColor(Color.black);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Font font = this.table.getFont().deriveFont(1);
        graphics.setFont(font);
        fontMetrics = graphics.getFontMetrics();
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        int n6 = tableColumnModel.getColumnCount();
        int[] nArray = new int[n6];
        nArray[0] = 0;
        int n7 = fontMetrics.getHeight();
        n5 += n7;
        int n8 = 0;
        while (n8 < n6) {
            TableColumn tableColumn = tableColumnModel.getColumn(n8);
            n2 = tableColumn.getWidth();
            if (nArray[n8] + n2 > n3) {
                n6 = n8;
                break;
            }
            if (n8 + 1 < n6) {
                nArray[n8 + 1] = nArray[n8] + n2;
            }
            String string = (String)tableColumn.getIdentifier();
            graphics.drawString(string, nArray[n8], n5);
            ++n8;
        }
        graphics.setFont(this.table.getFont());
        fontMetrics = graphics.getFontMetrics();
        int n9 = n5;
        n7 = fontMetrics.getHeight();
        n2 = Math.max((int)((double)n7 * 1.5), 10);
        int n10 = (n4 - n9) / n2;
        this.m_maxNumPage = Math.max((int)Math.ceil((double)this.table.getRowCount() / (double)n10), 1);
        TableModel tableModel = this.table.getModel();
        int n11 = n * n10;
        int n12 = Math.min(this.table.getRowCount(), n11 + n10);
        int n13 = n11;
        while (n13 < n12) {
            n5 += n7;
            n8 = 0;
            while (n8 < n6) {
                Object object = this.model.getValueAt(n13, n8);
                String string = object.toString();
                graphics.setColor(Color.black);
                graphics.drawString(string, nArray[n8], n5);
                ++n8;
            }
            ++n13;
        }
        System.gc();
        return 0;
    }
}

