/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class PositionInterestTable
extends JPanel {
    private int row;
    private int col;
    protected JLabel m_title;
    protected JLabel m_fdName;
    static Object[][] data = null;
    private Object[][] Data;
    private JPanel topPane;
    protected int m_maxNumPage = 1;
    public TableTestModel model;
    public JTable table;
    private JTableHeader jth;
    private TableColumn tbc;
    private TableColumnModel tbcm;
    private int exp_idx;
    final Font ftBorder = new Font("Serif", 1, 14);
    MouseListener popupListener;
    String[] colNames = new String[]{"Positions of Interest (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + ")"};
    final int deftWidth = 200;
    final int deftHeight = 190;
    public boolean dupError;
    public boolean emptyTable;
    private boolean hasEr;

    public PositionInterestTable() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.m_title = new JLabel("Initial Conditions of Soil System");
        this.m_title.setFont(new Font("Siref", 1, 20));
        this.topPane = new JPanel();
        this.topPane.setLayout(new BorderLayout());
        this.topPane.setPreferredSize(new Dimension(200, 190));
        this.topPane.setBorder(BorderFactory.createEtchedBorder(0));
        this.row = 20;
        this.col = this.colNames.length;
        this.Data = data != null ? (data.length > this.row ? new Object[data.length][this.col] : new Object[this.row][this.col]) : new Object[this.row][this.col];
        this.getData();
        this.table = new JTable();
        this.model = new TableTestModel(this.Data, this.colNames, this.table);
        this.table.setFont(new Font("Serif", 0, 12));
        this.table.setAutoCreateColumnsFromModel(false);
        this.table.setModel(this.model);
        this.table.setGridColor(Color.gray);
        int n = 200 / this.colNames.length;
        int n2 = 0;
        while (n2 < this.colNames.length) {
            DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
            defaultTableCellRenderer.setHorizontalAlignment(2);
            TableColumn tableColumn = new TableColumn(n2, n, defaultTableCellRenderer, null);
            this.table.addColumn(tableColumn);
            ++n2;
        }
        this.setUpTableCellEditor(this.table);
        this.jth = this.table.getTableHeader();
        this.jth.setFont(RichardsEqn.tableHeaderFont);
        this.jth.setToolTipText("Double click column header to add a new row");
        this.table.setSelectionMode(0);
        this.table.setRowSelectionAllowed(false);
        this.topPane.add((Component)new JScrollPane(this.table), "Center");
        this.jth.addMouseListener(new MouseEventListener("TableHead"));
        this.setLayout(new BorderLayout());
        this.add((Component)this.topPane, "Center");
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.revalidate();
    }

    private void setUpTableCellEditor(JTable jTable) {
        final InputNumberField inputNumberField = new InputNumberField("", 25);
        inputNumberField.setHorizontalAlignment(2);
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(inputNumberField){

            public Object getCellEditorValue() {
                return String.valueOf(inputNumberField.getValue());
            }
        };
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        tableColumnModel.getColumn(0).setCellEditor(defaultCellEditor);
    }

    protected void getData() {
        if (data != null) {
            int n = 0;
            while (n < this.Data.length) {
                int n2 = 0;
                while (n2 < this.col) {
                    this.Data[n][n2] = n < data.length ? data[n][n2] : "";
                    ++n2;
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.Data.length) {
                int n3 = 0;
                while (n3 < this.col) {
                    this.Data[n][n3] = "";
                    ++n3;
                }
                ++n;
            }
        }
    }

    public void checkTableData() {
        if (this.hasEr) {
            return;
        }
        if (this.table.isEditing()) {
            int n = this.table.getSelectedColumn();
            int n2 = this.table.getSelectedRow();
            if (n >= 0 && n2 >= 0) {
                DefaultCellEditor defaultCellEditor = (DefaultCellEditor)this.table.getCellEditor(n2, n);
                Object object = defaultCellEditor.getCellEditorValue();
                if (object == null) {
                    this.hasEr = true;
                    JOptionPane.showMessageDialog(new JPanel(), "Please enter zero or positive number", "Invalid value", 0);
                    ((JTextField)this.table.getEditorComponent()).requestFocus();
                    this.hasEr = false;
                    return;
                }
                try {
                    double d = Double.parseDouble((String)object);
                    if (d < 0.0) {
                        this.hasEr = true;
                        JOptionPane.showMessageDialog(new JPanel(), "Please enter zero or positive number", "Invalid value", 0);
                        ((JTextField)this.table.getEditorComponent()).requestFocus();
                        this.hasEr = false;
                        return;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.hasEr = true;
                    JOptionPane.showMessageDialog(new JPanel(), "Please enter zero or positive number", "Invalid value", 0);
                    ((JTextField)this.table.getEditorComponent()).requestFocus();
                    this.hasEr = false;
                    return;
                }
                this.table.setValueAt(object, n2, n);
                this.table.getCellEditor().stopCellEditing();
                this.hasEr = false;
            }
        } else {
            int n = 0;
            while (n < this.Data.length) {
                try {
                    double d;
                    String string = (String)this.Data[n][0];
                    if (string.trim().length() != 0 && (d = Double.parseDouble(string)) < 0.0) {
                        this.hasEr = true;
                        JOptionPane.showMessageDialog(new JPanel(), "Please enter zero or positive number", "Invalid value", 0);
                        this.table.editCellAt(n, 0);
                        ((JTextField)this.table.getEditorComponent()).requestFocus();
                        this.hasEr = false;
                        return;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.hasEr = true;
                    JOptionPane.showMessageDialog(new JPanel(), "Please enter zero or positive number", "Invalid value", 0);
                    this.table.setEditingRow(n);
                    this.table.editCellAt(n, 0);
                    ((JTextField)this.table.getEditorComponent()).requestFocus();
                    this.hasEr = false;
                    return;
                }
                ++n;
            }
        }
    }

    public void prepareTableBeforeSorting() {
        int n = 0;
        int n2 = this.table.getRowCount();
        int n3 = this.table.getColumnCount();
        boolean[] blArray = new boolean[n2];
        int n4 = 0;
        while (n4 < n2) {
            if (((String)this.table.getValueAt(n4, 0)).equals("")) {
                blArray[n4] = false;
            } else {
                blArray[n4] = true;
                ++n;
            }
            ++n4;
        }
        data = new Object[n][n3];
        int n5 = 0;
        int n6 = 0;
        while (n6 < n2) {
            int n7 = 0;
            while (n7 < n3) {
                if (blArray[n6]) {
                    PositionInterestTable.data[n5][n7] = this.table.getValueAt(n6, n7);
                    if (n7 == n3 - 1) {
                        ++n5;
                    }
                }
                ++n7;
            }
            ++n6;
        }
    }

    public void restoreTableAfterSorting(Object[][] objectArray) {
        int n = objectArray.length;
        int n2 = objectArray[0].length;
        if (n >= this.row) {
            this.Data = new Object[n][n2];
            int n3 = 0;
            while (n3 < n) {
                int n4 = 0;
                while (n4 < n2) {
                    this.Data[n3][n4] = objectArray[n3][n4].toString();
                    ++n4;
                }
                ++n3;
            }
        } else {
            this.Data = new Object[this.row][n2];
            int n5 = 0;
            while (n5 < this.row) {
                int n6 = 0;
                while (n6 < n2) {
                    this.Data[n5][n6] = n5 < n ? objectArray[n5][n6].toString() : "";
                    ++n6;
                }
                ++n5;
            }
        }
        this.model = new TableTestModel(this.Data, this.colNames, this.table);
        this.model.setupMinAndMaxVal();
        this.table.setModel(this.model);
        if (Tools.isDuplicateValue(this.model.selectVal, this.model.numIdx)) {
            this.dupError = true;
            JOptionPane.showMessageDialog(new JPanel(), "Positions of Interest: Value Duplication.", "Error", 0);
        } else {
            this.dupError = false;
        }
    }

    void upDateDataSize() {
        int n = this.table.getRowCount();
        int n2 = this.table.getColumnCount();
        this.Data = new Object[n][n2];
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                this.Data[n3][n4] = this.table.getValueAt(n3, n4);
                ++n4;
            }
            ++n3;
        }
        this.model = new TableTestModel(this.Data, this.colNames, this.table);
        this.table.setModel(this.model);
    }

    public void clearTable() {
        data = null;
        this.Data = new Object[this.row][this.col];
        this.getData();
        this.model = new TableTestModel(this.Data, this.colNames, this.table);
        this.table.setModel(this.model);
        this.table.repaint();
    }

    public void sortingTable() {
        this.prepareTableBeforeSorting();
        if (data.length == 0) {
            JOptionPane.showMessageDialog(new JPanel(), "No positions of interest have been selected.", "Error", 0);
            this.emptyTable = true;
            return;
        }
        this.emptyTable = false;
        SortingTable sortingTable = new SortingTable(data, 0);
        data = sortingTable.SortTable2();
        this.restoreTableAfterSorting(data);
        this.table.repaint();
    }

    static /* synthetic */ JTableHeader access$100(PositionInterestTable positionInterestTable) {
        return positionInterestTable.jth;
    }

    class MouseEventListener
    extends MouseAdapter {
        String name = null;

        MouseEventListener(String string) {
            this.name = string;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (this.name.trim().equals("TableHead") && mouseEvent.getClickCount() > 1) {
                Thread thread = new Thread(this, mouseEvent){
                    private final /* synthetic */ MouseEvent val$evt;
                    private final /* synthetic */ MouseEventListener this$1;
                    {
                        this.this$1 = mouseEventListener;
                        this.val$evt = mouseEvent;
                    }

                    public void run() {
                        Object var1_1 = null;
                        int n = 0;
                        MouseEventListener.access$000(this.this$1).setCursor(Cursor.getPredefinedCursor(3));
                        n = PositionInterestTable.access$100(MouseEventListener.access$000(this.this$1)).columnAtPoint(new Point(this.val$evt.getX(), this.val$evt.getY()));
                        if (n >= 0 && n < 4) {
                            int n2 = JOptionPane.showOptionDialog(null, new JPanel(), "Add a New Row ?", 2, -1, null, null, null);
                            switch (n2) {
                                case -1: {
                                    MouseEventListener.access$000(this.this$1).setCursor(Cursor.getPredefinedCursor(0));
                                    break;
                                }
                                case 0: {
                                    AddRow addRow = new AddRow(MouseEventListener.access$000((MouseEventListener)this.this$1).table, MouseEventListener.access$000((MouseEventListener)this.this$1).colNames);
                                    MouseEventListener.access$000((MouseEventListener)this.this$1).table = addRow.addRow();
                                    MouseEventListener.access$000((MouseEventListener)this.this$1).table.repaint();
                                    MouseEventListener.access$000(this.this$1).upDateDataSize();
                                    MouseEventListener.access$000(this.this$1).setCursor(Cursor.getPredefinedCursor(0));
                                    break;
                                }
                                case 2: {
                                    MouseEventListener.access$000(this.this$1).setCursor(Cursor.getPredefinedCursor(0));
                                }
                            }
                        } else {
                            JOptionPane.showMessageDialog(new JPanel(), "Non-numeric value in the column", "Warning", 2);
                            MouseEventListener.access$000(this.this$1).setCursor(Cursor.getPredefinedCursor(0));
                        }
                    }
                };
                thread.start();
            }
        }

        static /* synthetic */ PositionInterestTable access$000(MouseEventListener mouseEventListener) {
            return mouseEventListener.PositionInterestTable.this;
        }
    }
}

