/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ProgressMonitor;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;

public class ReportTablePanel
extends ChemfloPanel {
    private JLabel title;
    private JLabel sub_title1;
    public JLabel sub_title2;
    private JCheckBox waterCnt;
    private JCheckBox matPot;
    private JCheckBox totalPot;
    private JCheckBox drivingForce;
    private JCheckBox hydConduct;
    private JCheckBox fluxDensity;
    private JCheckBox cumuFlux;
    public JCheckBox chemConSolution;
    public JCheckBox chemConAdsorbed;
    public JCheckBox chemConTotal;
    public JCheckBox chemFluxDensity;
    public JCheckBox chemCumuFlux;
    private ButtonGroup group;
    private JRadioButton allPosSelectTime;
    private JRadioButton allTimeSelectPos;
    public JRadioButton selectTimeSelectPos;
    private JButton clearBnt;
    private JButton outTabBnt;
    private Border oldBorder;
    private BevelBorder raisedEdge = new BevelBorder(0);
    private TimePositionTabelPanel tablePane;
    public TimeInterestTable timeTable;
    public PositionInterestTable posTable;
    private JPanel topPane;
    private CheckParaPanel chkPane;
    private JPanel buttonP;
    public String[] outNames;
    public Object[][] outData;
    public Object[][] dataOut;
    private boolean[] waterPara = new boolean[7];
    private boolean[] chemPara = new boolean[5];
    private boolean[] rpOption = new boolean[3];
    public int[] waterRpara;
    public int[] chemRpara;
    public int opidx;
    static Vector daVec = new Vector(100, 50);
    private double[] time = null;
    private int idx = 0;
    private double remain = 0.0;
    private double[] posData = null;
    private int wid = 0;
    private int hgh = 0;
    private JPanel rootPane;
    private JPanel northP;
    private JPanel southP;
    private JPanel westP;
    private JPanel eastP;

    public ReportTablePanel() {
        super("Reports/Tables");
        this.setLayout(this.border);
        this.setBorder(this.edge);
        this.add((Component)this.titleP, "North");
        if (CHEMFLO.wMax) {
            this.wid = CHEMFLO.old_width - 250;
            this.hgh = CHEMFLO.old_height - 140;
        } else {
            this.wid = 550;
            this.hgh = 470;
        }
        this.rootPane = new JPanel();
        this.rootPane.setLayout(new BorderLayout());
        this.rootPane.setPreferredSize(new Dimension(this.wid, this.hgh));
        this.northP = new JPanel();
        this.northP.setPreferredSize(new Dimension(this.wid, 1));
        this.southP = new JPanel();
        this.southP.setPreferredSize(new Dimension(this.wid, 1));
        this.westP = new JPanel();
        this.westP.setPreferredSize(new Dimension(1, 450));
        this.eastP = new JPanel();
        this.eastP.setPreferredSize(new Dimension(1, 450));
        this.topPane = new JPanel();
        this.topPane.setLayout(new BorderLayout());
        this.topPane.setPreferredSize(new Dimension(this.wid - 2, this.hgh - 2));
        this.chkPane = new CheckParaPanel();
        this.tablePane = new TimePositionTabelPanel();
        this.buttonP = new JPanel();
        this.buttonP.setPreferredSize(new Dimension(530, 30));
        this.buttonP.setLayout(null);
        this.clearBnt = new JButton("Clear");
        this.clearBnt.setBounds(120, 0, 120, 25);
        this.outTabBnt = new JButton("Output Table");
        this.outTabBnt.setBounds(310, 0, 120, 25);
        this.buttonP.add(this.clearBnt);
        this.buttonP.add(this.outTabBnt);
        this.oldBorder = this.clearBnt.getBorder();
        this.clearBnt.addActionListener(new forEvent("Clear"));
        this.outTabBnt.addActionListener(new forEvent("OutTable"));
        bntMouseListener bntMouseListener2 = new bntMouseListener();
        this.clearBnt.addMouseListener(bntMouseListener2);
        this.outTabBnt.addMouseListener(bntMouseListener2);
        this.topPane.add((Component)this.chkPane, "North");
        this.topPane.add((Component)this.tablePane, "Center");
        this.topPane.add((Component)this.buttonP, "South");
        this.rootPane.add((Component)this.northP, "North");
        this.rootPane.add((Component)this.westP, "West");
        this.rootPane.add((Component)this.topPane, "Center");
        this.rootPane.add((Component)this.eastP, "East");
        this.rootPane.add((Component)this.southP, "South");
        this.add((Component)this.rootPane, "Center");
        this.addMouseListener(new forEvent("ReportPanel"));
    }

    public void prepareTableNames() {
        int n = 0;
        String[] stringArray = new String[14];
        stringArray[n++] = new String("Time\n (" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ")");
        stringArray[n++] = new String("Position\n (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + ")");
        if (this.waterCnt.isSelected()) {
            stringArray[n++] = new String("Water\n Content");
        }
        if (this.matPot.isSelected()) {
            stringArray[n++] = new String("Matric\n Potential\n (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + ")");
        }
        if (this.totalPot.isSelected()) {
            stringArray[n++] = new String("Total\n Potential\n (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + ")");
        }
        if (this.drivingForce.isSelected()) {
            stringArray[n++] = new String("Driving\n Force");
        }
        if (this.hydConduct.isSelected()) {
            stringArray[n++] = new String("Hydraulic\n Conductivity\n (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ")");
        }
        if (this.fluxDensity.isSelected()) {
            stringArray[n++] = new String("Flux\n Density\n (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ")");
        }
        if (this.cumuFlux.isSelected()) {
            stringArray[n++] = new String("Cumulative\n Flux\n (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + ")");
        }
        if (RichardsEqn.selectedInitialCond2 != 0) {
            if (this.chemConSolution.isSelected()) {
                stringArray[n++] = new String("Concentration\n Solution\n (g/m3)");
            }
            if (this.chemConAdsorbed.isSelected()) {
                stringArray[n++] = new String("Concentration\n Adsorbed\n (g/m3)");
            }
            if (this.chemConTotal.isSelected()) {
                stringArray[n++] = new String("Concentration\n Total\n (g/m3)");
            }
            if (this.chemFluxDensity.isSelected()) {
                stringArray[n++] = new String("Flux\n Density\n (g/m2/hr)");
            }
            if (this.chemCumuFlux.isSelected()) {
                stringArray[n++] = new String("Cumulative\n Flux\n (g/m2)");
            }
        }
        this.outNames = new String[n];
        int n2 = 0;
        while (n2 < n) {
            this.outNames[n2] = new String(stringArray[n2]);
            ++n2;
        }
    }

    public void prepareTableData() {
        int n = this.timeTable.table.getRowCount();
        int n2 = this.posTable.table.getRowCount();
        Object[] objectArray = new Object[n];
        Object[] objectArray2 = new Object[n2];
        int n3 = 0;
        int n4 = 0;
        if (this.selectTimeSelectPos.isSelected()) {
            this.timeTable.sortingTable();
            this.posTable.sortingTable();
            int n5 = 0;
            while (n5 < n) {
                if (!((String)this.timeTable.table.getValueAt(n5, 0)).equals("")) {
                    objectArray[n3++] = this.timeTable.table.getValueAt(n5, 0);
                }
                ++n5;
            }
            int n6 = 0;
            while (n6 < n2) {
                if (!((String)this.posTable.table.getValueAt(n6, 0)).equals("")) {
                    objectArray2[n4++] = this.posTable.table.getValueAt(n6, 0);
                }
                ++n6;
            }
            this.outData = n3 >= n4 ? new Object[n3][2] : new Object[n4][2];
            this.updateTableData1(objectArray, n3, objectArray2, n4);
        } else {
            int n7;
            if (this.allPosSelectTime.isSelected()) {
                this.timeTable.sortingTable();
                n7 = 0;
                while (n7 < n) {
                    if (!((String)this.timeTable.table.getValueAt(n7, 0)).equals("")) {
                        objectArray[n3++] = this.timeTable.table.getValueAt(n7, 0);
                    }
                    ++n7;
                }
                this.outData = new Object[n3][1];
                this.updateTableData2(objectArray, n3);
            }
            if (this.allTimeSelectPos.isSelected()) {
                this.posTable.sortingTable();
                n7 = 0;
                while (n7 < n2) {
                    if (!((String)this.posTable.table.getValueAt(n7, 0)).equals("")) {
                        objectArray2[n4++] = this.posTable.table.getValueAt(n7, 0);
                    }
                    ++n7;
                }
                this.outData = new Object[n4][1];
                this.updateTableData3(objectArray2, n4);
            }
        }
    }

    void updateTableData1(Object[] objectArray, int n, Object[] objectArray2, int n2) {
        int n3 = 0;
        while (n3 < this.outData.length) {
            int n4 = 0;
            while (n4 < this.outData[0].length) {
                this.outData[n3][n4] = n4 == 0 && n3 < n ? objectArray[n3] : (n4 == 1 && n3 < n2 ? objectArray2[n3] : "-");
                ++n4;
            }
            ++n3;
        }
    }

    void updateTableData2(Object[] objectArray, int n) {
        int n2 = 0;
        while (n2 < this.outData.length) {
            int n3 = 0;
            while (n3 < this.outData[0].length) {
                this.outData[n2][n3] = n3 == 0 && n2 < n ? objectArray[n2] : "-";
                ++n3;
            }
            ++n2;
        }
    }

    void updateTableData3(Object[] objectArray, int n) {
        int n2 = 0;
        while (n2 < this.outData.length) {
            int n3 = 0;
            while (n3 < this.outData[0].length) {
                this.outData[n2][n3] = n3 == 1 && n2 < n ? objectArray[n2] : "-";
                ++n3;
            }
            ++n2;
        }
    }

    public void ResetUnits() {
        if (this.topPane.getComponentCount() != 0) {
            this.topPane.removeAll();
        }
        this.tablePane = new TimePositionTabelPanel();
        this.topPane.add((Component)this.chkPane, "North");
        this.topPane.add((Component)this.tablePane, "Center");
        this.topPane.add((Component)this.buttonP, "South");
        if (this.allPosSelectTime.isSelected()) {
            this.timeTable.setVisible(true);
            this.posTable.setVisible(false);
        }
        if (this.allTimeSelectPos.isSelected()) {
            this.timeTable.setVisible(false);
            this.posTable.setVisible(true);
        }
        if (this.selectTimeSelectPos.isSelected()) {
            this.timeTable.setVisible(true);
            this.posTable.setVisible(true);
        }
    }

    public void getSelectedParameterFlags() {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        if (this.waterCnt.isSelected()) {
            this.waterPara[0] = true;
            ++n3;
        } else {
            this.waterPara[0] = false;
        }
        if (this.matPot.isSelected()) {
            this.waterPara[1] = true;
            ++n3;
        } else {
            this.waterPara[1] = false;
        }
        if (this.totalPot.isSelected()) {
            this.waterPara[2] = true;
            ++n3;
        } else {
            this.waterPara[2] = false;
        }
        if (this.drivingForce.isSelected()) {
            this.waterPara[3] = true;
            ++n3;
        } else {
            this.waterPara[3] = false;
        }
        if (this.hydConduct.isSelected()) {
            this.waterPara[4] = true;
            ++n3;
        } else {
            this.waterPara[4] = false;
        }
        if (this.fluxDensity.isSelected()) {
            this.waterPara[5] = true;
            ++n3;
        } else {
            this.waterPara[5] = false;
        }
        if (this.cumuFlux.isSelected()) {
            this.waterPara[6] = true;
            ++n3;
        } else {
            this.waterPara[6] = false;
        }
        if (this.chemConSolution.isSelected()) {
            this.chemPara[0] = true;
            ++n4;
        } else {
            this.chemPara[0] = false;
        }
        if (this.chemConAdsorbed.isSelected()) {
            this.chemPara[1] = true;
            ++n4;
        } else {
            this.chemPara[1] = false;
        }
        if (this.chemConTotal.isSelected()) {
            this.chemPara[2] = true;
            ++n4;
        } else {
            this.chemPara[2] = false;
        }
        if (this.chemFluxDensity.isSelected()) {
            this.chemPara[3] = true;
            ++n4;
        } else {
            this.chemPara[3] = false;
        }
        if (this.chemCumuFlux.isSelected()) {
            this.chemPara[4] = true;
            ++n4;
        } else {
            this.chemPara[4] = false;
        }
        if (this.allPosSelectTime.isSelected()) {
            this.rpOption[0] = true;
            this.opidx = 0;
        } else {
            this.rpOption[0] = false;
        }
        if (this.allTimeSelectPos.isSelected()) {
            this.rpOption[1] = true;
            this.opidx = 1;
        } else {
            this.rpOption[1] = false;
        }
        if (this.selectTimeSelectPos.isSelected()) {
            this.rpOption[2] = true;
            this.opidx = 2;
        } else {
            this.rpOption[2] = false;
        }
        if (n3 > 0) {
            this.waterRpara = new int[n3];
            n2 = 0;
            n = 0;
            while (n < 7) {
                if (this.waterPara[n]) {
                    this.waterRpara[n2++] = n;
                }
                ++n;
            }
        } else {
            this.waterRpara = null;
        }
        if (n4 > 0) {
            this.chemRpara = new int[n4];
            n2 = 0;
            n = 0;
            while (n < 5) {
                if (this.chemPara[n]) {
                    this.chemRpara[n2++] = n;
                }
                ++n;
            }
        } else {
            this.chemRpara = null;
        }
        if (this.waterRpara == null && this.chemRpara == null) {
            JOptionPane.showMessageDialog(new JPanel(), "No water and chemical related\n parameters have been selected.", "Error", 0);
        }
    }

    public String getWaterRelatedParaText(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = this.waterCnt.getText();
                break;
            }
            case 1: {
                string = this.matPot.getText() + " (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + ")";
                break;
            }
            case 2: {
                string = this.totalPot.getText() + " (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + ")";
                break;
            }
            case 3: {
                string = this.drivingForce.getText();
                break;
            }
            case 4: {
                string = this.hydConduct.getText() + " (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ")";
                break;
            }
            case 5: {
                string = this.fluxDensity.getText() + " (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ")";
                break;
            }
            case 6: {
                string = this.cumuFlux.getText() + " (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + ")";
            }
        }
        return string;
    }

    public String getChemRelatedParaText(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = this.chemConSolution.getText() + " (g/m3)";
                break;
            }
            case 1: {
                string = this.chemConAdsorbed.getText() + "(g/m3)";
                break;
            }
            case 2: {
                string = this.chemConTotal.getText() + " (g/m3)";
                break;
            }
            case 3: {
                string = this.chemFluxDensity.getText() + " (g/m2/hr)";
                break;
            }
            case 4: {
                string = this.chemCumuFlux.getText() + " (g/m2)";
            }
        }
        return string;
    }

    public String getPosAndTimeText(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = this.allPosSelectTime.getText();
                break;
            }
            case 1: {
                string = this.allTimeSelectPos.getText();
                break;
            }
            case 2: {
                string = this.selectTimeSelectPos.getText();
            }
        }
        return string;
    }

    public void prepareTableDataForOutput(ProgressMonitor progressMonitor, int n) {
        double[] dArray = null;
        switch (this.opidx) {
            case 0: {
                dArray = new double[this.timeTable.model.numIdx];
                int n2 = 0;
                while (n2 < this.timeTable.model.numIdx) {
                    dArray[n2] = RichardsEqn.storeTime(this.timeTable.model.selectVal[n2]);
                    ++n2;
                }
                this.outputReportTable(dArray, this.waterRpara, this.chemRpara, this.opidx, progressMonitor, n);
                break;
            }
            case 1: {
                this.outputReportTable(this.posData, this.waterRpara, this.chemRpara, this.opidx, progressMonitor, n);
                break;
            }
            case 2: {
                dArray = new double[this.timeTable.model.numIdx];
                int n3 = 0;
                while (n3 < this.timeTable.model.numIdx) {
                    dArray[n3] = RichardsEqn.storeTime(this.timeTable.model.selectVal[n3]);
                    ++n3;
                }
                this.outputReportTable(dArray, this.posData, this.waterRpara, this.chemRpara, progressMonitor, n);
            }
        }
    }

    public void reSetChemChoice() {
        this.chemConSolution.setSelected(false);
        this.chemConAdsorbed.setSelected(false);
        this.chemConTotal.setSelected(false);
        this.chemFluxDensity.setSelected(false);
        this.chemCumuFlux.setSelected(false);
        int n = 0;
        while (n < this.chemPara.length) {
            this.chemPara[n] = false;
            ++n;
        }
    }

    public void outputReportTable(double[] dArray, int[] nArray, int[] nArray2, int n, ProgressMonitor progressMonitor, int n2) {
        String[] stringArray = null;
        int n3 = 2;
        int n4 = 0;
        int n5 = 0;
        if (this.waterRpara != null) {
            n3 += this.waterRpara.length;
        }
        if (this.chemRpara != null) {
            n3 += this.chemRpara.length;
        }
        daVec.removeAllElements();
        switch (n) {
            case 0: {
                n5 = 0;
                while (n5 < dArray.length) {
                    if (n5 == dArray.length - 1) {
                        CHEMFLO.mainScreen.simulationForOutput(dArray[n5], true);
                    } else {
                        CHEMFLO.mainScreen.simulationForOutput(dArray[n5], false);
                    }
                    if (RichardsEqn.simString.equals("false")) {
                        return;
                    }
                    stringArray = RichardsEqn.output[RichardsEqn.currentLine].outputReportRows(RichardsEqn.output[RichardsEqn.currentLine].z, nArray, nArray2);
                    daVec.addElement(stringArray);
                    progressMonitor.setProgress(++n2);
                    if (progressMonitor.isCanceled()) {
                        RichardsEqn.stop = true;
                        return;
                    }
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ++n5;
                }
                n4 = (RichardsEqn.output[RichardsEqn.currentLine].z.length - 1) * dArray.length;
                this.dataOut = new Object[n4][n3];
                break;
            }
            case 1: {
                n5 = 0;
                while (n5 < this.idx) {
                    if (n5 == this.idx - 1) {
                        CHEMFLO.mainScreen.simulationForOutput(this.time[n5], true);
                    } else {
                        CHEMFLO.mainScreen.simulationForOutput(this.time[n5], false);
                    }
                    if (RichardsEqn.simString.equals("false")) {
                        return;
                    }
                    stringArray = RichardsEqn.output[RichardsEqn.currentLine].outputReportRows(dArray, nArray, nArray2);
                    daVec.addElement(stringArray);
                    progressMonitor.setProgress(++n2);
                    if (progressMonitor.isCanceled()) {
                        RichardsEqn.stop = true;
                        return;
                    }
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ++n5;
                }
                if (this.remain != 0.0) {
                    CHEMFLO.mainScreen.simulationForOutput(this.time[this.idx], true);
                    stringArray = RichardsEqn.output[RichardsEqn.currentLine].outputReportRows(dArray, nArray, nArray2);
                    daVec.addElement(stringArray);
                    progressMonitor.setProgress(++n2);
                    if (progressMonitor.isCanceled()) {
                        RichardsEqn.stop = true;
                        return;
                    }
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                n4 = this.remain != 0.0 ? (this.idx + 1) * dArray.length : this.idx * dArray.length;
                this.dataOut = new Object[n4][n3];
            }
        }
        this.getOutputDataArray();
        progressMonitor.setProgress(++n2);
        if (progressMonitor.isCanceled()) {
            RichardsEqn.stop = true;
            return;
        }
    }

    public void outputReportTable(double[] dArray, double[] dArray2, int[] nArray, int[] nArray2, ProgressMonitor progressMonitor, int n) {
        String[] stringArray = null;
        daVec.removeAllElements();
        int n2 = 0;
        while (n2 < dArray.length) {
            if (n2 == dArray.length - 1) {
                CHEMFLO.mainScreen.simulationForOutput(dArray[n2], true);
            } else {
                CHEMFLO.mainScreen.simulationForOutput(dArray[n2], false);
            }
            if (RichardsEqn.simString.equals("false")) {
                return;
            }
            stringArray = RichardsEqn.output[RichardsEqn.currentLine].outputReportRows(dArray2, nArray, nArray2);
            daVec.addElement(stringArray);
            progressMonitor.setProgress(++n);
            if (progressMonitor.isCanceled()) {
                RichardsEqn.stop = true;
                return;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++n2;
        }
        int n3 = 2;
        if (this.waterRpara != null) {
            n3 += this.waterRpara.length;
        }
        if (this.chemRpara != null) {
            n3 += this.chemRpara.length;
        }
        int n4 = dArray.length * dArray2.length;
        this.dataOut = new Object[n4][n3];
        this.getOutputDataArray();
        progressMonitor.setProgress(++n);
        if (progressMonitor.isCanceled()) {
            RichardsEqn.stop = true;
            return;
        }
    }

    public void getOutputDataArray() {
        int n = 0;
        String[] stringArray = null;
        int n2 = 0;
        while (n2 < daVec.size()) {
            stringArray = (String[])daVec.elementAt(n2);
            int n3 = 0;
            while (n3 < stringArray.length) {
                StringTokenizer stringTokenizer = new StringTokenizer(stringArray[n3], ",");
                int n4 = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    this.dataOut[n][n4++] = stringTokenizer.nextToken();
                }
                ++n;
                ++n3;
            }
            ++n2;
        }
    }

    public void calculateAllTimeIndex() {
        double d = 0.0;
        double d2 = 0.0;
        switch (RichardsEqn.selectedTimeUnit) {
            case 0: {
                d = RichardsEqn.displayTime(RichardsEqn.criticalTime);
                d2 = RichardsEqn.displayTime(RichardsEqn.timeIntv);
                this.idx = (int)(d / d2);
                ++this.idx;
                this.remain = d * 10.0 % (d2 * 10.0);
                if (this.remain < 0.05) {
                    this.remain = 0.0;
                }
                this.time = this.remain != 0.0 ? new double[this.idx + 1] : new double[this.idx];
                this.time[0] = 0.0;
                int n = 1;
                while (n < this.idx) {
                    this.time[n] = d2 + d2 * (double)(n - 1);
                    ++n;
                }
                if (this.remain == 0.0) break;
                this.time[this.idx] = this.time[this.idx - 1] + this.remain;
                break;
            }
            case 1: {
                d = RichardsEqn.displayTime(RichardsEqn.criticalTime);
                d2 = RichardsEqn.displayTime(RichardsEqn.timeIntv);
                this.idx = (int)(d / d2);
                ++this.idx;
                this.remain = d % d2;
                if (this.remain / 60.0 < 0.05) {
                    this.remain = 0.0;
                }
                this.time = this.remain != 0.0 ? new double[this.idx + 1] : new double[this.idx];
                this.time[0] = 0.0;
                int n = 1;
                while (n < this.idx) {
                    this.time[n] = (d2 + d2 * (double)(n - 1)) / 60.0;
                    ++n;
                }
                if (this.remain == 0.0) break;
                this.time[this.idx] = this.time[this.idx - 1] + this.remain / 60.0;
                break;
            }
            case 2: {
                d = RichardsEqn.displayTime(RichardsEqn.criticalTime);
                d2 = RichardsEqn.displayTime(RichardsEqn.timeIntv);
                this.idx = (int)(d / d2);
                ++this.idx;
                this.remain = d % d2;
                if (this.remain / 3600.0 < 0.05) {
                    this.remain = 0.0;
                }
                this.time = this.remain != 0.0 ? new double[this.idx + 1] : new double[this.idx];
                this.time[0] = 0.0;
                int n = 1;
                while (n < this.idx) {
                    this.time[n] = (d2 + d2 * (double)(n - 1)) / 3600.0;
                    ++n;
                }
                if (this.remain == 0.0) break;
                this.time[this.idx] = this.time[this.idx - 1] + this.remain / 3600.0;
                break;
            }
            case 3: {
                d = RichardsEqn.displayTime(RichardsEqn.criticalTime);
                d2 = RichardsEqn.displayTime(RichardsEqn.timeIntv);
                this.idx = (int)(d / d2);
                ++this.idx;
                this.remain = d % d2;
                if (this.remain * 24.0 < 0.05) {
                    this.remain = 0.0;
                }
                this.time = this.remain != 0.0 ? new double[this.idx + 1] : new double[this.idx];
                this.time[0] = 0.0;
                int n = 1;
                while (n < this.idx) {
                    this.time[n] = (d2 + d2 * (double)(n - 1)) * 24.0;
                    ++n;
                }
                if (this.remain == 0.0) break;
                this.time[this.idx] = this.time[this.idx - 1] + this.remain * 24.0;
            }
        }
    }

    void deleteNosensePositions() {
        int n;
        double d = RichardsEqn.storeLength(RichardsEqn.experiment.dz);
        double[] dArray = new double[this.posTable.model.numIdx];
        this.posData = new double[this.posTable.model.numIdx];
        int n2 = 0;
        while (n2 < this.posTable.model.numIdx) {
            this.posData[n2] = RichardsEqn.storeLength(this.posTable.model.selectVal[n2]);
            ++n2;
        }
        double d2 = 0.0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.posData.length) {
            d2 = this.posData[n5] % d;
            n3 = (int)(this.posData[n5] / d);
            if (d2 == 0.0) {
                if (n5 > 0) {
                    n = this.getLastSaveIdx(dArray, n5);
                    if (dArray[n] == this.posData[n5]) {
                        dArray[n5] = -1.0;
                        ++n4;
                    } else {
                        dArray[n5] = this.posData[n5];
                    }
                } else {
                    dArray[n5] = this.posData[n5];
                }
            } else if (d2 < d / 2.0) {
                if (n5 > 0) {
                    n = this.getLastSaveIdx(dArray, n5);
                    if (dArray[n] == (double)n3 * d) {
                        dArray[n5] = -1.0;
                        ++n4;
                    } else {
                        dArray[n5] = (double)n3 * d;
                    }
                } else {
                    dArray[n5] = (double)n3 * d;
                }
            } else {
                n = this.getLastSaveIdx(dArray, n5);
                if (dArray[n] > this.posData[n5]) {
                    dArray[n5] = -1.0;
                    ++n4;
                } else {
                    dArray[n5] = (double)(n3 + 1) * d;
                }
            }
            ++n5;
        }
        this.posData = new double[this.posTable.model.numIdx - n4];
        n = 0;
        int n6 = 0;
        while (n6 < this.posTable.model.numIdx) {
            if (dArray[n6] >= 0.0) {
                this.posData[n++] = dArray[n6];
            }
            ++n6;
        }
        if (n4 > 0) {
            JOptionPane.showMessageDialog(new JPanel(), "One or more selected positins do not\ncorrespond to mesh points. Values for\nthe nearest mesh points will be used.", "Warning", 2);
        }
    }

    public int getLastSaveIdx(double[] dArray, int n) {
        int n2 = n - 1;
        while (n2 >= 0) {
            if (dArray[n2] >= 0.0) {
                return n2;
            }
            --n2;
        }
        return 0;
    }

    public void updateSize() {
        if (CHEMFLO.wMax) {
            this.wid = CHEMFLO.old_width - 250;
            this.hgh = CHEMFLO.old_height - 140;
        } else {
            this.wid = 550;
            this.hgh = 470;
        }
        if (this.rootPane.getComponentCount() != 0) {
            this.rootPane.removeAll();
        }
        this.rootPane.setPreferredSize(new Dimension(this.wid, this.hgh));
        int n = (int)((double)(this.hgh - 470) / 3.0);
        this.northP.setPreferredSize(new Dimension(this.wid, n));
        if (CHEMFLO.wMax) {
            this.southP.setPreferredSize(new Dimension(this.wid, n - 10));
        } else {
            this.southP.setPreferredSize(new Dimension(this.wid, n));
        }
        int n2 = (int)((double)(this.wid - 540) / 2.0);
        this.westP.setPreferredSize(new Dimension(n2, 460));
        this.eastP.setPreferredSize(new Dimension(n2 - 5, 460));
        this.posTable.setBounds(340, 5, 170, 145 + n);
        this.timeTable.setBounds(40, 5, 170, 145 + n);
        this.rootPane.add((Component)this.northP, "North");
        this.rootPane.add((Component)this.westP, "West");
        this.rootPane.add((Component)this.topPane, "Center");
        this.rootPane.add((Component)this.eastP, "East");
        this.rootPane.add((Component)this.southP, "South");
        this.rootPane.repaint();
    }

    class bntMouseListener
    extends MouseAdapter {
        bntMouseListener() {
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (ReportTablePanel.this.clearBnt == (JButton)mouseEvent.getSource()) {
                ReportTablePanel.this.clearBnt.setBorder(ReportTablePanel.this.oldBorder);
            } else if (ReportTablePanel.this.outTabBnt == (JButton)mouseEvent.getSource()) {
                ReportTablePanel.this.outTabBnt.setBorder(ReportTablePanel.this.oldBorder);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (ReportTablePanel.this.clearBnt == (JButton)mouseEvent.getSource()) {
                ReportTablePanel.this.clearBnt.setBorder(ReportTablePanel.this.raisedEdge);
            } else if (ReportTablePanel.this.outTabBnt == (JButton)mouseEvent.getSource()) {
                ReportTablePanel.this.outTabBnt.setBorder(ReportTablePanel.this.raisedEdge);
            }
        }
    }

    class forEvent
    extends MouseAdapter
    implements AdjustmentListener,
    ActionListener,
    ItemListener {
        int iTemp;
        double dTemp;
        String sTemp;
        String name;

        public forEvent(String string) {
            this.name = string;
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.name.equals("Clear")) {
                if (ReportTablePanel.this.allPosSelectTime.isSelected()) {
                    ReportTablePanel.this.timeTable.clearTable();
                }
                if (ReportTablePanel.this.allTimeSelectPos.isSelected()) {
                    ReportTablePanel.this.posTable.clearTable();
                }
                if (ReportTablePanel.this.selectTimeSelectPos.isSelected()) {
                    ReportTablePanel.this.timeTable.clearTable();
                    ReportTablePanel.this.posTable.clearTable();
                }
            } else if (this.name.equals("OutTable")) {
                int n = 0;
                ReportTablePanel.this.getSelectedParameterFlags();
                if (ReportTablePanel.this.waterRpara == null && ReportTablePanel.this.chemRpara == null) {
                    return;
                }
                if (ReportTablePanel.this.selectTimeSelectPos.isSelected()) {
                    ReportTablePanel.this.timeTable.sortingTable();
                    ReportTablePanel.this.posTable.sortingTable();
                    if (ReportTablePanel.this.timeTable.dupError || ReportTablePanel.this.posTable.dupError) {
                        return;
                    }
                    if (ReportTablePanel.this.timeTable.emptyTable || ReportTablePanel.this.posTable.emptyTable) {
                        return;
                    }
                    if (ReportTablePanel.this.posTable.model.maxVal > RichardsEqn.displayLength(RichardsEqn.length)) {
                        JOptionPane.showMessageDialog(new JPanel(), "The maximum position of interest\n should not be bigger than " + Tools.formatDouble(RichardsEqn.displayLength(RichardsEqn.length), 5, 9) + " (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + ")", "Error", 0);
                        return;
                    }
                    ReportTablePanel.this.deleteNosensePositions();
                    RichardsEqn.criticalTime = ReportTablePanel.this.timeTable.model.maxVal;
                    CHEMFLO.mainScreen.tfTime.setText(RichardsEqn.formatTime(RichardsEqn.criticalTime));
                    CHEMFLO.mainScreen.sbrTime.setValue((int)(10.0 * RichardsEqn.criticalTime + 0.5));
                } else {
                    if (ReportTablePanel.this.allPosSelectTime.isSelected()) {
                        ReportTablePanel.this.timeTable.sortingTable();
                        if (ReportTablePanel.this.timeTable.dupError || ReportTablePanel.this.timeTable.emptyTable) {
                            return;
                        }
                        RichardsEqn.criticalTime = ReportTablePanel.this.timeTable.model.maxVal;
                        CHEMFLO.mainScreen.tfTime.setText(RichardsEqn.formatTime(RichardsEqn.criticalTime));
                        CHEMFLO.mainScreen.sbrTime.setValue((int)(10.0 * RichardsEqn.criticalTime + 0.5));
                    }
                    if (ReportTablePanel.this.allTimeSelectPos.isSelected()) {
                        ReportTablePanel.this.posTable.sortingTable();
                        if (ReportTablePanel.this.posTable.dupError || ReportTablePanel.this.posTable.emptyTable) {
                            return;
                        }
                        if (ReportTablePanel.this.posTable.model.maxVal > RichardsEqn.displayLength(RichardsEqn.length)) {
                            JOptionPane.showMessageDialog(new JPanel(), "The maximum position of interest\n shouldn't be bigger than " + Tools.formatDouble(RichardsEqn.displayLength(RichardsEqn.length), 5, 9) + " (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + ")", "Error", 0);
                            return;
                        }
                        ReportTablePanel.this.deleteNosensePositions();
                    }
                }
                if (ReportTablePanel.this.allTimeSelectPos.isSelected()) {
                    SetMaxTimeOfInterestDialog setMaxTimeOfInterestDialog = new SetMaxTimeOfInterestDialog();
                    RichardsEqn.criticalTime = setMaxTimeOfInterestDialog.getUserSetTime();
                    RichardsEqn.timeIntv = setMaxTimeOfInterestDialog.getUserSetTimeIntv();
                    CHEMFLO.mainScreen.tfTime.setText(RichardsEqn.formatTime(RichardsEqn.criticalTime));
                    CHEMFLO.mainScreen.sbrTime.setValue((int)(10.0 * RichardsEqn.criticalTime + 0.5));
                    ReportTablePanel.this.calculateAllTimeIndex();
                    n = ReportTablePanel.this.time.length;
                } else {
                    n = ReportTablePanel.this.timeTable.model.numIdx;
                }
                int n2 = JOptionPane.showOptionDialog(null, new OutputTableWindow(), "Select Output Device", 2, -1, null, null, null);
                switch (n2) {
                    case -1: {
                        break;
                    }
                    case 0: {
                        RichardsEqn.stop = false;
                        if (OutputTableWindow.screenOption.isSelected()) {
                            new ShowScreenDialog(n);
                        }
                        if (OutputTableWindow.tableOption.isSelected()) {
                            new PrintTableDialog(n);
                        }
                        if (!OutputTableWindow.textOption.isSelected()) break;
                        new SaveTableDialog(n);
                        break;
                    }
                }
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (this.name.equals("allPos")) {
                ReportTablePanel.this.timeTable.setVisible(true);
                ReportTablePanel.this.posTable.setVisible(false);
                ReportTablePanel.this.posTable.clearTable();
            } else if (this.name.equals("allTime")) {
                ReportTablePanel.this.timeTable.setVisible(false);
                ReportTablePanel.this.posTable.setVisible(true);
                ReportTablePanel.this.timeTable.clearTable();
            } else if (this.name.equals("selectPosTime")) {
                ReportTablePanel.this.timeTable.setVisible(true);
                ReportTablePanel.this.posTable.setVisible(true);
                ReportTablePanel.this.timeTable.clearTable();
                ReportTablePanel.this.posTable.clearTable();
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (this.name.trim().equals("ReportPanel")) {
                if (ReportTablePanel.this.allPosSelectTime.isSelected()) {
                    ReportTablePanel.this.timeTable.checkTableData();
                }
                if (ReportTablePanel.this.allTimeSelectPos.isSelected()) {
                    ReportTablePanel.this.posTable.checkTableData();
                }
                if (ReportTablePanel.this.selectTimeSelectPos.isSelected()) {
                    ReportTablePanel.this.timeTable.checkTableData();
                    ReportTablePanel.this.posTable.checkTableData();
                }
            }
        }
    }

    class TimePositionTabelPanel
    extends JPanel {
        TimePositionTabelPanel() {
            this.setPreferredSize(new Dimension(520, 170));
            this.setLayout(null);
            ReportTablePanel.this.timeTable = new TimeInterestTable();
            ReportTablePanel.this.timeTable.setBounds(40, 5, 170, 145);
            ReportTablePanel.this.posTable = new PositionInterestTable();
            ReportTablePanel.this.posTable.setBounds(340, 5, 170, 145);
            ReportTablePanel.this.posTable.setVisible(false);
            this.add(ReportTablePanel.this.timeTable);
            this.add(ReportTablePanel.this.posTable);
        }
    }

    class CheckParaPanel
    extends JPanel {
        CheckParaPanel() {
            this.setPreferredSize(new Dimension(520, 248));
            this.setLayout(null);
            ReportTablePanel.this.title = new JLabel("Select the Desired Output for the Report");
            ReportTablePanel.this.title.setFont(new Font("Serif", 1, 16));
            ReportTablePanel.this.title.setForeground(Color.black);
            ReportTablePanel.this.title.setBounds(130, 5, 350, 15);
            this.add(ReportTablePanel.this.title);
            ReportTablePanel.this.sub_title1 = new JLabel("Water Related Parameters");
            ReportTablePanel.this.sub_title1.setBounds(40, 27, 200, 10);
            ReportTablePanel.this.sub_title1.setForeground(Color.black);
            this.add(ReportTablePanel.this.sub_title1);
            ReportTablePanel.this.sub_title2 = new JLabel("Chemical Related Parameters");
            ReportTablePanel.this.sub_title2.setBounds(340, 27, 200, 10);
            ReportTablePanel.this.sub_title2.setForeground(Color.black);
            this.add(ReportTablePanel.this.sub_title2);
            ReportTablePanel.this.waterCnt = new JCheckBox("Water Content", false);
            ReportTablePanel.this.waterCnt.setBounds(40, 45, 200, 20);
            ReportTablePanel.this.matPot = new JCheckBox("Matric Potential", false);
            ReportTablePanel.this.matPot.setBounds(40, 65, 200, 20);
            ReportTablePanel.this.totalPot = new JCheckBox("Total Potential", false);
            ReportTablePanel.this.totalPot.setBounds(40, 85, 200, 20);
            ReportTablePanel.this.drivingForce = new JCheckBox("Driving Force", false);
            ReportTablePanel.this.drivingForce.setBounds(40, 105, 200, 20);
            ReportTablePanel.this.hydConduct = new JCheckBox("Hydraulic Conductivity", false);
            ReportTablePanel.this.hydConduct.setBounds(40, 125, 200, 20);
            ReportTablePanel.this.fluxDensity = new JCheckBox("Flux Density", false);
            ReportTablePanel.this.fluxDensity.setBounds(40, 145, 200, 20);
            ReportTablePanel.this.cumuFlux = new JCheckBox("Cumulative Flux", false);
            ReportTablePanel.this.cumuFlux.setBounds(40, 165, 200, 20);
            this.add(ReportTablePanel.this.waterCnt);
            this.add(ReportTablePanel.this.matPot);
            this.add(ReportTablePanel.this.totalPot);
            this.add(ReportTablePanel.this.drivingForce);
            this.add(ReportTablePanel.this.hydConduct);
            this.add(ReportTablePanel.this.fluxDensity);
            this.add(ReportTablePanel.this.cumuFlux);
            ReportTablePanel.this.chemConSolution = new JCheckBox("Concentration Solution", false);
            ReportTablePanel.this.chemConSolution.setBounds(340, 45, 200, 20);
            ReportTablePanel.this.chemConAdsorbed = new JCheckBox("Concentration Adsorbed", false);
            ReportTablePanel.this.chemConAdsorbed.setBounds(340, 65, 200, 20);
            ReportTablePanel.this.chemConTotal = new JCheckBox("Concentration Total", false);
            ReportTablePanel.this.chemConTotal.setBounds(340, 85, 200, 20);
            ReportTablePanel.this.chemFluxDensity = new JCheckBox("Flux Density", false);
            ReportTablePanel.this.chemFluxDensity.setBounds(340, 105, 200, 20);
            ReportTablePanel.this.chemCumuFlux = new JCheckBox("Cumulative Flux", false);
            ReportTablePanel.this.chemCumuFlux.setBounds(340, 125, 200, 20);
            this.add(ReportTablePanel.this.chemConSolution);
            this.add(ReportTablePanel.this.chemConAdsorbed);
            this.add(ReportTablePanel.this.chemConTotal);
            this.add(ReportTablePanel.this.chemFluxDensity);
            this.add(ReportTablePanel.this.chemCumuFlux);
            ReportTablePanel.this.allPosSelectTime = new JRadioButton("Display Results for All Positions and Selected Times", true);
            ReportTablePanel.this.allPosSelectTime.setBounds(130, 188, 400, 20);
            ReportTablePanel.this.allTimeSelectPos = new JRadioButton("Display Results for All Times and Selected Positions", false);
            ReportTablePanel.this.allTimeSelectPos.setBounds(130, 208, 400, 20);
            ReportTablePanel.this.selectTimeSelectPos = new JRadioButton("Display Results for Selected Positions and Selected Times", false);
            ReportTablePanel.this.selectTimeSelectPos.setBounds(130, 228, 400, 20);
            ReportTablePanel.this.group = new ButtonGroup();
            ReportTablePanel.this.group.add(ReportTablePanel.this.allPosSelectTime);
            ReportTablePanel.this.group.add(ReportTablePanel.this.allTimeSelectPos);
            ReportTablePanel.this.group.add(ReportTablePanel.this.selectTimeSelectPos);
            this.add(ReportTablePanel.this.allPosSelectTime);
            this.add(ReportTablePanel.this.allTimeSelectPos);
            this.add(ReportTablePanel.this.selectTimeSelectPos);
            ReportTablePanel.this.allPosSelectTime.addItemListener(new forEvent("allPos"));
            ReportTablePanel.this.allTimeSelectPos.addItemListener(new forEvent("allTime"));
            ReportTablePanel.this.selectTimeSelectPos.addItemListener(new forEvent("selectPosTime"));
        }
    }
}

