/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.util.Vector;

public class RichardsEqn
extends Applet {
    public static final int MLAYERS = 5;
    public static final int MAXLINES = 5;
    public static final int MAX_BC = 100;
    public static final double ESSENTIALLY_ZERO = 1.0E-10;
    public static final Color[] colorLine = new Color[]{Color.red, Color.blue, Color.black, Color.green, Color.magenta};
    public static Soil editingSoil;
    public static String[] lengthUnits;
    public static String[] timeUnits;
    public static int selectedLengthUnit;
    public static int selectedTimeUnit;
    public static int iterations;
    public static final boolean DEBUG = false;
    public static boolean diffsoilModel;
    public static boolean restart;
    public static boolean escape;
    public static boolean simDone;
    public static boolean errorFree;
    public static String errorMessage;
    public static boolean usingKoc;
    static double timeIntv;
    static double fluxAt0;
    static double fluxAtL;
    static double mixedFlux;
    static double rainfall;
    static double criticalPot;
    static double length;
    static double alpha;
    static double criticalTime;
    static double[] h;
    static int xGraph;
    static int yGraph;
    static int yAlpha;
    static int currentLine;
    static int jLines;
    static boolean semiInfiniteSelected;
    static Horizon[] horizons;
    static Horizon reservedHorizon;
    static Soil soil;
    static InitialCondition ic;
    static BoundaryCondition[] bc;
    static int mBC;
    static Solution[] output;
    static RichardsEqnSolver experiment;
    static TransportProperties tp;
    static double xmin;
    static double ymin;
    static double xmax;
    static double ymax;
    static double ln10;
    static boolean newBC0;
    static boolean newBCL;
    static String simString;
    static int selectedGraphIndex;
    static int selectedGraphIndex2;
    static int selectedInitialCond;
    static int selectedInitialCond2;
    static int oldInitialCond2;
    static int selectedBoundaryCond;
    static int selectedBoundaryCondAtL;
    static int selectedChemBoundaryCond;
    static int selectedChemBoundaryCondAtL;
    static int[] selectedConductModelIndex;
    static int[] selectedRententModelIndex;
    static double[] meshPosition;
    static double[] matricPotential;
    static double[] chemConcentration;
    static double matricChemPotInitial;
    static double matricPotInitial;
    static double wcInitial;
    static double criticalPosition;
    static double matricPotAt0;
    static double matricPotAtL;
    static double matricChemPotAt0;
    static double matricChemSoilPotAt0;
    static double matricChemPotAtL;
    static double initPondingDepth;
    static double[] Position;
    static double[] Alpha;
    static double[] Beta;
    static double[] Gamma;
    static double[] Kd;
    static int waterPartCoeIndex;
    static int firstDegLiqIndex;
    static int firstDegSoilIndex;
    static int zeroDegIndex;
    static double diff;
    static double disp;
    static double Koc;
    static double kd;
    static double alph;
    static double beta;
    static double gamma;
    static double massBalanceCriterion;
    static Vector allSoilNames;
    static int currentSoilIndex;
    static String currentSoilName;
    static double dt;
    static double dz;
    static double converg;
    static double maxAbsError;
    static double maxRelaError;
    static double criticalCumuFlux;
    public static boolean stop;
    public static String osName;
    public static Font labelFont;
    public static Font comboBoxFont;
    public static Font buttonTextFont;
    public static Font tableHeaderFont;
    public static Font noteFont;
    public static Font noteFontI;
    public static Font textFieldFont;
    public static Font graphNumberFont;
    public static Font equationFont;
    public static String htmlFontSize;
    static final boolean TEST_CDE = false;

    RichardsEqn() {
        if (osName.startsWith("Windows")) {
            labelFont = new Font("Serif", 1, 14);
            comboBoxFont = new Font("Serif", 1, 13);
            buttonTextFont = new Font("Serif", 1, 12);
            tableHeaderFont = new Font("Serif", 1, 12);
            noteFont = new Font("Dialog", 0, 12);
            noteFontI = new Font("Dialog", 0, 14);
            htmlFontSize = "<Font Size= 3>";
        } else if (osName.equals("Linux") || osName.equals("Solaris")) {
            labelFont = new Font("Serif", 1, 12);
            comboBoxFont = new Font("Serif", 1, 11);
            buttonTextFont = new Font("Serif", 1, 11);
            tableHeaderFont = new Font("Serif", 1, 10);
            noteFont = new Font("Dialog", 0, 11);
            noteFontI = new Font("Dialog", 0, 13);
            equationFont = new Font("SansSerif", 0, 11);
            htmlFontSize = "<Font Size= 2>";
        } else if (osName.equals("Mac OS X")) {
            textFieldFont = new Font("Dialog", 0, 11);
            graphNumberFont = new Font("Dialog", 0, 11);
            noteFont = new Font("Dialog", 0, 11);
            noteFontI = new Font("Dialog", 0, 13);
            equationFont = new Font("SansSerif", 0, 11);
            htmlFontSize = "<Font Size= 2>";
        }
        if (!equationFont.canDisplay('\u03b8')) {
            String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
            int n = 0;
            while (n < stringArray.length) {
                equationFont = new Font(stringArray[n], 0, 12);
                if (equationFont.canDisplay('\u03b8')) break;
                ++n;
            }
            System.out.println(stringArray.length + ", " + n + ", " + stringArray[n]);
        }
        matricPotInitial = -1000.0;
        matricChemPotInitial = 10.0;
        matricPotAt0 = 0.0;
        alpha = 90.0;
        RichardsEqn.getSoilNames(CHEMFLO.soilIO.soilList);
        currentSoilName = (String)allSoilNames.elementAt(0);
        RichardsEqn.setCurrentSoil(currentSoilName);
        soil = new Soil(currentSoilName, editingSoil.getLength(), RichardsEqn.editingSoil.horizon[0].getBulkDensity(), RichardsEqn.editingSoil.horizon[0].getOC(), RichardsEqn.editingSoil.horizon[0].wc, RichardsEqn.editingSoil.horizon[0].k);
        ic = new InitialCondition(matricPotInitial, true);
        semiInfiniteSelected = false;
        RichardsEqn.bc[RichardsEqn.mBC] = new BoundaryCondition(criticalTime);
        bc[mBC].setPotentialAt0(matricPotAt0);
        bc[mBC].setPotentialAtL(matricPotAtL);
        bc[mBC].setConcAt0(matricChemPotAt0, 4);
        bc[mBC].setConcAtL(matricChemPotAtL);
        tp = new TransportProperties(alph, beta, gamma, kd, disp, diff);
        experiment = new RichardsEqnSolver(soil, ic, bc[mBC], alpha, criticalPosition);
        experiment.setInitialCondition();
        xmax = bc[mBC].getWaterBCTypeAtL() != -1 ? soil.getLength() : 50.0;
        simString = experiment.simulate(criticalTime);
        RichardsEqn.output[RichardsEqn.currentLine] = new Solution(experiment.getNumberPoints(), experiment.getPositionArray(), experiment.getMatricPotentialArray(), experiment.getFluxWaterArray(), RichardsEqn.experiment.cumFluxWater, soil, RichardsEqn.experiment.angle, RichardsEqn.experiment.positionSaved, RichardsEqn.experiment.time, RichardsEqn.experiment.mp, RichardsEqn.experiment.q, RichardsEqn.experiment.nPointsSaved, RichardsEqn.experiment.ic.isFinite);
        criticalPosition = RichardsEqn.output[RichardsEqn.currentLine].depth;
        int n = 1;
        while (n < 5) {
            RichardsEqn.output[n] = new Solution();
            ++n;
        }
    }

    static void setCurrentSoil(String string) {
        int n = CHEMFLO.soilIO.getIndexOfSelectedSoil(string);
        Soil soil = (Soil)CHEMFLO.soilIO.soilList.get(n);
        length = 0.0;
        int n2 = 0;
        while (n2 < soil.nHorizons) {
            String string2 = RichardsEqn.getConductivityModel(soil.horizon[n2].k);
            RichardsEqn.selectedConductModelIndex[n2] = RichardsEqn.getConductivityModelIndex(string2);
            String string3 = RichardsEqn.getWaterContentModel(soil.horizon[n2].wc);
            RichardsEqn.selectedRententModelIndex[n2] = RichardsEqn.getWaterContentModelIndex(string3);
            ++n2;
        }
        editingSoil = soil;
        length = RichardsEqn.editingSoil.horizon[RichardsEqn.editingSoil.nHorizons - 1].depthBottom;
    }

    static void getSoilNames(Vector vector) {
        allSoilNames.removeAllElements();
        int n = 0;
        while (n < vector.size()) {
            Soil soil = (Soil)vector.get(n);
            allSoilNames.addElement(soil.name.trim());
            ++n;
        }
    }

    static double storeLength(double d) {
        double d2 = d;
        switch (selectedLengthUnit) {
            case 0: {
                d2 = d;
                break;
            }
            case 1: {
                d2 = d * 100.0;
                break;
            }
            case 2: {
                d2 = d * 30.48;
            }
        }
        return d2;
    }

    static double displayLength(double d) {
        double d2 = d;
        switch (selectedLengthUnit) {
            case 0: {
                d2 = d;
                break;
            }
            case 1: {
                d2 = d / 100.0;
                break;
            }
            case 2: {
                d2 = d / 30.48;
            }
        }
        return d2;
    }

    static String formatLength(double d) {
        int n = 0;
        switch (selectedLengthUnit) {
            case 0: {
                n = 1;
                break;
            }
            case 1: {
                n = 3;
                break;
            }
            case 2: {
                n = 3;
            }
        }
        return Tools.formatDouble(RichardsEqn.displayLength(d), n, n);
    }

    static String formatTime(double d) {
        int n = 0;
        switch (selectedTimeUnit) {
            case 0: {
                n = 4;
                break;
            }
            case 1: {
                n = 2;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            case 3: {
                n = 5;
            }
        }
        return Tools.formatDouble(RichardsEqn.displayTime(d), n, n);
    }

    static String formatVelocity(double d) {
        int n = 1;
        block0 : switch (selectedLengthUnit) {
            case 0: {
                switch (selectedTimeUnit) {
                    case 0: {
                        n = 3;
                        break;
                    }
                    case 1: {
                        n = 4;
                        break;
                    }
                    case 2: {
                        n = 6;
                        break;
                    }
                    case 3: {
                        n = 2;
                    }
                }
                break;
            }
            case 1: {
                switch (selectedTimeUnit) {
                    case 0: {
                        n = 5;
                        break;
                    }
                    case 1: {
                        n = 7;
                        break;
                    }
                    case 2: {
                        n = 8;
                        break;
                    }
                    case 3: {
                        n = 4;
                    }
                }
                break;
            }
            case 2: {
                switch (selectedTimeUnit) {
                    case 0: {
                        n = 5;
                        break block0;
                    }
                    case 1: {
                        n = 7;
                        break block0;
                    }
                    case 2: {
                        n = 8;
                        break block0;
                    }
                    case 3: {
                        n = 4;
                    }
                }
            }
        }
        return Tools.formatDouble(RichardsEqn.displayVelocity(d), n, n);
    }

    static double storeTime(double d) {
        double d2 = d;
        switch (selectedTimeUnit) {
            case 0: {
                d2 = d;
                break;
            }
            case 1: {
                d2 = d / 60.0;
                break;
            }
            case 2: {
                d2 = d / 3600.0;
                break;
            }
            case 3: {
                d2 = d * 24.0;
            }
        }
        return d2;
    }

    static double displayTime(double d) {
        double d2 = d;
        switch (selectedTimeUnit) {
            case 0: {
                d2 = d;
                break;
            }
            case 1: {
                d2 = d * 60.0;
                break;
            }
            case 2: {
                d2 = d * 3600.0;
                break;
            }
            case 3: {
                d2 = d / 24.0;
            }
        }
        return d2;
    }

    static double storeVelocity(double d) {
        return RichardsEqn.storeLength(d) / RichardsEqn.storeTime(1.0);
    }

    static double displayVelocity(double d) {
        return RichardsEqn.displayLength(d) / RichardsEqn.displayTime(1.0);
    }

    static void resetUnits() {
        CHEMFLO.initialPane.ResetUnits();
        CHEMFLO.boundaryPane.ResetUnits();
        CHEMFLO.soilPane.ResetUnits();
        CHEMFLO.mainScreen.ResetUnits();
        CHEMFLO.reportPane.ResetUnits();
    }

    static String getConductivityModel(Conductivity conductivity) {
        String string = "Unknown hydraulic conductivity model";
        if (conductivity instanceof GardnerConductivity) {
            string = "Gardner";
        } else if (conductivity instanceof BrooksConductivity) {
            string = "Brooks & Corey";
        } else if (conductivity instanceof VanGenuchtenConductivity) {
            string = "van Genuchten";
        }
        return string;
    }

    static String getWaterContentModel(WaterContent waterContent) {
        String string = "Unknown retention curve model";
        if (waterContent instanceof SimmonsWaterContent) {
            string = "Simmons";
        } else if (waterContent instanceof BrooksWaterContent) {
            string = "Brooks & Corey";
        } else if (waterContent instanceof VanGenuchtenWaterContent) {
            string = "van Genuchten";
        }
        return string;
    }

    static Conductivity getConductivityObj(String string, double d, double d2, double d3, Image image) throws NumberFormatException {
        Conductivity conductivity = null;
        if (string.trim().equals("Gardner")) {
            conductivity = new GardnerConductivity(d, d2, d3, image);
        } else if (string.trim().equals("Brooks & Corey")) {
            conductivity = new BrooksConductivity(d, d2, d3, image);
        } else if (string.trim().equals("van Genuchten")) {
            conductivity = new VanGenuchtenConductivity(d, d2, d3, image);
        } else {
            throw new NumberFormatException("Unknow hydraulic conductivity model.");
        }
        return conductivity;
    }

    static WaterContent getWaterContentObj(String string, double d, double d2, double d3, double d4, Image image) throws NumberFormatException {
        WaterContent waterContent = null;
        if (string.trim().equals("Simmons")) {
            waterContent = new SimmonsWaterContent(d, d2, d3, d4, image);
        } else if (string.trim().equals("Brooks & Corey")) {
            waterContent = new BrooksWaterContent(d, d2, d3, d4, image);
        } else if (string.trim().equals("van Genuchten")) {
            waterContent = new VanGenuchtenWaterContent(d, d2, d3, d4, image);
        } else {
            throw new NumberFormatException("Unknow soil water retention model.");
        }
        return waterContent;
    }

    static int getConductivityModelIndex(String string) {
        int n = -9999;
        if (string.trim().equals("Gardner")) {
            n = 0;
        } else if (string.trim().equals("Brooks & Corey")) {
            n = 1;
        } else if (string.trim().equals("van Genuchten")) {
            n = 2;
        }
        return n;
    }

    static int getWaterContentModelIndex(String string) {
        int n = -9999;
        if (string.trim().equals("Simmons")) {
            n = 0;
        } else if (string.trim().equals("Brooks & Corey")) {
            n = 1;
        } else if (string.trim().equals("van Genuchten")) {
            n = 2;
        }
        return n;
    }

    static {
        lengthUnits = new String[]{"cm", "m", "ft"};
        timeUnits = new String[]{"hr", "min", "sec", "day"};
        selectedLengthUnit = 0;
        selectedTimeUnit = 0;
        iterations = 0;
        diffsoilModel = false;
        restart = false;
        escape = false;
        simDone = false;
        errorFree = true;
        errorMessage = null;
        usingKoc = false;
        timeIntv = 0.1;
        fluxAt0 = 1.0;
        fluxAtL = 0.0;
        mixedFlux = 0.0;
        rainfall = 1.0;
        criticalPot = -1000.0;
        length = 50.0;
        criticalTime = 0.5;
        currentLine = 0;
        jLines = 1;
        bc = new BoundaryCondition[100];
        mBC = 0;
        output = new Solution[5];
        xmin = 0.0;
        ymin = 0.0;
        xmax = 50.0;
        ymax = 20.0;
        ln10 = Math.log(10.0);
        newBC0 = false;
        newBCL = false;
        selectedGraphIndex = 0;
        selectedGraphIndex2 = 14;
        selectedInitialCond = 0;
        selectedInitialCond2 = 0;
        oldInitialCond2 = 0;
        selectedBoundaryCond = 0;
        selectedBoundaryCondAtL = 0;
        selectedChemBoundaryCond = 0;
        selectedChemBoundaryCondAtL = 1;
        selectedConductModelIndex = new int[]{2, 2, 2, 2, 2};
        selectedRententModelIndex = new int[]{2, 2, 2, 2, 2};
        matricChemPotInitial = 10.0;
        matricPotInitial = -1000.0;
        wcInitial = 0.25;
        criticalPosition = 0.0;
        matricPotAt0 = 0.0;
        matricPotAtL = -1000.0;
        matricChemPotAt0 = 100.0;
        matricChemSoilPotAt0 = 100.0;
        matricChemPotAtL = 10.0;
        initPondingDepth = 20.0;
        waterPartCoeIndex = 0;
        firstDegLiqIndex = 0;
        firstDegSoilIndex = 0;
        zeroDegIndex = 0;
        diff = 0.03;
        disp = 2.0;
        Koc = 0.0;
        kd = 0.0;
        alph = 0.0;
        beta = 0.0;
        gamma = 0.0;
        massBalanceCriterion = 0.5;
        allSoilNames = new Vector(20, 10);
        currentSoilIndex = 0;
        dt = 0.005;
        dz = 0.5;
        converg = 1.0E-4;
        maxAbsError = 0.125;
        maxRelaError = 5.0;
        criticalCumuFlux = 2.5;
        stop = false;
        labelFont = new Font("Serif", 1, 14);
        comboBoxFont = new Font("Serif", 1, 13);
        buttonTextFont = new Font("Serif", 1, 12);
        tableHeaderFont = new Font("Serif", 1, 12);
        noteFont = new Font("Dialog", 0, 12);
        noteFontI = new Font("Dialog", 0, 14);
        textFieldFont = new Font("Dialog", 0, 12);
        graphNumberFont = new Font("Dialog", 0, 12);
        equationFont = new Font("Serif", 0, 12);
        htmlFontSize = "<Font Size= 3>";
    }
}

