/*
 * Decompiled with CFR 0.152.
 */
public class RichardsEqnSolver {
    Soil s;
    TransportProperties tp;
    InitialCondition ic;
    BoundaryCondition[] bc = new BoundaryCondition[100];
    int currentBC;
    double dz;
    double dt;
    double convergenceCriteria;
    double maxAbsError;
    double maxRelaError;
    double criticalCumuFlux;
    double criticalValue;
    boolean converged = false;
    double criticalPosition = 0.0;
    int criticalNode = 0;
    public double positionSaved = 0.0;
    int bcWaterType;
    int bcWaterTypeAtL;
    int bcChemType;
    int bcChemTypeAtL;
    public double angle;
    public int nPointsSaved = 0;
    public double[] time = new double[5002];
    public double[] mp = new double[5000];
    public double[] q = new double[5000];
    public double[] conc = new double[5000];
    public double[] fluxChem = new double[5000];
    public double[] massChem = new double[5000];
    public double[] cumFluxWater;
    public double[] cumFluxChem;
    private int nMeshPoints;
    private double[] z;
    private double[] h;
    private double[] c;
    private double[] alpha;
    private double[] beta;
    private double[] gamma;
    private double[] rho;
    private double[] kd;
    private double t = 0.0;
    private double sinAngle;
    private double[] k = new double[502];
    private double[] wCap = new double[502];
    private double[] theta = new double[502];
    private double[] theta0 = new double[502];
    private double[] flux1 = new double[502];
    private double[] flux0 = new double[502];
    private double[] lower = new double[502];
    private double[] diag = new double[502];
    private double[] upper = new double[502];
    private double[] rhs = new double[502];
    private double[] cOld = new double[2];
    double cumuInflux;
    double storageIncrease;
    double[] initWaterContent;
    double initWC;
    int convergenceFailureIndex;
    private static final int N_INITIAL = 50;
    public static final int MAX_MESHPOINTS = 500;
    public static final int MIN_POINTS_PER_HORIZON = 10;
    public static final int MAX_DATAPOINTS = 5000;
    public static final int MAX_TIME_INTERVALS = 10;
    private static final int MAX_BC = 100;
    private static final int MAX_ITERATIONS = 10;
    private static final int MIN_CONSECUTIVE_CONVERGENCES = 16;
    private static final boolean DEBUG = false;

    public RichardsEqnSolver(Soil soil, TransportProperties transportProperties, InitialCondition initialCondition, BoundaryCondition boundaryCondition, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        this.currentBC = 0;
        this.s = soil;
        this.tp = transportProperties;
        this.ic = initialCondition;
        this.bc[0] = boundaryCondition;
        this.bcWaterType = this.bc[0].getWaterBCTypeAt0();
        this.bcWaterTypeAtL = this.bc[0].getWaterBCTypeAtL();
        if (this.bcWaterType == 2) {
            this.bcWaterType = 1;
        }
        if (this.bcWaterType == 7) {
            this.bcWaterType = 0;
        }
        this.bcChemType = this.bc[0].getChemBCTypeAt0();
        this.bcChemTypeAtL = this.bc[0].getChemBCTypeAtL();
        this.angle = d;
        this.sinAngle = Math.sin(this.angle * Math.PI / 180.0);
        this.dz = d2;
        this.dt = d3;
        this.convergenceCriteria = d4;
        this.maxAbsError = d5;
        this.maxRelaError = d6;
        this.criticalCumuFlux = d7;
        this.criticalPosition = d8;
    }

    public RichardsEqnSolver(Soil soil, TransportProperties transportProperties, InitialCondition initialCondition, BoundaryCondition boundaryCondition, double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        this(soil, transportProperties, initialCondition, boundaryCondition, d, d2, d3, d4, d5, d6, d7, 0.0);
    }

    public RichardsEqnSolver(Soil soil, InitialCondition initialCondition, BoundaryCondition boundaryCondition, double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        this.currentBC = 0;
        this.s = soil;
        this.ic = initialCondition;
        this.bc[0] = boundaryCondition;
        this.bcWaterType = this.bc[0].getWaterBCTypeAt0();
        this.bcWaterTypeAtL = this.bc[0].getWaterBCTypeAtL();
        if (this.bcWaterType == 2) {
            this.bcWaterType = 1;
        }
        if (this.bcWaterType == 7) {
            this.bcWaterType = 0;
        }
        this.bcChemType = this.bc[0].getChemBCTypeAt0();
        this.bcChemTypeAtL = this.bc[0].getChemBCTypeAtL();
        this.angle = d;
        this.sinAngle = Math.sin(this.angle * Math.PI / 180.0);
        this.dz = d2;
        this.dt = d3;
        this.convergenceCriteria = d4;
        this.maxAbsError = d5;
        this.maxRelaError = d6;
        this.criticalCumuFlux = d7;
    }

    public RichardsEqnSolver(Soil soil, InitialCondition initialCondition, BoundaryCondition boundaryCondition, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        this(soil, initialCondition, boundaryCondition, d, d2, d3, d4, d5, d6, d7);
        this.criticalPosition = d8;
    }

    public RichardsEqnSolver(Soil soil, InitialCondition initialCondition, BoundaryCondition boundaryCondition, double d, double d2) {
        this(soil, initialCondition, boundaryCondition, d, 0.5, 0.005, 1.0E-4, 0.125, 5.0, 2.5, d2);
    }

    public RichardsEqnSolver() {
        this.nMeshPoints = 0;
    }

    public void addBoundaryCondition(BoundaryCondition boundaryCondition) {
        ++this.currentBC;
        this.bc[this.currentBC] = boundaryCondition;
    }

    public double[] getMatricPotentialArray() {
        return this.h;
    }

    public double[] getFluxWaterArray() {
        return this.flux1;
    }

    public double[] getPositionArray() {
        return this.z;
    }

    public double[] getConcentrationArray() {
        return this.c;
    }

    public void setInitialCondition() {
        int n;
        int[] nArray = new int[this.s.nHorizons];
        double[] dArray = new double[this.s.nHorizons];
        int n2 = 0;
        while (n2 <= RichardsEqn.mBC) {
            if (this.bc[n2].getWaterBCTypeAt0() == 7) {
                this.bc[n2].resetFallingHeadAt0();
            }
            ++n2;
        }
        if (!this.ic.isFinite) {
            this.z = new double[502];
            this.h = new double[502];
            this.cumFluxWater = new double[502];
            n2 = 0;
            while (n2 < 502) {
                this.z[n2] = (double)n2 * this.dz;
                this.cumFluxWater[n2] = 0.0;
                this.flux1[n2] = 0.0;
                ++n2;
            }
            this.nMeshPoints = 50;
        } else {
            int n3;
            int n4;
            do {
                n4 = 0;
                n3 = 0;
                while (n3 < this.s.nHorizons) {
                    nArray[n3] = (int)(this.s.horizon[n3].getLength() / this.dz);
                    if (nArray[n3] < 10) {
                        nArray[n3] = 10;
                    }
                    if ((double)nArray[n3] * this.dz < this.s.horizon[n3].getLength()) {
                        int n5 = n3;
                        nArray[n5] = nArray[n5] + 1;
                    }
                    dArray[n3] = this.s.horizon[n3].getLength() / (double)nArray[n3];
                    n4 += nArray[n3];
                    ++n3;
                }
                if (n4 < 499) continue;
                this.dz *= 1.1;
            } while (n4 >= 499);
            this.nMeshPoints = n4 + 1;
            this.z = new double[n4 + 1];
            this.h = new double[n4 + 1];
            this.initWaterContent = new double[n4 + 1];
            this.cumFluxWater = new double[n4 + 1];
            if (this.ic.simChemical) {
                this.c = new double[n4 + 1];
                this.rho = new double[n4 + 1];
                this.cumFluxChem = new double[n4 + 1];
            }
            n4 = 0;
            this.z[n4] = 0.0;
            this.cumFluxWater[0] = 0.0;
            n3 = 0;
            while (n3 < this.s.nHorizons) {
                n2 = 0;
                while (n2 < nArray[n3]) {
                    this.z[++n4] = this.z[n4 - 1] + dArray[n3];
                    this.cumFluxWater[n4] = 0.0;
                    ++n2;
                }
                ++n3;
            }
        }
        this.criticalNode = this.getClosestNode(this.criticalPosition);
        this.positionSaved = this.z[this.criticalNode];
        this.h = this.ic.getInitialPotentialArray(this.z);
        n2 = 0;
        while (n2 < this.nMeshPoints) {
            n = this.s.getHorizonIndex(this.z[n2]);
            this.flux1[n2] = this.getFluxWater(n2, 0);
            if (this.ic.isFinite) {
                this.initWaterContent[n2] = this.s.horizon[n].getWaterContent(this.h[n2]);
            }
            ++n2;
        }
        if (!this.ic.isFinite) {
            this.initWC = this.s.horizon[0].getWaterContent(this.h[1]);
            n2 = this.nMeshPoints;
            while (n2 < 502) {
                this.h[n2] = this.h[this.nMeshPoints - 1];
                this.flux1[n2] = this.flux1[this.nMeshPoints - 1];
                ++n2;
            }
        }
        if (this.ic.simChemical) {
            this.c = this.ic.isTotalConcentration ? this.ic.getInitConcenArrayFromTotalConcentration(this.z, this.s, this.tp) : this.ic.getInitialConcentrationArray(this.z);
            this.cOld[0] = this.c[0];
            this.cOld[1] = this.c[1];
            this.alpha = this.tp.getAlphaArray(this.z);
            this.beta = this.tp.getBetaArray(this.z);
            int n6 = 0;
            while (n6 < this.nMeshPoints) {
                int n7 = n6;
                this.alpha[n7] = this.alpha[n7] * -1.0;
                int n8 = n6++;
                this.beta[n8] = this.beta[n8] * -1.0;
            }
            this.gamma = this.tp.getGammaArray(this.z);
            this.kd = this.tp.getKdArray(this.z, this.s);
            n2 = 0;
            while (n2 < this.nMeshPoints) {
                n = this.s.getHorizonIndex(this.z[n2]);
                this.rho[n2] = this.s.horizon[n].getBulkDensity();
                this.theta[n2] = this.s.horizon[n].getWaterContent(this.h[n2]);
                this.cumFluxChem[n2] = 0.0;
                ++n2;
            }
        }
        this.mp[0] = this.h[this.criticalNode];
        this.q[0] = this.flux1[this.criticalNode];
        if (this.ic.simChemical) {
            this.conc[0] = this.c[this.criticalNode];
            this.fluxChem[0] = 0.0;
            this.massChem[0] = this.getMassChemical();
        }
        this.time[0] = 0.0;
        this.nPointsSaved = 1;
        this.cumuInflux = 0.0;
    }

    public String simulate(double d) {
        String string = new String("");
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        double d2 = Math.abs(this.ic.h[0]) > 100.0 ? 0.01 * Math.abs(this.ic.h[0]) : 1.0;
        double d3 = this.dt;
        int n4 = 0;
        while (n4 < this.nMeshPoints) {
            this.lower[n4] = this.getWaterContent(this.s.getHorizonIndex(this.z[n4]), n4);
            ++n4;
        }
        n = 0;
        RichardsEqn.iterations = 0;
        int n5 = 0;
        while (n5 <= this.currentBC && bl) {
            this.bcWaterType = this.bc[n5].getWaterBCTypeAt0();
            this.bcWaterTypeAtL = this.bc[n5].getWaterBCTypeAtL();
            this.bcChemType = this.bc[n5].getChemBCTypeAt0();
            this.bcChemTypeAtL = this.bc[n5].getChemBCTypeAtL();
            if (this.bc[n5].getWaterBCTypeAt0() == 2) {
                this.bcWaterType = this.bc[n5].changeToPotAt0(this.h[0]) ? 0 : 1;
            } else if (this.bc[n5].getWaterBCTypeAt0() == 7) {
                this.bcWaterType = this.bc[n5].changeToFluxAt0(this.bc[n5].getPotentialAt0()) ? 1 : 0;
            }
            double d4 = d > this.bc[n5].getTimeEnd() ? this.bc[n5].getTimeEnd() : d;
            while (bl && this.t < d4 - 0.01 * this.dt) {
                if (++n3 == 100) {
                    MainScreenPanel.lMessage1.setText("t=" + Tools.formatDouble(this.t, 5, 5));
                    n3 = 0;
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (RichardsEqn.stop) {
                    RichardsEqn.criticalTime = this.t;
                    return new String("Abort");
                }
                if (d4 - this.t < this.dt) {
                    this.dt = d4 - this.t;
                } else if (n > 0 && n2 > 16) {
                    n2 = 0;
                    --n;
                    this.dt *= 2.0;
                }
                this.convergenceFailureIndex = 0;
                bl = this.solveRichardsEqnMB(n5);
                while (!bl && this.convergenceFailureIndex == 0 && n < 16) {
                    this.dt /= 2.0;
                    ++n;
                    n2 = 0;
                    bl = this.solveRichardsEqnMB(n5);
                }
                if (!bl) continue;
                ++n2;
                n4 = 0;
                while (n4 < this.nMeshPoints) {
                    this.flux0[n4] = this.flux1[n4];
                    this.flux1[n4] = this.getFluxWater(n4, n5);
                    ++n4;
                }
                n4 = 0;
                while (n4 < this.nMeshPoints) {
                    int n6 = n4;
                    this.cumFluxWater[n6] = this.cumFluxWater[n6] + this.flux1[n4] * this.dt;
                    ++n4;
                }
                this.cumuInflux += (this.getFluxWater(0, n5) - this.getFluxWater(this.nMeshPoints - 1, n5)) * this.dt;
                this.storageIncrease = this.calcWaterStorage();
                this.t += this.dt;
                if (!this.ic.isFinite && Math.abs(this.h[this.nMeshPoints - 10] - this.ic.h[0]) > d2) {
                    this.nMeshPoints += 10;
                    if (this.nMeshPoints >= 500) {
                        string = new String("Maximum number of mesh points was exceeded at t = " + Tools.formatDouble(this.t, 4, 4) + " hr");
                        break;
                    }
                }
                if (this.bc[n5].getWaterBCTypeAt0() == 2) {
                    this.bcWaterType = this.bc[n5].changeToPotAt0(this.h[0]) ? 0 : 1;
                } else if (this.bc[n5].getWaterBCTypeAt0() == 7) {
                    if (this.bc[n5].changeToFluxAt0(this.h[0])) {
                        this.bcWaterType = 1;
                    } else {
                        this.bcWaterType = 0;
                        this.bc[n5].setFallingHeadPotentialAt0(this.h[0] - this.getFluxWater(0, n5) * this.dt);
                    }
                }
                if (this.ic.simChemical) {
                    this.cOld[0] = this.c[0];
                    this.cOld[1] = this.c[1];
                    this.solveCDE(n5, this.dt, this.theta, this.theta0, this.flux1, this.flux0);
                    n4 = 0;
                    while (n4 < this.nMeshPoints) {
                        int n7 = n4;
                        this.cumFluxChem[n7] = this.cumFluxChem[n7] + this.dt * this.getFluxDensityChemical(n4, n5);
                        ++n4;
                    }
                }
                this.storeData(this.t, this.criticalNode, n5, d3);
            }
            this.dt = d3;
            ++n5;
        }
        MainScreenPanel.lMessage1.setVisible(false);
        return string.length() > 0 ? string : (bl ? "true" : "false");
    }

    private boolean solveRichardsEqnMB(int n) {
        int n2;
        int n3 = 0;
        double d = 0.0;
        double[] dArray = new double[502];
        double[] dArray2 = new double[502];
        double[] dArray3 = new double[502];
        if (this.bcWaterType == 0) {
            this.h[0] = this.bc[n].getPotentialAt0();
        }
        if (this.bcWaterTypeAtL == 0) {
            this.h[this.nMeshPoints - 1] = this.bc[n].getPotentialAtL();
        }
        int n4 = 0;
        while (n4 < this.nMeshPoints) {
            n2 = this.s.getHorizonIndex(this.z[n4]);
            dArray3[n4] = this.h[n4];
            this.theta0[n4] = this.s.horizon[n2].getWaterContent(dArray3[n4]);
            if (Double.isNaN(this.theta0[n4])) {
                this.convergenceFailureIndex = 1;
                return false;
            }
            this.theta[n4] = this.theta0[n4];
            this.k[n4] = this.s.horizon[n2].getK(this.h[n4]);
            if (Double.isNaN(this.k[n4])) {
                this.convergenceFailureIndex = 1;
                return false;
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < this.nMeshPoints - 1) {
            this.k[n4] = (this.k[n4] + this.k[n4 + 1]) / 2.0;
            ++n4;
        }
        n4 = 0;
        while (n4 < this.z.length - 1) {
            dArray[n4] = this.z[n4 + 1] - this.z[n4];
            ++n4;
        }
        n4 = 1;
        while (n4 < this.z.length - 1) {
            dArray2[n4] = (this.z[n4 + 1] - this.z[n4 - 1]) * 0.5;
            ++n4;
        }
        this.converged = false;
        while (!this.converged && n3 < 10) {
            ++RichardsEqn.iterations;
            n4 = 0;
            while (n4 < this.nMeshPoints) {
                n2 = this.s.getHorizonIndex(this.z[n4]);
                this.wCap[n4] = this.s.horizon[n2].wc.getWaterCapacity(this.h[n4]);
                if (Double.isNaN(this.wCap[n4])) {
                    this.convergenceFailureIndex = 1;
                    return false;
                }
                ++n4;
            }
            n4 = 1;
            while (n4 < this.nMeshPoints - 1) {
                this.diag[n4] = this.wCap[n4] / this.dt + (this.k[n4 - 1] / dArray[n4 - 1] + this.k[n4] / dArray[n4]) / dArray2[n4];
                this.lower[n4] = -this.k[n4 - 1] / (dArray[n4 - 1] * dArray2[n4]);
                this.upper[n4] = -this.k[n4] / (dArray[n4] * dArray2[n4]);
                this.rhs[n4] = this.wCap[n4] * this.h[n4] / this.dt + (this.k[n4 - 1] - this.k[n4]) * this.sinAngle / dArray2[n4] - (this.theta[n4] - this.theta0[n4]) / this.dt;
                ++n4;
            }
            if (this.bcWaterType == 0) {
                this.diag[0] = 1.0;
                this.upper[0] = 0.0;
                this.rhs[0] = this.h[0];
            } else if (this.bcWaterType == 1) {
                this.diag[0] = this.wCap[0] / this.dt + 2.0 * this.k[0] / (dArray[0] * dArray[0]);
                this.upper[0] = -(2.0 * this.k[0] / (dArray[0] * dArray[0]));
                this.rhs[0] = this.h[0] * this.wCap[0] / this.dt + 2.0 * (this.bc[n].getFluxAt0() - this.k[0] * this.sinAngle) / dArray[0] - (this.theta[0] - this.theta0[0]) / this.dt;
            }
            if (this.bcWaterTypeAtL == 0 || this.bcWaterTypeAtL == -1) {
                this.lower[this.nMeshPoints - 1] = 0.0;
                this.diag[this.nMeshPoints - 1] = 1.0;
                this.rhs[this.nMeshPoints - 1] = this.h[this.nMeshPoints - 1];
            }
            if (this.bcWaterTypeAtL == 1) {
                this.lower[this.nMeshPoints - 1] = -(2.0 * this.k[this.nMeshPoints - 2] / (dArray[this.nMeshPoints - 2] * dArray[this.nMeshPoints - 2]));
                this.diag[this.nMeshPoints - 1] = this.wCap[this.nMeshPoints - 1] / this.dt + 2.0 * this.k[this.nMeshPoints - 2] / (dArray[this.nMeshPoints - 2] * dArray[this.nMeshPoints - 2]);
                this.rhs[this.nMeshPoints - 1] = this.h[this.nMeshPoints - 1] * this.wCap[this.nMeshPoints - 1] / this.dt;
                int n5 = this.nMeshPoints - 1;
                this.rhs[n5] = this.rhs[n5] + 2.0 * (this.k[this.nMeshPoints - 2] * this.sinAngle - this.bc[n].getFluxAtL()) / dArray[this.nMeshPoints - 2];
                int n6 = this.nMeshPoints - 1;
                this.rhs[n6] = this.rhs[n6] - (this.theta[this.nMeshPoints - 1] - this.theta0[this.nMeshPoints - 1]) / this.dt;
            }
            if (this.bcWaterTypeAtL == 3) {
                this.lower[this.nMeshPoints - 1] = -(2.0 * this.k[this.nMeshPoints - 2] / (dArray[this.nMeshPoints - 2] * dArray[this.nMeshPoints - 2]));
                this.diag[this.nMeshPoints - 1] = this.wCap[this.nMeshPoints - 1] / this.dt + 2.0 * this.k[this.nMeshPoints - 2] / (dArray[this.nMeshPoints - 2] * dArray[this.nMeshPoints - 2]);
                this.rhs[this.nMeshPoints - 1] = this.h[this.nMeshPoints - 1] * this.wCap[this.nMeshPoints - 1] / this.dt;
                int n7 = this.nMeshPoints - 1;
                this.rhs[n7] = this.rhs[n7] + 2.0 * ((this.k[this.nMeshPoints - 2] - this.k[this.nMeshPoints - 1]) * this.sinAngle) / dArray[this.nMeshPoints - 2];
                int n8 = this.nMeshPoints - 1;
                this.rhs[n8] = this.rhs[n8] - (this.theta[this.nMeshPoints - 1] - this.theta0[this.nMeshPoints - 1]) / this.dt;
            }
            this.triDiagonalSolver(this.nMeshPoints, this.lower, this.diag, this.upper, this.rhs, this.h);
            ++n3;
            n4 = 0;
            while (n4 < this.nMeshPoints) {
                if (Double.isNaN(this.h[n4])) {
                    this.convergenceFailureIndex = 1;
                    return false;
                }
                n2 = this.s.getHorizonIndex(this.z[n4]);
                this.theta[n4] = this.s.horizon[n2].getWaterContent(this.h[n4]);
                if (Double.isNaN(this.theta[n4])) {
                    this.convergenceFailureIndex = 1;
                    return false;
                }
                this.k[n4] = this.s.horizon[n2].getK(this.h[n4]);
                if (Double.isNaN(this.k[n4])) {
                    this.convergenceFailureIndex = 1;
                    return false;
                }
                ++n4;
            }
            n4 = 0;
            while (n4 < this.nMeshPoints - 1) {
                this.k[n4] = (this.k[n4] + this.k[n4 + 1]) / 2.0;
                ++n4;
            }
            this.converged = true;
            this.criticalValue = this.convergenceCriteria / this.dt;
            n4 = 1;
            while (n4 < this.nMeshPoints - 1) {
                d = (this.k[n4] * (this.h[n4 + 1] - this.h[n4]) / dArray[n4] - this.k[n4 - 1] * (this.h[n4] - this.h[n4 - 1]) / dArray[n4 - 1]) / dArray2[n4];
                d -= (this.k[n4] - this.k[n4 - 1]) * this.sinAngle / dArray2[n4];
                if ((d -= (this.theta[n4] - this.theta0[n4]) / this.dt) > this.criticalValue) {
                    this.converged = false;
                    break;
                }
                ++n4;
            }
            if (this.converged) {
                if (this.bcWaterType == 0) {
                    d = 0.0;
                } else {
                    d = this.k[0] * (this.h[1] - this.h[0]) / (dArray[0] * dArray[0]) + (this.bc[n].getFluxAt0() - this.k[0] * this.sinAngle) / dArray[0];
                    d -= (this.theta[0] - this.theta0[0]) / (2.0 * this.dt);
                }
                if (d > this.criticalValue) {
                    this.converged = false;
                }
            }
            if (!this.converged) continue;
            if (this.bcWaterTypeAtL == 0 || this.bcWaterTypeAtL == -1) {
                d = 0.0;
            } else if (this.bcWaterTypeAtL == 1) {
                d = this.k[this.nMeshPoints - 2] * (this.h[this.nMeshPoints - 2] - this.h[this.nMeshPoints - 1]) / (dArray[this.nMeshPoints - 2] * dArray[this.nMeshPoints - 2]) + (this.k[this.nMeshPoints - 2] * this.sinAngle - this.bc[n].getFluxAtL()) / dArray[this.nMeshPoints - 2];
                d -= (this.theta[this.nMeshPoints - 1] - this.theta0[this.nMeshPoints - 1]) / (2.0 * this.dt);
            } else {
                d = this.k[this.nMeshPoints - 2] * (this.h[this.nMeshPoints - 2] - this.h[this.nMeshPoints - 1]) / (dArray[this.nMeshPoints - 2] * dArray[this.nMeshPoints - 2]) + (this.k[this.nMeshPoints - 2] * this.sinAngle - this.k[this.nMeshPoints - 1] * this.sinAngle) / dArray[this.nMeshPoints - 2];
                d -= (this.theta[this.nMeshPoints - 1] - this.theta0[this.nMeshPoints - 1]) / (2.0 * this.dt);
            }
            if (!(d > this.criticalValue)) continue;
            this.converged = false;
        }
        if (!this.converged) {
            int n9 = 0;
            while (n9 < this.nMeshPoints) {
                this.h[n9] = dArray3[n9];
                ++n9;
            }
        }
        return this.converged;
    }

    public int getNumberPoints() {
        return this.nMeshPoints;
    }

    public double getMeshSizeInTime() {
        return this.dt;
    }

    public double getMeshSizeInDistance() {
        return this.dz;
    }

    public double getConvergenceCriteria() {
        return this.convergenceCriteria;
    }

    public double getMaxAbsError() {
        return this.maxAbsError;
    }

    public double getMaxRelaError() {
        return this.maxRelaError;
    }

    public double getCriticalCumuFlux() {
        return this.criticalCumuFlux;
    }

    public double getWaterContent(int n, int n2) {
        return this.s.horizon[n].wc.getWC(this.h[n2]);
    }

    public int getClosestNode(double d) {
        int n = 1;
        while (this.z[n] < d) {
            ++n;
        }
        n = Math.abs(this.z[n] - d) < Math.abs(this.z[n - 1] - d) ? n : n - 1;
        return n;
    }

    public void triDiagonalSolver(int n, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5) {
        dArray3[n - 1] = 0.0;
        dArray3[0] = dArray3[0] / dArray2[0];
        dArray4[0] = dArray4[0] / dArray2[0];
        int n2 = 1;
        while (n2 < n) {
            int n3 = n2;
            dArray2[n3] = dArray2[n3] - dArray[n2] * dArray3[n2 - 1];
            int n4 = n2;
            dArray3[n4] = dArray3[n4] / dArray2[n2];
            dArray4[n2] = (dArray4[n2] - dArray[n2] * dArray4[n2 - 1]) / dArray2[n2];
            ++n2;
        }
        dArray5[n - 1] = dArray4[n - 1];
        n2 = n - 2;
        while (n2 >= 0) {
            dArray5[n2] = dArray4[n2] - dArray3[n2] * dArray5[n2 + 1];
            --n2;
        }
    }

    private void storeData(double d, int n, int n2, double d2) {
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        if (this.nPointsSaved < 5000) {
            double d6;
            double d7;
            if (n < this.nMeshPoints) {
                d7 = this.h[n];
                d6 = this.flux1[n];
                if (this.ic.simChemical) {
                    d3 = this.c[n];
                    d4 = this.getFluxDensityChemical(n, n2);
                    d5 = this.getMassChemical();
                }
            } else {
                d7 = this.h[this.nMeshPoints - 1];
                d6 = this.q[this.nMeshPoints - 1];
            }
            boolean bl = false;
            boolean bl2 = false;
            if (this.nPointsSaved > 1) {
                double d8 = d6 / this.s.getConductivity(this.z[n], d7);
                double d9 = this.q[this.nPointsSaved - 1] / this.s.getConductivity(this.z[n], this.mp[this.nPointsSaved - 1]);
                double d10 = this.q[this.nPointsSaved - 2] / this.s.getConductivity(this.z[n], this.mp[this.nPointsSaved - 2]);
                if (Math.abs(d7) <= 0.1 && Math.abs(d7 - this.mp[this.nPointsSaved - 1]) > 0.01 || Math.abs(d7) > 0.1 && Math.abs((d7 - this.mp[this.nPointsSaved - 1]) / d7) > 0.01 || Math.abs(d8) <= 0.1 && Math.abs(d8 - d9) > 0.01 || Math.abs(d8) > 0.1 && Math.abs((d8 - d9) / d8) > 0.01 || this.ic.simChemical && Math.abs(d3) <= 0.1 && Math.abs(d3 - this.conc[this.nPointsSaved - 1]) > 0.01 || this.ic.simChemical && Math.abs(d3) > 0.1 && Math.abs((d3 - this.conc[this.nPointsSaved - 1]) / d3) > 0.01 || this.ic.simChemical && Math.abs(d4) <= 0.1 && Math.abs(d4 - this.fluxChem[this.nPointsSaved - 1]) > 0.01 || this.ic.simChemical && Math.abs(d4) > 0.1 && Math.abs((d4 - this.fluxChem[this.nPointsSaved - 1]) / d4) > 0.01 || this.ic.simChemical && d5 <= 0.1 && Math.abs(d5 - this.massChem[this.nPointsSaved - 1]) > 0.01 || this.ic.simChemical && d5 > 0.1 && Math.abs((d5 - this.massChem[this.nPointsSaved - 1]) / d5) > 0.01 || d - this.time[this.nPointsSaved - 2] > 10.0 * d2) {
                    bl2 = true;
                }
                if (Math.abs(this.mp[this.nPointsSaved - 1]) <= 0.1 && Math.abs(this.mp[this.nPointsSaved - 2] - this.mp[this.nPointsSaved - 1]) > 0.01 || Math.abs(this.mp[this.nPointsSaved - 1]) > 0.1 && Math.abs((this.mp[this.nPointsSaved - 2] - this.mp[this.nPointsSaved - 1]) / this.mp[this.nPointsSaved - 1]) > 0.01 || Math.abs(d9) <= 0.1 && Math.abs(d10 - d9) > 0.01 || Math.abs(d9) > 0.1 && Math.abs((d10 - d9) / d9) > 0.01 || this.ic.simChemical && Math.abs(this.conc[this.nPointsSaved - 1]) <= 0.1 && Math.abs(this.conc[this.nPointsSaved - 2] - this.conc[this.nPointsSaved - 1]) > 0.01 || this.ic.simChemical && Math.abs(this.conc[this.nPointsSaved - 1]) > 0.1 && Math.abs((this.conc[this.nPointsSaved - 2] - this.conc[this.nPointsSaved - 1]) / this.conc[this.nPointsSaved - 1]) > 0.01 || this.ic.simChemical && Math.abs(this.fluxChem[this.nPointsSaved - 1]) <= 0.1 && Math.abs(this.fluxChem[this.nPointsSaved - 2] - this.fluxChem[this.nPointsSaved - 1]) > 0.01 || this.ic.simChemical && Math.abs(this.fluxChem[this.nPointsSaved - 1]) > 0.1 && Math.abs((this.fluxChem[this.nPointsSaved - 2] - this.fluxChem[this.nPointsSaved - 1]) / this.fluxChem[this.nPointsSaved - 1]) > 0.01 || this.ic.simChemical && this.massChem[this.nPointsSaved - 1] <= 0.1 && Math.abs(this.massChem[this.nPointsSaved - 2] - this.massChem[this.nPointsSaved - 1]) > 0.01 || this.ic.simChemical && this.massChem[this.nPointsSaved - 1] > 0.1 && Math.abs((this.massChem[this.nPointsSaved - 2] - this.massChem[this.nPointsSaved - 1]) / this.massChem[this.nPointsSaved - 1]) > 0.01 || this.time[this.nPointsSaved - 1] - this.time[this.nPointsSaved - 2] > 10.0 * d2) {
                    bl = true;
                }
                if (!bl && !bl2) {
                    --this.nPointsSaved;
                }
            } else {
                if (n == 0 || n == this.nMeshPoints - 1) {
                    this.mp[0] = this.h[n];
                    if (this.ic.simChemical) {
                        this.conc[0] = this.c[n];
                    }
                }
                if (n == 0) {
                    this.q[0] = d6;
                    if (this.ic.simChemical) {
                        this.fluxChem[0] = d4;
                    }
                }
            }
            this.time[this.nPointsSaved] = d;
            this.mp[this.nPointsSaved] = d7;
            this.q[this.nPointsSaved] = d6;
            if (this.ic.simChemical) {
                this.conc[this.nPointsSaved] = d3;
                this.fluxChem[this.nPointsSaved] = d4;
                this.massChem[this.nPointsSaved] = this.getMassChemical();
            }
            ++this.nPointsSaved;
        }
        this.time[this.nPointsSaved] = d;
    }

    private boolean solveCDE(int n, double d, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        double d2;
        double d3;
        double d4;
        double[] dArray5 = new double[500];
        double[] dArray6 = new double[500];
        double d5 = this.tp.getDiffusionCoef();
        double d6 = this.tp.getDispersivity();
        int n2 = 0;
        while (n2 < this.nMeshPoints) {
            d4 = this.s.getWaterContent(this.z[n2], 0.0);
            d3 = Math.pow(dArray2[n2], 2.3333333333333335) / (d4 * d4);
            d2 = d5 * d3 + d6 * Math.abs(dArray4[n2] / dArray2[n2]);
            dArray5[n2] = d2 * dArray2[n2] + dArray4[n2] * dArray4[n2] * d / (6.0 * (dArray2[n2] + this.rho[n2] * this.kd[n2]));
            dArray6[n2] = 1.0 + this.rho[n2] * this.kd[n2] / dArray2[n2];
            ++n2;
        }
        n2 = 1;
        while (n2 < this.nMeshPoints - 1) {
            this.upper[n2] = (dArray5[n2] + dArray5[n2 + 1]) / ((this.z[n2 + 1] - this.z[n2 - 1]) * (this.z[n2 + 1] - this.z[n2]));
            int n3 = n2;
            this.upper[n3] = this.upper[n3] - (dArray4[n2] + 2.0 * dArray4[n2 + 1]) / (3.0 * (this.z[n2 + 1] - this.z[n2 - 1]));
            int n4 = n2;
            this.upper[n4] = this.upper[n4] + (this.alpha[n2] * dArray2[n2] + this.rho[n2] * this.beta[n2] * this.kd[n2] + this.alpha[n2 + 1] * dArray2[n2 + 1] + this.rho[n2 + 1] * this.beta[n2 + 1] * this.kd[n2 + 1]) / 12.0;
            int n5 = n2;
            this.upper[n5] = this.upper[n5] / 2.0;
            this.lower[n2] = (dArray5[n2] + dArray5[n2 - 1]) / ((this.z[n2 + 1] - this.z[n2 - 1]) * (this.z[n2] - this.z[n2 - 1]));
            int n6 = n2;
            this.lower[n6] = this.lower[n6] + (dArray4[n2] + 2.0 * dArray4[n2 - 1]) / (3.0 * (this.z[n2 + 1] - this.z[n2 - 1]));
            int n7 = n2;
            this.lower[n7] = this.lower[n7] + (this.alpha[n2] * dArray2[n2] + this.rho[n2] * this.beta[n2] * this.kd[n2] + this.alpha[n2 - 1] * dArray2[n2 - 1] + this.rho[n2 - 1] * this.beta[n2 - 1] * this.kd[n2 - 1]) / 12.0;
            int n8 = n2;
            this.lower[n8] = this.lower[n8] / 2.0;
            this.diag[n2] = -((dArray5[n2] + dArray5[n2 + 1]) / ((this.z[n2 + 1] - this.z[n2 - 1]) * (this.z[n2 + 1] - this.z[n2])) + (dArray5[n2] + dArray5[n2 - 1]) / ((this.z[n2 + 1] - this.z[n2 - 1]) * (this.z[n2] - this.z[n2 - 1])));
            int n9 = n2;
            this.diag[n9] = this.diag[n9] - (dArray4[n2 + 1] - dArray4[n2 - 1]) / (3.0 * (this.z[n2 + 1] - this.z[n2 - 1]));
            int n10 = n2;
            this.diag[n10] = this.diag[n10] + ((this.alpha[n2 + 1] * dArray2[n2 + 1] + this.rho[n2 + 1] * this.beta[n2 + 1] * this.kd[n2 + 1] + this.alpha[n2 - 1] * dArray2[n2 - 1] + this.rho[n2 - 1] * this.beta[n2 - 1] * this.kd[n2 - 1]) / 12.0 + (this.alpha[n2] * dArray2[n2] + this.rho[n2] * this.beta[n2] * this.kd[n2]) / 2.0);
            int n11 = n2;
            this.diag[n11] = this.diag[n11] / 2.0;
            int n12 = n2;
            this.diag[n12] = this.diag[n12] + dArray2[n2] * dArray6[n2] / d;
            this.rhs[n2] = this.c[n2 + 1] * this.upper[n2] + this.c[n2] * this.diag[n2] + this.c[n2 - 1] * this.lower[n2] + this.gamma[n2] * (dArray[n2] + dArray2[n2]) / 2.0;
            ++n2;
        }
        if (this.bcChemType == 5) {
            this.rhs[0] = this.bc[n].getConcAt0();
        } else if (this.bcChemType == 4) {
            this.diag[0] = dArray2[0] * dArray6[0] / d + 1.0 / (this.z[1] - this.z[0]) * (-(dArray5[0] + dArray5[1]) / (2.0 * (this.z[1] - this.z[0])) - (2.0 * dArray4[0] + dArray4[1]) / 6.0);
            this.diag[0] = this.diag[0] + (3.0 * (this.alpha[0] * dArray2[0] + this.beta[0] * this.rho[0] * this.kd[0]) + (this.alpha[1] * dArray2[1] + this.beta[1] * this.rho[1] * this.kd[1])) / 12.0;
            this.upper[0] = 1.0 / (this.z[1] - this.z[0]) * ((dArray5[0] + dArray5[1]) / (2.0 * (this.z[1] - this.z[0])) - (dArray4[0] + 2.0 * dArray4[1]) / 6.0);
            this.upper[0] = this.upper[0] + (this.alpha[0] * dArray2[0] + this.beta[0] * this.rho[0] * this.kd[0] + (this.alpha[1] * dArray2[1] + this.beta[1] * this.rho[1] * this.kd[1])) / 12.0;
            this.rhs[0] = this.c[0] * this.diag[0] + this.c[1] * this.upper[0] + this.gamma[0] * (dArray2[0] + dArray[0]) / 2.0;
            if (dArray4[0] > 0.0 && dArray3[0] > 0.0) {
                this.rhs[0] = this.rhs[0] + (dArray4[0] + dArray3[0]) * this.bc[n].getConcAt0() / (this.z[1] - this.z[0]);
            }
        }
        int n13 = this.nMeshPoints - 1;
        if (this.bcChemTypeAtL == 6) {
            this.diag[n13] = dArray2[n13] * dArray6[n13] / d - 1.0 / (this.z[n13] - this.z[n13 - 1]) * (dArray4[n13] + (dArray5[n13] + dArray5[n13 - 1]) / (2.0 * (this.z[n13] - this.z[n13 - 1])) - (2.0 * dArray4[n13] + dArray4[n13 - 1]) / 6.0);
            int n14 = n13;
            this.diag[n14] = this.diag[n14] + (3.0 * (this.alpha[n13] * dArray2[n13] + this.beta[n13] * this.rho[n13] * this.kd[n13]) + (this.alpha[n13 - 1] * dArray2[n13 - 1] + this.beta[n13 - 1] * this.rho[n13 - 1] * this.kd[n13 - 1])) / 12.0;
            this.lower[n13] = -(1.0 / (this.z[n13] - this.z[n13 - 1])) * (-(dArray5[n13] + dArray5[n13 - 1]) / (2.0 * (this.z[n13] - this.z[n13 - 1])) - (dArray4[n13] + 2.0 * dArray4[n13 - 1]) / 6.0);
            int n15 = n13;
            this.lower[n15] = this.lower[n15] + (this.alpha[n13] * dArray2[n13] + this.beta[n13] * this.rho[n13] * this.kd[n13] + (this.alpha[n13 - 1] * dArray2[n13 - 1] + this.beta[n13 - 1] * this.rho[n13 - 1] * this.kd[n13 - 1])) / 12.0;
            this.rhs[n13] = this.c[n13] * this.diag[n13] + this.c[n13 - 1] * this.lower[n13] + this.gamma[n13] * (dArray2[n13] + dArray[n13]) / 2.0;
        } else {
            this.rhs[n13] = this.bc[n].getConcAtL();
        }
        n2 = 0;
        while (n2 < this.nMeshPoints) {
            d4 = this.s.getWaterContent(this.z[n2], 0.0);
            d3 = Math.pow(dArray[n2], 2.3333333333333335) / (d4 * d4);
            d2 = d5 * d3 + d6 * Math.abs(dArray3[n2] / dArray[n2]);
            dArray5[n2] = d2 * dArray[n2] - dArray3[n2] * dArray3[n2] * d / (6.0 * (dArray[n2] + this.rho[n2] * this.kd[n2]));
            dArray6[n2] = 1.0 + this.rho[n2] * this.kd[n2] / dArray[n2];
            ++n2;
        }
        n2 = 1;
        while (n2 < this.nMeshPoints - 1) {
            this.lower[n2] = (dArray5[n2] + dArray5[n2 - 1]) / ((this.z[n2 + 1] - this.z[n2 - 1]) * (this.z[n2] - this.z[n2 - 1]));
            int n16 = n2;
            this.lower[n16] = this.lower[n16] + (dArray3[n2] + 2.0 * dArray3[n2 - 1]) / (3.0 * (this.z[n2 + 1] - this.z[n2 - 1]));
            int n17 = n2;
            this.lower[n17] = this.lower[n17] + (this.alpha[n2] * dArray[n2] + this.rho[n2] * this.beta[n2] * this.kd[n2] + this.alpha[n2 - 1] * dArray[n2 - 1] + this.rho[n2 - 1] * this.beta[n2 - 1] * this.kd[n2 - 1]) / 12.0;
            int n18 = n2;
            this.lower[n18] = this.lower[n18] / -2.0;
            this.upper[n2] = -((dArray5[n2] + dArray5[n2 + 1]) / ((this.z[n2 + 1] - this.z[n2 - 1]) * (this.z[n2 + 1] - this.z[n2])));
            int n19 = n2;
            this.upper[n19] = this.upper[n19] + (dArray3[n2] + 2.0 * dArray3[n2 + 1]) / (3.0 * (this.z[n2 + 1] - this.z[n2 - 1]));
            int n20 = n2;
            this.upper[n20] = this.upper[n20] - (this.alpha[n2] * dArray[n2] + this.rho[n2] * this.beta[n2] * this.kd[n2] + this.alpha[n2 + 1] * dArray[n2 + 1] + this.rho[n2 + 1] * this.beta[n2 + 1] * this.kd[n2 + 1]) / 12.0;
            int n21 = n2;
            this.upper[n21] = this.upper[n21] / 2.0;
            this.diag[n2] = (dArray5[n2] + dArray5[n2 + 1]) / ((this.z[n2 + 1] - this.z[n2 - 1]) * (this.z[n2 + 1] - this.z[n2])) + (dArray5[n2] + dArray5[n2 - 1]) / ((this.z[n2 + 1] - this.z[n2 - 1]) * (this.z[n2] - this.z[n2 - 1]));
            int n22 = n2;
            this.diag[n22] = this.diag[n22] + (dArray3[n2 + 1] - dArray3[n2 - 1]) / (3.0 * (this.z[n2 + 1] - this.z[n2 - 1]));
            int n23 = n2;
            this.diag[n23] = this.diag[n23] - ((this.alpha[n2 + 1] * dArray[n2 + 1] + this.rho[n2 + 1] * this.beta[n2 + 1] * this.kd[n2 + 1] + this.alpha[n2 - 1] * dArray[n2 - 1] + this.rho[n2 - 1] * this.beta[n2 - 1] * this.kd[n2 - 1]) / 12.0 + (this.alpha[n2] * dArray[n2] + this.rho[n2] * this.beta[n2] * this.kd[n2]) / 2.0);
            int n24 = n2;
            this.diag[n24] = this.diag[n24] / 2.0;
            int n25 = n2;
            this.diag[n25] = this.diag[n25] + dArray[n2] * dArray6[n2] / d;
            ++n2;
        }
        if (this.bcChemType == 5) {
            this.diag[0] = 1.0;
            this.upper[0] = 0.0;
        } else if (this.bcChemType == 4) {
            this.diag[0] = dArray[0] * dArray6[0] / d;
            this.diag[0] = this.diag[0] - 1.0 / (this.z[1] - this.z[0]) * (-(dArray5[0] + dArray5[1]) / (2.0 * (this.z[1] - this.z[0])) - (2.0 * dArray3[0] + dArray3[1]) / 6.0);
            this.diag[0] = this.diag[0] - (3.0 * (this.alpha[0] * dArray[0] + this.beta[0] * this.rho[0] * this.kd[0]) + (this.alpha[1] * dArray[1] + this.beta[1] * this.rho[1] * this.kd[1])) / 12.0;
            this.upper[0] = -1.0 / (this.z[1] - this.z[0]) * ((dArray5[0] + dArray5[1]) / (2.0 * (this.z[1] - this.z[0])) - (dArray3[0] + 2.0 * dArray3[1]) / 6.0);
            this.upper[0] = this.upper[0] - (this.alpha[0] * dArray[0] + this.beta[0] * this.rho[0] * this.kd[0] + (this.alpha[1] * dArray[1] + this.beta[1] * this.rho[1] * this.kd[1])) / 12.0;
        }
        if (this.bcChemTypeAtL == 6) {
            this.diag[n13] = dArray[n13] * dArray6[n13] / d + 1.0 / (this.z[n13] - this.z[n13 - 1]) * (dArray3[n13] + (dArray5[n13] + dArray5[n13 - 1]) / (2.0 * (this.z[n13] - this.z[n13 - 1])) - (2.0 * dArray3[n13] + dArray3[n13 - 1]) / 6.0);
            int n26 = n13;
            this.diag[n26] = this.diag[n26] - (3.0 * (this.alpha[n13] * dArray[n13] + this.beta[n13] * this.rho[n13] * this.kd[n13]) + (this.alpha[n13 - 1] * dArray[n13 - 1] + this.beta[n13 - 1] * this.rho[n13 - 1] * this.kd[n13 - 1])) / 12.0;
            this.lower[n13] = 1.0 / (this.z[n13] - this.z[n13 - 1]) * (-(dArray5[n13] + dArray5[n13 - 1]) / (2.0 * (this.z[n13] - this.z[n13 - 1])) - (dArray3[n13] + 2.0 * dArray3[n13 - 1]) / 6.0);
            int n27 = n13;
            this.lower[n27] = this.lower[n27] - (this.alpha[n13] * dArray[n13] + this.beta[n13] * this.rho[n13] * this.kd[n13] + (this.alpha[n13 - 1] * dArray[n13 - 1] + this.beta[n13 - 1] * this.rho[n13 - 1] * this.kd[n13 - 1])) / 12.0;
        } else {
            this.diag[n13] = 1.0;
            this.lower[n13] = 0.0;
        }
        this.triDiagonalSolver(this.nMeshPoints, this.lower, this.diag, this.upper, this.rhs, this.c);
        return true;
    }

    private double getFluxDensityChemical(int n, int n2) {
        double d;
        int n3 = this.s.getHorizonIndex(this.z[n]);
        double d2 = this.flux1[n];
        double d3 = this.theta[n];
        double d4 = this.s.horizon[n3].getWaterContent(0.0);
        double d5 = Math.pow(d3, 2.3333333333333335) / (d4 * d4);
        double d6 = this.tp.getDiffusionCoef() * d5 + this.tp.getDispersivity() * Math.abs(d2 / d3);
        if (n == 0) {
            if (this.bcChemType == 4) {
                d = d2 * this.bc[n2].getConcAt0();
            } else {
                d = -d3 * d6 * ((this.c[1] - this.c[0]) / (this.z[1] - this.z[0])) + d2 * this.c[0];
                double d7 = (this.z[1] - this.z[0]) * this.gamma[0] / 16.0 * (3.0 * (this.theta[0] + this.theta0[0]) + this.theta[1] + this.theta0[1]);
                double d8 = 3.0 * (this.alpha[0] * this.theta0[0] + this.beta[0] * this.rho[0] * this.kd[0]) * this.cOld[0] + (this.alpha[1] * this.theta0[1] + this.beta[1] * this.rho[1] * this.kd[1]) * this.cOld[1];
                d8 += 3.0 * (this.alpha[0] * this.theta[0] + this.beta[0] * this.rho[0] * this.kd[0]) * this.c[0] + (this.alpha[1] * this.theta[1] + this.beta[1] * this.rho[1] * this.kd[1]) * this.c[1];
                double d9 = 3.0 * (this.theta[0] + this.rho[0] * this.kd[0]) * this.c[0] + (this.theta[1] + this.rho[1] * this.kd[1]) * this.c[1];
                d9 -= 3.0 * (this.theta0[0] + this.rho[0] * this.kd[0]) * this.cOld[0] + (this.theta0[1] + this.rho[1] * this.kd[1]) * this.cOld[1];
                d += (d9 *= (this.z[1] - this.z[0]) / (16.0 * this.dt)) + (d8 *= (this.z[1] - this.z[0]) / 16.0) - d7;
            }
        } else {
            d = n == this.nMeshPoints - 1 ? -d3 * d6 * ((this.c[n] - this.c[n - 1]) / (this.z[n] - this.z[n - 1])) + d2 * this.c[n] : -d3 * d6 * ((this.c[n + 1] - this.c[n - 1]) / (this.z[n + 1] - this.z[n - 1])) + d2 * this.c[n];
        }
        return d / 100.0;
    }

    private double getMassChemical() {
        double[] dArray = new double[this.nMeshPoints];
        int n = 0;
        while (n < this.nMeshPoints) {
            dArray[n] = (this.s.getWaterContent(this.z[n], this.h[n]) + this.rho[n] * this.kd[n]) * this.c[n];
            ++n;
        }
        return Tools.integrateTrapezoidal(this.nMeshPoints, this.z, dArray) / 100.0;
    }

    private double getFluxWater(int n, int n2) {
        double d = 0.0;
        if (n == 0) {
            d = this.bcWaterType == 1 ? this.bc[n2].getFluxAt0() : -0.5 * (this.s.getConductivity(this.z[0], this.h[0]) + this.s.getConductivity(this.z[1], this.h[1])) * ((this.h[1] - this.h[0]) / (this.z[1] - this.z[0]) - this.sinAngle);
        } else if (n == this.nMeshPoints - 1) {
            d = this.bcWaterTypeAtL == 1 ? this.bc[n2].getFluxAtL() : (this.bcWaterTypeAtL == 3 ? this.s.getConductivity(this.z[n], this.h[n]) : -0.5 * (this.s.getConductivity(this.z[n], this.h[n]) + this.s.getConductivity(this.z[n - 1], this.h[n - 1])) * ((this.h[n] - this.h[n - 1]) / (this.z[n] - this.z[n - 1]) - this.sinAngle));
        } else {
            double d2 = -0.5 * (this.s.getConductivity(this.z[n], this.h[n]) + this.s.getConductivity(this.z[n - 1], this.h[n - 1])) * ((this.h[n] - this.h[n - 1]) / (this.z[n] - this.z[n - 1]) - this.sinAngle);
            double d3 = -0.5 * (this.s.getConductivity(this.z[n], this.h[n]) + this.s.getConductivity(this.z[n + 1], this.h[n + 1])) * ((this.h[n + 1] - this.h[n]) / (this.z[n + 1] - this.z[n]) - this.sinAngle);
            d = (d2 * (this.z[n + 1] - this.z[n]) + d3 * (this.z[n] - this.z[n - 1])) / (this.z[n + 1] - this.z[n - 1]);
        }
        return d;
    }

    double calcWaterStorage() {
        double d = 0.0;
        int n = 0;
        while (n < this.nMeshPoints - 1) {
            double d2 = this.ic.isFinite ? 0.5 * (this.theta[n] - this.initWaterContent[n] + (this.theta[n + 1] - this.initWaterContent[n + 1])) : 0.5 * (this.theta[n] - this.initWC + (this.theta[n + 1] - this.initWC));
            d += d2 * (this.z[n + 1] - this.z[n]);
            ++n;
        }
        return d;
    }
}

