/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ProgressMonitor;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;

public class SaveTableDialog
extends JDialog {
    private JLabel fTitle;
    private JLabel fNameLb;
    private Border oldBorder;
    private BevelBorder raisedEdge = new BevelBorder(0);
    private JButton okBnt;
    private JButton cancelBnt;
    JPanel frame = new JPanel();
    preparTableRunnable runnable;
    ProgressMonitor monitor;
    private int orient = 1;
    int min = 0;
    int max = 0;
    String[] message = new String[2];
    BufferedWriter bufferedWriter;

    public SaveTableDialog(int n) {
        super(new JFrame(), "Save the output in file", true);
        this.setSize(250, 180);
        this.getContentPane().setLayout(new BorderLayout());
        this.bufferedWriter = CHEMFLO.getBufferedWriter();
        this.message[0] = "Prepare the output data.";
        this.message[1] = "This may take some time...";
        this.max = n + 4;
        this.monitor = new ProgressMonitor(this.frame, this.message, "", this.min, this.max);
        this.monitor.setMillisToPopup(50);
        FileNameFieldPanel fileNameFieldPanel = new FileNameFieldPanel();
        BntPanel bntPanel = new BntPanel();
        this.getContentPane().add((Component)fileNameFieldPanel, "Center");
        this.getContentPane().add((Component)bntPanel, "South");
        Toolkit toolkit = this.getToolkit();
        Dimension dimension = toolkit.getScreenSize();
        this.setLocation(dimension.width - this.getSize().width >> 1, dimension.height - this.getSize().height >> 1);
        if (this.bufferedWriter != null) {
            this.show();
        } else {
            this.dispose();
        }
    }

    class preparTableRunnable
    implements Runnable {
        int sleepTime;

        public preparTableRunnable(int n) {
            this.sleepTime = n;
        }

        public void run() {
            try {
                SaveTableDialog.this.monitor.setNote("Prepare Table Column Names");
                Thread.sleep(this.sleepTime);
                CHEMFLO.reportPane.prepareTableNames();
                Thread.sleep(this.sleepTime);
                SaveTableDialog.this.monitor.setProgress(1);
                if (SaveTableDialog.this.monitor.isCanceled()) {
                    SaveTableDialog.this.monitor.setProgress(SaveTableDialog.this.max);
                    RichardsEqn.stop = true;
                    return;
                }
                SaveTableDialog.this.monitor.setNote("Prepare Table Data");
                CHEMFLO.reportPane.prepareTableDataForOutput(SaveTableDialog.this.monitor, 1);
                Thread.sleep(this.sleepTime);
                SaveTableDialog.this.monitor.setProgress(SaveTableDialog.this.max - 2);
                if (SaveTableDialog.this.monitor.isCanceled()) {
                    SaveTableDialog.this.monitor.setProgress(SaveTableDialog.this.max);
                    RichardsEqn.stop = true;
                    return;
                }
                SaveTableDialog.this.monitor.setNote("Save Data");
                SaveTableData saveTableData = new SaveTableData();
                SaveTableDialog.this.monitor.setProgress(SaveTableDialog.this.max - 1);
                Thread.sleep(this.sleepTime);
                if (SaveTableDialog.this.monitor.isCanceled()) {
                    SaveTableDialog.this.monitor.setProgress(SaveTableDialog.this.max);
                    RichardsEqn.stop = true;
                    return;
                }
                try {
                    if (!RichardsEqn.stop) {
                        saveTableData.saveData(SaveTableDialog.this.bufferedWriter);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                SaveTableDialog.this.monitor.setProgress(SaveTableDialog.this.max);
                Thread.sleep(this.sleepTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            SaveTableDialog.this.monitor.close();
        }
    }

    class forEvent
    extends MouseAdapter
    implements ActionListener {
        String name = null;

        public forEvent() {
        }

        public forEvent(String string) {
            this.name = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.name.equals("OK")) {
                SaveTableDialog.this.runnable = new preparTableRunnable(500);
                Thread thread = new Thread(SaveTableDialog.this.runnable);
                thread.start();
                SaveTableDialog.this.setVisible(false);
                SaveTableDialog.this.dispose();
            }
            if (this.name.equals("Cancel")) {
                SaveTableDialog.this.setVisible(false);
                SaveTableDialog.this.dispose();
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (this.name.equals("OK")) {
                SaveTableDialog.this.okBnt.setBorder(SaveTableDialog.this.oldBorder);
            }
            if (this.name.equals("Cancel")) {
                SaveTableDialog.this.cancelBnt.setBorder(SaveTableDialog.this.oldBorder);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (this.name.equals("OK")) {
                SaveTableDialog.this.okBnt.setBorder(SaveTableDialog.this.raisedEdge);
            }
            if (this.name.equals("Cancel")) {
                SaveTableDialog.this.cancelBnt.setBorder(SaveTableDialog.this.raisedEdge);
            }
        }
    }

    class BntPanel
    extends JPanel {
        public BntPanel() {
            this.setPreferredSize(new Dimension(250, 50));
            this.setLayout(null);
            SaveTableDialog.this.okBnt = new JButton("OK");
            SaveTableDialog.this.okBnt.setBounds(25, 5, 90, 30);
            this.add(SaveTableDialog.this.okBnt);
            SaveTableDialog.this.cancelBnt = new JButton("Cancel");
            SaveTableDialog.this.cancelBnt.setBounds(135, 5, 90, 30);
            this.add(SaveTableDialog.this.cancelBnt);
            SaveTableDialog.this.oldBorder = SaveTableDialog.this.okBnt.getBorder();
            SaveTableDialog.this.okBnt.addMouseListener(new forEvent("OK"));
            SaveTableDialog.this.cancelBnt.addMouseListener(new forEvent("Cancel"));
            SaveTableDialog.this.okBnt.addActionListener(new forEvent("OK"));
            SaveTableDialog.this.cancelBnt.addActionListener(new forEvent("Cancel"));
        }
    }

    class FileNameFieldPanel
    extends JPanel {
        public FileNameFieldPanel() {
            this.setPreferredSize(new Dimension(250, 80));
            this.setLayout(null);
            SaveTableDialog.this.fTitle = new JLabel("The output data file name:", 0);
            SaveTableDialog.this.fTitle.setForeground(Color.black);
            SaveTableDialog.this.fTitle.setBounds(10, 15, 200, 20);
            SaveTableDialog.this.fNameLb = new JLabel(CHEMFLO.fileNameSaved, 0);
            SaveTableDialog.this.fNameLb.setForeground(Color.black);
            SaveTableDialog.this.fNameLb.setBounds(10, 45, 200, 20);
            this.add(SaveTableDialog.this.fTitle);
            this.add(SaveTableDialog.this.fNameLb);
        }
    }
}

