/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Image;

public class SimmonsWaterContent
extends WaterContent {
    double a;
    double satWC;
    double residualWC;
    double n;
    private static final Parameter alpha = new Parameter("Empirical Constant, \u03b1", 1.2, 1.15, 1.25, 2);
    private static final Parameter nConstant = new Parameter("Empirical Constant, n", 0.06, 0.025, 0.1, 3);
    private Image equationImage;

    public SimmonsWaterContent(double d, double d2, double d3, double d4, Image image) {
        this.satWC = d;
        this.residualWC = d2;
        this.a = d3;
        this.n = d4;
        this.equationImage = image;
    }

    public double getWC(double d) {
        double d2;
        if (d < 0.0) {
            d2 = this.a * this.satWC - this.n * Math.log(-d);
            if (this.residualWC > d2) {
                d2 = this.residualWC;
            } else if (this.satWC < d2) {
                d2 = this.satWC;
            }
        } else {
            d2 = this.satWC;
        }
        return d2;
    }

    public double getSatWC() {
        return this.satWC;
    }

    public double getResidualWC() {
        return this.residualWC;
    }

    public double getWaterCapacity(double d) {
        if (d >= -Math.exp((this.a - 1.0) * this.satWC / this.n) || d <= -Math.exp((this.a * this.satWC - this.residualWC) / this.n)) {
            return 0.0;
        }
        return -this.n / d;
    }

    public double getMatricPotential(double d) {
        double d2;
        if (d < this.residualWC) {
            d = this.residualWC;
            d2 = -Math.exp((this.a * this.satWC - this.residualWC) / this.n);
        } else if (d > this.satWC) {
            d = this.satWC;
            d2 = 0.0;
        } else {
            d2 = -Math.exp((this.a * this.satWC - d) / this.n);
        }
        return d2;
    }

    public String getName(int n) {
        String string;
        switch (n) {
            case 1: {
                string = alpha.getName();
                break;
            }
            case 2: {
                string = nConstant.getName();
                break;
            }
            case 3: {
                string = WaterContent.thetaSat.getName();
                break;
            }
            case 4: {
                string = WaterContent.thetaRes.getName();
                break;
            }
            default: {
                string = "IllegalIndex";
            }
        }
        return string;
    }

    public double getParamValue(int n) {
        double d;
        switch (n) {
            case 1: {
                d = this.a;
                break;
            }
            case 2: {
                d = this.n;
                break;
            }
            case 3: {
                d = this.satWC;
                break;
            }
            case 4: {
                d = this.residualWC;
                break;
            }
            default: {
                d = -999.0;
            }
        }
        return d;
    }

    public double getDefault(int n) {
        double d;
        switch (n) {
            case 1: {
                d = alpha.getDefaultValue();
                break;
            }
            case 2: {
                d = nConstant.getDefaultValue();
                break;
            }
            case 3: {
                d = WaterContent.thetaSat.getDefaultValue();
                break;
            }
            case 4: {
                d = WaterContent.thetaRes.getDefaultValue();
                break;
            }
            default: {
                d = -999.0;
            }
        }
        return d;
    }

    public double getLowerLimit(int n) {
        double d;
        switch (n) {
            case 1: {
                d = alpha.getLowerLimit();
                break;
            }
            case 2: {
                d = nConstant.getLowerLimit();
                break;
            }
            case 3: {
                d = WaterContent.thetaSat.getLowerLimit();
                break;
            }
            case 4: {
                d = WaterContent.thetaRes.getLowerLimit();
                break;
            }
            default: {
                d = -999999.0;
            }
        }
        return d;
    }

    public double getUpperLimit(int n) {
        double d;
        switch (n) {
            case 1: {
                d = alpha.getUpperLimit();
                break;
            }
            case 2: {
                d = nConstant.getUpperLimit();
                break;
            }
            case 3: {
                d = WaterContent.thetaSat.getUpperLimit();
                break;
            }
            case 4: {
                d = WaterContent.thetaRes.getUpperLimit();
                break;
            }
            default: {
                d = 999999.0;
            }
        }
        return d;
    }

    public int getDecimalDigits(int n) {
        int n2;
        switch (n) {
            case 1: {
                n2 = alpha.getDecimalDigits();
                break;
            }
            case 2: {
                n2 = nConstant.getDecimalDigits();
                break;
            }
            case 3: {
                n2 = WaterContent.thetaSat.getDecimalDigits();
                break;
            }
            case 4: {
                n2 = WaterContent.thetaRes.getDecimalDigits();
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return n2;
    }

    public String getErrorMessage(int n) {
        String string;
        switch (n) {
            case 1: {
                string = new String("Empirical Constant, \u03b1,");
                break;
            }
            case 2: {
                string = new String("Empirical constant, n");
                break;
            }
            case 3: {
                string = new String("Saturated Water Content");
                break;
            }
            case 4: {
                string = new String("Residual Water Content");
                break;
            }
            default: {
                string = new String("Program Error: This should never be shown.");
            }
        }
        string = new String(string + " is usually between " + Tools.formatDouble(this.getLowerLimit(n), this.getDecimalDigits(n), 0) + " and " + Tools.formatDouble(this.getUpperLimit(n), this.getDecimalDigits(n), 0));
        return string;
    }

    public Image getEquationImage() {
        return this.equationImage;
    }

    public void setParamValue(int n, double d) {
        switch (n) {
            case 1: {
                this.a = d;
                break;
            }
            case 2: {
                this.n = d;
                break;
            }
            case 3: {
                this.satWC = d;
                break;
            }
            case 4: {
                this.residualWC = d;
            }
        }
    }
}

