/*
 * Decompiled with CFR 0.152.
 */
public class Soil {
    public String name;
    public int nHorizons;
    public Horizon[] horizon;

    public Soil(String string, Horizon[] horizonArray) {
        this.name = string;
        this.nHorizons = horizonArray.length;
        this.horizon = horizonArray;
    }

    public Soil(String string, double d, double d2, double d3, WaterContent waterContent, Conductivity conductivity) {
        this.name = string;
        this.nHorizons = 1;
        this.horizon = new Horizon[this.nHorizons];
        this.horizon[0] = new Horizon(0.0, d, d2, d3, waterContent, conductivity);
    }

    public Soil(String string, double d, WaterContent waterContent, Conductivity conductivity) {
        this.name = string;
        this.nHorizons = 1;
        this.horizon = new Horizon[this.nHorizons];
        this.horizon[0] = new Horizon(d, waterContent, conductivity);
    }

    public double getLength() {
        double d = 0.0;
        int n = 0;
        while (n < this.nHorizons) {
            d += this.horizon[n].getLength();
            ++n;
        }
        return d;
    }

    public double getConductivity(double d, double d2) {
        return this.horizon[this.getHorizonIndex(d)].getK(d2);
    }

    public double getOrganicCarbon(double d) {
        return this.horizon[this.getHorizonIndex(d)].getOC();
    }

    public double getWaterContent(double d, double d2) {
        return this.horizon[this.getHorizonIndex(d)].getWaterContent(d2);
    }

    public int getHorizonIndex(double d) {
        int n = 0;
        n = 0;
        while (n < this.nHorizons) {
            if (this.horizon[n].depthBottom >= d) break;
            ++n;
        }
        int n2 = n < this.nHorizons ? n : this.nHorizons - 1;
        return n2;
    }

    public String displaySoil() {
        String string = new String(this.name + ":\r\n");
        int n = 0;
        while (n < this.nHorizons) {
            string = string + this.horizon[n].displayHorizon() + "\r\n";
            ++n;
        }
        return string;
    }
}

