/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class SoilFileIO {
    private String fname = "Soils.dat";
    private String str;
    private int readLineIdx = 0;
    public Vector soilList;
    public BufferedReader fin;
    public BufferedWriter fout;
    public Reader reader;
    private File file;
    private String[] exten = new String[]{"dat", "txt"};
    private boolean soilDataDir = false;

    SoilFileIO() {
        this.soilList = new Vector(100, 10);
    }

    public boolean makeSoilList(String string) {
        Object object;
        Object object2;
        boolean bl = false;
        int n = 1;
        Horizon[] horizonArray = new Horizon[5];
        Object object3 = null;
        int n2 = 0;
        double d = 0.0;
        this.readLineIdx = 0;
        if (!CHEMFLO.localSoilData) {
            try {
                object2 = this.getClass().getClassLoader();
                object = ((ClassLoader)object2).getResourceAsStream(string);
                this.reader = new InputStreamReader((InputStream)object, "latin1");
                this.fin = new BufferedReader(this.reader);
            }
            catch (IOException iOException) {
                System.out.println(iOException);
            }
        }
        try {
            while ((this.str = this.fin.readLine()) != null) {
                if (this.str.trim().length() == 0) {
                    ++n;
                    continue;
                }
                object2 = new StringTokenizer(this.str, ",");
                if (((StringTokenizer)object2).countTokens() != 14) {
                    JOptionPane.showMessageDialog(CHEMFLO.appWin, string + ", line " + n + ": Format error in soil parameters.\nThe old soil list were reloaded into the soil system.", "Error", 0);
                    return false;
                }
                try {
                    if (this.readLineIdx > 0) {
                        if (n2 == 0) {
                            object3 = ((StringTokenizer)object2).nextToken();
                            horizonArray[n2] = this.getHorizon(string, n, (StringTokenizer)object2, d);
                            if (horizonArray[n2] == null) {
                                return false;
                            }
                            ++n2;
                        } else {
                            object = ((StringTokenizer)object2).nextToken();
                            if (((String)object3).equals(object)) {
                                horizonArray[n2] = this.getHorizon(string, n, (StringTokenizer)object2, d += horizonArray[n2 - 1].getLength());
                                if (horizonArray[n2] == null) {
                                    return false;
                                }
                                ++n2;
                            } else {
                                this.addSoilObjToSoilList((String)object3, n2, horizonArray);
                                n2 = 0;
                                d = 0.0;
                                object3 = object;
                                horizonArray[n2] = this.getHorizon(string, n, (StringTokenizer)object2, d);
                                if (horizonArray[n2] == null) {
                                    return false;
                                }
                                ++n2;
                            }
                        }
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    noSuchElementException.printStackTrace();
                    return false;
                }
                ++n;
                ++this.readLineIdx;
            }
            this.fin.close();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(new JPanel(), string + ", line " + n + ": Unknown problem in the system's IO devices.\nThe old soil list were reloaded into the soil system.", "Error", 0);
            iOException.printStackTrace();
            return false;
        }
        this.addSoilObjToSoilList((String)object3, n2, horizonArray);
        this.soilDataDir = false;
        return true;
    }

    private void addSoilObjToSoilList(String string, int n, Horizon[] horizonArray) {
        Horizon[] horizonArray2 = new Horizon[n];
        int n2 = 0;
        while (n2 < n) {
            horizonArray2[n2] = horizonArray[n2];
            ++n2;
        }
        Soil soil = new Soil(string, horizonArray2);
        this.soilList.add(soil);
    }

    private Horizon getHorizon(String string, int n, StringTokenizer stringTokenizer, double d) {
        double d2;
        double d3;
        WaterContent waterContent;
        Conductivity conductivity;
        double d4;
        try {
            stringTokenizer.nextToken();
            d4 = Double.parseDouble(stringTokenizer.nextToken());
            String string2 = stringTokenizer.nextToken();
            double d5 = Double.parseDouble(stringTokenizer.nextToken());
            double d6 = Double.parseDouble(stringTokenizer.nextToken());
            double d7 = Double.parseDouble(stringTokenizer.nextToken());
            conductivity = RichardsEqn.getConductivityObj(string2, d5, d6, d7, null);
            String string3 = stringTokenizer.nextToken();
            double d8 = Double.parseDouble(stringTokenizer.nextToken());
            double d9 = Double.parseDouble(stringTokenizer.nextToken());
            double d10 = Double.parseDouble(stringTokenizer.nextToken());
            double d11 = Double.parseDouble(stringTokenizer.nextToken());
            waterContent = RichardsEqn.getWaterContentObj(string3, d8, d9, d10, d11, null);
            d3 = Double.parseDouble(stringTokenizer.nextToken());
            d2 = Double.parseDouble(stringTokenizer.nextToken());
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(new JPanel(), string + ", line " + n + ": Format error in soil parameters.\nThe old soil list were reloaded into the soil system.", "Error", 0);
            return null;
        }
        Horizon horizon = new Horizon(d, d + d4, d3, d2, waterContent, conductivity);
        return horizon;
    }

    public int getIndexOfSelectedSoil(String string) {
        int n = -9999;
        Soil soil = null;
        int n2 = 0;
        while (n2 < this.soilList.size()) {
            soil = (Soil)this.soilList.get(n2);
            if (string.trim().equals(soil.name.trim())) {
                n = n2;
                break;
            }
            ++n2;
        }
        return n;
    }

    public void saveCurrentSoil() {
        int n = this.getIndexOfSelectedSoil(RichardsEqn.currentSoilName);
        RichardsEqn.editingSoil.name = RichardsEqn.currentSoilName;
        this.soilList.set(n, RichardsEqn.editingSoil);
        RichardsEqn.currentSoilIndex = n;
    }

    public void saveNewSoil() {
        RichardsEqn.editingSoil.name = RichardsEqn.currentSoilName;
        this.soilList.add(RichardsEqn.editingSoil);
        RichardsEqn.currentSoilIndex = this.getIndexOfSelectedSoil(RichardsEqn.currentSoilName);
    }

    public boolean isDuplicateSoil(String string) {
        int n = 0;
        while (n < this.soilList.size()) {
            Soil soil = (Soil)this.soilList.get(n);
            if (string.trim().equals(soil.name.trim())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void writeToFile() {
        if (!this.soilDataDir) {
            JOptionPane.showMessageDialog(CHEMFLO.appWin, "Please select the location and file name for the soil database.", "Message", -1);
            CHEMFLO.appWin.repaint();
            this.fout = CHEMFLO.getBufferedWriter();
            if (this.fout == null) {
                return;
            }
            try {
                this.outputSoilFileTitle();
                int n = 0;
                while (n < this.soilList.size()) {
                    Soil soil = (Soil)this.soilList.get(n);
                    this.writeOneSoilToFile(soil);
                    ++n;
                }
                this.fout.flush();
                this.soilDataDir = true;
            }
            catch (IOException iOException) {
                System.out.println("Error writing to the soil data file. \n" + iOException);
            }
        } else {
            Soil soil = (Soil)this.soilList.lastElement();
            try {
                this.writeOneSoilToFile(soil);
                this.fout.flush();
            }
            catch (IOException iOException) {
                System.out.println("Error writing to the soil data file. \n" + iOException);
            }
        }
    }

    private void writeOneSoilToFile(Soil soil) throws IOException {
        String string = "";
        String string2 = "";
        int n = 0;
        while (n < soil.nHorizons) {
            string = RichardsEqn.getConductivityModel(soil.horizon[n].k);
            string2 = RichardsEqn.getWaterContentModel(soil.horizon[n].wc);
            this.fout.write(soil.name + ",");
            this.fout.write(String.valueOf(n + 1) + ",");
            this.fout.write(String.valueOf(soil.horizon[n].getLength()) + ",");
            this.fout.write(string + ",");
            this.fout.write(String.valueOf(soil.horizon[n].k.getParamValue(3)) + ",");
            this.fout.write(String.valueOf(soil.horizon[n].k.getParamValue(1)) + ",");
            this.fout.write(String.valueOf(soil.horizon[n].k.getParamValue(2)) + ",");
            this.fout.write(string2 + ",");
            this.fout.write(String.valueOf(soil.horizon[n].wc.getParamValue(3)) + ",");
            this.fout.write(String.valueOf(soil.horizon[n].wc.getParamValue(4)) + ",");
            this.fout.write(String.valueOf(soil.horizon[n].wc.getParamValue(1)) + ",");
            this.fout.write(String.valueOf(soil.horizon[n].wc.getParamValue(2)) + ",");
            this.fout.write(String.valueOf(soil.horizon[n].getBulkDensity()) + ",");
            this.fout.write(String.valueOf(soil.horizon[n].getOC()) + "\r\n");
            ++n;
        }
    }

    public void outputSoilFileTitle() {
        try {
            this.fout.write("SoilName,Layer,Thickness,K Model,Ks,K param#1,K param#2,WC Model,Sat WC,Res WC,WC param#1,WC param#2,BulkDensity,Organic Carbon\r\n");
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    public void deleteSoil(String string) {
        int n = -9999;
        int n2 = 0;
        while (n2 < this.soilList.size()) {
            Soil soil = (Soil)this.soilList.get(n2);
            if (string.trim().equals(soil.name.trim())) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n < 0) {
            JOptionPane.showMessageDialog(CHEMFLO.appWin, "The soil list is already empty.", "Error", 0);
            CHEMFLO.appWin.repaint();
            return;
        }
        this.soilList.remove(n);
    }
}

