/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;

public class SoilInterestPanel
extends ChemfloPanel {
    private JButton editBnt;
    private JButton deleteBnt;
    private BevelBorder raisedEdge = new BevelBorder(0);
    private Border oldBorder;
    private String[] conductivityStr = new String[3];
    private String[][] conductivityPara = new String[3][3];
    private String[] rententionStr = new String[3];
    private String[][] rententionPara = new String[3][4];
    static JTextField tfLength;
    static JTextField tfAlpha;
    public JLabel lLength;
    static JRadioButton cboxSemiInfinite;
    static JRadioButton cboxLength;
    static JScrollBar sbrAlpha;
    public JScrollBar sbrLength;
    private JLabel lAlpha;
    private FunctionFormPanel funcFormP;
    public JComboBox soilBox;
    private JLabel lMaxXtoPlot;
    private JTextField tfMaxXtoPlot;
    private JScrollBar sbrMaxXtoPlot;
    static JPanel centerP;
    private JScrollBar vsb;
    private JScrollBar hsb;
    private JScrollPane sclp;
    boolean errorFree = true;
    private int oldSoilIndex;
    private JPanel soilBoxPane;
    TitlePanel tbTitleP;
    FontMetrics fm;
    private int wid = 0;
    private int hgh = 0;
    private JPanel rootPane;
    private JPanel topPane;
    private JPanel northP;
    private JPanel southP;
    private JPanel westP;
    private JPanel eastP;
    public boolean finiteChanged;

    public SoilInterestPanel() {
        super("Select Soil of Interest");
        this.setLayout(this.border);
        this.setBorder(this.edge);
        this.add((Component)this.titleP, "North");
        if (CHEMFLO.wMax) {
            this.wid = CHEMFLO.old_width - 220;
            this.hgh = CHEMFLO.old_height - 140;
        } else {
            this.wid = 592;
            this.hgh = 470;
        }
        this.rootPane = new JPanel();
        this.rootPane.setLayout(new BorderLayout());
        this.rootPane.setPreferredSize(new Dimension(this.wid, this.hgh));
        this.northP = new JPanel();
        this.northP.setPreferredSize(new Dimension(this.wid, 1));
        this.southP = new JPanel();
        this.southP.setPreferredSize(new Dimension(this.wid, 1));
        this.westP = new JPanel();
        this.westP.setPreferredSize(new Dimension(1, 450));
        this.eastP = new JPanel();
        this.eastP.setPreferredSize(new Dimension(1, 450));
        this.topPane = new JPanel();
        this.topPane.setLayout(new BorderLayout());
        this.topPane.setPreferredSize(new Dimension(this.wid - 2, this.hgh - 2));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        UpLeftPanel upLeftPanel = new UpLeftPanel();
        jPanel.add(upLeftPanel);
        this.topPane.add((Component)jPanel, "North");
        this.funcFormP = new FunctionFormPanel();
        this.sclp = new JScrollPane(this.funcFormP);
        this.sclp.setHorizontalScrollBarPolicy(31);
        this.vsb = this.sclp.getVerticalScrollBar();
        this.hsb = this.sclp.getHorizontalScrollBar();
        this.vsb.addAdjustmentListener(new forEvent("VscrollBar"));
        this.hsb.addAdjustmentListener(new forEvent("HscrollBar"));
        this.tbTitleP = new TitlePanel();
        centerP.setLayout(new BorderLayout());
        centerP.setBorder(BorderFactory.createEtchedBorder());
        centerP.add((Component)this.sclp, "Center");
        centerP.add((Component)this.tbTitleP, "North");
        this.topPane.add((Component)centerP, "Center");
        BottomPanel bottomPanel = new BottomPanel();
        this.topPane.add((Component)bottomPanel, "South");
        this.rootPane.add((Component)this.northP, "North");
        this.rootPane.add((Component)this.westP, "West");
        this.rootPane.add((Component)this.topPane, "Center");
        this.rootPane.add((Component)this.eastP, "East");
        this.rootPane.add((Component)this.southP, "South");
        this.add((Component)this.rootPane, "Center");
        tfAlpha.addFocusListener(new forEvent("Alpha"));
        tfLength.addFocusListener(new forEvent("Length"));
        tfAlpha.addMouseListener(new forEvent("Alpha"));
        tfLength.addMouseListener(new forEvent("Length"));
        cboxSemiInfinite.setSelected(RichardsEqn.semiInfiniteSelected);
        cboxLength.setSelected(true);
        RichardsEqn.length = RichardsEqn.editingSoil.horizon[RichardsEqn.editingSoil.nHorizons - 1].depthBottom;
        tfLength.setText(RichardsEqn.formatLength(RichardsEqn.length));
        this.sbrLength.setValue((int)(RichardsEqn.length + 0.5));
        tfLength.setVisible(true);
        this.sbrLength.setVisible(true);
        tfLength.setEditable(true);
        this.lLength.setVisible(true);
        this.lLength.setText("Soil Length ( " + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + " ):");
        if (this.finiteChanged) {
            CHEMFLO.initialPane.refresh();
            CHEMFLO.transProperty.refresh();
            this.finiteChanged = false;
        }
        this.addMouseListener(new forEvent(" "));
        centerP.repaint();
        this.setUsedStrings();
    }

    public void ResetUnits() {
        if (!RichardsEqn.semiInfiniteSelected) {
            this.lLength.setText("Soil Length ( " + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + " ):");
            tfLength.setText(RichardsEqn.formatLength(RichardsEqn.length));
            if (RichardsEqn.editingSoil.nHorizons == 1) {
                this.sbrLength.setValue((int)(RichardsEqn.length + 0.5));
            }
        } else {
            this.lMaxXtoPlot.setText("Maximum Distance to Plot ( " + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + " ):");
            this.tfMaxXtoPlot.setText(RichardsEqn.formatLength(RichardsEqn.xmax));
            this.sbrMaxXtoPlot.setValue((int)(RichardsEqn.xmax + 0.5));
        }
        this.funcFormP.ResetUnits();
        centerP.repaint();
        CHEMFLO.buttonP.repaint();
    }

    public void updateSelectedSoil() {
        this.soilBox.setSelectedIndex(RichardsEqn.currentSoilIndex);
        this.soilBox.revalidate();
        this.soilBox.repaint();
        tfLength.setText("" + RichardsEqn.length);
        RichardsEqn.xmax = RichardsEqn.length;
        CHEMFLO.initialPane.refresh();
        CHEMFLO.transProperty.refresh();
        centerP.repaint();
        CHEMFLO.mainScreen.repaint();
        CHEMFLO.boundaryPane.updateMarks();
    }

    public void setLengthAppear() {
        if (RichardsEqn.editingSoil.nHorizons != 1) {
            this.sbrLength.setVisible(false);
            tfLength.setEditable(false);
            tfLength.setText(RichardsEqn.formatLength(RichardsEqn.length));
        } else if (RichardsEqn.semiInfiniteSelected) {
            this.tfMaxXtoPlot.setText(RichardsEqn.formatLength(RichardsEqn.xmax));
        } else {
            tfLength.setText(RichardsEqn.formatLength(RichardsEqn.length));
            this.sbrLength.setVisible(true);
            tfLength.setEditable(true);
        }
        this.funcFormP.ResetUnits();
        centerP.repaint();
        CHEMFLO.buttonP.repaint();
    }

    public void updateSize() {
        if (CHEMFLO.wMax) {
            this.wid = CHEMFLO.old_width - 220;
            this.hgh = CHEMFLO.old_height - 140;
        } else {
            this.wid = 592;
            this.hgh = 470;
        }
        if (this.rootPane.getComponentCount() != 0) {
            this.rootPane.removeAll();
        }
        this.rootPane.setPreferredSize(new Dimension(this.wid, this.hgh));
        int n = (int)((double)(this.hgh - 470) / 2.0);
        this.northP.setPreferredSize(new Dimension(this.wid, n));
        if (CHEMFLO.wMax) {
            this.southP.setPreferredSize(new Dimension(this.wid, n - 10));
        } else {
            this.southP.setPreferredSize(new Dimension(this.wid, n));
        }
        int n2 = (int)((double)(this.wid - 592) / 2.0);
        this.westP.setPreferredSize(new Dimension(n2, 460));
        this.eastP.setPreferredSize(new Dimension(n2 - 5, 460));
        this.rootPane.add((Component)this.northP, "North");
        this.rootPane.add((Component)this.westP, "West");
        this.rootPane.add((Component)this.topPane, "Center");
        this.rootPane.add((Component)this.eastP, "East");
        this.rootPane.add((Component)this.southP, "South");
        this.rootPane.repaint();
    }

    public Vector getSoilData() {
        Vector<String> vector = new Vector<String>();
        vector.addElement("Soil:");
        vector.addElement(new String("Name:        " + CHEMFLO.soilPane.soilBox.getSelectedItem()));
        if (RichardsEqn.semiInfiniteSelected) {
            vector.addElement("Semi-infinite Soil");
        } else {
            vector.addElement(new String("Extent:      " + RichardsEqn.formatLength(RichardsEqn.length) + " " + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit]));
        }
        vector.addElement(new String("Orientation: Angle of Inclination is " + RichardsEqn.alpha + " degrees"));
        vector.addElement("Properties:");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Layer   ");
        int n = stringBuffer.toString().length();
        stringBuffer.append("Thickness   ");
        int n2 = stringBuffer.toString().length();
        stringBuffer.append("Conductivity              ");
        int n3 = stringBuffer.toString().length();
        stringBuffer.append("Water Characteristic      ");
        int n4 = stringBuffer.toString().length();
        stringBuffer.append("Organic     ");
        int n5 = stringBuffer.toString().length();
        stringBuffer.append("Bulk    ");
        vector.addElement(stringBuffer.toString());
        stringBuffer = new StringBuffer();
        int n6 = 0;
        while (n6 < n) {
            stringBuffer.append(" ");
            ++n6;
        }
        stringBuffer.append(new String("    (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + ")"));
        int n7 = n2 - stringBuffer.toString().length();
        int n8 = 0;
        while (n8 < n7) {
            stringBuffer.append(" ");
            ++n8;
        }
        stringBuffer.append("Function");
        n7 = n3 - stringBuffer.toString().length();
        int n9 = 0;
        while (n9 < n7) {
            stringBuffer.append(" ");
            ++n9;
        }
        stringBuffer.append("Function");
        n7 = n4 - stringBuffer.toString().length();
        int n10 = 0;
        while (n10 < n7) {
            stringBuffer.append(" ");
            ++n10;
        }
        stringBuffer.append("Carbon");
        n7 = n5 - stringBuffer.toString().length();
        int n11 = 0;
        while (n11 < n7) {
            stringBuffer.append(" ");
            ++n11;
        }
        stringBuffer.append("Density");
        vector.addElement(stringBuffer.toString());
        stringBuffer = new StringBuffer();
        int n12 = 0;
        while (n12 < n4) {
            stringBuffer.append(" ");
            ++n12;
        }
        stringBuffer.append("(g/g)");
        n7 = n5 - stringBuffer.toString().length();
        int n13 = 0;
        while (n13 < n7) {
            stringBuffer.append(" ");
            ++n13;
        }
        stringBuffer.append("(Mg/m3)");
        vector.addElement(stringBuffer.toString());
        int n14 = 0;
        while (n14 < RichardsEqn.editingSoil.nHorizons) {
            int n15;
            int n16;
            stringBuffer = new StringBuffer();
            if (!RichardsEqn.semiInfiniteSelected) {
                stringBuffer.append(Integer.toString(n14 + 1));
                n7 = n - stringBuffer.toString().length();
                n16 = 0;
                while (n16 < n7) {
                    stringBuffer.append(" ");
                    ++n16;
                }
                stringBuffer.append(String.valueOf(Tools.formatDouble(RichardsEqn.editingSoil.horizon[n14].getLength(), 1, 8)));
                n7 = n2 - stringBuffer.toString().length();
                n15 = 0;
                while (n15 < n7) {
                    stringBuffer.append(" ");
                    ++n15;
                }
            } else {
                n16 = 0;
                while (n16 < n2) {
                    stringBuffer.append(" ");
                    ++n16;
                }
            }
            stringBuffer.append(this.conductivityStr[RichardsEqn.selectedConductModelIndex[n14]]);
            n7 = n3 - stringBuffer.toString().length();
            n16 = 0;
            while (n16 < n7) {
                stringBuffer.append(" ");
                ++n16;
            }
            stringBuffer.append(this.rententionStr[RichardsEqn.selectedRententModelIndex[n14]]);
            n7 = n4 - stringBuffer.toString().length();
            n15 = 0;
            while (n15 < n7) {
                stringBuffer.append(" ");
                ++n15;
            }
            stringBuffer.append(String.valueOf(RichardsEqn.editingSoil.horizon[n14].getOC()));
            n7 = n5 - stringBuffer.toString().length();
            int n17 = 0;
            while (n17 < n7) {
                stringBuffer.append(" ");
                ++n17;
            }
            stringBuffer.append(String.valueOf(RichardsEqn.editingSoil.horizon[n14].getBulkDensity()));
            vector.addElement(stringBuffer.toString());
            stringBuffer = new StringBuffer();
            int n18 = 0;
            while (n18 < n2) {
                stringBuffer.append(" ");
                ++n18;
            }
            stringBuffer.append(new String(this.conductivityPara[RichardsEqn.selectedConductModelIndex[n14]][0] + String.valueOf(RichardsEqn.editingSoil.horizon[n14].k.getParamValue(3))));
            n7 = n3 - stringBuffer.toString().length();
            int n19 = 0;
            while (n19 < n7) {
                stringBuffer.append(" ");
                ++n19;
            }
            stringBuffer.append(new String(this.rententionPara[RichardsEqn.selectedRententModelIndex[n14]][0] + String.valueOf(RichardsEqn.editingSoil.horizon[n14].wc.getParamValue(3))));
            vector.addElement(stringBuffer.toString());
            stringBuffer = new StringBuffer();
            int n20 = 0;
            while (n20 < n2) {
                stringBuffer.append(" ");
                ++n20;
            }
            stringBuffer.append(new String(this.conductivityPara[RichardsEqn.selectedConductModelIndex[n14]][1] + String.valueOf(RichardsEqn.editingSoil.horizon[n14].k.getParamValue(1))));
            n7 = n3 - stringBuffer.toString().length();
            int n21 = 0;
            while (n21 < n7) {
                stringBuffer.append(" ");
                ++n21;
            }
            stringBuffer.append(new String(this.rententionPara[RichardsEqn.selectedRententModelIndex[n14]][1] + String.valueOf(RichardsEqn.editingSoil.horizon[n14].wc.getParamValue(4))));
            vector.addElement(stringBuffer.toString());
            stringBuffer = new StringBuffer();
            int n22 = 0;
            while (n22 < n2) {
                stringBuffer.append(" ");
                ++n22;
            }
            stringBuffer.append(new String(this.conductivityPara[RichardsEqn.selectedConductModelIndex[n14]][2] + String.valueOf(RichardsEqn.editingSoil.horizon[n14].k.getParamValue(2))));
            n7 = n3 - stringBuffer.toString().length();
            int n23 = 0;
            while (n23 < n7) {
                stringBuffer.append(" ");
                ++n23;
            }
            stringBuffer.append(new String(this.rententionPara[RichardsEqn.selectedRententModelIndex[n14]][2] + String.valueOf(RichardsEqn.editingSoil.horizon[n14].wc.getParamValue(1))));
            vector.addElement(stringBuffer.toString());
            stringBuffer = new StringBuffer();
            int n24 = 0;
            while (n24 < n3) {
                stringBuffer.append(" ");
                ++n24;
            }
            stringBuffer.append(new String(this.rententionPara[RichardsEqn.selectedRententModelIndex[n14]][3] + String.valueOf(RichardsEqn.editingSoil.horizon[n14].wc.getParamValue(2))));
            vector.addElement(stringBuffer.toString());
            ++n14;
        }
        return vector;
    }

    private void setUsedStrings() {
        this.conductivityStr[0] = "Gardner";
        this.conductivityStr[1] = "Brooks & Corey";
        this.conductivityStr[2] = "van Genuchten";
        this.conductivityPara[0][0] = "Ks (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ") = ";
        this.conductivityPara[0][1] = "hc (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + ") = ";
        this.conductivityPara[0][2] = "n = ";
        this.conductivityPara[1][0] = "Ks (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ") = ";
        this.conductivityPara[1][1] = "hb (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + ") = ";
        this.conductivityPara[1][2] = "n = ";
        this.conductivityPara[2][0] = "Ks (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ") = ";
        this.conductivityPara[2][1] = "\u03b1 (1/" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + ") = ";
        this.conductivityPara[2][2] = "n = ";
        this.rententionStr[0] = "Simmons";
        this.rententionStr[1] = "Brooks & Corey";
        this.rententionStr[2] = "van Genuchten";
        this.rententionPara[0][0] = "\u03b8s (v/v) = ";
        this.rententionPara[0][1] = "\u03b8r (v/v) = ";
        this.rententionPara[0][2] = "\u03b1 (1/" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + ") = ";
        this.rententionPara[0][3] = "n = ";
        this.rententionPara[1][0] = "\u03b8s (v/v) = ";
        this.rententionPara[1][1] = "\u03b8r (v/v) = ";
        this.rententionPara[1][2] = "hb = (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + ") = ";
        this.rententionPara[1][3] = "\u03bb = ";
        this.rententionPara[2][0] = "\u03b8s (v/v) = ";
        this.rententionPara[2][1] = "\u03b8r (v/v) = ";
        this.rententionPara[2][2] = "\u03b1 (1/" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + ") = ";
        this.rententionPara[2][3] = "n = ";
    }

    static /* synthetic */ int access$400(SoilInterestPanel soilInterestPanel) {
        return soilInterestPanel.oldSoilIndex;
    }

    static {
        centerP = new JPanel();
    }

    class forEvent
    extends MouseAdapter
    implements AdjustmentListener,
    ActionListener,
    FocusListener,
    ItemListener {
        int iTemp;
        double dTemp;
        String sTemp;
        String name;

        public forEvent(String string) {
            this.name = string;
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            if (this.name.equals("Alpha")) {
                this.iTemp = sbrAlpha.getValue() - 360;
                if (this.iTemp < 0) {
                    while (this.iTemp < 0) {
                        this.iTemp += 360;
                    }
                }
                if (this.iTemp >= 360) {
                    while (this.iTemp >= 360) {
                        this.iTemp -= 360;
                    }
                }
                tfAlpha.setText(String.valueOf(this.iTemp));
                RichardsEqn.alpha = this.iTemp;
                sbrAlpha.setValue((int)RichardsEqn.alpha + 360);
                RichardsEqn.restart = true;
                this.performed();
                if (SoilInterestPanel.this.errorFree) {
                    CHEMFLO.buttonP.repaint();
                } else {
                    new ErrorMessageDialog("Error", RichardsEqn.errorMessage);
                    return;
                }
            }
            if (this.name.equals("Length")) {
                this.iTemp = SoilInterestPanel.this.sbrLength.getValue();
                RichardsEqn.length = this.iTemp;
                tfLength.setText(RichardsEqn.formatLength(RichardsEqn.length));
                RichardsEqn.restart = true;
                this.performed();
                if (SoilInterestPanel.this.errorFree) {
                    CHEMFLO.buttonP.repaint();
                    RichardsEqn.editingSoil.horizon[RichardsEqn.editingSoil.nHorizons - 1].setLength(RichardsEqn.editingSoil.horizon[RichardsEqn.editingSoil.nHorizons - 1].depthTop, RichardsEqn.length);
                    RichardsEqn.xmax = RichardsEqn.editingSoil.horizon[RichardsEqn.editingSoil.nHorizons - 1].depthBottom;
                    centerP.repaint();
                    CHEMFLO.mainScreen.repaint();
                    CHEMFLO.boundaryPane.updateMarks();
                    if (RichardsEqn.waterPartCoeIndex == 1) {
                        CHEMFLO.transProperty.setupDefaultData();
                    }
                    CHEMFLO.mainScreen.resetPosition();
                } else {
                    new ErrorMessageDialog("Error", RichardsEqn.errorMessage);
                    return;
                }
            }
            if (this.name.equals("MaxXtoPlot")) {
                this.iTemp = SoilInterestPanel.this.sbrMaxXtoPlot.getValue();
                RichardsEqn.xmax = this.iTemp;
                SoilInterestPanel.this.tfMaxXtoPlot.setText(RichardsEqn.formatLength(RichardsEqn.xmax));
                this.performed();
                if (SoilInterestPanel.this.errorFree) {
                    RichardsEqn.length = RichardsEqn.xmax;
                    RichardsEqn.editingSoil.horizon[RichardsEqn.editingSoil.nHorizons - 1].setLength(RichardsEqn.editingSoil.horizon[RichardsEqn.editingSoil.nHorizons - 1].depthTop, RichardsEqn.length);
                    CHEMFLO.mainScreen.repaint();
                    centerP.repaint();
                } else {
                    new ErrorMessageDialog("Error", RichardsEqn.errorMessage);
                    return;
                }
            }
            if (this.name.equals("VscrollBar") || this.name.equals("HscrollBar")) {
                centerP.repaint();
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            CHEMFLO.mainScreen.repaint();
            CHEMFLO.boundaryPane.updateMarks();
            CHEMFLO.buttonP.repaint();
        }

        /*
         * Unable to fully structure code
         */
        public void actionPerformed(ActionEvent var1_1) {
            block31: {
                block36: {
                    block37: {
                        block35: {
                            block34: {
                                block33: {
                                    block32: {
                                        block30: {
                                            if (!SoilInterestPanel.this.errorFree) {
                                                if (this.name.equals("SemiInfinite")) {
                                                    SoilInterestPanel.cboxSemiInfinite.setSelected(false);
                                                    SoilInterestPanel.cboxLength.setSelected(true);
                                                } else if (this.name.equals("Finite")) {
                                                    SoilInterestPanel.cboxSemiInfinite.setSelected(true);
                                                    SoilInterestPanel.cboxLength.setSelected(false);
                                                }
                                                JOptionPane.showMessageDialog(CHEMFLO.appWin, RichardsEqn.errorMessage, "Error", 0);
                                                CHEMFLO.appWin.repaint();
                                                return;
                                            }
                                            if (!this.name.equals("ChoiceSoil")) break block30;
                                            SoilInterestPanel.access$402(SoilInterestPanel.this, RichardsEqn.currentSoilIndex);
                                            RichardsEqn.currentSoilIndex = SoilInterestPanel.this.soilBox.getSelectedIndex();
                                            var2_2 = new String(RichardsEqn.currentSoilName);
                                            RichardsEqn.currentSoilName = (String)SoilInterestPanel.this.soilBox.getSelectedItem();
                                            var3_7 = CHEMFLO.soilIO.getIndexOfSelectedSoil(RichardsEqn.currentSoilName);
                                            if (((Soil)CHEMFLO.soilIO.soilList.get((int)var3_7)).nHorizons > 1 && SoilInterestPanel.cboxSemiInfinite.isSelected()) {
                                                JOptionPane.showMessageDialog(CHEMFLO.appWin, "This soil has more than one layer. It can not\nbe used as a semi-infinite soil. Please select\nanother soil or simulate as finite length soil.", "Error", 0);
                                                CHEMFLO.appWin.repaint();
                                                RichardsEqn.currentSoilName = var2_2;
                                                SoilInterestPanel.this.soilBox.setSelectedIndex(SoilInterestPanel.access$400(SoilInterestPanel.this));
                                                SoilInterestPanel.this.sbrLength.setVisible(false);
                                                SoilInterestPanel.tfLength.setVisible(false);
                                                SoilInterestPanel.this.lLength.setVisible(false);
                                                SoilInterestPanel.this.soilBox.repaint();
                                                return;
                                            }
                                            if (SoilInterestPanel.access$400(SoilInterestPanel.this) != RichardsEqn.currentSoilIndex) {
                                                RichardsEqn.setCurrentSoil(RichardsEqn.currentSoilName);
                                                SoilInterestPanel.tfLength.setText("" + RichardsEqn.length);
                                                RichardsEqn.xmax = RichardsEqn.length;
                                                if (RichardsEqn.editingSoil.nHorizons > 1) {
                                                    SoilInterestPanel.this.lLength.setVisible(true);
                                                    SoilInterestPanel.this.sbrLength.setVisible(false);
                                                    SoilInterestPanel.tfLength.setVisible(true);
                                                    SoilInterestPanel.tfLength.setEditable(false);
                                                } else if (SoilInterestPanel.cboxSemiInfinite.isSelected()) {
                                                    SoilInterestPanel.this.lLength.setVisible(false);
                                                    SoilInterestPanel.this.sbrLength.setVisible(false);
                                                    SoilInterestPanel.tfLength.setVisible(false);
                                                } else {
                                                    SoilInterestPanel.this.lLength.setVisible(true);
                                                    SoilInterestPanel.this.sbrLength.setVisible(true);
                                                    SoilInterestPanel.tfLength.setVisible(true);
                                                    SoilInterestPanel.tfLength.setEditable(true);
                                                }
                                                CHEMFLO.initialPane.refresh();
                                                if (RichardsEqn.waterPartCoeIndex == 1) {
                                                    CHEMFLO.transProperty.setupDefaultData();
                                                }
                                                CHEMFLO.initialPane.refreshInitTableWithSoilChanged();
                                                if (RichardsEqn.editingSoil.nHorizons > 1 && RichardsEqn.selectedInitialCond == 1) {
                                                    CHEMFLO.initialPane.extractUniInitCondations();
                                                }
                                                SoilInterestPanel.centerP.repaint();
                                                RichardsEqn.restart = true;
                                                CHEMFLO.mainScreen.resetPosition();
                                            }
                                            break block31;
                                        }
                                        if (!this.name.equals("SemiInfinite")) break block32;
                                        SoilInterestPanel.cboxSemiInfinite.setSelected(true);
                                        SoilInterestPanel.cboxLength.setSelected(false);
                                        if (RichardsEqn.editingSoil.nHorizons > 1) {
                                            JOptionPane.showMessageDialog(CHEMFLO.appWin, "This soil has more than one layer. It can not\nbe used as a semi-infinite soil. Please select\nanother soil or simulate as finite length soil.", "Error", 0);
                                            CHEMFLO.appWin.repaint();
                                            SoilInterestPanel.cboxSemiInfinite.setSelected(false);
                                            RichardsEqn.semiInfiniteSelected = false;
                                            SoilInterestPanel.cboxLength.setSelected(true);
                                            RichardsEqn.length = RichardsEqn.editingSoil.horizon[RichardsEqn.editingSoil.nHorizons - 1].depthBottom;
                                            SoilInterestPanel.tfLength.setText(RichardsEqn.formatLength(RichardsEqn.length));
                                            SoilInterestPanel.this.sbrLength.setValue((int)(RichardsEqn.length + 0.5));
                                            SoilInterestPanel.tfLength.setVisible(true);
                                            SoilInterestPanel.this.sbrLength.setVisible(false);
                                            SoilInterestPanel.tfLength.setEditable(false);
                                            SoilInterestPanel.access$500(SoilInterestPanel.this).setVisible(false);
                                            SoilInterestPanel.access$600(SoilInterestPanel.this).setVisible(false);
                                            SoilInterestPanel.access$700(SoilInterestPanel.this).setVisible(false);
                                            SoilInterestPanel.this.lLength.setText("Soil Length ( " + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + " ):");
                                            if (SoilInterestPanel.this.finiteChanged) {
                                                CHEMFLO.initialPane.refresh();
                                                CHEMFLO.transProperty.refresh();
                                                SoilInterestPanel.this.finiteChanged = false;
                                                RichardsEqn.restart = true;
                                                RichardsEqn.diffsoilModel = true;
                                                RichardsEqn.newBCL = true;
                                            }
                                        } else {
                                            SoilInterestPanel.cboxSemiInfinite.setSelected(true);
                                            RichardsEqn.semiInfiniteSelected = true;
                                            SoilInterestPanel.cboxLength.setSelected(false);
                                            SoilInterestPanel.tfLength.setVisible(false);
                                            SoilInterestPanel.this.sbrLength.setVisible(false);
                                            SoilInterestPanel.this.lLength.setVisible(false);
                                            SoilInterestPanel.access$500(SoilInterestPanel.this).setVisible(true);
                                            SoilInterestPanel.access$600(SoilInterestPanel.this).setVisible(true);
                                            SoilInterestPanel.access$700(SoilInterestPanel.this).setVisible(true);
                                            SoilInterestPanel.access$600(SoilInterestPanel.this).setText(new Double(RichardsEqn.xmax).toString());
                                            SoilInterestPanel.access$700(SoilInterestPanel.this).setValue((int)(RichardsEqn.xmax + 0.5));
                                            if (!SoilInterestPanel.this.finiteChanged) {
                                                CHEMFLO.initialPane.refresh();
                                                CHEMFLO.transProperty.refresh();
                                                SoilInterestPanel.this.finiteChanged = true;
                                                RichardsEqn.restart = true;
                                                RichardsEqn.diffsoilModel = true;
                                                RichardsEqn.newBCL = true;
                                                CHEMFLO.mainScreen.resetPosition();
                                            }
                                        }
                                        SoilInterestPanel.centerP.repaint();
                                        CHEMFLO.buttonP.repaint();
                                        break block31;
                                    }
                                    if (!this.name.equals("Finite")) break block33;
                                    SoilInterestPanel.cboxSemiInfinite.setSelected(false);
                                    RichardsEqn.semiInfiniteSelected = false;
                                    SoilInterestPanel.cboxLength.setSelected(true);
                                    RichardsEqn.length = RichardsEqn.editingSoil.horizon[RichardsEqn.editingSoil.nHorizons - 1].depthBottom;
                                    SoilInterestPanel.tfLength.setText(RichardsEqn.formatLength(RichardsEqn.length));
                                    SoilInterestPanel.this.sbrLength.setValue((int)(RichardsEqn.length + 0.5));
                                    SoilInterestPanel.this.lLength.setVisible(true);
                                    SoilInterestPanel.tfLength.setVisible(true);
                                    if (RichardsEqn.editingSoil.nHorizons > 1) {
                                        SoilInterestPanel.this.sbrLength.setVisible(false);
                                        SoilInterestPanel.tfLength.setEditable(false);
                                    } else {
                                        SoilInterestPanel.this.sbrLength.setVisible(true);
                                        SoilInterestPanel.tfLength.setEditable(true);
                                        SoilInterestPanel.tfLength.setText(new Double(RichardsEqn.length).toString());
                                        SoilInterestPanel.this.sbrLength.setValue((int)(RichardsEqn.length + 0.5));
                                    }
                                    SoilInterestPanel.access$500(SoilInterestPanel.this).setVisible(false);
                                    SoilInterestPanel.access$600(SoilInterestPanel.this).setVisible(false);
                                    SoilInterestPanel.access$700(SoilInterestPanel.this).setVisible(false);
                                    RichardsEqn.semiInfiniteSelected = false;
                                    SoilInterestPanel.this.lLength.setText("Soil Length ( " + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + " ):");
                                    if (SoilInterestPanel.this.finiteChanged) {
                                        CHEMFLO.initialPane.refresh();
                                        CHEMFLO.transProperty.refresh();
                                        SoilInterestPanel.this.finiteChanged = false;
                                        RichardsEqn.restart = true;
                                        RichardsEqn.diffsoilModel = true;
                                        RichardsEqn.newBCL = true;
                                        CHEMFLO.mainScreen.resetPosition();
                                    }
                                    SoilInterestPanel.centerP.repaint();
                                    CHEMFLO.buttonP.repaint();
                                    CHEMFLO.boundaryPane.updateMarks();
                                    break block31;
                                }
                                if (!this.name.equals("DetailedProperty")) break block34;
                                SoilInterestPanel.this.titleP.setBackground(Color.gray);
                                RichardsEqn.setCurrentSoil(RichardsEqn.currentSoilName);
                                if (RichardsEqn.semiInfiniteSelected || RichardsEqn.editingSoil.nHorizons == 1) {
                                    RichardsEqn.length = RichardsEqn.xmax;
                                    RichardsEqn.editingSoil.horizon[RichardsEqn.editingSoil.nHorizons - 1].setLength(RichardsEqn.editingSoil.horizon[RichardsEqn.editingSoil.nHorizons - 1].depthTop, RichardsEqn.length);
                                }
                                new ModelParameters(RichardsEqn.editingSoil);
                                if (RichardsEqn.editingSoil.nHorizons > 1 && RichardsEqn.selectedInitialCond == 1) {
                                    CHEMFLO.initialPane.extractUniInitCondations();
                                }
                                SoilInterestPanel.this.titleP.setBackground(new Color(0, 0, 128));
                                SoilInterestPanel.centerP.repaint();
                                break block31;
                            }
                            if (!this.name.equals("DeleteSoil")) break block35;
                            var2_3 = null;
                            RichardsEqn.getSoilNames(CHEMFLO.soilIO.soilList);
                            if (RichardsEqn.allSoilNames.size() > 1) {
                                var2_3 = new String[RichardsEqn.allSoilNames.size() - 1];
                                var3_8 = 1;
                                while (var3_8 < RichardsEqn.allSoilNames.size()) {
                                    var2_3[var3_8 - 1] = new String((String)RichardsEqn.allSoilNames.elementAt(var3_8));
                                    ++var3_8;
                                }
                            } else {
                                var2_3 = null;
                            }
                            var3_9 = new DeleteSoilWindow(var2_3);
                            if (var3_9.dSoilName != null) {
                                CHEMFLO.soilIO.deleteSoil(var3_9.dSoilName);
                                RichardsEqn.getSoilNames(CHEMFLO.soilIO.soilList);
                                RichardsEqn.currentSoilIndex = 0;
                                SoilInterestPanel.this.soilBox.setSelectedIndex(RichardsEqn.currentSoilIndex);
                                SoilInterestPanel.this.soilBox.repaint();
                                RichardsEqn.currentSoilName = (String)SoilInterestPanel.this.soilBox.getSelectedItem();
                                RichardsEqn.setCurrentSoil(RichardsEqn.currentSoilName);
                                SoilInterestPanel.tfLength.setText("" + RichardsEqn.length);
                                RichardsEqn.xmax = RichardsEqn.length;
                                SoilInterestPanel.this.sbrLength.setVisible(true);
                                SoilInterestPanel.tfLength.setEditable(true);
                                CHEMFLO.initialPane.refresh();
                                CHEMFLO.transProperty.refresh();
                                SoilInterestPanel.centerP.repaint();
                                RichardsEqn.restart = true;
                                CHEMFLO.mainScreen.repaint();
                                CHEMFLO.boundaryPane.updateMarks();
                                CHEMFLO.buttonP.repaint();
                                CHEMFLO.soilIO.writeToFile();
                            }
                            break block31;
                        }
                        if (!this.name.equals("Length")) break block36;
                        this.performed();
                        if (!SoilInterestPanel.this.errorFree) break block37;
                        var2_4 = new Thread(this){
                            private final /* synthetic */ forEvent this$1;
                            {
                                this.this$1 = forEvent2;
                            }

                            public void run() {
                                RichardsEqn.editingSoil.horizon[RichardsEqn.editingSoil.nHorizons - 1].setLength(RichardsEqn.editingSoil.horizon[RichardsEqn.editingSoil.nHorizons - 1].depthTop, RichardsEqn.length);
                                RichardsEqn.xmax = RichardsEqn.editingSoil.horizon[RichardsEqn.editingSoil.nHorizons - 1].depthBottom;
                                CHEMFLO.buttonP.repaint();
                                CHEMFLO.boundaryPane.updateMarks();
                                centerP.repaint();
                                if (RichardsEqn.waterPartCoeIndex == 1) {
                                    CHEMFLO.transProperty.setupDefaultData();
                                }
                            }
                        };
                        var2_4.start();
                        break block31;
                    }
                    JOptionPane.showMessageDialog(CHEMFLO.appWin, RichardsEqn.errorMessage, "Error", 0);
                    CHEMFLO.appWin.repaint();
                    return;
                }
                if (!this.name.equals("MaxXtoPlot")) ** GOTO lbl213
                this.performed();
                if (SoilInterestPanel.this.errorFree) {
                    var2_5 = new Thread(this){
                        private final /* synthetic */ forEvent this$1;
                        {
                            this.this$1 = forEvent2;
                        }

                        public void run() {
                            RichardsEqn.length = RichardsEqn.xmax;
                            RichardsEqn.editingSoil.horizon[RichardsEqn.editingSoil.nHorizons - 1].setLength(RichardsEqn.editingSoil.horizon[RichardsEqn.editingSoil.nHorizons - 1].depthTop, RichardsEqn.length);
                            CHEMFLO.buttonP.repaint();
                            centerP.repaint();
                        }
                    };
                    var2_5.start();
                } else {
                    JOptionPane.showMessageDialog(CHEMFLO.appWin, RichardsEqn.errorMessage, "Error", 0);
                    CHEMFLO.appWin.repaint();
                    return;
lbl213:
                    // 1 sources

                    if (this.name.equals("Alpha")) {
                        this.performed();
                        if (SoilInterestPanel.this.errorFree) {
                            var2_6 = new Thread(this){
                                private final /* synthetic */ forEvent this$1;
                                {
                                    this.this$1 = forEvent2;
                                }

                                public void run() {
                                    CHEMFLO.buttonP.repaint();
                                }
                            };
                            var2_6.start();
                        } else {
                            JOptionPane.showMessageDialog(CHEMFLO.appWin, RichardsEqn.errorMessage, "Error", 0);
                            CHEMFLO.appWin.repaint();
                            return;
                        }
                    }
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void focusLost(FocusEvent focusEvent) {
            this.performed();
            if (this.name.equals("Length")) {
                if (!SoilInterestPanel.this.errorFree) return;
                Thread thread = new Thread(this){
                    private final /* synthetic */ forEvent this$1;
                    {
                        this.this$1 = forEvent2;
                    }

                    public void run() {
                        RichardsEqn.editingSoil.horizon[RichardsEqn.editingSoil.nHorizons - 1].setLength(RichardsEqn.editingSoil.horizon[RichardsEqn.editingSoil.nHorizons - 1].depthTop, RichardsEqn.length);
                        RichardsEqn.xmax = RichardsEqn.editingSoil.horizon[RichardsEqn.editingSoil.nHorizons - 1].depthBottom;
                        CHEMFLO.buttonP.repaint();
                        CHEMFLO.boundaryPane.updateMarks();
                        centerP.repaint();
                    }
                };
                thread.start();
                return;
            } else {
                if (!this.name.equals("MaxXtoPlot")) return;
                if (!SoilInterestPanel.this.errorFree) return;
                Thread thread = new Thread(this){
                    private final /* synthetic */ forEvent this$1;
                    {
                        this.this$1 = forEvent2;
                    }

                    public void run() {
                        RichardsEqn.length = RichardsEqn.xmax;
                        RichardsEqn.editingSoil.horizon[RichardsEqn.editingSoil.nHorizons - 1].setLength(RichardsEqn.editingSoil.horizon[RichardsEqn.editingSoil.nHorizons - 1].depthTop, RichardsEqn.length);
                        CHEMFLO.buttonP.repaint();
                        centerP.repaint();
                    }
                };
                thread.start();
            }
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            block3: {
                JTextField jTextField;
                if (!(mouseEvent.getSource() instanceof JTextField) || (jTextField = (JTextField)mouseEvent.getSource()).getText() == null || jTextField.getText().trim().length() == 0) break block3;
                try {
                    Double.parseDouble(jTextField.getText());
                    this.performed();
                    if (!SoilInterestPanel.this.errorFree) {
                        JOptionPane.showMessageDialog(CHEMFLO.appWin, RichardsEqn.errorMessage, "Error", 0);
                        CHEMFLO.appWin.repaint();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    jTextField.grabFocus();
                }
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.performed();
        }

        public void performed() {
            JTextField jTextField = null;
            String string = "";
            try {
                double d;
                this.sTemp = tfAlpha.getText();
                jTextField = tfAlpha;
                string = "Soil System: Invalid angle of inclination value";
                RichardsEqn.alpha = d = Double.parseDouble(this.sTemp);
                while (RichardsEqn.alpha < 0.0) {
                    RichardsEqn.alpha += 360.0;
                }
                while (RichardsEqn.alpha >= 360.0) {
                    RichardsEqn.alpha -= 360.0;
                }
                tfAlpha.setText(Tools.formatDouble(RichardsEqn.alpha, 0, 0));
                if (d != RichardsEqn.alpha) {
                    sbrAlpha.setValue((int)RichardsEqn.alpha + 360);
                    RichardsEqn.alpha = d;
                    while (RichardsEqn.alpha < 0.0) {
                        RichardsEqn.alpha += 360.0;
                    }
                    while (RichardsEqn.alpha >= 360.0) {
                        RichardsEqn.alpha -= 360.0;
                    }
                    tfAlpha.setText(Tools.formatDouble(RichardsEqn.alpha, 0, 0));
                    RichardsEqn.restart = true;
                }
                if (!RichardsEqn.semiInfiniteSelected) {
                    this.sTemp = tfLength.getText();
                    jTextField = tfLength;
                    string = "Soil System: Invalid soil length value";
                    double d2 = Double.parseDouble(this.sTemp);
                    d = RichardsEqn.storeLength(d2);
                    if (d <= 0.0 || d > 5000.0) {
                        throw new IllegalValueException("Soil System: Soil length must be greater than zero and less than 5000 cm.");
                    }
                    if (RichardsEqn.editingSoil.nHorizons == 1 && d != RichardsEqn.length) {
                        RichardsEqn.length = d;
                        SoilInterestPanel.this.sbrLength.setValue((int)(RichardsEqn.length + 0.5));
                        RichardsEqn.length = d;
                        tfLength.setText(this.sTemp);
                        RichardsEqn.restart = true;
                    }
                } else {
                    this.sTemp = SoilInterestPanel.this.tfMaxXtoPlot.getText();
                    jTextField = SoilInterestPanel.this.tfMaxXtoPlot;
                    string = "Soil System: Invalid soil maximum distance value";
                    d = RichardsEqn.storeLength(new Double(this.sTemp));
                    if (d < 0.0) {
                        throw new IllegalValueException("Soil System: Maximum distance must be greater than zero.");
                    }
                    RichardsEqn.xmax = d;
                    SoilInterestPanel.this.sbrMaxXtoPlot.setValue((int)(RichardsEqn.xmax + 0.5));
                    if (d != RichardsEqn.xmax) {
                        RichardsEqn.xmax = d;
                        SoilInterestPanel.this.sbrMaxXtoPlot.setValue((int)(RichardsEqn.xmax + 0.5));
                        RichardsEqn.xmax = d;
                        SoilInterestPanel.this.tfMaxXtoPlot.setText(this.sTemp);
                        RichardsEqn.restart = true;
                    }
                }
                SoilInterestPanel.this.errorFree = true;
            }
            catch (Exception exception) {
                RichardsEqn.errorMessage = exception instanceof IllegalValueException ? exception.getMessage() : string;
                SoilInterestPanel.this.errorFree = false;
                jTextField.grabFocus();
            }
        }
    }

    class bntMouseListener
    extends MouseAdapter {
        bntMouseListener() {
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (SoilInterestPanel.this.editBnt == (JButton)mouseEvent.getSource()) {
                SoilInterestPanel.this.editBnt.setBorder(SoilInterestPanel.this.oldBorder);
            }
            if (SoilInterestPanel.this.deleteBnt == (JButton)mouseEvent.getSource()) {
                SoilInterestPanel.this.deleteBnt.setBorder(SoilInterestPanel.this.oldBorder);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (SoilInterestPanel.this.editBnt == (JButton)mouseEvent.getSource()) {
                SoilInterestPanel.this.editBnt.setBorder(SoilInterestPanel.this.raisedEdge);
            }
            if (SoilInterestPanel.this.deleteBnt == (JButton)mouseEvent.getSource()) {
                SoilInterestPanel.this.deleteBnt.setBorder(SoilInterestPanel.this.raisedEdge);
            }
        }
    }

    class UpLeftPanel
    extends JPanel {
        UpLeftPanel() {
            this.setPreferredSize(new Dimension(365, 150));
            this.setLayout(null);
            int n = 0;
            JLabel jLabel = new JLabel("Soil:");
            jLabel.setForeground(Color.black);
            jLabel.setBounds(20, 10, 50, 22);
            jLabel.setPreferredSize(new Dimension(50, 22));
            this.add(jLabel);
            SoilInterestPanel.this.soilBoxPane = new JPanel();
            SoilInterestPanel.this.soilBoxPane.setSize(385, 22);
            SoilInterestPanel.this.soilBoxPane.setLayout(new BorderLayout());
            SoilInterestPanel.this.soilBoxPane.setBounds(70, 10, 385, 22);
            SoilInterestPanel.this.oldSoilIndex = RichardsEqn.currentSoilIndex;
            SoilInterestPanel.this.soilBox = new JComboBox(RichardsEqn.allSoilNames);
            SoilInterestPanel.this.soilBox.setSelectedIndex(RichardsEqn.currentSoilIndex);
            SoilInterestPanel.this.soilBox.setForeground(Color.black);
            SoilInterestPanel.this.soilBox.setPreferredSize(new Dimension(380, 22));
            SoilInterestPanel.this.soilBoxPane.add((Component)SoilInterestPanel.this.soilBox, "Center");
            this.add(SoilInterestPanel.this.soilBoxPane);
            SoilInterestPanel.this.soilBox.addActionListener(new forEvent("ChoiceSoil"));
            cboxLength = new JRadioButton("Finite Length Soil", false);
            cboxLength.setForeground(Color.black);
            cboxLength.setFont(RichardsEqn.comboBoxFont);
            cboxLength.setBounds(20, 45, 150, 22);
            SoilInterestPanel.this.lLength = new JLabel("Soil Length");
            SoilInterestPanel.this.lLength.setForeground(Color.black);
            SoilInterestPanel.this.lLength.setFont(RichardsEqn.comboBoxFont);
            SoilInterestPanel.this.lLength.setBounds(220, 45, 120, 22);
            SoilInterestPanel.this.lLength.setVisible(false);
            this.add(SoilInterestPanel.this.lLength);
            tfLength = new JTextField(Tools.formatDouble(RichardsEqn.length, 1, 1));
            tfLength.setBounds(340, 45, 50, 22);
            tfLength.setPreferredSize(new Dimension(50, 22));
            tfLength.setVisible(false);
            this.add(tfLength);
            tfLength.addActionListener(new forEvent("Length"));
            n = (int)(RichardsEqn.length + 0.5);
            SoilInterestPanel.this.sbrLength = new JScrollBar(0, n, 0, 0, 5000);
            SoilInterestPanel.this.sbrLength.setUnitIncrement(5);
            SoilInterestPanel.this.sbrLength.setBounds(395, 45, 60, 22);
            this.add(SoilInterestPanel.this.sbrLength);
            SoilInterestPanel.this.sbrLength.setVisible(false);
            cboxSemiInfinite = new JRadioButton("Semi-infinite Soil", true);
            SoilInterestPanel.this.finiteChanged = true;
            cboxSemiInfinite.setForeground(Color.black);
            cboxSemiInfinite.setFont(RichardsEqn.comboBoxFont);
            cboxSemiInfinite.setBounds(20, 75, 130, 22);
            this.add(cboxLength);
            this.add(cboxSemiInfinite);
            SoilInterestPanel.this.lMaxXtoPlot = new JLabel("Maximum Distance to Plot ( " + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + " ):");
            SoilInterestPanel.this.lMaxXtoPlot.setBounds(150, 75, 190, 22);
            SoilInterestPanel.this.lMaxXtoPlot.setForeground(Color.black);
            SoilInterestPanel.this.lMaxXtoPlot.setFont(RichardsEqn.comboBoxFont);
            SoilInterestPanel.this.lMaxXtoPlot.setVisible(false);
            this.add(SoilInterestPanel.this.lMaxXtoPlot);
            SoilInterestPanel.this.tfMaxXtoPlot = new JTextField(String.valueOf((int)RichardsEqn.xmax));
            SoilInterestPanel.this.tfMaxXtoPlot.setBounds(340, 75, 50, 22);
            SoilInterestPanel.this.tfMaxXtoPlot.setVisible(false);
            this.add(SoilInterestPanel.this.tfMaxXtoPlot);
            n = (int)RichardsEqn.xmax;
            SoilInterestPanel.this.sbrMaxXtoPlot = new JScrollBar(0, n, 0, 0, 1001);
            SoilInterestPanel.this.sbrMaxXtoPlot.setBounds(395, 75, 60, 22);
            SoilInterestPanel.this.sbrMaxXtoPlot.setUnitIncrement(5);
            SoilInterestPanel.this.sbrMaxXtoPlot.setVisible(false);
            this.add(SoilInterestPanel.this.sbrMaxXtoPlot);
            SoilInterestPanel.this.tfMaxXtoPlot.addActionListener(new forEvent("MaxXtoPlot"));
            SoilInterestPanel.this.tfMaxXtoPlot.addFocusListener(new forEvent("MaxXtoPlot"));
            SoilInterestPanel.this.tfMaxXtoPlot.addMouseListener(new forEvent("MaxXtoPlot"));
            SoilInterestPanel.this.sbrMaxXtoPlot.addAdjustmentListener(new forEvent("MaxXtoPlot"));
            cboxSemiInfinite.addActionListener(new forEvent("SemiInfinite"));
            cboxLength.addActionListener(new forEvent("Finite"));
            SoilInterestPanel.this.lAlpha = new JLabel("Angle of Inclination, (degrees):");
            SoilInterestPanel.this.lAlpha.setBounds(20, 110, 250, 22);
            SoilInterestPanel.this.lAlpha.setPreferredSize(new Dimension(250, 22));
            SoilInterestPanel.this.lAlpha.setForeground(Color.black);
            tfAlpha = new JTextField(String.valueOf((int)RichardsEqn.alpha));
            tfAlpha.setBounds(340, 110, 50, 22);
            tfAlpha.setPreferredSize(new Dimension(50, 22));
            n = (int)RichardsEqn.alpha + 360;
            sbrAlpha = new JScrollBar(0, n, 0, 0, 720);
            sbrAlpha.setUnitIncrement(5);
            sbrAlpha.setBounds(395, 110, 60, 22);
            sbrAlpha.setPreferredSize(new Dimension(75, 22));
            sbrAlpha.addAdjustmentListener(new forEvent("Alpha"));
            SoilInterestPanel.this.sbrLength.addAdjustmentListener(new forEvent("Length"));
            tfAlpha.addActionListener(new forEvent("Alpha"));
            this.add(SoilInterestPanel.this.lAlpha);
            this.add(tfAlpha);
            this.add(sbrAlpha);
        }
    }

    class BottomPanel
    extends JPanel {
        public BottomPanel() {
            this.setLayout(null);
            this.setPreferredSize(new Dimension(500, 60));
            SoilInterestPanel.this.editBnt = new JButton("Edit/View Properties");
            SoilInterestPanel.this.editBnt.setBounds(150, 10, 150, 35);
            SoilInterestPanel.this.editBnt.setFont(RichardsEqn.comboBoxFont);
            SoilInterestPanel.this.deleteBnt = new JButton("Delete Soil");
            SoilInterestPanel.this.deleteBnt.setBounds(310, 10, 150, 35);
            SoilInterestPanel.this.deleteBnt.setFont(RichardsEqn.comboBoxFont);
            SoilInterestPanel.this.oldBorder = SoilInterestPanel.this.editBnt.getBorder();
            bntMouseListener bntMouseListener2 = new bntMouseListener();
            SoilInterestPanel.this.editBnt.addMouseListener(bntMouseListener2);
            SoilInterestPanel.this.deleteBnt.addMouseListener(bntMouseListener2);
            SoilInterestPanel.this.editBnt.addActionListener(new forEvent("DetailedProperty"));
            SoilInterestPanel.this.deleteBnt.addActionListener(new forEvent("DeleteSoil"));
            this.add(SoilInterestPanel.this.editBnt);
            this.add(SoilInterestPanel.this.deleteBnt);
        }
    }

    class TitlePanel
    extends JPanel {
        int xWidth = 546;
        int yHeight = 80;

        TitlePanel() {
            this.setPreferredSize(new Dimension(550, 80));
        }

        public void paintComponent(Graphics graphics) {
            int n = 0;
            if (RichardsEqn.osName.equals("Mac OS X")) {
                n = 0;
            }
            SoilInterestPanel.this.fm = this.getFontMetrics(this.getFont());
            graphics.setColor(Color.blue.darker());
            graphics.drawLine(10 + n, 9, this.xWidth + 1 + n, 9);
            graphics.drawLine(11 + n, 10, this.xWidth + n, 10);
            graphics.drawLine(10 + n, 9, 10 + n, this.yHeight + 1);
            graphics.drawLine(11 + n, 10, 11 + n, this.yHeight);
            graphics.drawLine(this.xWidth + n, 10, this.xWidth + n, this.yHeight);
            graphics.drawLine(this.xWidth + 1 + n, 9, this.xWidth + 1 + n, this.yHeight + 1);
            graphics.drawLine(61 + n, 10, 61 + n, this.yHeight);
            graphics.drawLine(131 + n, 10, 131 + n, this.yHeight);
            graphics.drawLine(261 + n, 10, 261 + n, this.yHeight);
            graphics.drawLine(421 + n, 10, 421 + n, this.yHeight);
            graphics.drawLine(486 + n, 10, 486 + n, this.yHeight);
            graphics.drawLine(11 + n, this.yHeight - 1, this.xWidth + n, this.yHeight - 1);
            int n2 = 10;
            graphics.setColor(Color.black);
            graphics.setFont(RichardsEqn.comboBoxFont);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            n2 += fontMetrics.getHeight();
            if (!RichardsEqn.semiInfiniteSelected) {
                graphics.drawString("Layer", 15 + n, n2);
                graphics.drawString("Thickness", 65 + n, n2);
            } else {
                graphics.drawString("Semi-", 15 + n, n2);
                graphics.drawString("Max Dis", 70 + n, n2);
            }
            graphics.drawString("Conductivity", 135 + n, n2);
            graphics.drawString("Water Characteristic", 270 + n, n2);
            graphics.drawString("Organic", 430 + n, n2);
            graphics.drawString("Bulk", 500 + n, n2);
            n2 += fontMetrics.getHeight();
            if (RichardsEqn.semiInfiniteSelected) {
                graphics.drawString("infinite", 15 + n, n2);
                graphics.drawString("to Plot", 75 + n, n2);
            } else {
                graphics.drawString("(" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + ")", 80 + n, n2);
            }
            graphics.drawString("Function", 145 + n, n2);
            graphics.drawString("Function", 315 + n, n2);
            graphics.drawString("Carbon", 430 + n, n2);
            graphics.drawString("Density", 492 + n, n2);
            n2 += fontMetrics.getHeight();
            if (RichardsEqn.semiInfiniteSelected) {
                graphics.drawString("Soil", 15 + n, n2);
                graphics.drawString("(" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + ")", 80 + n, n2);
            }
            graphics.drawString("(g/g)", 435 + n, n2);
            graphics.drawString("(Mg/m3)", 492 + n, n2);
        }
    }
}

