/*
 * Decompiled with CFR 0.152.
 */
public class Solution {
    public Soil s;
    public TransportProperties tp;
    public double[] z;
    public double[] h;
    public double[] fluxDensityWater;
    public double[] c;
    public double[] cumFluxWater;
    public double[] cumFluxChem;
    public double[] time;
    public double[] mp;
    public double[] q;
    public double[] con;
    public double[] fluxChem;
    public double[] massChem;
    public double depth;
    public int nPointsSaved;
    public int nPoints;
    public double sinAngle;
    public boolean isFinite;
    private int nodeOfDepth;
    private int horizonIndexOfDepth;

    public Solution(int n, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, Soil soil, double d, double d2, double[] dArray5, double[] dArray6, double[] dArray7, int n2, boolean bl) {
        int n3;
        Horizon[] horizonArray = new Horizon[soil.nHorizons];
        this.z = new double[n + 1];
        this.h = new double[n + 1];
        this.fluxDensityWater = new double[n + 1];
        this.cumFluxWater = new double[n + 1];
        this.nPoints = n;
        int n4 = 0;
        while (n4 < n) {
            this.z[n4] = dArray[n4];
            this.h[n4] = dArray2[n4];
            this.fluxDensityWater[n4] = dArray3[n4];
            this.cumFluxWater[n4] = dArray4[n4];
            ++n4;
        }
        if (n2 > 0) {
            this.nPointsSaved = n2;
            this.depth = d2;
            this.mp = new double[n2 + 1];
            this.q = new double[n2 + 1];
            this.time = new double[n2 + 2];
            n3 = 0;
            while (n3 < n2) {
                this.time[n3] = dArray5[n3];
                this.mp[n3] = dArray6[n3];
                this.q[n3] = dArray7[n3];
                ++n3;
            }
            this.time[n2] = dArray5[n2];
        }
        n3 = 0;
        while (n3 < soil.nHorizons) {
            horizonArray[n3] = soil.horizon[n3].duplicate();
            ++n3;
        }
        this.s = new Soil(soil.name, horizonArray);
        this.sinAngle = Math.sin(d * Math.PI / 180.0);
        this.horizonIndexOfDepth = soil.getHorizonIndex(this.depth);
        this.nodeOfDepth = this.getClosestNode(this.depth);
        this.isFinite = bl;
    }

    public Solution(int n, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6, Soil soil, TransportProperties transportProperties, double d, double d2, double[] dArray7, double[] dArray8, double[] dArray9, double[] dArray10, double[] dArray11, double[] dArray12, int n2, boolean bl) {
        this(n, dArray, dArray2, dArray3, dArray4, soil, d, d2, dArray7, dArray8, dArray9, n2, bl);
        this.tp = transportProperties;
        this.c = new double[n + 1];
        this.cumFluxChem = new double[n + 1];
        int n3 = 0;
        while (n3 < n) {
            this.c[n3] = dArray5[n3];
            this.cumFluxChem[n3] = dArray6[n3];
            ++n3;
        }
        if (n2 > 0) {
            this.con = new double[n2 + 1];
            this.fluxChem = new double[n2 + 1];
            this.massChem = new double[n2 + 1];
            int n4 = 0;
            while (n4 < n2) {
                this.con[n4] = dArray10[n4];
                this.fluxChem[n4] = dArray11[n4];
                this.massChem[n4] = dArray12[n4];
                ++n4;
            }
        }
    }

    public Solution() {
        this.nPoints = 0;
    }

    public double getMaxTime() {
        return this.time[this.nPointsSaved];
    }

    public double getWaterContent(int n) {
        int n2 = this.s.getHorizonIndex(this.z[n]);
        return this.getWaterContent(n2, n);
    }

    public double getWaterContent(int n, int n2) {
        return this.s.horizon[n].wc.getWC(this.h[n2]);
    }

    public double getWaterContentAtDepth(double d) {
        return this.s.horizon[this.horizonIndexOfDepth].wc.getWC(d);
    }

    public double getTotalPotential(int n) {
        return this.h[n] - this.sinAngle * this.z[n];
    }

    public double getTotalPotential(double d, double d2) {
        return d - this.sinAngle * d2;
    }

    public double getFluxDensity(int n) {
        return this.fluxDensityWater[n];
    }

    public double getFluxDensity(double d) {
        int n = this.getClosestNode(d);
        return this.fluxDensityWater[n];
    }

    public double getK(int n) {
        int n2 = this.s.getHorizonIndex(this.z[n]);
        return this.getK(n2, n);
    }

    public double getK(int n, int n2) {
        return this.s.horizon[n].getK(this.h[n2]);
    }

    public double getKatDepth(double d) {
        return this.s.horizon[this.horizonIndexOfDepth].getK(d);
    }

    public double getDrivingForceAtDepth(int n) {
        return this.q[n] / this.getKatDepth(this.mp[n]);
    }

    public double getDrivingForce(int n) {
        return this.fluxDensityWater[n] / this.getK(n);
    }

    public int getClosestNode(double d) {
        int n = 1;
        while (n < this.nPoints && this.z[n] < d) {
            ++n;
        }
        n = n == this.nPoints ? --n : (Math.abs(this.z[n] - d) < Math.abs(this.z[n - 1] - d) ? n : n - 1);
        return n;
    }

    public double getChemicalFluxDensity(double d) {
        int n = this.getClosestNode(d);
        int n2 = this.s.getHorizonIndex(this.z[n]);
        return this.getChemicalFluxDensity(n2, n);
    }

    public double getChemicalFluxDensity(int n, int n2) {
        double d = this.getWaterContent(n, n2);
        double d2 = this.fluxDensityWater[n2];
        double d3 = this.getDispersionCoef(this.tp.getDiffusionCoef(), this.tp.getDispersivity(), d2, d, this.s.horizon[n].wc.getWC(0.0));
        double d4 = n2 == 0 ? -d * d3 * ((this.c[1] - this.c[0]) / (this.z[1] - this.z[0])) + d2 * this.c[n2] : (n2 == this.nPoints - 1 ? -d * d3 * ((this.c[n2] - this.c[n2 - 1]) / (this.z[n2] - this.z[n2 - 1])) + d2 * this.c[n2] : -d * d3 * ((this.c[n2 + 1] - this.c[n2 - 1]) / (this.z[n2 + 1] - this.z[n2 - 1])) + d2 * this.c[n2]);
        return d4 / 100.0;
    }

    public double getChemicalFluxDensity(double[] dArray, double[] dArray2, double d, double d2, double d3, int n, int n2) {
        double d4 = n == 0 ? -d2 * d * ((dArray2[1] - dArray2[0]) / (dArray[1] - dArray[0])) + d3 * dArray2[0] : (n == n2 - 1 ? -d2 * d * ((dArray2[n] - dArray2[n - 1]) / (dArray[n] - dArray[n - 1])) + d3 * dArray2[n] : -d2 * d * ((dArray2[n + 1] - dArray2[n - 1]) / (dArray[n + 1] - dArray[n - 1])) + d3 * dArray2[n]);
        return d4 / 100.0;
    }

    public double getDispersionCoef(double d, double d2, double d3, double d4, double d5) {
        double d6 = Math.pow(d4, 3.3333333333333335) / (d5 * d5);
        return d * d6 + d2 * Math.abs(d3 / d4);
    }

    public double getTotalConcentration(int n) {
        int n2 = this.s.getHorizonIndex(this.z[n]);
        return this.getTotalConcentration(n2, n);
    }

    public double getTotalConcentration(double d) {
        int n = this.getClosestNode(d);
        return this.getTotalConcentration(n);
    }

    public double getTotalConcentration(int n, int n2) {
        double d = this.getWaterContent(n, n2);
        double d2 = this.s.horizon[n].getBulkDensity();
        double d3 = this.tp.getKd(this.z[n2], this.s);
        return (d + d2 * d3) * this.c[n2];
    }

    public double getTotalConcentrationAtTime(int n) {
        int n2 = this.getClosestNode(this.depth);
        int n3 = this.s.getHorizonIndex(this.depth);
        double d = this.getWaterContent(n3, n2);
        double d2 = this.s.horizon[n3].getBulkDensity();
        double d3 = this.tp.getKd(this.depth, this.s);
        return (d + d2 * d3) * this.con[n];
    }

    public String[] outputReportRows(double[] dArray, int[] nArray, int[] nArray2) {
        int n = 0;
        String[] stringArray = null;
        double d = RichardsEqn.displayTime(this.getMaxTime());
        int n2 = 2;
        n = dArray == this.z ? dArray.length - 1 : dArray.length;
        stringArray = new String[n];
        int n3 = 0;
        while (n3 < n) {
            int n4;
            double d2 = dArray[n3];
            int n5 = this.getClosestNode(d2);
            stringArray[n3] = Tools.formatDouble(d, 4, 8) + ",";
            if (dArray == this.z) {
                int n6 = n3;
                stringArray[n6] = stringArray[n6] + Tools.formatDouble(RichardsEqn.displayLength(this.z[n5]), 5, 9);
            } else {
                int n7 = n3;
                stringArray[n7] = stringArray[n7] + Tools.formatDouble(dArray[n3], 5, 9);
            }
            if (nArray != null) {
                n4 = 0;
                while (n4 < nArray.length) {
                    stringArray[n3] = stringArray[n3] + "," + this.getDesiredWaterData(nArray[n4], n5);
                    ++n4;
                }
            }
            if (nArray2 != null) {
                n4 = 0;
                while (n4 < nArray2.length) {
                    stringArray[n3] = stringArray[n3] + "," + this.getDesiredChemData(nArray2[n4], n5);
                    ++n4;
                }
            }
            ++n3;
        }
        return stringArray;
    }

    public String getDesiredWaterData(int n, int n2) {
        String string = null;
        switch (n) {
            case 0: {
                string = Tools.formatDouble(this.getWaterContent(n2), 3, 8);
                break;
            }
            case 1: {
                if (Math.abs(this.h[n2]) <= 1000000.0) {
                    string = Tools.formatDouble(RichardsEqn.displayLength(this.h[n2]), 3, 10);
                    break;
                }
                string = Tools.formatDouble(RichardsEqn.displayLength(this.h[n2]), 3, 10, "E");
                break;
            }
            case 2: {
                if (Math.abs(this.getTotalPotential(n2)) <= 1000000.0) {
                    string = Tools.formatDouble(RichardsEqn.displayLength(this.getTotalPotential(n2)), 3, 10);
                    break;
                }
                string = Tools.formatDouble(RichardsEqn.displayLength(this.getTotalPotential(n2)), 3, 10, "E");
                break;
            }
            case 3: {
                string = Tools.formatDouble(this.getDrivingForce(n2), 3, 12, "E");
                break;
            }
            case 4: {
                string = Tools.formatDouble(RichardsEqn.displayVelocity(this.getK(n2)), 3, 12, "E");
                break;
            }
            case 5: {
                string = Tools.formatDouble(RichardsEqn.displayVelocity(this.fluxDensityWater[n2]), 3, 12, "E");
                break;
            }
            case 6: {
                string = Tools.formatDouble(RichardsEqn.displayLength(this.cumFluxWater[n2]), 3, 12, "E");
            }
        }
        return string;
    }

    public String getDesiredChemData(int n, int n2) {
        String string = null;
        switch (n) {
            case 0: {
                string = Tools.formatDouble(this.c[n2], 3, 12, "E");
                break;
            }
            case 1: {
                string = Tools.formatDouble(this.c[n2] * RichardsEqn.kd, 3, 12, "E");
                break;
            }
            case 2: {
                string = Tools.formatDouble(this.getTotalConcentration(n2), 3, 12, "E");
                break;
            }
            case 3: {
                string = Tools.formatDouble(this.getChemicalFluxDensity(n2), 3, 12, "E");
                break;
            }
            case 4: {
                string = Tools.formatDouble(this.cumFluxChem[n2], 3, 12, "E");
            }
        }
        return string;
    }
}

