/*
 * Decompiled with CFR 0.152.
 */
public class TransportProperties {
    private double[] position;
    private double[] alpha;
    private double[] beta;
    private double[] gamma;
    private double[] kd;
    private double diffusion;
    private double dispersivity;
    private double Koc = 0.0;
    private boolean useKoc;

    public TransportProperties(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double d, double d2) {
        this.position = dArray;
        this.alpha = dArray2;
        this.beta = dArray3;
        this.gamma = dArray4;
        this.kd = dArray5;
        this.dispersivity = d;
        this.diffusion = d2;
        this.useKoc = false;
    }

    public TransportProperties(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double d, double d2, double d3) {
        double[] dArray5 = new double[dArray.length];
        int n = 0;
        while (n < dArray.length) {
            dArray5[n] = 0.0;
            ++n;
        }
        this.position = dArray;
        this.alpha = dArray2;
        this.beta = dArray3;
        this.gamma = dArray4;
        this.Koc = d;
        this.dispersivity = d2;
        this.diffusion = d3;
        this.useKoc = true;
    }

    public TransportProperties(double d, double d2, double d3, double d4, double d5, double d6) {
        this.position = new double[1];
        this.alpha = new double[1];
        this.beta = new double[1];
        this.gamma = new double[1];
        this.kd = new double[1];
        this.useKoc = false;
        this.dispersivity = d5;
        this.diffusion = d6;
        int n = 0;
        while (n < 1) {
            this.position[n] = 0.0;
            this.alpha[n] = d;
            this.beta[n] = d2;
            this.gamma[n] = d3;
            this.kd[n] = d4;
            ++n;
        }
    }

    public TransportProperties(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        this(d, d2, d3, d4, d5, d6);
        this.useKoc = true;
        this.Koc = d7;
    }

    public double getDiffusionCoef() {
        return this.diffusion;
    }

    public double getDispersivity() {
        return this.dispersivity;
    }

    public double getAlpha(double d) {
        return Tools.linearInterpolateY(d, this.position, this.alpha);
    }

    public double[] getAlphaArray(double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray2[n2] = Tools.linearInterpolateY(dArray[n2], this.position, this.alpha);
            ++n2;
        }
        return dArray2;
    }

    public double getBeta(double d) {
        return Tools.linearInterpolateY(d, this.position, this.beta);
    }

    public double[] getBetaArray(double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray2[n2] = Tools.linearInterpolateY(dArray[n2], this.position, this.beta);
            ++n2;
        }
        return dArray2;
    }

    public double getGamma(double d) {
        return Tools.linearInterpolateY(d, this.position, this.gamma);
    }

    public double[] getGammaArray(double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray2[n2] = Tools.linearInterpolateY(dArray[n2], this.position, this.gamma);
            ++n2;
        }
        return dArray2;
    }

    public double getKd(double d, Soil soil) {
        double d2 = this.useKoc ? this.Koc * soil.getOrganicCarbon(d) : Tools.linearInterpolateY(d, this.position, this.kd);
        return d2;
    }

    public double[] getKdArray(double[] dArray, Soil soil) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray2[n2] = this.useKoc ? this.Koc * soil.getOrganicCarbon(dArray[n2]) : Tools.linearInterpolateY(dArray[n2], this.position, this.kd);
            ++n2;
        }
        return dArray2;
    }

    public double[] getKdVal() {
        return this.kd;
    }

    public double[] getPsVal() {
        return this.position;
    }

    public double[] getAlpVal() {
        return this.alpha;
    }

    public double[] getBtVal() {
        return this.beta;
    }

    public double[] getGaVal() {
        return this.gamma;
    }

    public double getKoc() {
        return this.Koc;
    }
}

