/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class TransportPropertyPanel
extends ChemfloPanel {
    private JButton clearBnt;
    private JButton sortBnt;
    private Border oldBorder;
    private BevelBorder raisedEdge = new BevelBorder(0);
    private JPanel diffCoeBox;
    private JPanel disperBox;
    public JComboBox waterPartCoeBox;
    public JComboBox firstDegLiqBox;
    public JComboBox firstDegSoilBox;
    public JComboBox zeroDegBox;
    private Vector waterPartCoeNames;
    private Vector firstDegLiqNames;
    private Vector firstDegSoilNames;
    private Vector zeroDegNames;
    private JTextField diffCoeField;
    private JTextField disperField;
    private JTextField waterPartCoeField;
    private JTextField firstDegLiqField;
    private JTextField firstDegSoilField;
    private JTextField zeroDegField;
    private JScrollBar diffCoeBar;
    private JScrollBar disperBar;
    private JScrollBar waterPartCoeBar;
    private JScrollBar firstDegLiqBar;
    private JScrollBar firstDegSoilBar;
    private JScrollBar zeroProdBar;
    private JPanel tablePane;
    public TransPropTablePanel transPropPane;
    private JPanel noteP;
    private UpTransPropPanel upPane;
    private JPanel scrollPane;
    private FontMetrics fm;
    private Object[][] data;
    private Object[][] old_data;
    static boolean hasNonUniform = false;
    public boolean errorFree = true;
    private boolean error = false;
    private boolean liquidChange;
    private boolean soilChange;
    private boolean zeroChange;
    private int wid = 0;
    private int hgh = 0;
    private JPanel rootPane;
    private JPanel topPane;
    private JPanel northP;
    private JPanel southP;
    private JPanel westP;
    private JPanel eastP;
    private JTextField errorTF;

    public TransportPropertyPanel() {
        super("Transport Properties");
        this.setLayout(this.border);
        this.setBorder(this.edge);
        this.add((Component)this.titleP, "North");
        if (CHEMFLO.wMax) {
            this.wid = CHEMFLO.old_width - 220;
            this.hgh = CHEMFLO.old_height - 140;
        } else {
            this.wid = 592;
            this.hgh = 470;
        }
        this.rootPane = new JPanel();
        this.rootPane.setLayout(new BorderLayout());
        this.rootPane.setPreferredSize(new Dimension(this.wid, this.hgh));
        this.northP = new JPanel();
        this.northP.setPreferredSize(new Dimension(this.wid, 1));
        this.southP = new JPanel();
        this.southP.setPreferredSize(new Dimension(this.wid, 1));
        this.westP = new JPanel();
        this.westP.setPreferredSize(new Dimension(1, 470));
        this.eastP = new JPanel();
        this.eastP.setPreferredSize(new Dimension(1, 470));
        this.diffCoeBox = new JPanel();
        this.diffCoeBox.setPreferredSize(new Dimension(365, 25));
        this.diffCoeBox.setLayout(new BorderLayout());
        this.disperBox = new JPanel();
        this.disperBox.setPreferredSize(new Dimension(365, 25));
        this.disperBox.setLayout(new BorderLayout());
        this.topPane = new JPanel();
        this.topPane.setLayout(new BorderLayout());
        this.topPane.setPreferredSize(new Dimension(this.wid - 2, this.hgh - 2));
        this.upPane = new UpTransPropPanel();
        this.scrollPane = new JPanel();
        this.scrollPane.setLayout(new BorderLayout());
        this.scrollPane.add((Component)this.upPane, "Center");
        this.tablePane = new JPanel();
        this.tablePane.setPreferredSize(new Dimension(590, 275));
        this.tablePane.setLayout(null);
        this.noteP = new JPanel(){

            public void paintComponent(Graphics graphics) {
                graphics.setFont(RichardsEqn.noteFontI);
                graphics.drawString("These parameters are required only when simulating chemical", 15, 38);
                graphics.drawString("movement. The current initial conditions indicate that only water ", 15, 55);
                graphics.drawString("movement is to be simulated.", 15, 72);
            }
        };
        this.noteP.setPreferredSize(new Dimension(450, 90));
        this.noteP.setBackground(new Color(204, 204, 204));
        this.noteP.setBorder(new TitledBorder(new EtchedBorder(), "Note:", 1, 0, RichardsEqn.labelFont, Color.black));
        this.noteP.setBounds(60, 10, 450, 90);
        this.transPropPane = new TransPropTablePanel();
        this.transPropPane.setBounds(10, 0, 490, 270);
        this.tablePane.add(this.noteP);
        this.clearBnt = new JButton(" Clear ");
        this.clearBnt.setBounds(502, 100, 70, 30);
        this.clearBnt.setFont(RichardsEqn.buttonTextFont);
        this.tablePane.add(this.clearBnt);
        this.sortBnt = new JButton(" Sort ");
        this.sortBnt.setBounds(502, 150, 70, 30);
        this.sortBnt.setFont(RichardsEqn.buttonTextFont);
        this.tablePane.add(this.sortBnt);
        this.clearBnt.addActionListener(new forEvent("Clear"));
        this.sortBnt.addActionListener(new forEvent("Sort"));
        bntMouseListener bntMouseListener2 = new bntMouseListener();
        this.clearBnt.addMouseListener(bntMouseListener2);
        this.sortBnt.addMouseListener(bntMouseListener2);
        this.oldBorder = this.clearBnt.getBorder();
        this.topPane.add((Component)this.scrollPane, "North");
        this.topPane.add((Component)this.tablePane, "Center");
        this.rootPane.add((Component)this.northP, "North");
        this.rootPane.add((Component)this.westP, "West");
        this.rootPane.add((Component)this.topPane, "Center");
        this.rootPane.add((Component)this.eastP, "East");
        this.rootPane.add((Component)this.southP, "South");
        this.add((Component)this.rootPane, "Center");
        this.addMouseListener(new forEvent("TransPanel"));
        this.hiddenComponents();
    }

    public void updateWaterPart() {
        SortingTable sortingTable = null;
        this.error = !this.tableErrorFree();
        switch (RichardsEqn.waterPartCoeIndex) {
            case 0: {
                this.transPropPane.setCursor(Cursor.getPredefinedCursor(3));
                this.transPropPane.prepareTableBeforeSorting();
                sortingTable = new SortingTable(this.transPropPane.data, 0);
                this.transPropPane.data = sortingTable.SortTable2();
                int n = 0;
                while (n < this.transPropPane.data.length) {
                    this.transPropPane.data[n][1] = String.valueOf(RichardsEqn.kd);
                    ++n;
                }
                this.transPropPane.restoreTableAfterSorting(this.transPropPane.data);
                this.transPropPane.setCursor(Cursor.getPredefinedCursor(0));
                this.transPropPane.table.repaint();
                RichardsEqn.restart = true;
                break;
            }
            case 1: {
                this.transPropPane.setCursor(Cursor.getPredefinedCursor(3));
                this.transPropPane.prepareTableBeforeSorting();
                sortingTable = new SortingTable(this.transPropPane.data, 0);
                this.transPropPane.data = sortingTable.SortTable2();
                int n = 0;
                while (n < this.transPropPane.data.length) {
                    double d = Double.parseDouble((String)this.transPropPane.data[n][0]);
                    this.transPropPane.data[n][1] = Tools.formatDouble(RichardsEqn.Koc * RichardsEqn.editingSoil.getOrganicCarbon(d), 5, 5);
                    ++n;
                }
                this.transPropPane.restoreTableAfterSorting(this.transPropPane.data);
                this.transPropPane.setCursor(Cursor.getPredefinedCursor(0));
                this.transPropPane.table.repaint();
                RichardsEqn.restart = true;
            }
        }
    }

    public void updateFirstLiq() {
        if (RichardsEqn.firstDegLiqIndex == 0) {
            this.error = !this.tableErrorFree();
            this.transPropPane.setCursor(Cursor.getPredefinedCursor(3));
            this.transPropPane.prepareTableBeforeSorting();
            SortingTable sortingTable = new SortingTable(this.transPropPane.data, 0);
            this.transPropPane.data = sortingTable.SortTable2();
            int n = 0;
            while (n < this.transPropPane.data.length) {
                this.transPropPane.data[n][2] = String.valueOf(RichardsEqn.alph);
                ++n;
            }
            this.transPropPane.restoreTableAfterSorting(this.transPropPane.data);
            this.transPropPane.setCursor(Cursor.getPredefinedCursor(0));
            this.transPropPane.table.repaint();
            RichardsEqn.restart = true;
        }
    }

    public void updateFirstSoil() {
        if (RichardsEqn.firstDegSoilIndex == 0) {
            this.error = !this.tableErrorFree();
            this.transPropPane.setCursor(Cursor.getPredefinedCursor(3));
            this.transPropPane.prepareTableBeforeSorting();
            SortingTable sortingTable = new SortingTable(this.transPropPane.data, 0);
            this.transPropPane.data = sortingTable.SortTable2();
            int n = 0;
            while (n < this.transPropPane.data.length) {
                this.transPropPane.data[n][3] = String.valueOf(RichardsEqn.beta);
                ++n;
            }
            this.transPropPane.restoreTableAfterSorting(this.transPropPane.data);
            this.transPropPane.setCursor(Cursor.getPredefinedCursor(0));
            this.transPropPane.table.repaint();
            RichardsEqn.restart = true;
        }
    }

    public void updateZeroDeg() {
        if (RichardsEqn.zeroDegIndex == 0) {
            this.error = !this.tableErrorFree();
            this.transPropPane.setCursor(Cursor.getPredefinedCursor(3));
            this.transPropPane.prepareTableBeforeSorting();
            SortingTable sortingTable = new SortingTable(this.transPropPane.data, 0);
            this.transPropPane.data = sortingTable.SortTable2();
            int n = 0;
            while (n < this.transPropPane.data.length) {
                this.transPropPane.data[n][4] = String.valueOf(RichardsEqn.gamma);
                ++n;
            }
            this.transPropPane.restoreTableAfterSorting(this.transPropPane.data);
            this.transPropPane.setCursor(Cursor.getPredefinedCursor(0));
            this.transPropPane.table.repaint();
            RichardsEqn.restart = true;
        }
    }

    void hiddenComponents() {
        if (RichardsEqn.semiInfiniteSelected || RichardsEqn.selectedInitialCond2 == 0) {
            if (this.tablePane.getComponentCount() != 0) {
                this.tablePane.removeAll();
            }
            this.tablePane.add(this.noteP);
            this.tablePane.repaint();
            this.diffCoeBox.setVisible(false);
            this.disperBox.setVisible(false);
            this.waterPartCoeBox.setVisible(false);
            this.firstDegLiqBox.setVisible(false);
            this.firstDegSoilBox.setVisible(false);
            this.zeroDegBox.setVisible(false);
            this.diffCoeField.setVisible(false);
            this.disperField.setVisible(false);
            this.waterPartCoeField.setVisible(false);
            this.firstDegLiqField.setVisible(false);
            this.firstDegSoilField.setVisible(false);
            this.zeroDegField.setVisible(false);
            this.diffCoeBar.setVisible(false);
            this.disperBar.setVisible(false);
            this.waterPartCoeBar.setVisible(false);
            this.firstDegLiqBar.setVisible(false);
            this.firstDegSoilBar.setVisible(false);
            this.zeroProdBar.setVisible(false);
            this.transPropPane.setVisible(false);
            this.clearBnt.setVisible(false);
            this.sortBnt.setVisible(false);
            hasNonUniform = false;
        } else {
            if (this.tablePane.getComponentCount() != 0) {
                this.tablePane.removeAll();
            }
            this.tablePane.add(this.transPropPane);
            this.tablePane.add(this.clearBnt);
            this.tablePane.add(this.sortBnt);
            this.tablePane.repaint();
            this.diffCoeBox.setVisible(true);
            this.disperBox.setVisible(true);
            this.waterPartCoeBox.setVisible(true);
            this.firstDegLiqBox.setVisible(true);
            this.firstDegSoilBox.setVisible(true);
            this.zeroDegBox.setVisible(true);
            this.diffCoeField.setVisible(true);
            this.disperField.setVisible(true);
            this.diffCoeBar.setVisible(true);
            this.disperBar.setVisible(true);
            if (RichardsEqn.waterPartCoeIndex == 2) {
                this.waterPartCoeField.setVisible(false);
                this.waterPartCoeBar.setVisible(false);
            } else {
                this.waterPartCoeField.setVisible(true);
                this.waterPartCoeBar.setVisible(true);
            }
            if (RichardsEqn.firstDegLiqIndex != 0) {
                this.firstDegLiqField.setVisible(false);
                this.firstDegLiqBar.setVisible(false);
            } else {
                this.firstDegLiqField.setVisible(true);
                this.firstDegLiqBar.setVisible(true);
            }
            if (RichardsEqn.firstDegSoilIndex != 0) {
                this.firstDegSoilField.setVisible(false);
                this.firstDegSoilBar.setVisible(false);
            } else {
                this.firstDegSoilField.setVisible(true);
                this.firstDegSoilBar.setVisible(true);
            }
            if (RichardsEqn.zeroDegIndex == 0) {
                this.zeroDegField.setVisible(true);
                this.zeroProdBar.setVisible(true);
            } else {
                this.zeroDegField.setVisible(false);
                this.zeroProdBar.setVisible(false);
            }
            if (RichardsEqn.waterPartCoeIndex == 0 && RichardsEqn.firstDegLiqIndex == 0 && RichardsEqn.firstDegSoilIndex == 0 && RichardsEqn.zeroDegIndex == 0) {
                this.transPropPane.setVisible(false);
                this.clearBnt.setVisible(false);
                this.sortBnt.setVisible(false);
                hasNonUniform = false;
            } else {
                this.transPropPane.setVisible(true);
                this.clearBnt.setVisible(true);
                this.sortBnt.setVisible(true);
                hasNonUniform = true;
            }
            this.transPropPane.clearTable();
        }
        if (CHEMFLO.wMax) {
            this.updateSize();
        }
    }

    public boolean tableErrorFree() {
        if (hasNonUniform) {
            if (this.transPropPane.isEmptyTable()) {
                JDialog jDialog = new JDialog(new Frame(), "Warning");
                WarningMessagePanel warningMessagePanel = new WarningMessagePanel(jDialog, "Transport properties for the flow system must  be defined before leaving this option.");
                jDialog.getContentPane().setLayout(new BorderLayout());
                jDialog.getContentPane().add((Component)warningMessagePanel, "Center");
                Toolkit toolkit = this.getToolkit();
                Dimension dimension = toolkit.getScreenSize();
                jDialog.setLocation(dimension.width - jDialog.getWidth() >> 1, dimension.height - jDialog.getHeight() >> 1);
                jDialog.setDefaultCloseOperation(2);
                jDialog.show();
                return false;
            }
            if (this.checlValidTable()) {
                if (!RichardsEqn.semiInfiniteSelected && RichardsEqn.selectedInitialCond2 != 0) {
                    if (this.transPropPane.model.minPos == 0.0 && this.transPropPane.model.maxPos == RichardsEqn.length) {
                        return true;
                    }
                    JDialog jDialog = new JDialog(new Frame(), "Warning");
                    WarningMessagePanel warningMessagePanel = new WarningMessagePanel(jDialog, "There are errors in the transport property table: The minimum position must be defined at 0 and the maximum position must be " + RichardsEqn.length);
                    jDialog.getContentPane().setLayout(new BorderLayout());
                    jDialog.getContentPane().add((Component)warningMessagePanel, "Center");
                    Toolkit toolkit = this.getToolkit();
                    Dimension dimension = toolkit.getScreenSize();
                    jDialog.setLocation(dimension.width - jDialog.getWidth() >> 1, dimension.height - jDialog.getHeight() >> 1);
                    jDialog.setDefaultCloseOperation(2);
                    jDialog.show();
                    return false;
                }
                return true;
            }
            JDialog jDialog = new JDialog(new Frame(), "Warning");
            WarningMessagePanel warningMessagePanel = new WarningMessagePanel(jDialog, "Transport properties for the flow system must  be defined before leaving this option.");
            jDialog.getContentPane().setLayout(new BorderLayout());
            jDialog.getContentPane().add((Component)warningMessagePanel, "Center");
            Toolkit toolkit = this.getToolkit();
            Dimension dimension = toolkit.getScreenSize();
            jDialog.setLocation(dimension.width - jDialog.getWidth() >> 1, dimension.height - jDialog.getHeight() >> 1);
            jDialog.setDefaultCloseOperation(2);
            jDialog.show();
            return false;
        }
        return true;
    }

    private boolean checlValidTable() {
        boolean bl = true;
        int n = 0;
        int n2 = this.transPropPane.table.getRowCount();
        int n3 = this.transPropPane.table.getColumnCount();
        boolean[] blArray = new boolean[n2];
        int n4 = 0;
        while (n4 < n2) {
            if (((String)this.transPropPane.table.getValueAt(n4, 0)).equals("")) {
                blArray[n4] = false;
            } else {
                blArray[n4] = true;
                ++n;
            }
            ++n4;
        }
        int n5 = 0;
        while (n5 < n2) {
            int n6 = 0;
            while (n6 < n3) {
                if (blArray[n5] && ((String)this.transPropPane.table.getValueAt(n5, n6)).equals("")) {
                    bl = false;
                    break;
                }
                ++n6;
            }
            ++n5;
        }
        if (n == 0) {
            bl = false;
        }
        return bl;
    }

    public void refresh() {
        RichardsEqn.zeroDegIndex = 0;
        RichardsEqn.waterPartCoeIndex = 0;
        RichardsEqn.firstDegSoilIndex = 0;
        RichardsEqn.firstDegLiqIndex = 0;
        RichardsEqn.Koc = 0.0;
        RichardsEqn.kd = 0.0;
        RichardsEqn.alph = 0.0;
        RichardsEqn.beta = 0.0;
        RichardsEqn.gamma = 0.0;
        hasNonUniform = false;
        int n = 1;
        while (n < TransPropTableTestModel.editableInx.length) {
            TransPropTableTestModel.editableInx[n] = false;
            ++n;
        }
        this.error = false;
        this.errorFree = true;
        if (this.scrollPane.getComponentCount() != 0) {
            this.scrollPane.removeAll();
        }
        this.upPane = new UpTransPropPanel();
        this.scrollPane.add((Component)this.upPane, "Center");
        this.hiddenComponents();
    }

    public void ResetUnits() {
        this.diffCoeBox.add((Component)new JPanel(){

            public void paintComponent(Graphics graphics) {
                TransportPropertyPanel.this.fm = this.getFontMetrics(this.getFont());
                graphics.setColor(Color.black);
                graphics.setFont(RichardsEqn.labelFont);
                Tools.drawSpecialString("Diffusion Coefficient of Chemical in Water(" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "2/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ")", 5, 17, TransportPropertyPanel.this.fm, graphics);
            }
        }, "Center");
        this.disperBox.add((Component)new JPanel(){

            public void paintComponent(Graphics graphics) {
                TransportPropertyPanel.this.fm = this.getFontMetrics(this.getFont());
                graphics.setColor(Color.black);
                graphics.setFont(RichardsEqn.labelFont);
                Tools.drawSpecialString("Dispersivity (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + ")", 5, 17, TransportPropertyPanel.this.fm, graphics);
            }
        }, "Center");
        this.disperField.setText(RichardsEqn.formatLength(RichardsEqn.disp));
        this.firstDegLiqNames.removeAllElements();
        this.firstDegSoilNames.removeAllElements();
        this.waterPartCoeNames.removeAllElements();
        if (RichardsEqn.semiInfiniteSelected || RichardsEqn.selectedInitialCond2 == 0) {
            if (RichardsEqn.selectedLengthUnit == 0) {
                this.waterPartCoeNames.addElement("Uniform Partition Coefficient (m3/Mg soil)");
            } else {
                this.waterPartCoeNames.addElement("Uniform Partition Coefficient (cub. " + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "/g soil)");
            }
            this.firstDegLiqNames.addElement("Uniform 1st-Order Degradation Const., Liquid (1/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ")");
            this.firstDegSoilNames.addElement("Uniform 1st-Order Degradation Const., Soil (1/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ")");
            this.waterPartCoeBox.setSelectedIndex(RichardsEqn.waterPartCoeIndex);
            this.firstDegSoilBox.setSelectedIndex(RichardsEqn.firstDegSoilIndex);
            this.firstDegLiqBox.setSelectedIndex(RichardsEqn.firstDegLiqIndex);
        } else {
            if (RichardsEqn.selectedLengthUnit == 0) {
                this.waterPartCoeNames.addElement("Uniform Partition Coefficient (m3/Mg soil)");
                this.waterPartCoeNames.addElement("Estimate Partition Coef. Using Koc (m3/Mg OC)");
                this.waterPartCoeNames.addElement("Non-Uniform Partition Coefficient (m3/Mg soil)");
            } else {
                this.waterPartCoeNames.addElement("Uniform Partition Coefficient (m3/Mg)");
                this.waterPartCoeNames.addElement("Estimate Partition Coef. Using Koc (m3/Mg OC)");
                this.waterPartCoeNames.addElement("Non-Uniform Partition Coefficient (m3/Mg)");
            }
            this.firstDegLiqNames.addElement("Uniform 1st-Order Degradation Const., Liquid (1/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ")");
            this.firstDegLiqNames.addElement("Non-Uniform 1st-Order Degradation Const., Liquid (1/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ")");
            this.firstDegSoilNames.addElement("Uniform 1st-Order Degradation Const., Soil (1/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ")");
            this.firstDegSoilNames.addElement("Non-Uniform 1st-Order Degradation Const., Soil (1/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ")");
            this.waterPartCoeBox.setSelectedIndex(RichardsEqn.waterPartCoeIndex);
            this.firstDegSoilBox.setSelectedIndex(RichardsEqn.firstDegSoilIndex);
            this.firstDegLiqBox.setSelectedIndex(RichardsEqn.firstDegLiqIndex);
        }
    }

    public void getTransProperties() {
        if (RichardsEqn.semiInfiniteSelected || RichardsEqn.selectedInitialCond2 == 0) {
            this.getDatas();
            return;
        }
        if (!this.tableErrorFree()) {
            return;
        }
        this.getDatas();
    }

    public void getDatas() {
        if (hasNonUniform) {
            try {
                RichardsEqn.diff = Double.parseDouble(this.diffCoeField.getText());
                RichardsEqn.disp = Double.parseDouble(this.disperField.getText());
                this.sortingTable();
                this.data = this.transPropPane.data;
                this.extractTransProperties();
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        } else {
            try {
                RichardsEqn.diff = Double.parseDouble(this.diffCoeField.getText());
                RichardsEqn.disp = Double.parseDouble(this.disperField.getText());
                RichardsEqn.kd = Double.parseDouble(this.waterPartCoeField.getText());
                RichardsEqn.alph = Double.parseDouble(this.firstDegLiqField.getText());
                RichardsEqn.beta = Double.parseDouble(this.firstDegSoilField.getText());
                RichardsEqn.gamma = Double.parseDouble(this.zeroDegField.getText());
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
    }

    public void prepareTableBeforeSorting() {
        int n = 0;
        int n2 = this.transPropPane.table.getRowCount();
        int n3 = this.transPropPane.table.getColumnCount();
        boolean[] blArray = new boolean[n2];
        int n4 = 0;
        while (n4 < n2) {
            if (((String)this.transPropPane.table.getValueAt(n4, 0)).equals("")) {
                blArray[n4] = false;
            } else {
                blArray[n4] = true;
                ++n;
            }
            ++n4;
        }
        this.data = new Object[n][n3];
        int n5 = 0;
        int n6 = 0;
        while (n6 < n2) {
            int n7 = 0;
            while (n7 < n3) {
                if (blArray[n6]) {
                    this.data[n5][n7] = this.transPropPane.table.getValueAt(n6, n7);
                    if (n7 == n3 - 1) {
                        ++n5;
                    }
                }
                ++n7;
            }
            ++n6;
        }
    }

    void extractTransProperties() {
        int n = this.data.length;
        int n2 = this.data[0].length;
        RichardsEqn.Position = new double[n];
        RichardsEqn.Alpha = new double[n];
        RichardsEqn.Beta = new double[n];
        RichardsEqn.Gamma = new double[n];
        RichardsEqn.Kd = new double[n];
        int n3 = 0;
        while (n3 < n) {
            RichardsEqn.Position[n3] = Double.parseDouble((String)this.data[n3][0]);
            ++n3;
        }
        int n4 = 0;
        while (n4 < n) {
            RichardsEqn.Kd[n4] = Double.parseDouble((String)this.data[n4][1]);
            ++n4;
        }
        int n5 = 0;
        while (n5 < n) {
            RichardsEqn.Alpha[n5] = Double.parseDouble((String)this.data[n5][2]);
            ++n5;
        }
        int n6 = 0;
        while (n6 < n) {
            RichardsEqn.Beta[n6] = Double.parseDouble((String)this.data[n6][3]);
            ++n6;
        }
        int n7 = 0;
        while (n7 < n) {
            RichardsEqn.Gamma[n7] = Double.parseDouble((String)this.data[n7][4]);
            ++n7;
        }
        if (this.old_data != null) {
            int n8;
            if (this.old_data.length != n || this.old_data[0].length != this.data[0].length) {
                RichardsEqn.restart = true;
            } else {
                n8 = 0;
                while (n8 < n) {
                    if (!((String)this.old_data[n8][0]).trim().equals(((String)this.data[n8][0]).trim())) {
                        RichardsEqn.restart = true;
                    }
                    if (!((String)this.old_data[n8][1]).trim().equals(((String)this.data[n8][1]).trim())) {
                        RichardsEqn.restart = true;
                    }
                    if (!((String)this.old_data[n8][2]).trim().equals(((String)this.data[n8][2]).trim())) {
                        RichardsEqn.restart = true;
                    }
                    if (!((String)this.old_data[n8][3]).trim().equals(((String)this.data[n8][3]).trim())) {
                        RichardsEqn.restart = true;
                    }
                    if (!((String)this.old_data[n8][4]).trim().equals(((String)this.data[n8][4]).trim())) {
                        RichardsEqn.restart = true;
                    }
                    ++n8;
                }
            }
            this.old_data = new Object[this.data.length][this.data[0].length];
            n8 = 0;
            while (n8 < this.data.length) {
                int n9 = 0;
                while (n9 < this.data[0].length) {
                    this.old_data[n8][n9] = new String((String)this.data[n8][n9]);
                    ++n9;
                }
                ++n8;
            }
        } else {
            this.old_data = new Object[this.data.length][this.data[0].length];
            int n10 = 0;
            while (n10 < this.data.length) {
                int n11 = 0;
                while (n11 < this.data[0].length) {
                    this.old_data[n10][n11] = new String((String)this.data[n10][n11]);
                    ++n11;
                }
                ++n10;
            }
        }
    }

    public void sortingTable() {
        this.transPropPane.setCursor(Cursor.getPredefinedCursor(3));
        this.transPropPane.prepareTableBeforeSorting();
        SortingTable sortingTable = new SortingTable(this.transPropPane.data, 0);
        this.transPropPane.data = sortingTable.SortTable2();
        this.transPropPane.restoreTableAfterSorting(this.transPropPane.data);
        this.transPropPane.setCursor(Cursor.getPredefinedCursor(0));
        this.transPropPane.table.repaint();
    }

    public void performed() {
        try {
            String string = this.diffCoeField.getText();
            this.errorTF = this.diffCoeField;
            double d = Double.parseDouble(string);
            if (d < 0.0 || d > 10.0) {
                throw new IllegalValueException("Diffusion Coefficient must be between 0 to 10.00.");
            }
            if (d != RichardsEqn.diff) {
                RichardsEqn.diff = d;
                this.diffCoeBar.setValue((int)(RichardsEqn.diff * 1000.0 + 0.5));
                RichardsEqn.diff = d;
                this.diffCoeField.setText(string);
                RichardsEqn.restart = true;
            }
            string = this.disperField.getText();
            this.errorTF = this.disperField;
            d = Double.parseDouble(string);
            if (d < 0.0 || d > 1000.0) {
                throw new IllegalValueException("Dispersivity must be between 0 to 1000.");
            }
            if (d != RichardsEqn.disp) {
                RichardsEqn.disp = d;
                this.disperBar.setValue((int)(RichardsEqn.disp * 10.0 + 0.5));
                RichardsEqn.disp = d;
                this.disperField.setText(string);
                RichardsEqn.restart = true;
            }
            if (RichardsEqn.waterPartCoeIndex != 2) {
                this.errorTF = this.waterPartCoeField;
                switch (RichardsEqn.waterPartCoeIndex) {
                    case 0: {
                        string = this.waterPartCoeField.getText();
                        d = Double.parseDouble(string);
                        if (d < 0.0 || d > 1000.0) {
                            throw new IllegalValueException("Partition Coefficient must be between 0 to 1000.");
                        }
                        if (d == RichardsEqn.kd) break;
                        RichardsEqn.kd = d;
                        this.waterPartCoeBar.setValue((int)(RichardsEqn.kd * 10.0 + 0.5));
                        RichardsEqn.kd = d;
                        this.waterPartCoeField.setText(string);
                        RichardsEqn.restart = true;
                        RichardsEqn.usingKoc = false;
                        break;
                    }
                    case 1: {
                        string = this.waterPartCoeField.getText();
                        d = Double.parseDouble(string);
                        if (d < 0.0 || d > 100000.0) {
                            throw new IllegalValueException("Koc must be between 0 to 100000.");
                        }
                        if (d == RichardsEqn.Koc) break;
                        RichardsEqn.Koc = d;
                        this.waterPartCoeBar.setValue((int)(RichardsEqn.Koc * 10.0 + 0.5));
                        RichardsEqn.Koc = d;
                        this.waterPartCoeField.setText(string);
                        RichardsEqn.usingKoc = true;
                        RichardsEqn.restart = true;
                    }
                }
            }
            if (RichardsEqn.firstDegLiqIndex == 0) {
                string = this.firstDegLiqField.getText();
                this.errorTF = this.firstDegLiqField;
                d = Double.parseDouble(string);
                if (d < 0.0 || d > 1.0) {
                    throw new IllegalValueException("First-order deg. const. liquid must be between 0 to 1.000.");
                }
                if (d != RichardsEqn.alph) {
                    RichardsEqn.alph = d;
                    this.firstDegLiqBar.setValue((int)(RichardsEqn.alph * 10000.0 + 0.5));
                    RichardsEqn.alph = d;
                    this.firstDegLiqField.setText(string);
                    RichardsEqn.restart = true;
                }
            }
            if (RichardsEqn.firstDegSoilIndex == 0) {
                string = this.firstDegSoilField.getText();
                this.errorTF = this.firstDegSoilField;
                d = Double.parseDouble(string);
                if (d < 0.0 || d > 1.0) {
                    throw new IllegalValueException("First-order deg. const. soil must be between 0 to 1.000.");
                }
                if (d != RichardsEqn.beta) {
                    RichardsEqn.beta = d;
                    this.firstDegSoilBar.setValue((int)(RichardsEqn.beta * 10000.0 + 0.5));
                    RichardsEqn.beta = d;
                    this.firstDegSoilField.setText(string);
                    RichardsEqn.restart = true;
                }
            }
            if (RichardsEqn.zeroDegIndex == 0) {
                string = this.zeroDegField.getText();
                this.errorTF = this.zeroDegField;
                d = Double.parseDouble(string);
                if (d < -100.0 || d > 100.0) {
                    throw new IllegalValueException("Zero-order production constant must be between -100 and 100.");
                }
                if (d != RichardsEqn.gamma) {
                    RichardsEqn.gamma = d;
                    this.zeroProdBar.setValue((int)(RichardsEqn.gamma * 10.0 + 1000.5));
                    RichardsEqn.gamma = d;
                    this.zeroDegField.setText(string);
                    RichardsEqn.restart = true;
                }
            }
            this.errorFree = true;
        }
        catch (Exception exception) {
            RichardsEqn.errorMessage = exception instanceof IllegalValueException ? new String("Transproperties: " + exception.getMessage()) : new String("Transproperties Error in number format");
            this.errorFree = false;
        }
    }

    public boolean getHasTable() {
        return hasNonUniform;
    }

    public void setupDefaultData() {
        int n = 10;
        double d = RichardsEqn.length / (double)n;
        if (RichardsEqn.firstDegLiqIndex == 0 && RichardsEqn.firstDegSoilIndex == 0 && RichardsEqn.zeroDegIndex == 0) {
            if (this.transPropPane.data.length > 0) {
                if (Double.parseDouble((String)this.transPropPane.data[this.transPropPane.data.length - 1][0]) != RichardsEqn.length) {
                    this.transPropPane.data = new Object[n + 1][5];
                    int n2 = 0;
                    while (n2 <= n) {
                        this.transPropPane.data[n2][0] = String.valueOf(Tools.formatDouble(d * (double)n2, 1, 8));
                        this.transPropPane.data[n2][1] = Tools.formatDouble(RichardsEqn.Koc * RichardsEqn.editingSoil.getOrganicCarbon(d * (double)n2), 4, 12);
                        this.transPropPane.data[n2][2] = String.valueOf(Tools.formatDouble(RichardsEqn.alph, 4, 12));
                        this.transPropPane.data[n2][3] = String.valueOf(Tools.formatDouble(RichardsEqn.beta, 4, 12));
                        this.transPropPane.data[n2][4] = String.valueOf(Tools.formatDouble(RichardsEqn.gamma, 4, 12));
                        ++n2;
                    }
                } else if (this.transPropPane.data.length > n + 1) {
                    int n3 = 0;
                    while (n3 < this.transPropPane.data.length) {
                        double d2 = Double.parseDouble((String)this.transPropPane.data[n3][0]);
                        this.transPropPane.data[n3][1] = Tools.formatDouble(RichardsEqn.Koc * RichardsEqn.editingSoil.getOrganicCarbon(d2), 4, 12);
                        this.transPropPane.data[n3][2] = String.valueOf(Tools.formatDouble(RichardsEqn.alph, 4, 12));
                        this.transPropPane.data[n3][3] = String.valueOf(Tools.formatDouble(RichardsEqn.beta, 4, 12));
                        this.transPropPane.data[n3][4] = String.valueOf(Tools.formatDouble(RichardsEqn.gamma, 4, 12));
                        ++n3;
                    }
                } else if (this.transPropPane.data.length == 0) {
                    this.transPropPane.data = new Object[n + 1][5];
                    int n4 = 0;
                    while (n4 <= n) {
                        this.transPropPane.data[n4][0] = String.valueOf(Tools.formatDouble(d * (double)n4, 1, 8));
                        this.transPropPane.data[n4][1] = Tools.formatDouble(RichardsEqn.Koc * RichardsEqn.editingSoil.getOrganicCarbon(d * (double)n4), 4, 12);
                        this.transPropPane.data[n4][2] = String.valueOf(Tools.formatDouble(RichardsEqn.alph, 4, 12));
                        this.transPropPane.data[n4][3] = String.valueOf(Tools.formatDouble(RichardsEqn.beta, 4, 12));
                        this.transPropPane.data[n4][4] = String.valueOf(Tools.formatDouble(RichardsEqn.gamma, 4, 12));
                        ++n4;
                    }
                } else {
                    int n5 = 0;
                    while (n5 < this.transPropPane.data.length) {
                        double d3 = Double.parseDouble((String)this.transPropPane.data[n5][0]);
                        this.transPropPane.data[n5][1] = Tools.formatDouble(RichardsEqn.Koc * RichardsEqn.editingSoil.getOrganicCarbon(d3), 4, 12);
                        this.transPropPane.data[n5][2] = String.valueOf(Tools.formatDouble(RichardsEqn.alph, 4, 12));
                        this.transPropPane.data[n5][3] = String.valueOf(Tools.formatDouble(RichardsEqn.beta, 4, 12));
                        this.transPropPane.data[n5][4] = String.valueOf(Tools.formatDouble(RichardsEqn.gamma, 4, 12));
                        ++n5;
                    }
                }
            } else {
                this.transPropPane.data = new Object[n + 1][5];
                int n6 = 0;
                while (n6 <= n) {
                    this.transPropPane.data[n6][0] = String.valueOf(Tools.formatDouble(d * (double)n6, 1, 8));
                    this.transPropPane.data[n6][1] = Tools.formatDouble(RichardsEqn.Koc * RichardsEqn.editingSoil.getOrganicCarbon(d * (double)n6), 4, 12);
                    this.transPropPane.data[n6][2] = String.valueOf(Tools.formatDouble(RichardsEqn.alph, 4, 12));
                    this.transPropPane.data[n6][3] = String.valueOf(Tools.formatDouble(RichardsEqn.beta, 4, 12));
                    this.transPropPane.data[n6][4] = String.valueOf(Tools.formatDouble(RichardsEqn.gamma, 4, 12));
                    ++n6;
                }
                this.transPropPane.restoreTableAfterSorting(this.transPropPane.data);
                this.transPropPane.setCursor(Cursor.getPredefinedCursor(0));
                this.transPropPane.table.repaint();
            }
            this.transPropPane.restoreTableAfterSorting(this.transPropPane.data);
            this.transPropPane.setCursor(Cursor.getPredefinedCursor(0));
            this.transPropPane.table.repaint();
        } else {
            Object[][] objectArray = new Object[n + 1][5];
            int n7 = 0;
            while (n7 <= n) {
                int n8 = 0;
                while (n8 < 5) {
                    objectArray[n7][n8] = "";
                    ++n8;
                }
                ++n7;
            }
            if (this.transPropPane.data.length > n + 1) {
                if (Double.parseDouble((String)this.transPropPane.data[this.transPropPane.data.length - 1][0]) == RichardsEqn.length) {
                    int n9 = 0;
                    while (n9 < this.transPropPane.data.length) {
                        double d4 = Double.parseDouble((String)this.transPropPane.data[n9][0]);
                        this.transPropPane.data[n9][1] = Tools.formatDouble(RichardsEqn.Koc * RichardsEqn.editingSoil.getOrganicCarbon(d4), 4, 12);
                        if (RichardsEqn.firstDegLiqIndex == 0) {
                            this.transPropPane.data[n9][2] = String.valueOf(Tools.formatDouble(RichardsEqn.alph, 4, 12));
                        } else if (this.liquidChange) {
                            this.transPropPane.data[n9][2] = "";
                        }
                        if (RichardsEqn.firstDegSoilIndex == 0) {
                            this.transPropPane.data[n9][3] = String.valueOf(Tools.formatDouble(RichardsEqn.beta, 4, 12));
                        }
                        if (this.soilChange) {
                            this.transPropPane.data[n9][3] = "";
                        }
                        if (RichardsEqn.zeroDegIndex == 0) {
                            this.transPropPane.data[n9][4] = String.valueOf(Tools.formatDouble(RichardsEqn.gamma, 4, 12));
                        }
                        if (this.zeroChange) {
                            this.transPropPane.data[n9][4] = "";
                        }
                        ++n9;
                    }
                } else {
                    int n10 = 0;
                    while (n10 <= n) {
                        objectArray[n10][0] = String.valueOf(Tools.formatDouble(d * (double)n10, 1, 8));
                        objectArray[n10][1] = Tools.formatDouble(RichardsEqn.Koc * RichardsEqn.editingSoil.getOrganicCarbon(d * (double)n10), 4, 12);
                        if (RichardsEqn.firstDegLiqIndex == 0) {
                            objectArray[n10][2] = String.valueOf(Tools.formatDouble(RichardsEqn.alph, 4, 12));
                        } else if (!this.liquidChange) {
                            objectArray[n10][2] = this.transPropPane.data[n10][2];
                        }
                        if (RichardsEqn.firstDegSoilIndex == 0) {
                            objectArray[n10][3] = String.valueOf(Tools.formatDouble(RichardsEqn.beta, 4, 12));
                        } else if (!this.soilChange) {
                            objectArray[n10][3] = this.transPropPane.data[n10][3];
                        }
                        if (RichardsEqn.zeroDegIndex == 0) {
                            objectArray[n10][4] = String.valueOf(Tools.formatDouble(RichardsEqn.gamma, 4, 12));
                        } else if (!this.zeroChange) {
                            objectArray[n10][4] = this.transPropPane.data[n10][4];
                        }
                        ++n10;
                    }
                    this.transPropPane.data = objectArray;
                }
            } else if (this.transPropPane.data.length > 0) {
                if (Double.parseDouble((String)this.transPropPane.data[this.transPropPane.data.length - 1][0]) == RichardsEqn.length) {
                    int n11 = 0;
                    while (n11 < this.transPropPane.data.length) {
                        double d5 = Double.parseDouble((String)this.transPropPane.data[n11][0]);
                        this.transPropPane.data[n11][1] = Tools.formatDouble(RichardsEqn.Koc * RichardsEqn.editingSoil.getOrganicCarbon(d5), 4, 12);
                        if (RichardsEqn.firstDegLiqIndex == 0) {
                            this.transPropPane.data[n11][2] = String.valueOf(Tools.formatDouble(RichardsEqn.alph, 4, 12));
                        } else if (this.liquidChange) {
                            this.transPropPane.data[n11][2] = "";
                        }
                        if (RichardsEqn.firstDegSoilIndex == 0) {
                            this.transPropPane.data[n11][3] = String.valueOf(Tools.formatDouble(RichardsEqn.beta, 4, 12));
                        } else if (this.soilChange) {
                            this.transPropPane.data[n11][3] = "";
                        }
                        if (RichardsEqn.zeroDegIndex == 0) {
                            this.transPropPane.data[n11][4] = String.valueOf(Tools.formatDouble(RichardsEqn.gamma, 4, 12));
                        } else if (this.zeroChange) {
                            this.transPropPane.data[n11][4] = "";
                        }
                        ++n11;
                    }
                } else {
                    int n12 = 0;
                    while (n12 <= n) {
                        objectArray[n12][0] = String.valueOf(Tools.formatDouble(d * (double)n12, 1, 8));
                        objectArray[n12][1] = Tools.formatDouble(RichardsEqn.Koc * RichardsEqn.editingSoil.getOrganicCarbon(d * (double)n12), 4, 12);
                        if (RichardsEqn.firstDegLiqIndex == 0) {
                            objectArray[n12][2] = String.valueOf(Tools.formatDouble(RichardsEqn.alph, 4, 12));
                        }
                        if (RichardsEqn.firstDegSoilIndex == 0) {
                            objectArray[n12][3] = String.valueOf(Tools.formatDouble(RichardsEqn.beta, 4, 12));
                        }
                        if (RichardsEqn.zeroDegIndex == 0) {
                            objectArray[n12][4] = String.valueOf(Tools.formatDouble(RichardsEqn.gamma, 4, 12));
                        }
                        ++n12;
                    }
                    this.transPropPane.data = objectArray;
                }
            } else if (this.transPropPane.data.length == 0) {
                int n13 = 0;
                while (n13 <= n) {
                    objectArray[n13][0] = String.valueOf(Tools.formatDouble(d * (double)n13, 1, 8));
                    objectArray[n13][1] = Tools.formatDouble(RichardsEqn.Koc * RichardsEqn.editingSoil.getOrganicCarbon(d * (double)n13), 4, 12);
                    if (RichardsEqn.firstDegLiqIndex == 0) {
                        objectArray[n13][2] = String.valueOf(Tools.formatDouble(RichardsEqn.alph, 4, 12));
                    }
                    if (RichardsEqn.firstDegSoilIndex == 0) {
                        objectArray[n13][3] = String.valueOf(Tools.formatDouble(RichardsEqn.beta, 4, 12));
                    }
                    if (RichardsEqn.zeroDegIndex == 0) {
                        objectArray[n13][4] = String.valueOf(Tools.formatDouble(RichardsEqn.gamma, 4, 12));
                    }
                    ++n13;
                }
                this.transPropPane.data = objectArray;
            }
            this.transPropPane.restoreTableAfterSorting(this.transPropPane.data);
            this.transPropPane.setCursor(Cursor.getPredefinedCursor(0));
            this.transPropPane.table.repaint();
            this.liquidChange = false;
            this.soilChange = false;
            this.zeroChange = false;
        }
    }

    public void updateSize() {
        if (CHEMFLO.wMax) {
            this.wid = CHEMFLO.old_width - 220;
            this.hgh = CHEMFLO.old_height - 140;
        } else {
            this.wid = 592;
            this.hgh = 470;
        }
        if (this.rootPane.getComponentCount() != 0) {
            this.rootPane.removeAll();
        }
        this.rootPane.setPreferredSize(new Dimension(this.wid, this.hgh));
        int n = (int)((double)(this.hgh - 470) / 3.0);
        this.northP.setPreferredSize(new Dimension(this.wid, n));
        if (CHEMFLO.wMax) {
            this.southP.setPreferredSize(new Dimension(this.wid, n - 10));
        } else {
            this.southP.setPreferredSize(new Dimension(this.wid, n));
        }
        int n2 = (int)((double)(this.wid - 592) / 2.0);
        this.westP.setPreferredSize(new Dimension(n2, 470));
        this.eastP.setPreferredSize(new Dimension(n2 - 5, 470));
        this.tablePane.setPreferredSize(new Dimension(590, 245 + n));
        this.transPropPane.setBounds(10, 0, 490, 245 + n);
        this.clearBnt.setBounds(502, 100 + n / 2, 70, 30);
        this.sortBnt.setBounds(502, 150 + n / 2, 70, 30);
        this.rootPane.add((Component)this.northP, "North");
        this.rootPane.add((Component)this.westP, "West");
        this.rootPane.add((Component)this.topPane, "Center");
        this.rootPane.add((Component)this.eastP, "East");
        this.rootPane.add((Component)this.southP, "South");
        this.rootPane.repaint();
    }

    public Vector getTransPropData() {
        Vector<String> vector = new Vector<String>();
        vector.addElement("Transport properties:");
        if (RichardsEqn.selectedInitialCond2 > 0) {
            vector.addElement(new String("Parameter                                        Value"));
            vector.addElement(new String("Diffusion Coefficient                            " + RichardsEqn.diff + " " + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "2/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit]));
            vector.addElement(new String("Dispersivity                                     " + RichardsEqn.disp + " " + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit]));
            if (!hasNonUniform) {
                vector.addElement(new String("Partition coefficient                            " + RichardsEqn.kd + " " + "m3/Mg"));
                vector.addElement(new String("First-order degradation rate const. in liquid    " + RichardsEqn.alph + " 1/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit]));
                vector.addElement(new String("First-order degradation rate const. on solids    " + RichardsEqn.beta + " 1/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit]));
                vector.addElement(new String("Zero-order production rate                       " + RichardsEqn.gamma + " g/m3/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit]));
            }
            if (hasNonUniform) {
                vector.addElement("");
                vector.addElement(new String("   Position     Partition Coeff.  1st-Order Rate    1st-Order Rate    Zero-Order Rate "));
                vector.addElement(new String("     (cm)          (m3/Mg)        Const. in Liquid  Const. in Solids      Const."));
                vector.addElement(new String("                                      (1/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ")" + "            (1/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ")" + "          (g/m3/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ")"));
                StringBuffer stringBuffer = null;
                int n = this.transPropPane.valid_idx;
                int n2 = this.transPropPane.model.getColumnCount();
                int n3 = 0;
                while (n3 < n) {
                    stringBuffer = new StringBuffer();
                    int n4 = 0;
                    while (n4 < n2) {
                        Object object = this.transPropPane.model.getValueAt(n3, n4);
                        stringBuffer.append(object.toString() + "      ");
                        ++n4;
                    }
                    vector.addElement(stringBuffer.toString());
                    ++n3;
                }
            }
        } else {
            vector.addElement("These parameters are required only when simulating chemical movement.");
            vector.addElement("The current initial conditions indicate that only water movement is to be simulated.");
        }
        return vector;
    }

    class bntMouseListener
    extends MouseAdapter {
        bntMouseListener() {
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (TransportPropertyPanel.this.clearBnt == (JButton)mouseEvent.getSource()) {
                TransportPropertyPanel.this.clearBnt.setBorder(TransportPropertyPanel.this.oldBorder);
            }
            if (TransportPropertyPanel.this.sortBnt == (JButton)mouseEvent.getSource()) {
                TransportPropertyPanel.this.sortBnt.setBorder(TransportPropertyPanel.this.oldBorder);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (TransportPropertyPanel.this.clearBnt == (JButton)mouseEvent.getSource()) {
                TransportPropertyPanel.this.clearBnt.setBorder(TransportPropertyPanel.this.raisedEdge);
            }
            if (TransportPropertyPanel.this.sortBnt == (JButton)mouseEvent.getSource()) {
                TransportPropertyPanel.this.sortBnt.setBorder(TransportPropertyPanel.this.raisedEdge);
                TransportPropertyPanel.this.performed();
                if (!TransportPropertyPanel.this.errorFree) {
                    JOptionPane.showMessageDialog(CHEMFLO.appWin, RichardsEqn.errorMessage, "Error", 0);
                    CHEMFLO.appWin.repaint();
                    TransportPropertyPanel.this.errorTF.grabFocus();
                }
            }
        }
    }

    class forEvent
    extends MouseAdapter
    implements AdjustmentListener,
    ActionListener,
    ItemListener {
        int iTemp;
        double dTemp;
        String sTemp;
        String name;

        public forEvent(String string) {
            this.name = string;
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            if (this.name.equals("diffCoe")) {
                int n = TransportPropertyPanel.this.diffCoeBar.getValue();
                RichardsEqn.diff = (double)n / 1000.0;
                TransportPropertyPanel.this.diffCoeField.setText(String.valueOf(RichardsEqn.diff));
                RichardsEqn.restart = true;
            } else if (this.name.equals("Disper")) {
                int n = TransportPropertyPanel.this.disperBar.getValue();
                RichardsEqn.disp = (double)n / 10.0;
                TransportPropertyPanel.this.disperField.setText(RichardsEqn.formatLength(RichardsEqn.disp));
                RichardsEqn.restart = true;
            } else if (this.name.equals("waterPart")) {
                TransportPropertyPanel.this.error = false;
                if (hasNonUniform) {
                    if (!TransportPropertyPanel.this.transPropPane.isEmptyTable()) {
                        switch (RichardsEqn.waterPartCoeIndex) {
                            case 0: {
                                int n = TransportPropertyPanel.this.waterPartCoeBar.getValue();
                                RichardsEqn.kd = (double)n / 10.0;
                                TransportPropertyPanel.this.waterPartCoeField.setText(String.valueOf(RichardsEqn.kd));
                                break;
                            }
                            case 1: {
                                int n = TransportPropertyPanel.this.waterPartCoeBar.getValue();
                                RichardsEqn.Koc = (double)n / 10.0;
                                TransportPropertyPanel.this.waterPartCoeField.setText(String.valueOf(RichardsEqn.Koc));
                            }
                        }
                        TransportPropertyPanel.this.updateWaterPart();
                    } else {
                        switch (RichardsEqn.waterPartCoeIndex) {
                            case 0: {
                                int n = TransportPropertyPanel.this.waterPartCoeBar.getValue();
                                RichardsEqn.kd = (double)n / 10.0;
                                TransportPropertyPanel.this.waterPartCoeField.setText(String.valueOf(RichardsEqn.kd));
                                RichardsEqn.restart = true;
                                RichardsEqn.usingKoc = false;
                                break;
                            }
                            case 1: {
                                int n = TransportPropertyPanel.this.waterPartCoeBar.getValue();
                                RichardsEqn.Koc = (double)n / 10.0;
                                TransportPropertyPanel.this.waterPartCoeField.setText(String.valueOf(RichardsEqn.Koc));
                                RichardsEqn.usingKoc = true;
                                RichardsEqn.restart = true;
                            }
                        }
                    }
                } else {
                    switch (RichardsEqn.waterPartCoeIndex) {
                        case 0: {
                            int n = TransportPropertyPanel.this.waterPartCoeBar.getValue();
                            RichardsEqn.kd = (double)n / 10.0;
                            TransportPropertyPanel.this.waterPartCoeField.setText(String.valueOf(RichardsEqn.kd));
                            RichardsEqn.usingKoc = false;
                            RichardsEqn.restart = true;
                            break;
                        }
                        case 1: {
                            int n = TransportPropertyPanel.this.waterPartCoeBar.getValue();
                            RichardsEqn.Koc = (double)n / 10.0;
                            TransportPropertyPanel.this.waterPartCoeField.setText(String.valueOf(RichardsEqn.Koc));
                            RichardsEqn.usingKoc = true;
                            RichardsEqn.restart = true;
                        }
                    }
                }
            } else if (this.name.equals("firstLiq")) {
                TransportPropertyPanel.this.error = false;
                if (hasNonUniform) {
                    if (!TransportPropertyPanel.this.transPropPane.isEmptyTable()) {
                        int n = TransportPropertyPanel.this.firstDegLiqBar.getValue();
                        RichardsEqn.alph = (double)n / 10000.0;
                        TransportPropertyPanel.this.firstDegLiqField.setText(String.valueOf(RichardsEqn.alph));
                        TransportPropertyPanel.this.updateFirstLiq();
                    } else {
                        int n = TransportPropertyPanel.this.firstDegLiqBar.getValue();
                        RichardsEqn.alph = (double)n / 10000.0;
                        TransportPropertyPanel.this.firstDegLiqField.setText(String.valueOf(RichardsEqn.alph));
                        RichardsEqn.restart = true;
                    }
                } else {
                    int n = TransportPropertyPanel.this.firstDegLiqBar.getValue();
                    RichardsEqn.alph = (double)n / 10000.0;
                    TransportPropertyPanel.this.firstDegLiqField.setText(String.valueOf(RichardsEqn.alph));
                    RichardsEqn.restart = true;
                }
            } else if (this.name.equals("firstSoil")) {
                TransportPropertyPanel.this.error = false;
                if (hasNonUniform) {
                    if (!TransportPropertyPanel.this.transPropPane.isEmptyTable()) {
                        int n = TransportPropertyPanel.this.firstDegSoilBar.getValue();
                        RichardsEqn.beta = (double)n / 10000.0;
                        TransportPropertyPanel.this.firstDegSoilField.setText(String.valueOf(RichardsEqn.beta));
                        TransportPropertyPanel.this.updateFirstSoil();
                    } else {
                        int n = TransportPropertyPanel.this.firstDegSoilBar.getValue();
                        RichardsEqn.beta = (double)n / 10000.0;
                        TransportPropertyPanel.this.firstDegSoilField.setText(String.valueOf(RichardsEqn.beta));
                        RichardsEqn.restart = true;
                    }
                } else {
                    int n = TransportPropertyPanel.this.firstDegSoilBar.getValue();
                    RichardsEqn.beta = (double)n / 10000.0;
                    TransportPropertyPanel.this.firstDegSoilField.setText(String.valueOf(RichardsEqn.beta));
                    RichardsEqn.restart = true;
                }
            } else if (this.name.equals("zeroDeg")) {
                TransportPropertyPanel.this.error = false;
                if (hasNonUniform) {
                    if (!TransportPropertyPanel.this.transPropPane.isEmptyTable()) {
                        int n = TransportPropertyPanel.this.zeroProdBar.getValue();
                        RichardsEqn.gamma = (double)(n - 1000) / 10.0;
                        TransportPropertyPanel.this.zeroDegField.setText(String.valueOf(RichardsEqn.gamma));
                        TransportPropertyPanel.this.updateZeroDeg();
                    } else {
                        int n = TransportPropertyPanel.this.zeroProdBar.getValue();
                        RichardsEqn.gamma = (double)(n - 1000) / 10.0;
                        TransportPropertyPanel.this.zeroDegField.setText(String.valueOf(RichardsEqn.gamma));
                        RichardsEqn.restart = true;
                    }
                } else {
                    int n = TransportPropertyPanel.this.zeroProdBar.getValue();
                    RichardsEqn.gamma = (double)(n - 1000) / 10.0;
                    TransportPropertyPanel.this.zeroDegField.setText(String.valueOf(RichardsEqn.gamma));
                    RichardsEqn.restart = true;
                }
            }
            if (!TransportPropertyPanel.this.error) {
                TransportPropertyPanel.this.performed();
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            int n = 0;
            if (this.name.equals("waterPart")) {
                RichardsEqn.waterPartCoeIndex = TransportPropertyPanel.this.waterPartCoeBox.getSelectedIndex();
                TransportPropertyPanel.this.hiddenComponents();
                if (RichardsEqn.waterPartCoeIndex == 2) {
                    TransPropTableTestModel.editableInx[1] = true;
                    RichardsEqn.usingKoc = false;
                } else {
                    int n2 = 0;
                    switch (RichardsEqn.waterPartCoeIndex) {
                        case 0: {
                            n2 = (int)(RichardsEqn.kd * 10.0);
                            TransportPropertyPanel.this.waterPartCoeBar.setValues(n2, 0, 0, 10000);
                            TransportPropertyPanel.this.waterPartCoeField.setText(String.valueOf(RichardsEqn.kd));
                            RichardsEqn.usingKoc = false;
                            break;
                        }
                        case 1: {
                            n2 = (int)(RichardsEqn.Koc * 10.0);
                            TransportPropertyPanel.this.waterPartCoeBar.setValues(n2, 0, 0, 1000000);
                            TransportPropertyPanel.this.waterPartCoeField.setText(String.valueOf(RichardsEqn.Koc));
                            RichardsEqn.usingKoc = true;
                            TransportPropertyPanel.this.setupDefaultData();
                        }
                    }
                    TransPropTableTestModel.editableInx[1] = false;
                }
                RichardsEqn.restart = true;
            } else if (this.name.equals("firstLiq")) {
                n = RichardsEqn.firstDegLiqIndex;
                RichardsEqn.firstDegLiqIndex = TransportPropertyPanel.this.firstDegLiqBox.getSelectedIndex();
                TransportPropertyPanel.this.hiddenComponents();
                if (n != RichardsEqn.firstDegLiqIndex) {
                    TransportPropertyPanel.this.liquidChange = true;
                }
                TransPropTableTestModel.editableInx[2] = RichardsEqn.firstDegLiqIndex != 0;
                if (RichardsEqn.waterPartCoeIndex == 1) {
                    TransportPropertyPanel.this.setupDefaultData();
                }
                RichardsEqn.restart = true;
            } else if (this.name.equals("firstSoil")) {
                n = RichardsEqn.firstDegSoilIndex;
                RichardsEqn.firstDegSoilIndex = TransportPropertyPanel.this.firstDegSoilBox.getSelectedIndex();
                TransportPropertyPanel.this.hiddenComponents();
                if (n != RichardsEqn.firstDegSoilIndex) {
                    TransportPropertyPanel.this.soilChange = true;
                }
                TransPropTableTestModel.editableInx[3] = RichardsEqn.firstDegSoilIndex != 0;
                if (RichardsEqn.waterPartCoeIndex == 1) {
                    TransportPropertyPanel.this.setupDefaultData();
                }
                RichardsEqn.restart = true;
            } else if (this.name.equals("zeroDeg")) {
                n = RichardsEqn.zeroDegIndex;
                RichardsEqn.zeroDegIndex = TransportPropertyPanel.this.zeroDegBox.getSelectedIndex();
                TransportPropertyPanel.this.hiddenComponents();
                if (n != RichardsEqn.zeroDegIndex) {
                    TransportPropertyPanel.this.zeroChange = true;
                }
                TransPropTableTestModel.editableInx[4] = RichardsEqn.zeroDegIndex != 0;
                if (RichardsEqn.waterPartCoeIndex == 1) {
                    TransportPropertyPanel.this.setupDefaultData();
                }
                RichardsEqn.restart = true;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.name.equals("Clear")) {
                TransportPropertyPanel.this.transPropPane.clearTable();
                return;
            }
            if (this.name.equals("Sort")) {
                if (!TransportPropertyPanel.this.tableErrorFree()) {
                    return;
                }
                TransportPropertyPanel.this.sortingTable();
                return;
            }
            if (this.name.equals("waterPart")) {
                if (!hasNonUniform) {
                    TransportPropertyPanel.this.performed();
                    if (TransportPropertyPanel.this.errorFree) return;
                    JOptionPane.showMessageDialog(CHEMFLO.appWin, RichardsEqn.errorMessage, "Error", 0);
                    CHEMFLO.appWin.repaint();
                    return;
                }
                if (TransportPropertyPanel.this.transPropPane.isEmptyTable()) {
                    TransportPropertyPanel.this.performed();
                    if (TransportPropertyPanel.this.errorFree) return;
                    JOptionPane.showMessageDialog(CHEMFLO.appWin, RichardsEqn.errorMessage, "Error", 0);
                    CHEMFLO.appWin.repaint();
                    return;
                }
                TransportPropertyPanel.this.error = false;
                if (!TransportPropertyPanel.this.tableErrorFree()) return;
                TransportPropertyPanel.this.performed();
                if (TransportPropertyPanel.this.errorFree) {
                    TransportPropertyPanel.this.updateWaterPart();
                    return;
                }
                JOptionPane.showMessageDialog(CHEMFLO.appWin, RichardsEqn.errorMessage, "Error", 0);
                CHEMFLO.appWin.repaint();
                return;
            }
            if (this.name.equals("firstLiq")) {
                if (!hasNonUniform) {
                    TransportPropertyPanel.this.performed();
                    if (TransportPropertyPanel.this.errorFree) return;
                    JOptionPane.showMessageDialog(CHEMFLO.appWin, RichardsEqn.errorMessage, "Error", 0);
                    CHEMFLO.appWin.repaint();
                    return;
                }
                if (TransportPropertyPanel.this.transPropPane.isEmptyTable()) {
                    TransportPropertyPanel.this.performed();
                    if (TransportPropertyPanel.this.errorFree) return;
                    JOptionPane.showMessageDialog(CHEMFLO.appWin, RichardsEqn.errorMessage, "Error", 0);
                    CHEMFLO.appWin.repaint();
                    return;
                }
                TransportPropertyPanel.this.error = false;
                if (!TransportPropertyPanel.this.tableErrorFree()) return;
                TransportPropertyPanel.this.performed();
                if (TransportPropertyPanel.this.errorFree) {
                    TransportPropertyPanel.this.updateFirstLiq();
                    return;
                }
                JOptionPane.showMessageDialog(CHEMFLO.appWin, RichardsEqn.errorMessage, "Error", 0);
                CHEMFLO.appWin.repaint();
                return;
            }
            if (this.name.equals("firstSoil")) {
                if (!hasNonUniform) {
                    TransportPropertyPanel.this.performed();
                    if (TransportPropertyPanel.this.errorFree) return;
                    JOptionPane.showMessageDialog(CHEMFLO.appWin, RichardsEqn.errorMessage, "Error", 0);
                    CHEMFLO.appWin.repaint();
                    return;
                }
                if (TransportPropertyPanel.this.transPropPane.isEmptyTable()) {
                    TransportPropertyPanel.this.performed();
                    if (TransportPropertyPanel.this.errorFree) return;
                    JOptionPane.showMessageDialog(CHEMFLO.appWin, RichardsEqn.errorMessage, "Error", 0);
                    CHEMFLO.appWin.repaint();
                    return;
                }
                TransportPropertyPanel.this.error = false;
                if (!TransportPropertyPanel.this.tableErrorFree()) return;
                TransportPropertyPanel.this.performed();
                if (TransportPropertyPanel.this.errorFree) {
                    TransportPropertyPanel.this.updateFirstSoil();
                    return;
                }
                JOptionPane.showMessageDialog(CHEMFLO.appWin, RichardsEqn.errorMessage, "Error", 0);
                CHEMFLO.appWin.repaint();
                return;
            }
            if (this.name.equals("zeroDeg")) {
                if (!hasNonUniform) {
                    TransportPropertyPanel.this.performed();
                    if (TransportPropertyPanel.this.errorFree) return;
                    JOptionPane.showMessageDialog(CHEMFLO.appWin, RichardsEqn.errorMessage, "Error", 0);
                    CHEMFLO.appWin.repaint();
                    return;
                }
                if (TransportPropertyPanel.this.transPropPane.isEmptyTable()) {
                    TransportPropertyPanel.this.performed();
                    if (TransportPropertyPanel.this.errorFree) return;
                    JOptionPane.showMessageDialog(CHEMFLO.appWin, RichardsEqn.errorMessage, "Error", 0);
                    CHEMFLO.appWin.repaint();
                    return;
                }
                TransportPropertyPanel.this.error = false;
                if (!TransportPropertyPanel.this.tableErrorFree()) return;
                TransportPropertyPanel.this.performed();
                if (TransportPropertyPanel.this.errorFree) {
                    TransportPropertyPanel.this.updateZeroDeg();
                    return;
                }
                JOptionPane.showMessageDialog(CHEMFLO.appWin, RichardsEqn.errorMessage, "Error", 0);
                CHEMFLO.appWin.repaint();
                return;
            }
            if (this.name.equals("diffCoe")) {
                TransportPropertyPanel.this.performed();
                return;
            }
            if (!this.name.equals("Disper")) return;
            TransportPropertyPanel.this.performed();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            block3: {
                JTextField jTextField;
                if (!(mouseEvent.getSource() instanceof JTextField) || (jTextField = (JTextField)mouseEvent.getSource()).getText() == null || jTextField.getText().trim().length() == 0) break block3;
                try {
                    Double.parseDouble(jTextField.getText());
                    TransportPropertyPanel.this.performed();
                    if (!TransportPropertyPanel.this.errorFree) {
                        JOptionPane.showMessageDialog(CHEMFLO.appWin, RichardsEqn.errorMessage, "Error", 0);
                        CHEMFLO.appWin.repaint();
                        TransportPropertyPanel.this.errorTF.grabFocus();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    jTextField.grabFocus();
                }
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (this.name.trim().equals("TransPanel")) {
                if (hasNonUniform) {
                    TransportPropertyPanel.this.transPropPane.checkTableData();
                }
                TransportPropertyPanel.this.performed();
            }
        }
    }

    class UpTransPropPanel
    extends JPanel {
        UpTransPropPanel() {
            this.setPreferredSize(new Dimension(590, 170));
            this.setLayout(null);
            int n = 0;
            TransportPropertyPanel.this.diffCoeBox.add((Component)new JPanel(this){
                private final /* synthetic */ UpTransPropPanel this$1;
                {
                    this.this$1 = upTransPropPanel;
                }

                public void paintComponent(Graphics graphics) {
                    TransportPropertyPanel.access$102(UpTransPropPanel.access$000(this.this$1), this.getFontMetrics(this.getFont()));
                    graphics.setColor(Color.black);
                    graphics.setFont(RichardsEqn.labelFont);
                    Tools.drawSpecialString("Diffusion Coefficient of Chemical in Water(" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + "2/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ")", 5, 17, TransportPropertyPanel.access$100(UpTransPropPanel.access$000(this.this$1)), graphics);
                }
            }, "Center");
            TransportPropertyPanel.this.diffCoeBox.setBounds(10, 10, 365, 22);
            TransportPropertyPanel.this.diffCoeField = new JTextField(String.valueOf(RichardsEqn.diff));
            TransportPropertyPanel.this.diffCoeField.setBounds(379, 10, 55, 22);
            n = (int)(RichardsEqn.diff * 1000.0);
            TransportPropertyPanel.this.diffCoeBar = new JScrollBar(0, n, 0, 0, 10000);
            TransportPropertyPanel.this.diffCoeBar.setBounds(438, 10, 62, 22);
            this.add(TransportPropertyPanel.this.diffCoeBox);
            this.add(TransportPropertyPanel.this.diffCoeField);
            this.add(TransportPropertyPanel.this.diffCoeBar);
            TransportPropertyPanel.this.disperBox.add((Component)new JPanel(this){
                private final /* synthetic */ UpTransPropPanel this$1;
                {
                    this.this$1 = upTransPropPanel;
                }

                public void paintComponent(Graphics graphics) {
                    TransportPropertyPanel.access$102(UpTransPropPanel.access$000(this.this$1), this.getFontMetrics(this.getFont()));
                    graphics.setColor(Color.black);
                    graphics.setFont(RichardsEqn.labelFont);
                    Tools.drawSpecialString("Dispersivity (" + RichardsEqn.lengthUnits[RichardsEqn.selectedLengthUnit] + ")", 5, 17, TransportPropertyPanel.access$100(UpTransPropPanel.access$000(this.this$1)), graphics);
                }
            }, "Center");
            TransportPropertyPanel.this.disperBox.setBounds(10, 35, 365, 22);
            TransportPropertyPanel.this.disperField = new JTextField(RichardsEqn.formatLength(RichardsEqn.disp));
            TransportPropertyPanel.this.disperField.setBounds(379, 35, 55, 22);
            n = (int)(RichardsEqn.disp * 10.0);
            TransportPropertyPanel.this.disperBar = new JScrollBar(0, n, 0, 0, 10000);
            TransportPropertyPanel.this.disperBar.setBounds(438, 35, 62, 22);
            this.add(TransportPropertyPanel.this.disperBox);
            this.add(TransportPropertyPanel.this.disperField);
            this.add(TransportPropertyPanel.this.disperBar);
            TransportPropertyPanel.this.waterPartCoeNames = new Vector(5, 5);
            if (RichardsEqn.semiInfiniteSelected || RichardsEqn.selectedInitialCond2 == 0) {
                TransportPropertyPanel.this.waterPartCoeNames.addElement("Uniform Partition Coefficient (m3/Mg soil)");
            } else {
                TransportPropertyPanel.this.waterPartCoeNames.addElement("Uniform Partition Coefficient (m3/Mg soil)");
                TransportPropertyPanel.this.waterPartCoeNames.addElement("Estimate Partition Coef. Using Koc (m3/Mg OC)");
                TransportPropertyPanel.this.waterPartCoeNames.addElement("Non-Uniform Partition Coefficient (m3/Mg soil)");
            }
            TransportPropertyPanel.this.waterPartCoeBox = new JComboBox(TransportPropertyPanel.this.waterPartCoeNames);
            TransportPropertyPanel.this.waterPartCoeBox.setForeground(Color.black);
            TransportPropertyPanel.this.waterPartCoeBox.setFont(RichardsEqn.comboBoxFont);
            TransportPropertyPanel.this.waterPartCoeBox.setSelectedIndex(RichardsEqn.waterPartCoeIndex);
            TransportPropertyPanel.this.waterPartCoeBox.setBounds(10, 60, 365, 22);
            TransportPropertyPanel.this.waterPartCoeField = new JTextField(String.valueOf(RichardsEqn.kd));
            TransportPropertyPanel.this.waterPartCoeField.setBounds(379, 60, 55, 22);
            n = (int)RichardsEqn.kd * 10;
            TransportPropertyPanel.this.waterPartCoeBar = new JScrollBar(0, n, 0, 0, 10000);
            TransportPropertyPanel.this.waterPartCoeBar.setBounds(438, 60, 62, 22);
            this.add(TransportPropertyPanel.this.waterPartCoeBox);
            this.add(TransportPropertyPanel.this.waterPartCoeField);
            this.add(TransportPropertyPanel.this.waterPartCoeBar);
            TransportPropertyPanel.this.firstDegLiqNames = new Vector(5, 5);
            if (RichardsEqn.semiInfiniteSelected || RichardsEqn.selectedInitialCond2 == 0) {
                TransportPropertyPanel.this.firstDegLiqNames.addElement("Uniform 1st-Order Degradation Const. in Liquid (1/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ")");
            } else {
                TransportPropertyPanel.this.firstDegLiqNames.addElement("Uniform 1st-Order Degradation Const. in Liquid (1/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ")");
                TransportPropertyPanel.this.firstDegLiqNames.addElement("Non-Uniform 1st-Order Degradation Const. in Liquid (1/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ")");
            }
            TransportPropertyPanel.this.firstDegLiqBox = new JComboBox(TransportPropertyPanel.this.firstDegLiqNames);
            TransportPropertyPanel.this.firstDegLiqBox.setForeground(Color.black);
            TransportPropertyPanel.this.firstDegLiqBox.setFont(RichardsEqn.comboBoxFont);
            TransportPropertyPanel.this.firstDegLiqBox.setSelectedIndex(RichardsEqn.firstDegLiqIndex);
            TransportPropertyPanel.this.firstDegLiqBox.setBounds(10, 85, 365, 22);
            TransportPropertyPanel.this.firstDegLiqField = new JTextField(String.valueOf(RichardsEqn.alph));
            TransportPropertyPanel.this.firstDegLiqField.setBounds(379, 85, 55, 22);
            n = (int)RichardsEqn.alph * 10000;
            TransportPropertyPanel.this.firstDegLiqBar = new JScrollBar(0, n, 0, 0, 10000);
            TransportPropertyPanel.this.firstDegLiqBar.setBounds(438, 85, 62, 22);
            this.add(TransportPropertyPanel.this.firstDegLiqBox);
            this.add(TransportPropertyPanel.this.firstDegLiqField);
            this.add(TransportPropertyPanel.this.firstDegLiqBar);
            TransportPropertyPanel.this.firstDegSoilNames = new Vector(5, 5);
            if (RichardsEqn.semiInfiniteSelected || RichardsEqn.selectedInitialCond2 == 0) {
                TransportPropertyPanel.this.firstDegSoilNames.addElement("Uniform 1st-Order Degradation Const. on Solids (1/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ")");
            } else {
                TransportPropertyPanel.this.firstDegSoilNames.addElement("Uniform 1st-Order Degradation Const. on Solids (1/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ")");
                TransportPropertyPanel.this.firstDegSoilNames.addElement("Non-Uniform 1st-Order Degradation Const. on Solids (1/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ")");
            }
            TransportPropertyPanel.this.firstDegSoilBox = new JComboBox(TransportPropertyPanel.this.firstDegSoilNames);
            TransportPropertyPanel.this.firstDegSoilBox.setForeground(Color.black);
            TransportPropertyPanel.this.firstDegSoilBox.setFont(RichardsEqn.comboBoxFont);
            TransportPropertyPanel.this.firstDegSoilBox.setSelectedIndex(RichardsEqn.firstDegSoilIndex);
            TransportPropertyPanel.this.firstDegSoilBox.setBounds(10, 110, 365, 22);
            TransportPropertyPanel.this.firstDegSoilField = new JTextField(String.valueOf(RichardsEqn.beta));
            TransportPropertyPanel.this.firstDegSoilField.setBounds(379, 110, 55, 22);
            n = (int)RichardsEqn.beta * 10000;
            TransportPropertyPanel.this.firstDegSoilBar = new JScrollBar(0, n, 0, 0, 10000);
            TransportPropertyPanel.this.firstDegSoilBar.setBounds(438, 110, 62, 22);
            this.add(TransportPropertyPanel.this.firstDegSoilBox);
            this.add(TransportPropertyPanel.this.firstDegSoilField);
            this.add(TransportPropertyPanel.this.firstDegSoilBar);
            TransportPropertyPanel.this.zeroDegNames = new Vector(5, 5);
            if (RichardsEqn.semiInfiniteSelected || RichardsEqn.selectedInitialCond2 == 0) {
                TransportPropertyPanel.this.zeroDegNames.addElement("Uniform Zero-Order Production Constant (g/m3/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ")");
            } else {
                TransportPropertyPanel.this.zeroDegNames.addElement("Uniform Zero-Order Production Constant (g/m3/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ")");
                TransportPropertyPanel.this.zeroDegNames.addElement("Non-Uniform Zero-Order Production Constant (g/m3/" + RichardsEqn.timeUnits[RichardsEqn.selectedTimeUnit] + ")");
            }
            TransportPropertyPanel.this.zeroDegBox = new JComboBox(TransportPropertyPanel.this.zeroDegNames);
            TransportPropertyPanel.this.zeroDegBox.setForeground(Color.black);
            TransportPropertyPanel.this.zeroDegBox.setFont(RichardsEqn.comboBoxFont);
            TransportPropertyPanel.this.zeroDegBox.setSelectedIndex(RichardsEqn.zeroDegIndex);
            TransportPropertyPanel.this.zeroDegBox.setBounds(10, 135, 365, 22);
            TransportPropertyPanel.this.zeroDegField = new JTextField(String.valueOf(RichardsEqn.gamma));
            TransportPropertyPanel.this.zeroDegField.setBounds(378, 135, 56, 22);
            n = (int)(RichardsEqn.gamma * 10.0 + 1000.5);
            TransportPropertyPanel.this.zeroProdBar = new JScrollBar(0, n, 0, 0, 2000);
            TransportPropertyPanel.this.zeroProdBar.setBounds(438, 135, 62, 22);
            this.add(TransportPropertyPanel.this.zeroDegBox);
            this.add(TransportPropertyPanel.this.zeroDegField);
            this.add(TransportPropertyPanel.this.zeroProdBar);
            TransportPropertyPanel.this.waterPartCoeBox.addItemListener(new forEvent("waterPart"));
            TransportPropertyPanel.this.firstDegLiqBox.addItemListener(new forEvent("firstLiq"));
            TransportPropertyPanel.this.firstDegSoilBox.addItemListener(new forEvent("firstSoil"));
            TransportPropertyPanel.this.zeroDegBox.addItemListener(new forEvent("zeroDeg"));
            TransportPropertyPanel.this.waterPartCoeBar.addAdjustmentListener(new forEvent("waterPart"));
            TransportPropertyPanel.this.firstDegLiqBar.addAdjustmentListener(new forEvent("firstLiq"));
            TransportPropertyPanel.this.firstDegSoilBar.addAdjustmentListener(new forEvent("firstSoil"));
            TransportPropertyPanel.this.zeroProdBar.addAdjustmentListener(new forEvent("zeroDeg"));
            TransportPropertyPanel.this.disperBar.addAdjustmentListener(new forEvent("Disper"));
            TransportPropertyPanel.this.diffCoeBar.addAdjustmentListener(new forEvent("diffCoe"));
            TransportPropertyPanel.this.waterPartCoeField.addMouseListener(new forEvent("waterPart"));
            TransportPropertyPanel.this.firstDegLiqField.addMouseListener(new forEvent("firstLiq"));
            TransportPropertyPanel.this.firstDegSoilField.addMouseListener(new forEvent("firstSoil"));
            TransportPropertyPanel.this.zeroDegField.addMouseListener(new forEvent("zeroDeg"));
            TransportPropertyPanel.this.disperField.addMouseListener(new forEvent("Disper"));
            TransportPropertyPanel.this.diffCoeField.addMouseListener(new forEvent("diffCoe"));
            TransportPropertyPanel.this.waterPartCoeField.addActionListener(new forEvent("waterPart"));
            TransportPropertyPanel.this.firstDegLiqField.addActionListener(new forEvent("firstLiq"));
            TransportPropertyPanel.this.firstDegSoilField.addActionListener(new forEvent("firstSoil"));
            TransportPropertyPanel.this.zeroDegField.addActionListener(new forEvent("zeroDeg"));
            TransportPropertyPanel.this.disperField.addActionListener(new forEvent("Disper"));
            TransportPropertyPanel.this.diffCoeField.addActionListener(new forEvent("diffCoe"));
        }

        static /* synthetic */ TransportPropertyPanel access$000(UpTransPropPanel upTransPropPanel) {
            return upTransPropPanel.TransportPropertyPanel.this;
        }
    }
}

