/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Image;

public class VanGenuchtenConductivity
extends Conductivity {
    double satK;
    double a;
    double n;
    double m;
    private static final Parameter alpha = new Parameter("Empirical Constant, \u03b1, (1/cm)", 0.015, 0.002, 0.15, 3);
    private static final Parameter nConstant = new Parameter("Empirical Constant, n", 1.875, 1.25, 3.0, 3);
    private static final Parameter kSat = new Parameter("Sat. Conductivity, Ks, (cm/hr)", 2.0, 0.0, 50.0, 2);
    private Image equationImage;

    public VanGenuchtenConductivity(double d, double d2, double d3, Image image) {
        this.satK = d;
        this.a = d2;
        this.n = d3;
        this.m = 1.0 - 1.0 / d3;
        this.equationImage = image;
    }

    public double getK(double d) {
        double d2;
        if (d < 0.0) {
            double d3 = -this.a * d;
            double d4 = Math.pow(d3, this.n);
            double d5 = Math.pow(1.0 + d4, this.m);
            double d6 = Math.pow(1.0 - d4 / d3 / d5, 2.0);
            d2 = this.satK * d6 / Math.sqrt(d5);
        } else {
            d2 = this.satK;
        }
        return d2;
    }

    public double getSatK() {
        return this.satK;
    }

    public String getName(int n) {
        String string;
        switch (n) {
            case 1: {
                string = alpha.getName();
                break;
            }
            case 2: {
                string = nConstant.getName();
                break;
            }
            case 3: {
                string = kSat.getName();
                break;
            }
            default: {
                string = "Illegal Index";
            }
        }
        return string;
    }

    public double getParamValue(int n) {
        double d;
        switch (n) {
            case 1: {
                d = this.a;
                break;
            }
            case 2: {
                d = this.n;
                break;
            }
            case 3: {
                d = this.satK;
                break;
            }
            default: {
                d = -999.0;
            }
        }
        return d;
    }

    public double getDefault(int n) {
        double d;
        switch (n) {
            case 1: {
                d = alpha.getDefaultValue();
                break;
            }
            case 2: {
                d = nConstant.getDefaultValue();
                break;
            }
            case 3: {
                d = kSat.getDefaultValue();
                break;
            }
            default: {
                d = -999.0;
            }
        }
        return d;
    }

    public double getLowerLimit(int n) {
        double d;
        switch (n) {
            case 1: {
                d = alpha.getLowerLimit();
                break;
            }
            case 2: {
                d = nConstant.getLowerLimit();
                break;
            }
            case 3: {
                d = kSat.getLowerLimit();
                break;
            }
            default: {
                d = -999999.0;
            }
        }
        return d;
    }

    public double getUpperLimit(int n) {
        double d;
        switch (n) {
            case 1: {
                d = alpha.getUpperLimit();
                break;
            }
            case 2: {
                d = nConstant.getUpperLimit();
                break;
            }
            case 3: {
                d = kSat.getUpperLimit();
                break;
            }
            default: {
                d = 999999.0;
            }
        }
        return d;
    }

    public Image getEquationImage() {
        return this.equationImage;
    }

    public int getDecimalDigits(int n) {
        int n2;
        switch (n) {
            case 1: {
                n2 = alpha.getDecimalDigits();
                break;
            }
            case 2: {
                n2 = nConstant.getDecimalDigits();
                break;
            }
            case 3: {
                n2 = kSat.getDecimalDigits();
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return n2;
    }

    public String getErrorMessage(int n) {
        String string;
        switch (n) {
            case 1: {
                string = new String("Empirical Constant, \u03b1,");
                break;
            }
            case 2: {
                string = new String("Empirical constant, n");
                break;
            }
            case 3: {
                string = new String("Sat. Conductivity");
                break;
            }
            default: {
                string = new String("Program Error: This should never be shown.");
            }
        }
        string = n == 3 ? new String(string + " is usually between " + Tools.formatDouble(this.getLowerLimit(n), this.getDecimalDigits(n), 0) + " and " + Tools.formatDouble(this.getUpperLimit(n), this.getDecimalDigits(n), 0)) : new String(string + " is usually between " + Tools.formatDouble(this.getLowerLimit(n), this.getDecimalDigits(n), 0) + " and " + Tools.formatDouble(this.getUpperLimit(n), this.getDecimalDigits(n), 0));
        return string;
    }

    public void setParamValue(int n, double d) {
        switch (n) {
            case 1: {
                this.a = d;
                break;
            }
            case 2: {
                this.n = d;
                this.m = 1.0 - 1.0 / this.n;
                break;
            }
            case 3: {
                this.satK = d;
            }
        }
    }
}

