C     Last change:  JG   12 Feb 2000    6:21 am
c
c
      subroutine basis_2d
c
c
c program to calculate basis functions and first and second derivatives
c      in local coordinates and creates the products for the
c      time term(b3), velocity terms(bx3,by3), dispersion terms
c      (bxx3,byy3,bxy3)
c       also have linear lagrange basis represented
c       also have quadratic lagrange basis represented
c
        include 'include.f'
c
        dimension gp(2)
c
c local gauss points
                       gp(1) = -(1.d0/dsqrt(3.d0))
                       gp(2) =  (1.d0/dsqrt(3.d0))
                     jj=1
c calc. the basis functions in local space
c functions 1,2 are defined on neg side
c functions 3,4 are defined on pos side
c 
           do 10 j=1,2
             x1=gp(j)
             x2=gp(j)*gp(j)
             x3=gp(j)*gp(j)*gp(j)
c
             bbx1=(x3-3.d0*x1+2.d0)/4.d0
             bbx2=(x3-x2-x1+1.d0)/4.d0
             bbx3=(2.d0+3.d0*x1-x3)/4.d0
             bbx4=(x3+x2-x1-1.d0)/4.d0
             dbx1=(3.d0*x2-3.d0)/4.d0
             dbx2=(3.d0*x2-2.d0*x1-1.d0)/4.d0
             dbx3=(3.d0-3.d0*x2)/4.d0
             dbx4=(3.d0*x2+2.d0*x1-1.d0)/4.d0
             d2bx1= 3.d0*x1/2.d0
             d2bx2=(3.d0*x1-1.d0)/2.d0
             d2bx3=-3.d0*x1/2.d0
             d2bx4=(3.d0*x1+1.d0)/2.d0
c
             sx1 = (1.d0-x1)/2.d0
             sx2 = (1.d0+x1)/2.d0
             dsx1 = -0.5d0
             dsx2 = 0.5d0
c
	do 20 k=1,2
             y1=gp(k)
             y2=gp(k)*gp(k)
	     y3=gp(k)*gp(k)*gp(k)
c
	     bby1=(y3-3.d0*y1+2.d0)/4.d0
	     bby2=(y3-y2-y1+1.d0)/4.d0
	     bby3=(2.d0+3.d0*y1-y3)/4.d0
	     bby4=(y3+y2-y1-1.d0)/4.d0
	     dby1=(3.d0*y2-3.d0)/4.d0
	     dby2=(3.d0*y2-2.d0*y1-1.d0)/4.d0
	     dby3=(3.d0-3.d0*y2)/4.d0
	     dby4=(3.d0*y2+2.d0*y1-1.d0)/4.d0
	     d2by1= 3.d0*y1/2.d0
	     d2by2=(3.d0*y1-1.d0)/2.d0
	     d2by3=-3.d0*y1/2.d0
	     d2by4=(3.d0*y1+1.d0)/2.d0
c
             sy1=(1.d0-y1)/2.d0
             sy2=(1.d0+y1)/2.d0
             dsy1=-0.5d0
             dsy2=0.5d0
c
c hermites
c construct BASIS matricies - one for the time term (b3)
c           one for velocity in x (bx3)
c           one for velocity in y (by3)
c           one for dispersion in yy (byy3)
c           one for dispersion in xx (bxx3)
c           one for dispersion in xy (bxy3)
c row(jj) = collocation point location
c column = node location
c page= degree of freedom (U, Ux, Uy, Uxy)
c
c node 1
	b3(jj,1,1) = bbx1*bby1
	b3(jj,1,2) = bbx2*bby1
	b3(jj,1,3) = bbx1*bby2
	b3(jj,1,4) = bbx2*bby2
c node 2
	b3(jj,2,1) = bbx1*bby3
	b3(jj,2,2) = bbx2*bby3
	b3(jj,2,3) = bbx1*bby4
	b3(jj,2,4) = bbx2*bby4
c node 3
	b3(jj,3,1) = bbx3*bby1
	b3(jj,3,2) = bbx4*bby1
	b3(jj,3,3) = bbx3*bby2
	b3(jj,3,4) = bbx4*bby2
c node 4
	b3(jj,4,1) = bbx3*bby3
	b3(jj,4,2) = bbx4*bby3
	b3(jj,4,3) = bbx3*bby4
	b3(jj,4,4) = bbx4*bby4
c
c node 1
	bx3(jj,1,1) = dbx1*bby1
	bx3(jj,1,2) = dbx2*bby1
	bx3(jj,1,3) = dbx1*bby2
	bx3(jj,1,4) = dbx2*bby2
c node 2
	bx3(jj,2,1) = dbx1*bby3
	bx3(jj,2,2) = dbx2*bby3
	bx3(jj,2,3) = dbx1*bby4
	bx3(jj,2,4) = dbx2*bby4
c node 3
	bx3(jj,3,1) = dbx3*bby1
	bx3(jj,3,2) = dbx4*bby1
	bx3(jj,3,3) = dbx3*bby2
	bx3(jj,3,4) = dbx4*bby2
c node 4
	bx3(jj,4,1) = dbx3*bby3
	bx3(jj,4,2) = dbx4*bby3
	bx3(jj,4,3) = dbx3*bby4
	bx3(jj,4,4) = dbx4*bby4
c
c node 1
	by3(jj,1,1) = bbx1*dby1
	by3(jj,1,2) = bbx2*dby1
	by3(jj,1,3) = bbx1*dby2
	by3(jj,1,4) = bbx2*dby2
c node 2
	by3(jj,2,1) = bbx1*dby3
	by3(jj,2,2) = bbx2*dby3
	by3(jj,2,3) = bbx1*dby4
	by3(jj,2,4) = bbx2*dby4
c node 3
	by3(jj,3,1) = bbx3*dby1
	by3(jj,3,2) = bbx4*dby1
	by3(jj,3,3) = bbx3*dby2
	by3(jj,3,4) = bbx4*dby2
c node 4
	by3(jj,4,1) = bbx3*dby3
	by3(jj,4,2) = bbx4*dby3
	by3(jj,4,3) = bbx3*dby4
	by3(jj,4,4) = bbx4*dby4
c
c node 1
	bxx3(jj,1,1)  = d2bx1*bby1
	bxx3(jj,1,2)  = d2bx2*bby1
	bxx3(jj,1,3)  = d2bx1*bby2
	bxx3(jj,1,4)  = d2bx2*bby2
c node 2
	bxx3(jj,2,1)  = d2bx1*bby3
	bxx3(jj,2,2)  = d2bx2*bby3
	bxx3(jj,2,3)  = d2bx1*bby4
	bxx3(jj,2,4)  = d2bx2*bby4
c node 3
	bxx3(jj,3,1) = d2bx3*bby1
	bxx3(jj,3,2) = d2bx4*bby1
	bxx3(jj,3,3) = d2bx3*bby2
	bxx3(jj,3,4) = d2bx4*bby2
c node 4
	bxx3(jj,4,1) = d2bx3*bby3
	bxx3(jj,4,2) = d2bx4*bby3
	bxx3(jj,4,3) = d2bx3*bby4
	bxx3(jj,4,4) = d2bx4*bby4
c
c node 1
	byy3(jj,1,1)  = bbx1*d2by1
	byy3(jj,1,2)  = bbx2*d2by1
	byy3(jj,1,3)  = bbx1*d2by2
	byy3(jj,1,4)  = bbx2*d2by2
c node 2
	byy3(jj,2,1)  = bbx1*d2by3
	byy3(jj,2,2)  = bbx2*d2by3
	byy3(jj,2,3)  = bbx1*d2by4
	byy3(jj,2,4)  = bbx2*d2by4
c node 3
	byy3(jj,3,1) = bbx3*d2by1
	byy3(jj,3,2) = bbx4*d2by1
	byy3(jj,3,3) = bbx3*d2by2
	byy3(jj,3,4) = bbx4*d2by2
c node 4
	byy3(jj,4,1) = bbx3*d2by3
	byy3(jj,4,2) = bbx4*d2by3
	byy3(jj,4,3) = bbx3*d2by4
	byy3(jj,4,4) = bbx4*d2by4
c
c node 1
	bxy3(jj,1,1)  = dbx1*dby1
	bxy3(jj,1,2)  = dbx2*dby1
	bxy3(jj,1,3)  = dbx1*dby2
	bxy3(jj,1,4)  = dbx2*dby2
c node 2
	bxy3(jj,2,1)  = dbx1*dby3
	bxy3(jj,2,2)  = dbx2*dby3
	bxy3(jj,2,3)  = dbx1*dby4
	bxy3(jj,2,4)  = dbx2*dby4
c node 3
	bxy3(jj,3,1) = dbx3*dby1
	bxy3(jj,3,2) = dbx4*dby1
	bxy3(jj,3,3) = dbx3*dby2
	bxy3(jj,3,4) = dbx4*dby2
c node 4
	bxy3(jj,4,1) = dbx3*dby3
	bxy3(jj,4,2) = dbx4*dby3
	bxy3(jj,4,3) = dbx3*dby4
	bxy3(jj,4,4) = dbx4*dby4
c
c linear lagrange (over 4 nodes)
        b1(jj,1) = sx1*sy1
        b1(jj,2) = sx1*sy2
        b1(jj,3) = sx2*sy1
        b1(jj,4) = sx2*sy2
c
        bx1(jj,1) = dsx1*sy1
        bx1(jj,2) = dsx1*sy2
        bx1(jj,3) = dsx2*sy1
        bx1(jj,4) = dsx2*sy2
c
        by1(jj,1) = sx1*dsy1
        by1(jj,2) = sx1*dsy2
        by1(jj,3) = sx2*dsy1
        by1(jj,4) = sx2*dsy2
c
	jj = jj + 1
c
   20   continue
   10   continue
                                                return
	                                        end
c
c
      subroutine basis_1d
c
        include 'include.f'
c
	dimension gp(4)
c
c calc 1-D hermites (a 4by4 matrix)
c for the line integration use 
c 4 local gauss points
              gp(1) = -(1.d0/dsqrt(3.d0))
              gp(2) =  (1.d0/dsqrt(3.d0))
              gp(3) =  .0d0
              gp(4) =  .0d0
c
c             gp(1) = -.861136311594053d0
c             gp(2) = -.339981043584856d0
c             gp(3) =  .339981043584856d0
c             gp(4) =  .861136311594053d0
c
c integration weights
c               wt(1) = .347854845137454d0
c               wt(2) = .652145154862546d0
c               wt(3) = .652145154862546d0
c               wt(4) = .347854845137454d0
                wt(1) = 1.d0
                wt(2) = 1.d0
                wt(3) = 0.d0
                wt(4) = 0.d0
c               wt(1) = 1.d0/3.d0
c               wt(2) = 1.d0 + 1.d0/3.d0
c               wt(3) = 1.d0/3.d0
c
	     x1 = gp(1)
	     x2 = gp(1)*gp(1)
	     x3 = gp(1)*gp(1)*gp(1)
c
c          fi0 -
	     b(1,1) = (x3-3.d0*x1+2.d0)/4.d0
c          fi1 -
	     b(1,2) = (x3-x2-x1+1.d0)/4.d0
c          fi0 +
	     b(1,3) = (2.d0+3.d0*x1-x3)/4.d0
c          fi1 +
	     b(1,4) = (x3+x2-x1-1.d0)/4.d0
c
	     x1 = gp(2)
	     x2 = gp(2)*gp(2)
	     x3 = gp(2)*gp(2)*gp(2)
c
c          fi0 -
	     b(2,1) = (x3-3.d0*x1+2.d0)/4.d0
c          fi1 -
	     b(2,2) = (x3-x2-x1+1.d0)/4.d0
c          fi0 +
	     b(2,3) = (2.d0+3.d0*x1-x3)/4.d0
c          fi1 +
	     b(2,4) = (x3+x2-x1-1.d0)/4.d0
c
	     x1 = gp(3)
	     x2 = gp(3)*gp(3)
	     x3 = gp(3)*gp(3)*gp(3)
c
c          fi0 -
	     b(3,1) = (x3-3.d0*x1+2.d0)/4.d0
c          fi1 -
	     b(3,2) = (x3-x2-x1+1.d0)/4.d0
c          fi0 +
	     b(3,3) = (2.d0+3.d0*x1-x3)/4.d0
c          fi1 +
	     b(3,4) = (x3+x2-x1-1.d0)/4.d0
c
	     x1 = gp(4)
	     x2 = gp(4)*gp(4)
	     x3 = gp(4)*gp(4)*gp(4)
c
c          fi0 -
	     b(4,1) = (x3-3.d0*x1+2.d0)/4.d0
c          fi1 -
	     b(4,2) = (x3-x2-x1+1.d0)/4.d0
c          fi0 +
	     b(4,3) = (2.d0+3.d0*x1-x3)/4.d0
c          fi1 +
	     b(4,4) = (x3+x2-x1-1.d0)/4.d0
c
c calc 1-D linear lagrange
             b11(1,1) = (1.d0-gp(1))/2.d0
             b11(1,2) = (1.d0+gp(1))/2.d0
             b11(2,1) = (1.d0-gp(2))/2.d0
             b11(2,2) = (1.d0+gp(2))/2.d0
             b11(3,1) = (1.d0-gp(3))/2.d0
             b11(3,2) = (1.d0+gp(3))/2.d0
             b11(4,1) = (1.d0-gp(4))/2.d0
             b11(4,2) = (1.d0+gp(4))/2.d0
	                                        return
	                                        end
