C     Last change:  JG   25 Sep 2002    5:08 pm
c
c@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
           subroutine bcset
c@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
c
c Define the bc-type for each boundary node
c - default -- neumann everywhere - CASE !
c set up flow  and transport vectors for no flow
c
c Save this data in 2 vectors
c
c the vector ending with _x is for boundaries in the x-direction
c the vector ending with _y is for boundaries in the y-direction
c
c THE BC IS IMPOSED NORMAL TO THAT SIDE
c
c bc vectors are a matrix with 2 columns representing the node    
c and the two planes for each axis pair
c  with the plane on the (-) side in col 1
c
        include 'include.f'
c
c initialize the source vectors
c
        do 2 i = 1, nn
                       qiow(i) = 0.d0
                       qiog(i) = 0.d0
                       qw(i)   = 0.d0
                       qn(i)   = 0.d0
                       qg(i)   = 0.d0
    2   continue
c-------------------------------------------------------
c y-faces
c
          k = 0
      do 68 j = 1, 2
        do 69 jj = 1, nny
c
              ib_y(jj,j)  = 1       
c          concentration
             iboa_y(jj,j)  = 2       
c          concentration
             ibog_y(jj,j)  = 2       
c
c              index for y-numbering
               ii = k+jj
c
                  call water_prop (roa11(ii,1),wa,dww,visw)
                  call   gas_prop (rog11(ii,1),gg,dgg,visg)
c
           pa11(ii,2) = dww*grav*dcos(thgx)
c*
             d_pc = -1.d+07
c                call pc_nw    (sw11(ii,1), pc, d_pc, ii)
             call lev_sw_p (d_pc,dpcnw(ii) )
c                call pc_gn    (st11(ii,1), pc, d_pc, ii)
             call lev_st_p (d_pc, dpcgn(ii) )
           sw11(ii,2) = (rn_r-dww)*grav*dcos(thgx) /dpcnw(ii)
           st11(ii,2) = (dgg-rn_r)*grav*dcos(thgx) /dpcgn(ii)
c*
c          st11(ii,2) = (dgg-dww)*grav*dcos(thgx) /(dpcnw(ii)+dpcgn(ii))
c          sw11(ii,2) = st11(ii,2)
c
   69   continue
          k = nn - nny
   68 continue
c
c x-faces
c
          k = 0
      do 168 j = 1, 2
        do 169 jj = 1, nnx
c
c          flow conditions
              ib_x(jj,j)  = 1       
c          concentration
             iboa_x(jj,j)  = 2       
c          concentration
             ibog_x(jj,j)  = 2       
c
c              index for x-numbering
               ii = k + (jj-1)*nny + 1
c
                  call water_prop (roa11(ii,1),wa,dww,visw)
                  call   gas_prop (rog11(ii,1),gg,dgg,visg)
c
           pa11(ii,3) = dww*grav*dcos(thgy)
c*
             d_pc = -1.d+07
c                call pc_nw    (sw11(ii,1), pc, d_pc, ii)
             call lev_sw_p (d_pc,dpcnw(ii) )
c                call pc_gn    (st11(ii,1), pc, d_pc, ii)
             call lev_st_p (d_pc, dpcgn(ii) )
           sw11(ii,3) = (rn_r-dww)*grav*dcos(thgy) /dpcnw(ii)
           st11(ii,3) = (dgg-rn_r)*grav*dcos(thgy) /dpcgn(ii)
c*
c          st11(ii,3) = (dgg-dww)*grav*dcos(thgy) /(dpcnw(ii)+dpcgn(ii))
c          sw11(ii,3) = st11(ii,3)
  169   continue
          k = ney
  168 continue
c
c
                                return
                                 end
c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
c
c     SPECIFICATION OF DIRICHLET BC'S
c     for the flow equations
c
c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
          subroutine bc_flow (ncond)
c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
c
c NOTE: all other in/out of mass from the system is described by 
c       point source/sink terms
c
        include 'include.f'
c
        do 26 i=1,ncond
c
c nface = domain face on which the bc is to be perscribed
c          =1 - x-side
c          =2 - y-side
c
c ii = global node number for non-zero flux condition (numbering y-x-z)
c
c ncode for Dirichlet bc's :    (variable(s) specified)
c        =1 - default no flow condition
c        =2 - open to gas flow (Pg), closed to water and NAPL flow
c        =3 - open to NAPL flow (Pn), closed to water and gas flow
c        =4 - open to water flow (Pw), closed to gas and NAPL flow
c
c        =5 - open to water, gas and NAPL flow (Pw, Sn, Sg)
c
c press = specified pressure
c
c       ****
        read(9,*)nface,ii,ncode
c       ****
               if(ncode.eq.2.and.iphase.eq.12) then
       write(6,*) 'INPUT ERROR '
       write(6,*) 'APPLYING A GAS HEAD FOR A WATER-NAPL PROBLEM'
                stop
               else if(ncode.eq.3.and.iphase.eq.13) then
       write(6,*) 'INPUT ERROR '
       write(6,*) 'APPLYING A NAPL HEAD FOR A WATER-GAS PROBLEM'
                stop
               endif
c given the node figure out the row and column 
c
                 nco = ii/nny
                  if(nny*(ii/nny).lt.ii) nco = nco + 1
                 nro = nny - ( nny*nco - ii )
c
c?????????????????
c set the ib_ vector for this condition
c?????????????????
      if (nface.eq.1)  then
c
c       check to see if this node is on an x face
         if(nro.ne.1.and.nro.ne.nny)then
c           this node is not on either x-face
       write(6,*) 'INPUT ERROR '
            write(6,*) 'CHECK Pw BC S ON THE X-FACES'
                             stop
         else
c
c          this an x-face boundary node : consider column
                  if(nro.eq.1)  then
                           iplane = 1
                  else
                           iplane = 2
                  endif
                           ib_x(nco,iplane)  = ncode
         endif
c
      else if (nface.eq.2)  then
c
c      check to see if this node is on an y face
         if(nco.ne.1.and.nco.ne.nnx)then
c           this node is not on either y-face
       write(6,*) 'INPUT ERROR '
            write(6,*) 'CHECK Pw BC S ON THE Y-FACES'
                             stop
         else
c
c          this an y-face boundary node : consider row 
                  if(nco.eq.1)  then
                           iplane = 1
                  else
                           iplane = 2
                  endif
                     ib_y(nro,iplane)  = ncode
         endif
c
      else
c            there is a problem with face specification
       write(6,*) 'INPUT ERROR '
            write(6,*) 'CHECK Pw BC FACE SPECIFICATION'
                             stop
      endif
c
c?????????????????
c SET THE Proper variables 
c?????????????????
c (2)
        if( ncode .eq. 2 )  then 
c (2)
c Pg is known   
c Dirichlet condition on Pw = Pg - Pcnw - Pcgn
c Neumann conditions on Sw and St
c set Qg = Vt * area after solving for Pw.
c
c specify the head of the gas phase at the node
c
          read(9,*) head
c
         call   gas_prop (rog11(ii,1),gg,dgg,visg)
c
        IF(i_static.eq.0) then
         pa11(ii,1)   = grav*dgg*head + pg_ref
     &                - pcnw1(ii) - pcgn1(ii)
        else
         pa11(ii,1)   = pg_ref + grav*dgg* ( head
     &                         + dcos(thgx)*x(nco)
     &                         + dcos(thgy)*y(nro) )
     &                - pcnw1(ii) - pcgn1(ii)
        endif
c
       if (nface.eq.1)  then
c
            if(dabs(st11(ii,2)).lt.1.d-10)  then
                pcgn =  0.d0
             else
                pcgn =  dpcgn (ii) * st11(ii,2)
             endif
             if(dabs(sw11(ii,2)).lt.1.d-10)  then
                pcnw =  0.d0
             else
                pcnw =  dpcnw (ii) * sw11(ii,2)
             endif
          pa11(ii,2)   = grav*dgg*dcos(thgx) - (pcnw + pcgn)
       else
c
            if(dabs(st11(ii,3)).lt.1.d-10)  then
                pcgn =  0.d0
             else
                pcgn =  dpcgn (ii) * st11(ii,3)
             endif
             if(dabs(sw11(ii,3)).lt.1.d-10)  then
                pcnw =  0.d0
             else
                pcnw =  dpcnw (ii) * sw11(ii,3)
             endif
          pa11(ii,3)   = grav*dgg*dcos(thgy) - (pcnw + pcgn)
       endif
c
c (3)
        else if( ncode      .eq.  3 )  then 
c (3)
c Pn is known   
c Dirichlet condition on Pw = Pn - Pcnw
c Neumann conditions on Sw and St
c set Qg = Vt * area after solving for Pw.
c
c specify the head of the NAPL phase at the node
c
          read(9,*) head
c
        IF(i_static.eq.0) then
         pa11(ii,1)   = grav*rn_r*head + pg_ref - pcnw1(ii)
        else
         pa11(ii,1)   = pg_ref + grav*rn_r * ( head
     &                         + dcos(thgx)*x(nco)
     &                         + dcos(thgy)*y(nro) )
     &                - pcnw1(ii)
        endif
c
       if (nface.eq.1)  then
            if(dabs(st11(ii,2)).lt.1.d-10)  then
                pcgn =  0.d0
             else
                pcgn =  dpcgn (ii) * st11(ii,2)
             endif
             if(dabs(sw11(ii,2)).lt.1.d-10)  then
                pcnw =  0.d0
             else
                pcnw =  dpcnw (ii) * sw11(ii,2)
             endif
          pa11(ii,2)   = grav*rn_r*dcos(thgx) - pcnw
       else
c
            if(dabs(st11(ii,3)).lt.1.d-10)  then
                pcgn =  0.d0
             else
                pcgn =  dpcgn (ii) * st11(ii,3)
             endif
             if(dabs(sw11(ii,3)).lt.1.d-10)  then
                pcnw =  0.d0
             else
                pcnw =  dpcnw (ii) * sw11(ii,3)
             endif
         pa11(ii,3)   = grav*rn_r*dcos(thgy) - pcnw
       endif
c
c (4)
        else if( ncode      .eq.  4 )  then 
c (4)
c Pw is known   
c set Dirichlet condition on Pw and 
c Neumann conditions on Sw and St
c
c specify the head of the water phase at the node
c 
c        read in Pw (in terms of head of water)
          read(9,*) head
c
         call water_prop (roa11(ii,1),wa,dww,visw)
c
        IF(i_static.eq.0) then
         pa11(ii,1)   = pg_ref + grav*dww*head
        else
         pa11(ii,1)   = pg_ref + grav*dww* ( head
     &                         + dcos(thgx)*x(nco)
     &                         + dcos(thgy)*y(nro) )
        endif
c
       if (nface.eq.1)  then
         pa11(ii,2)   = grav*dww*dcos(thgx)
       else
         pa11(ii,3)   = grav*dww*dcos(thgy) 
       endif
c
c (5)
        else if( ncode      .eq. 5 )  then 
c (5)
c        Pw(1), Sw(1), St(1)
c
c        read in Pw, Sw, Sg
          read(9,*) n_opt,head, sw, sg 
c n_opt = 1 then use the restart values as Dirichlet data
c n_opt = 0 then use the bc_flow.in file values as Dirichlet data
c
            if (n_opt.ne.1)  then
              if ( 1.d0-sw-sg .gt. 0.0001d0 ) then
c               NAPL is present, so set Dirichlet conc. at eq. 
                roa11(ii,1) = parow
                rog11(ii,1) = parog
                roat(ii,1) = parow
                rogt(ii,1) = parog
                 if (nface.eq.1)  then
                     iboa_x(nco,iplane)  = 1
                     ibog_x(nco,iplane)  = 1
                 else
                     iboa_y(nro,iplane)  = 1
                     ibog_y(nro,iplane)  = 1
                 endif
              endif
                  call water_prop (roa11(ii,1),wa,dww,visw)
c
        IF(i_static.eq.0) then
              pa11(ii,1)  = grav*dww   *head  + pg_ref
        else
              pa11(ii,1)   = pg_ref + grav*dww* ( head
     &                        + dcos(thgx)*x(nco)
     &                        + dcos(thgy)*y(nro) )
        endif
c
               sw11(ii,1)  =  sw
               st11(ii,1)  =  1.d0 - sg
c
                 if (nhyst.eq.1)   then
                      swt(ii,1)  =  sw
                      stt(ii,1)  =  1.d0 - sg
c                  hysteresis on
                        call hyst_ic (ii, sw11(ii,1), st11(ii,1))
                 endif
                call pc_nw    (sw11(ii,1), pc, d_pc, ii)
                call lev_sw_p (pc, pcnw1(ii) )
                call pc_gn       (st11(ii,1), pc, d_pc, ii)
                call lev_st_p    (pc, pcgn1(ii) )
            else if(nflag.ne.1) then
              write(6,*) 'INPUT ERROR'
         write(6,*)'BC FLOW CASE 5, n_opt = 1 when no IC data to read'
                    stop
            endif
c
        else 
              write(6,*) 'INPUT ERROR'
              write(6,*) 'NOT A VALID CODE NUMBER at boundary node:'
              write(6,*) ii
              stop
        endif
   26  continue
                                    return
                                    end
c
c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
c Trenaport EQUATION - Roa
c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
          subroutine bc_oa (ncond)
c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
c
c routine to set up Dirichlet bc's for the Trenaport equation
c
c NOTE: all other in/out of mass from the system is described by 
c       point source/sink terms
c
        include 'include.f'
c
        if (ntr_ow.eq.1)  then
        do 26 i=1,ncond
c
c nface = domain face on which the bc is to be perscribed
c          =1 - x-side
c          =2 - y-side
c
c nod = global node number for non-zero flux condition (numbering y-x-z)
c
c value = known concentration
c       ****
        read(10,*)nface,nod,value 
c       ****
        if ( value .lt. -epsil) then
              write(6,*) 'INPUT ERROR'
              write(6,*) 'Negative value for Roa BC at boundary node:'
              write(6,*) nod
              stop
        endif
               roa11(nod,1) =  value
               roat(nod,1) =  value
c
c given the node figure out the row and column 
c
                 nco = nod/nny
                  if(nny*(nod/nny).lt.nod) nco = nco + 1
                 nro = nny - ( nny*nco - nod )
c
c
c set the iboa_ vector for this condition
c
      if (nface.eq.1)  then
c
c       check to see if this node is on an x face
         if(nro.ne.1.and.nro.ne.nny)then
c           this node is not on either x-face
              write(6,*) 'INPUT ERROR'
            write(6,*) 'CHECK Conc BC S ON THE X-FACES'
                             stop
         else
c
c          this an x-face boundary node : consider column
                  if(nro.eq.1)  then
                           iplane = 1
                  else
                           iplane = 2
                  endif
                           iboa_x(nco,iplane)  = 1
         endif
c
      else if (nface.eq.2)  then
c
c      check to see if this node is on an y face
         if(nco.ne.1.and.nco.ne.nnx)then
c           this node is not on either y-face
              write(6,*) 'INPUT ERROR'
            write(6,*) 'CHECK Conc BC S ON THE Y-FACES'
                             stop
         else
c
c          this an y-face boundary node : consider row 
                  if(nco.eq.1)  then
                           iplane = 1
                  else
                           iplane = 2
                  endif
                     iboa_y(nro,iplane)  = 1
         endif
c
      else
c            there is a problem with face specification
              write(6,*) 'INPUT ERROR'
            write(6,*) 'CHECK Conc BC FACE SPECIFICATION'
                             stop
      endif
c
   26  continue
c
       else 
              write(28,*) 'INPUT WARNING'
       write(28,*) 'NAPL-water transport is OFF - NO BCs SET'
       endif
                                    return
                                    end
c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
c Trenaport EQUATION - Rog
c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
          subroutine bc_og (ncond)
c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
c
c routine to set up Dirichlet bc's for the Trenaport equation
c
c NOTE: all other in/out of mass from the system is described by 
c       point source/sink terms
c
        include 'include.f'
c
        if (ntr_og.eq.1) then
        do 26 i=1,ncond
c
c nface = domain face on which the bc is to be perscribed
c          =1 - x-side
c          =2 - y-side
c
c nod = global node number for non-zero flux condition (numbering y-x-z)
c
c ntype = Dirichlet (1) or Mixed (3)
c
c value = known concentration
c       ****
        read(11,*) nface,nod,value 
c       ****
         if(value .gt . -epsil) then
c           DIRICHLET data
               rog11(nod,1) =  value
               rogt(nod,1) =  value
             ntype = 1
         else
c            MIXED data
             ntype = 3
         endif 
c
c given the node figure out the row and column 
c
                 nco = nod/nny
                  if(nny*(nod/nny).lt.nod) nco = nco + 1
                 nro = nny - ( nny*nco - nod )
c
c
c set the ibog_ vector for this condition
c
      if (nface.eq.1)  then
c
c       check to see if this node is on an x face
         if(nro.ne.1.and.nro.ne.nny)then
c           this node is not on either x-face
              write(6,*) 'INPUT ERROR'
            write(6,*) 'CHECK Conc BC S ON THE X-FACES'
                             stop
         else
c
c          this an x-face boundary node : consider column
                  if(nro.eq.1)  then
                      iplane = 1
                  else
                      iplane = 2
                  endif
                      ibog_x(nco,iplane)  = ntype
         endif
c
      else if (nface.eq.2)  then
c
c      check to see if this node is on an y face
         if(nco.ne.1.and.nco.ne.nnx)then
c           this node is not on either y-face
              write(6,*) 'INPUT ERROR'
            write(6,*) 'CHECK Conc BC S ON THE Y-FACES'
                             stop
         else
c
c          this an y-face boundary node : consider row 
                  if(nco.eq.1)  then
                      iplane = 1
                  else
                      iplane = 2
                  endif
                      ibog_y(nro,iplane)  = ntype
         endif
c
      else
c            there is a problem with face specification
              write(6,*) 'INPUT ERROR'
            write(6,*) 'CHECK Conc BC FACE SPECIFICATION'
                             stop
      endif
c
   26  continue
c
       else 
              write(28,*) 'INPUT WARNING'
       write(28,*) 'NAPL-gas transport is OFF - NO BCs SET'
       endif
                                    return
                                    end
c
c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
           subroutine bc_up
c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
c
c GET READY FOR THE NEXT TIME STEP 
c     update all bc'c which are a function of the solution 
c              pressure, concentration and saturation
c
        include 'include.f'
c
c y-faces
        k = 0 
c
      do 68 j = 1, 2
       do 69 jj = 1, nny
c
c              index for y-numbering
               ii = k+jj
c fluid properties
                  call water_prop (roa11(ii,1),wa,dww,visw)
                  call   gas_prop (rog11(ii,1),gg,dgg,visg)
c(1)
        if( ib_y(jj,j) .eq.  1 )    then
c(1)
            pa11(ii,2)    = dww*grav*dcos(thgx)
c
        if (dabs(dcos(thgx)).gt.epsil)  then
             d_pc = -1.d+07
c                call pc_nw    (sw11(ii,1), pc, d_pc, ii)
             call lev_sw_p (d_pc,dpcnw(ii) )
c                call pc_gn    (st11(ii,1), pc, d_pc, ii)
             call lev_st_p (d_pc, dpcgn(ii) )
           sw11(ii,2) = (rn_r-dww)*grav*dcos(thgx) /dpcnw(ii)
           st11(ii,2) = (dgg-rn_r)*grav*dcos(thgx) /dpcgn(ii)
        endif
c
c(2)
        else if( ib_y(jj,j) .eq.  2 )    then
c(2)
c
            if(dabs(st11(ii,3)).lt.1.d-10)  then
                pcgn =  0.d0
             else
                pcgn =  dpcgn (ii) * st11(ii,3)
             endif
             if(dabs(sw11(ii,3)).lt.1.d-10)  then
                pcnw =  0.d0
             else
                pcnw =  dpcnw (ii) * sw11(ii,3)
             endif
c
            pa11(ii,3) = dgg*grav*dcos(thgy)-(pcnw + pcgn)
            pa11(ii,1) = pat(ii,1) - (pcnw1(ii)+pcgn1(ii))
c
        if (dabs(dcos(thgx)).gt.epsil)  then
             d_pc = -1.d+07
c                call pc_nw    (sw11(ii,1), pc, d_pc, ii)
             call lev_sw_p (d_pc,dpcnw(ii) )
c                call pc_gn    (st11(ii,1), pc, d_pc, ii)
             call lev_st_p (d_pc, dpcgn(ii) )
            sw11(ii,2) = (rn_r - dww)*grav*dcos(thgx)/dpcnw(ii)
            st11(ii,2) = (dgg - rn_r)*grav*dcos(thgx) /dpcgn(ii)
        endif
c
             qw(ii)   = 0.d0
             qn(ii)   = 0.d0
             qg(ii)   = 0.d0
             qiog(ii) = 0.d0
             qiow(ii) = 0.d0
c
c(3)
        else if( ib_y(jj,j) .eq.  3 )    then
c(3)
c
            if(dabs(st11(ii,3)).lt.1.d-10)  then
                pcgn =  0.d0
             else
                pcgn =  dpcgn (ii) * st11(ii,3)
             endif
             if(dabs(sw11(ii,3)).lt.1.d-10)  then
                pcnw =  0.d0
             else
                pcnw =  dpcnw (ii) * sw11(ii,3)
             endif
c
            pa11(ii,1) = pat(ii,1) - pcnw1(ii)
            pa11(ii,3) = rn_r*grav*dcos(thgy) - pcnw
c
        if (dabs(dcos(thgx)).gt.epsil)  then
             d_pc = -1.d+07
c                call pc_nw    (sw11(ii,1), pc, d_pc, ii)
             call lev_sw_p (d_pc,dpcnw(ii) )
c                call pc_gn    (st11(ii,1), pc, d_pc, ii)
             call lev_st_p (d_pc, dpcgn(ii) )
            sw11(ii,2) = (rn_r - dww)*grav*dcos(thgx)/dpcnw(ii)
            st11(ii,2) = (dgg - rn_r)*grav*dcos(thgx) /dpcgn(ii)
        endif
c
             qw(ii)   = 0.d0
             qn(ii)   = 0.d0
             qg(ii)   = 0.d0
             qiog(ii) = 0.d0
             qiow(ii) = 0.d0
c
c(4)
        else if( ib_y(jj,j) .eq.  4)  then
c(4)
c
        if (dabs(dcos(thgx)).gt.epsil)  then
             d_pc = -1.d+07
c                call pc_nw    (sw11(ii,1), pc, d_pc, ii)
             call lev_sw_p (d_pc,dpcnw(ii) )
c                call pc_gn    (st11(ii,1), pc, d_pc, ii)
             call lev_st_p (d_pc, dpcgn(ii) )
          sw11(ii,2) = (rn_r - dww)*grav*dcos(thgx) /dpcnw(ii)
          st11(ii,2) = (dgg - rn_r)*grav*dcos(thgx) /dpcgn(ii)
        endif
c
             qw(ii)   = 0.d0
             qn(ii)   = 0.d0
             qg(ii)   = 0.d0
             qiog(ii) = 0.d0
             qiow(ii) = 0.d0
c
        endif
c
   69   continue
          k = nn - nny
   68 continue
c  
c x-faces
        k = 0 
c
      do 168 j = 1, 2
       do 169 jj = 1, nnx
c
c              index for x-numbering
               ii = k + (jj-1)*nny + 1
c fluid properties
                  call water_prop (roa11(ii,1),wa,dww,visw)
                  call   gas_prop (rog11(ii,1),gg,dgg,visg)
c
c(1)
        if( ib_x(jj,j) .eq.  1 )    then
c(1)
            pa11(ii,3)    = dww*grav*dcos(thgy)
c
      if (dabs(dcos(thgy)).gt.epsil)  then
             d_pc = -1.d+07
c                call pc_nw    (sw11(ii,1), pc, d_pc, ii)
             call lev_sw_p (d_pc,dpcnw(ii) )
c                call pc_gn    (st11(ii,1), pc, d_pc, ii)
             call lev_st_p (d_pc, dpcgn(ii) )
           sw11(ii,3) = (rn_r-dww)*grav*dcos(thgy) /dpcnw(ii)
           st11(ii,3) = (dgg-rn_r)*grav*dcos(thgy) /dpcgn(ii)
      endif
c
c(2)
        else if( ib_x(jj,j) .eq.  2 )    then
c(2)
c
            if(dabs(st11(ii,2)).lt.1.d-10)  then
                pcgn =  0.d0
             else
                pcgn =  dpcgn (ii) * st11(ii,2)
             endif
             if(dabs(sw11(ii,2)).lt.1.d-10)  then
                pcnw =  0.d0
             else
                pcnw =  dpcnw (ii) * sw11(ii,2)
             endif
            pa11(ii,2)   = dgg*grav*dcos(thgx)-(pcnw + pcgn)
            pa11(ii,1) = pat(ii,1) - (pcnw1(ii)+pcgn1(ii))
c
      if (dabs(dcos(thgy)).gt.epsil)  then
             d_pc = -1.d+07
c                call pc_nw    (sw11(ii,1), pc, d_pc, ii)
             call lev_sw_p (d_pc,dpcnw(ii) )
c                call pc_gn    (st11(ii,1), pc, d_pc, ii)
             call lev_st_p (d_pc, dpcgn(ii) )
         sw11(ii,3) = (rn_r - dww)*grav*dcos(thgy) /dpcnw(ii)
         st11(ii,3) = (dgg - rn_r)*grav*dcos(thgy) /dpcgn(ii)
      endif
c
         qw(ii) = 0.d0
         qn(ii) = 0.d0
         qg(ii) = 0.d0
         qiog(ii) = 0.d0
         qiow(ii) = 0.d0
c
c(3)
        else if( ib_x(jj,j) .eq.  3 )    then
c(3)
c
            if(dabs(st11(ii,2)).lt.1.d-10)  then
                pcgn =  0.d0
             else
                pcgn =  dpcgn (ii) * st11(ii,2)
             endif
             if(dabs(sw11(ii,2)).lt.1.d-10)  then
                pcnw =  0.d0
             else
                pcnw =  dpcnw (ii) * sw11(ii,2)
             endif
c
            pa11(ii,1) = pat(ii,1) - pcnw1(ii) 
            pa11(ii,2)   = rn_r*grav*dcos(thgx) - pcnw 
c
      if (dabs(dcos(thgy)).gt.epsil)  then
             d_pc = -1.d+07
c                call pc_nw    (sw11(ii,1), pc, d_pc, ii)
             call lev_sw_p (d_pc,dpcnw(ii) )
c                call pc_gn    (st11(ii,1), pc, d_pc, ii)
             call lev_st_p (d_pc, dpcgn(ii) )
         sw11(ii,3) = (rn_r - dww)*grav*dcos(thgy) /dpcnw(ii)
         st11(ii,3) = (dgg - rn_r)*grav*dcos(thgy) /dpcgn(ii)
      endif
c
         qw(ii) = 0.d0
         qn(ii) = 0.d0
         qg(ii) = 0.d0
         qiog(ii) = 0.d0
         qiow(ii) = 0.d0
c
c(4)
        else if( ib_x(jj,j) .eq.  4 )  then
c(4)
c
      if (dabs(dcos(thgy)).gt.epsil)  then
             d_pc = -1.d+07
c                call pc_nw    (sw11(ii,1), pc, d_pc, ii)
             call lev_sw_p (d_pc,dpcnw(ii) )
c                call pc_gn    (st11(ii,1), pc, d_pc, ii)
             call lev_st_p (d_pc, dpcgn(ii) )
         sw11(ii,3) = (rn_r - dww)*grav*dcos(thgy) /dpcnw(ii)
         st11(ii,3) = (dgg - rn_r)*grav*dcos(thgy) /dpcgn(ii)
      endif
c
         qw(ii) = 0.d0
         qn(ii) = 0.d0
         qg(ii) = 0.d0
         qiog(ii) = 0.d0
         qiow(ii) = 0.d0
c
        endif
c
  169   continue
          k = ney
  168 continue
c
                                    return
                                    end
c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
c
           subroutine pr_bc
c
c convert Vt into appropriate Q for flow BC's 2, 3, 4
c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
c DEFINE BC'S FOR THE SATURATION EQUATIONS AFTER Pw SOLUTION
c     For Pg and Pn Dirichlet data set the following:     
c
c Pg:  qg = normal cpt. of Vt * area
c Pn:  qn = normal cpt. of Vt * area
c
        include 'include.f'
c
cwrite       if (iscr.eq.1) then
cwrite       write(6,*) 'FLUX CONVERSION for BCs 2, 3, 4 (node, qw, qn, qg)'
cwrite       endif
c y-faces
        k = 0 
c
      do 68 j = 1, 2
       do 69 jj = 1, nny
c
c              index for y-numbering
               ii = k+jj
c
c(2)
        if( ib_y(jj,j) .eq.  2 )    then
c(2)
c Pg condition
c
           if(j.eq.1)  then
                  qg(ii) = vtx(ii) / dx(1)*2.d0
                  ds = dx(1)/2.d0
           else
                  qg(ii) = -vtx(ii) / dx(nex)*2.d0
                  ds = dx(nex)/2.d0
           endif
              vtx(ii) = 0.d0
              vwx(ii) = 0.d0
              vgx(ii) = 0.d0
c
       if(qg(ii) .lt. -1.d-10)  then
c        outflow condition, 
c        adjust rate based on phase mobilities at node
           qt = qg(ii)
         call qout_adj (qt, ii)
       endif
c
       if (iscr.eq.1) then
             if(jj.eq.1) then
                   dss = dy(1)/2.d0
             else if(jj.eq.nny) then
                   dss = dy(ney)/2.d0
             else
                   dss = (dy(jj-1)+dy(jj))/2.d0
             endif
         v_w = qw(ii)*ds*dss
         v_n = qn(ii)*ds*dss
         v_g = qg(ii)*ds*dss
cwrite       write(6,111) ii, v_w, v_n, v_g
       endif
c
c(3)
        else if( ib_y(jj,j) .eq.  3 )    then
c(3)
c Pn condition
c
           if(j.eq.1)  then
                  qn(ii) = vtx(ii) / dx(1)*2.d0
                  ds = dx(1)/2.d0
           else
                  qn(ii) = -vtx(ii) / dx(nex)*2.d0
                  ds = dx(nex)/2.d0
           endif
              vtx(ii) = 0.d0
              vwx(ii) = 0.d0
              vgx(ii) = 0.d0
c
       if(qn(ii) .lt. -1.d-10)  then
c        outflow condition, 
c        adjust rate based on phase mobilities at node
           qt = qn(ii)
         call qout_adj (qt, ii)
       endif
c
       if (iscr.eq.1) then
             if(jj.eq.1) then
                   dss = dy(1)/2.d0
             else if(jj.eq.nny) then
                   dss = dy(ney)/2.d0
             else
                   dss = (dy(jj-1)+dy(jj))/2.d0
             endif
         v_w = qw(ii)*ds*dss
         v_n = qn(ii)*ds*dss
         v_g = qg(ii)*ds*dss
cwrite       write(6,111) ii, v_w, v_n, v_g
       endif
c
c(4)
        else if( ib_y(jj,j) .eq.  4 ) then 
c(4)
c Pw condition
c
           if(j.eq.1)  then
                  qw(ii) = vtx(ii) / dx(1)*2.d0
                  ds = dx(1)/2.d0
           else
                  qw(ii) = -vtx(ii) / dx(nex)*2.d0
                  ds = dx(nex)/2.d0
           endif
              vtx(ii) = 0.d0
              vwx(ii) = 0.d0
              vgx(ii) = 0.d0
c
       if(qw(ii) .lt. -1.d-10)  then
c        outflow condition, 
c        adjust rate based on phase mobilities at node
           qt = qw(ii)
         call qout_adj (qt, ii)
       endif
c
       if (iscr.eq.1) then
             if(jj.eq.1) then
                   dss = dy(1)/2.d0
             else if(jj.eq.nny) then
                   dss = dy(ney)/2.d0
             else
                   dss = (dy(jj-1)+dy(jj))/2.d0
             endif
         v_w = qw(ii)*ds*dss
         v_n = qn(ii)*ds*dss
         v_g = qg(ii)*ds*dss
cwrite       write(6,111) ii, v_w, v_n, v_g
       endif
c
        endif
c
   69   continue
          k = nn - nny
   68 continue
c  
c x-faces
        k = 0 
c
      do 168 j = 1, 2
       do 169 jj = 1, nnx
c
c              index for x-numbering
               ii = k + (jj-1)*nny + 1
c
c(2)
        if( ib_x(jj,j) .eq.  2 )    then
c(2)
c Pg condition
c
           if(j.eq.1)  then
                  qg(ii) = vty(ii) / dy(1)*2.d0
                  ds = dy(1)/2.d0
           else
                  qg(ii) = -vty(ii) / dy(ney)*2.d0
                  ds = dy(ney)/2.d0
           endif
              vty(ii) = 0.d0
              vwy(ii) = 0.d0
              vgy(ii) = 0.d0
c
       if(qg(ii) .lt. -1.d-10)  then
c        outflow condition, 
c        adjust rate based on phase mobilities at node
           qt = qg(ii)
         call qout_adj (qt, ii)
       endif
c
       if (iscr.eq.1) then
             if(jj.eq.1) then
                   dss = dx(1)/2.d0
             else if(jj.eq.nnx) then
                   dss = dx(nex)/2.d0
             else
                   dss = (dx(jj-1)+dx(jj))/2.d0
             endif
         v_w = qw(ii)*ds*dss
         v_n = qn(ii)*ds*dss
         v_g = qg(ii)*ds*dss
cwrite       write(6,111) ii, v_w, v_n, v_g
       endif
c
c(3)
        else if( ib_x(jj,j) .eq.  3 )    then
c(3)
c Pn condition
c
           if(j.eq.1)  then
                  qn(ii) = vty(ii) / dy(1)*2.d0
                  ds = dy(1)/2.d0
           else
                  qn(ii) = -vty(ii) / dy(ney)*2.d0
                  ds = dy(ney)/2.d0
           endif
              vty(ii) = 0.d0
              vwy(ii) = 0.d0
              vgy(ii) = 0.d0
c
       if(qn(ii) .lt. -1.d-10)  then
c        outflow condition, 
c        adjust rate based on phase mobilities at node
           qt = qn(ii)
         call qout_adj (qt, ii)
       endif
c
       if (iscr.eq.1) then
             if(jj.eq.1) then
                   dss = dx(1)/2.d0
             else if(jj.eq.nnx) then
                   dss = dx(nex)/2.d0
             else
                   dss = (dx(jj-1)+dx(jj))/2.d0
             endif
         v_w = qw(ii)*ds*dss
         v_n = qn(ii)*ds*dss
         v_g = qg(ii)*ds*dss
cwrite       write(6,111) ii, v_w, v_n, v_g
       endif
c
c(4)
        else if( ib_x(jj,j) .eq.  4 )  then
c(4)
c Pw condition
c
           if(j.eq.1)  then
                  qw(ii) = vty(ii) / dy(1)*2.d0
                  ds = dy(1)/2.d0
           else
                  qw(ii) = -vty(ii) / dy(ney)*2.d0
                  ds = dy(ney)/2.d0
           endif
              vty(ii) = 0.d0
              vwy(ii) = 0.d0
              vgy(ii) = 0.d0
c
       if(qw(ii) .lt. -1.d-10)  then
c        outflow condition, 
c        adjust rate based on phase mobilities at node
           qt = qw(ii)
         call qout_adj (qt, ii)
       endif
c
       if (iscr.eq.1) then
             if(jj.eq.1) then
                   dss = dx(1)/2.d0
             else if(jj.eq.nnx) then
                   dss = dx(nex)/2.d0
             else
                   dss = (dx(jj-1)+dx(jj))/2.d0
             endif
         v_w = qw(ii)*ds*dss
         v_n = qn(ii)*ds*dss
         v_g = qg(ii)*ds*dss
cwrite       write(6,111) ii, v_w, v_n, v_g
       endif
c
        endif
c
  169   continue
          k = ney
  168 continue
c
  111  format(i5,2x,1pe12.4,2x,1pe12.4,2x,1pe12.4)
cwrite       if (iscr.eq.1) then
cwrite       write(6,*)
cwrite       endif
                                    return
                                    end
c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
           subroutine pr_save
c
c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
c at the begining of the time step 
c save pressure conditions for flow bc's 2 and 3
c    ( save the Pg and Pn bc's in Pw at time level 'n')
c
        include 'include.f'
c
c y-faces
        k = 0 
c
      do 68 j = 1, 2
       do 69 jj = 1, nny
c
c              index for y-numbering
               ii = k+jj
c(2)
        if( ib_y(jj,j) .eq.  2 )    then
c(2)
            pat(ii,1) = pa11(ii,1) + pcnw1(ii) + pcgn1(ii)
c
c(3)
        else if( ib_y(jj,j) .eq.  3 )    then
c(3)
            pat(ii,1) = pa11(ii,1) + pcnw1(ii)
c
        endif
c
   69   continue
          k = nn - nny
   68 continue
c  
c x-faces
        k = 0 
c
      do 168 j = 1, 2
       do 169 jj = 1, nnx
c
c              index for x-numbering
               ii = k + (jj-1)*nny + 1
c(2)
        if( ib_x(jj,j) .eq.  2 )    then
c(2)
            pat(ii,1) = pa11(ii,1) + pcnw1(ii) + pcgn1(ii)
c
c(3)
        else if( ib_x(jj,j) .eq.  3 )    then
c(3)
            pat(ii,1) = pa11(ii,1) + pcnw1(ii)
c
        endif
c
  169   continue
          k = ney
  168 continue
c
                                    return
                                    end
c
c@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
           subroutine no_flow
c@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
c
c For no flow BC's set the dpc slope to a very high value
c to mimic a LINEAR no-flow condition
c
        include 'include.f'
c
c-------------------------------------------------------
c y-faces
      if (dabs(dcos(thgx)).gt.epsil)  then
c
          k = 0
        do 68 j = 1, 2
          do 69 jj = 1, nny
c
            if (ib_y(jj,j) .ne. 5)  then
c
c                index for y-numbering
                 ii = k+jj
c
c                call pc_nw    (sw11(ii,1), pc, d_pc, ii)
c             call lev_sw_p (d_pc,dpcnw(ii) )
c                call pc_gn    (st11(ii,1), pc, d_pc, ii)
c             call lev_st_p (d_pc, dpcgn(ii) )
                 call lev_sw_p (-1.d+07, dpcnw(ii) )
                 call lev_st_p (-1.d+07, dpcgn(ii) )
c
            endif 
c
   69     continue
            k = nn - nny
   68   continue
      endif 
c
c x-faces
      if (dabs(dcos(thgy)).gt.epsil)  then
c
          k = 0
      do 168 j = 1, 2
        do 169 jj = 1, nnx
c
            if (ib_x(jj,j) .ne. 5)  then
c
c              index for x-numbering
               ii = k + (jj-1)*nny + 1
c
c                call pc_nw    (sw11(ii,1), pc, d_pc, ii)
c             call lev_sw_p (d_pc,dpcnw(ii) )
c                call pc_gn    (st11(ii,1), pc, d_pc, ii)
c             call lev_st_p (d_pc, dpcgn(ii) )
                 call lev_sw_p (-1.d+07, dpcnw(ii) )
                 call lev_st_p (-1.d+07, dpcgn(ii) )
c
            endif 
c
  169   continue
          k = ney
  168 continue
c
      endif 
c
                                return
                                end
