C     Last change:  JG   20 Sep 2000    3:53 pm
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c       Define degree of freedom numbering for 
c       each dependent variable, for each subdomain
c       based on subdomain dimension and boundary data
c
c here the following vctors are defined:
c  ibc_p     (Pw)
c  ibc_s    (Sw and St)
c  ibc_oa    (Roa)
c  ibc_og    (Rog)
c
c dimension of ibc_ (4[#elements per subdomain])
c
c in setting the vectors ibc_ :
c a zero indicates that the df is a bc
c all non bc df's are given a number indicating the row
c in the system of equations it belongs
c
c the numbering of ibc_  is in shortest direction first (as per ixy)
c
c
c PROCEDURE 
c construct boundary nodes of ibc_p by:
c 1. initialize all bdy df's to 9
c 2. look at each face separately and mark the proper condition 
c    normal to that face with a  0
c 3. then loop through and give all 9 df's the proper number
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c
c PRESSURE SOLUTION
c
           subroutine df_num_p
c
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        include 'include.f'
c
c
c initialize ibc = 9
       do 101 j = 1, 4 
         do 100 i = 1, nn
             ibc_p(i,j) = 9
  100    continue
  101  continue
c
c 1. negative x face 
c
          do 15 i = 0, nnx-1
c
                nod = npt_s(i+1,1)
c
                if(ib_x(i+1,1).ne.1 ) then  
c                  this node is a Dirichlet node
                          ibc_p(nod,1) = 0
                          ibc_p(nod,2) = 0
                else
c                  this node is a Neumann node
                          ibc_p(nod,3) = 0
                          ibc_p(nod,4) = 0
                endif 
   15    continue
c
c 2. positive x face 
c
            j = 0
          do 25 i = nn-nnx+1, nn
c
                nod = npt_s(i,1)
                if(ib_x(j+1,2).ne.1 ) then 
c                  this node is a Dirichlet node
                          ibc_p(nod,1) = 0
                          ibc_p(nod,2) = 0
                else
c                  this node is a Neumann node
                          ibc_p(nod,3) = 0
                          ibc_p(nod,4) = 0
                endif 
              j = j + 1
   25    continue
c
c 3. negative y face 
c
          do 35 i = 0, nny-1
c
                nod = npt_s(i+1,2)
                if(ib_y(i+1,1).ne.1 ) then  
c                  this node is a Dirichlet node
                          ibc_p(nod,1) = 0
                          ibc_p(nod,3) = 0
                else
c                  this node is a Neumann node
                          ibc_p(nod,2) = 0
                          ibc_p(nod,4) = 0
                endif 
   35    continue
c
c 4. positive y face 
              j = 0
          do 45 i = nn-nny+1, nn
c
                nod = npt_s(i,2)
                if(ib_y(j+1,2).ne.1 ) then 
c                  this node is a Dirichlet node
                          ibc_p(nod,1) = 0
                          ibc_p(nod,3) = 0
                else
c                  this node is a Neumann node
                          ibc_p(nod,2) = 0
                          ibc_p(nod,4) = 0
                endif 
              j = j + 1
   45    continue
c
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c ordering of unknowns
c TENSOR PRODUCT ORDERING FOR THE PRESSURE VARIABLES
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c number the degrees of freedom for the system of equations
c numbering is dependent on the grid numbering
c
       if(ixy .eq.1)  then
c x-lines
            do 12   j = 1, nny
              nod = (j-1)*nnx + 1
c
              if(j.eq.1.or.j.eq.nny)  then
c              first or last sweep
                if(j.eq.1)  then
                 num = 1
                else
                 num = (nny-1)*(nnx-1)*4-(nnx-1)*2+1
                endif
c
                do 13 k = 1, nnx
                    do 14 idf = 1, 4
                          if(ibc_p(nod,idf).ne.0)  then
                             ibc_p(nod,idf) = num
                             num = num + 1
                          endif
   14               continue
                               nod = nod + 1
   13           continue
c
              else 
                 numm = (j-2)*(nnx-1)*4+(nnx-1)*2+1
                 nump = (j-2)*(nnx-1)*4+(nnx-1)*4+1
c              interior sweep
                do 16 k = 1, nnx
                  if(k.eq.1.or.k.eq.nnx)  then
c                  first or last node
c
                          if(ibc_p(nod,1).ne.0)  then
                             ibc_p(nod,1) = numm
                             numm = numm + 1
                          else 
                             ibc_p(nod,2) = numm
                             numm = numm + 1
                          endif
                          if(ibc_p(nod,3).ne.0)  then
                             ibc_p(nod,3) = nump
                             nump = nump + 1
                          else
                             ibc_p(nod,4) = nump
                             nump = nump + 1
                          endif
                  else
c                   interior node
                             ibc_p(nod,1) = numm
                             numm = numm + 1
                             ibc_p(nod,2) = numm
                             numm = numm + 1
                             ibc_p(nod,3) = nump
                             nump = nump + 1
                             ibc_p(nod,4) = nump
                             nump = nump + 1
                  endif
                               nod = nod + 1
   16           continue
              endif
   12       continue
       else 
c y-lines
            do 2   j = 1, nnx
              nod = (j-1)*nny + 1
c
              if(j.eq.1.or.j.eq.nnx)  then
c              first or last sweep
                if(j.eq.1)  then
                 num = 1
                else
                 num = (nnx-1)*(nny-1)*4-(nny-1)*2+1
                endif
c
                do 3 k = 1, nny
                    do 4 idf = 1, 4
                          if(ibc_p(nod,idf).ne.0)  then
                             ibc_p(nod,idf) = num
                             num = num + 1
                          endif
    4               continue
                               nod = nod + 1
    3           continue
c
              else 
                 numm = (j-2)*(nny-1)*4+(nny-1)*2+1
                 nump = (j-2)*(nny-1)*4+(nny-1)*4+1
c              interior sweep
                do 5 k = 1, nny
                  if(k.eq.1.or.k.eq.nny)  then
c                  first or last node
c
                          if(ibc_p(nod,1).ne.0)  then
                             ibc_p(nod,1) = numm
                             numm = numm + 1
                          else 
                             ibc_p(nod,3) = numm
                             numm = numm + 1
                          endif
                          if(ibc_p(nod,2).ne.0)  then
                             ibc_p(nod,2) = nump
                             nump = nump + 1
                          else
                             ibc_p(nod,4) = nump
                             nump = nump + 1
                          endif
                  else
c                   interior node
                             ibc_p(nod,1) = numm
                             numm = numm + 1
                             ibc_p(nod,3) = numm
                             numm = numm + 1
                             ibc_p(nod,2) = nump
                             nump = nump + 1
                             ibc_p(nod,4) = nump
                             nump = nump + 1
                  endif
                               nod = nod + 1
    5           continue
              endif
    2       continue
c
       endif
c
c####   ####   ####   ####   ####   ####   ####   ####   
                        return 
                        end
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c
c SATURATION SOLUTION
c
           subroutine df_num_s
c
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c
        include 'include.f'
c
c initialize ibc_s = 9
       do 101 j = 1, 4 
         do 100 i = 1, nn
             ibc_s(i,j) = 9
  100    continue
  101  continue
c
c 1. negative x face 
          do 15 i = 0, nnx-1
c
                nod = npt_s(i+1,1)
c
                if(ib_x(1+i,1).ne. 5 ) then 
c                  this node is a Neumann node
                          ibc_s(nod,3) = 0
                          ibc_s(nod,4) = 0
                else
c                  this node is a Dirichlet node
                          ibc_s(nod,1) = 0
                          ibc_s(nod,2) = 0
                endif 
   15    continue
c
c 2. positive x face 
c
            j = 0
          do 25 i = nn-nnx+1, nn
c
                nod = npt_s(i,1)
                if(ib_x(1+j,2).ne. 5 ) then 
c                  this node is a Neumann node
                          ibc_s(nod,3) = 0
                          ibc_s(nod,4) = 0
                else
c                  this node is a Dirichlet node
                          ibc_s(nod,1) = 0
                          ibc_s(nod,2) = 0
                endif 
              j = j + 1
   25    continue
c
c 3. negative y face 
c
          do 35 i = 0, nny-1
c
                nod = npt_s(i+1,2)
                if(ib_y(1+i,1).ne. 5 ) then 
c                  this node is a Neumann node
                          ibc_s(nod,2) = 0
                          ibc_s(nod,4) = 0
                else
c                  this node is a Dirichlet node
                          ibc_s(nod,1) = 0
                          ibc_s(nod,3) = 0
                endif 
   35    continue
c
c 4. positive y face 
              j = 0
          do 45 i = nn - nny + 1, nn
c
                nod = npt_s(i,2)
                if(ib_y(1+j,2).ne. 5 ) then 
c                  this node is a Neumann node
                          ibc_s(nod,2) = 0
                          ibc_s(nod,4) = 0
                else
c                  this node is a Dirichlet node
                          ibc_s(nod,1) = 0
                          ibc_s(nod,3) = 0
                endif 
              j = j + 1
   45    continue
c
c ordering of equations
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c TENSOR PRODUCT ORDERING FOR THE Saturation VARIABLES
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c number the degrees of freedom for the system of equations
c numbering is dependent on the grid numbering
c
       if(ixy .eq.1)  then
c x-lines
            do 12   j = 1, nny
              nod = (j-1)*nnx + 1
c
              if(j.eq.1.or.j.eq.nny)  then
c              first or last sweep
                if(j.eq.1)  then
                 num = 1
                else
                 num = (nny-1)*(nnx-1)*4-(nnx-1)*2+1
                endif
c
                do 13 k = 1, nnx
                    do 14 idf = 1, 4
                          if(ibc_s(nod,idf).ne.0)  then
                             ibc_s(nod,idf) = num
                             num = num + 1
                          endif
   14               continue
                               nod = nod + 1
   13           continue
c
              else 
                 numm = (j-2)*(nnx-1)*4+(nnx-1)*2+1
                 nump = (j-2)*(nnx-1)*4+(nnx-1)*4+1
c              interior sweep
                do 16 k = 1, nnx
                  if(k.eq.1.or.k.eq.nnx)  then
c                  first or last node
c
                          if(ibc_s(nod,1).ne.0)  then
                             ibc_s(nod,1) = numm
                             numm = numm + 1
                          else 
                             ibc_s(nod,2) = numm
                             numm = numm + 1
                          endif
                          if(ibc_s(nod,3).ne.0)  then
                             ibc_s(nod,3) = nump
                             nump = nump + 1
                          else
                             ibc_s(nod,4) = nump
                             nump = nump + 1
                          endif
                  else
c                   interior node
                             ibc_s(nod,1) = numm
                             numm = numm + 1
                             ibc_s(nod,2) = numm
                             numm = numm + 1
                             ibc_s(nod,3) = nump
                             nump = nump + 1
                             ibc_s(nod,4) = nump
                             nump = nump + 1
                  endif
                               nod = nod + 1
   16           continue
              endif
   12       continue
       else 
c y-lines
            do 2   j = 1, nnx
              nod = (j-1)*nny + 1
c
              if(j.eq.1.or.j.eq.nnx)  then
c              first or last sweep
                if(j.eq.1)  then
                 num = 1
                else
                 num = (nnx-1)*(nny-1)*4-(nny-1)*2+1
                endif
c
                do 3 k = 1, nny
                    do 4 idf = 1, 4
                          if(ibc_s(nod,idf).ne.0)  then
                             ibc_s(nod,idf) = num
                             num = num + 1
                          endif
    4               continue
                               nod = nod + 1
    3           continue
c
              else 
                 numm = (j-2)*(nny-1)*4+(nny-1)*2+1
                 nump = (j-2)*(nny-1)*4+(nny-1)*4+1
c              interior sweep
                do 5 k = 1, nny
                  if(k.eq.1.or.k.eq.nny)  then
c                  first or last node
c
                          if(ibc_s(nod,1).ne.0)  then
                             ibc_s(nod,1) = numm
                             numm = numm + 1
                          else 
                             ibc_s(nod,3) = numm
                             numm = numm + 1
                          endif
                          if(ibc_s(nod,2).ne.0)  then
                             ibc_s(nod,2) = nump
                             nump = nump + 1
                          else
                             ibc_s(nod,4) = nump
                             nump = nump + 1
                          endif
                  else
c                   interior node
                             ibc_s(nod,1) = numm
                             numm = numm + 1
                             ibc_s(nod,3) = numm
                             numm = numm + 1
                             ibc_s(nod,2) = nump
                             nump = nump + 1
                             ibc_s(nod,4) = nump
                             nump = nump + 1
                  endif
                               nod = nod + 1
    5           continue
              endif
    2       continue
c
       endif
c
                        return 
                        end
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c
c TRANSPORT SOLUTION
c
           subroutine df_num_oa
c
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c
        include 'include.f'
c
c initialize ibc_oa = 9
       do 101 j = 1, 4 
         do 100 i = 1, nn
             ibc_oa(i,j) = 9
  100    continue
  101  continue
c
c 1. negative x face 
          do 15 i = 0, nnx-1
c
                nod = npt_s(i+1,1)
c
                if(iboa_x(1+i,1).eq.1)  then
c                  this node is a Dirichlet node
                          ibc_oa(nod,1) = 0
                          ibc_oa(nod,2) = 0
                else
c                  this node is a Neumann node
                          ibc_oa(nod,3) = 0
                          ibc_oa(nod,4) = 0
                endif 
   15    continue
c
c 2. positive x face 
c
            j = 0
          do 25 i = nn-nnx+1, nn
c
                nod = npt_s(i,1)
                if(iboa_x(1+j,2).eq.1)  then
c                  this node is a Dirichlet node
                          ibc_oa(nod,1) = 0
                          ibc_oa(nod,2) = 0
                else
c                  this node is a Neumann node
                          ibc_oa(nod,3) = 0
                          ibc_oa(nod,4) = 0
                endif 
              j = j + 1
   25    continue
c
c 3. negative y face 
c
          do 35 i = 0, nny-1
c
                nod = npt_s(i+1,2)
                if(iboa_y(1+i,1).eq.1)  then
c                  this node is a Dirichlet node
                          ibc_oa(nod,1) = 0
                          ibc_oa(nod,3) = 0
                else
c                  this node is a Neumann node
                          ibc_oa(nod,2) = 0
                          ibc_oa(nod,4) = 0
                endif 
   35    continue
c
c 4. positive y face 
              j = 0
          do 45 i = nn-nny+1, nn
c
                nod = npt_s(i,2)
                if(iboa_y(1+j,2).eq.1)  then
c                  this node is a Dirichlet node
                          ibc_oa(nod,1) = 0
                          ibc_oa(nod,3) = 0
                else
c                  this node is a Neumann node
                          ibc_oa(nod,2) = 0
                          ibc_oa(nod,4) = 0
                endif 
              j = j + 1
   45    continue
c
c
c ordering of equations
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c TENSOR PRODUCT ORDERING FOR THE Roa VARIABLES
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c number the degrees of freedom for the system of equations
c numbering is dependent on the grid numbering
c
       if(ixy .eq.1)  then
c x-lines
            do 12   j = 1, nny
              nod = (j-1)*nnx + 1
c
              if(j.eq.1.or.j.eq.nny)  then
c              first or last sweep
                if(j.eq.1)  then
                 num = 1
                else
                 num = (nny-1)*(nnx-1)*4-(nnx-1)*2+1
                endif
c
                do 13 k = 1, nnx
                    do 14 idf = 1, 4
                          if(ibc_oa(nod,idf).ne.0)  then
                             ibc_oa(nod,idf) = num
                             num = num + 1
                          endif
   14               continue
                               nod = nod + 1
   13           continue
c
              else 
                 numm = (j-2)*(nnx-1)*4+(nnx-1)*2+1
                 nump = (j-2)*(nnx-1)*4+(nnx-1)*4+1
c              interior sweep
                do 16 k = 1, nnx
                  if(k.eq.1.or.k.eq.nnx)  then
c                  first or last node
c
                          if(ibc_oa(nod,1).ne.0)  then
                             ibc_oa(nod,1) = numm
                             numm = numm + 1
                          else 
                             ibc_oa(nod,2) = numm
                             numm = numm + 1
                          endif
                          if(ibc_oa(nod,3).ne.0)  then
                             ibc_oa(nod,3) = nump
                             nump = nump + 1
                          else
                             ibc_oa(nod,4) = nump
                             nump = nump + 1
                          endif
                  else
c                   interior node
                             ibc_oa(nod,1) = numm
                             numm = numm + 1
                             ibc_oa(nod,2) = numm
                             numm = numm + 1
                             ibc_oa(nod,3) = nump
                             nump = nump + 1
                             ibc_oa(nod,4) = nump
                             nump = nump + 1
                  endif
                               nod = nod + 1
   16           continue
              endif
   12       continue
       else 
c y-lines
            do 2   j = 1, nnx
              nod = (j-1)*nny + 1
c
              if(j.eq.1.or.j.eq.nnx)  then
c              first or last sweep
                if(j.eq.1)  then
                 num = 1
                else
                 num = (nnx-1)*(nny-1)*4-(nny-1)*2+1
                endif
c
                do 3 k = 1, nny
                    do 4 idf = 1, 4
                          if(ibc_oa(nod,idf).ne.0)  then
                             ibc_oa(nod,idf) = num
                             num = num + 1
                          endif
    4               continue
                               nod = nod + 1
    3           continue
c
              else 
                 numm = (j-2)*(nny-1)*4+(nny-1)*2+1
                 nump = (j-2)*(nny-1)*4+(nny-1)*4+1
c              interior sweep
                do 5 k = 1, nny
                  if(k.eq.1.or.k.eq.nny)  then
c                  first or last node
c
                          if(ibc_oa(nod,1).ne.0)  then
                             ibc_oa(nod,1) = numm
                             numm = numm + 1
                          else 
                             ibc_oa(nod,3) = numm
                             numm = numm + 1
                          endif
                          if(ibc_oa(nod,2).ne.0)  then
                             ibc_oa(nod,2) = nump
                             nump = nump + 1
                          else
                             ibc_oa(nod,4) = nump
                             nump = nump + 1
                          endif
                  else
c                   interior node
                             ibc_oa(nod,1) = numm
                             numm = numm + 1
                             ibc_oa(nod,3) = numm
                             numm = numm + 1
                             ibc_oa(nod,2) = nump
                             nump = nump + 1
                             ibc_oa(nod,4) = nump
                             nump = nump + 1
                  endif
                               nod = nod + 1
    5           continue
              endif
    2       continue
c
       endif
c
  200 continue
c####   ####   ####   ####   ####   ####   ####   ####   
                        return 
                        end
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c
c TRANSPORT SOLUTION
c
           subroutine df_num_og
c
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        include 'include.f'
c
c initialize ibc_og = 9
       do 101 j = 1, 4 
         do 100 i = 1, nn
             ibc_og(i,j) = 9
  100    continue
  101  continue
c
c 1. negative x face 
          do 15 i = 0, nnx-1
c
                nod = npt_s(i+1,1)
c
                if(ibog_x(1+i,1).eq.1)  then
c                  this node is a Dirichlet node
                          ibc_og(nod,1) = 0
                          ibc_og(nod,2) = 0
                else if(ibog_x(1+i,1).eq.2)  then
c                  this node is a Neumann node
                          ibc_og(nod,3) = 0
                          ibc_og(nod,4) = 0
                else
c                  this node is a Mixed node
                          ibc_og(nod,3) = -1
                          ibc_og(nod,4) = -1
                endif 
   15    continue
c
c 2. positive x face 
c
            j = 0
          do 25 i = nn-nnx+1, nn
c
                nod = npt_s(i,1)
                if(ibog_x(1+j,2).eq.1)  then
c                  this node is a Dirichlet node
                          ibc_og(nod,1) = 0
                          ibc_og(nod,2) = 0
                else if(ibog_x(1+j,2).eq.2)  then
c                  this node is a Neumann node
                          ibc_og(nod,3) = 0
                          ibc_og(nod,4) = 0
                else
c                  this node is a Mixed node
                          ibc_og(nod,3) = -1
                          ibc_og(nod,4) = -1
                endif 
              j = j + 1
   25    continue
c
c 3. negative y face 
c
          do 35 i = 0, nny-1
c
                nod = npt_s(i+1,2)
                if(ibog_y(1+i,1).eq.1)  then
c                  this node is a Dirichlet node
                          ibc_og(nod,1) = 0
                          ibc_og(nod,3) = 0
                else if(ibog_y(1+i,1).eq.2)  then
c                  this node is a Neumann node
                          ibc_og(nod,2) = 0
                          ibc_og(nod,4) = 0
                else
c                  this node is a Mixed node
                          ibc_og(nod,2) = -1
                          ibc_og(nod,4) = -1
                endif 
   35    continue
c
c 4. positive y face 
              j = 0
          do 45 i = nn-nny+1, nn
c
                nod = npt_s(i,2)
                if(ibog_y(1+j,2).eq.1)  then
c                  this node is a Dirichlet node
                          ibc_og(nod,1) = 0
                          ibc_og(nod,3) = 0
                else if(ibog_y(1+j,2).eq.2)  then
c                  this node is a Neumann node
                          ibc_og(nod,2) = 0
                          ibc_og(nod,4) = 0
                else
c                  this node is a Mixed node
                          ibc_og(nod,2) = -1
                          ibc_og(nod,4) = -1
                endif 
              j = j + 1
   45    continue
c
c ordering of equations
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c TENSOR PRODUCT ORDERING FOR THE Sw VARIABLES
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c number the degrees of freedom for the system of equations
c numbering is dependent on the grid numbering
c
       if(ixy .eq.1)  then
c x-lines
            do 12   j = 1, nny
              nod = (j-1)*nnx + 1
c
              if(j.eq.1.or.j.eq.nny)  then
c              first or last sweep
                if(j.eq.1)  then
                 num = 1
                else
                 num = (nny-1)*(nnx-1)*4-(nnx-1)*2+1
                endif
c
                do 13 k = 1, nnx
                  iinc = 0 
                 do 14 idf = 1, 4
                  if(ibc_og(nod,idf).gt.0)  then
                     ibc_og(nod,idf) = num
                     num = num + 1
                  else if(ibc_og(nod,idf).lt.0)  then
c                  match this df to its linear combination partner
                   call third (iinc,nod,idf,num)
                  endif
   14            continue
                               nod = nod + 1
   13           continue
c
              else 
                 numm = (j-2)*(nnx-1)*4+(nnx-1)*2+1
                 nump = (j-2)*(nnx-1)*4+(nnx-1)*4+1
c              interior sweep
                do 16 k = 1, nnx
                  if(k.eq.1.or.k.eq.nnx)  then
c                  first or last node
c
                    if(ibc_og(nod,1).gt.0)  then
                       ibc_og(nod,1) = numm
                                            numm = numm + 1
                       if(ibc_og(nod,2).lt.0)  then
                          ibc_og(nod,2) = -(numm-1)
                       endif
                    else 
                       ibc_og(nod,2) = numm
                       numm = numm + 1
                    endif
                    if(ibc_og(nod,3).gt.0)  then
                       ibc_og(nod,3) = nump
                                            nump = nump + 1
                       if(ibc_og(nod,4).lt.0)  then
                          ibc_og(nod,4) = -(nump-1)
                       endif
                    else
                       ibc_og(nod,4) = nump
                       nump = nump + 1
                    endif
                  else
c                   interior node
                             ibc_og(nod,1) = numm
                             numm = numm + 1
                             ibc_og(nod,2) = numm
                             numm = numm + 1
                             ibc_og(nod,3) = nump
                             nump = nump + 1
                             ibc_og(nod,4) = nump
                             nump = nump + 1
                  endif
                               nod = nod + 1
   16           continue
              endif
   12       continue
       else 
c y-lines
            do 2   j = 1, nnx
              nod = (j-1)*nny + 1
c
              if(j.eq.1.or.j.eq.nnx)  then
c              first or last sweep
                if(j.eq.1)  then
                 num = 1
                else
                 num = (nnx-1)*(nny-1)*4-(nny-1)*2+1
                endif
c
                do 3 k = 1, nny
                iinc = 0
                 do 4 idf = 1, 4
                  if(ibc_og(nod,idf).gt.0)  then
                     ibc_og(nod,idf) = num
                                            num = num + 1
                  else if(ibc_og(nod,idf).lt.0)  then
c                  match this df to its linear combination partner
                   call third (iinc,nod,idf,num)
                  endif
    4            continue
                           nod = nod + 1
    3           continue
c
              else 
                 numm = (j-2)*(nny-1)*4+(nny-1)*2+1
                 nump = (j-2)*(nny-1)*4+(nny-1)*4+1
c              interior sweep
                do 5 k = 1, nny
                  if(k.eq.1.or.k.eq.nny)  then
c                  first or last node
c
                     if(ibc_og(nod,1).gt.0)  then
                        ibc_og(nod,1) = numm
                                             numm = numm + 1
                       if(ibc_og(nod,3).lt.0)  then
                          ibc_og(nod,3) = -(numm-1)
                       endif
                     else 
                        ibc_og(nod,3) = numm
                                             numm = numm + 1
                     endif
                     if(ibc_og(nod,2).gt.0)  then
                        ibc_og(nod,2) = nump
                                             nump = nump + 1
                       if(ibc_og(nod,4).lt.0)  then
                          ibc_og(nod,4) = -(nump-1)
                       endif
                     else
                        ibc_og(nod,4) = nump
                                             nump = nump + 1
                     endif
                  else
c                   interior node
                             ibc_og(nod,1) = numm
                             numm = numm + 1
                             ibc_og(nod,3) = numm
                             numm = numm + 1
                             ibc_og(nod,2) = nump
                             nump = nump + 1
                             ibc_og(nod,4) = nump
                             nump = nump + 1
                  endif
                               nod = nod + 1
    5           continue
              endif
    2       continue
c
       endif
c
  200 continue
c
                        return 
                        end
c
c
c####   ####   ####   ####   ####   ####   ####   ####   
         subroutine third (iinc,nod,idf,num)
c####   ####   ####   ####   ####   ####   ####   ####   
c
        include 'include.f'
c
c           match this df to its linear combination partner
c           compute row and col of this node
c
            IF(ixy.eq.2) then
              nco=nod/nny
              if(nny*nco.lt.nod)  nco=nco+1
              nro=nny-(nny*nco-nod)
            else
              nro=nod/nnx
              if(nnx*nro.lt.nod)  nro=nro+1
              nco=nnx-(nnx*nro-nod)
            endif
c
              if(nco.eq.1 )                 then
c               y - face
c check for a corner
               if(nro.eq.1 )                 then
c                corner 1
                   if(ibog_y(1,1).ne.1.and.ibog_x(1,1).ne.1) then
c                   no Dirichlet conditions
                         ibc_og(nod,idf) = -(num - 1)
                         ibc_og(nod,4) = 0 
                   else
c                   Dirichlet condition on one of the faces
                        if(idf.eq.4) then
                         ibc_og(nod,4) = -(num - 1)
                        else
                         ibc_og(nod,idf) = 0           
                        endif 
                   endif 
               else if(nro.eq.nny )                 then
c                corner 2
                   if(ibog_y(nny,1).ne.1.and.ibog_x(1,2).ne.1) then
c                   no Dirichlet conditions
                         ibc_og(nod,idf) = -(num - 1)
                         ibc_og(nod,4) = 0 
                   else
c                   Dirichlet condition on one of the faces
                        if(idf.eq.4) then
                         ibc_og(nod,4) = -(num - 1)
                        else
                         ibc_og(nod,idf) = 0           
                        endif 
                   endif 
               else
c               not a corner
                         ibc_og(nod,idf) = -(num - 1)
               endif 
c
              else if(nco.eq.nnx )     then
c               y - face
c check for a corner
               if(nro.eq.1 )           then
c                corner 3
                   if(ibog_y(1,2).ne.1.and.ibog_x(nnx,1).ne.1) then
c                   no Dirichlet conditions
                         ibc_og(nod,idf) = -(num - 1)
                         ibc_og(nod,4) = 0 
                   else
c                   Dirichlet condition on one of the faces
                        if(idf.eq.4) then
                         ibc_og(nod,4) = -(num - 1)
                        else
                         ibc_og(nod,idf) = 0           
                        endif 
                   endif 
               else if(nro.eq.nny )                 then
c                corner 4
                   if(ibog_y(nny,2).ne.1.and.ibog_x(nnx,2).ne.1) then
c                   no Dirichlet conditions
                         ibc_og(nod,idf) = -(num - 1)
                         ibc_og(nod,4) = 0 
                   else
c                   Dirichlet condition on one of the faces
                        if(idf.eq.4) then
                         ibc_og(nod,4) = -(num - 1)
                        else
                         ibc_og(nod,idf) = 0           
                        endif 
                   endif 
               else
c               not a corner
                         ibc_og(nod,idf) = -(num - 1)
               endif 
c
              else if(nro.eq.1 .or. nro.eq.nny ) then
c               x - face
                  ibc_og(nod,idf) = -(num - 2 + iinc)
                  iinc = 1
              else 
                   write(6,*) 'STOP - THIRD-TYPE BC ERROR'
                         stop
              endif
c
         return
         end
