C     Last change:  JG   26 Sep 2000    1:01 pm
c
c        #########################################################
         subroutine exch_w (ncomp, ii, dsx, dsy, poro,
     &                      cow, cowg)
c        #########################################################
c
c compute the mass exchange terms for the water contaminant transport
c equation
c for ncomp = 1, compute coefficient at collocation point
c for ncomp = 0, compute coefficient at node and interpolate
c                to collocation point using either linear
c                or constant interpolation
c
        include 'include.f'
c
c--------------------------
        if (ncomp.eq.1)  then 
c--------------------------
c compute the exchange coeff at the collocation point
c--------------------------
c
             sa = 0.d0
             st = 0.d0
              vw_x   = 0.d0
              vw_y   = 0.d0
           so_mn = 1.d0
           so_mx = 0.d0
           sa_mn  = 1.d0
           sa_mx  = 0.d0
c
         do 21 i = 1, 4
c
                 ino    = npt_gs(inod(i) )
c
           vw_x = vw_x + vwx(ino) *b1(ii,i)
           vw_y = vw_y + vwy(ino) *b1(ii,i)
c
       st    = st    + stt(ino,1) * b3(ii,i,1)
     &               + stt(ino,2) * b3(ii,i,2) * dsx
     &               + stt(ino,3) * b3(ii,i,3) * dsy
     &               + stt(ino,4) * b3(ii,i,4) * dsx*dsy
c
       sa    = sa    + swt(ino,1) * b3(ii,i,1)
     &               + swt(ino,2) * b3(ii,i,2) * dsx
     &               + swt(ino,3) * b3(ii,i,3) * dsy
     &               + swt(ino,4) * b3(ii,i,4) * dsx*dsy
c
      if (stt(ino,1)-swt(ino,1).lt.so_mn) so_mn = stt(ino,1)-swt(ino,1)
      if (stt(ino,1)-swt(ino,1).gt.so_mx) so_mx = stt(ino,1)-swt(ino,1)
      if (swt(ino,1).lt.sa_mn)  sa_mn = swt(ino,1)
      if (swt(ino,1).gt.sa_mx)  sa_mx = swt(ino,1)
c
   21   continue
c
         so = st - sa
c
           if (so_mn.lt.0.d0)          so_mn = 0.d0
           if (so_mx.gt.1.d0)          so_mx = 1.d0
           if (so.gt.so_mx)             so = so_mx
           if (so.lt.so_mn)             so = so_mn
c
           if (sa_mn.lt.0.d0)          sa_mn = 0.d0
           if (sa_mx.gt.1.d0)          sa_mx = 1.d0
           if (sa.gt.sa_mx)             sa = sa_mx
           if (sa.lt.sa_mn)             sa = sa_mn
c
c N to W exchange
c 1.)
          vmag = dsqrt(vw_x*vw_x + vw_y*vw_y)
      cow = bow_1*vmag**bow_3*(poro*so)**(bow_2)/24.d0
c 2.)
c     cow = bow_1*(poro*so)**(bow_2)
c
c N in W to G exchange
c force exchange = 0 if Sg < 0.001
        IF(1.d0-so-sa .GE. 0.01d0)  then
c there is enough gas for exchange to occur
c 1.)
c          vmag = dsqrt(vg_x*vg_x + vg_y*vg_y)
c          cowg = bowg_1*vmag**bowg_3*(poro*sa)**(bowg_2)/24.d0
c 2.)
           cowg = bowg_1*(poro*sa)**(bowg_2)
        else
c extinguish the rate as Sg goes to 0
           cowg = bowg_1*(poro*(0.99d0-so))**(bowg_2)
     &           * (1.d0 - 100.d0*(0.01d0-1.d0+so+sa))
        endif
c--------------------------
        else
c--------------------------
c compute exchange term at the node and interpolate it to the col pt
c--------------------------
             cow  = 0.d0
             cowg = 0.d0
          do 19 i = 1, 4
c the node is
             ino = npt_gs(inod(i))
c find area about this node
                  nco=ino/nny
                  if(nny*nco.lt.ino)  nco=nco+1
                  nro=nny-(nny*nco-ino)
c
                 if(nco.eq.1)then
                     ddx=dx(1)/2.d0
                 else if(nco.eq.nnx)then
                     ddx=dx(nex)/2.d0
                 else
                     ddx=dx(nco)/2.d0+dx(nco-1)/2.d0
                 endif
c
                 if(nro.eq.1)then
                     ddy=dy(1)/2.d0
                 else if(nro.eq.nny)then
                     ddy=dy(ney)/2.d0
                 else
                     ddy=dy(nro)/2.d0+dy(nro-1)/2.d0
                 endif
c define nodal saturations
           if(swt(ino,1).gt.1.d0) then
               sa = 1.d0
           else if(swt(ino,1).lt.0.d0) then
               sa = 0.d0
           else 
               sa = swt(ino,1)
           endif
c
           if(stt(ino,1).gt.1.d0) then
               st = 1.d0
           else if(stt(ino,1).lt.0.d0) then
               st = 0.d0
           else 
               st = stt(ino,1)
           endif
c
           if(stt(ino,1)-swt(ino,1).gt.1.d0) then
               so = 1.d0
           else if(stt(ino,1)-swt(ino,1).lt.0.d0) then
               so = 0.d0
           else 
               so = stt(ino,1)-swt(ino,1)
           endif
c
c choose interpolation weight (linear or constant)
             b_wt = b1(ii,i)
c            b_wt = 0.25d0   
         cow  = cow  + bow_1 * b_wt / (ddx*ddy)
     &   * (poro*so)**(bow_2) 
     &   * (dsqrt(vwx(ino)*vwx(ino)+vwy(ino)*vwy(ino)))**(bow_3)
c
c force exchange = 0 if Sg < 0.001
        IF(1.d0-st .GT. 0.001d0)  then
c there is enough gas for exchange to occur
         cowg  = cowg  + bowg_1 * b_wt / (ddx*ddy)
     &   *(poro*sa)**(bowg_2) 
c    &   *(dsqrt(vgx(ino)*vgx(ino)+vgy(ino)*vgy(ino)))**(bowg_3)
        endif

c
   19    continue
c--------------------------
        endif
c--------------------------
c
                   return 
                   end 
c
c        #########################################################
         subroutine exch_g (ncomp,ii,dsx,dsy,poro,cog,cowg)
c        #########################################################
c
c compute the mass exchange terms for the gas contaminant transport
c equation
c for ncomp = 1, compute coefficient at collocation point
c for ncomp = 0, compute coefficient at node and interpolate
c                to collocation point using either linear
c                or constant interpolation
c
        include 'include.f'
c
c--------------------------
        if (ncomp.eq.1)  then 
c--------------------------
c compute the exchange coeff at the collocation point
c
             sa = 0.d0
             st = 0.d0
              vg_x   = 0.d0
              vg_y   = 0.d0
           so_mn = 1.d0
           so_mx = 0.d0
           sa_mn  = 1.d0
           sa_mx  = 0.d0
c
         do 21 i = 1, 4
c
                 ino    = npt_gs(inod(i) )
c
             vg_x =   vg_x   + vgx(ino)  *b1(ii,i)
             vg_y =   vg_y   + vgy(ino)  *b1(ii,i)
c
       st    = st    + stt(ino,1) * b3(ii,i,1)
     &               + stt(ino,2) * b3(ii,i,2) * dsx
     &               + stt(ino,3) * b3(ii,i,3) * dsy
     &               + stt(ino,4) * b3(ii,i,4) * dsx*dsy
c
       sa    = sa    + swt(ino,1) * b3(ii,i,1)
     &               + swt(ino,2) * b3(ii,i,2) * dsx
     &               + swt(ino,3) * b3(ii,i,3) * dsy
     &               + swt(ino,4) * b3(ii,i,4) * dsx*dsy
c
      if (stt(ino,1)-swt(ino,1).lt.so_mn) so_mn = stt(ino,1)-swt(ino,1)
      if (stt(ino,1)-swt(ino,1).gt.so_mx) so_mx = stt(ino,1)-swt(ino,1)
      if (swt(ino,1).lt.sa_mn)  sa_mn = swt(ino,1)
      if (swt(ino,1).gt.sa_mx)  sa_mx = swt(ino,1)
c
   21   continue
c
         so = st - sa
           if (so_mn.lt.0.d0)          so_mn = 0.d0
           if (so_mx.gt.1.d0)          so_mx = 1.d0
           if (so.gt.so_mx)             so = so_mx
           if (so.lt.so_mn)             so = so_mn
c
           if (sa_mn.lt.0.d0)          sa_mn = 0.d0
           if (sa_mx.gt.1.d0)          sa_mx = 1.d0
           if (sa.gt.sa_mx)             sa = sa_mx
           if (sa.lt.sa_mn)             sa = sa_mn
c
c N to G exchange
c 1.)
c          vmag = dsqrt(vg_x*vg_x + vg_y*vg_y)
c          cog = bog_1*vmag**(bog_3)*(poro*so)**(bog_2)/24.d0
c 2.)
           cog = bog_1*(poro*so)**(bog_2)
c
c N in W to G exchange
c force exchange = 0 if Sg = 0
        IF(1.d0-so-sa .GE. 0.01d0)  then
c there is enough gas for normal exchange to occur
c 1.)
c          cowg = bowg_1*vmag**(bowg_3)*(poro*sa)**(bowg_2)/24.d0
c 2.)
           cowg = bowg_1*(poro*sa)**(bowg_2)
        else
c extinguish the rate as Sg goes to 0
           cowg = bowg_1*(poro*(0.99d0-so))**(bowg_2)
     &           * (1.d0 - 100.d0*(0.01d0-1.d0+so+sa))
        endif
c
c--------------------------
        else
c--------------------------
c compute exchange term at the node and interpolate it to the col pt
c--------------------------
             cog  = 0.d0
             cowg = 0.d0
          do 19 i = 1, 4
c the node is
             ino = npt_gs(inod(i))
c find area about this node
                  nco=ino/nny
                  if(nny*nco.lt.ino)  nco=nco+1
                  nro=nny-(nny*nco-ino)
c
                 if(nco.eq.1)then
                     ddx=dx(1)/2.d0
                 else if(nco.eq.nnx)then
                     ddx=dx(nex)/2.d0
                 else
                     ddx=dx(nco)/2.d0+dx(nco-1)/2.d0
                 endif
c
                 if(nro.eq.1)then
                     ddy=dy(1)/2.d0
                 else if(nro.eq.nny)then
                     ddy=dy(ney)/2.d0
                 else
                     ddy=dy(nro)/2.d0+dy(nro-1)/2.d0
                 endif
c define nodal saturations
           if(swt(ino,1).gt.1.d0) then
               sa = 1.d0
           else if(swt(ino,1).lt.0.d0) then
               sa = 0.d0
           else 
               sa = swt(ino,1)
           endif
c
           if(stt(ino,1).gt.1.d0) then
               st = 1.d0
           else if(stt(ino,1).lt.0.d0) then
               st = 0.d0
           else 
               st = stt(ino,1)
           endif
c
           if(stt(ino,1)-swt(ino,1).gt.1.d0) then
               so = 1.d0
           else if(stt(ino,1)-swt(ino,1).lt.0.d0) then
               so = 0.d0
           else 
               so = stt(ino,1)-swt(ino,1)
           endif
c
c choose interpolation weight (linear or constant)
             b_wt = b1(ii,i)
c            b_wt = 0.25d0   
         cog  = cog  + bog_1 * b_wt / (ddx*ddy)
     &   * (poro*so)**(bow_2)
c    &   * (dsqrt(vgx(ino)*vgx(ino)+vgy(ino)*vgy(ino)))**(bow_3)
c
c force exchange = 0 if Sg < 0.001
        IF(1.d0-st .GT. 0.001d0)  then
c there is enough gas for exchange to occur
         cowg  = cowg  + bowg_1 * b_wt / (ddx*ddy)
     &   *(poro*sa)**(bowg_2) 
c    &   *(dsqrt(vgx(ino)*vgx(ino)+vgy(ino)*vgy(ino)))**(bowg_3)
        ENDIF
c
   19    continue
c--------------------------
        endif
c--------------------------
                   return 
                   end 
