c************************************************************
      subroutine  flow_fun
c************************************************************
c
c  calculate the functions of saturation for the 
c  TOTAL FLOW EQUATION
c
c given Sw and St 
c we need:
c Nodal values of 
c pcnw1           => Pcnw
c pcgn1           => Pcgn
c rpa             => Krw
c rpn             => Kro
c rpg             => Krg
c
c 3 Hermite coefficients: pa11, sw11, st11
c
        include 'include.f'
c
           do 10 ik = 1, nn
c
          sw = sw11(ik,1)
          st = st11(ik,1)
c
c given Sw what is Pcnw and dPcnw/dSw
             call pc_nw    (sw, pc, d_pc, ik)
             call lev_sw_p (pc,  pcnw1(ik) )
             call lev_sw_p (d_pc,dpcnw(ik) )
c
c given St what is Pcgn and dPcgn/dSt
             call pc_gn    (st, pc, d_pc, ik)
             call lev_st_p (pc,  pcgn1(ik) )
             call lev_st_p (d_pc,dpcgn(ik) )
c
c water rel perm 
               call sfunkw (sw,   rpa(ik),ik)
c gas rel perm 
               call sfunkg (st,   rpg(ik),ik)
c NAPL rel perm 
               call sfunkn (sw,st,rpn(ik),ik)
c
   10    continue
c
c   reset the Dpc/Dsw vectors to reflect the LINEAR no-flow condition.
            call no_flow
                                                 return
                                                 end
c
c     ************************************************************
c     ************************************************************
      subroutine  water_prop (roa,wa,dw,visw)
c     ************************************************************
c     ************************************************************
c
c  calculate the water density and viscosity
c  given NAPL concentration
c
        include 'include.f'
c
           if(roa.gt.parow) then
                oa = parow
           else if(roa.lt.0.d0) then
                oa = 0.d0 
           else
                oa = roa
           endif
c
           wa = rw_r*(1.d0-oa/rn_r)
c
           dw     = oa + wa  
c
c viscosity of the phase
        visw   = vw_r**(wa/rw_r) * vn_r**(oa/rn_r) 
c
                                 return
                                 end
c     ************************************************************
c     ************************************************************
      subroutine  gas_prop (rog,gg,dg,visg)
c     ************************************************************
c     ************************************************************
c
c  calculate the gas density and viscosity
c  given NAPL concentration
c
        include 'include.f'
c
           if(rog.gt.parog) then
                og = parog
           else if(rog.lt.0.d0) then
                og = 0.d0 
           else
                og = rog
           endif
c
c          pg = pa11(ik,1) + pcnw1(ik) + pcgn1(ik)
c          gg = rg_r*(pg/pg_r - og/rn_r)
c
           gg = rg_r*(1.d0 - og/rn_r)
           dg = og + gg  
c
c viscosity of the phase
           visg = vg_r**(gg/rg_r) * vn_r**(og/rn_r) 
c
                                 return
                                 end
c     ************************************************************
c     ************************************************************
      subroutine  fun_at_n
c     ************************************************************
c     ************************************************************
c
c 1.)  INITIALIZE Pw Sw St Row Rog 
c 2.)  project Rog and Row for mass exchange
c
c
        include 'include.f'
c
        do 76 j = 1, 4
          do 75 i = 1, nn
                  swt(i,j)  = sw11(i,j)
                  stt(i,j)  = st11(i,j)
   75     continue
   76   continue
c
      if(ntr_ow.gt.0.or.ntr_og.gt.0)        then
        do 6 j = 1, 4
          do 5 i = 1, nn
           roa_p(i,j) = theta*roa11(i,j) + (1.d0 - theta)*roat(i,j)
           rog_p(i,j) = theta*rog11(i,j) + (1.d0 - theta)*rogt(i,j)
           roat(i,j) = roa11(i,j)
           rogt(i,j) = rog11(i,j)
    5     continue
    6   continue
c
      endif
c
c     save pressure conditions for flow bc's 2 and 3 in pat
           call pr_save
c
                                 return
                                 end
c************************************************************
c     ************************************************************
      subroutine  vel_w
c     ************************************************************
c************************************************************
c
c   set water phase velocity coefficients
c
c  dated at most recent flow solution
c
c  VECTORS: vwx, vwy
c
        include 'include.f'
c
           do 10 ik = 1, nn
c
      call  water_prop (roa11(ik,1),wa,rw,vw)
c
c velocity components
         if(dabs(vtx(ik)).gt.1.d-10 ) then
          vwx(ik) = - (perm(ik)*rpa(ik)/vw)*
     &                (pa11(ik,2) - rw*grav*dcos(thgx))
         else
          vwx(ik) = 0.d0
         endif
c
         if(dabs(vty(ik)).gt.1.d-10 ) then
          vwy(ik) = - (perm(ik)*rpa(ik)/vw)*
     &                (pa11(ik,3) - rw*grav*dcos(thgy))
         else
          vwy(ik) = 0.d0
         endif
c
   10   continue
c
                                                 return
                                                 end
c************************************************************
c     ************************************************************
      subroutine   vel_g
c     ************************************************************
c************************************************************
c
c   set gas phase velocity coefficients
c
c  dated at most recent flow solution
c
c  VECTORS: vgx, vgy
c
        include 'include.f'
c
           do 10 ik = 1, nn
c
      call  gas_prop (rog11(ik,1),gg,rg,vg)
c
c velocity components
c
         if( dabs(vtx(ik)).gt.1.d-10 )       then
c
             if(dabs(st11(ik,2)).lt.1.d-10)  then
                pcgn =  0.d0
             else
                pcgn =  dpcgn (ik) * st11(ik,2)
             endif
             if(dabs(sw11(ik,2)).lt.1.d-10)  then
                pcnw =  0.d0
             else
                pcnw =  dpcnw (ik) * sw11(ik,2)
             endif
          vgx(ik) = - (perm(ik)*rpg(ik)/vg)*
     &                ( pa11(ik,2) + pcnw + pcgn
     &              -  rg*grav*dcos(thgx))
         else
          vgx(ik) = 0.d0
         endif
c
         if(dabs(vty(ik)).gt.1.d-10 ) then
             if(dabs(st11(ik,3)).lt.1.d-10)  then
                pcgn =  0.d0
             else
                pcgn =  dpcgn (ik) * st11(ik,3)
             endif
             if(dabs(sw11(ik,3)).lt.1.d-10)  then
                pcnw =  0.d0
             else
                pcnw =  dpcnw (ik) * sw11(ik,3)
             endif
          vgy(ik) = - (perm(ik)*rpg(ik)/vg)*
     &                ( pa11(ik,3) + pcnw + pcgn
     &              -  rg*grav*dcos(thgy))
         else
          vgy(ik) = 0.d0
         endif
c
   10   continue
c
                                                 return
                                                 end
c     ************************************************************
      subroutine   vel_n (ik, vnx, vny)
c     ************************************************************
c************************************************************
c
c   compute phase velocities
        include 'include.f'
c
         if( dabs(vtx(ik)).gt.1.d-10 )       then
c
             if(dabs(sw11(ik,2)).lt.1.d-10)  then
                pcnw =  0.d0
             else
                pcnw =  dpcnw (ik) * sw11(ik,2)
             endif
          vnx = - (perm(ik)*rpn(ik)/vn_r)*
     &            (pa11(ik,2) + pcnw
     &          -  rn_r*grav*dcos(thgx))
         else
          vnx = 0.d0
         endif
c
         if(dabs(vty(ik)).gt.1.d-10 ) then
             if(dabs(sw11(ik,3)).lt.1.d-10)  then
                pcnw =  0.d0
             else
                pcnw =  dpcnw (ik) * sw11(ik,3)
             endif
          vny = - (perm(ik)*rpn(ik)/vn_r)*
     &                (pa11(ik,3) +  pcnw
     &              -  rn_r*grav*dcos(thgy))
         else
          vny = 0.d0
         endif
c
                                                 return
                                                 end
c
c************************************************************
c************************************************************
      subroutine  v_tot 
c************************************************************
c
c given the pressure solution calculate the components of
c each phase velocity
c
c
        include 'include.f'
c
           do 20 ik = 1, nn
c calculate the total velocity at each node
c
      call  water_prop (roa11(ik,1),wa,rw,vw)
      call  gas_prop   (rog11(ik,1),gg,rg,vg)
c
             if(dabs(st11(ik,2)).lt.1.d-10)  then
                pcgn =  0.d0
             else
                pcgn =  dpcgn (ik) * st11(ik,2)
             endif
             if(dabs(sw11(ik,2)).lt.1.d-10)  then
                pcnw =  0.d0
             else
                pcnw =  dpcnw (ik) * sw11(ik,2)
             endif
c
          vtx(ik) = - perm(ik)*((rpa(ik)/vw)*
     &                (pa11(ik,2) -  rw*grav*dcos(thgx))
     &              + (rpn(ik)/vn_r)*
     &                (pa11(ik,2) + pcnw - rn_r*grav*dcos(thgx))
     &              + (rpg(ik)/vg)*
     &                ( pa11(ik,2) + pcnw + pcgn
     &              -  rg*grav*dcos(thgx)))
c
c
             if(dabs(st11(ik,3)).lt.1.d-10)  then
                pcgn =  0.d0
             else
                pcgn =  dpcgn (ik) * st11(ik,3)
             endif
             if(dabs(sw11(ik,3)).lt.1.d-10)  then
                pcnw =  0.d0
             else
                pcnw =  dpcnw (ik) * sw11(ik,3)
             endif
c
          vty(ik) = - perm(ik)*((rpa(ik)/vw)*
     &                (pa11(ik,3) -  rw*grav*dcos(thgy))
     &              + (rpn(ik)/vn_r)*
     &                (pa11(ik,3) + pcnw - rn_r*grav*dcos(thgy))
     &              + (rpg(ik)/vg)*
     &                ( pa11(ik,3) + pcnw + pcgn
     &              -  rg*grav*dcos(thgy)))
c
   20    continue
c
                                                 return
                                                 end
c************************************************************
c     ************************************************************
      subroutine  disp_w (ik, dspx, dspy, dspxy)
c     ************************************************************
c************************************************************
c
c   set water phase dispersion coefficients
c
c  dated at most recent flow solution
c
c  VECTORS: dspx, dspy, dspxy
c
        include 'include.f'
c
c       call  water_prop (roa11(ik,1),wa,rw,vw)
              rw = rw_r
c
          sat = sw11(ik,1)
        if(sat.gt.1.d0 ) sat = 1.d0
        if(sat.lt. 0.d0) sat =  0.d0
c
         vmag = dsqrt(vwx(ik)*vwx(ik) 
     &              + vwy(ik)*vwy(ik) )
c
         if( vmag .lt. 1.0d-15 )     then
           dspx  =  por(ik)**1.333333 * sat**3.333333 * diffw
     &              * (rw_r/rw)
           dspy  =  por(ik)**1.333333 * sat**3.333333 * diffw
     &              * (rw_r/rw)
           dspxy =     0.d0
         else
           dspx  = (por(ik)**1.333333*sat**3.333333*diffw
     &            + (along-atran)*vwx(ik)*vwx(ik)/vmag 
     &            + atran*vmag )
     &              * (rw_r/rw)
           dspy  = (por(ik)**1.333333*sat**3.333333*diffw
     &            + (along-atran)*vwy(ik)*vwy(ik)/vmag 
     &            + atran*vmag )
     &              * (rw_r/rw)
c
           dspxy = (along-atran)*vwx(ik)*vwy(ik)/vmag
     &              * (rw_r/rw)
         endif
c
                                                 return
                                                 end
c ************************************************************
      subroutine   disp_g (ik, dspx, dspy, dspxy)
c ************************************************************
c************************************************************
c
c   set gas phase dispersion coefficients
c
c  dated at most recent flow solution
c
c  VECTORS: dspx, dspy, dspxy
c
        include 'include.f'
c
c        call  gas_prop   (rog11(ik,1),gg,rg,vg)
              rg = rg_r
c
         vmag = dsqrt(vgx(ik)*vgx(ik) 
     &              + vgy(ik)*vgy(ik) )
c
         sg  = 1.d0 - st11(ik,1)
        if(sg.gt.1.d0 ) sg = 1.d0
        if(sg.lt. 0.d0) sg =  0.d0
c
         if( vmag .lt. 1.0d-15 )     then
           dspx  =  por(ik)**1.333333 * sg**3.333333 * diffg
     &              * (rg_r/rg)
           dspy  =  por(ik)**1.333333 * sg**3.333333 * diffg
     &              * (rg_r/rg)
           dspxy =     0.d0
         else
           dspx  = (por(ik)**1.333333 * sg**3.333333 * diffg
     &            + (along-atran)*vgx(ik)*vgx(ik)/vmag 
     &            + atran*vmag )
     &              * (rg_r/rg)
           dspy  = (por(ik)**1.333333 * sg**3.333333 * diffg
     &            + (along-atran)*vgy(ik)*vgy(ik)/vmag 
     &            + atran*vmag )
     &              * (rg_r/rg)
c
           dspxy = (along-atran)*vgx(ik)*vgy(ik)/vmag
     &              * (rg_r/rg)
         endif
c
                                                 return
                                                 end
c
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
       subroutine dfds3 (dfww,dfwg,dfgg,dfgw,dfnw,dfng,
     &                   dfwgw,dfwgg,dfwnw,dfgng,ik)
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c
        include 'include.f'
c
      call  water_prop (roa11(ik,1),wa,rw,vw)
      call  gas_prop (rog11(ik,1),gg,rg,vg)
c  derivatives of fractional flow
c     numerical differentiation
       ffw         = rpa (ik)/
     &        (rpa (ik) + vw/vn_r*rpn(ik) + vw/vg*rpg(ik))
       ffn         = rpn (ik)/
     &        (rpn (ik) + vn_r/vw*rpa(ik) + vn_r/vg*rpg(ik))
       ffg         = rpg (ik)/
     &        (rpg (ik) + vg/vn_r*rpn(ik) + vg/vw*rpa(ik))
       ffwn        = rpa(ik)*rpn(ik)/vn_r/
     &        (rpa (ik) + vw/vn_r*rpn(ik) + vw/vg*rpg(ik))
       ffwg        = rpa(ik)*rpg(ik)/vg/
     &        (rpa (ik) + vw/vn_r*rpn(ik) + vw/vg*rpg(ik))
       ffgn        = rpg (ik)*rpn(ik)/vn_r/
     &        (rpg (ik) + vg/vn_r*rpn(ik) + vg/vw*rpa(ik))
c
          sw = sw11(ik,1)
          st = st11(ik,1)
c
cc$$$$$$$
c WATER 
cc$$$$$$$
c               if (nhc_w(ik)/2*2.eq.nhc_w(ik) )  then
                if (sw11(ik,1) .gt. swt(ik,1)  )  then
c             on a water imbibition path (sw increasing)
                 sw_w = sw + 1.0d-6
                else 
c             on a water drainage path (sw decreasing)
                 sw_w = sw - 1.0d-6
                endif 
c
               rpw = rpa (ik)
               call sfunkw (sw_w,     rpa(ik)  ,ik)
               call sfunkn (sw_w,st  ,rpn_e  ,ik)
               rpg_e = rpg (ik)
               rpa_e = rpa (ik)
               rpa(ik) = rpw
c
           if(ffw .lt.1.d0-1.d-12.and.ffw .gt.1.d-12)  then
               ffw_en = rpa_e / 
     &              (rpa_e + vw/vn_r*rpn_e + vw/vg*rpg_e  )
               if(ffw_en.gt.1.d-12) then
                  dfww = ( ffw_en - ffw ) / 1.0d-6
               else
                  dfww = 0.d0
               endif 
           else
                  dfww = 0.0d0
           endif
c
           if(ffwn .gt. 1.d-12)  then
c
               ffwn_en = rpa_e*rpn_e/vn_r / 
     &              (rpa_e + vw/vn_r*rpn_e + vw/vg*rpg_e  )
               if(ffwn_en.gt.1.d-12) then
                  dfwnw = ( ffwn_en - ffwn ) / 1.0d-6
               else
                  dfwnw = 0.d0
               endif 
           else
                  dfwnw = 0.0d0
           endif
c
           if(ffwg .gt. 1.d-12)  then
               ffwg_en = rpa_e*rpg_e/vg / 
     &              (rpa_e + vw/vn_r*rpn_e + vw/vg*rpg_e  )
                         if(ffwg_en.gt.1.d-12) then
                            dfwgw = ( ffwg_en - ffwg ) / 1.0d-6
                         else
                            dfwgw = 0.d0
                         endif 
           else
                            dfwgw = 0.0d0
           endif
c
           if(ffg .lt.1.d0-1.d-12.and.ffg .gt.1.d-12)  then
               ffg_en = rpg_e / 
     &              (rpg_e + vg/vn_r*rpn_e + vg/vw*rpa_e  )
               if(ffg_en.gt.1.d-12) then
                  dfgw = ( ffg_en - ffg ) / 1.0d-6
               else
                  dfgw = 0.d0
               endif 
           else
                  dfgw = 0.0d0
           endif
c          if(ffgn .gt.1.d-12)  then
c              ffgn_en = rpn_e*rpg_e/vg / 
c    &              (rpn_e + vn_r/vw*rpa_e + vn_r/vg*rpg_e  )
c                  if(ffgn_en.gt.1.d-12) then
c                     dfgnw = ( ffgn_en - ffgn ) / 1.0d-6
c                  else
c                     dfgnw = 0.d0
c                  endif 
c          else
c                     dfgnw = 0.0d0
c          endif
                   if(ffn .lt.1.d0-1.d-12.and.ffn .gt.1.d-12)  then
                    ffn_en = rpn_e / 
     &              (rpn_e + vn_r/vw*rpa_e + vn_r/vg*rpg_e  )
                         if(ffn_en.gt.1.d-12) then
                            dfnw = ( ffn_en - ffn ) / 1.0d-6
                         else
                            dfnw = 0.d0
                         endif 
                   else
                       dfnw = 0.0d0
                   endif
c
cc$$$$$$$
c gas    
cc$$$$$$$
c               if (nhc_t(ik)/2*2.eq.nhc_t(ik) )  then
                if (st11(ik,1) .gt. stt(ik,1)  )  then
c             on a total imbibition path (st increasing)
                 st_t = st + 1.0d-6
                else 
c             on a total drainage path (st decreasing)
                 st_t = st - 1.0d-6
                endif 
c
               rp_g  = rpg(ik)
               call sfunkg (st_t,     rpg(ik),ik)
               call sfunkn (sw  ,st_t,rpn_e  ,ik)
               rpa_e  = rpa(ik)
               rpg_e  = rpg(ik)
               rpg(ik) = rp_g 
c
           if(ffg .lt.1.d0-1.d-12.and.ffg .gt.1.d-12)  then
c
               ffg_en = rpg_e / 
     &              (rpg_e + vg/vn_r*rpn_e + vg/vw*rpa_e  )
               if(ffg_en.gt.1.d-12) then
                  dfgg = ( ffg_en - ffg ) / 1.0d-6
               else
                  dfgg = 0.d0
               endif 
           else
                  dfgg = 0.0d0
           endif
c
           if(ffwg .gt.1.d-12)  then
c
               ffwg_en = rpg_e*rpa_e/vw / 
     &              (rpg_e + vg/vn_r*rpn_e + vg/vw*rpa_e  )
               if(ffwg_en.gt.1.d-12) then
                  dfwgg = ( ffwg_en - ffwg ) / 1.0d-6
               else
                  dfwgg = 0.d0
               endif 
           else
                  dfwgg = 0.0d0
           endif
c
           if(ffgn .gt.1.d-12)  then
               ffgn_en = rpn_e*rpg_e/vg / 
     &              (rpn_e + vn_r/vw*rpa_e + vn_r/vg*rpg_e  )
                   if(ffgn_en.gt.1.d-12) then
                      dfgng = ( ffgn_en - ffgn ) / 1.0d-6
                   else
                      dfgng = 0.d0
                   endif 
           else
                      dfgng = 0.0d0
           endif
c
           if(ffw .lt.1.d0-1.d-12.and.ffw .gt.1.d-12)  then
               ffw_en = rpa_e / 
     &              (rpa_e + vw/vn_r*rpn_e + vw/vg*rpg_e  )
               if(ffw_en.gt.1.d-12) then
                  dfwg = ( ffw_en - ffw ) / 1.0d-6
               else
                  dfwg = 0.d0
               endif 
           else
                  dfwg = 0.0d0
           endif
c          if(ffwn .gt. 1.d-12)  then
c              ffwn_en = rpa_e*rpn_e/vn_r / 
c    &              (rpa_e + vw/vn_r*rpn_e + vw/vg*rpg_e  )
c              if(ffwn_en.gt.1.d-12) then
c                 dfwng = ( ffwn_en - ffwn ) / 1.0d-6
c              else
c                 dfwng = 0.d0
c              endif 
c          else
c                 dfwng = 0.0d0
c          endif
c
                   if(ffn .lt.1.d0-1.d-08.and.ffn .gt.1.d-08)  then
                    ffn_en = rpn_e / 
     &              (rpn_e + vn_r/vw*rpa_e + vn_r/vg*rpg_e  )
                         if(ffn_en.gt.1.d-12) then
                            dfng = ( ffn_en - ffn ) / 1.0d-6
                         else
                            dfng = 0.d0
                         endif 
                   else
                       dfng = 0.0d0
                   endif
c
                 return
                 end
