C     Last change:  JG    8 May 2002   11:35 am
c
c k-S-P HYSTERESIS DEFINITION AND UPDATE
c
c Main subroutines
c  subroutine hyst_ic - initial condition k-S-P parameter setup
c  subroutine trap_up - update for trapping parameters
c  subroutine sw_pc - update for Sw(Pcnw) parameters
c  subroutine st_pc - update for St(Pcgn) parameters
c
c List of parameters
c
c trapping vectors
c maxumum saturation available for entrapment
c                     sw_mx(j)   
c                     sg_mx(j)  
c                     sn_mx(j)
c current values
c                     swt_c(j)   
c                     sgt_c(j)  
c                     snt_c(j)
c maxumum values
c                     swt_mx(j)   
c                     sgt_mx(j)  
c                     snt_mx(j)
c minumum values
c                     swt_mn(j)   
c                     sgt_mn(j)  
c                     snt_mn(j)
c
c THE S-P MODEL VECTORS 
c given this information initialize effective saturation parameters
c curve type odd=drainage, even=imbib
c                     nhc_t(ik)
c                     nhc_w(ik)
c residual scaling parameter
c                     sr_t(ik,nhc_t(ik))   
c                     sr_w(ik,nhc_w(ik))
c saturation scaling parameter
c                     ss_t(ik,nhc_t(ik))   
c                     ss_w(ik,nhc_w(ik))   
c curve origin
c                     sb_t(ik,nhc_t(ik))   
c                     sb_w(ik,nhc_w(ik))   
c
c shape parameter
c                     a_w(ik,nhc_w(ik))   
c                     a_t(ik,nhc_t(ik))   
c
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c             INITIALIZE
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
           subroutine hyst_ic (j, swinit, stinit)
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c
c Initialize trapping parameters
c values based on swinit and stinit and some assumptions:
c    if a phase is specified < residual then it is at an immobile state
c
        include 'include.f'
c
         sginit = 1.d0 - stinit
         sninit = stinit - swinit
c
        if ( sninit .lt. 1.d0-epsil ) then
         snr = (snnr(j)*swinit + snwr(j)*sginit)/(sginit+swinit)
        else
          snr = (snnr(j) + snwr(j))/2.d0
        endif 
c
         if( dabs(stinit-swinit).lt.1.d-6 ) then
c *****   no NAPL in the system
                    sn_mx(j)   = 0.d0 
                    snt_mx(j)  = 0.d0
                    snt_mn(j)  = 0.d0
                    snt_c(j)   = 0.d0
          if( swinit.ge.1.d0-sgr(j) ) then
c            then we are starting out with immobile residual gas if any
c            set both curves to origin of PDC/MDC (curve 1)
                 nhc_w(j) = 1  
                 nhc_t(j) = 1  
c
c                   initialize trapping parameters for WATER
                  sw_mx(j)   = swinit
                if (swr(j).lt.epsil) then
                  swt_mn(j)  = 0.d0   
                  swt_c(j)   = 0.d0
                  swt_mx(j)  = 0.d0
                else
                  swt_mn(j)  = swr(j)   
                  swt_c(j) = swt_mn(j)*(1.d0-swinit)/(1.d0-swt_mn(j))
                   r = 1.d0/(swr(j) - swt_c(j)) - 1.d0/(1.d0 - swt_c(j))
                  swt_mx(j) = swt_c(j) +  (sw_mx(j) - swt_c(j))
     &                       / (1.d0 + r * (sw_mx(j) - swt_c(j)) ) 
                endif
c
c                   initialize trapping parameters for gas 
                    sg_mx(j)   = 1.d0 - stinit 
                    sgt_mx(j)  = 1.d0 - stinit
                    sgt_mn(j)  = 1.d0 - stinit
                    sgt_c(j)   = 1.d0 - stinit
c
          else if( swinit.le.swr(j) ) then
c          then we are starting out with immobile residual water if any
c            set both curves to origin of PIC/MIC (curve 2)
                 nhc_w(j) = 2  
                 nhc_t(j) = 2  
c                   initialize trapping parameters for gas  
                    sg_mx(j)   = 1.d0 - stinit
                if (sgr(j).lt.epsil) then
                  sgt_mn(j)  = 0.d0   
                  sgt_c(j)   = 0.d0
                  sgt_mx(j)  = 0.d0
                else
                    sgt_mn(j)  = sgr(j)
c
                  sgt_c(j) = sgt_mn(j)*(1.d0-sginit)/(1.d0-sgt_mn(j))
                   r = 1.d0/(sgr(j) - sgt_c(j)) - 1.d0/(1.d0 - sgt_c(j))
                  sgt_mx(j) = sgt_c(j) +  (sg_mx(j) - sgt_c(j))
     &                       / (1.d0 + r * (sg_mx(j) - sgt_c(j))) 
                endif
c
c                   initialize trapping parameters for water
                    sw_mx(j)   = swinit 
                    swt_mx(j)  = swinit
                    swt_mn(j)  = swinit
                    swt_c(j)   = swinit
          else 
c          then we are starting out with both phases mobile
c            set both curves to PDC (curve 1)
                 nhc_w(j) = 1  
                 nhc_t(j) = 1  
c                   initialize trapping parameters for WATER
                    sw_mx(j)   = 1.d0
              if (swr(j).lt.epsil) then
                  swt_mn(j)  = 0.d0   
                  swt_c(j)   = 0.d0
                  swt_mx(j)  = 0.d0
              else
                swt_mx(j) = swr(j)
                swt_mn(j) = 0.d0
                swt_c(j) = swr(j)*((1.d0 - swinit)/(1.d0 - swr(j)))**e_r
              endif
c                   initialize trapping parameters for gas 
                    sg_mx(j)   = 1.d0 - stinit
                    sgt_mn(j)  = 0.d0
                    sgt_c(j)   = 0.d0
                if (sgr(j).lt.epsil) then
                  sgt_mx(j)  = 0.d0
                else
                    r = 1.d0/sgr(j) - 1.d0
                    sgt_mx(j) = sg_mx(j)/(1.d0 + r*sg_mx(j))
                endif
          endif
c *****
         else if( dabs(1.d0-stinit).lt.1.d-6 ) then
c *****
c         no gas in the system
c            set St curve to origin of PDC (curve 1)
                 nhc_t(j) = 1  
                    sg_mx(j)   = 0.d0 
                    sgt_mx(j)  = 0.d0
                    sgt_mn(j)  = 0.d0
                    sgt_c(j)   = 0.d0 
          if( swinit.ge.1.d0-snr) then
c            then we are starting out with immobile residual NAPL if any
c            set Sw curve to origin of PDC/MDC (curve 1)
                 nhc_w(j) = 1  
c
c                   initialize trapping parameters for WATER
                  sw_mx(j)   = swinit
                if (swr(j).lt.epsil) then
                  swt_mn(j)  = 0.d0   
                  swt_c(j)   = 0.d0
                  swt_mx(j)  = 0.d0
                else
                  swt_mn(j)  = swr(j)   
                  swt_c(j) = swt_mn(j)*(1.d0-swinit)/(1.d0-swt_mn(j))
                   r = 1.d0/(swr(j) - swt_c(j)) - 1.d0/(1.d0 - swt_c(j))
                  swt_mx(j) = swt_c(j) +  (sw_mx(j) - swt_c(j))
     &                       / (1.d0 + r * (sw_mx(j) - swt_c(j))) 
                endif
c                   initialize trapping parameters for NAPL
                    sn_mx(j)   = 1.d0 - swinit 
                    snt_mx(j)  = 1.d0 - swinit
                    snt_mn(j)  = 1.d0 - swinit
                    snt_c(j)   = 1.d0 - swinit
c
          else if( swinit.le.swr(j) ) then
c          then we are starting out with immobile residual water if any
c            set Sw curve to origin of PIC/MIC (curve 2)
                 nhc_w(j) = 2  
c                   initialize trapping parameters for NAPL 
                    sn_mx(j)   = sninit
                if (snr.lt.epsil) then
                  snt_mn(j)  = 0.d0   
                  snt_c(j)   = 0.d0
                  snt_mx(j)  = 0.d0
                else
                  snt_mn(j)  = snr
                  snt_c(j) = snt_mn(j)*(1.d0-sninit)/(1.d0-snt_mn(j))
                    r = 1.d0/(snr - snt_c(j)) - 1.d0/(1.d0 - snt_c(j))
                  snt_mx(j) = snt_c(j) +  (sn_mx(j) - snt_c(j))
     &                       / (1.d0 + r * (sn_mx(j) - snt_c(j))) 
                endif
c
c                   initialize trapping parameters for water
                    sw_mx(j)   = swinit 
                    swt_mx(j)  = swinit
                    swt_mn(j)  = swinit
                    swt_c(j)   = swinit
          else 
c          then we are starting out with both phases mobile
c            set Sw curve to PDC (curve 1)
                 nhc_w(j) = 1  
c                   initialize trapping parameters for WATER
                    sw_mx(j)   = 1.d0
             if (swr(j).lt.epsil) then
                  swt_mn(j)  = 0.d0   
                  swt_c(j)   = 0.d0
                  swt_mx(j)  = 0.d0
             else
               swt_mx(j) = swr(j)
               swt_mn(j) = 0.d0
               swt_c(j)  = swr(j)*((1.d0 - swinit)/(1.d0 - swr(j)))**e_r
             endif
c                   initialize trapping parameters for NAPL 
                    sn_mx(j)   = sninit
                    snt_mn(j)  = 0.d0
                    snt_c(j)   = 0.d0
                if (snr.lt.epsil) then
                  snt_mx(j)  = 0.d0
                else
                    r = 1.d0/snr - 1.d0
                    snt_mx(j) = sn_mx(j)/(1.d0 + r*sn_mx(j))
                endif
          endif
c *****
         else
c *****
c         NAPL and gas are present in the system
c          1 > St > Sw
          if( stinit.ge.1.d0-sgr(j) ) then
c            then we are starting out with immobile residual gas
c            set St curve to origin of PDC/MDC (curve 1)
                 nhc_t(j) = 1  
c
c                   initialize trapping parameters for gas 
                    sg_mx(j)   = 1.d0 - stinit 
                    sgt_mx(j)  = 1.d0 - stinit
                    sgt_mn(j)  = 1.d0 - stinit
                    sgt_c(j)   = 1.d0 - stinit
c
            if( stinit-swinit.le.snr ) then
c            then we are starting out with immobile residual gas & NAPL
c            and mobile water  (1,1)
c            set Sw curve to origin of PDC/MDC (curve 1)
                 nhc_w(j) = 1  
c                   initialize trapping parameters for WATER
                  sw_mx(j)   = swinit
                if (swr(j).lt.epsil) then
                  swt_mn(j)  = 0.d0   
                  swt_c(j)   = 0.d0
                  swt_mx(j)  = 0.d0
                else
                  swt_mn(j)  = swr(j)
                  swt_c(j) = swt_mn(j)*(1.d0-swinit)/(1.d0-swt_mn(j))
                   r = 1.d0/(swr(j) - swt_c(j)) - 1.d0/(1.d0 - swt_c(j))
                  swt_mx(j) = swt_c(j) +  (sw_mx(j) - swt_c(j))
     &                       / (1.d0 + r * (sw_mx(j) - swt_c(j))) 
                endif
c
c                   initialize trapping parameters for NAPL
                    sn_mx(j)   = stinit - swinit 
                    snt_mx(j)  = stinit - swinit
                    snt_mn(j)  = stinit - swinit
                    snt_c(j)   = stinit - swinit
            else if( swinit.le.swr(j) ) then
c            then we are starting out with 
c            immobile residual water & gas and mobile NAPL  (1,3)
c            set Sw curve to origin of PIC/MIC (curve 2)
                 nhc_w(j) = 2  
c                   initialize trapping parameters for WATER
                    sw_mx(j)   = swinit 
                    swt_mx(j)  = swinit
                    swt_mn(j)  = swinit
                    swt_c(j)   = swinit
c                   initialize trapping parameters for NAPL
                    sn_mx(j)   = stinit - swinit
                if (snr.lt.epsil) then
                  snt_mn(j)  = 0.d0   
                  snt_c(j)   = 0.d0
                  snt_mx(j)  = 0.d0
                else
                  snt_mn(j)  = snr
                  snt_c(j) = snt_mn(j)*(1.d0-sninit)/(1.d0-snt_mn(j))
                    r = 1.d0/(snr - snt_c(j)) - 1.d0/(1.d0 - snt_c(j))
                  snt_mx(j) = snt_c(j) +  (sn_mx(j) - snt_c(j))
     &                       / (1.d0 + r * (sn_mx(j) - snt_c(j))) 
                endif
            else 
c            then we are starting out with immobile residual gas 
c            and mobile NAPL and water  (1,2)
c            set Sw curve to PDC/MDC (curve 1)
                 nhc_w(j) = 1  
c                   initialize trapping parameters for WATER
                  sw_mx(j)   = swinit
                if (swr(j).lt.epsil) then
                  swt_mn(j)  = 0.d0   
                  swt_c(j)   = 0.d0
                  swt_mx(j)  = 0.d0
                else
                  swt_mn(j)  = swr(j)
c
                  swt_c(j) = swt_mn(j)*(1.d0-swinit)/(1.d0-swt_mn(j))
                   r = 1.d0/(swr(j) - swt_c(j)) - 1.d0/(1.d0 - swt_c(j))
                  swt_mx(j) = swt_c(j) +  (sw_mx(j) - swt_c(j))
     &                       / (1.d0 + r * (sw_mx(j) - swt_c(j))) 
                endif
c
c                   initialize trapping parameters for NAPL
                    sn_mx(j)   = sninit
                    snt_mn(j)  = 0.d0
                    snt_c(j)   = 0.d0
                if (snr.lt.epsil) then
                  snt_mx(j)  = 0.d0
                else
                    r = 1.d0/snr - 1.d0
                    snt_mx(j) = sn_mx(j)/(1.d0 + r*sn_mx(j))
                endif
            endif
c *****
          else if( swinit.le.swr(j) ) then
c *****
c            then we are starting out with immobile residual water
c            set Sw curve to origin of PIC/MIC (curve 2)
                 nhc_w(j) = 2  
c                   initialize trapping parameters for WATER
                    sw_mx(j)   = swinit 
                    swt_mx(j)  = swinit
                    swt_mn(j)  = swinit
                    swt_c(j)   = swinit
c
            if( stinit-swinit.le.snr ) then
c            then we are starting out with residual water & NAPL
c            and mobile gas (3,3)
c            set St curve to origin of PIC/MIC (curve 2)
                 nhc_t(j) = 2  
c                   initialize trapping parameters for gas
                    sg_mx(j)   = 1.d0 - stinit
                if (sgr(j).lt.epsil) then
                  sgt_mn(j)  = 0.d0   
                  sgt_c(j)   = 0.d0
                  sgt_mx(j)  = 0.d0
                else
                  sgt_mn(j)  = sgr(j)
                  sgt_c(j) = sgt_mn(j)*(1.d0-sginit)/(1.d0-sgt_mn(j))
                   r = 1.d0/(sgr(j) - sgt_c(j)) - 1.d0/(1.d0 - sgt_c(j))
                  sgt_mx(j) = sgt_c(j) +  (sg_mx(j) - sgt_c(j))
     &                       / (1.d0 + r * (sg_mx(j) - sgt_c(j))) 
                endif
c                   initialize trapping parameters for NAPL
                    sn_mx(j)   = stinit - swinit 
                    snt_mx(j)  = stinit - swinit
                    snt_mn(j)  = stinit - swinit
                    snt_c(j)   = stinit - swinit
            else 
c            then we are starting out with immobile residual water 
c            and mobile NAPL and gas (2,3)
c            set St curve to PIC/MIC (curve 2)
                 nhc_t(j) = 2  
c                   initialize trapping parameters for gas  
                    sg_mx(j)   = 1.d0 - stinit
                if (sgr(j).lt.epsil) then
                  sgt_mn(j)  = 0.d0   
                  sgt_c(j)   = 0.d0
                  sgt_mx(j)  = 0.d0
                else
                  sgt_mn(j)  = sgr(j)
                  sgt_c(j) = sgt_mn(j)*(1.d0-sginit)/(1.d0-sgt_mn(j))
                   r = 1.d0/(sgr(j) - sgt_c(j)) - 1.d0/(1.d0 - sgt_c(j))
                  sgt_mx(j) = sgt_c(j) +  (sg_mx(j) - sgt_c(j))
     &                       / (1.d0 + r * (sg_mx(j) - sgt_c(j))) 
                endif
c                   initialize trapping parameters for NAPL
                    sn_mx(j)   = sninit
                    snt_mn(j)  = 0.d0
                    snt_c(j)   = 0.d0
                if (snr.lt.epsil) then
                  snt_mx(j)  = 0.d0
                else
                    r = 1.d0/snr - 1.d0
                    snt_mx(j) = sn_mx(j)/(1.d0 + r*sn_mx(j))
                endif
            endif
c *******
          else 
c *******
c            then we are starting out with mobile water and gas (2,2)
c            set Sw and St curves to MDC (curve 1)
                 nhc_t(j) = 1  
                 nhc_w(j) = 1  
c
c                   initialize trapping parameters for water
                  sw_mx(j)   = swinit
                if (swr(j).lt.epsil) then
                  swt_mn(j)  = 0.d0   
                  swt_c(j)   = 0.d0
                  swt_mx(j)  = 0.d0
                else
                  swt_mn(j)  = swr(j)
                  swt_c(j) = swt_mn(j)*(1.d0-swinit)/(1.d0-swt_mn(j))
                   r = 1.d0/(swr(j) - swt_c(j)) - 1.d0/(1.d0 - swt_c(j))
                  swt_mx(j) = swt_c(j) +  (sw_mx(j) - swt_c(j))
     &                       / (1.d0 + r * (sw_mx(j) - swt_c(j))) 
                endif
c
c                   initialize trapping parameters for gas  
                    sg_mx(j)   = 1.d0 - stinit
                if (sgr(j).lt.epsil) then
                  sgt_mn(j)  = 0.d0   
                  sgt_c(j)   = 0.d0
                  sgt_mx(j)  = 0.d0
                else
                    sgt_mn(j)  = sgr(j)
                  sgt_c(j) = sgt_mn(j)*(1.d0-sginit)/(1.d0-sgt_mn(j))
                   r = 1.d0/(sgr(j) - sgt_c(j)) - 1.d0/(1.d0 - sgt_c(j))
                  sgt_mx(j) = sgt_c(j) +  (sg_mx(j) - sgt_c(j))
     &                       / (1.d0 + r * (sg_mx(j) - sgt_c(j))) 
                endif
c
c            check to see if NAPL is mobile
            if( (stinit-swinit).le.snr ) then
c            NAPL is immobile, distribute the trapped phase to 
c            water and gas based on a % of current saturations
                    sn_mx(j)   = stinit - swinit 
                    snt_mx(j)  = stinit - swinit
                    snt_mn(j)  = stinit - swinit
                    snt_c(j)   = stinit - swinit
            else
c            NAPL is mobile (assume nothing trapped)
                    sn_mx(j)   = sninit
                    snt_mn(j)  = 0.d0
                    snt_c(j)   = 0.d0
                if (snr.lt.epsil) then
                  snt_mx(j)  = 0.d0
                else
                    r = 1.d0/snr - 1.d0
                    snt_mx(j) = sn_mx(j)/(1.d0 + r*sn_mx(j))
                endif
            endif
          endif
        endif
c
             sr_t(j,nhc_t(j)) = swt_c(j) + snt_c(j)
             sr_w(j,nhc_w(j)) = swt_c(j)
             ss_t(j,nhc_t(j)) = 1.d0 - sgt_c(j)
             if(nhc_t(j).ne.1) ss_t(j,1) = ss_t(j,nhc_t(j))
             ss_w(j,nhc_w(j)) = 1.d0 - sgt_c(j) - snt_c(j)
             if(nhc_w(j).ne.1) ss_w(j,1) = ss_w(j,nhc_w(j))
c
            if ( nhc_t(j).eq.1)  then
               sb_t(j,1) = 1.d0 - sgt_mn(j)
               sb_t(j,2) = stinit
            else
               sb_t(j,2) = swt_mn(j) + snt_mn(j)
               sb_t(j,3) = stinit
            endif
            if ( nhc_w(j).eq.1)  then
               sb_w(j,1) = sw_mx(j)
               sb_w(j,2) = swinit   
            else
               sb_w(j,2) = swt_mn(j)
               sb_w(j,3) = swinit   
            endif
c
               a_w(j,1) = asd(j)
               a_w(j,2) = asi(j)
               a_t(j,1) = asd(j)
               a_t(j,2) = asi(j)
c
                                  return
                                  end
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        subroutine trap_up
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c trapping vectors
c maxumum saturation available for entrapment
c      sw_mx(j)   > swr, < 1
c      sg_mx(j)  
c      sn_mx(j)
c current values
c      swt_c(j)   >= swt_mn(j), <= swt_mx(j)
c      sgt_c(j)    >= sgt_mn(j), <= sgt_mx(j)
c      snt_c(j)  >= snt_mn(j), <= snt_mx(j)
c maxumum values
c      swt_mx(j)   >= swt_mn(j),  <= swr
c      sgt_mx(j)    >= sgt_mn(j),  <= sgr
c      snt_mx(j)  >= snt_mn(j),  <= snr
c minumum values
c      swt_mn(j)   >= 0 , <= swr
c      sgt_mn(j)   >= 0 , <= sgr
c      snt_mn(j) >= 0 , <= snr
c
c update the hysteresis trapping vectors for next time step
c
        include 'include.f'
c
       do 103 ik = 1, nn
c
c Set saturation values after this time step:
c
        if(sw11(ik,1).lt.0.d0) then
             sw = 0.d0
        else if(sw11(ik,1).gt.1.d0) then
             sw = 1.d0
        else
             sw = sw11(ik,1)
        endif
c
           if(st11(ik,1).lt.0.d0) then
                st = 0.d0
           else if(st11(ik,1).gt.1.d0) then
                st = 1.d0
           else
                st = st11(ik,1)
           endif
c
        if(st11(ik,1)-sw11(ik,1).lt.0.d0) then
             so = 0.d0
        else if(st11(ik,1)-sw11(ik,1).gt.1.d0) then
             so = 1.d0
        else
             so = st11(ik,1) - sw11(ik,1)
        endif
c
c----------------------------------------------------
c UPDATE WATER TRAPPING PARAMETERS:
c----------------------------------------------------
c sw_mx(ik) 
        if( swr(ik) .lt. epsil ) then
                  sw_mx(ik) =  0.d0
                  swt_mx(ik) =  0.d0
                  swt_mn(ik) =  0.d0
                  swt_c(ik)  =  0.d0
            go to 199
        else if( sw .gt. sw_mx(ik) ) then
c            set a new sw_mx
             sw_mx(ik) = sw + epsil
        else if( sw .lt. swt_mx(ik) + 1.d-8  
     &      .or. sw .lt. swt_mn(ik) + 1.d-8)  then
c           water is immobile, HIT TOP 
                  swt_mx(ik) =  sw
                  swt_mn(ik) =  sw
                  swt_c(ik)  =  sw
                  sw_mx(ik)  =  sw
            go to 199
        endif
c
c compute new swt_mx
c
        if ( sw_mx(ik).gt.1.d0-epsil ) then
                  swt_mx(ik) =  swr(ik)
                  swt_mn(ik) =  0.d0
                  sw_mx(ik)  =  1.d0
        else
c
          st_min = swt_mn(ik)*(1.d0-sw)/(1.d0-swt_mn(ik))
c
          r = 1.d0/(swr(ik) - st_min) - 1.d0/(1.d0 - st_min)
c
          swt_mx(ik) = min( 0.5d0*sw_mx(ik) ,
     &                 st_min +  (sw_mx(ik) - st_min)
     &             / (1.d0 + r * (sw_mx(ik) - st_min)) )
     &                 
        endif
c
c compute new swt_c
c
        if( sw .lt. swt_mx(ik) + 1.d-8  )  then
c           water is immobile, HIT TOP 
                  swt_mx(ik) =  sw
                  swt_mn(ik) =  sw
                  swt_c(ik)  =  sw
                  sw_mx(ik)  =  sw
        else
c
            st_min = swt_mn(ik)*(1.d0-sw)/(1.d0-swt_mn(ik))
c
         swt_c(ik) = st_min + (swt_mx(ik)-st_min)
     &                      *( (sw_mx(ik) - sw)
     &                      /  (sw_mx(ik) - swt_mx(ik)) )**e_r
        endif
c
  199  continue
c
c----------------------------------------------------
c UPDATE GAS TRAPPING PARAMETERS:
c----------------------------------------------------
c sg_mx(ik) 
        if( sgr(ik) .lt. epsil ) then
                  sg_mx(ik) =  0.d0
                  sgt_mx(ik) =  0.d0
                  sgt_mn(ik) =  0.d0
                  sgt_c(ik)  =  0.d0
            go to 299
        else if( sg_mx(ik).lt. 1.d0 - st ) then
c set a new sg_mx
                    sg_mx(ik) = 1.d0-st + epsil
        else if( 1.d0 - st .lt. sgt_mx(ik) + 1.d-8  
     &      .or. 1.d0 - st .lt. sgt_mn(ik) + 1.d-8)  then
c           gas is immobile
                  sgt_mx(ik) =  1.d0 - st
                  sgt_mn(ik) =  1.d0 - st
                  sgt_c(ik)  =  1.d0 - st
                  sg_mx(ik)  =  1.d0 - st
            go to 299
        endif
c
c compute new sgt_mx
c
        if ( sg_mx(ik).gt.1.d0-epsil ) then
                  sgt_mx(ik) =  sgr(ik)
                  sgt_mn(ik) =  0.d0
                  sg_mx(ik)  =  1.d0
        else
c
          st_min = sgt_mn(ik)*st/(1.d0-sgt_mn(ik))
c
          r = 1.d0/(sgr(ik) - st_min) - 1.d0/(1.d0 - st_min)
c
          sgt_mx(ik) = min( 0.5d0*sg_mx(ik) ,
     &                 st_min +  (sg_mx(ik) - st_min)
     &             / (1.d0 + r * (sg_mx(ik) - st_min)) )
        endif
c
c compute new sgt_c
c
        if( 1.d0 - st .lt. sgt_mx(ik) + 1.d-8  )  then
c           gas is immobile
                  sgt_mx(ik) =  1.d0 - st
                  sgt_mn(ik) =  1.d0 - st
                  sgt_c(ik)  =  1.d0 - st
                  sg_mx(ik)  =  1.d0 - st
        else
c
          st_min = sgt_mn(ik)*st/(1.d0-sgt_mn(ik))
c
         sgt_c(ik) = st_min + (sgt_mx(ik)-st_min)
     &                      *( (sg_mx(ik) - 1.d0 + st)
     &                      /  (sg_mx(ik) - sgt_mx(ik)) )**e_r
        endif
c
  299  continue
c
c----------------------------------------------------
c UPDATE NAPL PHASE TRAPPING PARAMETERS:
c----------------------------------------------------
c
        if ( 1.d0-st+sw .gt. epsil ) then
          snr = (snnr(ik)*(sw) + snwr(ik)*(1.d0-st) )/(1.d0-st+sw)
        else
          snr = (snnr(ik) + snwr(ik))/2.d0
        endif 
        if( snr .lt. epsil ) then
                  sn_mx(ik) =  0.d0
                  snt_mx(ik) =  0.d0
                  snt_mn(ik) =  0.d0
                  snt_c(ik)  =  0.d0
            go to 399
        endif
        if( snt_mx(ik).gt. snr ) then
            snt_mx(ik) = snr
        endif
        if( snt_mn(ik).gt. snr ) then
            snt_mn(ik) = snr
        endif
c
        if( so .gt. sn_mx(ik) ) then
            sn_mx(ik) = so + epsil
        else if( so .lt. snt_mx(ik) + 1.d-8  
     &      .or. so .lt. snt_mn(ik) + 1.d-8)  then
c           NAPL as a nonwetting phase is immobile
                  snt_mx(ik) =  so
                  snt_mn(ik) =  so
                  snt_c(ik)  =  so
                  sn_mx(ik)  =  so
            go to 399
        endif
c
c compute new snt_mx
c
        if ( sn_mx(ik).gt.1.d0-epsil ) then
                  snt_mx(ik) =  snr
                  snt_mn(ik) =  0.d0
                  sn_mx(ik)  =  1.d0
        else
          st_min = snt_mn(ik)*(1.d0-so)/(1.d0-snt_mn(ik))
c
          r = 1.d0/(snr - st_min) - 1.d0/(1.d0 - st_min)
c
          snt_mx(ik) = min( 0.5d0*sn_mx(ik) ,
     &                  st_min +  (sn_mx(ik) - st_min)
     &              / (1.d0 + r * (sn_mx(ik) - st_min)) )
        endif
c
c compute new snt_c
c
        if( so .lt. snt_mx(ik) + 1.d-8  )  then
c           NAPL as a nonwetting phase is immobile
                  snt_mx(ik) =  so
                  snt_mn(ik) =  so
                  snt_c(ik)  =  so
                  sn_mx(ik)  =  so
        else
c
          st_min = snt_mn(ik)*(1.d0-so)/(1.d0-snt_mn(ik))
c
         snt_c(ik) = st_min + (snt_mx(ik)-st_min)
     &                       *( (sn_mx(ik) - so)
     &                       /  (sn_mx(ik) - snt_mx(ik)) )**e_r
        endif
c
  399  continue
c*********************************************************************
  103  continue
                                 return
                                 end
c************************************************************
        subroutine sw_pc(icut)
c************************************************************
c************************************************************
c update the hysteresis vectors for the Sw(Pcnw) functional
c for the next time step
c
        include 'include.f'
c
                      do 103 ik = 1, nn
c
          sw = sw11(ik,1)
             if(sw.lt.0.d0)  sw = 0.d0
             if(sw.gt.1.d0)  sw = 1.d0
c
c HYSTERESIS
c drainage/imbibition/reversal ...
c
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                   if (nhc_w(ik).eq.1 )        then
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
             se = (sw - sr_w(ik,1)) / (ss_w(ik,1) - sr_w(ik,1))
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c                     PDC / MDC
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c
c          4 possibilities: 1. hit top (immobile water)
c                           2. hit bottom (immobile NAPL+gas)
c                           3. reversal to SIC_1
c                           4. continue on this curve
c
          if( sw.le.(swt_c(ik)+epsil) .or. se.lt.epsil )  then
c case 1
c          have hit the top (immobile water)
c          shift to curve 2; 
c          NEW PIC/MIC DEFINED
c
                   call w2_new (ik,sw)
c          
          else if( sw.gt. 1.d0 - (sgt_c(ik)+snt_c(ik)+epsil) ) then
c case 2
c              NEW PDC/MDC DEFINED
c
                   call w1_new (ik,sw)
c
          else if( se .gt. se_rl .and. se .lt. (1.d0-se_sl) ) then
c not on a linear part of the curve so allow update/reversal
c
               if( (sw - sb_w(ik,2)) .ge. factd .and.  
     &               sb_w(ik,1) - sb_w(ik,2) .gt. sr_min .and.  
     &               sw - sr_w(ik,1) .gt. sr_min ) then
c case 3
c               REVERSAL to curve 2
c               NEW SIC_1   DEFINED
                     icut = 1
c
                   call w21_new (ik,sw)
c--
               else
c case 4
c          not enough to change things, update sr_w, ss_w
c           PDC/MDC UPDATE
c
                   call w1_up (ik,sw,se)
c
               endif
          endif
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
               else if( nhc_w(ik).eq.2)  then
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
             se = (sw - sr_w(ik,2)) / (ss_w(ik,2) - sr_w(ik,2))
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c                   PIC / MIC / SIC_1
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c
c  5 possibilities: 1. hit bottom (immobile NAPL+gas)
c                   2. hit top (immobile water)
c                   3. reverse through branch point back to curve 1
c                   4. reversal to curve 3
c                   5. continue along the curve     
c
          if( sw.gt. 1.d0- sgt_c(ik)-snt_c(ik)-epsil  .or.
     &        se.gt. 1.d0-epsil )  then
c case 1
c          shift to curve 1; lose all previous history
c          
c           NEW PDC/MDC DEFINED
c
            call w1_new (ik,sw)
c
          else if( sw.le.swt_c(ik)+epsil )   then
c case 2
c                 have hit the top (immobile water)
c                 NEW PIC/MIC DEFINED
c          
                  call w2_new (ik,sw)
c
          else if( sw.lt.sb_w(ik,2) )          then
c case 3
c             have reversed back onto curve 1   
c                 REVERT back to  PDC/MDC
c          
                  call w1_rev (ik,sw)
c
          else if( se .gt. se_rl .and. se .lt. (1.d0-se_sl) ) then
c not on a linear part of the curve so allow update/reversal
               if( sw - sb_w(ik,3) .le. -facti .and.
     &               sb_w(ik,3) - sb_w(ik,2) .gt. sr_min .and. 
     &               ss_w(ik,2) - sw .gt. sr_min ) then
c case 4
c
c         REVERSAL
                     icut = 1
c
c                NEW SDC_1 or SDC_2 CURVE 
c
                 call w3_new (ik,sw)
c
               else
c case 5
c
c           UPDATE PIC / MIC / SIC_1  
c
                 call w2_up (ik,sw,se)
c
               endif
          endif
c
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
               else if( nhc_w(ik).eq.3)  then
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
             se = (sw - sr_w(ik,3)) / (ss_w(ik,3) - sr_w(ik,3))
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c                     SDC_1 / SDC_2 
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c         on scanning drainage path
c
c          6 possibilities: 1. close loop to curve 1 
c                           2. hit top 
c                           3. hit bottom (revert to curve 1)
c                           4. reverse back onto curve 2
c                           5. reversal to curve 4
c                           6. continue along this curve
c
         if(sw.le.swt_c(ik)+epsil)  then
c case 2 
c              NEW PIC/MIC
c
               call w2_new (ik,sw)
c
         else if( sw.le.(sb_w(ik,2)+epsil) )          then
c case 1
c              Rrevert back to PDC/MDC
c
               call w1_rev (ik,sw)
c
         else if( sw.ge.sb_w(ik,3) )          then
c case 3 or 4
c
           if( sw.ge.1.d0-sgt_c(ik)- snt_c(ik)-epsil )  then
c case 3
c                    NEW PDC/MDC
c
                     call w1_new (ik,sw)
c
           else
c case 4
c
                  call w2_rev (ik,sw)
c
           endif 
c
          else if( se .gt. se_rl .and. se .lt. (1.d0-se_sl) ) then
c not on a linear part of the curve so allow update/reversal
            if( (sw - sb_w(ik,4))  .ge. factd .and.  
     &               sb_w(ik,3) - sb_w(ik,4) .gt. sr_min .and.
     &               sw - sr_w(ik,3) .gt. sr_min ) then
c case 5
c           REVERSAL to curve 4
c           NEW SIC_2
                     icut = 1
c
              call w4_new (ik,sw)
c
            else  
c case 6
c
               call w3_up (ik,sw,se)
c
            endif 
       endif 
c
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
               else if( nhc_w(ik).eq.4)  then
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c                    SIC_2 
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c         on scanning imbibition path
c
c 6 possibilities: 1. close loop back onto curve 2
c                  2. hit bottom
c                  3. reverse through branch point back to curve 1
c                  4. reverse through branch point back to curve 3
c                  5. reverse through branch point back to top (curve 2)
c                  6. stay on curve 4
c
        if( sw.ge.sb_w(ik,3) )          then
c case 1 or 2
           if( sw.ge.
     &        (1.d0-sgt_c(ik)- snt_c(ik)-epsil) )  then
c case 2   (immobile total nonwetting phase)
c
c                 NEW PDC/MDC DEFINED
c
                  call w1_new (ik,sw)
c
           else
c case 1, reverse back onto curve 2
c
c               REVERT TO PIC / MIC / SIC_1
                  call w2_rev (ik,sw)
c
           endif
        else if( sw.le.swt_c(ik)+epsil )          then
c case 5, 
c          NEW PIC/MIC DEFINED
c
            call w2_new (ik,sw)
c          
        else if( sw.le.(sb_w(ik,2)+epsil) )          then
c case 3, 
c                 REVERT back to  PDC/MDC
c          
                  call w1_rev (ik,sw)
c
c
        else if( sw.le.sb_w(ik,4) )   then
c case 4
c
c           REVERT TO SDC_1 / SDC_2 
c
                call w3_rev (ik,sw)
c
        else
c case 6
c
             if( sw.ge.swt(ik,1))  then
c             imbibition 
                call w4_up (ik,sw)
             else 
c             drainage  
                call w4_up_r (ik,sw)
             endif
c
        endif 
c
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                          endif
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c
  103   continue
                                          return
                                          end
c
c----------------------------------------------------------
         subroutine w1_new (ik,sw)
c----------------------------------------------------------
c
c           NEW PDC/MDC DEFINED
c
        include 'include.f'
c
              nhc_w (ik)   = 1
                    ss_w(ik,1) = sw
                    sb_w(ik,1) = sw
                    sb_w(ik,2) = sw
                    sr_w(ik,1) = swt_c(ik)
                    a_w(ik,1)  = asd(ik)
c
c reset NAPL and gas trapping parameters:
           if(st11(ik,1).lt.0.d0) then
                st = 0.d0
           else if(st11(ik,1).gt.1.d0) then
                st = 1.d0
           else
                st = st11(ik,1)
           endif
c
        if(st11(ik,1)-sw11(ik,1).lt.0.d0) then
             so = 0.d0
        else if(st11(ik,1)-sw11(ik,1).gt.1.d0) then
             so = 1.d0
        else
             so = st11(ik,1) - sw11(ik,1)
        endif
                   if (sgr(ik).lt.epsil)  then
                    sg_mx(ik)   = 0.d0
                    sgt_mx(ik)  = 0.d0
                    sgt_mn(ik)  = 0.d0 
                    sgt_c(ik)   = 0.d0 
                   else
                    sg_mx(ik)   = 1.d0 - st
                    sgt_mx(ik)  = 1.d0 - st
                    sgt_mn(ik)  = 1.d0 - st
                    sgt_c(ik)   = 1.d0 - st
                   endif
                   if (snnr(ik)+snwr(ik).lt.epsil)  then
                    sn_mx(ik)   = 0.d0            
                    snt_mx(ik)  = 0.d0            
                    snt_mn(ik)  = 0.d0            
                    snt_c(ik)   = 0.d0            
                   else
                    sn_mx(ik)   = so              
                    snt_mx(ik)  = so              
                    snt_mn(ik)  = so              
                    snt_c(ik)   = so              
                   endif
c
                              return
                              end    
c----------------------------------------------------------
         subroutine w1_up (ik,sw,se)
c----------------------------------------------------------
c
c          PDC/MDC UPDATE
c  se =     the current se
c
        include 'include.f'
c
            if( sw .lt. sb_w(ik,2) ) sb_w(ik,2) = sw
c
c           update 'sr_w' for this PDC (trapped Sw)
c
               sr_w1      =  swt_c(ik)
c
c           a change in sr_w requires a change in ss_w
c           so that the Pc doesn't change
c
               ss_w1      = (sw - sr_w1     ) / se  + sr_w1     
c++ curve 1
                   if  (ss_w1 - sr_w1 .ge. sp_min ) then
c                   the curve is not too tight so update
                      ss_w(ik,1) = ss_w1
                      sr_w(ik,1) = sr_w1
                   endif
c++
                              return
                              end    
c----------------------------------------------------------
         subroutine w1_rev (ik,sw)
c----------------------------------------------------------
c
c    revert back to a PDC/MDC from another curve
c
        include 'include.f'
c
         DOUBLE precision nsw, msw
         nsw = shape(ik)
         msw = 1.d0-1.d0/shape(ik)
c
c             calc. the head at this point before change
                 call lev_p_sw ( pcnw1(ik), pc )
                 hd = pc/denw
c           update
             nhc_w(ik) = 1
             a_w(ik,1)  = asd(ik)
c
c            force the new PDC to pass through this hd 
             se = (1.d0+(asd(ik)*hd)**nsw)**(-msw)
c
             sr_w(ik,1) =  swt_c(ik) 
c
             ss_w(ik,1) = (sw - sr_w(ik,1)) / se  + sr_w(ik,1)
             sb_w(ik,2) = sw
c
                              return
                              end    
c-------------------------------------------------------------
         subroutine w2_new  (ik,sw)
c-------------------------------------------------------------
c
c           NEW PIC/MIC DEFINED
c
        include 'include.f'
c          
              nhc_w(ik)   = 2
              sr_w(ik,2) = sw
              sb_w(ik,2) = sw
              sb_w(ik,3) = sw
              a_w(ik,2) = asi(ik)
              ss_w(ik,2) = 1.d0 - sgt_c(ik) -  snt_c(ik)
c
c reset water trapping parameters:
                 if(swr(ik).lt.epsil)  then
                    sw_mx(ik)   = 0.d0
                    swt_mx(ik)  = 0.d0
                    swt_mn(ik)  = 0.d0
                    swt_c(ik)   = 0.d0
                 else
                    sw_mx(ik)   = sw
                    swt_mx(ik)  = sw
                    swt_mn(ik)  = sw
                    swt_c(ik)   = sw
                 endif
                              return
                              end
c-------------------------------------------------------------
         subroutine w2_up (ik,sw,se)
c-------------------------------------------------------------
c
c              Curve 2 update
c              includes PIC / MIC / SIC_1
c  se =      the se at the current point
c
        include 'include.f'
        DOUBLE precision nsw, msw
         nsw = shape(ik)
         msw = 1.d0-1.d0/shape(ik)
c
c           update the farthest progression
            if( sw .gt. sb_w(ik,3) ) sb_w(ik,3) = sw
c
c          update 'ss_w' for this primary imbibition curve
           ss_w1 = 1.d0 - sgt_c(ik) -  snt_c(ik)
c
c if this is an SIC, then must update aw:
        if(dabs(asd(ik)-asi(ik)).gt.0.0001d0) then
        if(dabs(asi(ik)-a_w(ik,2))/dabs(asd(ik)-asi(ik)).gt.0.01d0) then
c update the SIC
c             calc. the head at this point before change
                 call lev_p_sw ( pcnw1(ik), pc )
                 hd = pc/denw
c
           if(sw.le.sb_w(ik,2) ) sw = sb_w(ik,2)  + epsil
           a_w1 = asd(ik)  + (asi(ik)  - asd(ik))
     &              * ((sw - sb_w(ik,2)) / (ss_w1 - sb_w(ik,2)))**b_a
c
c iii          calculate the Se of the new curve at the branch point
           se   = (1.d0+(a_w1*hd)**nsw)**(-msw)
c
        else  
           a_w1 = asi(ik) 
        endif 
        else  
           a_w1 = asi(ik) 
        endif 
c
           sr_w1 = (sw - se*ss_w1 ) / (1.d0 - se)
c++ curve 2
                   if  (ss_w1 - sr_w1 .ge. sp_min ) then
c                   the curve is not too tight so update
                      a_w(ik,2)  = a_w1
                      ss_w(ik,2) = ss_w1      
                      sr_w(ik,2) = sr_w1
                   endif
c++
                              return
                              end    
c-------------------------------------------------------------
         subroutine w2_rev (ik,sw)
c-------------------------------------------------------------
c
c              revert back to curve  2 
c              includes PIC / MIC / SIC_1
c
        include 'include.f'
c
        DOUBLE precision nsw, msw
         nsw = shape(ik)
         msw = 1.d0-1.d0/shape(ik)
c          2 possibilities: 1. origin of curve 2 off curve 1
c                           2. origin of curve 2 at immobile water
c
c i            calculate the head at the current point
                 call lev_p_sw ( pcnw1(ik), pc )
                 hd = pc/denw
c
             ss_w(ik,2) = 1.d0 - sgt_c(ik) -  snt_c(ik)
c
        if(dabs(asd(ik)-asi(ik)).gt.0.0001d0) then
        if(dabs(asi(ik)-a_w(ik,2))/dabs(asd(ik)-asi(ik)).gt.0.01d0) then
c update the SIC
           a_w(ik,2) = asd(ik)  + (asi(ik)  - asd(ik))
     &           * ((sw - sb_w(ik,2)) / (ss_w(ik,2) - sb_w(ik,2)))**b_a
c
        endif
        endif
c iii          calculate the Se at the current point
c
           se   = (1.d0+(a_w(ik,2)*hd)**nsw)**(-msw)
c
           sr_w(ik,2) = (sw - se*ss_w(ik,2)) / (1.d0 - se)
c
              nhc_w(ik) = 2
              sb_w(ik,3) = sw
c
                              return
                              end    
c-------------------------------------------------------------
         subroutine w21_new (ik,sw)
c-------------------------------------------------------------
c
c           set up a NEW SIC_1 CURVE
c
        include 'include.f'
c
         DOUBLE precision nsw, msw
         nsw = shape(ik)
         msw = 1.d0-1.d0/shape(ik)
c                  new branch point
                     sb_w(ik,2) = sw
                     sb_w(ik,3) = sw
c
            ss_w1 = 1.d0 - sgt_c(ik) -  snt_c(ik)
c
c a.) compute se for continuity
c
c i            calculate the head at the branch point
                 call lev_p_sw ( pcnw1(ik), pc )
                 hd = pc/denw
c
c ii               calculate the variable imbibition a_w
c                   
                    a_w1 = asd(ik) + (asi(ik)  - asd(ik))
     &                   * ( epsil
     &                   / (ss_w1 - sb_w(ik,2)))**b_a
c
c iii          calculate the Se of the new curve at the branch point
                    se1   = (1.d0+(a_w1*hd)**nsw)**(-msw)
c
c
                   sr_w1      = (sb_w(ik,2) - se1*ss_w1     ) 
     &                         / (1.d0 - se1)
c
c++ start curve 2
                   nhc_w(ik) = 2
                   if  (ss_w1 - sr_w1 .ge. sp_min ) then
c                   the curve is not too tight so update
                         a_w(ik,2)  = a_w1      
                         ss_w(ik,2) = ss_w1      
                         sr_w(ik,2) = sr_w1
                           call pc_nw (sw,pc,d_pc,ik)
                           hd0 = pc/denw
                      if (hd0 .gt. hd +epsil )   then
c                         keep the old curve parameters
                          a_w(ik,2)  = asd(ik)
                          ss_w(ik,2) = ss_w(ik,1) 
                          sr_w(ik,2) = sr_w(ik,1) 
                      endif 
                   else 
c                     curve too tight keep the old curve parameters
                      a_w(ik,2)  = asd(ik)
                      ss_w(ik,2) = ss_w(ik,1) 
                      sr_w(ik,2) = sr_w(ik,1) 
                   endif
c++
c
                              return
                              end    
c-------------------------------------------------------------
         subroutine w3_new (ik,sw)
c-------------------------------------------------------------
c
c           start a new SDC_1 of SDC_2 curve
c
        include 'include.f'
c
        DOUBLE precision nsw, msw
         nsw = shape(ik)
         msw = 1.d0-1.d0/shape(ik)
c                  new branch point
                     sb_w(ik,3) = sw
                     sb_w(ik,4) = sw
c
c              the hd at the current branch point
                 call lev_p_sw ( pcnw1(ik), pc )
                 hd1 = pc/denw
c
c              construct a scanning drainage branch
c              2 possibilities  1: curve 2 originated at Sw > swr
c                               2: curve 2 originated at Sw = swr
c
             if( sb_w(ik,2).gt.swt_mx(ik)+1.d-6 )  then
c SDC_2
c              curve 2 is a MWC, (originated off curve 1), the curve
c              must pass through both sb_w(ik,3) and sb_w(ik,2)
c
c              calculate new a_w:
              a_w1      = a_w(ik,2) - (a_w(ik,2) - asd(ik) )
     &                   * ( epsil / (sb_w(ik,3) - sb_w(ik,2)) )**b_a
c
c              the Se at the current branch point
                 se1  = (1.d0+(a_w1 * hd1)**nsw)**(-msw)
c
c              the Se at the previous branch point (off curve 1)
                 nhc_w(ik) = 1
                 call pc_nw (sb_w(ik,2),pc,d_pc,ik)
                 hd0 = pc/denw
c
                 se0   = (1.d0+(a_w1 * hd0)**nsw)**(-msw)
c
                 sr_w1      = (se0*sb_w(ik,3)
     &                              - se1*sb_w(ik,2))
     &                              / (se0 - se1)
                 ss_w1      = (sb_w(ik,3)
     &                              - sr_w1     )/se1
     &                              + sr_w1     
             else
c SDC_1
c              curve 2 is a PWC (originated at Sw < swr, immobile water)
c              curve 3 must pass through sb_w(ik,3) and
c              terminate at swr >= sr_w(ik,3) > sb_w(ik,2)
c
c              calculate new a_w:
               a_w1   = a_w(ik,2) - (a_w(ik,2) - asd(ik) )
     &                * ( epsil / (sb_w(ik,3) - swt_c(ik) ))**b_a
c
                 se1   = (1.d0+(a_w1     *hd1)**nsw)**(-msw)
c
c
                 sr_w1      =  swt_c(ik)
c
                 ss_w1      = (sb_w(ik,3) - sr_w1     ) 
     &                        / se1  + sr_w1     
             endif
c++
               nhc_w(ik) = 3
                 if  (ss_w1 - sr_w1 .ge. sp_min ) then
c                   the curve is not too tight so update
                           a_w(ik,3) = a_w1 
                           ss_w(ik,3) = ss_w1 
                           sr_w(ik,3) = sr_w1 
                           call pc_nw (sw,pc,d_pc,ik)
                           hd0 = pc/denw
                      if (hd0 .lt. hd1-epsil )   then
                           a_w(ik,3) = a_w(ik,2)
                           ss_w(ik,3) = ss_w(ik,2)
                           sr_w(ik,3) = sr_w(ik,2)
                      endif
                 else
                    a_w(ik,3) = a_w(ik,2)
                    ss_w(ik,3) = ss_w(ik,2)
                    sr_w(ik,3) = sr_w(ik,2)
                 endif
c++
                              return
                              end    
c----------------------------------------------------------
         subroutine w3_up (ik,sw,se)
c----------------------------------------------------------
c
c            UPDATE SDC_1 or SDC_2
c
        include 'include.f'
        DOUBLE precision nsw, msw
         nsw = shape(ik)
         msw = 1.d0-1.d0/shape(ik)
c   se = current se
c
c          2 possibilities: 1. origin of curve 2 off curve 1
c                           2. origin of curve 2 at immobile water
c
c           update the farthest progression
            if( sw .lt. sb_w(ik,4) ) sb_w(ik,4) = sw
c
c             calc. the head at this point before change
                 call lev_p_sw ( pcnw1(ik), pc )
                 hd1 = pc/denw
c
          if( sb_w(ik,2).gt.swt_mx(ik)+1.d-6 )  then
c 1. origin of curve 2 off curve 1
c SDC_2
c              calculate new a_w:
               if(sw.ge.sb_w(ik,3)) sw = sb_w(ik,3)-epsil
               a_w1      = a_w(ik,2) - (a_w(ik,2) - asd(ik) )
     &                     * ( (sb_w(ik,3) - sw )
     &                     / (sb_w(ik,3) - sb_w(ik,2)) )**b_a
               se1  = (1.d0+(a_w1     *hd1)**nsw)**(-msw)
c
c              the Se at branch point 2
                 nhc_w(ik) = 1
                     call pc_nw (sb_w(ik,2),pc,d_pc,ik)
                     hd0 = pc/denw
                 nhc_w(ik) = 3
                 se0   = (1.d0+(a_w1     *hd0)**nsw)**(-msw)
c
                 sr_w1      = (se0*sw - se1*sb_w(ik,2))
     &                              / (se0 - se1)
                 ss_w1      = (sw - sr_w1     )/se1 + sr_w1
c
          else
c SDC_1
c           curve 3 terminates at top (immobile water)
c           given a new se and sr_w defines a change in ss_w
c           so that the Pc doesn't change
c
c           update 'sr_w' for this primary drainage curve
                 sr_w1      =  swt_c(ik)
c
              if(sw.ge.sb_w(ik,3)) sw = sb_w(ik,3)-epsil
c              calculate new a_w:
               a_w1      = a_w(ik,2) - (a_w(ik,2) - asd(ik) )
     &                     * ( (sb_w(ik,3) - sw )
     &                     / (sb_w(ik,3) - swt_c(ik) ))**b_a
c
               se  = (1.d0+(a_w1 * hd1)**nsw)**(-msw)
c
c           given a new se and sr_w defines a change in ss_w
c           so that the Pc doesn't change
c
               ss_w1  = (sw - sr_w1 ) / se  + sr_w1     
c
          endif
c++
                 if  (ss_w1 - sr_w1 .ge. sp_min ) then
c                   the curve is not too tight so update
                    a_w(ik,3) =  a_w1 
                   ss_w(ik,3) = ss_w1 
                   sr_w(ik,3) = sr_w1 
                 endif
c++
                                    return
                                    end
c----------------------------------------------------------
         subroutine w3_rev (ik,sw)
c----------------------------------------------------------
c
c           REVERT back to an SDC_1 or SDC_2
c
        include 'include.f'
c
         DOUBLE precision nsw, msw
         nsw = shape(ik)
         msw = 1.d0-1.d0/shape(ik)
c          2 possibilities: 1. origin of curve 2 off curve 1
c                           2. origin of curve 2 at immobile water
c
c
c           the head at the current point
                 call lev_p_sw ( pcnw1(ik), pc )
                 hd1 = pc/denw
c
          if( sb_w(ik,2).gt.swt_mx(ik)+1.d-6 )  then
c 1. origin of curve 2 off curve 1
c SDC_2
c              calculate new a_w:
               if(sw.ge.sb_w(ik,3)) sw = sb_w(ik,3)-epsil
               a_w1      = a_w(ik,2) - (a_w(ik,2) - asd(ik) )
     &                     * ( (sb_w(ik,3) - sw )
     &                     / (sb_w(ik,3) - sb_w(ik,2)) )**b_a
c
               se1  = (1.d0+(a_w1 *hd1)**nsw)**(-msw)
c
c              the Se at branch point 2
                 nhc_w(ik) = 1
                     call pc_nw (sb_w(ik,2),pc,d_pc,ik)
                     hd0 = pc/denw
                 se0   = (1.d0+(a_w1*hd0)**nsw)**(-msw)
c
c
                 sr_w1      = (se0*sw - se1*sb_w(ik,2))
     &                              / (se0 - se1)
                 ss_w1      = (sw - sr_w1     )/se1 + sr_w1     
c
          else
c SDC_1
c           curve 3 terminates at top (immobile water)
c
c           update 'sr_w' for this primary drainage curve
c
                 sr_w1      =  swt_c(ik)
c
               if(sw.ge.sb_w(ik,3)) sw = sb_w(ik,3)-epsil
c              calculate new a_w:
               a_w1      = a_w(ik,2) - (a_w(ik,2) - asd(ik) )
     &                     * ( (sb_w(ik,3) - sw )
     &                     / (sb_w(ik,3) - swt_c(ik) ))**b_a
c
               se  = (1.d0+(a_w1 * hd1)**nsw)**(-msw)
c
c           given a new se and sr_w defines a change in ss_w
c           so that the Pc doesn't change
c
               ss_w1  = (sw - sr_w1 ) / se  + sr_w1     
c
          endif
c++
c must take the values when reverting
                    a_w(ik,3) =  a_w1
                   ss_w(ik,3) = ss_w1 
                   sr_w(ik,3) = sr_w1 
c
c           update the farthest progression
            sb_w(ik,4) = sw
                 nhc_w(ik) = 3
c
                                    return
                                    end
c----------------------------------------------------------
         subroutine w4_new (ik,sw)
c----------------------------------------------------------
c
c           NEW SIC_2
c
        include 'include.f'
c
         DOUBLE precision nsw, msw
         nsw = shape(ik)
         msw = 1.d0-1.d0/shape(ik)
                     sb_w(ik,4) = sw
c              calculate a_w(Sw):
                 a_w1      = a_w(ik,3)
     &                   + (a_w(ik,2) - a_w(ik,3))
     &                   * ( epsil / (sb_w(ik,3) - sb_w(ik,4)) )**b_a
c
c              generate a curve which will pass through 
c              both sb_w(ik,4) and sb_w(ik,3)
c
c              the hd at the current branch point
                 call lev_p_sw ( pcnw1(ik), pc )
                 hd1 = pc/denw
                 se1   = (1.d0+(a_w1     *hd1)**nsw)**(-msw)
c
c              the hd at the previous branch point (off curve 2)
                 nhc_w(ik) = 2
                 call pc_nw (sb_w(ik,3),pc,d_pc,ik)
                 hd0 = pc/denw
                 se0   = (1.d0+(a_w1     *hd0)**nsw)**(-msw)
c
                 sr_w1      = (se0*sb_w(ik,4)
     &                              - se1*sb_w(ik,3))
     &                              / (se0 - se1)
                 ss_w1      = (sb_w(ik,4)
     &                              - sr_w1     )/se1
     &                              + sr_w1     
c++
                 nhc_w(ik) = 4
                 if  (ss_w1 - sr_w1 .ge. sp_min ) then
c                   the curve is not too tight so update
                    a_w(ik,4) =  a_w1
                   ss_w(ik,4) = ss_w1         
                   sr_w(ik,4) = sr_w1         
                           call pc_nw (sw,pc,d_pc,ik)
                           hd0 = pc/denw
                      if (hd0 .gt. hd1 +epsil )   then
c                         keep the old curve parameters
                            a_w(ik,4) =  a_w(ik,3)
                           ss_w(ik,4) = ss_w(ik,3)
                           sr_w(ik,4) = sr_w(ik,3)
                      endif 
                 else
                    a_w(ik,4) =  a_w(ik,3)
                   ss_w(ik,4) = ss_w(ik,3)
                   sr_w(ik,4) = sr_w(ik,3)
                 endif
c++
                                    return
                                    end
c----------------------------------------------------------
         subroutine w4_up (ik,sw)
c----------------------------------------------------------
c
c           UPDATE SIC_2
c
c           normal - match on the sb_w(ik,4) side
c
        include 'include.f'
        DOUBLE precision nsw, msw
c
         nsw = shape(ik)
         msw = 1.d0-1.d0/shape(ik)
c              head at current point
                 call lev_p_sw ( pcnw1(ik), pc )
                 hd1 = pc/denw
c              calculate a_w(Sw):
                if ( sw.le.sb_w(ik,4) ) sw = sb_w(ik,4)+epsil
                a_w1      = a_w(ik,3)
     &                     + (a_w(ik,2) - a_w(ik,3))
     &                     * ( (sw - sb_w(ik,4) )
     &              / (sb_w(ik,3) - sb_w(ik,4)) )**b_a
c
               se1  = (1.d0+(a_w1     *hd1)**nsw)**(-msw)
c
c              the Se at branch point 3
                 nhc_w(ik) = 2
                 call pc_nw (sb_w(ik,3),pc,d_pc,ik)
                 hd0 = pc/denw
                 nhc_w(ik) = 4
                 se0   = (1.d0+(a_w1     *hd0)**nsw)**(-msw)
c
                 sr_w1      = (se0*sw
     &                       - se1*sb_w(ik,3)) / (se0 - se1)
                 ss_w1      = (sw - sr_w1     )/se1 + sr_w1
c++
                 if (ss_w1 - sr_w1 .ge. sp_min)   then
c                 the curve is not too tight so update
                   a_w(ik,4) = a_w1
                   ss_w(ik,4) = ss_w1
                   sr_w(ik,4) = sr_w1
                 endif
c++
                                    return
                                    end
c----------------------------------------------------------
         subroutine w4_up_r (ik,sw)
c----------------------------------------------------------
c
c           UPDATE SIC_2
c
c           reverse - match on the sb_w(ik,4) side
c
        include 'include.f'
        DOUBLE precision nsw, msw
c
         nsw = shape(ik)
         msw = 1.d0-1.d0/shape(ik)
c              head at current point
                 call lev_p_sw ( pcnw1(ik), pc )
                 hd0 = pc/denw
c              calculate a_w(Sw):
                if ( sw.le.sb_w(ik,4) ) sw = sb_w(ik,4)+epsil
c                    a_w1      = a_w(ik,3)
c    &                     + (a_w(ik,2) - a_w(ik,3))
c    &                     * ( (sw - sb_w(ik,4) )
c    &              / (sb_w(ik,3) - sb_w(ik,4)) )**b_a
                     a_w1      = a_w(ik,2)
     &                     - (a_w(ik,2) - a_w(ik,3))
     &                     * ( (sb_w(ik,3) - sw )
     &              / (sb_w(ik,3) - sb_w(ik,4)) )**b_a
c
               se0  = (1.d0+(a_w1     *hd0)**nsw)**(-msw)
c              the Se at branch point 4
                 nhc_w(ik) = 3
                 call pc_nw(sb_w(ik,4),pc,d_pc,ik)
                 hd1 = pc/denw
                 nhc_w(ik) = 4
                 se1   = (1.d0+(a_w1     *hd1)**nsw)**(-msw)
c
                 sr_w1      = (se0*sb_w(ik,4)
     &                       - se1*sw) / (se0 - se1)
                 ss_w1      = (sb_w(ik,4)
     &                       - sr_w1     )/se1  + sr_w1
c++
                 if (ss_w1 - sr_w1 .ge. sp_min)   then
c                 the curve is not too tight so update
                    a_w(ik,4) =  a_w1
                   ss_w(ik,4) = ss_w1
                   sr_w(ik,4) = sr_w1
                 endif
c++
                                    return
                                    end
c************************************************************
        subroutine st_pc(icut)
c************************************************************
c************************************************************
c update the hysteresis vectors for the St(Pcgn) functional
c for the next time step
c
        include 'include.f'
c
                      do 103 ik = 1, nn
c
          st = st11(ik,1)
             if(st.lt.0.d0)  st = 0.d0
             if(st.gt.1.d0)  st = 1.d0
c
c HYSTERESIS
c drainage/imbibition/reversal ...
c
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                   if (nhc_t(ik).eq.1 )        then
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
             se = (st - sr_t(ik,1)) / (ss_t(ik,1) - sr_t(ik,1))
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c                     PDC / MDC
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c
c          4 possibilities: 1. hit top (immobile water)
c                           2. hit bottom (immobile NAPL+gas)
c                           3. reversal to SIC_1
c                           4. continue on this curve
c
          if( st.le.(swt_c(ik)+snt_c(ik)+epsil).or.se.lt.epsil )  then
c case 1
c          have hit the top (immobile water+NAPL)
c          shift to curve 2; 
c          NEW PIC/MIC DEFINED
c
                   call t2_new (ik,st)
c          
          else if( st.gt. 1.d0 - sgt_c(ik) - epsil ) then
c case 2
c              NEW PDC/MDC DEFINED
c
                   call t1_new (ik,st)
c
          else if( se .gt. se_rl .and. se .lt. (1.d0-se_sl) ) then
c not on a linear part of the curve so allow update/reversal
c
               if( (st - sb_t(ik,2)) .ge. factd .and.  
     &               sb_t(ik,1) - sb_t(ik,2) .gt. sr_min .and.  
     &               st - sr_t(ik,1) .gt. sr_min ) then
c case 3
c               REVERSAL to curve 2
c               NEW SIC_1   DEFINED
                     icut = 1
c
                   call t21_new (ik,st)
c--
               else
c case 4
c          not enough to change things, update sr_t, ss_t
c           PDC/MDC UPDATE
c
                   call t1_up (ik,st,se)
c
               endif
          endif
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
               else if( nhc_t(ik).eq.2)  then
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
             se = (st - sr_t(ik,2)) / (ss_t(ik,2) - sr_t(ik,2))
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c                   PIC / MIC / SIC_1
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c
c  5 possibilities: 1. hit bottom (immobile NAPL+gas)
c                   2. hit top (immobile water)
c                   3. reverse through branch point back to curve 1
c                   4. reversal to curve 3
c                   5. continue along the curve     
c
          if( st.gt. 1.d0- sgt_c(ik) -epsil  .or.
     &        se.gt. 1.d0-epsil )  then
c case 1
c          shift to curve 1; lose all previous history
c          
c           NEW PDC/MDC DEFINED
c
            call t1_new (ik,st)
c
          else if( st.le.swt_c(ik)+snt_c(ik)+epsil )   then
c case 2
c                 have hit the top (immobile water+NAPL)
c                 NEW PIC/MIC DEFINED
c          
                  call t2_new (ik,st)
c
          else if( st.lt.sb_t(ik,2) )          then
c case 3
c             have reversed back onto curve 1   
c                 REVERT back to  PDC/MDC
c          
                  call t1_rev (ik,st)
c
          else if( se .gt. se_rl .and. se .lt. (1.d0-se_sl) ) then
c not on a linear part of the curve so allow update/reversal
               if( st - sb_t(ik,3) .le. -facti .and.
     &               sb_t(ik,3) - sb_t(ik,2) .gt. sr_min .and. 
     &               ss_t(ik,2) - st .gt. sr_min ) then
c case 4
c
c         REVERSAL
                     icut = 1
c
c                NEW SDC_1 or SDC_2 CURVE 
c
                 call t3_new (ik,st)
c
               else
c case 5
c
c           UPDATE PIC / MIC / SIC_1  
c
                 call t2_up (ik,st,se)
c
               endif
          endif
c
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
               else if( nhc_t(ik).eq.3)  then
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
             se = (st - sr_t(ik,3)) / (ss_t(ik,3) - sr_t(ik,3))
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c                     SDC_1 / SDC_2 
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c         on scanning drainage path
c
c          6 possibilities: 1. close loop to curve 1 
c                           2. hit top 
c                           3. hit bottom (revert to curve 1)
c                           4. reverse back onto curve 2
c                           5. reversal to curve 4
c                           6. continue along this curve
c
         if(st.le.swt_c(ik)+snt_c(ik)+epsil)  then
c case 2 
c              NEW PIC/MIC
c
               call t2_new (ik,st)
c
         else if( st.le.(sb_t(ik,2)+epsil) )          then
c case 1
c              Rrevert back to PDC/MDC
c
               call t1_rev (ik,st)
c
         else if( st.ge.sb_t(ik,3) )          then
c case 3 or 4
c
           if( st.ge.1.d0-sgt_c(ik)-epsil )  then
c case 3
c                    NEW PDC/MDC
c
                     call t1_new (ik,st)
c
           else
c case 4
c
                  call t2_rev (ik,st)
c
           endif 
c
          else if( se .gt. se_rl .and. se .lt. (1.d0-se_sl) ) then
c not on a linear part of the curve so allow update/reversal
            if( (st - sb_t(ik,4))  .ge. factd .and.  
     &               sb_t(ik,3) - sb_t(ik,4) .gt. sr_min .and.
     &               st - sr_t(ik,3) .gt. sr_min ) then
c case 5
c           REVERSAL to curve 4
c           NEW SIC_2
                     icut = 1
c
              call t4_new (ik,st)
c
            else  
c case 6
c
               call t3_up (ik,st,se)
c
            endif 
       endif 
c
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
               else if( nhc_t(ik).eq.4)  then
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c                    SIC_2 
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c         on scanning imbibition path
c
c 6 possibilities: 1. close loop back onto curve 2
c                  2. hit bottom
c                  3. reverse through branch point back to curve 1
c                  4. reverse through branch point back to curve 3
c                  5. reverse through branch point back to top (curve 2)
c                  6. stay on curve 4
c
        if( st.ge.sb_t(ik,3) )          then
c case 1 or 2
           if( st.ge. 1.d0-sgt_c(ik)-epsil )  then
c case 2   (immobile total nonwetting phase)
c
c                 NEW PDC/MDC DEFINED
c
                  call t1_new (ik,st)
c
           else
c case 1, reverse back onto curve 2
c
c               REVERT TO PIC / MIC / SIC_1
                  call t2_rev (ik,st)
c
           endif
        else if( st.le.swt_c(ik)+snt_c(ik)+epsil )   then
c case 5, 
c          NEW PIC/MIC DEFINED
c
            call t2_new (ik,st)
c          
        else if( st.le.(sb_t(ik,2)+epsil) )          then
c case 3, 
c                 REVERT back to  PDC/MDC
c          
                  call t1_rev (ik,st)
c
c
        else if( st.le.sb_t(ik,4) )   then
c case 4
c
c           REVERT TO SDC_1 / SDC_2 
c
                call t3_rev (ik,st)
c
        else
c case 6
c
             if( st.ge.stt(ik,1))  then
c             imbibition 
                call t4_up (ik,st)
             else 
c             drainage  
                call t4_up_r (ik,st)
             endif
c
        endif 
c
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
                          endif
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c
  103   continue
                                          return
                                          end
c
c----------------------------------------------------------
         subroutine t1_new (ik,st)
c----------------------------------------------------------
c
c           NEW PDC/MDC DEFINED
c
        include 'include.f'
c
              nhc_t (ik)   = 1
                    ss_t(ik,1) = st
                    sb_t(ik,1) = st
                    sb_t(ik,2) = st
                    sr_t(ik,1) = swt_c(ik) + snt_c(ik)
                    a_t(ik,1)  = asd(ik)
c
c reset gas trapping parameters:
                  if(sgr(ik).lt.epsil) then
                    sg_mx(ik)   = 0.d0 
                    sgt_mx(ik)  = 0.d0 
                    sgt_mn(ik)  = 0.d0 
                    sgt_c(ik)   = 0.d0 
                  else
                    sg_mx(ik)   = 1.d0 - st
                    sgt_mx(ik)  = 1.d0 - st
                    sgt_mn(ik)  = 1.d0 - st
                    sgt_c(ik)   = 1.d0 - st
                  endif
c
                              return
                              end    
c----------------------------------------------------------
         subroutine t1_up (ik,st,se)
c----------------------------------------------------------
c
c          PDC/MDC UPDATE
c  se =     the current se
c
        include 'include.f'
c
            if( st .lt. sb_t(ik,2) ) sb_t(ik,2) = st
c
c           update 'sr_t' for this PDC (trapped St)
c
               sr_t1      =  swt_c(ik) + snt_c(ik)
c
c           a change in sr_t requires a change in ss_t
c           so that the Pc doesn't change
c
               ss_t1      = (st - sr_t1     ) / se  + sr_t1     
c++ curve 1
                   if  (ss_t1 - sr_t1 .ge. sp_min ) then
c                   the curve is not too tight so update
                      ss_t(ik,1) = ss_t1
                      sr_t(ik,1) = sr_t1
                   endif
c++
                              return
                              end    
c----------------------------------------------------------
         subroutine t1_rev (ik,st)
c----------------------------------------------------------
c
c    revert back to a PDC/MDC from another curve
c
        include 'include.f'
c
        DOUBLE precision nsw, msw
         nsw = shape(ik)
         msw = 1.d0-1.d0/shape(ik)
c
c             calc. the head at this point before change
                 call lev_p_st ( pcgn1(ik), pc )
                 hd = pc/denw
c           update
             nhc_t(ik) = 1
             a_t(ik,1)  = asd(ik)      
c
c            force the new PDC to pass through this hd 
             se = (1.d0+(asd(ik)*hd)**nsw)**(-msw)
c
             sr_t(ik,1) =  swt_c(ik) + snt_c(ik)
c
             ss_t(ik,1) = (st - sr_t(ik,1)) / se  + sr_t(ik,1)
             sb_t(ik,2) = st
c
                              return
                              end    
c-------------------------------------------------------------
         subroutine t2_new  (ik,st)
c-------------------------------------------------------------
c
c           NEW PIC/MIC DEFINED
c
        include 'include.f'
c          
              nhc_t(ik)   = 2
              sr_t(ik,2) = st
              sb_t(ik,2) = st
              sb_t(ik,3) = st
              a_t(ik,2) = asi(ik)
              ss_t(ik,2) = 1.d0 - sgt_c(ik)
c
c reset NAPL and water trapping parameters:
           if(sw11(ik,1).lt.0.d0) then
                sw = 0.d0
           else if(sw11(ik,1).gt.1.d0) then
                sw = 1.d0
           else
                sw = sw11(ik,1)
           endif
c
        if(st11(ik,1)-sw11(ik,1).lt.0.d0) then
             so = 0.d0
        else if(st11(ik,1)-sw11(ik,1).gt.1.d0) then
             so = 1.d0
        else
             so = st11(ik,1) - sw11(ik,1)
        endif
                 if(swr(ik).lt.epsil)  then
                    sw_mx(ik)   = 0.d0
                    swt_mx(ik)  = 0.d0
                    swt_mn(ik)  = 0.d0
                    swt_c(ik)   = 0.d0
                 else
                    sw_mx(ik)   = sw
                    swt_mx(ik)  = sw
                    swt_mn(ik)  = sw
                    swt_c(ik)   = sw
                 endif
                 if(snwr(ik)+snnr(ik).lt.epsil)  then
                    sn_mx(ik)   = 0.d0            
                    snt_mx(ik)  = 0.d0            
                    snt_mn(ik)  = 0.d0            
                    snt_c(ik)   = 0.d0            
                 else
                    sn_mx(ik)   = so              
                    snt_mx(ik)  = so              
                    snt_mn(ik)  = so              
                    snt_c(ik)   = so              
                 endif
c
                              return
                              end
c-------------------------------------------------------------
         subroutine t2_up (ik,st,se)
c-------------------------------------------------------------
c
c              Curve 2 update
c              includes PIC / MIC / SIC_1
c  se =      the se at the current point
c
        include 'include.f'
         DOUBLE precision nsw, msw
         nsw = shape(ik)
         msw = 1.d0-1.d0/shape(ik)
c
c           update the farthest progression
            if( st .gt. sb_t(ik,3) ) sb_t(ik,3) = st
c
c          update 'ss_t' for this primary imbibition curve
           ss_t1 = 1.d0 - sgt_c(ik)
c
c if this is an SIC, then must update at:
        if(dabs(asd(ik)-asi(ik)).gt.0.0001d0) then
        if(dabs(asi(ik)-a_t(ik,2))/dabs(asd(ik)-asi(ik)).gt.0.01d0) then
c update the SIC
c             calc. the head at this point before change
                 call lev_p_st ( pcgn1(ik), pc )
                 hd = pc/denw
c
           if(st.le.sb_t(ik,2) ) st = sb_t(ik,2)  + epsil
           a_t1 = asd(ik)  + (asi(ik)  - asd(ik))
     &              * ((st - sb_t(ik,2)) / (ss_t1 - sb_t(ik,2)))**b_a
c
c iii          calculate the Se of the new curve at the branch point
           se   = (1.d0+(a_t1*hd)**nsw)**(-msw)
c
        else  
           a_t1 = asi(ik) 
        endif 
        else  
           a_t1 = asi(ik) 
        endif 
c
           sr_t1 = (st - se*ss_t1 ) / (1.d0 - se)
c++ curve 2
                   if  (ss_t1 - sr_t1 .ge. sp_min ) then
c                   the curve is not too tight so update
                      a_t(ik,2)  = a_t1
                      ss_t(ik,2) = ss_t1      
                      sr_t(ik,2) = sr_t1
                   endif
c++
                              return
                              end    
c-------------------------------------------------------------
         subroutine t2_rev (ik,st)
c-------------------------------------------------------------
c
c              revert back to curve  2 
c              includes PIC / MIC / SIC_1
c
        include 'include.f'
c
         DOUBLE precision nsw, msw
         nsw = shape(ik)
         msw = 1.d0-1.d0/shape(ik)
c          2 possibilities: 1. origin of curve 2 off curve 1
c                           2. origin of curve 2 at immobile water
c
c i            calculate the head at the current point
                 call lev_p_st ( pcgn1(ik), pc )
                 hd = pc/denw
c
             ss_t(ik,2) = 1.d0 - sgt_c(ik) 
c
        if(dabs(asd(ik)-asi(ik)).gt.0.0001d0) then
        if(dabs(asi(ik)-a_t(ik,2))/dabs(asd(ik)-asi(ik)).gt.0.01d0) then
c update the SIC
           a_t(ik,2) = asd(ik)  + (asi(ik)  - asd(ik))
     &           * ((st - sb_t(ik,2)) / (ss_t(ik,2) - sb_t(ik,2)))**b_a
c
        endif
        endif
c iii          calculate the Se at the current point
c
           se   = (1.d0+(a_t(ik,2)*hd)**nsw)**(-msw)
c
           sr_t(ik,2) = (st - se*ss_t(ik,2)) / (1.d0 - se)
c
              nhc_t(ik) = 2
              sb_t(ik,3) = st
c
                              return
                              end    
c-------------------------------------------------------------
         subroutine t21_new (ik,st)
c-------------------------------------------------------------
c
c           set up a NEW SIC_1 CURVE
c
        include 'include.f'
c
         DOUBLE precision nsw, msw
         nsw = shape(ik)
         msw = 1.d0-1.d0/shape(ik)
c                  new branch point
                     sb_t(ik,2) = st
                     sb_t(ik,3) = st
c
            ss_t1 = 1.d0 - sgt_c(ik)
c
c a.) compute se for continuity
c
c i            calculate the head at the branch point
                 call lev_p_st ( pcgn1(ik), pc )
                 hd = pc/denw
c
c ii               calculate the variable imbibition a_t
c                   
                    a_t1 = asd(ik) + (asi(ik)  - asd(ik))
     &                   * ( epsil
     &                   / (ss_t1 - sb_t(ik,2)))**b_a
c
c iii          calculate the Se of the new curve at the branch point
                    se1   = (1.d0+(a_t1*hd)**nsw)**(-msw)
c
c
                   sr_t1      = (sb_t(ik,2) - se1*ss_t1     ) 
     &                         / (1.d0 - se1)
c
c++ start curve 2
                   nhc_t(ik) = 2
                   if  (ss_t1 - sr_t1 .ge. sp_min ) then
c                   the curve is not too tight so update
                         a_t(ik,2)  = a_t1      
                         ss_t(ik,2) = ss_t1      
                         sr_t(ik,2) = sr_t1
                           call pc_gn (st,pc,d_pc,ik)
                           hd0 = pc/denw
                      if (hd0 .gt. hd +epsil )   then
c                         keep the old curve parameters
                          a_t(ik,2)  = asd(ik)
                          ss_t(ik,2) = ss_t(ik,1) 
                          sr_t(ik,2) = sr_t(ik,1) 
                      endif 
                   else 
c                     curve too tight keep the old curve parameters
                      a_t(ik,2)  = asd(ik)
                      ss_t(ik,2) = ss_t(ik,1) 
                      sr_t(ik,2) = sr_t(ik,1) 
                   endif
c++
c
                              return
                              end    
c-------------------------------------------------------------
         subroutine t3_new (ik,st)
c-------------------------------------------------------------
c
c           start a new SDC_1 of SDC_2 curve
c
        include 'include.f'
c
         DOUBLE precision nsw, msw
         nsw = shape(ik)
         msw = 1.d0-1.d0/shape(ik)
c                  new branch point
                     sb_t(ik,3) = st
                     sb_t(ik,4) = st
c
c              the hd at the current branch point
                 call lev_p_st ( pcgn1(ik), pc )
                 hd1 = pc/denw
c
c              construct a scanning drainage branch
c              2 possibilities  1: curve 2 originated at St > stwr
c                               2: curve 2 originated at St = stwr
c
             if( sb_t(ik,2).gt.swt_mx(ik)+snt_c(ik)+1.d-6 )  then
c SDC_2
c              curve 2 is a MWC, (originated off curve 1), the curve
c              must pass through both sb_t(ik,3) and sb_t(ik,2)
c
c              calculate new a_t:
              a_t1      = a_t(ik,2) - (a_t(ik,2) - asd(ik) )
     &                   * ( epsil / (sb_t(ik,3) - sb_t(ik,2)) )**b_a
c
c              the Se at the current branch point
                 se1  = (1.d0+(a_t1 * hd1)**nsw)**(-msw)
c
c              the Se at the previous branch point (off curve 1)
                 nhc_t(ik) = 1
                 call pc_gn (sb_t(ik,2),pc,d_pc,ik)
                 hd0 = pc/denw
c
                 se0   = (1.d0+(a_t1 * hd0)**nsw)**(-msw)
c
                 sr_t1      = (se0*sb_t(ik,3)
     &                              - se1*sb_t(ik,2))
     &                              / (se0 - se1)
                 ss_t1      = (sb_t(ik,3)
     &                              - sr_t1     )/se1
     &                              + sr_t1     
             else
c SDC_1
c            curve 2 is a PWC (originated at St < stwr, immobile W+N)
c            curve 3 must pass through sb_t(ik,3) and
c            terminate at stwr >= sr_t(ik,3) > sb_t(ik,2)
c
                 sr_t1  =  swt_c(ik) + snt_c(ik)
c              calculate new a_t:
               a_t1   = a_t(ik,2) - (a_t(ik,2) - asd(ik) )
     &                * ( epsil / (sb_t(ik,3) - sr_t1 ))**b_a
c
                 se1   = (1.d0+(a_t1     *hd1)**nsw)**(-msw)
c
                 ss_t1      = (sb_t(ik,3) - sr_t1     ) 
     &                        / se1  + sr_t1     
             endif
c++
               nhc_t(ik) = 3
                 if  (ss_t1 - sr_t1 .ge. sp_min ) then
c                   the curve is not too tight so update
                           a_t(ik,3) = a_t1 
                           ss_t(ik,3) = ss_t1 
                           sr_t(ik,3) = sr_t1 
                           call pc_nw (st,pc,d_pc,ik)
                           hd0 = pc/denw
                      if (hd0 .lt. hd1-epsil )   then
                           a_t(ik,3) = a_t(ik,2)
                           ss_t(ik,3) = ss_t(ik,2)
                           sr_t(ik,3) = sr_t(ik,2)
                      endif
                 else
                    a_t(ik,3) = a_t(ik,2)
                    ss_t(ik,3) = ss_t(ik,2)
                    sr_t(ik,3) = sr_t(ik,2)
                 endif
c++
                              return
                              end    
c----------------------------------------------------------
         subroutine t3_up (ik,st,se)
c----------------------------------------------------------
c
c            UPDATE SDC_1 or SDC_2
c
        include 'include.f'
         DOUBLE precision nsw, msw
         nsw = shape(ik)
         msw = 1.d0-1.d0/shape(ik)
c   se = current se
c
c          2 possibilities: 1. origin of curve 2 off curve 1
c                           2. origin of curve 2 at immobile NAPL+water
c
c           update the farthest progression
            if( st .lt. sb_t(ik,4) ) sb_t(ik,4) = st
c
c             calc. the head at this point before change
                 call lev_p_st ( pcgn1(ik), pc )
                 hd1 = pc/denw
c
          if( sb_t(ik,2).gt.swt_mx(ik)+snt_c(ik)+1.d-6 )  then
c 1. origin of curve 2 off curve 1
c SDC_2
c              calculate new a_t:
               if(st.ge.sb_t(ik,3)) st = sb_t(ik,3)-epsil
               a_t1      = a_t(ik,2) - (a_t(ik,2) - asd(ik) )
     &                     * ( (sb_t(ik,3) - st )
     &                     / (sb_t(ik,3) - sb_t(ik,2)) )**b_a
               se1  = (1.d0+(a_t1     *hd1)**nsw)**(-msw)
c
c              the Se at branch point 2
                 nhc_t(ik) = 1
                     call pc_gn (sb_t(ik,2),pc,d_pc,ik)
                     hd0 = pc/denw
                 nhc_t(ik) = 3
                 se0   = (1.d0+(a_t1     *hd0)**nsw)**(-msw)
c
                 sr_t1      = (se0*st - se1*sb_t(ik,2))
     &                              / (se0 - se1)
                 ss_t1      = (st - sr_t1     )/se1 + sr_t1
c
          else
c SDC_1
c           curve 3 terminates at top (immobile NAPL+water)
c           given a new se and sr_t defines a change in ss_t
c           so that the Pc doesn't change
c
c           update 'sr_t' for this primary drainage curve
                 sr_t1      =  swt_c(ik)+snt_c(ik)
c
              if(st.ge.sb_t(ik,3)) st = sb_t(ik,3)-epsil
c              calculate new a_t:
               a_t1      = a_t(ik,2) - (a_t(ik,2) - asd(ik) )
     &                     * ( (sb_t(ik,3) - st )
     &                     / (sb_t(ik,3) - sr_t1 ) )**b_a
c
               se  = (1.d0+(a_t1 * hd1)**nsw)**(-msw)
c
c           given a new se and sr_t defines a change in ss_t
c           so that the Pc doesn't change
c
               ss_t1  = (st - sr_t1 ) / se  + sr_t1     
c
          endif
c++
                 if  (ss_t1 - sr_t1 .ge. sp_min ) then
c                   the curve is not too tight so update
                    a_t(ik,3) =  a_t1 
                   ss_t(ik,3) = ss_t1 
                   sr_t(ik,3) = sr_t1 
                 endif
c++
                                    return
                                    end
c----------------------------------------------------------
         subroutine t3_rev (ik,st)
c----------------------------------------------------------
c
c           REVERT back to an SDC_1 or SDC_2
c
        include 'include.f'
c
        DOUBLE precision nsw, msw
         nsw = shape(ik)
         msw = 1.d0-1.d0/shape(ik)
c          2 possibilities: 1. origin of curve 2 off curve 1
c                           2. origin of curve 2 at immobile NAPL+water
c
c
c           the head at the current point
                 call lev_p_st ( pcgn1(ik), pc )
                 hd1 = pc/denw
c
          if( sb_t(ik,2).gt.swt_mx(ik)+snt_mx(ik)+1.d-6 )  then
c 1. origin of curve 2 off curve 1
c SDC_2
c              calculate new a_t:
               if(st.ge.sb_t(ik,3)) st = sb_t(ik,3)-epsil
               a_t1      = a_t(ik,2) - (a_t(ik,2) - asd(ik) )
     &                     * ( (sb_t(ik,3) - st )
     &                     / (sb_t(ik,3) - sb_t(ik,2)) )**b_a
c
               se1  = (1.d0+(a_t1 *hd1)**nsw)**(-msw)
c
c              the Se at branch point 2
                 nhc_t(ik) = 1
                     call pc_gn (sb_t(ik,2),pc,d_pc,ik)
                     hd0 = pc/denw
                 se0   = (1.d0+(a_t1*hd0)**nsw)**(-msw)
c
c
                 sr_t1      = (se0*st - se1*sb_t(ik,2))
     &                              / (se0 - se1)
                 ss_t1      = (st - sr_t1     )/se1 + sr_t1     
c
          else
c SDC_1
c           curve 3 terminates at top (immobile NAPL+water)
c
c           update 'sr_t' for this primary drainage curve
c
                 sr_t1      =  swt_c(ik)+snt_c(ik)
c
               if(st.ge.sb_t(ik,3)) st = sb_t(ik,3)-epsil
c              calculate new a_t:
               a_t1      = a_t(ik,2) - (a_t(ik,2) - asd(ik) )
     &                     * ( (sb_t(ik,3) - st )
     &                     / (sb_t(ik,3) - sr_t1 ))**b_a
c
               se  = (1.d0+(a_t1 * hd1)**nsw)**(-msw)
c
c           given a new se and sr_t defines a change in ss_t
c           so that the Pc doesn't change
c
               ss_t1  = (st - sr_t1 ) / se  + sr_t1     
c
          endif
c++
c must take the values when reverting
                    a_t(ik,3) =  a_t1
                   ss_t(ik,3) = ss_t1 
                   sr_t(ik,3) = sr_t1 
c
c           update the farthest progression
            sb_t(ik,4) = st
                 nhc_t(ik) = 3
c
                                    return
                                    end
c----------------------------------------------------------
         subroutine t4_new (ik,st)
c----------------------------------------------------------
c
c           NEW SIC_2
c
        include 'include.f'
c
         DOUBLE precision nsw, msw
         nsw = shape(ik)
         msw = 1.d0-1.d0/shape(ik)
                     sb_t(ik,4) = st
c              calculate a_t(St):
                 a_t1      = a_t(ik,3)
     &                   + (a_t(ik,2) - a_t(ik,3))
     &                   * ( epsil / (sb_t(ik,3) - sb_t(ik,4)) )**b_a
c
c              generate a curve which will pass through 
c              both sb_t(ik,4) and sb_t(ik,3)
c
c              the hd at the current branch point
                 call lev_p_st ( pcgn1(ik),  pc )
                 hd1 = pc/denw
                 se1   = (1.d0+(a_t1     *hd1)**nsw)**(-msw)
c
c              the hd at the previous branch point (off curve 2)
                 nhc_t(ik) = 2
                 call pc_gn (sb_t(ik,3),pc,d_pc,ik)
                 hd0 = pc/denw
                 se0   = (1.d0+(a_t1     *hd0)**nsw)**(-msw)
c
                 sr_t1      = (se0*sb_t(ik,4)
     &                              - se1*sb_t(ik,3))
     &                              / (se0 - se1)
                 ss_t1      = (sb_t(ik,4)
     &                              - sr_t1     )/se1
     &                              + sr_t1     
c++
                 nhc_t(ik) = 4
                 if  (ss_t1 - sr_t1 .ge. sp_min ) then
c                   the curve is not too tight so update
                    a_t(ik,4) =  a_t1
                   ss_t(ik,4) = ss_t1         
                   sr_t(ik,4) = sr_t1         
                           call pc_gn (st,pc,d_pc,ik)
                           hd0 = pc/denw
                      if (hd0 .gt. hd1 +epsil )   then
c                         keep the old curve parameters
                            a_t(ik,4) =  a_t(ik,3)
                           ss_t(ik,4) = ss_t(ik,3)
                           sr_t(ik,4) = sr_t(ik,3)
                      endif 
                 else
                    a_t(ik,4) =  a_t(ik,3)
                   ss_t(ik,4) = ss_t(ik,3)
                   sr_t(ik,4) = sr_t(ik,3)
                 endif
c++
                                    return
                                    end
c----------------------------------------------------------
         subroutine t4_up (ik,st)
c----------------------------------------------------------
c
c           UPDATE SIC_2
c
c           normal - match on the sb_t(ik,4) side
c
        include 'include.f'
        DOUBLE precision nsw, msw
c
         nsw = shape(ik)
         msw = 1.d0-1.d0/shape(ik)
c              head at current point
                 call lev_p_st ( pcgn1(ik),  pc )
                 hd1 = pc/denw
c              calculate a_t(St):
                if ( st.le.sb_t(ik,4) ) st = sb_t(ik,4)+epsil
                a_t1      = a_t(ik,3)
     &                     + (a_t(ik,2) - a_t(ik,3))
     &                     * ( (st - sb_t(ik,4) )
     &              / (sb_t(ik,3) - sb_t(ik,4)) )**b_a
c
               se1  = (1.d0+(a_t1     *hd1)**nsw)**(-msw)
c
c              the Se at branch point 3
                 nhc_t(ik) = 2
                 call pc_gn (sb_t(ik,3),pc,d_pc,ik)
                 hd0 = pc/denw
                 nhc_t(ik) = 4
                 se0   = (1.d0+(a_t1     *hd0)**nsw)**(-msw)
c
                 sr_t1      = (se0*st
     &                       - se1*sb_t(ik,3)) / (se0 - se1)
                 ss_t1      = (st - sr_t1     )/se1 + sr_t1
c++
                 if (ss_t1 - sr_t1 .ge. sp_min)   then
c                 the curve is not too tight so update
                   a_t(ik,4) = a_t1
                   ss_t(ik,4) = ss_t1
                   sr_t(ik,4) = sr_t1
                 endif
c++
                                    return
                                    end
c----------------------------------------------------------
         subroutine t4_up_r (ik,st)
c----------------------------------------------------------
c
c           UPDATE SIC_2
c
c           reverse - match on the sb_t(ik,4) side
c
        include 'include.f'
        DOUBLE precision nsw, msw
c
         nsw = shape(ik)
         msw = 1.d0-1.d0/shape(ik)
c              head at current point
                 call lev_p_st ( pcgn1(ik),  pc )
                 hd0 = pc/denw
c              calculate a_t(St):
                if ( st.le.sb_t(ik,4) ) st = sb_t(ik,4)+epsil
c                    a_t1      = a_t(ik,3)
c    &                     + (a_t(ik,2) - a_t(ik,3))
c    &                     * ( (st - sb_t(ik,4) )
c    &              / (sb_t(ik,3) - sb_t(ik,4)) )**b_a
                     a_t1      = a_t(ik,2)
     &                     - (a_t(ik,2) - a_t(ik,3))
     &                     * ( (sb_t(ik,3) - st )
     &              / (sb_t(ik,3) - sb_t(ik,4)) )**b_a
c
               se0  = (1.d0+(a_t1     *hd0)**nsw)**(-msw)
c              the Se at branch point 4
                 nhc_t(ik) = 3
                 call pc_gn(sb_t(ik,4),pc,d_pc,ik)
                 hd1 = pc/denw
                 nhc_t(ik) = 4
                 se1   = (1.d0+(a_t1     *hd1)**nsw)**(-msw)
c
                 sr_t1      = (se0*sb_t(ik,4)
     &                       - se1*st) / (se0 - se1)
                 ss_t1      = (sb_t(ik,4)
     &                       - sr_t1     )/se1  + sr_t1
c++
                 if (ss_t1 - sr_t1 .ge. sp_min)   then
c                 the curve is not too tight so update
                    a_t(ik,4) =  a_t1
                   ss_t(ik,4) = ss_t1
                   sr_t(ik,4) = sr_t1
                 endif
c++
                                    return
                                    end
