C     Last change:  JG   30 Oct 97    4:39 pm
c
c
           subroutine icset 
c
c
c ivert = 1 then cross section else areal simulation
c
        include 'include.f'
c
c
c  swinit : initial global water saturation
c  coninit : initial global contaminant concentration
c            cannot be bigger than parow
c
c Initial water saturation: swinit
c
             read (1,*) swinit
c
c Initial total liquid saturation: stinit
c
             read (1,*) stinit
c
           if(stinit.lt.swinit-1.d-12) then
             write(6,*) 'INPUT ERROR'
               write(6,*) '   VIOLATE St >= Sw'
               stop
           endif
           if(iphase.eq.12.and.stinit.lt.1.d0-epsil) then
             write(6,*) 'INPUT ERROR'
       write(6,*)'       IPHASE and INITIAL saturations not compatible'
               stop
           endif
           if(iphase.eq.13.and.dabs(stinit-swinit).gt.epsil) then
             write(6,*) 'INPUT ERROR'
       write(6,*)'       IPHASE and INITIAL SATURATIONS not compatible'
               stop
           endif
c
c Initial oil in water concentration : roainit
c
             read (1,*) roainit
               if(ntr_ow.ne.1) then
                 roainit = 0.d0
               endif
c
c Initial oil in gas concentration : roginit
c
             read (1,*) roginit
               if(ntr_og.ne.1) then
                 roginit = 0.d0
               endif
c
        read(1,*) ncont
        if (ncont.ne.1)then
c
c        initial cond are static equalibrium
c
           if (stinit-swinit.gt.0.001d0) then
c NAPL is present in the system and NAPL and water are in equalibrium
c set all values of roa11 equal to parow
c set all values of rog11 equal to parog
             do 35 i = 1, nn   
c
                    roa11(i,1) = parow
                    rog11(i,1) = parog
                    roat(i,1) = parow
                    rogt(i,1) = parog
c
   35        continue
             call water_prop (parow,wa,dww,visw)
             call   gas_prop (parog,wg,dgg,visg)
c
           else 
c set all values of roa11 equal to roainit
c set all values of rog11 equal to roginit
            do 434 j = 1, nn    
c
               roa11(j,1)   = roainit
               rog11(j,1)   = roginit
               roat(j,1)   = roainit
               rogt(j,1)   = roginit
c
  434       continue
             call water_prop (roainit,wa,dww,visw)
             call   gas_prop (roginit,wg,dgg,visg)
c
           endif
c______________________________________________________________
c Given global initial Sw and St define initial capillary pressures
c
       if (nhyst.eq.1)   then
c
c hysteresis on 
c
c define effective saturation parameters and 
c phase trapping parameters 
c before computing the capillary pressures
c
          do 333 j = 1, nn    
c
                 sw11(j,1)  = swinit
                 swt(j,1)   = swinit
c
                 st11(j,1)  = stinit
                 stt(j,1)   = stinit
c
             call hyst_ic (j, swinit, stinit)
c
c            given Sw what is Pcnw 
             call pc_nw    (swinit, pc, d_pc, j)
             call lev_sw_p (pc, pc )
                 pcnw1(j)  = pc
c            given St what is Pcgn 
             call pc_gn    (stinit, pc, d_pc, j)
             call lev_st_p (pc, pc )
                 pcgn1(j)  = pc
c
  333     continue
c
       else
c
c no hysteresis
c
            do 334 j = 1, nn    
c
                 sw11(j,1)  = swinit
                 swt(j,1)   = swinit
c
                 st11(j,1)  = stinit
                 stt(j,1)   = stinit
c
c            given Sw what is Pcnw 
             call pc_nw    (swinit, pc, d_pc, j)
             call lev_sw_p (pc,  pc )
                 pcnw1(j)  = pc
c            given St what is Pcgn 
             call pc_gn    (stinit, pc, d_pc, j)
             call lev_st_p (pc,  pc )
                 pcgn1(j)  = pc
c
              nhc_t(j) = 1
              nhc_w(j) = 1
              ss_w(j,1) = 1.d0
              sr_w(j,1) = swr(j)
              ss_t(j,1) = 1.d0
              sr_t(j,1) = swr(j)
c
  334       continue
c
       endif
c
c  read in deviations to global SATURATION definition
c ndev_s  = number of nodes at which Sw and St are to be redefined
            read(1,*) ndev_s
            if (ndev_s.gt.0)  then
                call ic_sat(ndev_s)
            endif  
c
c SET WATER PRESSURE - STATIC DISTRIBUTION 
c
c where potential = Pw / (rw*g) - x
c and x is vertical, datum is at x = 0, x+ is downward
c therefore,
c              Pw = x*rw*g
c assume that Pw = 0 at x = 0, y = 0 
c  set reference pressure = Pw = 0
c
c           cross section ( x is vertical positive down )
c           set up static pressure distribution in vertical
c           ii = -nny 
c           do 25 i=1,nnx
c             ii = ii + nny 
c           do 26 j=1,nny
c             pa11(ii+j,1) = grav*dww*(dcos(thgx)*x(i)+dcos(thgy)*y(j))
c             pa11(ii+j,2) = grav*dww*dcos(thgx)
c             pa11(ii+j,3) = grav*dww*dcos(thgy)
c             pa11(ii+j,4) = 0.d0
c  26       continue
c  25       continue
c
c  set reference pressure = Pg = pg_ref (1.e6 dynes/cm**2)
c  assuming Sw < 1
            ii = -nny 
            do 25 i=1,nnx
              ii = ii + nny 
            do 26 j=1,nny
              pa11(ii+j,1) = grav*dgg*(dcos(thgx)*x(i)+dcos(thgy)*y(j))
     &            + pg_ref - pcnw1(ii+j) - pcgn1(ii+j)      
              pa11(ii+j,2) = grav*dgg*dcos(thgx)
              pa11(ii+j,3) = grav*dgg*dcos(thgy)
              pa11(ii+j,4) = 0.d0
   26       continue
   25       continue
c
c below the WT set Pw = g*rw*depth
c
         do  143 ii = 1, nny  
c
c          find the first node in the column where St = 1
           do  42 jj = 0, nnx-1
               if(st11(jj*nny+ii,1).gt.0.9999) then
c               no gas, this is the first node
                  x_wt = x(jj+1)
                  mj = jj
                  go to 44
               endif
   42      continue
        go to 444
c
   44 continue
c  get to here then set Pw 
c                at and below WT
c               pcnw = pcnw1(mj*nny+ii)
c               pcgn = pcgn1(mj*nny+ii)
c        head = pg_ref - pcnw1(mj*nny+ii) - pcgn1(mj*nny+ii)
c    &            + grav*dgg*(dcos(thgx)*x_wt+dcos(thgy)*y(ii))
         head = pg_ref 
c        head = 0.d0
c
              do  142 jk = mj, nnx-1
               pa11(jk*nny+ii,1) = head +
     &         grav*dww*(dcos(thgx)*(x(jk+1)-x_wt)+dcos(thgy)*y(ii))
               pa11(jk*nny+ii,2) = grav*dww*dcos(thgx)
               pa11(jk*nny+ii,3) = grav*dww*dcos(thgy)
  142        continue
c
  444 continue
c
  143                  continue
c
c@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
c
        else
                 nflag = 1
c
c it's a RESTART
c this is a continuation of a previous run, if so we must read in
c initial data
c
                        call read_rs 
c
c  read in deviations to global SATURATION definition
c ndev_s  = number of nodes at which Sw and St are to be redefined
            read(1,*) ndev_s
            if (ndev_s.gt.0)  then
                call ic_sat(ndev_s)
            endif  
        endif
c
c  read in deviations to global ROA definition
c ndev_roa  = number of nodes at which Conc is to be redefined
            read(1,*) ndev_roa
            if (ndev_roa.gt.0)  then
                call ic_roa(ndev_roa)
            endif  
c
c  read in deviations to global ROG definition
c ndev_rog  = number of nodes at which Conc is to be redefined
            read(1,*) ndev_rog
            if (ndev_rog.gt.0)  then
                call ic_rog(ndev_rog)
            endif  
c
                                                      return 
                                                      end
c
c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
          subroutine ic_sat(ndev)
c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
c
c opportunity to change IC's/BC's from global/default specification
c
c additional conditions for Sw and St
c
c can be either dirichlet bc's to override default conditions
c or can specify specific IC's at any node in the domain
c changing Sw here can result in either mobile or immobile residual
c NOTE: alter functional conditions only!
c
        include 'include.f'
c
                       open (13,file='sw.in')
             do 26 i=1,ndev
c
              read(13,*)  nod,sw,st
c
           if(st.lt.sw-1.d-12) then
               write(6,*) 'INPUT ERROR'
               write(6,*) '       VIOLATE St >= Sw, AT NODE:'
               write(6,*) nod
               stop
           endif
           if(iphase.eq.12.and.st.lt.1.d0-epsil) then
               write(6,*) 'INPUT ERROR'
       write(6,*)' IPHASE/INITIAL Saturations not compatible @ node'
               write(6,*) nod
               stop
           endif
           if(iphase.eq.13.and.dabs(st-sw).gt.epsil) then
               write(6,*) 'INPUT ERROR'
       write(6,*)' IPHASE/INITIAL Saturations not compatible @ node'
               write(6,*) nod
               stop
           endif
           if (sw.gt.1.000d0) sw = 1.d0
           if (st.gt.1.000d0) st = 1.d0
c
               sw11(nod,1)  = sw
               st11(nod,1)  = st
c
                       if (st-sw.gt.0.001d0) then
 	                  roa11(nod,1) = parow
 	                  rog11(nod,1) = parog
 	                  roat(nod,1) = parow
 	                  rogt(nod,1) = parog
                       endif
c
c Given nodal initial Sw define initial capillary pressure
c and hysteresis vectors
c
         if (nhyst.eq.1)   then
c hysteresis on 
c given sw and st define parameters for hysteretic k-S-P model
c
              call hyst_ic (nod, sw, st)
c
         endif
c
c set capillary pressure
c            given Sw what is Pcnw 
             call pc_nw    (sw, pc, d_pc, nod)
             call lev_sw_p (pc,  pc )
                 pcnw1(nod)  = pc
c            given St what is Pcgn 
             call pc_gn    (st, pc, d_pc, nod)
             call lev_st_p (pc,  pc )
                 pcgn1(nod)  = pc
c
   26   continue
c
        close (13)
           return 
         end
c
c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
          subroutine ic_roa(ndev)
c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
c
c opportunity to change IC's from global/default specification
c at any node in the domain
c
        include 'include.f'
        open (13,file='roa.in')
c
        if (ntr_ow.eq.1) then
        do 26 i=1,ndev
c
                read(13,*)  nod,value
c
           if (value.gt.parow  ) value = parow
           if (value.lt.0.d0  ) value = 0.d0
c
              roa11(nod,1)  = value
              roat(nod,1)  = value
c
   26   continue
c
        else 
               write(28,*) 'INPUT WARNING'
         write(28,*) 'NAPL-water transport is OFF'
        endif
        close (13)
                                               return
                                               end
c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
          subroutine ic_rog(ndev)
c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
c
c opportunity to change IC's from global/default specification
c at any node in the domain
c
        include 'include.f'
        open (13,file='rog.in')
c
        if (ntr_og.eq.1) then
        do 26 i=1,ndev
c
                read(13,*)  nod,value
c
           if (value.gt.parog  ) value = parog
           if (value.lt.0.d0  ) value = 0.d0
c
              rog11(nod,1)  = value
              rogt(nod,1)  = value
c
   26   continue
c
        else 
               write(28,*) 'INPUT WARNING'
         write(28,*) 'NAPL-gas transport is OFF'
        endif
        close (13)
                                               return
                                               end
