C     Last change:  JG   25 Sep 2002    4:26 pm
        implicit double precision(a-h,o-z)
c
c-----------------------------------------------------------------
c THESE 2 PARAMETERS MUST REFLECT THE DIMENSION OF THE PROBELM
c-----------------------------------------------------------------
c
c maximum number of nodes in long dimension
                                         parameter (mnnd_l  = 41)
c maximum number of nodes in short dimension
                                         parameter (mnnd_s =  41)
c
c This parameter determines how flow BCs are specified
c Pressure condition - difference from static
c (=1, input pressure head)
c (=0, input total head)
                                         parameter (i_static = 1)
c
c-----------------------------------------------------------------
c
c DON'T CHANGE THE FOLLOWING STUFF
c
c-----------------------------------------------------------------
c global dimensions
        parameter (mnn          = mnnd_l   * mnnd_s )    
        parameter (mne          = (mnnd_l-1)   * (mnnd_s-1) )    
        parameter (mnnd         = mnnd_l )
        parameter (mnnd2        = mnnd_l*2 )
c
c max number df for flow and transport
        parameter (mdf     = 4*mnn )    
c
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c
c number of equations in the domain
        parameter (meq     =      4*mne)
c
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c FOR THE ITERATIVE SOLVER
c
c max number of matrix elements = 
c    4* ( 16*(# interior elements) + 12*(# midside elements) + 36)
        parameter (mme   =
     &           4* ( 16*((mnnd_s-1)-2)*((mnnd_l-1)-2)
     &              + 24*((mnnd_s-1) + (mnnd_l-1)-4) + 36 ) )
c
c Bi-CG/ILU
c  LENW >= NL+NU+8*N
       parameter (lenw  =  (mme + 9*meq)  )
c
c  LENIW >= NL+NU+4*N+12
       parameter (leniw =  (mme + 12 + 5*meq) )
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c
c-----------------------------------------------------------------
c-----------------------------------------------------------------
c-- given these parameters all vectors are defined ---------------
c-----------------------------------------------------------------
c
c mesh definition and node numbering
       dimension y(mnnd),x(mnnd),dx(mnnd-1),dy(mnnd-1), 
     &           nel(mnn,4)
       dimension norder(4), npt_gs(mnn), npt_s(mnn,2)
c
c boundary condition information
       dimension ib_x(mnnd2,2),iboa_x(mnnd2,2),ibog_x(mnnd2,2),
     &           ib_y(mnnd2,2),ibog_y(mnnd2,2),iboa_y(mnnd2,2)
c
       dimension ibc_p(mnn,4), ibc_s(mnn,4),
     &           ibc_oa(mnn,4), ibc_og(mnn,4)
c
c Hermite variables
       dimension  roa11(mnn,4),   roat(mnn,4),   roa_p(mnn,4),
     &            rog11(mnn,4),   rogt(mnn,4),   rog_p(mnn,4),
     &             pa11(mnn,4),   pat(mnn,4),
     &             sw11(mnn,4),   swt(mnn,4),
     &             st11(mnn,4),   stt(mnn,4)
c
c point source stuff (wells)
       dimension qw(mnn),qn(mnn),qg(mnn),qiow(mnn),qiog(mnn) 
c
c soil properties and adsorption
       dimension perm(mnn), por(mnn), p_ow(mnn)
c
c k-S-P model  definition
       dimension  nhc_w(mnn), nhc_t(mnn), 
     &            swt_c(mnn), sgt_c(mnn), snt_c(mnn),
     &               asd(mnn),    asi(mnn), shape(mnn),
     &              swr(mnn),   sgr(mnn),  snwr(mnn), snnr(mnn)
c
c coefficients in the PDE's
c
c flow variables
       dimension  dpcgn(mnn), dpcnw(mnn), pcnw1(mnn), pcgn1(mnn)
       dimension    rpn(mnn),   rpa(mnn),   rpg(mnn),
     &         vtx(mnn),   vty(mnn),  h_gw(mnn),h_gn(mnn),h_nw(mnn)
       dimension  vwx(mnn),vwy(mnn),vgx(mnn),vgy(mnn)
c      dimension  maddw(mnn), maddg(mnn)
c
c basis functions
       dimension b3(4,4,4),bx3(4,4,4),by3(4,4,4),bxx3(4,4,4),
     &          byy3(4,4,4),bxy3(4,4,4),
     &          b1(4,4),bx1(4,4),by1(4,4),b(4,4),wt(4),b11(4,2)
c
c basis functions
       common /bf3/ b3,bx3,by3,bxx3,byy3,bxy3
       common /bf3_1d/ b,wt,b11
       common /bf1/ b1,bx1,by1
c
c Hermite vectors
       common/p_w/        pa11,pat
       common/s_w/        sw11,swt
       common/s_t/        st11,stt
       common/conc/       roa11,roat,roa_p,rog11,rogt,rog_p
c
c boundary condition vectors 
       common/bv/         ib_x,ib_y,iboa_x,iboa_y,ibog_x,ibog_y
       common/eq_num/     ibc_p,ibc_s,ibc_oa,ibc_og
c
c dimensions - domain / subdomain
       common/space/   x,y,dx,dy
       common/ncon/    nel,npt_s,npt_gs,norder
       common/num_dir/ ixy,nequ,ncd,n_short,n_long
       common/dim/     nex,ney,nnx,nny,nex4,ney4,nnx4,nny4,nn
c
c simulation parameters (vectors)
       common/fun_trans/  vwx,vwy,vgx,vgy
       common/cap_press/      pcnw1,pcgn1
       common/fun_flow/   rpa,rpn,rpg,dpcnw,dpcgn
       common/fun_sat/    h_gw, h_gn, h_nw, vtx, vty
       common/peclet_c/   pe_w ,pe_g ,iphase
c
c source / sink vectors
       common/well_rate/  qw,qn,qg,qiow,qiog
c
c simulation parameters (scalars)
c
c time step control
       common /dtlim/  dslim,co
       common /dtctrl/  dt,dt0,dt_crit,
     &                  tdivh,tsmin,time,tmax,istop,iscr,itrf,
     &                  itrt,itrs,inc,n_opt,
     &                  ithangs,ithangg,ithangc,ihang,itermx
       common /dtctrl2/ tmult,tsmx,tdiv,itw_dt,itg_dt,itoa_dt,itog_dt,
     &                  itreds,itincs,itredc,itincc,itredg,itincg
c iteration data
       common /error/    erip,eris,eros,erit,erot
       common /er_norm/  ernp,erns,ernt,ixp,ixs,ixt
c
       common/exchange/ parow,bow_1, bow_2, bow_3,
     &                  parog,bog_1, bog_2, bog_3,
     &                  e_henry, bowg_1, bowg_2, bowg_3,
     &                  p_ow,decay,theta,ntr_ow,ntr_og
       common /fluid/  vw_r,vn_r,vg_r,rw_r,rn_r,rg_r,denw,
     &                 along,atran,diffw,diffg,pg_ref,d_layer
c
       common/lev_sc/       b_nw, b_gn, b_gw
c
c general
       common/soil/         perm, por
       common /xsect/  grav,thgx,thgy
       common/fdge/    epsil, nflag, mass, iout
c
c hysteresis definition
c
       common /s_p/  swr,snnr,snwr,sgr,shape,asd,asi
       common /k_s/  alfw,alfn,alfg,
     &               nsew1,nsew2, nseg1,nseg2, nsen1,nsen2,nsen3
       common /k_s_p/  se_sl,se_rl,sfact_kr
       common /hyst_p/ e_r,b_a,sp_min,sr_min,factd,facti,nhyst
       common/ksp/       swt_c,sgt_c,snt_c, nhc_w,nhc_t
c
c-----------------------------------------------------------------
       parameter (mloop        = 4 )
c-----------------------------------------------------------------
       dimension  sb_w(mnn,mloop),sb_t(mnn,mloop),
     &            ss_w(mnn,mloop),ss_t(mnn,mloop),
     &            sr_w(mnn,mloop),sr_t(mnn,mloop),
     &            a_w(mnn,mloop), a_t(mnn,mloop)
c trapping definition
       dimension  sw_mx(mnn), sg_mx(mnn), sn_mx(mnn),
     &            swt_mx(mnn),sgt_mx(mnn),snt_mx(mnn),
     &            swt_mn(mnn),sgt_mn(mnn),snt_mn(mnn)
c
       common/hyst/       sb_w,sr_w,ss_w,a_w,
     &                    sb_t,sr_t,ss_t,a_t,
     &                    sw_mx,sg_mx,sn_mx,
     &                    swt_mx,sgt_mx,snt_mx,
     &                    swt_mn,sgt_mn,snt_mn
c-----------------------------------------------------------------
c-----------------------------------------------------------------
c system of equations
       dimension  ri(meq), iwork(leniw), rwork(lenw), ai(mme)
       dimension sg_tmp(mnn,4), sol_g(meq)
       dimension sw_tmp(mnn,4), sol_w(meq)
c indexing vectors
       dimension inod(4), n_eq(4)
c
       common/solve/       ai,ri,rwork,iwork,inod,n_eq
       common/temp/       sol_w, sol_g, sw_tmp, sg_tmp
c
c BiCG pointer vectors
       dimension ja(mme),ia(mme)
       common /bicg/ ja, ia
c-----------------------------------------------------------------
c-----------------------------------------------------------------
