C     Last change:  JG   29 Aug 2000   12:32 pm
c**********************************************************************W
c 2-D 
c full 3-phase flow
c NAPL (pure phase) can dissolve in water and vaporize into gas
c Use decoupled approach
c for each time step first solve for total flow (pressure equation)
c then solve for dissolved and vapor NAPL concentrations
c then solve for Sw and Sg 
c
c   porous medium is inhomogeneous, isotropic
c   permeability is a scalar but variable in space
c   dispersion is a velocity dependent tensor
c   hysteretic k-S-P model with closed loops:
c           capillary hysteresis
c           hysteresis due to fluid entrapment
c-----------------------------------------------------------------------
c
c            - rectangular domains
c     using the collocation method with:
c            - cubic hermite polynomial basis functions
c            - solves 8 unknowns simultaneously
c            - system of equations is solved using
c                  iterative solver (GMRES/ILU)
c
c     code written by:
c            Joe Guarnaccia
c            University of Vermont
c            Dept. of Civil and Env. Eng.
c            213 Votey Building
c            Burlington VT 05405
c            email: guarnacc@emba.uvm.edu
c            revised, May, 1997
c***********************************************************************
c
        include 'include.f'
c
       dimension title(17)
c
c INPUT FILES
      open (1, file="sm.in")
      open (9, file='bc_flow.in')
      open (10, file='bc_roa.in')
      open (11, file='bc_rog.in')
      open (12, file='well.in')
c solution vectors
      open (22,file='sat.out')
      open (23,file='velw.out')
      open (24,file='veln.out')
      open (25,file='velg.out')
      open (26,file='velt.out')
c
      open (28,file='echo.out')
c
c     open (100,file='node.5')
c     open (101,file='node.10')
c     open (102,file='node.15')
c     open (103,file='node.20')
c     open (104,file='node.25')
c
c file # 13 is reserved for temporary input
c
         epsil = 1.d-08
c(1)
        read(1, 5) (title(i),i=1,17)
        WRITE(6, 5)(title(i),i=1,17)
    5  format(17a4)
c
c  which phases are to be modeled
c iphase = 12 - water and NAPL
c iphase = 13 - water and gas
c iphase = 123 - water , NAPL and gas
c(2)
      read(1,*) iphase
       if (iphase.ne.12.and.
     &      iphase.ne.13.and.
     &      iphase.ne.123)          then
             write(6,*) 'INPUT ERROR'
         write(6,*)'      SPECIFYING IPHASE - STOP (see input line 2)'
         stop
       endif
       if (iphase.eq.12)  then
             write(28,*) 'INPUT WARNING'
         write(28,*)'          2-PHASE NAPL-water  ONLY'
       endif
       if (iphase.eq.13)  then
             write(28,*) 'INPUT WARNING'
         write(28,*)' 2-PHASE gas-water  ONLY'
       endif
       if (iphase.eq.123)  then
             write(28,*) 'INPUT WARNING'
         write(28,*)'3-PHASE NAPL-gas-water is on'
       endif
c output iteration info to the screen? (iscr=1 = yes)
c(3)
      read(1,*) iscr     
c output nodal Hermite data at print interval( herm = 1 = yes)
c(4)
      read(1,*) iherm 
        if (iherm.eq.1) then
c       open Hermite output files
            open (2, file='sw.out')
            open (3, file='st.out')
            open (4, file='pa.out')
            open (7,file='oa.out')
            open (8,file='og.out')
        endif
c do mass balance calculations ( mass = 1 = yes)
c(5)
      read(1,*) mass 
        if (mass.eq.1) then
c       open mass balance output files
              open (14,file='mass.out')
              open (15,file='massw.out')
              open (16,file='masso.out')
              open (17,file='massg.out')
              open (19,file='masst.out')
              open (18,file='cmass.out')
        endif
c
c number of elements in each direction
c(6)
      read(1,*) nex,ney
c 
      nex4 = 4*nex
      ney4 = 4*ney
      nnx  = nex+1
      nny  = ney+1
      nnx4 = nnx*4
      nny4 = nny*4
      nn   = nnx*nny
      nd   = 4*nn
      ne   = nex*ney
      nc   = 4*(nn-ne)
      n    = nd-nc
c
c     nequ - number of unknowns in domain after bc's removed
          nequ = 4*(nnx - 1)*(nny - 1)
c
c          given the partition and the size of the subdomains
c          we want to number in the shortest dimension first
c     norder() = map from shortest numbering direction first to y-x
c                numbering for an element for use in system matrix
c                assembly
c
                       norder(1) = 1
                       norder(4) = 4
c
c ixy references the subdomain shortest direction
c
            if(nny.le.nnx)  then
               ixy     = 2
               n_short = nny
               n_long  = nnx
                       norder(2) = 2
                       norder(3) = 3
            else
               ixy    = 1
               n_short = nnx
               n_long  = nny
                       norder(2) = 3
                       norder(3) = 2
            endif
c
c     ncd - number of co-diagonals for the system matrix (upper=lower)
c
               ncd = 2*n_short + 3
c
c set up ponter array to map between x and y sweeps
c the global vectors are numbered in y-direction first by default
          call point
c
c set up element connectivity list
          call relem
c
c START TIME STEP CONTROL INPUT
c        t1pr= time to first print
c        tmprnt= time increment to print after t1pr
c        tmax= maximum time for simulation
c        itinc_ = minimum iterations to increase time step
c                 one for each d. v. 
c        tmult= increment to increase
c        itred_ = maximum iterations to decrease time step
c                 one for each d. v. 
c        tdiv= increment to decrease time step after too many iter.
c        ithang_ = convergence is hung up for degree of freedom
c                 one for each d. v. 
c        itermx - if any of the df's take this many iterations, STOP
c        tdivh= increment to decrease time step after hang-up
c        time = starting time (may be different than zero)
c(7) through (12)
      read(1,*) time             
      read(1,*) t1pr,tmprnt, tmax 
            tmpr=t1pr+time
            iprnt = 0
      read(1,*) itincs,itincc,tmult
      read(1,*) itreds,itredc,tdiv
      read(1,*) ithangs,ithangc,tdivh
      read(1,*) itermx
c
      itincg = itincs
      itredg = itreds
      ithangg = ithangs
c      dslim - the max change in effective Sw solution over time step
c
c      co    - Courant constraint for dt control
c (13)
      read(1,*) dslim
c (14)
      read(1,*) co
c
c      dt0= initial time step for simulation
c (15)
      read(1,*) dt0
c      dtt= dummy variable used to calc. avg. time step 
            dtt = 0.d0
            dt = dt0
            inctot = 0
c
c      tsmx= max time step
c      tsmin= min time step
c
c (16)
      read(1,*) tsmx,tsmin
c
c END TIME STEP CONTROL INPUT
c
c GRAPHICS OUTPUT CONTROL (JACQUARD)
c       ngrf_on = 1 then graphics is on, =0 then off
c       grinc - time increment to print
c       ngrch - number of prints before change grinc
c       fgrch - factor to multiply grinc
c       gmax  - maximum grinc
c (17)
      read(1,*) ngrf_on, gr_inc, ngrch, fgrch, gmax
             iinc = 0
             ngrf = ngrch
             grinc = gr_inc
             tgrf = time + grinc
c
c ITERATION ITERATION CONVERGENCE
c       inner = number of iterations between Pw and Sw over a time step
c (18)
      read(1,*) inner
c
c      error tolerance is given in terms of % of the dependent variable
c      erip= GMRES error tolerance for Pw
c      eris= GMRES error tolerance for Sw
c      eros= NL  error tolerance for   Sw
c      erit= GMRES error tolerance for Concentration
c      erot= NL error tolerance for Concentration
c
c (19)
      read(1,*) erip
c (20)
      read(1,*) eris,eros
c (21)
      read(1,*) erit,erot
c
c-----------------------------------------------------------------
c     node coordinates
c read idxdy, if =1 then read indiv. values , else equal grid spacing
c	and you have to read in xmax and ymax.
c (22)
        read(1,*) idxdy
c
             open (13, file='space.in')
             if (idxdy.eq.1)         then
c
             read(13,*) (x(i), i=1,nnx)
             read(13,*) (y(i), i=1,nny)
c
              xmax=x(nnx)
              ymax=y(nny)
        else
c              equal grid spacing , read in xmax and ymax
               read(13,*) xmax,ymax
                   xnex=nex
                   yney=ney
                   dxx=xmax/xnex
	           dyy=ymax/yney
	           x(1)=0.d0
	           y(1)=0.d0
                        do 21 j=2,nnx
                                xj=j-1
                                x(j)=xj*dxx
   21                   continue
                        do 22 j=2,nny
                                yj=j-1
                                y(j)=yj*dyy
   22                           continue
	endif
                  close (13)
c
c element width
      do j=1,nex
         dx(j)=x(j+1)-x(j)
      enddo
      do k=1,ney
         dy(k)=y(k+1)-y(k)
      enddo
c
c------------------------------------------------------------------
c            parameters
c------------------------------------------------------------------
c        gravity - g
c        thg - grid rotation ccw to horizontal
c              pivot on node 1
c        x-direction is vertical, positive is down
c        y-direction is horizontal
c
c (23)
          read (1,*) g
c (24)
          read (1,*) thg
c
              thgx = thg*datan(1.d0)/45.d0
              thgy = (90.d0 + thg)*datan(1.d0)/45.d0
                 grav = g
c     permeability scalar  [L/T]
c (25)
        read (1,*) permb
                 do 25 j=1,nn
                   perm(j) = permb
   25            continue
c (26)
        read (1,*) ndev
          if (ndev.ne.0) then     
                  open (13,file='perm.in') 
                  do 26 j=1, ndev
                   read(13,*) nde,p_b   
                   perm (nde) = p_b   
   26            continue
                close (13)
         endif 
c porosity
c (27)
          read (1,*) porb 
          do 27 j=1,nn
            por(j) = porb
   27     continue
c
c (28)
          read (1,*) ndev
          if (ndev.ne.0) then     
                open (13,file='por.in') 
                do 28 j=1, ndev
                      read(13,*) nde,poros 
                      por(nde) = poros 
   28          continue
                close (13)
          endif 
c
c           area of of the system
                    area=xmax*ymax
c
c bulk density [M/L^3] (= (1-poro)*soil density)
c (29)
          read (1,*) bulkb
          do 29 j=1,nn
            p_ow(j) = bulkb
   29     continue
c
c (30)
          read (1,*) ndev
           if (ndev.ne.0) then
                open (13,file='bulk.in')
                do 30 j=1, ndev
                      read(13,*) nde,bulk
                      p_ow(nde) = bulk
   30          continue
                close (13)
          endif
c
c
c FLUID PROPERTIES
c        read in viscosity of pure water (vw_r)
c                             pure NAPL (vn_r)
c                             pure gas (vg_r)
c        [FT/(L*L]
c (31)
      read(1,*) vw_r,vn_r,vg_r
c
c       density of the fluids [M/vol]
c                             pure water (rw_r)
c                             pure NAPL (rn_r)
c                             pure gas (rg_r)
c (32)
      read(1,*) rw_r,rn_r,rg_r
c
           denw = g*rw_r
c
c interfacial tension data [L*L/F]
c    siggw = interfacial tension between gas and water
c    signw = interfacial tension between NAPL and water
c    siggn = interfacial tension between gas and NAPL
c
c (33)
      read(1,*) siggw, signw, siggn
c
c    define system which was measured
c (34)
      read(1,*) n_phase
c
c compute the scaling parameters
c      s.t.    Pcgw = Pcgn + Pcnw
c          and Pcgw/siggw = Pcnw/signw = Pcgn/siggn
c
c          and b_gw*Pcgw = b_nw*Pcnw = b_gn*Pcgn
c
       if(n_phase.eq.1)  then
c          W-G system measured
           b_gn = ( siggn + signw ) / siggn
           b_nw = ( siggn + signw ) / signw
           b_gw = 1.d0 
       else if(n_phase.eq.2)  then
c          N-W system measured
           b_gw = ( siggw - siggn ) / siggw
           b_gn = ( siggw - siggn ) / siggn
           b_nw = 1.d0 
       else if(n_phase.eq.3)  then
c          G-N system measured
           b_gw = ( siggw - signw ) / siggw
           b_nw = ( siggw - signw ) / signw
           b_gn = 1.d0 
       else
c          error
             write(6,*) 'INPUT ERROR'
           write(6,*) 'INCORRECT INPUT FOR 2-PHASE SYSTEM MEASURED'
           stop
       endif
c
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c k-S-P MODEL DEFINITION
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c
c     read in the cap press - sat relation for base soil (permb, porb)
c     and assume that the date was obtained from a water - gas system
c
c swr = water residual
c snnr = NAPL - water residual (NAPL as a non-wetting phase)
c snwr = NAPL - gas residual   (NAPL as a     wetting phase)
c sgr = gas residual
c
c (35)
       read(1,*) swrb,snnrb,snwrb,sgrb
c     allow swr,snnr,snwr,sgr to be spatially variable
                     do  31 j = 1, nn
                       swr(j) = swrb
                       sgr(j) = sgrb
                       snnr(j) = snnrb
                       snwr(j) = snwrb
   31                continue
c number of deviations from the global residual saturation 
c (36)
       read(1,*) ndev
         if(ndev.gt.0)  then
                open (13,file='residual.in')
                do  32 j = 1, ndev
                      read(13,*) nde, swrb, snnrb, snwrb, sgrb
                       swr(nde)  = swrb
                       sgr(nde)  = sgrb
                       snnr(nde) = snnrb
                       snwr(nde) = snwrb
   32          continue
                close (13)
         endif
c
c asd= drainage curve shape parameter
c asi= imbibition curve shape parameter
c shape= curve shape parameter
c
c (37)
       read(1,*) asdb, asib, etab
c     allow asd, asi  and eta to be spatially variable
                     do  33 j = 1, nn
                       asd(j) = asdb
                       asi(j) = asib
                       shape(j) = etab
   33                continue
c number of deviations from the global asd and asi values
c (38)
       read(1,*) ndev
         if(ndev.gt.0)  then
                open (13,file='shape.in')
                do  34 j = 1, ndev
                      read(13,*) nde, asdb, asib, etab
                      asd(nde) = asdb
                      asi(nde) = asib
                    shape(nde) = etab
   34          continue
                close (13)
         endif
c
c read in the base soil properties upon which the alpha's were measured
c (39)
       read(1,*) permb, porb
c scale the alpha's given the actual soils
             do  35 j=1,nn
                asd(j) = asd(j)*dsqrt(permb/perm(j)*por(j)/porb)
                asi(j) = asi(j)*dsqrt(permb/perm(j)*por(j)/porb)
   35        continue
c number of deviations from the global base soils
c (40)
       read(1,*) ndev
         if(ndev.gt.0)  then
                open (13,file='base.in')
                do  36 j=1, ndev
                      read(13,*) nde,perm_b, por_b
                asd(nde) = asd(nde)/dsqrt(permb/perm(nde)*por(nde)/porb)
     &                         *dsqrt(perm_b/perm(nde)*por(nde)/por_b)
                asi(nde) = asi(nde)/dsqrt(permb/perm(nde)*por(nde)/porb)
     &                         *dsqrt(perm_b/perm(nde)*por(nde)/por_b)
   36          continue
                close (13)
         endif
c
c alfw = power for Krw connectivity term
c alfn = power for Kro connectivity term
c alfg = power for Krg connectivity term
c (41)
       read(1,*) alfw, nsew1, nsew2
              if (nsew2.ne.1.and.nsew2.ne.2) then
                 write(6,*) 'INPUT ERROR LINE # 41'
                 stop
              endif
              if (nsew1.ne.1.and.nsew1.ne.2) then
                 write(6,*) 'INPUT ERROR LINE # 41'
                 stop
              endif
c (42)
       read(1,*) alfn, nsen1, nsen2, nsen3
              if (nsen1.ne.1.and.nsen1.ne.2) then
                 write(6,*) 'INPUT ERROR LINE # 42'
                 stop
              endif
              if (nsen2.ne.1.and.nsen2.ne.2.and.nsen2.ne.3) then
                 write(6,*) 'INPUT ERROR LINE # 42'
                 stop
              endif
              if (nsen3.ne.1.and.nsen3.ne.2.and.nsen3.ne.3) then
                 write(6,*) 'INPUT ERROR LINE # 42'
                 stop
              endif
c (43)
       read(1,*) alfg, nseg1, nseg2
              if (nseg2.ne.1.and.nseg2.ne.2) then
                 write(6,*) 'INPUT ERROR LINE # 43'
                 stop
              endif
              if (nseg1.ne.1.and.nseg1.ne.2) then
                 write(6,*) 'INPUT ERROR LINE # 43'
                 stop
              endif
c
c linearize the the S-P functional at the endpoints
c at Se = 1
c se_sl = if se > (1-se_sl) linearize
c at Se = 0
c se_sr = if se < se_sr linearize
c
c sfact_kr = if sw >= [(1-Sor) - sfact_kr], then Kro = 0
c            if sw <= [Swr + sfact_kr], then Krw = 0
c(44)
       read(1,*) se_sl, se_rl
c(45)
       read(1,*) sfact_kr
c
c*********************
c HYSTERESIS PARMETERS (only important when nhyst = 1)
c hysteresis on? (1=yes)
c(46)
       read(1,*) nhyst             
c
c e_r   = power for entrapment and release
c
c b_a   =  blending parameter for the variable S-P curve 
c          shape parameter asd,asi
c (47)
       read(1,*) e_r
c (48)
       read(1,*) b_a
c
c sp_min  = smallest span of an S-P curve allowed
c sr_min  = min delta change to start considering S-P reversals
c (49)
       read(1,*) sp_min, sr_min
c
c      fact_ = Sw tolerance to switch drainage paths
c (50)
      read(1,*) factd,facti
c
c*********************
c      pe     = Peclet number for multiphase flow: pe > 0    
c (51)
      read(1,*) pe_w, pe_g
c
c===================================
c      pg_ref     = reference pressure of the gas phase
c (52)
      read(1,*) pg_ref
c
c===================================
c CONTAMINANT TRANSPORT AND MASS EXCHANGE STUFF
c
c      ntr_ow = mass exch on (=1) off (=0) for oil - water
c      ntr_og = mass exch on (=1) off (=0) for oil - gas
c (53)
      read(1,*)ntr_ow, ntr_og
          if (ntr_ow.ne.1 ) then
             write(28,*) 'INPUT WARNING'
          write(28,*) ' Dissolved NAPL transport is OFF'
          endif
          if (ntr_og.ne.1 ) then
             write(28,*) 'INPUT WARNING'
          write(28,*) ' NAPL Vapor transport is OFF'
          endif
c
c      theta  = projection for Roa to Rog mass exchange
c
c (54)
      read(1,*) theta
c     dispersion tensor = input dispersivities [L] 
c     and diffusion coefficient [L*L/T]
c
c (55)
      read (1,*) along,atran,diffw,diffg
c
c     adsorption coefficient = p_oc*f_oc
c     p_oc = organic carbon partition coefficient
c     f_oc = fraction of organic carbon in the soil (scalar)
c (56)
      read (1,*) p_oc, focb
                do  40 j=1, nn
                      p_ow(j) = p_ow(j)*focb*p_oc
   40          continue
c number of deviations from the global f_oc values
c (57)
       read(1,*) ndev
         if(ndev.gt.0.and.ntr_ow.eq.1)  then
                open (13,file='o_c.in')
                do  41 j=1, ndev
                      read(13,*) nde,f_oc
                      if (focb.gt.epsil) then
                          p_ow(nde) = f_oc*p_ow(nde)/focb
                      else
                          p_ow(nde) = f_oc*p_ow(nde)
                      endif
   41          continue
                close (13)
         endif
c
c read in the thickness of the top boundary layer
c which defines the Rog eq. 3 rd type bc
c (58)
      read (1,*) d_layer
c
c   define mass exchange kinetics of NAPL in NAPL to water
c      parow = constant molar partition coefficient
c     bow_1, bow_2, bow_3 = defines rate coefficient
c (59)
      read(1,*)bow_1, bow_2, bow_3 
c (60)
      read(1,*)parow
         if(ntr_ow.ne.1)  then
             parow = 0.d0
             bow_1 = 0.d0
         endif
c   define mass exchange kinetics of NAPL in NAPL to gas
c      parog = constant molar partition coefficient 
c     bog_1, bog_2, bog_3 = defines rate coefficient
c (61)
      read(1,*)bog_1, bog_2
            bog_3 = bow_3
c (62)
      read(1,*)parog
         if(ntr_og.ne.1)  then
             parog = 0.d0
             bog_1 = 0.d0
         endif
c   define mass exchange kinetics of NAPL in water to gas
c      e_henry = Henrey's law coefficient
c     bowg_1, bowg_2, bowg_3 = defines rate coefficient
c (63)
      read(1,*)bowg_1, bowg_2
         bowg_3 = bow_3
c (64)
      read(1,*)e_henry
         if(ntr_og.ne.1.or.ntr_ow.ne.1)  then
             bowg_1 = 0.d0
         endif
c
c 1/2 life  coefficient [T]
c (65)
      read(1,*) t_half  
           if (t_half.lt.epsil) then
             decay = 0.0d0
           else
             decay = dlog(2.d0)/t_half
           endif
c--------------------------------------------------------------
cxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
c     initial conditions-  setup vectors for                      x
c		1-  Pw
c		2-  Sw
c		3-  St
c		3-  concentration 
c  two vectors representing inintial time and last iterate        x
c           11=  n+1,m    known					  x
c            t=  n        known  				  x
cxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
c set up initial conditions for static conditions or
c use previous run for the ic's
                nflag = 0
c (66) through (73) are in subroutine icset
                call icset 
c
c   set functions of Sw and St given initial data
                call flow_fun
cxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
c
c output grid and soil information for graphics - GMS V 2.1
              if (ngrf_on.eq.1)  then
c              graphics files
c
               call gms_set
c
              endif
c
cxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
c
c set up Hermite bicubic basis functions at orthogonal points
         call basis_2d
         call basis_1d
c
cxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
c           pore volume of the system
        call pore_vol (pv1)
c
c     print information
        call echo(xmax,ymax,nd,nc,n,area,pv1,g,thg,title,
     &            siggw, signw, siggn)
c
cxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
c@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
c BOUNDARY CONDITION STUFF
c Pw, Sw, and concentrations bc's - default -- neumann everywhere
c
                new_stress = 0
  599       call bcset
c xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
c
c boundary conditions which are different from no flux
c
c read in Dirichlet conditions
c NOTE: non zero flux bc's are replaced by point source/sink terms
c set up flow and transport separately
c --------------------------------------------------------------
c ncondc = number of Dirichlet Row bc's 
c ncondf = number of Dirichlet flow bc's
c 
c===================================
c TRANSPORT DIRICHLET DATA 
c conditions for Roa
c (74)
      read(1,*)nbcroa
       if(nbcroa.gt.0.and.ntr_ow.eq.1)   then
c         get information from file bc_roa.in
c                -------------
                 call bc_oa(nbcroa)
c                -------------
       endif
c set up degree of freedom numbering for each subdomain: ibc_oa
c  ibc_oa (numbered in the shortest directions first)
                call df_num_oa
c
c conditions for Rog
c (73)
      read(1,*)nbcrog
       if(nbcrog.gt.0.and.ntr_og.eq.1)   then
c         get information from file bc_rog.in
c                -------------
                 call bc_og(nbcrog)
c                -------------
       endif
c set up degree of freedom numbering for each subdomain: ibc_og
c  ibc_og (numbered in the shortest directions first)
                call df_num_og
c
c FLOW DIRICHLET DATA               
c (74)
      read(1,*)ncondf
       if(ncondf.gt.0) then
c         get information from file bc_flow.in
c                -------------
                 call bc_flow(ncondf)
c                -------------
       endif
c set up degree of freedom numbering for each subdomain: 
c  ibc_p (numbered in the shortest directions first)
c  ibc_s (numbered in the shortest directions first)
                call df_num_p
                call df_num_s
c
c--------------------------------------------------------------
c
c input well conditions
c set up to inject or extract total fluid rate  qt
c where qt = qw*fw + qo*fo
c where fw and fo are the fractional flow functions 
c if fo in nonzero then assume inject dissolved density = parow
c nwella = number of well conditions
c
c (77)
      read(1,*)nwella
       if(nwella.gt.0)   then 
c         get information from file well.in
c                -------------
                 call point_source (nwella)
c                -------------
c      make outflow wells compatible with ic's
                 call qout
       endif
c
c DEFINE NEW STRESS PERIOD
c   timec = time to change the bc's just prescribed
c   iphase = the new initial dt
c            which phases are to be modeled
c                  = 12 - water and NAPL
c                  = 13 - water and gas
c                  = 123 - water , NAPL and gas
c   dtnew = the new initial dt
c   dtmax = the new max dt
c   co_new    = the new Courant constraint
c
c(78)
       read(1,*)  timec,iph_new,dtnew,dtmax,co_new
c      if (iph_new.eq.12)  then
c            write(28,*) 'INPUT WARNING'
c        write(28,*)' 2-PHASE NAPL-water  ONLY for next stress period'
c      endif
c      if (iph_new.eq.13)  then
c            write(28,*) 'INPUT WARNING'
c        write(28,*)' 2-PHASE gas-water  ONLY for next stress period'
c      endif
c      if (iph_new.eq.123)  then
c            write(28,*) 'INPUT WARNING'
c      write(28,*)' 3-PHASE NAPL-gas-water is on for next stress period'
c      endif
c
       if (iph_new.ne.12.and.
     &      iph_new.ne.13.and.
     &      iph_new.ne.123)          then
             write(6,*) 'INPUT ERROR'
         write(6,*)'SPECIFYING NEW IPHASE - STOP (see input line 75)'
         stop
       endif
cxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
c     x        INPUT HAS BEEN ACCOMPLISHED          x
cxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
c
c INITIALIZE ALL VECTORS
c     set f(saturation) for total flow
         call flow_fun
c
      if (mass.eq.1)  then
c  see what the starting mass is
        if(new_stress.eq.0) then
c         initial start-up or continuation after stop
c-------------------------------------------------------------------
            call mbal (tmoa,tmwa,tmon,tmog,tmgg)
c-------------------------------------------------------------------
         else
c           change conditions on the fly, save computed actual mass 
            tmwa = tmiwa + cvwa
            tmon = tmion + cvon
            tmoa = tmioa + cvoa
            tmog = tmiog + cvog
            tmgg = tmigg + cvgg
            tiwpm = tiwpm + chbcw
            tiopm = tiopm + chbco
            tigpm = tigpm + chbcg
            new_stress = 0
         endif
c
c prefix  tm = total mass of a species in the domain
c         tmi = total species mass in the domain at time 0            
c         tmt = total species mass in the domain before the time step
c          suffix = species of interest
c                   oa = oil in water
c                   wa = water in water
c                   on = oil in oil
c                   og = oil in gas
c                   gg = gas in gas
c                   a= water
c                   n= NAPL
c                   g= gas 
c      tiwpm = total water phase mass in the domain before the time step
c      tiopm = total oil phase mass in the domain before the time step
          tiwpm = tmwa
          tiopm = tmoa + tmon + tmog
          tigpm = tmgg
        write (14,945)tmwa,tmon,tmgg,tmoa,tmog,tiwpm,tiopm,tigpm
  945       format('INITIAL:'/
     *             'water in water species:             ',15x,0pe15.8/
     *             'oil in oil species:                 ',15x,0pe15.8/
     *             'gas in gas species:                 ',15x,0pe15.8/
     *             'oil in water species:               ',15x,0pe15.8/
     *             'oil in gas species:                 ',15x,0pe15.8/
     *             '   WATER species mass is:           ',15x,0pe15.8/
     *             '   NAPL species mass is:            ',15x,0pe15.8/
     *             '   GAS species mass is:             ',15x,0pe15.8)
        tmiwa = tmwa
        tmioa = tmoa
        tmion = tmon
        tmiog = tmog
        tmigg = tmgg
                    tmtwa = tmwa
                    tmtoa = tmoa
                    tmton = tmon
                    tmtog = tmog
                    tmtgg = tmgg
c
        write (15,*)'TIME     - M in - M out - DM actual - DM calc - R'
        write (16,*)'TIME     - M in - M out - DM actual - DM calc - R'
        write (17,*)'TIME     - M in - M out - DM actual - DM calc - R'
c initialize mass balance parameters
                cviwa=0.d0
                cvowa=0.d0
                cvioa=0.d0
                cviog=0.d0
                cvigg=0.d0
                cvooa=0.d0
                cvion=0.d0
                cvoon=0.d0
                cvoog=0.d0
                cvogg=0.d0
              chbwa = 0.d0           
              chboa = 0.d0           
              chbon = 0.d0           
              chbog = 0.d0           
              chbgg = 0.d0           
              chbtw = 0.d0           
              chbto = 0.d0           
              chbtg = 0.d0           
              flxtiw = 0.d0           
              flxtow = 0.d0           
              flxtio = 0.d0           
              flxtoo = 0.d0           
              flxtig = 0.d0           
              flxtog = 0.d0           
      endif
cxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
c  begin calculations!!!!!!!!!!!!!!!!!!!!
c-----------------------------------------------------------------
c
c initialize time step and iteration parameters
                inc = 0
                itt = 0
                itf = 0
                itw = 0
                itg = 0
                ihang = 0
c
c==================================================================
c loop 201 does all the work from now on
c solution procedure - define the phase composition apriori to 
c calculating the phase distributions. given the saturation
c distributions, evaluate the transport. Revise the composition
c vector and recompute the pressures. Revise the composition.
c Repeat until convergence is obtained.
c___________________________________________________________________
c  -------- sequential flow equation solution-----------
c___________________________________________________________________
c
c
  201       call fun_at_n
c
                istop = 0
                itf_dt = 0
  501           itw_dt = 0
                itg_dt = 0
                itoa_dt = 0
                itog_dt = 0
                icutw = 0
                icutt = 0
                ixs = 0
                ixt = 0
c
          do 505 nloop = 0,inner
           if (nloop.gt.0)   then
c     UPDATE SATURATION AND COMPOSITION DEPENDENT FORCINGS
c            FOR THE NEXT INNER ITERATION
c ^^^^^^^^^^^^  
c  ****       flow conditions 
                             call bc_up 
c
c  ****       outflow point sources 
c
                             call qout
           endif
c
c=================================================================
c SOLVE THE FLOW PROBLEM
c=================================================================
c
c%%%
c SOLVE FOR PRESSURE given all functions of saturation 
c%%%
c
c linear equation - direct solve
c
c if istop = 2, then there was a hangup in either the saturation
c solver or the transport solver , 
c its a restart, but don't recompute Pw
c
        if (istop.ne.2)   then
c         ^^^^^^^^^^^^  
                iterf = 0
c
            call pw_sol (iterf)
c
                itf_dt = itf_dt + iterf
c         ^^^^^^^^^^^^  
             if(inc.gt.0.and.iterf.gt.itermx.or.istop.eq.1) then
c can't converge on Pw in a reasonable number of iterations
c so stop 
                      time = tmax 
                      go to 490
             endif
             if(iterf.gt.itermx) then
             write(6,*) 'ITERATION ERROR'
             write(6,*) 'VIOLATE itermx during PRESSURE solver'
             write(6,*) 'PRINT SOLUTION AND THEN STOP'
                write(6,*)  time
                      time = tmax 
                      go to 490
             endif
c%%%
c given the pressure solution calculate the total velocity
c
            call v_tot
            call pr_bc
                     call vel_w
                     call vel_g
            call mp_diff
c%%%
        endif
c
c=================================================================
c TRANSPORT SOLUTIONS   ===========
c=================================================================
c
         if(ntr_ow.gt.0 .or. ntr_og.gt.0 )     then
c TRANSPORT IS ON 
               istop = 0
               iter_oa = 0
               iter_og = 0
c
cxxxxxxxxxxx       xxxxxxxxxxx        xxxxxxxxxxxxx
              call tran_sol (iter_oa,iter_og)
cxxxxxxxxxxx       xxxxxxxxxxx        xxxxxxxxxxxxx
                itoa_dt = itoa_dt + iter_oa
                itog_dt = itog_dt + iter_og
c
               if (istop.eq.2)  then
c                restart the time step
                     call restrt 
                    if (istop.eq.5)  then
c                     the computation CRASHED
                      go to 490
                    else 
c                     istop = 0
                      go to 501
                    endif
               endif
         endif
c=================================================================
c%%%
c SOLVE FOR SATURATION given Pw and conc
c the saturation equation is non-linear
c
c         ^^^^^^^^^^^^  
                istop = 0
                iterg = 0
                iterw = 0
c
            call sat_sol (iterw,iterg)
c         ^^^^^^^^^^^^  
                itg_dt = itg_dt + iterg
                itw_dt = itw_dt + iterw
c            if(iterg.gt.ithangs.or.istop.eq.2) then
             if(istop.eq.2 .or.   
     &          iterw.gt.ithangs+1.or.iterg.gt.ithangs+1) then
c                restart the time step
                     call restrt 
                    if (istop.eq.5)  then
c                     the computation CRASHED
                      go to 490
                    else 
c                     istop = 0
                      go to 501
                    endif
             endif
             if(istop.eq.3) then
c                restart the time step
                      istop = 2
                      go to 501
             endif
c
  505        continue
c-------------------------        ----------------------------------
c------------------------- output ----------------------------------
c-------------------------        ----------------------------------
c-------------------------------------------------------------------
c we have converged on a time step
  490       time = time+dt
             inc = inc + 1
             inctot = inctot + 1
                 itf = itf + itf_dt
                 itw = itw + itw_dt
                 itg = itg + itg_dt
                 itoa = itoa + itoa_dt
                 itog = itog + itog_dt
c calc max time step so far for grneral interest only
         if (dt.gt.dtt) dtt = dt
c
        if (iscr.eq.1) then
               write(6,*)
             write(6,*) '  elapsed time  time step (dt_crit)' 
               write(6,*)  time,dt,dt_crit
               write(6,933) ihang,inctot
               write(6,*)
  933       format(1x,i5,5x,i5,5x,2(i5))
        endif
c
c ^^^^^^^^^^^^  
c
        if ( mass.eq.1 )   then
c       ---------------------------------------------
c       MASS BALANCE CALCULATIONS
c       ---------------------------------------------
c       from point sources and sinks
c  over this time step:
c          prefix flxo = outgoing species mass over boundary
c                 flxi = incoming species mass over boundary
c                 flxti = incoming summed species mass over boundary
c                 flxto = outgiong summed species mass over boundary
c                 qti = incoming summed species mass through wells 
c                 qto = outgiong summed species mass through wells 
c                 cvi = cumulative species mass in over boundary
c                 cvo = cumulative species mass out over boundary
c                 cv  = cumulative change in species mass over boundary
c      chb  = change in species mass over bdy. for this dt(- = loss)
c      chbt = change in summed species mass over bdy. for this dt
c      chq  = change in species mass through wells for this dt(- = loss)
c      chqt = change in summed species mass through wells for this dt
c      chbc = cumulative change in summed species mass over bdy.
c
c          suffix = species of interest
c                   oa = oil in water
c                   wa = water in water
c                   on = oil in oil
c                   w = water phase  
c                   o = oil phase  
c
              flxtiw = 0.d0
              flxtow = 0.d0
              flxtio = 0.d0
              flxtoo = 0.d0
              flxtig = 0.d0
              flxtog = 0.d0
              chbwa = 0.d0
              chboa = 0.d0
              chbon = 0.d0
              chbog = 0.d0
              chbgg = 0.d0
              chbtw = 0.d0
              chbto = 0.d0
              chbtg = 0.d0
c
c        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
             call well_mass(cviwa,cvioa,cvion,cviog,cvigg,
     &                         cvowa,cvooa,cvoon,cvoog,cvogg,
     &                      chqwa,chqoa,chqon,chqog,chqgg,
     &                      chqtw,chqto,chqtg,
     &                      qtiw,qtow,qtio,qtoo,qtig,qtog)
c
c        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
c
c          mass over the boundaries
c
        if (ncondf.ne.0) then
c          should be all the Dirichlet nodes for this problem
c        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
            call mbalb(flxowa,flxiwa,flxoon,flxion,flxooa,flxioa,
     &                 flxoog,flxiog,flxogg,flxigg)
c        ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
c SEPARATE SPECIES
              cviwa = cviwa + flxiwa
              cvioa = cvioa + flxioa
              cvion = cvion + flxion
              cviog = cviog + flxiog
              cvigg = cvigg + flxigg
              cvowa = cvowa + flxowa
              cvooa = cvooa + flxooa
              cvoon = cvoon + flxoon
              cvoog = cvoog + flxoog
              cvogg = cvogg + flxogg
              cvwa = cviwa - cvowa 
              cvoa = cvioa - cvooa 
              cvon = cvion - cvoon 
              cvog = cviog - cvoog 
              cvgg = cvigg - cvogg 
              chbwa = flxiwa - flxowa
              chboa = flxioa - flxooa
              chbon = flxion - flxoon
              chbog = flxiog - flxoog
              chbgg = flxigg - flxogg
c SUMMED SPECIES
              chbtw = chbwa 
              chbto = chboa + chbon  + chbog 
              chbtg = chbgg 
              chbcw =  cvwa 
              chbco =  cvoa +  cvon  +  cvog 
              chbcg =  cvgg 
              flxtiw = flxiwa 
              flxtow = flxowa
              flxtio = flxioa + flxion + flxiog
              flxtoo = flxooa + flxoon + flxoog
              flxtig = flxigg 
              flxtog = flxogg
c
        endif
c@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
c change due to wells and boundary
              chbwa = chbwa + chqwa
              chboa = chboa + chqoa
              chbon = chbon + chqon
              chbog = chbog + chqog
              chbgg = chbgg + chqgg
c
              chbtw = chbtw + chqtw
              chbto = chbto + chqto
              chbtg = chbtg + chqtg
              flxtiw = flxtiw + qtiw
              flxtow = flxtow + qtow
              flxtio = flxtio + qtio
              flxtoo = flxtoo + qtoo
              flxtig = flxtig + qtig
              flxtog = flxtog + qtog
c@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
c--------------------------------------------------------------------
c interior mass balance calculation                                
c-------------------------------------------------------------------
           call mbal (tmoa,tmwa,tmon,tmog,tmgg)
c-------------------------------------------------------------------
c------------------=============================--------------------
c       the change in mass over this time step
c          prefix chi = change in mass on interior over this dt(-=loss)
c                 chc = cumul change in mass on interior
c                 chit = change in phase mass on interior 
c                 tmt = save as mass bfore the next time step
c
         chiwa = tmwa - tmtwa
         chioa = tmoa - tmtoa
         chion = tmon - tmton
         chiog = tmog - tmtog
         chigg = tmgg - tmtgg
          chcwa = tmwa  - tmiwa
          chcoa = tmoa  - tmioa
          chcon = tmon  - tmion
          chcog = tmog  - tmiog
          chcgg = tmgg  - tmigg
              chitw = chiwa 
              chito = chioa + chion  + chiog 
              chitg = chigg 
          tmtwa = tmwa  
          tmtoa = tmoa  
          tmton = tmon  
          tmtog = tmog  
          tmtgg = tmgg  
c         total summed species mass
          twsm = chcwa 
          tosm = chcoa + chcon + chcog
          tgsm = chcgg 
c
c ----------        -----------        ------------      ----------
c           --------           --------            ------
c ----------        -----------        ------------      ----------
c over each time step compare phase masses - boundary vs interior
           if (dabs(chbtw).lt.1.0d-10) then
              ratiow = 0.d0
           else
              ratiow = chitw/chbtw          
           endif
           if (dabs(chbto).lt.1.0d-10) then
              ratioo = 0.d0
           else
              ratioo = chito/chbto          
           endif
           if (dabs(chbtg).lt.1.0d-10) then
              ratiog = 0.d0
           else
              ratiog = chitg/chbtg          
           endif
c
c total mass in, total mass out:
c        flxtit = flxtiw + flxtio + flxtig
c        flxtot = flxtow + flxtoo + flxtog
         chbtt  = chbtw  + chbto  + chbtg 
         chitt  = chitw  + chito  + chitg 
           if (dabs(chbtt).lt.1.0d-10) then
              ratiot = 0.d0
           else
              ratiot = chitt/chbtt          
           endif
c        output results - errors for this time step
c
           write(15,992)time,flxtiw,flxtow,chbtw,chitw,ratiow
           write(16,992)time,flxtio,flxtoo,chbto,chito,ratioo
           write(17,992)time,flxtig,flxtog,chbtg,chitg,ratiog
           write(19,990)time,ratiot
c
  990      format(f15.4,2x,f15.8)
  992      format(1pe10.3,2x,1pe10.3,2x,1pe10.3,2x,1pe10.3,
     &            2x,1pe10.3,2x,1pe10.3)
c
c        compare the change of cumulative mass
            chtvw = cviwa - cvowa
            chtvo = (cvioa+cvion+cviog) - (cvooa+cvoon+cvoog)
            chtvg = cvigg - cvogg
            chw = tmwa - tmiwa
            cho = (tmoa+tmon+tmog) - (tmioa+tmion+tmiog)
            chg = tmgg - tmigg
            pctw = 100.d0*dabs(chw-chtvw)
     &                       /(tiwpm+tiopm+tigpm+twsm+tosm+tgsm)
            pcto = 100.d0*dabs(cho-chtvo)
     &                       /(tiwpm+tiopm+tigpm+twsm+tosm+tgsm)
            pctg = 100.d0*dabs(chg-chtvg)
     &                       /(tiwpm+tiopm+tigpm+twsm+tosm+tgsm)
c
            write(18,993)time,pctw,pcto,pctg,
     &                   dt,itf_dt,itw_dt,itg_dt, ihang
  993      format(1pe10.3,2x,'%water',1x,1pe10.3,2x,
     &                       '%oil',  1x,1pe10.3,2x,
     &                       '%gas',  1x,1pe10.3,2x,
     &                      'dt ',1x,1pe10.3,2x,'Pw it',i3,
     &            2x,'Sw it',i3,2x,'Sg it',i3,2x,'# hang',i3)     
c
c print saturation data at specific nodes after each time step:
c           j = 1 + 4*nny
c         write(100,1000) time,sw11(j,1),st11(j,1),pcnw1(j),pcgn1(j),
c    &                 rpa(j), rpn(j), rpg(j)
c           j = 1 +  9*nny
c         write(101,1000) time,sw11(j,1),st11(j,1),pcnw1(j),pcgn1(j),
c    &                 rpa(j), rpn(j), rpg(j)
c           j = 1 + 13*nny
c         write(102,1000) time,sw11(j,1),st11(j,1),pcnw1(j),pcgn1(j),
c    &                 rpa(j), rpn(j), rpg(j)
c           j = 1 + 15*nny
c         write(103,1000) time,sw11(j,1),st11(j,1),pcnw1(j),pcgn1(j),
c    &                 rpa(j), rpn(j), rpg(j)
c           j = 1 + 17*nny
c         write(104,1000) time,sw11(j,1),st11(j,1),pcnw1(j),pcgn1(j),
c    &                 rpa(j), rpn(j), rpg(j)
c1000  format(8(e12.4))
c
c END MASS BALANCE CALCULATIONS
        endif
c ----------        -----------        ------------      ----------
c
c     conditions for output
c                 1.)  we have reached max simulation time
c                 2.)  we have reached a print increment    
c
        if (time.ge.tmax - epsil .or.
     &      time.ge.tmpr - tsmin)   then
c
            tmpr = tmpr + tmprnt
c--------------------------------------------------------------------
c-------------   print     ----------------------------------------
c-------------------------------------------------------------------
c
c               WRITE DATA OUTPUT & RESTART FILES
c
         call print (dtt,chcwa,chcon,chcgg,chcoa,chcog,twsm,tosm,
     *               tgsm,cvwa,cvon,cvgg,cvoa,cvog,chbcw,chbco,chbcg,
     &               pctw,pcto,pctg,inctot,itf,itw,itg,itt,iherm,iprnt)
c
c               WRITE TO RESTART FILES
               call write_rs
c
        endif
c
c
c---------------------------------------------------------------------
c GMS graphics output
c
c       ngrf_on = 1 then graphics is on, =0 then off
c       grinc - time increment to print
c       ngrch - number of time steps before change grinc
c       fgrch - factor to multiply grinc
c       gmax  - maximum grinc
c
       if (ngrf_on.eq.1) then
        if (time.ge.tgrf.or.time.ge.tmax - epsil ) then
                  iinc = iinc + 1
c
                  call graph 
c
              if(iinc.ge.ngrf) then
                 ngrf = ngrf + ngrch
                 grinc = grinc*fgrch
                 if(grinc.gt.gmax)   grinc = gmax
              endif
c
          tgrf = tgrf + grinc
c
        endif
       endif
c---------------------------------------------------------------------
c ^^^^^^^^^^^^  
c     UPDATE HYSTERETIC k-S-P FUNCTIONALS
c ^^^^^^^^^^^^  
        if (nhyst.eq.1)  then
c
c************   hysteresis is on   ************
c           update the hysteresis vector
c icut is a marker which =1 if there is a reversal somewhere
c in the domain, and =0 if there is not
c if icut = 1 then there was a reversal somewhere
c-----
                      call trap_up
                      call sw_pc (icutw)
                      call st_pc (icutt)
c
c            adjust functions of Sw given hysteresis changes
                      call flow_fun
c-----
       endif
c ^^^^^^^^^^^^  
c---------------------------------------------------------------------
c-------------------- time step control-------------------------------
c---------------------------------------------------------------------
      if(time.lt.tmax - 1.0e-8) then 
c
           if(itf_dt.gt.itermx.or.itw_dt.gt.itermx.or.
     &        itg_dt.gt.itermx.or.itoa_dt.gt.itermx
     &        .or.itog_dt.gt.itermx) stop      
c
        if(time.ge.timec-epsil)  then
c       NEW STRESS PERIOD (  time for new bc's, Ic's )
                nflag = 1
c
                new_stress = 1
                dt = dtnew
                iphase = iph_new
                tsmx = dtmax
                co = co_new
                inc = 0
c                   reinitialize the solution vectors
              qtiw =   0.d0
              qtow =   0.d0         
              qtio =   0.d0         
              qtoo =   0.d0          
              qtig =   0.d0         
              qtog =   0.d0          
c
              chqwa =   0.d0         
              chqoa =   0.d0         
              chqog =   0.d0         
              chqgg =   0.d0         
              chqon =   0.d0         
c
              chqtw = 0.d0         
              chqto = 0.d0          
              chqtg = 0.d0          
c
             if (ngrf_on.eq.1) then
c             reinitialize graphics output
                 iinc = 0
                 ngrf =  ngrch
                 grinc = gr_inc
                 tgrf =  grinc + timec
             endif
c
              go to 599
c
        endif
c
c increase or reduce dt based on number of iterations
c given the time step based on iteration count
c calculate the time step based on Courant constraint
c and choose the smaller value
c
            call dt_cntrl 
c
c
c       adjust time step based on : print interval
c                                   stress period 
          if ((time+dt)-epsil.gt.timec) then
              dt = timec - time
             if(dt.lt.tsmin) dt = tsmin
          else if ((time+dt)-epsil.gt.tmpr) then
              dt = tmpr - time
             if(dt.lt.tsmin) dt = tsmin
          endif
c
c ^^^^^^^^^^^^  
c ^^^^^^^^^^^^  
c     UPDATE SATURATION AND COMPOSITION DEPENDENT FORCINGS
c            FOR THE NEXT TIME STEP
c ^^^^^^^^^^^^  
c  ****       flow conditions 
                             call bc_up 
c
c  ****       outflow point sources 
c
                             call qout
c
              go to 201
      endif
                    close (1)
                    close (9)
                    close (10)
                    close (11)
                    close (12)
                    close (22)
                    close (23)
                    close (24)
                    close (25)
                    close (26)
c
              if (ngrf_on.eq.1)  then
c              graphics files
               IF(iout.eq.0) then
c ASCII file format
                write(51,989)
                write(52,989)
                write(55,989)
                write(56,989)
                write(57,989)
                write(58,989)
                 if(ntr_ow.eq.1) then
                   write(53,989)
                   close(53)
                 endif
                 if(ntr_og.eq.1) then
                   write(54,989)
                   close(54)
                 endif
                else
c BINARY unformatted
                iend = 210
                write(51) iend
                write(52) iend
                write(55) iend
                write(56) iend
                write(57) iend
                 if(ntr_ow.eq.1) then
                   write(53)iend
                 endif
                 if(ntr_og.eq.1) then
                   write(54) iend
                 endif
                ENDIF
                   close(51)
                   close(52)
                   close(55)
                   close(56)
                   close(57)
                 if(ntr_ow.eq.1) then
                   close(53)
                 endif
                 if(ntr_og.eq.1) then
                   close(54)
                 endif
              endif
  989 FORMAT('ENDDS')
c
  500   stop
        end
