C     Last change:  JG   30 Oct 97    4:41 pm
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        subroutine point
c*********************************************************************
c
c set up pointer to map between x and y nodal numberings
c for this rectangular mesh
c four degrees of freedon per node
c 
c
c npt_s -- is an operator which eliminates 
c          shortest-direction-first (SDF) numbering dependence. 
c         
c        Dimension (nn_sub,2)
c          column 1 is x-first of SDF numbering
c          column 2 is y-first of SDF numbering
c
c npt_gs -- relates global default numbering (y-direction first) and
c            domain default numbering (shortest direction first)
c            (SDF of y-first numbering)
c            Dimension (nn_sub). 
c
        include 'include.f'
c
c
c%%%%%%
c generate npt_s and npt_gs depending on domain default numbering
c%%%%%%
c for local domain vectors, the numbering 
c is by default first in the shortest dimension 
c
      if(ixy.eq.1)  then
c            shortest dimension is in x
c
c%%%%%%
c generate npt_s 
c%%%%%%
                       k = 0
               do 113 i = 1, n_short
	            do 112 j = 0, n_long-1   
c
                       k = k + 1
	               npt_s(k,2) = j*n_short + i
c
  112             continue
  113               continue
c
	             k = 0
	             do 163 i = 0, n_long-1  
	               do 162 j = 1, n_short   
c
                         k = k + 1
		          npt_s(k,1) = j + i*n_short 
c
  162                  continue
  163                continue
c
c%%%%%%
c generate npt_gs
c%%%%%%
c domain is numbered in x first (ixy = 1)
c but the global domain is default in y
c
             kk = 0
	             do  143 ii = 1, n_long
	               do  142 jj = 0, n_short-1
                         kk = kk + 1
	                 npt_gs(kk) = jj*nny + ii
c
  142                continue
  143                  continue
c
c
      else 
c
c            shortest dimension is in y
c
c%%%%%%
c generate npt_s
c%%%%%%
                       k = 0
	          do 213 i = 1, n_short
	            do 212 j = 0, n_long-1   
c
                       k = k + 1
	               npt_s(k,1) = j*n_short + i
c
  212             continue
  213               continue
c
	             k = 0
	             do 263 i = 0, n_long-1  
	               do 262 j = 1, n_short
c
                         k = k + 1
		          npt_s(k,2) = j + i*n_short
c
  262                  continue
  263                continue
c
c%%%%%%
c generate npt_gs
c%%%%%%
c domain nodes are numbered in y first (ixy = 2)
c and so is the global domain 
c
c
             kk = 0
	             do  343 ii = 0, n_long-1  
	               do  342 jj = 1, n_short
                         kk = kk + 1
	                 npt_gs(kk) = ii*nny + jj
c
  342                continue
  343                  continue
c
      endif
c-----------------------------------------------------------------
                                        return
                                        end
c
	subroutine relem
c
c generates a list of the element indicies
c nodes are numbered in y-x order
c to go with collocation point numbering
c
        include 'include.f'
c
	m = -nny
c
	     kk = 1
	do 3 k = 1, nex
	     m = m + nny
	do 2 j = 1, ney
             nel(kk,2) = j + m + 1
             nel(kk,1) = j + m
             nel(kk,3) = j + nny + m
             nel(kk,4) = j + nny + m + 1
	     kk = kk + 1
    2   continue
    3   continue
c
	return
	end
