C     Last change:  JG   12 Feb 2000    6:23 am
c SPECIFY WELL CONDITIONS
c
          subroutine point_source(nwella)
c
c
c routine to calc flow conditions forcing from wells (point sources)
c use well conditions to get mass in and out of domain
c ues instead of flux bc's.
c 
         include 'include.f'        
c
c        read in locations and strength of sources and sinks
c
c nod = nodal location
c   qiow(nod) = inflow of dissolved contaminant
c   qiog(nod) = inflow of vapor contaminant
c   qw(nod)   = water flow rate in/out
c   qn(nod)   = NAPL flow rate in/out
c   qg(nod)   = gas flow rate in/out
c
          nstop = 0
c
          do 26 i=1,nwella
c
c q_tot = well source total rate (- = extraction) (+ = injection)
c ff_w = fractional flow of water 
c ff_g = fractional flow of gas s.t. 
c             qw = (ff_w)*q_tot
c             qg = (ff_g)*q_tot
c             qn = q_tot - qw - qg
c
c c_d = concentration dissolved in water 
c       assocoated with inflow point sources
c c_v = concentration vaporized in gas 
c       assocoated with inflow point sources
c        when ff_w + ff_g = 1, 
c        when ff_w + ff_g < 1, then c_d = parow
c                                   c_v = parog
c
          read(12,*) nod, q_tot, ff_w, ff_g, c_w, c_g
c
               if(ntr_og.ne.1) then
                    c_g = 0.d0
               endif
               if(ntr_ow.ne.1) then
                    c_w = 0.d0
               endif
c
c calculate the length of the elements surrounding the node to 
c calc the proper flux in
c for point source divide by the area
c for flux bc divide by the length
c (+) = injection at a constant conc
c       input rate and concentration
c (-) = extrtaction at nodal conc
c       input rate only                
                   nco=nod/nny
                 if(nny*nco.lt.nod)  nco=nco+1
		  nro=nny-(nny*nco-nod)
                 if(nco.eq.1)then
c
c check this y-face node for Dirichlet pressure condition
       if(ib_y(nro,1).ne.1.and.ib_y(nro,1).ne.5) then
         write(6,*)
     &   'VIOLATION: well & NL pressure condition at the same node'
         write(6,*) nod
          nstop = 1
       endif 
c
                     ddx = dx(1)/2.d0
                 else if(nco.eq.nnx)then
c check this y-face node for Dirichlet pressure condition
       if(ib_y(nro,2).ne.1.and.ib_y(nro,2).ne.5) then
         write(6,*)
     &   'VIOLATION: well & NL pressure condition at the same node'
         write(6,*) nod
          nstop = 1
       endif 
c
                     ddx = dx(nex)/2.d0
                 else
                     ddx = (dx(nco)+dx(nco-1))/2.d0
                 endif
c
                 if(nro.eq.1)then
c check this x-face node for Dirichlet pressure condition
       if(ib_x(nco,1).ne.1.and.ib_x(nco,1).ne.5) then
         write(6,*)
     &   'VIOLATION: well & NL pressure condition at the same node'
         write(6,*) nod
          nstop = 1
       endif 
c
                     ddy = dy(1)/2.d0
                 else if(nro.eq.nny)then
c check this x-face node for Dirichlet pressure condition
       if(ib_x(nco,2).ne.1.and.ib_x(nco,2).ne.5) then
         write(6,*)
     &   'VIOLATION: well & NL pressure condition at the same node'
         write(6,*) nod
          nstop = 1
       endif 
c
                     ddy = dy(ney)/2.d0
                 else
                     ddy = (dy(nro)+dy(nro-1))/2.d0
                 endif
c                        
c                   well as a point source
                qw(nod) = q_tot*ff_w/ (ddx*ddy) 
                qg(nod) = q_tot*ff_g/ (ddx*ddy) 
                qn(nod) = q_tot*(1.d0-ff_w-ff_g)/ (ddx*ddy) 
c
c
           if (q_tot.gt.0.d0) then
c          inflow at constant phase mix defined by ff,
c          and density for flow - mass in = rate*density
c                 constant source strength for transport
c               density                               
                 if ( ff_w + ff_g .lt. 0.9999) then
c                        NAPL is present
                         pow = parow
                         pog = parog
                 else
c                        no NAPL is present
                         pow = c_w
                         pog = c_g
                 endif
                       qiow(nod) = qw(nod)*pow   
                       qiog(nod) = qg(nod)*pog   
           endif
c
   26     continue
c^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
              if(nstop.eq.1)  stop
           return
           end
c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
          subroutine qout
c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
c
c routine to update the NONZERO OUTFLOW well conditions 
c to reflect the change in the water saturation and composition
c after each time step
c distribution based on FRACTIONAL FLOW
c
        include 'include.f'
c
      do 72 nod=1,nn
c
c
      if ( qw(nod)+qn(nod)+qg(nod) .lt. -1.d-10 )  then
c
c outflow well condition so distribute the rate based in the 
c current solution.
c
c                - nod- is the node number
c
c          distribute the rate based on phase mobility 
      call  water_prop (roa11(nod,1),wa,rw,vw)
      call  gas_prop   (rog11(nod,1),gg,rg,vg)
           qt = qw(nod)+qn(nod)+qg(nod)
      tot_mob = rpa(nod)/vw + rpn(nod)/vn_r + rpg(nod)/vg
c
        if(rpa(nod).gt.epsil)  then
          if(rpg(nod).gt.epsil)  then
            if(rpn(nod).gt.epsil)  then
c                                                   all mobile
                qw(nod) = qt*rpa(nod)/vw/tot_mob
                qn(nod) = qt * rpn(nod)/vn_r / tot_mob
                qg(nod) = qt - qw(nod) - qn(nod)
            else
c                                                   only water and gas
                qw(nod) = qt*rpa(nod)/vw/tot_mob
                qn(nod) = 0.d0
                qg(nod) = qt - qw(nod)
            endif
          else
            if(rpn(nod).gt.epsil)  then
c                                                   only water and NAPL
                qw(nod) = qt*rpa(nod)/vw/tot_mob
                qn(nod) = qt - qw(nod)
                qg(nod) = 0.d0
            else
c                                                   only water 
                qw(nod) = qt 
                qn(nod) = 0.d0
                qg(nod) = 0.d0
            endif
          endif
        else
          if(rpg(nod).gt.epsil)  then
            if(rpn(nod).gt.epsil)  then
c                                                   only gas and NAPL
                qw(nod) = 0.d0
                qn(nod) = qt * rpn(nod)/vn_r / tot_mob
                qg(nod) = qt - qn(nod)
            else
c                                                   only gas
                qw(nod) = 0.d0
                qn(nod) = 0.d0
                qg(nod) = qt 
            endif
          else
            if(rpn(nod).gt.epsil)  then
c                                                    only NAPL
                qw(nod) = 0.d0
                qn(nod) = qt 
                qg(nod) = 0.d0
            endif
          endif
        endif
c
      endif
c
   72 continue        
                                        return
                                        end
c
c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
          subroutine qout_adj (qt,nod)
c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
c
c routine to update the NONZERO OUTFLOW well conditions 
c to reflect the change in the water saturation and composition
c after each time step
c distribution based on FRACTIONAL FLOW
c
        include 'include.f'
c
c
c outflow well condition so distribute the rate based in the 
c current solution.
c
c                - nod- is the node number
c
c          distribute the rate based on phase mobility 
c
      call  water_prop (roa11(nod,1),wa,rw,vw)
      call  gas_prop   (rog11(nod,1),gg,rg,vg)
      tot_mob = rpa(nod)/vw + rpn(nod)/vn_r + rpg(nod)/vg
c
        if(rpa(nod).gt.epsil)  then
          if(rpg(nod).gt.epsil)  then
            if(rpn(nod).gt.epsil)  then
c                                                   all mobile
                qw(nod) = qt*rpa(nod)/vw/tot_mob
                qn(nod) = qt * rpn(nod)/vn_r / tot_mob
                qg(nod) = qt - qw(nod) - qn(nod)
            else
c                                                   only water and gas
                qw(nod) = qt*rpa(nod)/vw/tot_mob
                qn(nod) = 0.d0
                qg(nod) = qt - qw(nod)
            endif
          else
            if(rpn(nod).gt.epsil)  then
c                                                   only water and NAPL
                qw(nod) = qt*rpa(nod)/vw/tot_mob
                qn(nod) = qt - qw(nod)
                qg(nod) = 0.d0
            else
c                                                   only water 
                qw(nod) = qt 
                qn(nod) = 0.d0
                qg(nod) = 0.d0
            endif
          endif
        else
          if(rpg(nod).gt.epsil)  then
            if(rpn(nod).gt.epsil)  then
c                                                   only gas and NAPL
                qw(nod) = 0.d0
                qn(nod) = qt * rpn(nod)/vn_r / tot_mob
                qg(nod) = qt - qn(nod)
            else
c                                                   only gas
                qw(nod) = 0.d0
                qn(nod) = 0.d0
                qg(nod) = qt 
            endif
          else
            if(rpn(nod).gt.epsil)  then
c                                                    only NAPL
                qw(nod) = 0.d0
                qn(nod) = qt 
                qg(nod) = 0.d0
            endif
          endif
        endif
c
                                        return
                                        end
c
c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
c
          subroutine well_mass(cviwa,cvioa,cvion,cviog,cvigg,
     &                         cvowa,cvooa,cvoon,cvoog,cvogg,
     &                      chqwa,chqoa,chqon,chqog,chqgg,
     &                      chqtw,chqto,chqtg,
     &                      qtiw,qtow,qtio,qtoo,qtig,qtog)
c
c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
c
c routine to calc the mass in and out of point sources 
c over this time step
c
        include 'include.f'
c
                wiwa = 0.d0        
                wioa = 0.d0        
                wion = 0.d0        
                wiog = 0.d0        
                wigg = 0.d0        
                wowa = 0.d0        
                wooa = 0.d0        
                woon = 0.d0        
                woog = 0.d0        
                wogg = 0.d0        
c
c           wells are source / sinks
c          prefix   wo = outgoing species mass over boundary
c                   wi = incoming species mass over boundary
c                   qti = incoming summed species mass through wells
c                   qto = outgiong summed species mass through wells
c                 cvi = cumulative species mass in over boundary
c                 cvo = cumulative species mass out over boundary
c           chq = change in species mass over bdy. for this dt(- = loss)
c          chqt = change in summed species mass over bdy. for this dt
c for outflow well conditions calc the mass in/out over this time step
c mass out
      do 82 nod = 1, nn
c
c      if (dabs(qw(nod)+qn(nod)+qg(nod)).gt.1.d-12)  then
c
c clac the 
                  nco=nod/nny
                  if(nny*nco.lt.nod)  nco=nco+1
                  nro=nny-(nny*nco-nod)
                 if(nco.eq.1)then
                     ddx=dx(1)/2.d0
                 else if(nco.eq.nnx)then
                     ddx=dx(nex)/2.d0
                 else
                     ddx=dx(nco)/2.d0+dx(nco-1)/2.d0
                 endif
                 if(nro.eq.1)then
                     ddy=dy(1)/2.d0
                 else if(nro.eq.nny)then
                     ddy=dy(ney)/2.d0
                 else
                     ddy=dy(nro)/2.d0+dy(nro-1)/2.d0
                 endif
c
                 qt =  qw(nod)+qn(nod)+qg(nod)
c
        if (qt    .gt. 1.d-12 ) then
c
c               its an inflow cond.
c
                  if(qw(nod).gt.1.d-15) then
                      conc = qiow(nod)/qw(nod)
                  else 
                      conc = 0.d0
                  endif
                  call water_prop (conc,wa,dw,visw)
c
                wiwa =   wiwa + qw(nod)*wa*ddx*ddy*dt
                wioa =   wioa + qiow(nod) *ddx*ddy*dt
c
                  if(qg(nod).gt.1.d-15) then
                      conc = qiog(nod)/qg(nod)
                  else 
                      conc = 0.d0
                  endif
                  call   gas_prop (conc,gg,dg,visg)
c
                wigg =   wigg + qg(nod)*gg*ddx*ddy*dt
                wiog =   wiog + qiog(nod) *ddx*ddy*dt
c
                wion =   wion + qn(nod)*rn_r *ddx*ddy*dt
c
c
        else if (qt    .lt. -1.d-12 ) then
c
c             its an outflow condition
c
                  call water_prop (roa11(nod,1),wa,dw,visw)
                  call   gas_prop (rog11(nod,1),gg,dg,visg)
c
                wowa =   wowa + dabs(qw(nod))*ddx*ddy*wa*dt
                wooa =   wooa + dabs(qw(nod))*ddx*ddy*roa11(nod,1)*dt
c
                woon =   woon + dabs(qn(nod))*ddx*ddy*rn_r*dt
c
                wogg =   wogg + dabs(qg(nod))*ddx*ddy*gg*dt
                woog =   woog + dabs(qg(nod))*ddx*ddy*rog11(nod,1)*dt
c
        endif
c
c      endif
   82     continue
c
              cviwa = cviwa +   wiwa
              cvioa = cvioa +   wioa
              cvion = cvion +   wion
              cvigg = cvigg +   wigg
              cviog = cviog +   wiog
c
              cvowa = cvowa +   wowa
              cvooa = cvooa +   wooa
              cvoon = cvoon +   woon
              cvogg = cvogg +   wogg
              cvoog = cvoog +   woog
c
              chqwa =   wiwa -   wowa
              chqoa =   wioa -   wooa
              chqon =   wion -   woon
              chqgg =   wigg -   wogg
              chqog =   wiog -   woog
c
              chqtw = chqwa
              chqto = chqoa + chqon + chqog
              chqtg = chqgg 
c 
              qtiw =   wiwa
              qtow =   wowa
              qtio =   wioa + wion + wiog
              qtoo =   wooa + woon + woog
              qtig =   wigg
              qtog =   wogg
c
                                        return
                                        end
