C     Last change:  JG   28 Sep 2000    1:18 pm
c
c Solution of the WATER and GAS BALANCE EQUATIONS
c given the flow and concentration solutions, 
c and the Sw and Sg solutions at time level 'n'
c use Picard iteration to compute a solution at time level 'n+1'
c
c calls sw_sol (sw_tmp,tnorm_w,tinf_w,dw_max,nw_max,isubw,i_dfw,iterw)
c    compute the iterative update for Sw
c calls st_sol (sg_tmp,tnorm_g,tinf_g,dg_max,ng_max,isubg,i_dfg,iterg)
c    compute the iterative update for Sg
c calls flow_fun - update the nonlinearities
c calls mp_diff - add diffusion if necessary via Peclet constraint
c
c---------------------------------------------------------------------
       subroutine sat_sol (iterw,iterg)
c---------------------------------------------------------------------
c
c Iterate to convergence by concurrent solution of 
c the WATER equation and the GAS equation 
c
c given flow field and composition
c use Ismael's CG iterative solver 
c
        include 'include.f'
c########################################################
c initialize sol
             do 15 j    = 1, nequ
                 sol_g(j) = 0.d0
                 sol_w(j) = 0.d0
   15        continue
c
            eris = eros
c
  203        continue
c
       if ( iphase.eq.13 )  then
c----------------------------------------
c         gas-water solution
c----------------------------------------
c         solve the gas   equation given sw11, st11, vtot
c         GAS BALANCE EQUATION
          call st_sol     (tnorm_g,tinf_g,dg_max,ng_max,iterg)
              if(istop.eq.2)  return
c
              nw_max  = 1
              dw_max  = 0.d0
              tinf_w  = 0.d0
              tnorm_w = 0.d0
c FINAL UPDATE
           do 76 j = 1, 4
              do 75 i = 1, nn
                  sw11(i,j)  = sg_tmp(i,j) - stt(i,j) + swt(i,j)
                  st11(i,j)  = sg_tmp(i,j)
   75         continue
   76      continue
c
        else if ( iphase.eq.12 )  then
c----------------------------------------
c         water-NAPL solution
c----------------------------------------
c         solve the water equation given sw11, st11, vtot
c         WATER BALANCE EQUATION
          call sw_sol     (tnorm_w,tinf_w,dw_max,nw_max,iterw)
              if(istop.eq.2)  return
c
              ng_max  = 1
              dg_max  = 0.d0
              tinf_g  = 0.d0
              tnorm_g = 0.d0
c FINAL UPDATE
           do 176 j = 1, 4
              do 175 i = 1, nn
                  sw11(i,j)  = sw_tmp(i,j)
  175         continue
  176      continue
c
        else if ( iphase.eq.123 )  then
c----------------------------------------
c water-NAPL-gas solution
c----------------------------------------
c parallel equation solution
c$doacross local(ieq)
        do 1 ieq = 1, 2
c
          if(ieq.eq.1)  then
c           GAS BALANCE EQUATION
            call st_sol (tnorm_g,tinf_g,dg_max,ng_max,iterg)
              if(istop.eq.2)  return
          else
c           WATER BALANCE EQUATION
            call sw_sol  (tnorm_w,tinf_w,dw_max,nw_max,iterw)
              if(istop.eq.2)  return
          endif
c
   1    continue
c
c FINAL UPDATE
           do 276 j = 1, 4
              do 275 i = 1, nn
                  sw11(i,j)  = sw_tmp(i,j)
                  st11(i,j)  = sg_tmp(i,j)
  275         continue
  276      continue
c
        else 
           write(6,*) 'ERROR - IPHASE ='
           write(6,*) iphase
        endif
c
c---------------------------------------------------------------------
c
c                    update nonlinearities
c
                         call  flow_fun
c
               if (iscr.eq.1)  then
c
                if(tinf_w.gt.tinf_g) then
                 sw = sw11(nw_max,1)
                 sn = st11(nw_max,1) - sw11(nw_max,1)
                 sg = 1.d0 - st11(nw_max,1)
c            pc_mx = -dpcnw(nw_max)*dw_max
                 write(6,953)iterw,nw_max,sw, sn, sg, 
     &                       dw_max,tnorm_w,tinf_w
                else
                 sw = sw11(ng_max,1)
                 sn = st11(ng_max,1) - sw11(ng_max,1)
                 sg = 1.d0 - st11(ng_max,1)
c            pc_mx = -dpcgn(ng_max)*dg_max
                 write(6,953)iterg,ng_max,sw, sn, sg, 
     &                       dg_max,tnorm_g,tinf_g
                endif
               endif
  953  format(' NL_S',i2,1x,i5,3(f8.4),1x,
     &       '(',f8.6,')',2x,f8.6,2x,f8.6/)
c
           if(dw_max.gt.dslim .or. dg_max.gt.dslim) then
c          if(pc_mx.gt.dslim ) then
c                   too large a change for this time step
c                   so reduce time step and restart
                          istop = 2
                          return
c
           else if (tnorm_w.lt.eros .and. tnorm_g.lt.eros .or.  
     &              tinf_w .lt.eros .and. tinf_g .lt.eros)  then
c               converged
                          return
c
           else if(iterw.gt.ithangs .or. iterg.gt.ithangs) then
c                   too many iterations for this time step
c                   so reduce time step and restart
                          istop = 2
                          return
c
           else
                         call  mp_diff
                    if (dt_crit*tmult.lt.dt) then 
c                      time step too high 
c                      so reduce time step and restart
                          istop = 2
                          return
                    else 
                         eris = eris/2.d0
                        if(eris.lt.eros/10.d0) eris = eros/10.d0
                           go to 203
                    endif 
           endif
c
                                                    end
c
c Driver for the WATER BALANCE EQUATION
c
c---------------------------------------------------------------------
       subroutine sw_sol  (t_norm,t_inf,ds_max,n_max,iters)
c---------------------------------------------------------------------
c
c Solution of the Sw equation given flow field and composition
c---------------------------------------------------------------------
c
        include 'include.f'
c
c  xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
c
            t_norm = 0.d0
            t_inf = 0.d0
            ds_max = 0.d0
            n_max = 1
c
cxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
             call system_wi (n_do,iter)
cxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
          if(iter.gt.1.5*ithangs)                       then
c                   too many iterations for this time step
c                   so reduce time step and restart
                          istop = 2
                          return
           endif
c
cxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
c
c all nodes
           do 211 nod = 1, nn
c
               n_g = npt_gs(nod)
       if(n_do.eq.1 .and. ibc_s(nod,1).ne.0)  then
c
c---------------------------------------------------------------------
c      nonlinear iteration convergence norms
             t_norm = t_norm + sol_w(ibc_s(nod,1))*sol_w(ibc_s(nod,1))
c
              span = ss_w(n_g,nhc_w(n_g)) - sr_w(n_g,nhc_w(n_g))
c
             if ( dabs(sol_w(ibc_s(nod,1)))/span .gt. t_inf) then
                     t_inf = dabs(sol_w(ibc_s(nod,1)))/span
                     n_max = n_g
             endif
c
             if (dabs(sw11(n_g,1) + sol_w(ibc_s(nod,1))-swt(n_g,1))/span
     &          .gt. ds_max) then
               ds_max = dabs(sw11(n_g,1)+sol_w(ibc_s(nod,1))-swt(n_g,1))
     &                                      /span
                          n_max = n_g
             endif
c---------------------------------------------------------------------
                sw_tmp(n_g,1) = sw11(n_g,1) + sol_w(ibc_s(nod,1))
       else
                sw_tmp(n_g,1) = sw11(n_g,1)
       endif
              do 221 idf = 1, 4
c
       if(n_do.eq.1 .and. ibc_s(nod,idf).ne.0)  then
                sw_tmp(n_g,idf) = sw11(n_g,idf) + sol_w(ibc_s(nod,idf))
       else
                sw_tmp(n_g,idf) = sw11(n_g,idf)
       endif
c
  221         continue
  211      continue
c
                            iters = iters + 1
c
c        L2 norm
                 t_norm = dsqrt(t_norm)
c
                                                    return
                                                    end
c
c Driver for the GAS BALANCE EQUATION
c
c---------------------------------------------------------------------
       subroutine st_sol (t_norm,t_inf,ds_max,n_max,iters)
c---------------------------------------------------------------------
c
c Solution of the St equation given flow field and composition
c---------------------------------------------------------------------
c
        include 'include.f'
c
c  xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
c
            t_norm = 0.d0
            t_inf = 0.d0
            ds_max = 0.d0
            n_max = 1
c
cxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
             call system_ti (n_do,iter)
cxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
          if(iter.gt.1.5*ithangs)                       then
c                   too many iterations for this time step
c                   so reduce time step and restart
                          istop = 2
                          return
           endif
c
cxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
c
c all nodes
           do 211 nod = 1, nn
c
               n_g = npt_gs(nod)
       if(n_do.eq.1 .and. ibc_s(nod,1).ne.0)  then
c
c---------------------------------------------------------------------
c      nonlinear iteration convergence norms
             t_norm = t_norm + sol_g(ibc_s(nod,1))*sol_g(ibc_s(nod,1))
c
              span = ss_t(n_g,nhc_t(n_g)) - sr_t(n_g,nhc_t(n_g))
c
             if ( dabs(sol_g(ibc_s(nod,1)))/span .gt. t_inf) then
                     t_inf = dabs(sol_g(ibc_s(nod,1)))/span
                     n_max = n_g
             endif
c
             if (dabs(st11(n_g,1) + sol_g(ibc_s(nod,1))-swt(n_g,1))/span
     &          .gt. ds_max) then
               ds_max = dabs(st11(n_g,1)+sol_g(ibc_s(nod,1))-stt(n_g,1))
     &                                      /span
                          n_max = n_g
             endif
c---------------------------------------------------------------------
                sg_tmp(n_g,1) = st11(n_g,1) + sol_g(ibc_s(nod,1))
       else
                sg_tmp(n_g,1) = st11(n_g,1)
       endif
              do 221 idf = 2, 4
c
       if(n_do.eq.1 .and. ibc_s(nod,idf).ne.0)  then
                sg_tmp(n_g,idf) = st11(n_g,idf) + sol_g(ibc_s(nod,idf))
       else
                sg_tmp(n_g,idf) = st11(n_g,idf)
       endif
c
  221 continue
  211  continue
c
                            iters = iters + 1
c
c        L2 norm
                 t_norm = dsqrt(t_norm)
c
                                                    return
                                                    end
