C     Last change:  JG    8 May 2002    1:05 pm
c************************************************************
        subroutine pc_gn(st,pc,d_pc,ik)
c************************************************************
c              NAPL - gas
c************************************************************
c
c find                      Pcng(St)  (pc) 
c and                       dPcng/dSt (d_pc)
c given:
c
c nhyst                =1 then hysteresis is on, else off
c st                   = St at most recent iterate level
c sr_t(ik,nhc_t(ik))   = current curve residual scaling parameter
c ss_t(ik,nhc_t(ik))   = current curve saturation scaling parameter
c a_t(ik,nhc_t(ik))    = current curve shape parameter
c
        include 'include.f'
        DOUBLE precision nsw, msw
c
c%%%%%%%%%%%%%%%%%   %%%%%%%%%%%%%  %%%%%%%%%%%%%%%%%%%  %%%%%%%%%%
c             van genuchten
          nsw = shape(ik)
          msw = 1.d0-1.d0/shape(ik)
       if (nhyst.ne.1) then
c NO HYSTERESIS (no entrapment of nonwetting phases)
c
                 se = (st - swr(ik)) / (1.d0 - swr(ik))
c
c
        if( se.ge.(1.d0-se_sl) )  then
          se = (1.d0-se_sl)
             d_pc = -(denw*se**(-1.d0 - 1.d0/msw)*(-1.d0 
     *        + se**(-1.d0/msw))**(-1.d0 + 1.d0/nsw)/(asd(ik)*msw*nsw))
     *             /(1.d0-swr(ik))     
             pcc  = denw*(-1.d0 + se**(-1.d0/msw))**(1.d0/nsw)/asd(ik)
             swcs = 1.d0 - se_sl*(1.d0-swr(ik))
             pc   = pcc + (st - swcs)*d_pc
        else if(se.le.se_rl)  then
          se = se_rl
             d_pc = -(denw*se**(-1.d0 - 1.d0/msw)*(-1.d0 
     *        + se**(-1.d0/msw))**(-1.d0 + 1.d0/nsw)/(asd(ik)*msw*nsw))
     *             /(1.d0-swr(ik))     
             pcc  = denw*(-1.d0 + se**(-1.d0/msw))**(1.d0/nsw)/asd(ik)
             swcr = swr(ik) + se_rl*(1.d0-swr(ik))
             pc   = pcc + (st - swcr)*d_pc
c
        else
c
             d_pc = -(denw*se**(-1.d0 - 1.d0/msw)*(-1.d0 
     *        + se**(-1.d0/msw))**(-1.d0 + 1.d0/nsw)/(asd(ik)*msw*nsw))
     *             /(1.d0-swr(ik))     
             pc  = denw*(-1.d0 + se**(-1.d0/msw))**(1.d0/nsw)/asd(ik)
c
        endif
c
c Buckley Leverett and Gottfried
c            d_pc   = -1.0d+1
c            pc   = (st - 1.d0)*d_pc
c
       else
c HYSTERESIS
c determine the appropriate value for Se drainage/imbibition
            if(nhc_t(ik).eq.2)  then
              if (sb_t(ik,2).gt.(swt_c(ik)+snt_c(ik)+1.d-4)
     &            .and. st.lt.sb_t(ik,2)-epsil ) then
c             revert to curve 1
                 sr = sr_t(ik,1)
                 ss = ss_t(ik,1)
                 as = asd(ik)
                 nhc_t(ik) = 1
                 a_t(ik,1) = asd(ik)
              else
                 sr = sr_t(ik,2)
                 ss = ss_t(ik,2)
                 as = a_t(ik,2)
              endif
            else if(nhc_t(ik).eq.3)  then
              if( st.gt.sb_t(ik,3)+epsil )  then
c             revert to curve 2
                 sr = sr_t(ik,2)
                 ss = ss_t(ik,2)
                 as = a_t(ik,2)
                 nhc_t(ik) = 2
              else if( st.lt.sb_t(ik,2)-epsil )  then
c             close loop to curve 1
                 sr = sr_t(ik,1)
                 ss = ss_t(ik,1)
                 as = asd(ik)
                 nhc_t(ik) = 1
                 a_t(ik,1) = asd(ik)
              else 
                 sr = sr_t(ik,3)
                 ss = ss_t(ik,3)
                 as = a_t(ik,3)
              endif
            else if(nhc_t(ik).eq.4)  then
              if( st.lt.sb_t(ik,4)-epsil )  then
c             revert to curve 3
                 sr = sr_t(ik,3)
                 ss = ss_t(ik,3)
                 as = a_t(ik,3)
                 nhc_t(ik) = 3
              else if( st.gt.sb_t(ik,3)+epsil )  then
c             close loop to curve 2
                 sr = sr_t(ik,2)
                 ss = ss_t(ik,2)
                 as = a_t(ik,2)
                 nhc_t(ik) = 2
              else 
                 sr = sr_t(ik,4)
                 ss = ss_t(ik,4)
                 as = a_t(ik,4)
              endif
            else
                 sr = sr_t(ik,1)
                 ss = ss_t(ik,1)
                 as = asd(ik)    
            endif
c
                 se = ( st - sr)  / (ss - sr)
c
        if( se.ge.(1.d0-se_sl) )  then
          se = (1.d0-se_sl)
c
             d_pc = -(denw*se**(-1.d0 - 1.d0/msw)*(-1.d0 
     *            + se**(-1.d0/msw))**(-1.d0 + 1.d0/nsw)
     *            /(as*msw*nsw)) /(ss - sr)
c
             pcc  = denw*(-1.d0 + se**(-1.d0/msw))**(1.d0/nsw)/as
             swcs = ss - se_sl * (ss - sr)
             pc   = pcc + (st - swcs)*d_pc
c
        else if(se.le.se_rl)  then
          se = se_rl
c
             d_pc = -(denw*se**(-1.d0 - 1.d0/msw)*(-1.d0 
     *            + se**(-1.d0/msw))**(-1.d0 + 1.d0/nsw)
     *            /(as*msw*nsw)) /(ss - sr)
c
             pcc  = denw*(-1.d0 + se**(-1.d0/msw))**(1.d0/nsw)/as
             swcr = sr + se_rl * (ss - sr)
             pc   = pcc + (st - swcr)*d_pc
c
        else
c
             d_pc = -(denw*se**(-1.d0 - 1.d0/msw)*(-1.d0 
     *            + se**(-1.d0/msw))**(-1.d0 + 1.d0/nsw)
     *            /(as*msw*nsw))/(ss - sr)
             pc = denw*(-1.d0 + se**(-1.d0/msw))**(1.d0/nsw)/as
c
        endif
c
       endif
c
            return
            end
c
c************************************************************
c************************************************************
        subroutine pc_nw(sw,pc,d_pc,ik)
c************************************************************
c              NAPL - water
c************************************************************
c
c find                      Pcnw(Sw)  (pc) 
c and                       dPcnw/dSw (d_pc)
c given:
c
c nhyst                =1 then hysteresis is on, else off
c sw                   = St at most recent iterate level
c sr_w(ik,nhc_w(ik))   = current curve residual scaling parameter
c ss_w(ik,nhc_w(ik))   = current curve saturation scaling parameter
c aw    = current curve shape parameter
c
        include 'include.f'
        DOUBLE precision nsw, msw
c
c%%%%%%%%%%%%%%%%%   %%%%%%%%%%%%%  %%%%%%%%%%%%%%%%%%%  %%%%%%%%%%
c             van genuchten
          nsw = shape(ik)
          msw = 1.d0-1.d0/shape(ik)
       if (nhyst.ne.1) then
c
c NO HYSTERESIS (no entrapment of nonwetting phases)
c
                 se = (sw - swr(ik)) / (1.d0 - swr(ik))
c
c
        if( se.ge.(1.d0-se_sl) )  then
          se = (1.d0-se_sl)
             d_pc = -(denw*se**(-1.d0 - 1.d0/msw)*(-1.d0 
     *        + se**(-1.d0/msw))**(-1.d0 + 1.d0/nsw)/(asd(ik)*msw*nsw))
     *             /(1.d0-swr(ik))     
             pcc  = denw*(-1.d0 + se**(-1.d0/msw))**(1.d0/nsw)/asd(ik)
c
             swcs = 1.d0 - se_sl*(1.d0-swr(ik))
             pc   = pcc + (sw - swcs)*d_pc
        else if(se.le.se_rl)  then
          se = se_rl
             d_pc = -(denw*se**(-1.d0 - 1.d0/msw)*(-1.d0 
     *        + se**(-1.d0/msw))**(-1.d0 + 1.d0/nsw)/(asd(ik)*msw*nsw))
     *             /(1.d0-swr(ik))     
             pcc  = denw*(-1.d0 + se**(-1.d0/msw))**(1.d0/nsw)/asd(ik)
c
             swcr = swr(ik) + se_rl*(1.d0-swr(ik))
             pc   = pcc + (sw - swcr)*d_pc
c
        else
c
             d_pc = -(denw*se**(-1.d0 - 1.d0/msw)*(-1.d0 
     *        + se**(-1.d0/msw))**(-1.d0 + 1.d0/nsw)/(asd(ik)*msw*nsw))
     *             /(1.d0-swr(ik))     
             pc = denw*(-1.d0 + se**(-1.d0/msw))**(1.d0/nsw)/asd(ik)
c
        endif
c
c Buckley Leverett and Gottfried
c            d_pc   = -1.0d+1
c            pc   = (sw - 1.d0)*d_pc
c
       else
c HYSTERESIS
c determine the appropriate value for Se drainage/imbibition
            if(nhc_w(ik).eq.2)  then
              if (sb_w(ik,2).gt.(swt_c(ik)+1.d-4)
     &            .and. sw.lt.sb_w(ik,2)-epsil ) then
c             revert to curve 1
                 sr = sr_w(ik,1)
                 ss = ss_w(ik,1)
                 as = asd(ik)
                 nhc_w(ik) = 1
                 a_w(ik,1) = asd(ik)
              else
                 sr = sr_w(ik,2)
                 ss = ss_w(ik,2)
                 as = a_w(ik,2)
              endif
            else if(nhc_w(ik).eq.3)  then
              if( sw.gt.sb_w(ik,3)+epsil )  then
c             revert to curve 2
                 sr = sr_w(ik,2)
                 ss = ss_w(ik,2)
                 as = a_w(ik,2)
                 nhc_w(ik) = 2
              else if( sw.lt.sb_w(ik,2)-epsil )  then
c             close loop to curve 1
                 sr = sr_w(ik,1)
                 ss = ss_w(ik,1)
                 as = asd(ik)
                 nhc_w(ik) = 1
                 a_w(ik,1) = asd(ik)
              else 
                 sr = sr_w(ik,3)
                 ss = ss_w(ik,3)
                 as = a_w(ik,3)
              endif
            else if(nhc_w(ik).eq.4)  then
              if( sw.lt.sb_w(ik,4)-epsil )  then
c             revert to curve 3
                 sr = sr_w(ik,3)
                 ss = ss_w(ik,3)
                 as = a_w(ik,3)
                 nhc_w(ik) = 3
              else if( sw.gt.sb_w(ik,3)+epsil )  then
c             close loop to curve 2
                 sr = sr_w(ik,2)
                 ss = ss_w(ik,2)
                 as = a_w(ik,2)
                 nhc_w(ik) = 2
              else 
                 sr = sr_w(ik,4)
                 ss = ss_w(ik,4)
                 as = a_w(ik,4)
              endif
            else
                 sr = sr_w(ik,1)
                 ss = ss_w(ik,1)
                 as = asd(ik)    
            endif
c
                 se = (sw - sr) / (ss - sr)
c
        if( se.ge.(1.d0 - se_sl) )  then
          se = (1.d0 - se_sl)
c
             d_pc = -(denw*se**(-1.d0 - 1.d0/msw)*(-1.d0 
     *            + se**(-1.d0/msw))**(-1.d0 + 1.d0/nsw)
     *            /(as    *msw*nsw)) /(ss - sr)
c
             pcc  = denw*(-1.d0 + se**(-1.d0/msw))**(1.d0/nsw) /as    
             swcs = ss - se_sl * (ss - sr)
             pc   = pcc + (sw - swcs)*d_pc
c
        else if(se.le.se_rl)  then
          se = se_rl
c
             d_pc = -(denw*se**(-1.d0 - 1.d0/msw)*(-1.d0 
     *            + se**(-1.d0/msw))**(-1.d0 + 1.d0/nsw)
     *            /(as    *msw*nsw)) /(ss - sr)
c
             pcc  = denw*(-1.d0 + se**(-1.d0/msw))**(1.d0/nsw)/as    
             swcr = sr + se_rl * (ss - sr)
             pc   = pcc + (sw - swcr)*d_pc
c
        else
c
             d_pc = -(denw*se**(-1.d0 - 1.d0/msw)*(-1.d0 
     *            + se**(-1.d0/msw))**(-1.d0 + 1.d0/nsw)
     *            /(as    *msw*nsw)) /(ss - sr)
             pc = denw*(-1.d0 + se**(-1.d0/msw))**(1.d0/nsw) /as    
c
        endif
c
       endif
c
            return
            end
c************************************************************
c************************************************************
        subroutine sfunkw(sw, rpw, ik)
c************************************************************
c************************************************************
c given  saturation and hysteresis info. find
c water relative permeability
c
c   sw  = Sw at most recent iterate level
c
c   ik = node number
c
c  rpw = Krw (sw)  output
c
c  swt_c(ik)   = the current trapped Sw
c
c  sfact_kr = the minimum se for which rpw > 0
c
        include 'include.f'
        DOUBLE precision msw
c
c xxxxxxxxx      xxxxxxxxxx      xxxxxxxxxxx         xxxxxxxxxxxx
c
          msw = 1.d0-1.d0/shape(ik)
c
      if (nhyst.eq.1) then
c     HYSTERESIS
c
c        if (nsew1.eq.1) then
c         se1  =  ( sw - swt_c(ik) )
c     &         / ( 1.d0 - sgt_c(ik) - snt_c(ik) - swt_c(ik) )
c        else
c         se1 =  ( sw - swt_c(ik) ) / ( 1.d0 - swt_c(ik) )
c        endif
c
c        if (nsew2.eq.1) then
c         se2  =  ( sw - swt_c(ik) )
c     &         / ( 1.d0 - sgt_c(ik) - snt_c(ik) - swt_c(ik) )
c        else
c         se2 =  ( sw - swt_c(ik) ) / ( 1.d0 - swt_c(ik) )
c        endif
c
c**
          se1  =  ( sw - swt_c(ik) )
c    &         / ( 1.d0 - swt_c(ik) )
     &         / ( 1.d0 - sgt_c(ik) - snt_c(ik) - swt_c(ik) )
          se2 = swt_c(ik)
          se3 = sw
c**
      else 
c       no hysteresis
              se1 = ( sw - swr(ik) ) / ( 1.d0 - swr(ik) )
c             se2 = se1
c
c**
          se2 = swr(ik)
          se3 = sw
c**
      endif
c
             if (se1.gt.1.d0)      se1  = 1.d0
             if (se1.lt.sfact_kr)  se1  = 0.d0
c
             if (se2.gt.1.d0)      se2  = 1.d0
             if (se2.lt.0.d0)      se2  = 0.d0
             if(se3  .gt. 1.d0 )       se3  = 1.d0
             if(se3  .lt. 0.d0 )       se3  = 0.d0
c NOTE: Se2 <= Se3
             if(se3.lt. se2 )       se3  = se2
c
c       rpw = se1**alfw*(1.d0 - (1.d0 - se2**(1.d0/msw))**msw)**2
c**
             rpw  =  se1**alfw
     &              * ( (1.d0 -  se2**(1.d0/msw))**msw
     &                - (1.d0 -  se3**(1.d0/msw))**msw )**2
c**
c
c Buckley Leverett 
c          rpw  =     (sw - swr(ik))**2
c Young (figure 12)
c          rpw  =     0.5d0*se**3
c Gottfried et al. 1966
c        rpw  =     (se)**4
 
c
                 return 
                 end
c************************************************************
c************************************************************
        subroutine sfunkn(sw,st, rp_n,ik)
c************************************************************
c given  saturation and hysteresis info. find
c oil relative permeability
c
c   sw  = Sw at most recent iterate level
c   st  = St at most recent iterate level
c
c   ik = node number
c
c  rp_n = Kro (sw)  output
c
c  snt_c(ik)   = the current Sn trapped
c
c  sfact_kr = the minimum se for which rp_n > 0
c
        include 'include.f'
        DOUBLE precision msw
c
c xxxxxxxxx      xxxxxxxxxx      xxxxxxxxxxx         xxxxxxxxxxxx
c
          msw = 1.d0-1.d0/shape(ik)
c
c drainage/imbibition/reversal ...
      if (nhyst.eq.1) then
c     HYSTERESIS
c 1.  Se_n
c        if (nsen1.eq.1) then
c              se1  = ( st - sw - snt_c(ik) )
c     &              / ( 1.d0 - sgt_c(ik) - snt_c(ik) - swt_c(ik) )
c        else if (nsen1.eq.2) then
c              se1  = ( st - sw - snt_c(ik) ) / ( 1.d0 - snt_c(ik) )
c        endif
c 2. Se_Tn
c        if (nsen2.eq.1) then
c               se2  =   ( sw - swt_c(ik) )
c     &               / ( 1.d0 - sgt_c(ik) - snt_c(ik) - swt_c(ik) )
c        else if (nsen2.eq.2) then
c               se2   = 1.d0 - ( 1.d0 - sw - snt_c(ik) -sgt_c(ik) )
c     &               / ( 1.d0 - snt_c(ik) - sgt_c(ik) )
c        else
cc            se2   = 1.d0 - ( 1.d0 - sw - snt_c(ik) )
cc            se2   = ( sw - snt_c(ik) )
cc     &               / ( 1.d0 - snt_c(ik) )
c        endif
c 3.  Se_Tw
c        if (nsen3.eq.1) then
c               se3  = ( st - snt_c(ik) - swt_c(ik) )
c     &               / ( 1.d0 - sgt_c(ik) - snt_c(ik) - swt_c(ik) )
c        else if (nsen3.eq.2) then
c               se3  = ( st - snt_c(ik) - swt_c(ik) )
c     &               / ( 1.d0 - snt_c(ik) - swt_c(ik) )
c        else
cc            se3   = ( st - snt_c(ik) )
cc     &               / ( 1.d0 - snt_c(ik) )
c        endif
c**
             se1  = ( st - sw - snt_c(ik) )
c    &              / ( 1.d0 - snt_c(ik) )
     &              / ( 1.d0 - sgt_c(ik) - snt_c(ik) - swt_c(ik) )
             IF(1.d0-st+sw.lt.epsil) then
c               IT IS ALL NAPL
                se2 = 0.d0
                se3 = 1.d0
             else
                se2   =  sw + snt_c(ik)*(1.d0-st)/(1.d0-st+sw)
                se3   =  st - snt_c(ik)*sw/(1.d0-st+sw)
             endif
c**
      else 
c       no hysteresis (no entrapped NAPL)
c
               se1  =  (st - sw)/(1.d0-swr(ik))
c
c              se2 =  (sw-swr(ik))/(1.d0-swr(ik))
               se2  =  sw
c
c              se3  =  (st-swr(ik))/(1.d0-swr(ik))
               se3  =  st
c
c              se1  =  st - sw
c              se2  =  sw
c              se3  =  st 
      endif
c
                   if(se1  .gt. 1.d0 )       se1  = 1.d0
                   if(se1  .lt. sfact_kr )   se1  = 0.d0   
c
                   if(se2  .gt. 1.d0 )       se2  = 1.d0
                   if(se2  .lt. 0.d0 )       se2  = 0.d0
                   if(se3  .gt. 1.d0 )       se3  = 1.d0       
                   if(se3  .lt. 0.d0 )       se3  = 0.d0   
c NOTE: Se2 <= Se3
             if(se3.lt. se2 )       se3  = se2
c
              rp_n  =  se1**alfn
     &              * ( (1.d0 -  se2**(1.d0/msw))**msw
     &                - (1.d0 -  se3**(1.d0/msw))**msw )**2
c
          if ( rp_n .lt.1.d-6 )  rp_n = 0.d0
c
c &&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
c Buckley Leverett 
c          rp_n  =     (1.d0 - sw - snnr(ik))**2
c Young (figure 12)
c          rp_n  =     senw**3
c Gottfried et al. 1966
c                     so = st - sw
c          rp_n  =     so**3 * (1.d0 - so + sw + 2.d0*swr(ik))
c    &                / (1-swr(ik))**4
c &&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
c---
                 return 
                 end
c
c************************************************************
c************************************************************
        subroutine sfunkg(st, rp_g, ik)
c************************************************************
c************************************************************
c given  saturation and hysteresis info. find
c gas relative permeability
c
c   st  = St at most recent iterate level
c
c   ik = node number
c
c  rp_g = Krg (st)  output
c
c  sgt_c(ik)   = the current trapped Sg
c
c  sfact_kr = the minimum se for which rpg > 0
c
        include 'include.f'
        DOUBLE precision msw
c
c xxxxxxxxx      xxxxxxxxxx      xxxxxxxxxxx         xxxxxxxxxxxx
          msw = 1.d0-1.d0/shape(ik)
c
      if (nhyst.eq.1) then
c     HYSTERESIS
c
c        if (nseg1.eq.1) then
c         se1 = ( 1.d0 - st - sgt_c(ik) )
c     &         / ( 1.d0 - sgt_c(ik) - snt_c(ik) - swt_c(ik) )
c        else
c         se1 = ( 1.d0 - st - sgt_c(ik) ) / ( 1.d0 - sgt_c(ik) )
c        endif
c
c        if (nseg2.eq.1) then
c         se2 = 1.d0 - ( 1.d0 - st - sgt_c(ik) )
c     &         / ( 1.d0 - sgt_c(ik) - snt_c(ik) - swt_c(ik) )
c        else
c         se2 = 1.d0 - ( 1.d0 - st - sgt_c(ik) ) / ( 1.d0 - sgt_c(ik) )
c        endif
c**
         se1 = ( 1.d0 - st - sgt_c(ik) )
c    &         / ( 1.d0 - sgt_c(ik) )
     &         / ( 1.d0 - sgt_c(ik) - snt_c(ik) - swt_c(ik) )
         se2 = st
         se3 = 1.d0 - sgt_c(ik)
c**
c
      else 
c       no hysteresis (no entrapped gas) 
         se1  = ( 1.d0 - st  ) / (1.d0 - swr(ik))
c        se2  = 1.d0 - se1
         se2 = st
         se3 = 1.d0
c
      endif
c
                  if (se1 .gt.1.d0)     se1 = 1.d0
                  if (se1 .lt.sfact_kr) se1 = 0.d0
c
                  if (se2.gt.1.d0)      se2 = 1.d0
                  if (se2.lt.0.d0)      se2 = 0.d0
                  if (se3  .gt. 1.d0 )       se3  = 1.d0
                  if (se3  .lt. 0.d0 )       se3  = 0.d0
c NOTE: Se2 <= Se3
             if( se3.lt. se2 )       se3  = se2
c
c        rp_g = se1**alfg*(1.d0 - se2**(1.d0/msw))**(2.d0*msw)
c**
             rp_g  =  se1**alfg
     &              * ( (1.d0 -  se2**(1.d0/msw))**msw
     &                - (1.d0 -  se3**(1.d0/msw))**msw )**2
c**
c
c Forsyth 1995 and Parker et al. 1987
c                se = (st - swr(ik)) / (1.d0 - swr(ik))
c                 if (se.lt.0.d0)      se = 0.d0
c                 if (se.gt.1.d0-sfact_kr)  se = 1.d0
c               rp_g  =  (1.d0-se)**alfg*
c    &                   (1.d0 - se**(1.d0/msw))**(2.d0*msw)
c
c Buckley Leverett & Young (figure 12)
c          rp_g  =  0.d0
c Gottfried et al. 1966
c            sg = 1.d0-st
c            if(sg.lt.0.d0)  sg = 0.d0
c          rp_g  = sg**3*(2.d0 - sg - 2.d0*swr(ik)) 
c    &                / (1-swr(ik))**4
c---
c
                 return 
                 end
c************************************************************
c************************************************************
        subroutine lev_sw_p ( pc_in, pc_out )
c************************************************************
c************************************************************
c
        include 'include.f'
c
c%%%%%%%%%%%%%%%%%   %%%%%%%%%%%%%  %%%%%%%%%%%%%%%%%%%  %%%%%%%%%%
c IFT scaling for Pcnw:
c
         pc_out = pc_in /b_nw
c Buckley Leverett and Gottfried
c        pc_out = pc_in
c
            return
            end
c
c************************************************************
c************************************************************
        subroutine lev_p_sw ( pc_in, pc_out )
c************************************************************
c************************************************************
c
        include 'include.f'
c
c%%%%%%%%%%%%%%%%%   %%%%%%%%%%%%%  %%%%%%%%%%%%%%%%%%%  %%%%%%%%%%
c IFT scaling for Pcnw:
c
         pc_out = pc_in *b_nw
c
            return
            end
c
c************************************************************
c************************************************************
        subroutine lev_st_p ( pc_in, pc_out )
c************************************************************
c************************************************************
c
        include 'include.f'
c
c%%%%%%%%%%%%%%%%%   %%%%%%%%%%%%%  %%%%%%%%%%%%%%%%%%%  %%%%%%%%%%
c IFT scaling for Pcgn:
c
         pc_out = pc_in /b_gn
c Buckley Leverett and Gottfried
c        pc_out = pc_in
c
            return
            end
c************************************************************
c************************************************************
        subroutine lev_p_st ( pc_in, pc_out )
c************************************************************
c************************************************************
c
        include 'include.f'
c
c%%%%%%%%%%%%%%%%%   %%%%%%%%%%%%%  %%%%%%%%%%%%%%%%%%%  %%%%%%%%%%
c IFT scaling for Pcgn:
c
         pc_out = pc_in *b_gn
c
            return
            end
