C     Last change:  JG   28 Sep 2000    1:16 pm
c
c =====================================================================
c  Generate and solve the linear system of equations for the Rog
c  solution
c  4 routines here which are called as required:
c
c    sys_og_vi (del,iter)= iterative (ILU/GMRES) solution of del
c    sys_og_vd (del) = direct (LU) solution of del
c
c =====================================================================
      subroutine sys_og_i (n_do,iter)
c =====================================================================
c parabolic transport equation setup
c sweep in the shortest direction
c
c  stors the system matrix in slap triad format
c
c  the product of functions cast in basis are delt with by 
c  summing the function cast in lagrange at the collocation
c  point and obtaining a value.
c
c ***********************************************************
        include 'include.f'
c
c ***********************************************************
c 3 steps:
c    1. generate ai*x = ri
c    2. solve for x using iterative solver
c    3. update the global pressure vector
c
c STEP 1.
c XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
c
                nelt = 0
                  n_do = 0
                  iter = 0
c
c loop through all the rows of elements in this subdomain
c
c
       do 5 n2 = 1, n_long-1
c
           if(ixy.eq.1)  then
              dsy = dy(n2)/2.d0
           else
              dsx = dx(n2)/2.d0
           endif 
c
c
       do 10 n1 = 1, (n_short-1)
c
           if(ixy.eq.1)  then
              dsx = dx(n1)/2.d0
           else
              dsy = dy(n1)/2.d0
           endif
c
c the subdomain node numbers making up this element
c where the ordering is the same as for the collocation points
c
      inod(norder(1)) = n_short*(n2-1) + n1
      inod(norder(2)) = n_short*(n2-1) + n1 + 1
      inod(norder(3)) = n_short* n2    + n1
      inod(norder(4)) = n_short* n2    + n1 + 1
c the collocation point numbers for this element
      n_eq(norder(1))= (n2-1)*(n_short-1)*4 + 2*n1 - 1
      n_eq(norder(2))= (n2-1)*(n_short-1)*4 + 2*n1
      n_eq(norder(3))= (n2-1)*(n_short-1)*4 + 2*n1 - 1+ 2*(n_short-1)
      n_eq(norder(4))= (n2-1)*(n_short-1)*4 + 2*n1    + 2*(n_short-1)
c
c loop through the 4 collocation points in the element
c
c elemental node/collocation point numbering order is as follows:
c                                            2 4
c                                            1 3
c collocation point location index = ii
       do 20 ii  = 1, 4
c
           ri(n_eq(ii)) = 0.d0
c
c-------------------------------------------------------------
c    calculate the product functions at this colocation point
c          linear lagrange representation
c-------------------------------------------------------------
             satt  = 0.d0
             ds   = 0.d0
             dg   = 0.d0
c
              vx   = 0.d0
              vy   = 0.d0
c
             poro = 0.d0
c
             dsp_x = 0.d0
             dspxx = 0.d0
             dsp_y = 0.d0
             dspyy = 0.d0
             dsp_xy = 0.d0
             dspxyy = 0.d0
             dspxyx = 0.d0
c
             qg_in = 0.d0 
             qi_og = 0.d0 
c
c         loop through the 4 nodes in this element to get
c         the value of the function at collocation point 'ii'
c
          do 19 i = 1, 4
c
             ino = npt_gs(inod(i) )
c
           call gas_prop (rog11(ino,1),gg,rg,vg)
           dg  = dg  +  rg    *b1(ii,i)
           ds = ds + (1.d0 - rog11(ino,1)/rn_r) *b1(ii,i)
c
c          sgg = 1.d0-stt(ino,1)
c           if ( sgg.lt.0.d0)  sgg = 0.d0
c           if ( sgg.gt.1.d0)  sgg = 1.d0
c          satt = satt +  sgg  *b1(ii,i)
           satt = satt +  (1.d0-stt(ino,1))  *b1(ii,i)
c
           poro  = poro  + por(ino)     *b1(ii,i)
c
           vx = vx + vgx(ino) *b1(ii,i)
           vy = vy + vgy(ino) *b1(ii,i)
c
          call disp_g (ino, dspx, dspy, dspxy)
          dsp_x = dsp_x    + dspx     *b1(ii,i)
          dsp_y = dsp_y    + dspy     *b1(ii,i)
          dsp_xy = dsp_xy  + dspxy    *b1(ii,i)
c
          dspxx = dspxx    + dspx     *bx1(ii,i)/dsx
          dspxyx = dspxyx  + dspxy    *bx1(ii,i)/dsx
          dspyy = dspyy    + dspy     *by1(ii,i)/dsy
          dspxyy = dspxyy  + dspxy    *by1(ii,i)/dsy
c
           if(qiog(ino).gt.1.d-12) then
c            injection only
c            qg_in  = qg_in  +  qg(ino)       *b1(ii,i)
c            qi_og  = qi_og  +  qiog(ino)     *b1(ii,i)
             qg_in  = qg_in  +  qg(ino)       *0.25d0   
             qi_og  = qi_og  +  qiog(ino)     *0.25d0   
           endif
   19    continue
c
cxxxxxxx
c calc the exchange term if it is on
      if(bog_1.gt.0.d0 .or. bowg_1.gt.0.d0) then
        call exch_g (1,ii,dsx,dsy,poro,cog,cowg)
      else
          cog = 0.d0
         cowg = 0.d0
      endif
c==================================================================
c        evaluate the entries in the system matrix
c        there are 16 degrees of freedom per element
c        before bc's reduced out
c
c for this collocation point
c loop through all the nodes in this element
c
         do 23 i = 1, 4
c
                 ino    = npt_gs(inod(i) )
c
c loop through the degrees of freedom at each node
c
          do 24 idf = 1, 4
c
                                  if(idf.eq.2) then
                                                  x1  = dsx
                             else if(idf.eq.3) then
                                                  x1  = dsy
                             else if(idf.eq.4) then
                                                  x1  = dsx*dsy
                             else
                                                  x1  = 1.d0
                             endif
c
c picard
c LHS stuff
c
        abb   = x1*( (poro*satt/dt + qg_in + ds*cog+ds*cowg
     *              + dg*poro*satt*decay/rg_r) * b3(ii,i,idf)
     *        +  vx          * bx3(ii,i,idf)/dsx
     *        +  vy          * by3(ii,i,idf)/dsy
     *        - ( (dspxx+dspxyy)*bx3(ii,i,idf)/dsx
     *        +  (dspxyx+dspyy)*by3(ii,i,idf)/dsy
     *        + dsp_x*bxx3(ii,i,idf)/(dsx*dsx)
     *        + 2.d0*dsp_xy*bxy3(ii,i,idf)/(dsx*dsy)
     *        + dsp_y*byy3(ii,i,idf)/(dsy*dsy)))
c    *        - dg*( (dspxx+dspxyy)*bx3(ii,i,idf)/dsx
c    *        +  (dspxyx+dspyy)*by3(ii,i,idf)/dsy
c    *        + dsp_x*bxx3(ii,i,idf)/(dsx*dsx)
c    *        + 2.d0*dsp_xy*bxy3(ii,i,idf)/(dsx*dsy)
c    *        + dsp_y*byy3(ii,i,idf)/(dsy*dsy))/rg_r)
c
       abb1   =   x1 * b3(ii,i,idf) * poro*satt/dt
c
       x_owg   =   x1*ds*cowg*e_henry * b3(ii,i,idf)
c*********************************************************
c -----
       if(ibc_og(inod(i),idf) .gt. 0)        then
c -----
c          we have a normal entry into the system matrix
                           nelt = nelt + 1
c matrix entry
                           ai(nelt) = abb
c row (equation number)
                           ia(nelt) =  n_eq(ii)
c column (degree of freedom)
                           ja(nelt) =  ibc_og(inod(i),idf)
c -----
           else if(ibc_og(inod(i),idf) .lt. 0)        then
c -----
c 3 rd - type condition
c search for the proper position (1 or 2 back)
              call disp_g (ino, dspx, dspy, dspxy)
        if(ja(nelt) .eq. -ibc_og(inod(i),idf) ) then
            if (idf.eq.2 .or. idf.eq.4) then
c             applied on y-face
              ai(nelt) = ai(nelt) 
     &                 + abb*(vgx(ino) + diffg/d_layer)/dspx
              rog11(ino,idf) = 
     &                 (vgx(ino)+diffg/d_layer)/dspx * rog11(ino,idf-1)
            else
c             a corner - applied on x-face
              ai(nelt) = ai(nelt) 
     &                 + abb*(vgy(ino) + diffg/d_layer)/dspy
              rog11(ino,3) = 
     &                 (vgy(ino)+diffg/d_layer)/dspy * rog11(ino,1)
            endif 
        else if(ja(nelt-1) .eq. -ibc_og(inod(i),idf) ) then
             if (idf.eq.3 .or. idf.eq.4) then
c             applied on x-face
              ai(nelt-1) = ai(nelt-1) 
     &                 + abb*(vgy(ino) + diffg/d_layer)/dspy
              rog11(ino,idf) = 
     &                 (vgy(ino)+diffg/d_layer)/dspy * rog11(ino,idf-2)
             else
c             a corner - applied on y-face
              ai(nelt-1) = ai(nelt-1) 
     &                 + abb*(vgx(ino) + diffg/d_layer)/dspx
              rog11(ino,2) = 
     &                 (vgx(ino)+diffg/d_layer)/dspx * rog11(ino,1)
             endif 
        endif 
c
       endif
c
c            RHS
             ri(n_eq(ii)) = ri(n_eq(ii))   
     &                    - abb    * rog11(ino,idf)
     &                    + abb1   *  rogt(ino,idf)
     &                    + x_owg  *  roa_p(ino,idf)
c
   24     continue
c
   23   continue
c
c                 add the exchange part and gravity part
c
       ri(n_eq(ii)) =  ri(n_eq(ii)) +  ds*cog*parog + qi_og
c
       if ( dabs(ri(n_eq(ii))).gt.1.d-15 ) n_do = 1
c
   20   continue
   10   continue
    5   continue
c
      if ( n_do.eq.1 )  then
c there was forcing so solve the system!
c XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
c STEP 2.
c XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
c for all those nodes where Sg < epsilon assume
c that the change in solution over the time step is ZERO
c Do this by 
c    1 looping through all the nodes in the mesh
c    2 at each node check for Sg < epsilon
c    3 if yes, then for all the df's associated with the node
c      zero out the row, put a 1 on the main diagonal, and 
c      set RHS = 0.
c       -------------------------
        call alt_cg(nelt,ri_max)
c       -------------------------
        if ( ri_max.lt.1.d-15 ) then
             n_do = 0
                 return
        endif
c
c XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
c STEP 3.
c XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
c have Ax = b, now solve for x
c      call dslugm(nequ, ri, sol_g, nelt, ia, ja, ai, 0, nsave,
c     $     0, erit, itermx, iter, err, ierr, 0,
c     $     rwork, lenw, iwork, leniw)
      call DSLUCS (nequ, ri, sol_g, nelt, ia, ja, ai, 0,
     +   2, erit, itermx, iter, err, ierr, 6,
     +   rwork, lenw, iwork, leniw)
c
                   if(iscr.eq.1) then
                    write(6,111) iter
  111               format(' Rog - BiCG',1x,i3)
                   endif
              if (ierr.ne.0) then
                   write(6,*) ' ERROR in   Rog_v     MATRIX SOLVER '
                   write(6,*) ierr
                    write(4,*) ' ERROR in  Rog_v     MATRIX SOLVER '
                   write(4,*) time
                     stop
               endif
c
      endif
                                return 
                                end
c=====================================================================
      subroutine alt_cg(nelt,ri_max)
c=====================================================================
c FOR GMRES SOLVER
c for all those nodes where Sg < epsilon assume
c that the change in solution over the time step is ZERO
c
c routine to interrogate each node for the saturation
c if no gas is present then assume that the solution to the napl
c in gas species transport equation is known at that node. 
c This is equivalent to
c zeroing out the row of the system matrix associated with that 
c degree of freedom and putting a 1 on the diagonal (column 3);
c also the RHS is set to 0 (ie the change in the value is 0).
c n = number of nodes
        include 'include.f'        
c
c*********************************************************************
c loop through the nodes in this sweep
c check the saturation at each node. if it is less than some min
c then assume the soln is known 
c
         ri_max = 0.d0
c    loop through the nodes
         do 10 i = 1, nn
                 ino    = npt_gs(i)
            sg = 1.d0 - st11(ino,1)
c    check for critical gas saturation
             if (sg.lt.0.0020d0)  then
c
c    loop through the df's at this node
                 do 11 idf=1,4
c    each of the active df's at this node are known
c
                  if (ibc_og(i,idf).ne.0) then
c    active df
                    ntag = 0
                    nro = ibc_og(i,idf)
                    ri(nro) = 0.d0 
c
c    find all the nonzero entries in this nro (<=16)
                    do 12 j = 1, nelt
                         if (ia(j).eq.nro)    then
                             ntag = 1
                             if (ja(j).eq.nro)    then
                               ai(j) = 1.d0
                             else
                               ai(j) = 0.d0
                             endif
                         else if (ntag .gt.0)    then
                          go to 11
                         endif
   12               continue
c
                  endif
   11            continue
c
             else
                 do 21 idf=1,4
                  if (ibc_og(i,idf).ne.0) then
c                 active df
                    nro = ibc_og(i,idf)
                    if(ri_max.lt.dabs(ri(nro))) ri_max = dabs(ri(nro))
                  endif
   21            continue
             endif
c
   10    continue
c
c
              return
              end
