C     Last change:  JG   28 Sep 2000    1:16 pm
c =====================================================================
c  Generate and solve the linear system of equations for the flow 
c  solution
c
c =====================================================================
      subroutine  system_pi (n_do,iter)
c =====================================================================
c FOR THE BiCG SOLVER
c elliptic water pressure equation setup
c sweep in the shortest direction
c
c  stors the system matrix in slap triad format
c
c  the product of functions cast in basis are delt with by 
c  summing the function cast in lagrange at the collocation
c  point and obtaining a value.
c
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c VARIABLES [external = variable set outside subroutine
c            internal =  variable set inside subroutine (indicate file where set)]
c            variable followed by (i) indicates vector
c
c   n_do     = flag to solve system or not (if no forcing then don't solve)[internal]
c   nelt     = total number of entries in the system matrix (ai) [internal]
c   n_short  = number of nodes in the short dimension of the grid[external, main]
c   n_long   =  number of nodes in the long dimension of the grid [external, main]
c   ixy      = flag indicating node numbering scheme: shortest direction first numbering:
c              ixy=1, then nodes are numbered in x first
c              ixy=2, then number in y first
c              [external, main]
c   dsy      = grid spacing in y for the current element [internal]
c   dsx      =  grid spacing in x for the current element [internal]
c   dy(i)    = vector of grid spacing in y [external, main]
c   dx(i)    = vector of grid spacing in x [external, main]
c   inod(i)  = node numbering for this element (4) [internal]
c   n_eq(i)  = collocation point numbers (equation numbers) for this element [internal]
c   norder(i)= the order to take the four nodes/collocation points
c              (depends on ixy) [external, main]
c   ri(i)       = RHS of matrix equation [internal]
c
c Linear Lagrange variables defined at the collocation point (loop 19)
c   poro     = porosity
c   rp_g     = gas mobility
c   rp_gy    = derivative in y
c   rp_gx    = derivative in x
c   rp_w     = water mobility
c   rp_wy    = derivative in y
c   rp_wx    = derivative in x
c   rp_n     = NAPL mobility
c   rp_ny    = derivative in y
c   rp_nx    = derivative in x
c   rp_wng   = total mobility
c   rp_wngx  = derivative in y
c   rp_wngy  = derivative in x
c   dg       = gas density
c   dw       = water density
c   dgx      = derivative in x
c   dgy      = derivative in y
c   dwx      = derivative in x
c   dwy      = derivative in y
c   qt       = well rate (NOTE, equal weight at collocation points)
c
c
c
c
c
c
c
c
c
c
c
c  ibc_p (i) = vector indicating the DF number and the BC status
c              of each Hermite variable in the mesh.
c              If the Hermite variable is a BC then it = 0.
c              Nodes are numbered in the shortest-direction-first.
c              Hermite variables are numbered along the shortest grid line
c              with variables grouped as 
c  ai(i) = the system matrix (stored as a vector with 'nelt' entries)      [internal]
c  ia(i) = index of the equation number (the row of the system matrix, ai) [internal]
c  ja(i) = index of the degree of freedom (the column of the system matrix)[internal]
c
c
c
c
c
c
c
c
c
c Setup procedure:
c STEP 1 - Set up the matrix equation: Ai * x = Ri
c  * loop over elements (shortest direction first) => loops 5 and 10
c  * for each element, loop over the 4 collocation points (loop 20)
c  * at each collocation point, evaluate all independent variables
c       - Lagrange interpolation (loop 19)
c  *
c
c STEP 2 - solve for x using BiCG iterative solver (subroutine dslucs)
c%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c
c ***********************************************************
        include 'include.f'
c
c ***********************************************************
c 2 steps:
c    1. generate ai*x = ri
c    2. solve for x using iterative solver
c
c STEP 1.
c XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
                  n_do = 0
                  nelt = 0
c
c loop through all the elements in this subdomain
c do so in the shortest dimensions first
c
       do 5 n2 = 1, n_long-1
c
           if(ixy.eq.1)  then
              dsy = dy(n2)/2.d0
           else
              dsx = dx(n2)/2.d0
           endif 
c
       do 10 n1 = 1, (n_short-1)
c
           if(ixy.eq.1)  then
              dsx = dx(n1)/2.d0
           else
              dsy = dy(n1)/2.d0
           endif 
c
c the node numbers making up this element
c where the ordering is the same as for the collocation points
c
      inod(norder(1)) = n_short*(n2-1) + n1
      inod(norder(2)) = n_short*(n2-1) + n1 + 1
      inod(norder(3)) = n_short* n2    + n1
      inod(norder(4)) = n_short* n2    + n1 + 1
c the collocation point numbers for this element
      n_eq(norder(1))= (n2-1)*(n_short-1)*4 + 2*n1 - 1
      n_eq(norder(2))= (n2-1)*(n_short-1)*4 + 2*n1
      n_eq(norder(3))= (n2-1)*(n_short-1)*4 + 2*n1 - 1+ 2*(n_short-1)
      n_eq(norder(4))= (n2-1)*(n_short-1)*4 + 2*n1    + 2*(n_short-1)
c
c loop through the 4 collocation points in the element
c
c elemental node/collocation point numbering order is as follows:
c                                            2 4
c                                            1 3
c collocation point location index = ii
       do 20 ii  = 1, 4
c
           ri(n_eq(ii)) = 0.d0
c
c-------------------------------------------------------------
c    calculate the product functions at this colocation point
c          linear lagrange representation
c-------------------------------------------------------------
c
c associated with total flow
             poro  = 0.d0
c
             rp_g   = 0.d0
             rp_gy  = 0.d0
             rp_gx  = 0.d0
c
             rp_w   = 0.d0
             rp_wy  = 0.d0
             rp_wx  = 0.d0
c
             rp_n   = 0.d0
             rp_ny  = 0.d0
             rp_nx  = 0.d0
c
             rp_wng   = 0.d0
             rp_wngx  = 0.d0
             rp_wngy  = 0.d0
c
             dg   = 0.d0
             dw   = 0.d0
             dgx  = 0.d0
             dgy  = 0.d0
             dwx  = 0.d0
             dwy  = 0.d0
c
              qt = 0.d0
c
c            dsp_xw = 0.d0
c            dspxxw = 0.d0
c            dsp_yw = 0.d0
c            dspyyw = 0.d0
c            dsp_xyw = 0.d0
c            dspxyyw = 0.d0
c            dspxyxw = 0.d0
c            satt    = 0.d0
c            dsp_xg = 0.d0
c            dspxxg = 0.d0
c            dsp_yg = 0.d0
c            dspyyg = 0.d0
c            dsp_xyg = 0.d0
c            dspxyyg = 0.d0
c            dspxyxg = 0.d0
c            sgtt    = 0.d0
c            pow    = 0.d0
c
c         loop through the 4 nodes in this element to get
c         the value of the function at collocation point 'ii'
c
          do 19 i = 1, 4
c
             ino = npt_gs(inod(i))
c
            call  water_prop (roa11(ino,1),wa,rw,vw)
            call    gas_prop (rog11(ino,1),gg,rg,vg)
c
           poro  = poro  + por(ino)   *b1(ii,i)
c
c
c NAPL mobility
          rp_n  = rp_n  + perm(ino)*rpn(ino)/vn_r    *b1(ii,i) 
          rp_nx = rp_nx + perm(ino)*rpn(ino)/vn_r    *bx1(ii,i) /dsx
          rp_ny = rp_ny + perm(ino)*rpn(ino)/vn_r    *by1(ii,i) /dsy
c
c water mobility
          rp_w  = rp_w  + perm(ino)*rpa(ino)/vw *b1(ii,i) 
          rp_wx = rp_wx + perm(ino)*rpa(ino)/vw *bx1(ii,i) /dsx
          rp_wy = rp_wy + perm(ino)*rpa(ino)/vw *by1(ii,i) /dsy
c
c gas mobility
          rp_g  = rp_g  + perm(ino)*rpg(ino)/vg *b1(ii,i) 
          rp_gx = rp_gx + perm(ino)*rpg(ino)/vg *bx1(ii,i) /dsx
          rp_gy = rp_gy + perm(ino)*rpg(ino)/vg *by1(ii,i) /dsy
c
c total mobility = (water mobility + gas mobility + NAPL mobility)
          rp_wng = rp_wng + perm(ino)*
     &               (  rpa(ino)/vw 
     &                + rpn(ino)/vn_r
     &                + rpg(ino)/vg )    *b1(ii,i) 
          rp_wngx = rp_wngx + perm(ino)*
     &               (  rpa(ino)/vw 
     &                + rpn(ino)/vn_r
     &                + rpg(ino)/vg )    *bx1(ii,i) /dsx
          rp_wngy = rp_wngy + perm(ino)*
     &               (  rpa(ino)/vw 
     &                + rpn(ino)/vn_r
     &                + rpg(ino)/vg )    *by1(ii,i) /dsy
c
           if(qw(ino)+qn(ino)+qg(ino).gt. 1.d-12) then
c           qt = qt + (qw(ino)+qn(ino)+qg(ino)) *b1(ii,i)
            qt = qt + (qw(ino)+qn(ino)+qg(ino)) *0.25d0   
           else 
c           qt = qt + (qw(ino)+qn(ino)+qg(ino)) *b1(ii,i)
            qt = qt + (qw(ino)+qn(ino)+qg(ino)) *0.25d0   
           endif
c
           dg  = dg  +  rg    *b1(ii,i)
           dgx = dgx +  rg    *bx1(ii,i)/dsx
           dgy = dgy +  rg    *by1(ii,i)/dsy
           dw  = dw  +  rw    *b1(ii,i)
           dwx = dwx +  rw    *bx1(ii,i)/dsx
           dwy = dwy +  rw    *by1(ii,i)/dsy
c
c          pow = pow + p_ow(ino)  *b1(ii,i)
c          satt = satt +  swt(ino,1)  *b1(ii,i)
c          sgtt = sgtt +  (1.d0-stt(ino,1))  *b1(ii,i)
c         call disp_w (ino, dspx, dspy, dspxy)
c         dsp_xw = dsp_xw    + dspx  *b1(ii,i)
c         dsp_yw = dsp_yw    + dspy  *b1(ii,i)
c         dsp_xyw = dsp_xyw  + dspxy *b1(ii,i)
c         dspxxw = dspxxw    + dspx      *bx1(ii,i)/dsx
c         dspxyxw = dspxyxw  + dspxy     *bx1(ii,i)/dsx
c         dspyyw = dspyyw    + dspy      *by1(ii,i)/dsy
c         dspxyyw = dspxyyw  + dspxy     *by1(ii,i)/dsy
c
c         call disp_g (ino, dspx, dspy, dspxy)
c         dsp_xg = dsp_xg    + dspx     *b1(ii,i)
c         dsp_yg = dsp_yg    + dspy     *b1(ii,i)
c         dsp_xyg = dsp_xyg  + dspxy    *b1(ii,i)
c         dspxxg = dspxxg    + dspx     *bx1(ii,i)/dsx
c         dspxyxg = dspxyxg  + dspxy    *bx1(ii,i)/dsx
c         dspyyg = dspyyg    + dspy     *by1(ii,i)/dsy
c         dspxyyg = dspxyyg  + dspxy    *by1(ii,i)/dsy
   19    continue
c
cxxxxxxx
c calc the exchange term if transport is on
c
c     if(ntr_og.gt.0) then
c        call exch_g (1,ii,dsx,dsy,poro,cog,cowg)
c     else
c          cog  = 0.d0
c          cowg  = 0.d0
c     endif
c
c==================================================================
c        evaluate the entries in the system matrix
c        there are 16 degrees of freedom per element
c        before BC's are reduced out
c
c for this collocation point 
c loop through all the nodes in this element
c
         do 23 i = 1, 4
c
                 ino    = npt_gs(inod(i) )
c
c loop through the degrees of freedom at each node
c
          do 24 idf = 1, 4
c
c  Evaluate the Hermite coefficients for the Capillary Pressure
c  Pcnw and Pcgn
c
         if(idf.eq.2) then
c        x-derivative
                      x1  = dsx
                      if(dabs(sw11(ino,2)).lt.1.d-10)  then
                         pcnw =  0.d0
                      else
                         pcnw =  dpcnw (ino) * sw11(ino,2)
                      endif
                      if(dabs(st11(ino,2)).lt.1.d-10)  then
                         pcgn =  0.d0
                      else
                         pcgn =  dpcgn (ino) * st11(ino,2)
                      endif
         else if(idf.eq.3) then
c        y-derivative
                      x1  = dsy
                      if(dabs(sw11(ino,3)).lt.1.d-10)  then
                         pcnw =  0.d0
                      else
                         pcnw =  dpcnw (ino) * sw11(ino,3)
                      endif
                      if(dabs(st11(ino,3)).lt.1.d-10)  then
                         pcgn =  0.d0
                      else
                         pcgn =  dpcgn (ino) * st11(ino,3)
                      endif
         else if(idf.eq.4) then
c        cross-derivative
                      x1  = dsx*dsy
                      if(dabs(sw11(ino,4)).lt.1.d-10)  then
                         pcnw =  0.d0
                      else
                         pcnw =  dpcnw (ino) * sw11(ino,4)
                      endif
                      if(dabs(st11(ino,4)).lt.1.d-10)  then
                         pcgn =  0.d0
                      else
                         pcgn =  dpcgn (ino) * st11(ino,4)
                      endif
         else
c        function
                       x1  = 1.d0
                       pcnw = pcnw1(ino)
                       pcgn = pcgn1(ino)
         endif
c
c The 3 Hermite variables are Pw, Pcnw and Pcgn
c LHS stuff
c
        pw_t     =    x1*(     rp_wng  *(bxx3(ii,i,idf)/(dsx*dsx)
     *                     +            byy3(ii,i,idf)/(dsy*dsy))
     *                     +  rp_wngx  *bx3 (ii,i,idf)/dsx
     *                     +  rp_wngy  *by3 (ii,i,idf)/dsy  )
c
        pc_n     =    x1*(     rp_n  *(bxx3(ii,i,idf)/(dsx*dsx)
     *                     +          byy3(ii,i,idf)/(dsy*dsy))
     *                     +  rp_nx  *bx3 (ii,i,idf)/dsx
     *                     +  rp_ny  *by3 (ii,i,idf)/dsy )
c
        pc_g     =    x1*(     rp_g  *(bxx3(ii,i,idf)/(dsx*dsx)
     *                     +          byy3(ii,i,idf)/(dsy*dsy))
     *                     +  rp_gx  *bx3 (ii,i,idf)/dsx
     *                     +  rp_gy  *by3 (ii,i,idf)/dsy )
c
c      abbg  = x1*(
c    &         (1.d0-rg_r/rn_r)*poro*sgtt*decay/rg_r* b3(ii,i,idf)
c    *        - (1.d0-rg_r/rn_r)*((dspxxg+dspxyyg)*bx3(ii,i,idf)/dsx
c    *           +  (dspxyxg+dspyyg)*by3(ii,i,idf)/dsy
c    *           + dsp_xg*bxx3(ii,i,idf)/(dsx*dsx)
c    *           + 2.d0*dsp_xyg*bxy3(ii,i,idf)/(dsx*dsy)
c    *           + dsp_yg*byy3(ii,i,idf)/(dsy*dsy))/dg)
c
c       abbw  = x1*( 
c    *          (  pow*decay/rn_r
c    &          - (1.d0-rw_r/rn_r)*poro*satt*decay/rw_r)* b3(ii,i,idf)
c    *        + (1.d0-rw_r/rn_r) *((dspxxw+dspxyyw)*bx3(ii,i,idf)/dsx
c    *        +  (dspxyxw+dspyyw)*by3(ii,i,idf)/dsy
c    *        + dsp_xw*bxx3(ii,i,idf)/(dsx*dsx)
c    *        + 2.d0*dsp_xyw*bxy3(ii,i,idf)/(dsx*dsy)
c    *        + dsp_yw*byy3(ii,i,idf)/(dsy*dsy))/dw)
c
c       abbw1  = x1*pow/rn_r/dt * b3(ii,i,idf)
c*********************************************************
c  system matrix - SLAP TRIAD FORMAT  (see DSLUCS.FOR for explanation)
c
c  is this DF a BC, if not enter in the system matrix AI
           if(ibc_p(inod(i),idf) .ne. 0)        then
c          we have an entry into the system matrix
                           nelt = nelt + 1
c matrix entry
                           ai(nelt) =  - pw_t
c row (equation number)
                           ia(nelt) =  n_eq(ii)
c column (degree of freedom)
                           ja(nelt) =  ibc_p(inod(i),idf)
c
           endif
c
c **** RHS ****
       ri(n_eq(ii)) = ri(n_eq(ii)) 
     &  +  pw_t                 * pa11(ino,idf)
     &  +  pc_n                 * pcnw
     &  +  pc_g                 *(pcnw + pcgn)
c    &  + abbg                  * rog_p(ino,idf)
c    &  - abbw                  * roa_p(ino,idf)
c    &  - abbw1                 *(roa_p(ino,idf) - roat(ino,idf))
c
   24     continue
c
   23   continue
c
c   add the exchange part and gravity part to the RHS
c
             ri(n_eq(ii)) = ri(n_eq(ii)) + qt
     *       - grav*(  dcos(thgx)*
     &        (rp_wx*dw + rp_w*dwx + rp_gx*dg + rp_g*dgx + rn_r*rp_nx)
     *                 + dcos(thgy)*
     &        (rp_wy*dw + rp_w*dwy + rp_gy*dg + rp_g*dgy + rn_r*rp_ny) )
c
       if ( dabs(ri(n_eq(ii))).gt.1.d-15 ) n_do = 1
   20   continue
   10   continue
    5   continue
c
      if ( n_do.eq.1 )  then
c there was forcing so solve the system!
c XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
c STEP 2.
c XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
c
c have Ax = b, now solve for x
c
c Set the first guess at the solution
c        = the solution to the last time step
        do 301 j = 1, nn
         do 300 k = 1, 4
           if(ibc_p(j,k).ne.0)  then
              sol_w(ibc_p(j,k)) = pat(npt_gs(j),k) 
           endif
  300    continue
  301   continue
c
c preconditioned GMRES CG solver
c      call dslugm(nequ, ri, sol_w, nelt, ia, ja, ai, 0, nsave,
c     $     0, erip, itermx, iter, err, ierr, 6,
c     $     rwork, lenw, iwork, leniw)
c
c preconditioned BiCG solver
      call DSLUCS (nequ, ri, sol_w, nelt, ia, ja, ai, 0,
     +   2, erip, itermx, iter, err, ierr, 0,
     +   rwork, lenw, iwork, leniw)
c
c How did we do: write statements
                if (iscr.eq.1) then
                  write(6,111) iter
 111              format(' P - BiCG (',i3,')'/)
                endif
              if (ierr.ne.0) then
                   write(6,*) ' ERROR in    Pw_v     MATRIX SOLVER '
                   write(6,*) ierr
                    write(4,*) ' ERROR in    Pw_v     MATRIX SOLVER '
                   write(4,*) time
                     stop
               endif
c
      endif
                                return 
                                end
