C     Last change:  JG   28 Sep 2000    1:15 pm
c
c               THE WATER PHASE BALANCE EQUATION
c =====================================================================
c  Generate and solve the linear system of equations for the Sw
c  solution
c  4 routines here which are called as required:
c
c    system_wvi (del) = iterative (ILU/GMRES) solution of del
c    system_wvd (del) = direct (LU) solution of del
c
c
c =====================================================================
      subroutine system_wi (n_do,iter)
c =====================================================================
c INHOMOGENEOUS SETUP
c                      A*{St} = [rhs]
c =====================================================================
c  stors the system matrix in slap triad format
c
c  the product of functions cast in basis are delt with by 
c  summing the function cast in lagrange at the collocation
c  point and obtaining a value.
c
c ***********************************************************
        include 'include.f'
c
c ***********************************************************
c 3 steps:
c    1. generate ai*x = ri
c    2. solve for x using iterative solver
c    3. update the global pressure vector
c
c STEP 1.
c XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
c
                nelt = 0
                  n_do = 0
                  iter = 0
c
c loop through all the rows of elements in this subdomain
c
c
       do 5 n2 = 1, n_long-1
c
           if(ixy.eq.1)  then
              dsy = dy(n2)/2.d0
           else
              dsx = dx(n2)/2.d0
           endif 
c
c
       do 10 n1 = 1, (n_short-1)
c
           if(ixy.eq.1)  then
              dsx = dx(n1)/2.d0
           else
              dsy = dy(n1)/2.d0
           endif
c
c the subdomain node numbers making up this element
c where the ordering is the same as for the collocation points
c
      inod(norder(1)) = n_short*(n2-1) + n1
      inod(norder(2)) = n_short*(n2-1) + n1 + 1
      inod(norder(3)) = n_short* n2    + n1
      inod(norder(4)) = n_short* n2    + n1 + 1
c the collocation point numbers for this element
      n_eq(norder(1))= (n2-1)*(n_short-1)*4 + 2*n1 - 1
      n_eq(norder(2))= (n2-1)*(n_short-1)*4 + 2*n1
      n_eq(norder(3))= (n2-1)*(n_short-1)*4 + 2*n1 - 1+ 2*(n_short-1)
      n_eq(norder(4))= (n2-1)*(n_short-1)*4 + 2*n1    + 2*(n_short-1)
c
c loop through the 4 collocation points in the element
c
c elemental node/collocation point numbering order is as follows:
c                                            2 4
c                                            1 3
c collocation point location index = ii
       do 20 ii  = 1, 4
c
           ri(n_eq(ii)) = 0.d0
c
c-------------------------------------------------------------
c    calculate the product functions at this colocation point
c          linear lagrange representation
c-------------------------------------------------------------
c associated with water flow
             poro   = 0.d0
c
             d_pgn   = 0.d0
             d_pgnx  = 0.d0
             d_pgny  = 0.d0
c
             d_pnw   = 0.d0
             d_pnwx  = 0.d0
             d_pnwy  = 0.d0
c
              hnw  = 0.d0
              hnwy = 0.d0
              hnwx = 0.d0
c
              hgw  = 0.d0
              hgwy = 0.d0
              hgwx = 0.d0
c
              ffw  = 0.d0
              ffwx = 0.d0
              ffwy = 0.d0
c
            vtoty  = 0.d0
c           vtotyy = 0.d0
            vtotx  = 0.d0
c           vtotxx = 0.d0
c
c            satt    = 0.d0
c            pow    = 0.d0
c            dsp_x = 0.d0
c            dspxx = 0.d0
c            dsp_y = 0.d0
c            dspyy = 0.d0
c            dsp_xy = 0.d0
c            dspxyy = 0.d0
c            dspxyx = 0.d0
c
             f_rn  = 0.d0
             f_rnx = 0.d0
             f_rny = 0.d0
c
             f_rg  = 0.d0
             f_rgx = 0.d0
             f_rgy = 0.d0
c
             dg   = 0.d0
             dw   = 0.d0
             dgx  = 0.d0
             dgy  = 0.d0
             dwx  = 0.d0
             dwy  = 0.d0
c
             qw_in = 0.d0
c            qi_ow = 0.d0
             qt    = 0.d0
c
c         loop through the 4 nodes in this element to get
c         the value of the function at collocation point 'ii'
c
          do 19 i = 1, 4
c
             ino = npt_gs(inod(i))
c
           call  water_prop (roa11(ino,1),wa,rw,vw)
           call    gas_prop (rog11(ino,1),gg,rg,vg)
c
           poro  = poro  + por(ino)     *b1(ii,i)
c
           if(qw(ino)+qn(ino)+qg(ino).gt. 1.d-12) then
c            qt     = qt     + (qw(ino)+qn(ino)+qg(ino))  *b1(ii,i)
c            qw_in  = qw_in  +  qw(ino)                   *b1(ii,i)
c            qi_ow = qi_ow + (qiow(ino)-qw(ino)*roa11(ino,1))*b1(ii,i)
             qt     = qt     + (qw(ino)+qn(ino)+qg(ino))  *0.25d0   
             qw_in  = qw_in  +  qw(ino)                   *0.25d0   
c            qi_ow = qi_ow + (qiow(ino)-qw(ino)*roa11(ino,1))*0.25d0
           endif
c
           d_pnw   = d_pnw   + dpcnw(ino) *b1(ii,i)
           d_pnwx  = d_pnwx  + dpcnw(ino) *bx1(ii,i)/dsx
           d_pnwy  = d_pnwy  + dpcnw(ino) *by1(ii,i)/dsy
c
           d_pgn   = d_pgn   + dpcgn(ino) *b1(ii,i)
           d_pgnx  = d_pgnx  + dpcgn(ino) *bx1(ii,i)/dsx
           d_pgny  = d_pgny  + dpcgn(ino) *by1(ii,i)/dsy
c
c       ####################################################
c fractional flow of water
         ffw  = ffw  + b1(ii,i) * rpa(ino)
     &    /(rpa(ino) + vw/vg*rpg(ino) + vw/vn_r*rpn(ino))
         ffwx  = ffwx  + bx1(ii,i)/dsx * rpa(ino)
     &    /(rpa(ino) + vw/vg*rpg(ino) + vw/vn_r*rpn(ino))
         ffwy  = ffwy  + by1(ii,i)/dsy * rpa(ino)
     &    /(rpa(ino) + vw/vg*rpg(ino) + vw/vn_r*rpn(ino))
c
c          applied to gravity term 
c FFw *  mob_n 
         f_rn  = f_rn  + b1(ii,i) * rpa(ino)
     &    /(rpa(ino) + vw/vg*rpg(ino) + vw/vn_r*rpn(ino))
     &    * perm(ino)* rpn(ino)/vn_r 
         f_rnx  = f_rnx  + bx1(ii,i)/dsx * rpa(ino)
     &    /(rpa(ino) + vw/vg*rpg(ino) + vw/vn_r*rpn(ino))
     &    * perm(ino)* rpn(ino)/vn_r 
         f_rny  = f_rny  + by1(ii,i)/dsy * rpa(ino)
     &    /(rpa(ino) + vw/vg*rpg(ino) + vw/vn_r*rpn(ino))
     &    * perm(ino)* rpn(ino)/vn_r 
c
c          applied to diffusion term (from routine mp_diff)
c FFw *  mob_n * h_nw
         hnw  = hnw  + b1(ii,i) * h_nw(ino) * rpa(ino)
     &    /(rpa(ino) + vw/vg*rpg(ino) + vw/vn_r*rpn(ino))
     &    * perm(ino)* rpn(ino)/vn_r 
          hnwx  =  hnwx  + bx1(ii,i)/dsx * h_nw(ino) * rpa(ino)
     &    /(rpa(ino) + vw/vg*rpg(ino) + vw/vn_r*rpn(ino))
     &    * perm(ino)* rpn(ino)/vn_r 
          hnwy  =  hnwy  + by1(ii,i)/dsy * h_nw(ino) * rpa(ino)
     &    /(rpa(ino) + vw/vg*rpg(ino) + vw/vn_r*rpn(ino))
     &    * perm(ino)* rpn(ino)/vn_r 
c
c          applied to gravity term 
c FFw * mob_g
         f_rg  = f_rg  + b1(ii,i) * rpa(ino)
     &    /(rpa(ino) + vw/vg*rpg(ino) + vw/vn_r*rpn(ino))
     &    * perm(ino)* rpg(ino)/vg 
         f_rgx  = f_rgx  + bx1(ii,i)/dsx * rpa(ino)
     &    /(rpa(ino) + vw/vg*rpg(ino) + vw/vn_r*rpn(ino))
     &    * perm(ino)* rpg(ino)/vg 
         f_rgy  = f_rgy  + by1(ii,i)/dsy * rpa(ino)
     &    /(rpa(ino) + vw/vg*rpg(ino) + vw/vn_r*rpn(ino))
     &    * perm(ino)* rpg(ino)/vg 
c
c          applied to diffusion term (from routine mp_diff)
c FFw * mob_g * h_gw
          hgw  =  hgw  + b1(ii,i) * h_gw(ino) * rpa(ino)
     &    /(rpa(ino) + vw/vg*rpg(ino) + vw/vn_r*rpn(ino))
     &    * perm(ino)* rpg(ino)/vg 
          hgwx  =  hgwx  + bx1(ii,i)/dsx * h_gw(ino) * rpa(ino)
     &    /(rpa(ino) + vw/vg*rpg(ino) + vw/vn_r*rpn(ino))
     &    * perm(ino)* rpg(ino)/vg 
          hgwy  =  hgwy  + by1(ii,i)/dsy * h_gw(ino) * rpa(ino)
     &    /(rpa(ino) + vw/vg*rpg(ino) + vw/vn_r*rpn(ino))
     &    * perm(ino)* rpg(ino)/vg 
c
c TOTAL VELOCITY AND DIVERGENCE OF TOTAL VELOCITY
         vtotx = vtotx + vtx(ino) *b1(ii,i)
         vtoty = vtoty + vty(ino) *b1(ii,i)
c        vtotxx = vtotxx + vtx(ino) *bx1(ii,i)/dsx
c        vtotyy = vtotyy + vty(ino) *by1(ii,i)/dsy
c
c for concentration dependence
c          pow = pow + p_ow(ino)  *b1(ii,i)
c          satt = satt +  swt(ino,1)  *b1(ii,i)
c         call disp_w (ino, dspx, dspy, dspxy)
c         dsp_x = dsp_x    + dspx  *b1(ii,i)
c         dsp_y = dsp_y    + dspy  *b1(ii,i)
c         dsp_xy = dsp_xy  + dspxy *b1(ii,i)
c
c         dspxx = dspxx    + dspx      *bx1(ii,i)/dsx
c         dspxyx = dspxyx  + dspxy     *bx1(ii,i)/dsx
c         dspyy = dspyy    + dspy      *by1(ii,i)/dsy
c         dspxyy = dspxyy  + dspxy     *by1(ii,i)/dsy
c
c density variation
c
           dw  = dw  + rw  *b1(ii,i)
           dg  = dg  + rg  *b1(ii,i)
           dgx = dgx + rg  *bx1(ii,i)/dsx
           dgy = dgy + rg  *by1(ii,i)/dsy
           dwx = dwx + rw  *bx1(ii,i)/dsx
           dwy = dwy + rw  *by1(ii,i)/dsy
c
   19    continue
cxxxxxxx
c calc the exchange term if transport is on
c
      if(ntr_ow.gt.0) then
        call exch_w (1,ii,dsx,dsy,poro, cow, cowg)
      else
          cow    = 0.d0
          cowg   = 0.d0
      endif
c
c TOTAL VELOCITY TERM
c
c          fovt =  ffw*qt - qw_in
c    &               + vtotx*ffwx + vtoty*ffwy
c          fovt =  ffw*(vtotxx+vtotyy - qw_in )
c    &               + vtotx*ffwx + vtoty*ffwy 
c
c GRAVITY TERM
c
c          fogt =  ffw*(gtotxx+gtotyy)
c    &            + gtotx*ffwx + gtoty*ffwy 
c       cgw =  grav*( 
c    &         dcos(thgx)*( f_rnx*(dw-rn_r) + f_rn*dwx )
c    &      +  dcos(thgy)*( f_rny*(dw-rn_r) + f_rn*dwy ) 
c    &      +  dcos(thgx)*( f_rgx*(dw-dg)   + f_rg*(dwx-dgx) )
c    &      +  dcos(thgy)*( f_rgy*(dw-dg)   + f_rg*(dwy-dgy) ) )
c
c       cgw =  grav*( 
c    &         dcos(thgx)*
c    &   (rpo*(dw-rn_r)*ffwx + ffw*(rpox*(dw-rn_r) + rpo*dwx ))
c    &      +  dcos(thgy)*
c    &   (rpo*(dw-rn_r)*ffwy + ffw*(rpoy*(dw-rn_r) + rpo*dwy ))
c    &      +  dcos(thgx)*
c    &   (rpv*(dw-dg)*ffwx + ffw*(rpvx*(dw-dg) + rpv*(dwx-dgx)))
c    &      +  dcos(thgy)*
c    &   (rpv*(dw-dg)*ffwy + ffw*(rpvy*(dw-dg) + rpv*(dwy-dgy))))
c
c
c==================================================================
c        evaluate the entries in the system matrix
c        there are 16 degrees of freedom per element
c        before bc's reduced out
c
c for this collocation point
c loop through all the nodes in this element
c
         do 23 i = 1, 4
c
                 ino    = npt_gs(inod(i) )
c
c loop through the degrees of freedom at each node
c
          do 24 idf = 1, 4
c
         if(idf.eq.2) then
c        x-derivative
                      x1  = dsx
                      if(dabs(sw11(ino,2)).lt.1.d-10)  then
                         pcnw =  0.d0
                      else
                         pcnw =  dpcnw (ino) * sw11(ino,2)
                      endif
                      if(dabs(st11(ino,2)).lt.1.d-10)  then
                         pcgn =  0.d0
                      else
                         pcgn =  dpcgn (ino) * st11(ino,2)
                      endif
        else if(idf.eq.3) then
c        y-derivative
                      x1  = dsy
                      if(dabs(sw11(ino,3)).lt.1.d-10)  then
                         pcnw =  0.d0
                      else
                         pcnw =  dpcnw (ino) * sw11(ino,3)
                      endif
                      if(dabs(st11(ino,3)).lt.1.d-10)  then
                         pcgn =  0.d0
                      else
                         pcgn =  dpcgn (ino) * st11(ino,3)
                      endif
         else if(idf.eq.4) then
c        cross-derivative
                      x1  = dsx*dsy
                      if(dabs(sw11(ino,4)).lt.1.d-10)  then
                         pcnw =  0.d0
                      else
                         pcnw =  dpcnw (ino) * sw11(ino,4)
                      endif
                      if(dabs(st11(ino,4)).lt.1.d-10)  then
                         pcgn =  0.d0
                      else
                         pcgn =  dpcgn (ino) * st11(ino,4)
                      endif
         else
c        function
                       x1  = 1.d0
                       pcnw = pcnw1(ino)
                       pcgn = pcgn1(ino)
         endif
c
c picard
c LHS stuff
c
c time/time-like
c
        sw_time =   x1*poro*b3(ii,i,idf)/dt
c
c space
cXXXXXXXXXXXXXXXXXXXXX
c
        sw_n     =      x1*( 
     *                 d_pnw*hnw  * (bxx3(ii,i,idf)/(dsx*dsx) 
     *               +              byy3(ii,i,idf)/(dsy*dsy)  )
     *                     +  ( d_pnw* hnwx + d_pnwx*hnw )
     *                                   *bx3(ii,i,idf)/dsx
     *                     +  ( d_pnw* hnwy + d_pnwy*hnw )
     *                                   *by3(ii,i,idf)/dsy )
c
        sw_g     =  x1*(  
     *           (d_pnw+d_pgn)* hgw * (bxx3(ii,i,idf)/(dsx*dsx) 
     *         +                      byy3(ii,i,idf)/(dsy*dsy) )
     *         + ( (d_pnw+d_pgn)* hgwx + (d_pnwx+d_pgnx)*hgw )
     *                                       *bx3(ii,i,idf)/dsx
     *         + ( (d_pnw+d_pgn)* hgwy + (d_pnwy+d_pgny)*hgw )
     *                                       *by3(ii,i,idf)/dsy )
c
        pc_n   =   x1   *(    hnw * (bxx3(ii,i,idf)/(dsx*dsx)
     *                     +        byy3(ii,i,idf)/(dsy*dsy) )
     *                     +  hnwx*  bx3(ii,i,idf)/dsx
     *                     +  hnwy*  by3(ii,i,idf)/dsy )
c
        pc_g   =   x1   *(    hgw * (bxx3(ii,i,idf)/(dsx*dsx)
     *                     +        byy3(ii,i,idf)/(dsy*dsy) )
     *                     +  hgwx*  bx3(ii,i,idf)/dsx
     *                     +  hgwy*  by3(ii,i,idf)/dsy )
c
        ab_ex   = x1* (cow + cowg*e_henry)/rn_r * b3(ii,i,idf)
        x_owg   =   x1*cowg/rn_r * b3(ii,i,idf)
c
c       abb   = x1*( 
c    *     (pow*decay/rn_r - (1.d0-rw_r/rn_r)*poro*satt*decay/rw_r)
c    &                                        * b3(ii,i,idf)
c    *        + (1.d0-rw_r/rn_r)*((dspxx+dspxyy)*bx3(ii,i,idf)/dsx
c    *        +  (dspxyx+dspyy)*by3(ii,i,idf)/dsy
c    *        + dsp_x*bxx3(ii,i,idf)/(dsx*dsx)
c    *        + 2.d0*dsp_xy*bxy3(ii,i,idf)/(dsx*dsy)
c    *        + dsp_y*byy3(ii,i,idf)/(dsy*dsy))/rw_r)
c
c       abb1  = x1*pow/rn_r/dt * b3(ii,i,idf)
c*********************************************************
c  system matrix- band stored - diag. is on col. (ncd+1)
c  is this df a bc, if not enter in the system matrix ai
c
           if(ibc_s(inod(i),idf) .ne. 0)        then
c
                           nelt = nelt + 1
c
c matrix entry
                           ai(nelt) = sw_time + sw_n + sw_g  
c row (equation number)
                           ia(nelt) =  n_eq(ii)
c column (degree of freedom)
                           ja(nelt) =  ibc_s(inod(i),idf)
c
           endif
c
c            RHS
c           
             ri(n_eq(ii)) = ri(n_eq(ii))   
     &            - sw_time  * (sw11(ino,idf) - swt(ino,idf))
     &            - pc_n   * pcnw
     &            - pc_g   * (pcgn + pcnw)
     &            - ab_ex  * roa_p(ino,idf)
     &            + x_owg  * rog_p(ino,idf)
c    &            - abb    * roa_p(ino,idf)
c    &            - abb1   *(roa_p(ino,idf) - roat(ino,idf))
c
   24     continue
c
   23   continue
c
c       add the gravity, exchange and source parts
c
c            ri(n_eq(ii)) = ri(n_eq(ii)) 
c    &                    - fovt - fogt - ex_owg + ex_ow - dw_var
c            ri(n_eq(ii)) = ri(n_eq(ii)) 
c    &                    - fovt - cgw - ex_owg + ex_ow - dw_var
c
        ri(n_eq(ii)) = ri(n_eq(ii)) 
     &          +  parow*cow/rn_r 
     &          -  (ffw*qt - qw_in + vtotx*ffwx + vtoty*ffwy )
     &      -  grav*( 
     &         dcos(thgx)*( f_rnx*(dw-rn_r) + f_rn*dwx  
     &                    + f_rgx*(dw-dg)   + f_rg*(dwx-dgx) )
     &       + dcos(thgy)*( f_rny*(dw-rn_r) + f_rn*dwy 
     &                    + f_rgy*(dw-dg)   + f_rg*(dwy-dgy) ) )
c
      if ( dabs(ri(n_eq(ii))).gt.1.d-15 ) n_do = 1
c
   20   continue
   10   continue
    5   continue
c
      if ( n_do.eq.1 )  then
c there was forcing so solve the system!
c XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
c STEP 2.
c XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
c
c have Ax = b, now solve for x
c
c      call dslugm(nequ, ri, sol_w, nelt, ia, ja, ai, 0, nsave,
c     $     0, eris, itermx, iter, err, ierr, 0,
c     $     rwork, lenw, iwork, leniw)
      call DSLUCS (nequ, ri, sol_w, nelt, ia, ja, ai, 0,
     +   2, eris, itermx, iter, err, ierr, 6,
     +   rwork, lenw, iwork, leniw)
c
                 if (iscr.eq.1) then
                   write(6,111) iter
  111              format(' Sw  - BiCG (',i3,')')
                 endif
              if (ierr.ne.0) then
                   write(6,*) ' ERROR in    Sw     MATRIX SOLVER '
                   write(6,*) ierr
                    write(4,*) 'ERROR in   Sw     MATRIX SOLVER '
                   write(4,*) time
                     stop
               endif
c
      endif
c
                                return 
                                end
