C     Last change:  JG   28 Sep 2000    1:18 pm
c
c TRANSPORT EQUATION SOLVER 
c
c roa11 - dissolved NAPL in water
c rog11 - volatilized NAPL in gas
c
c given the flow solution, define velocity vectors 
c                          and dispersion tensors
c
c solve the Roa and Rog equations concurrently if both are active
c ntr_ow = 1  then Roa active
c ntr_og = 1  then Rog active
c
c Option to Iterate to convergence by concurrent solution 
c
c Option to use Ismael's DD-CG iterative solver 
c
c---------------------------------------------------------------------
       subroutine tran_sol (iter_oa,iter_og)
c---------------------------------------------------------------------
c
        include 'include.f'
c
c########################################################
c initialize sol
             do 15 j    = 1, nequ
                 sol_w(j) = 0.d0
                 sol_g(j) = 0.d0
   15        continue
c
  203        continue
c
        if ( ntr_ow*ntr_og.gt.0 )  then
c----------------------------------------
c both transport equations active 
c----------------------------------------
c parallel equation solution
c$doacross local(ieq)
        do 1 ieq = 1, 2
c
          if(ieq.eq.1)  then
c           GAS TRANSPORT BALANCE EQUATION
            call  rog_sol (tnorm_g, tinf_g, n_og)
               iter_og = iter_og + 1
              if(istop.eq.2)  return
          else
c           WATER TRANSPORT BALANCE EQUATION
            call  roa_sol (tnorm_w, tinf_w, n_oa)
               iter_oa = iter_oa + 1
              if(istop.eq.2)  return
          endif
c
   1    continue
c FINAL UPDATE
       do 276 j = 1, 4
          do 275 i = 1, nn
c
           roa_p(i,j) = theta* sw_tmp(i,j) + (1.d0 - theta)*roa11(i,j)
           roa11(i,j) =  sw_tmp(i,j)
c
           rog_p(i,j) = theta* sg_tmp(i,j) + (1.d0 - theta)*rog11(i,j)
           rog11(i,j) =  sg_tmp(i,j)
c
  275         continue
  276      continue
c
       else if ( ntr_ow.gt.0 )  then
c----------------------------------------
c only consider transport of NAPL in the water phase
c----------------------------------------
            call  roa_sol ( tnorm_w, tinf_w, n_oa)
               iter_oa = iter_oa + 1
                if(istop.eq.2 )  return
              n_og   = 1
              tinf_g  = 0.d0
              tnorm_g = 0.d0
c FINAL UPDATE
       do 376 j = 1, 4
          do 375 i = 1, nn
c
           roa_p(i,j) = theta* sw_tmp(i,j) + (1.d0 - theta)*roa11(i,j)
           roa11(i,j) =  sw_tmp(i,j)
c
  375         continue
  376      continue
c
       else if ( ntr_og.gt.0 )  then
c----------------------------------------
c only consider transport of NAPL in the gas phase
c----------------------------------------
            call  rog_sol ( tnorm_g, tinf_g, n_og)
               iter_og = iter_og + 1
                if(istop.eq.2 )  return
              n_oa   = 1
              tinf_w  = 0.d0
              tnorm_w = 0.d0
c FINAL UPDATE
       do 476 j = 1, 4
          do 475 i = 1, nn
c
           rog_p(i,j) = theta* sg_tmp(i,j) + (1.d0 - theta)*rog11(i,j)
           rog11(i,j) =  sg_tmp(i,j)
c
  475         continue
  476      continue
        endif
c
c check for convergence on the nonlinearities
                if(tinf_w.gt.1.e-12) then
                 tinf_w = tinf_w/dabs(roa11(n_oa,1))
                endif
                if(tinf_g.gt.1.e-12) then
                 tinf_g = tinf_g/dabs(rog11(n_og,1))
                endif
               if (iscr.eq.1)  then
                if(tinf_w.gt.tinf_g) then
                 roa = roa11(n_oa,1)
                 rog = rog11(n_oa,1)
                 write(6,953)iter_oa,n_oa,roa,rog,tnorm_w,tinf_w
                else
                 roa = roa11(n_og,1)
                 rog = rog11(n_og,1)
                 write(6,953)iter_og,n_og,roa,rog,tnorm_g,tinf_g
                endif
               endif
  953  format(' NL_C',i2,1x,i5,2(f8.4),1x,f8.6,2x,f8.6/)
c
           if (tinf_w .lt.erot .and. tinf_g .lt.erot)  then
c               converged
                          return
c
           else if(iter_oa.gt.ithangc .or. iter_og.gt.ithangc) then
c                   too many iterations for this time step
c                   so reduce time step and restart
                          istop = 2
                          return
c
           else
                           go to 203
           endif
                                                    end
c
c---------------------------------------------------------------------
c---------------------------------------------------------------------
c Solution of the dissolved NAPL in water Transport equation 
c
c---------------------------------------------------------------------
       subroutine  roa_sol ( t_norm, t_inf, n_max)
c
c
c Solution of the Transport equation given flow variables
c use direct or iterative subroutine solution
c
c---------------------------------------------------------------------
        include 'include.f'
c---------------------------------------------------------------------
            t_norm = 0.d0
            t_inf = 0.d0
            n_max = 1
c
cxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
             call sys_oa_i (n_do,iter)
cxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
           if(iter.gt.1.5*ithangc)                       then
c                   too many iterations for this time step
c                   so reduce time step and restart
                          istop = 2
                          return
           endif
c
cxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
c
              do 211 nod = 1, nn
c
               n_g = npt_gs(nod)
c
       if(n_do.eq.1 .and. ibc_oa(nod,1).ne.0)  then
c
c---------------------------------------------------------------------
c      nonlinear iteration convergence norms
             t_norm = t_norm + sol_w(ibc_oa(nod,1))*sol_w(ibc_oa(nod,1))
c
            if ( dabs(sol_w(ibc_oa(nod,1))) .gt. t_inf) then
                     t_inf = dabs(sol_w(ibc_oa(nod,1)))
                     n_max = n_g
             endif
c
                sw_tmp(n_g,1) = roa11(n_g,1) + sol_w(ibc_oa(nod,1))
       else
                sw_tmp(n_g,1) = roa11(n_g,1)
       endif
c---------------------------------------------------------------------
              do 221 idf = 2, 4
c
c
       if(n_do.eq.1 .and. ibc_oa(nod,idf).ne.0)  then
              sw_tmp(n_g,idf) = roa11(n_g,idf) + sol_w(ibc_oa(nod,idf))
       else
              sw_tmp(n_g,idf) = roa11(n_g,idf)
       endif
c
  221         continue
  211      continue
c
c        L2 norm
                 t_norm = dsqrt(t_norm)
                                                    return
                                                    end
c
c---------------------------------------------------------------------
c---------------------------------------------------------------------
c---------------------------------------------------------------------
c Solution of the vapor NAPL in gas Transport equation 
c
c---------------------------------------------------------------------
       subroutine  rog_sol ( t_norm, t_inf, n_max)
c
c
c Solution of the Transport equation given flow variables
c use direct or iterative subroutine solution
c
c---------------------------------------------------------------------
        include 'include.f'
c---------------------------------------------------------------------
c
            t_norm = 0.d0
            t_inf = 0.d0
            n_max = 1
c
c     ITERATIVE SOLUTION
cxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
             call sys_og_i (n_do,iter)
cxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
           if(iter.gt.1.5*ithangc)                       then
c                   too many iterations for this time step
c                   so reduce time step and restart
                          istop = 2
                          return
           endif
c
cxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
           do 211 nod = 1, nn
               n_g = npt_gs(nod)
c
       if(n_do.eq.1 .and. ibc_og(nod,1).ne.0)  then
c
c---------------------------------------------------------------------
c      nonlinear iteration convergence norms
             t_norm = t_norm + sol_g(ibc_og(nod,1))*sol_g(ibc_og(nod,1))
c
            if ( dabs(sol_g(ibc_og(nod,1))) .gt. t_inf) then
                     t_inf = dabs(sol_g(ibc_og(nod,1)))
                     n_max = n_g
             endif
c
                sg_tmp(n_g,1) = rog11(n_g,1) + sol_g(ibc_og(nod,1))
       else
                sg_tmp(n_g,1) = rog11(n_g,1)
       endif
c---------------------------------------------------------------------
              do 221 idf = 2, 4
c
c
       if(n_do.eq.1 .and. ibc_og(nod,idf).ne.0)  then
              sg_tmp(n_g,idf) = rog11(n_g,idf) + sol_g(ibc_og(nod,idf))
       else
              sg_tmp(n_g,idf) = rog11(n_g,idf)
       endif
c
  221         continue
  211      continue
c
c        L2 norm
                 t_norm = dsqrt(t_norm)
                                                    return
                                                    end
