C     Last change:  JG    2 Jan 2003   10:34 am
        subroutine read_rs
c
c READ IN THE RESTART FILES
cc
        include 'include.f'
c
c dependent variables
        open (83,file='og.rs',form='unformatted')
        open (84,file='oa.rs',form='unformatted')
        open (85,file='pa.rs',form='unformatted')
        open (86,file='st.rs',form='unformatted')
        open (87,file='sw.rs',form='unformatted')
        read (83)(rog11(i,1),rog11(i,2),rog11(i,3),rog11(i,4),
     &              i=1,nn)
        read (84)(roa11(i,1),roa11(i,2),roa11(i,3),roa11(i,4),
     &              i=1,nn)
        read (85)(pa11(i,1),pa11(i,2),pa11(i,3),pa11(i,4),
     &              i=1,nn)
        read (86)(st11(i,1),st11(i,2),st11(i,3),st11(i,4),
     &              i=1,nn)
        read (87)(sw11(i,1),sw11(i,2),sw11(i,3),sw11(i,4),
     &              i=1,nn)
        close (83)
        close (84)
        close (85)
        close (86)
        close (87)
c
c hysteresis variables
        open (88,file='sb.rs',form='unformatted')
        open (89,file='sr.rs',form='unformatted')
        open (90,file='ss.rs',form='unformatted')
        open (91,file='a.rs',form='unformatted')
        open (92,file='nhc.rs',form='unformatted')
        read (92)(nhc_t(i),nhc_w(i),i=1,nn)  
        read (88)(sb_t(i,1),sb_t(i,2),sb_t(i,3),sb_t(i,4),
     &              sb_w(i,1),sb_w(i,2),sb_w(i,3),sb_w(i,4),i=1,nn)  
        read (89)(sr_t(i,1),sr_t(i,2),sr_t(i,3),sr_t(i,4),
     &              sr_w(i,1),sr_w(i,2),sr_w(i,3),sr_w(i,4),i=1,nn)  
        read (90)(ss_t(i,1),ss_t(i,2),ss_t(i,3),ss_t(i,4),
     &              ss_w(i,1),ss_w(i,2),ss_w(i,3),ss_w(i,4),i=1,nn)  
        read (91)( a_t(i,1), a_t(i,2), a_t(i,3), a_t(i,4),
     &               a_w(i,1), a_w(i,2), a_w(i,3),  a_w(i,4), i=1,nn)  
        close (88)
        close (89) 
        close (90) 
        close (91) 
        close (92) 
c
c trapping variables
c
        open (93,file='s_max.rs',form='unformatted')
        open (94,file='trap_c.rs',form='unformatted')
        open (95,file='trap_mx.rs',form='unformatted')
        open (96,file='trap_mn.rs',form='unformatted')
        read (93)( sw_mx(i), sg_mx(i), sn_mx(i), 
     &               i=1,nn)  
        read (94)( swt_c(i), sgt_c(i), snt_c(i),
     &               i=1,nn)  
        read (95)( swt_mx(i), sgt_mx(i), snt_mx(i),
     &               i=1,nn)  
        read (96)( swt_mn(i), sgt_mn(i), snt_mn(i),
     &               i=1,nn)  
        close (93) 
        close (94) 
        close (95) 
        close (96) 
c
           if (nhyst.eq.1)  then
                    do 10 k = 1,4 
                      do 101 j = 1,nn
                        swt(j,k) = sw11(j,k)
                        stt(j,k) = st11(j,k)
  101                 continue
   10               continue
           else
            do 102 j = 1,nn
               nhc_t(j) = 1
               nhc_w(j) = 1
               sr_t(j,1) = swr(j)
               ss_t(j,1) = 1.d0
               sr_w(j,1) = swr(j)
               ss_w(j,1) = 1.d0
  102       continue
           endif
                             return
                             end
c
c--------------------------------------------------------------------
c--------------------------------------------------------------------
        subroutine write_rs
c--------------------------------------------------------------------
c
c WRITE OUT THE RESTART FILES
cc
        include 'include.f'
c
c dependent variables
        open (83,file='og.rs',form='unformatted')
        open (84,file='oa.rs',form='unformatted')
        open (85,file='pa.rs',form='unformatted')
        open (86,file='st.rs',form='unformatted')
        open (87,file='sw.rs',form='unformatted')
        write (85)(pa11(i,1),pa11(i,2),pa11(i,3),pa11(i,4),
     &              i=1,nn)
        write (86)(st11(i,1),st11(i,2),st11(i,3),st11(i,4),
     &              i=1,nn)
        write (87)(sw11(i,1),sw11(i,2),sw11(i,3),sw11(i,4),
     &              i=1,nn)
        write (83)(rog11(i,1),rog11(i,2),rog11(i,3),rog11(i,4),
     &              i=1,nn)
        write (84)(roa11(i,1),roa11(i,2),roa11(i,3),roa11(i,4),
     &              i=1,nn)
        close (83)
        close (84)
        close (85)
        close (86)
        close (87)
c
c hysteresis variables
        open (88,file='sb.rs',form='unformatted')
        open (89,file='sr.rs',form='unformatted')
        open (90,file='ss.rs',form='unformatted')
        open (91,file='a.rs',form='unformatted')
        open (92,file='nhc.rs',form='unformatted')
        write (92)(nhc_t(i),nhc_w(i),i=1,nn)  
        write (88)(sb_t(i,1),sb_t(i,2),sb_t(i,3),sb_t(i,4),
     &              sb_w(i,1),sb_w(i,2),sb_w(i,3),sb_w(i,4),i=1,nn)  
        write (89)(sr_t(i,1),sr_t(i,2),sr_t(i,3),sr_t(i,4),
     &              sr_w(i,1),sr_w(i,2),sr_w(i,3),sr_w(i,4),i=1,nn)  
        write (90)(ss_t(i,1),ss_t(i,2),ss_t(i,3),ss_t(i,4),
     &              ss_w(i,1),ss_w(i,2),ss_w(i,3),ss_w(i,4),i=1,nn)  
        write (91)( a_t(i,1), a_t(i,2), a_t(i,3), a_t(i,4),
     &               a_w(i,1), a_w(i,2), a_w(i,3),  a_w(i,4), i=1,nn)  
        close (88)
        close (89) 
        close (90) 
        close (91) 
        close (92) 
c
c trapping variables
c
        open (93,file='s_max.rs',form='unformatted')
        open (94,file='trap_c.rs',form='unformatted')
        open (95,file='trap_mx.rs',form='unformatted')
        open (96,file='trap_mn.rs',form='unformatted')
        write (93)( sw_mx(i), sg_mx(i), sn_mx(i),
     &               i=1,nn)  
        write (94)( swt_c(i), sgt_c(i), snt_c(i), 
     &               i=1,nn)  
        write (95)( swt_mx(i), sgt_mx(i), snt_mx(i),
     &               i=1,nn)  
        write (96)( swt_mn(i), sgt_mn(i), snt_mn(i), 
     &               i=1,nn)  
        close (93) 
        close (94) 
        close (95) 
        close (96) 
c
                             return
                             end
c
c--------------------------------------------------------------------
c--------------------------------------------------------------------
         subroutine print 
     &             (dtt,chcwa,chcon,chcgg,chcoa,chcog,twsm,tosm,
     *               tgsm,cvwa,cvon,cvgg,cvoa,cvog,chbcw,chbco,chbcg,
     &               pctw,pcto,pctg,inctot,itf,itw,itg,itt,iherm,iprnt)
c--------------------------------------------------------------------
c--------------------------------------------------------------------
c
c-------------   print output files   -------------------------------
c
        include 'include.f'
c     integer iflag,nopen
c     character charnm*2,outfl*12
c
                  dtavg = time/float(inctot)
c
        if (mass.eq.1) then
       write(14,*)time, '********** TIME **** '
       write(14,*)'total number of iterations is: Pw, Sw, Sg, Conc. '
       write(14,*)itf, itw,itg,itt
       write(14,950)ihang
       write(14,*)dtt, dtavg, 'dtmax , dtavg   '
  950  format(5x,'hangups = ',i5)
c
c--------------------------------------------------------------------
c mass balance output
c the percent diff. between the actual and calc. mass in
          write(14,946)chcwa,chcon,chcgg,chcoa,chcog,twsm,tosm,tgsm
  946       format(/,'CHANGE (current - initial):'/
     *             'water in water species:             ',15x,0pe15.8/
     *             'oil in oil species:                 ',15x,0pe15.8/
     *             'gas in gas species:                 ',15x,0pe15.8/
     *             'oil in water species:               ',15x,0pe15.8/
     *             'oil in gas species:                 ',15x,0pe15.8/
     *             '        WATER species mass is:      ',15x,0pe15.8/
     *             '        NAPL species mass is:       ',15x,0pe15.8/
     *             '        GAS species mass is:        ',15x,0pe15.8/)
c
          write(14,947)cvwa, cvon,cvgg,cvoa,cvog,chbcw,chbco,chbcg,
     *                 pctw,pcto,pctg
  947       format('BOUUNDARY (in - out):'/
     *             'water in water species:             ',15x,0pe15.8/
     *             'oil in oil species:                 ',15x,0pe15.8/
     *             'gas in gas species:                 ',15x,0pe15.8/
     *             'oil in water species:               ',15x,0pe15.8/
     *             'oil in gas species:                 ',15x,0pe15.8/
     *             '        WATER species mass is:      ',15x,0pe15.8/
     *             '        NAPL species mass is:       ',15x,0pe15.8/
     *             '        GAS species mass is:        ',15x,0pe15.8/
     *             'PERCENT DIFFERENCE:'/
     *             '        WATER                :      ',15x,f15.4/  
     *             '        NAPL                 :      ',15x,f15.4,/
     *             '        GAS                  :      ',15x,f15.4,/)
        endif
c--------------------------------------------------------------------
c HERMITE output
      if (iherm.eq.1) then
        write(2,920)time,dt
        write(3,920)time,dt
        write(4,920)time,dt
        write(7,920)time,dt
        write(8,920)time,dt
      endif
c
  920   format(3x,0pf12.3,3x,'#',0pf12.3, 'elapsed time, time step'/
     &        1x,'# node',2x,'function',
     $ 2x,'x-gradient',2x,'y-gradient',2x,'twist and shout')
c
c====================================================================
c====================================================================
c  function list output including the following:
c             saturation
c             oil in water
c             water in oil
c             solvent in both phases
c             velocity (both phases)
c====================================================================
c
          write(22,*) time, dtt, '  time,dtmax   '
      write(22,*)
     &'# node        Sw          Sn          Sg         Pcnw        Pcgn
     &       o/w          o/g'
c
          write(23,244)time
          write(24,244)time
          write(25,244)time
  244     format(1x,'time         ',f15.8,/
     &               'node        velx          vely         magnitude')
c
                    vmw  = 0.d0
                    vmn  = 0.d0
                    vmg  = 0.d0
c################################################
       if (iherm.eq.1) then
c
        if (ntr_og.eq.1) then
          do 401 i=1,nn
c          write to og.out
             write(8,935) i,rog11(i,1),rog11(i,2),rog11(i,3),rog11(i,4)
  401     continue
        endif
c
        if (ntr_ow.eq.1) then
          do 402 i=1,nn
c          write to oa.out
             write(7,935) i,roa11(i,1),roa11(i,2),roa11(i,3),roa11(i,4)
  402     continue
        endif
c
          do 403 i=1,nn
c          write to pa.out
             write(4,935) i, pa11(i,1), pa11(i,2), pa11(i,3), pa11(i,4)
  403     continue
c
          do 404 i=1,nn
c          write to st.out
             write(3,935) i, st11(i,1), st11(i,2), st11(i,3), st11(i,4)
  404     continue
c
          do 405 i=1,nn
c          write to sw.out
             write(2,935) i, sw11(i,1), sw11(i,2), sw11(i,3), sw11(i,4)
  405     continue
c
       endif
c################################################
c set up output files for MESHMAKER
c         iprnt = iprnt + 1
c        call INum2Txt(iprnt, 1 ,'(i2)', charnm, iflag)
c        call cparse(charnm,2,nopen)
c        outfl='file'//charnm(nopen:2)//'.'//'out'
c        write(*,*) outfl
c
c        open(13,file=outfl,status='UNKNOWN')
c        write(13,*) 7
c
          do 406 i=1,nn
c           write to sat.out
           snn = st11(i,1) - sw11(i,1)
           sgg = 1.d0 - st11(i,1) 
              write(22,990)i,sw11(i,1),snn,sgg,pcnw1(i),pcgn1(i),
c    &                   roa11(i,1),rog11(i,1),maddw(i),maddg(i)
     &                   roa11(i,1),rog11(i,1)
c             write(13,990) i,sw11(i,1),snn,sgg,pcnw1(i),pcgn1(i),
c    &                   roa11(i,1),rog11(i,1)
  406     continue
c
c        close(13)
  935  format(i5,1x,1pe10.3,1x,1pe10.3,1x,1pe10.3,1x,1pe10.3)
  990  format(1x,i5, 2x,3(f12.6), 2x,2(f12.4),2(0pf14.9))
c
c VELOCITY OUTPUT
c set up output files for MESHMAKER
c        call INum2Txt(iprnt, 1 ,'(i2)', charnm, iflag)
c        call cparse(charnm,2,nopen)
c        outfl='vel'//charnm(nopen:2)//'.'//'out'
c        write(*,*) outfl
c
c        open(13,file=outfl,status='UNKNOWN')
c        write(13,*) 6
c
c transform boundary flux terms into velocity for output
         call vel_set
c
          do 407 i=1,nn
c
                vmagw= dsqrt(vwx(i)**2+vwy(i)**2)
                if (vmagw.gt.vmw) vmw = vmagw
c
                vmagg= dsqrt(vgx(i)**2+vgy(i)**2)
                if (vmagg.gt.vmg) vmg = vmagg
c
                vmagt= dsqrt(vtx(i)**2+vty(i)**2)
                if (vmagt.gt.vmt) vmt = vmagt
c
c          call vel_n (i,vnx,vny)
                   vny = vty(i) - vwy(i) - vgy(i)
                   vnx = vtx(i) - vwx(i) - vgx(i)
                vmagn= dsqrt(vnx**2+vny**2)
                if (vmagn.gt.vmn) vmn = vmagn
c
c       write to velw.out
         write(23,991)i,vwx(i),vwy(i),vmagw
c
c       write to veln.out
         write(24,991)i,vnx,vny,vmagn
c
c       write to velg.out
         write(25,991)i,vgx(i),vgy(i),vmagg
c
c       write to velt.out
         write(26,991)i,vtx(i),vty(i),vmagt
c
c             write(13,992) i,vwx(i),vwy(i),vnx,vny,vgx(i),
c    &                   vgy(i)
  407    continue
c        close(13)
  991    format(1x,i5,2x,3(0pf15.9))
  992  format(1x,i5, 2x,6(f12.6))
c
       write(23,245)vmw
       write(24,245)vmn
       write(25,245)vmg
       write(26,245)vmt
  245     format(1x,'maximum velocity:    ',f15.8)
c
         if(iscr.eq.1) then
                t = time/86400.d0
            write(6,*)  t
         endif
c
                            return
                            end
c
c====================================================================
c
c====================================================================
         subroutine graph
c GMS V2.1
c
c
        include 'include.f'
c
c  function list output including the following:
c             saturation
c             oil in water
c             velocity (both phases)
c====================================================================
c
       IF(iout.eq.0) then
c ASCII output
         write(51,989)  time
         write(52,989)  time
         write(55,989)  time
         write(56,989)  time
         write(57,989)  time
         write(58,989)  time
       if(ntr_ow.eq.1) then
         write(53,989) time
       endif
       if(ntr_og.eq.1) then
         write(54,989)  time
       endif
c
       else
c BINARY output
         its = 200
         i_stat = 0
         write(51)its, i_stat, time
         write(52)its, i_stat, time
         write(55)its, i_stat, time
         write(56)its, i_stat, time
         write(57)its, i_stat, time
       if(ntr_ow.eq.1) then
         write(53)its, i_stat, time
       endif
       if(ntr_og.eq.1) then
         write(54)its, i_stat, time
       endif
c
       endif
c
c transform boundary flux terms into velocity for output
         call vel_set
        vwz = 0.d0
        vgz = 0.d0
        vnz = 0.d0
c
c output in y-x ordering
             nodd = 0
        do  i = 0, nnx-1
          do j = 1, nny
c
             nodd = nodd+1
             sn = st11(nodd,1) - sw11(nodd,1)
c head out
                   IF(ntr_ow.eq.1)then
                    call water_prop (roa11(nodd,1),wa,dww,visw)
                   else
                    call water_prop (0.d0,wa,dww,visw)
                   endif
                   hd_w   = (pa11(nodd,1) - pg_ref) / (grav*dww)
c
c SATURATION
            IF(iout.eq.0) then
               write(51,900) sw11(nodd,1)
               write(52,900) sn
               write(58,906) hd_w
            else
               WRITE(51)sw11(nodd,1)
               write(52) sn
            ENDIF
c
c CONCENTRATION
       if(ntr_ow.eq.1) then
                 if(dabs(roa11(nodd,1)).lt.1.0d-08) then
                   r = 0.d0
                 else
                   r = roa11(nodd,1)
                 endif
            IF(iout.eq.0) then
              write(53,901) r
            else
              write(53) r
            ENDIF
       endif
       if(ntr_og.eq.1) then
                 if(dabs(rog11(nodd,1)).lt.1.0d-08) then
                   r = 0.d0
                 else
                   r = rog11(nodd,1)
                 endif
            IF(iout.eq.0) then
              write(54,901) r
            else
              write(54) r
            ENDIF
       endif
c
c VELOCITY
             vnx = vtx(nodd) - vwx(nodd) - vgx(nodd)
              if(dabs(vnx).lt.epsil)  vnx = 0.d0
             vny = vty(nodd) - vwy(nodd) - vgy(nodd)
              if(dabs(vny).lt.epsil)  vny = 0.d0
c
            IF(iout.eq.0) then
           write(55,992)vwx(nodd), vwy(nodd), vwz
           write(56,992)vnx      , vny      , vnz
           write(57,992)vgx(nodd), vgy(nodd), vgz
            else
           write(55)vwx(nodd), vwy(nodd), vwz
           write(56)vnx      , vny      , vnz
           write(57)vgx(nodd), vgy(nodd), vgz
            ENDIF
c
          END do
        END do
c
  900 format(f7.4)
  906 format(f10.4)
  901 format(e10.4)
  992 format(1x,e10.4,1x,e10.4,1x,e10.4)
  989  FORMAT('TS     0      ',f12.3 )
c
                                                          return
                                                          end
c
c--------------------------------------------------------------------
c--------------------------------------------------------------------
         subroutine gms_set
c--------------------------------------------------------------------
c--------------------------------------------------------------------
c
c  setup for GMS V 2.1 graphics output
c
        include 'include.f'
        CHARACTER*12 namee
c
c  function list output including the following:
c             saturation
c             oil in water
c             velocity (both phases)
c====================================================================
c DEFINE WHETHER PARAMETER OUTPUT IS ASCII (iout = 0)
c                                 OR BINARY (iout > 0)
            iout = 0
           ne = nex*ney
c
      IF(iout.eq.0) then
c GMS ASCII (pg 41 Formats Manual)
        open (51,file='sw.dat')
        iid = 1
        namee = 'Water_Sat'
        write(51,980) iid, nn, ne, namee
c
        open (52,file='sn.dat')
        iid = 2
        namee = 'NAPL_Sat'
        write(52,980) iid, nn, ne, namee
c
        open (58,file='hw.dat')
        iid = 8
        namee = 'Hw'
        write(58,980) iid, nn, ne, namee
c
       if(ntr_ow.eq.1) then
          open (53,file='oa.dat')
          iid = 6
          namee = 'Conc_nW'
          write(53,980) iid, nn, ne, namee
       endif
       if(ntr_og.eq.1) then
        open (54,file='og.dat')
          iid = 7
          namee = 'Conc_nG'
          write(54,980) iid, nn, ne, namee
       endif
c ASCII SCALAR DATA FILE FORMAT
  980  FORMAT('DATASET'/'OBJTYPE  grid2d'/'BEGSCL'/
     &        'OBJID  ',i5/'ND',5x, i8/'NC',5x, i8/
     &       'NAME  ',a12)
c
        open (55,file='velw.dat')
        iid = 3
        namee = 'Water_vel'
        write(55,981) iid, nn, ne, namee
c
        open (56,file='veln.dat')
        iid = 4
        namee = 'NAPL_vel'
        write(56,981) iid, nn, ne, namee
c
        open (57,file='velg.dat')
        iid = 5
        namee = 'Gas_vel'
        write(57,981) iid, nn, ne, namee
c
  981  FORMAT('DATASET'/'OBJTYPE  grid2d'/'BEGVEC'/
     &        'OBJID  ',i5/'ND',5x, i8/'NC',5x, i8/
     &       'NAME  ',a12)
c
      else
c GMS BINARY (pg 46 Formats Manual)
          iver = 3000
          ityp1 = 100
          ityp2 = 7
          isfl1 = 110
          isfl2 = 16
          isflg1 = 120
          isflg2 = 4
          ibsc = 130
          ibvc = 140
          ioid = 160
          ndat = 170
          ncell = 180
          iname = 190
c
        open (51,file='sw.dat',form='unformatted')
          namee = 'Water_Sat\0'
          id = 1
         write(51) iver
         write(51) ityp1,ityp2
         write(51) isfl1,isfl2
         write(51) isflg1, isflg2
         write(51) ibsc
         write(51) ioid, id
         write(51) ndat,nn
         write(51) ncell,ne
         write(51) iname,namee
c
        open (52,file='sn.dat',form='unformatted')
          namee = 'NAPL_Sat\0'
          id = 2
         write(52) iver
         write(52) ityp1,ityp2
         write(52) isfl1,isfl2
         write(52) isflg1, isflg2
         write(52) ibsc
         write(52) ioid, id
         write(52) ndat,nn
         write(52) ncell,ne
         write(52) iname,namee
c
        open (55,file='velw.dat',form='unformatted')
          namee = 'Water_vel\0'
          id = 3
         write(55) iver
         write(55) ityp1,ityp2
         write(55) isfl1,isfl2
         write(55) isflg1, isflg2
         write(55) ibvc
         write(55) ioid, id
         write(55) ndat,nn
         write(55) ncell,ne
         write(55) iname,namee
c
        open (56,file='veln.dat',form='unformatted')
          namee = 'NAPL_vel\0'
          id = 4
         write(56) iver
         write(56) ityp1,ityp2
         write(56) isfl1,isfl2
         write(56) isflg1, isflg2
         write(56) ibvc
         write(56) ioid, id
         write(56) ndat,nn
         write(56) ncell,ne
         write(56) iname,namee
c
        open (57,file='velg.dat',form='unformatted')
          namee = 'Gas_vel\0'
          id = 5
         write(57) iver
         write(57) ityp1,ityp2
         write(57) isfl1,isfl2
         write(57) isflg1, isflg2
         write(57) ibvc
         write(57) ioid, id
         write(57) ndat,nn
         write(57) ncell,ne
         write(57) iname,namee
c
       if(ntr_ow.eq.1) then
        open (53,file='oa.dat',form='unformatted')
          namee = 'Conc_nW\0'
          id = 6
         write(53) iver
         write(53) ityp1,ityp2
         write(53) isfl1,isfl2
         write(53) isflg1, isflg2
         write(53) ibsc
         write(53) ioid, id
         write(53) ndat,nn
         write(53) ncell,ne
         write(53) iname,namee
       endif
       if(ntr_og.eq.1) then
        open (54,file='og.dat',form='unformatted')
          namee = 'Conc_nG\0'
          id = 7
         write(54) iver
         write(54) ityp1,ityp2
         write(54) isfl1,isfl2
         write(54) isflg1, isflg2
         write(54) ibsc
         write(54) ioid, id
         write(54) ndat,nn
         write(54) ncell,ne
         write(54) iname,namee
       endif
      endif
c
c SET UP THE 2D GRID FILE
        open (72,file='grid.2dg')
c
         write(72,333) nnx, nny
                    do j=1,nnx
                      write(72,*) x(j)
                    END do
                    do j=1,nny
                      write(72,*) y(j)
                    END do
      close(72)
  333 FORMAT('GRID2D'/'TYPE  0'/'IJ   +x  +y'/
     &        'ORIGIN  0 0 0'/'ROTZ  0'/'DIM ', 2(i5))
c
c Write out the soil properties now: files 'perm.dat' and 'poros.dat'
c GMS orders nodes in order: y - z - x (layer, row, column)
c the vectors are stored internally as: y - x - z
c therefore, map from internal numbering to GMS numbering
c%%%%%%%%%%%% PERMEABILITY %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
c
        open (72,file='perm.dat')
c
           iid = 8
           namee = 'Permeability'
         write(72,334) iid,nn,ne,namee
c
c output in z-y-x ordering
        nodd = 0
        do  i = 0, nnx-1
          do j = 1, nny
c
             nodd = nodd+1
c
             write(72,336) perm(nodd)
c
          END do
        END do
c
        write(72,335)
        close(72)
c%%%%%%%%%%%% POROSITY %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        open (72,file='poros.dat')
c
           iid = 9
           namee = 'Porosity'
         write(72,334) iid,nn,ne,namee
c
c output in z-y-x ordering
        nodd = 0
        do  i = 0, nnx-1
          do j = 1, nny
c
             nodd = nodd+1
c
             write(72,*) por(nodd)
c
          END do
        END do
c
       write(72,335)
        close(72)
c%%%%%%%%%%%% POROSITY %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  334  FORMAT('DATASET'/'OBJTYPE  grid2d'/'BEGSCL'/
     &        'OBJID  ',i5/'ND',5x, i8/'NC',5x, i8/
     &       'NAME  ',a12/'TS     0      0' )
  335  FORMAT('ENDDS')
  336  FORMAT(1pe10.4)
                                                          return
                                                          end
c
c====================================================================
c--------------------------------------------------------------------
c--------------------------------------------------------------------
         subroutine echo (xmax,ymax,nd,nc,n,area,pv1,g,thg,title,
     &                       siggw, signw, siggn)
c--------------------------------------------------------------------
c-------------   print echo.out file   -------------------------------
c-------------------------------------------------------------------
        include 'include.f'
c
       dimension title(17)
c
      write(28,6) (title(i),i=1,17)
    6 format(1h1,2x,68(1h*)/3x,17a4/3x,68(1h*)/)
      write(28,954) xmax,ymax,nex,ney,nd,nc,n
  954 format('SPACE DIMENSIONS'/
     & 10x,'xmax and ymax (cm)',17x,2(f10.2)/
     & 10x,'number of elements in x-direction',2x,i5/10x,
     $ 'number of elements in y-direction',2x,i5/10x,
     $   'number of degrees of freedom',7x,i5/
     $ 10x,'number of boundary conditions',6x,i5/10x,
     $ 'number of unknowns',17x,i5)
c
      write(28,955) dt,tsmx,tmax,co,dslim,
     &             itincs,itincc,tmult,itreds,itredc,tdiv,
     &             ithangs,ithangc,tdivh,itermx
  955 format('TIME STEP CONTROL'/
     $ 10x,'initial delta t',20x,f6.4/10x,
     $'maximum delta t    ',14x,f15.8/10x,
     $'max simulation time',4x,f21.3/ 5x,
     $'Courant number',11x,f21.3/ 5x,
     $'max change in saturation',1x,f20.3// 5x,
     &'For Sw, Conc.:'/7x, 
     $'iterations to increase dt (multiplier)',6x,2i4,'(',f6.3,')'/7x, 
     $'iterations to decrease dt (multiplier)',6x,2i4,'(',f6.3,')'/7x, 
     $'iterations to restart time step (multiplier)',
     & 2i4,'(',f6.3,')'/5x,
     &'For Pw:'/7x, 'iterations to restart time step', 15x,i4)
c
      write(28,957)erip,eris,eros,erit,erot
  957 format(/5x,'Error Tolerance:'/
     &10x,'on pressure',20x,f10.7/10x,
     &'on saturation (GMRES, NL)',8x,2(f8.5)/10x,
     &'on concentration (GMRES, NL)',15x,2(f8.5)//)
c     parameters
      write(28,956) area,por(1),pv1,g,thg,
     &        vw_r,vn_r,vg_r,rw_r,rn_r,rg_r
  956 format(/5x,'PARAMETERS'/
     $10x,'area of simulation',10x,f15.4/10x,'porosity',22x,f10.4/
     $10x,'pore volume of the system ',2x,f15.4//
     $10x,'gravity',24x,f15.10/
     $10x,'angle grid rotate (ccw)',4x,f15.6 /
     $10x,'viscosity water  ',12x,f15.10/
     $10x,'viscosity NAPL ',14x,f15.10/
     $10x,'viscosity gas  ',14x,f15.10/
     $10x,'density water  ',14x,f15.10/
     $10x,'density NAPL ',16x,f15.10/
     $10x,'density gas  ',16x,f15.10//10x)
c
      write(28,959) siggw, signw, siggn,
     &              ntr_ow, ntr_og,
     &              parow,parog,e_henry,p_ow(1),
     &              perm(1),along,atran,diffw,diffg
  959 format(
     $10x,'G-W IFT       ',16x,f15.10/
     $10x,'N-W IFT       ',16x,f15.10/
     $10x,'G-N IFT       ',16x,f15.10//
     $10x,'mass exchange ow and og ? (on = 1, off = 0 )',2i5/
     $10x,'exchange coeff. oil in water',13x,f15.10/
     $10x,'exchange coeff. oil in gas',15x,f15.10/
     $10x,'Henery coeff. (for oil in water in gas)',2x,f15.10/
     $10x,'adsorption partition coeff.        ',6x,f15.10/
     $10x,'saturated perm  (cm^2)',4x,1pe15.8/
     $10x,'longitudinal dispers.',4x,f15.10/
     $10x,'transverse dispers.',6x,f15.10/
     $10x,'diffusion water ',9x,f15.10/
     $10x,'diffusion gas ',11x,f15.10 )
c
      write(28,958)nhyst,swr(1),snnr(1),snwr(1),sgr(1),
     &             asd(1),asi(1),b_a,shape(1),e_r,alfw,alfn,alfg,
     &             se_sl,se_rl,sfact_kr,sp_min,factd,facti, pe_w,pe_g
  958 format(/,5x,'k-S-P curve definition:',/,
     &10x,'hysteresis on (1=yes):',4x,i5,//
     &10x,'Swr',21x,f6.3,/
     &10x,'Snrw (n=w system)',7x,f6.3,/
     &10x,'Snrg (n=g system)',7x,f6.3,/
     &10x,'Sng',21x,f6.3,//
     &10x,'curve shape parameter (1/cm), a (drainage)',3x,f6.3,/
     &10x,'curve shape parameter, a (imbibition)', 8x,f6.3,/
     &10x,'power law for a after reversal',15x,f6.3,//
     &10x,'curve shape parameter, n',21x,f6.3,//
     &10x,'entrapment / release power',19x,f6.3,/
     &10x,'connectivity term for Krw',20x,f6.3,/
     &10x,'connectivity term for Kro',20x,f6.3,/
     &10x,'connectivity term for Krg',20x,f6.3,//
     &10x,'factor to linearize ends of S-P curve (s,r)',2x,2(f6.3),/
     &10x,'factor to zero k-S curves',20x,f6.3,/
     &10x,'min span of scanning curves',18x,f6.3,/
     &10x,'reversal tolerance, drainage',18x,f8.6,/
     &10x,'reversal tolerance, imbibition',16x,f8.6,//
     &10x,'peclet number (W, G)          ',13x,2(f6.2),/)
c
         close(28)
c
                             return
                             end
c
c     SUBROUTINE INum2Txt(inum,icol,fmat,txt,iflg)
C
C     <INum2Txt> converts an integer number into
C     a string of equivalent characters and stores them
C     in the character variable Txt beginning at column,
C     icol.  The number is formated according to the
C     the standard FORTRAN specifier passed in fmat.
C     iflg is returned as a status flag indicating the success
C     or failure of the operation.  iflg <=0 if the
C     operation was successful, and > 0 if it failed.
C
C      AUTHOR: Robert D. Stewart
C        DATE: DEC 24, 1992
C
C     CODE DEPENDENCIES:
C      Routine Name                  File
C        N/A
C
c     INTEGER inum
c     INTEGER icol,iflg
c     CHARACTER*(*) txt,fmat
c     WRITE(txt(icol:),fmt=fmat,iostat=iflg) inum
c     RETURN
c     END
c
c***********************************************************************
c
c this program returns the position of the first non-blank character
c (taken from PTC sources, file iotool4d.for (PC version))
c
c    zst      character string to be checked (i)
c    nst      characters in zst (negative for last to first) (i)
c    nstart    return code (o)   0 - all blanks
c            integer - position of first character encountered
c
c***********************************************************************
c       subroutine cparse(zst,nst,nstart)
c***********************************************************************
c         character zst*(*)
c
c eliminate leading blanks
c
c       nstart = 0
c       inst = iabs(nst)
c       if (zst(nstart+1:inst) .eq. ' ')                return
c       ninc = nst/inst
c       nbeg = (1 + ninc + inst*(1 - ninc))/2
c       nend = (1 - ninc + inst*(1 + ninc))/2
c       do 10 it1=nbeg,nend,ninc
c          if (zst(it1:it1) .ne. ' ') then
c             nstart = it1
c                                                       return
c          endif
c10     continue
c                                                       return
c       end
c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
c
           subroutine vel_set
c
c convert Vt into appropriate Q for flow BC's 2, 3, 4
c&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
c DEFINE BC'S FOR THE SATURATION EQUATIONS AFTER Pw SOLUTION
c     For Pg and Pn Dirichlet data set the following:     
c
c Pg:  qg = normal cpt. of Vt * area
c Pn:  qn = normal cpt. of Vt * area
c
        include 'include.f'
c
c y-faces
        k = 0 
c
      do 68 j = 1, 2
       do 69 jj = 1, nny
c
c              index for y-numbering
               ii = k+jj
c
c(2)
        if( ib_y(jj,j) .eq.  2 )    then
c(2)
c Pg condition
c
           if(j.eq.1)  then
                  vgx(ii) = qg(ii) * dx(1)/2.d0
                  vwx(ii) = qw(ii) * dx(1)/2.d0
                  vtx(ii) = (qw(ii)+qg(ii)+qn(ii)) * dx(1)/2.d0
           else
                  vgx(ii) = -qg(ii) * dx(nex)/2.d0
                  vwx(ii) = -qw(ii) * dx(nex)/2.d0
                  vtx(ii) = -(qw(ii)+qg(ii)+qn(ii)) * dx(nex)/2.d0
           endif
c
c(3)
        else if( ib_y(jj,j) .eq.  3 )    then
c(3)
c Pn condition
c
           if(j.eq.1)  then
                  vgx(ii) = qg(ii) * dx(1)/2.d0
                  vwx(ii) = qw(ii) * dx(1)/2.d0
                  vtx(ii) = (qw(ii)+qg(ii)+qn(ii)) * dx(1)/2.d0
           else
                  vgx(ii) = -qg(ii) * dx(nex)/2.d0
                  vwx(ii) = -qw(ii) * dx(nex)/2.d0
                  vtx(ii) = -(qw(ii)+qg(ii)+qn(ii)) * dx(nex)/2.d0
           endif
c
c(4)
        else if( ib_y(jj,j) .eq.  4 ) then 
c(4)
c Pw condition
c
           if(j.eq.1)  then
                  vgx(ii) = qg(ii) * dx(1)/2.d0
                  vwx(ii) = qw(ii) * dx(1)/2.d0
                  vtx(ii) = (qw(ii)+qg(ii)+qn(ii)) * dx(1)/2.d0
           else
                  vgx(ii) = -qg(ii) * dx(nex)/2.d0
                  vwx(ii) = -qw(ii) * dx(nex)/2.d0
                  vtx(ii) = -(qw(ii)+qg(ii)+qn(ii)) * dx(nex)/2.d0
           endif
c
        endif
c
   69   continue
          k = nn - nny
   68 continue
c  
c x-faces
        k = 0 
c
      do 168 j = 1, 2
       do 169 jj = 1, nnx
c
c              index for x-numbering
               ii = k + (jj-1)*nny + 1
c
c(2)
        if( ib_x(jj,j) .eq.  2 )    then
c(2)
c Pg condition
c
           if(j.eq.1)  then
                  vgy(ii) = qg(ii) * dy(1)/2.d0
                  vwy(ii) = qw(ii) * dy(1)/2.d0
                  vty(ii) = (qw(ii)+qg(ii)+qn(ii)) * dy(1)/2.d0
           else
                  vgy(ii) = -qg(ii) * dy(ney)/2.d0
                  vwy(ii) = -qw(ii) * dy(ney)/2.d0
                  vty(ii) = -(qw(ii)+qg(ii)+qn(ii)) * dy(ney)/2.d0
           endif
c
c(3)
        else if( ib_x(jj,j) .eq.  3 )    then
c(3)
c Pn condition
c
           if(j.eq.1)  then
                  vgy(ii) = qg(ii) * dy(1)/2.d0
                  vwy(ii) = qw(ii) * dy(1)/2.d0
                  vty(ii) = (qw(ii)+qg(ii)+qn(ii)) * dy(1)/2.d0
           else
                  vgy(ii) = -qg(ii) * dy(ney)/2.d0
                  vwy(ii) = -qw(ii) * dy(ney)/2.d0
                  vty(ii) = -(qw(ii)+qg(ii)+qn(ii)) * dy(ney)/2.d0
           endif
c
c(4)
        else if( ib_x(jj,j) .eq.  4 )  then
c(4)
c Pw condition
c
           if(j.eq.1)  then
                  vgy(ii) = qg(ii) * dy(1)/2.d0
                  vwy(ii) = qw(ii) * dy(1)/2.d0
                  vty(ii) = (qw(ii)+qg(ii)+qn(ii)) * dy(1)/2.d0
           else
                  vgy(ii) = -qg(ii) * dy(ney)/2.d0
                  vwy(ii) = -qw(ii) * dy(ney)/2.d0
                  vty(ii) = -(qw(ii)+qg(ii)+qn(ii)) * dy(ney)/2.d0
           endif
c
        endif
c
  169   continue
          k = ney
  168 continue
c
                                    return
                                    end
